/*
contributors: ["David Aerne", "Davo Galavotti"]
description: | 
    Color Standards and Color Nomenclature, by Robert Ridgway (1850-1929) was published in Washignton, DC in 1912, it's part of the public domain in the USA. In August 31, 2020 was added to the Gutenberg Project.
    The book full title "Color Standards and Color Nomenclature: With fifty-three colored plates and eleven hundred and fifteen named colors" clearly informs about the magnitud and spectrum of pigments, naming conventions and categories embedded in the book.
    https://codepen.io/meodai/full/abGjoLq
*/

#ifndef RIDGWAY_ABSINTHE_GREEN
#define RIDGWAY_ABSINTHE_GREEN float3(0.651, 0.706, 0.424)
#endif
#ifndef ABSINTHE_GREEN
#define ABSINTHE_GREEN RIDGWAY_ABSINTHE_GREEN
#endif

#ifndef RIDGWAY_ACAJOU_RED
#define RIDGWAY_ACAJOU_RED float3(0.631, 0.322, 0.322)
#endif
#ifndef ACAJOU_RED
#define ACAJOU_RED RIDGWAY_ACAJOU_RED
#endif

#ifndef RIDGWAY_ACETIN_BLUE
#define RIDGWAY_ACETIN_BLUE float3(0.306, 0.365, 0.482)
#endif
#ifndef ACETIN_BLUE
#define ACETIN_BLUE RIDGWAY_ACETIN_BLUE
#endif

#ifndef RIDGWAY_ACKERMANNS_GREEN
#define RIDGWAY_ACKERMANNS_GREEN float3(0.322, 0.522, 0.396)
#endif
#ifndef ACKERMANNS_GREEN
#define ACKERMANNS_GREEN RIDGWAY_ACKERMANNS_GREEN
#endif

#ifndef RIDGWAY_ACONITE_VIOLET
#define RIDGWAY_ACONITE_VIOLET float3(0.545, 0.404, 0.561)
#endif
#ifndef ACONITE_VIOLET
#define ACONITE_VIOLET RIDGWAY_ACONITE_VIOLET
#endif

#ifndef RIDGWAY_AGERATUM_VIOLET
#define RIDGWAY_AGERATUM_VIOLET float3(0.631, 0.533, 0.635)
#endif
#ifndef AGERATUM_VIOLET
#define AGERATUM_VIOLET RIDGWAY_AGERATUM_VIOLET
#endif

#ifndef RIDGWAY_ALICE_BLUE
#define RIDGWAY_ALICE_BLUE float3(0.514, 0.631, 0.698)
#endif
#ifndef ALICE_BLUE
#define ALICE_BLUE RIDGWAY_ALICE_BLUE
#endif

#ifndef RIDGWAY_ALIZARINE_BLUE
#define RIDGWAY_ALIZARINE_BLUE float3(0.259, 0.341, 0.490)
#endif
#ifndef ALIZARINE_BLUE
#define ALIZARINE_BLUE RIDGWAY_ALIZARINE_BLUE
#endif

#ifndef RIDGWAY_ALIZARINE_PINK
#define RIDGWAY_ALIZARINE_PINK float3(0.894, 0.592, 0.624)
#endif
#ifndef ALIZARINE_PINK
#define ALIZARINE_PINK RIDGWAY_ALIZARINE_PINK
#endif

#ifndef RIDGWAY_AMARANTH_PINK
#define RIDGWAY_AMARANTH_PINK float3(0.945, 0.565, 0.808)
#endif
#ifndef AMARANTH_PINK
#define AMARANTH_PINK RIDGWAY_AMARANTH_PINK
#endif

#ifndef RIDGWAY_AMARANTH_PURPLE
#define RIDGWAY_AMARANTH_PURPLE float3(0.655, 0.188, 0.345)
#endif
#ifndef AMARANTH_PURPLE
#define AMARANTH_PURPLE RIDGWAY_AMARANTH_PURPLE
#endif

#ifndef RIDGWAY_AMBER_BROWN
#define RIDGWAY_AMBER_BROWN float3(0.596, 0.357, 0.173)
#endif
#ifndef AMBER_BROWN
#define AMBER_BROWN RIDGWAY_AMBER_BROWN
#endif

#ifndef RIDGWAY_AMBER_YELLOW
#define RIDGWAY_AMBER_YELLOW float3(0.957, 0.827, 0.384)
#endif
#ifndef AMBER_YELLOW
#define AMBER_YELLOW RIDGWAY_AMBER_YELLOW
#endif

#ifndef RIDGWAY_AMERICAN_GREEN
#define RIDGWAY_AMERICAN_GREEN float3(0.435, 0.553, 0.447)
#endif
#ifndef AMERICAN_GREEN
#define AMERICAN_GREEN RIDGWAY_AMERICAN_GREEN
#endif

#ifndef RIDGWAY_AMETHYST_VIOLET
#define RIDGWAY_AMETHYST_VIOLET float3(0.510, 0.231, 0.675)
#endif
#ifndef AMETHYST_VIOLET
#define AMETHYST_VIOLET RIDGWAY_AMETHYST_VIOLET
#endif

#ifndef RIDGWAY_AMPARO_BLUE
#define RIDGWAY_AMPARO_BLUE float3(0.447, 0.573, 0.925)
#endif
#ifndef AMPARO_BLUE
#define AMPARO_BLUE RIDGWAY_AMPARO_BLUE
#endif

#ifndef RIDGWAY_AMPARO_PURPLE
#define RIDGWAY_AMPARO_PURPLE float3(0.718, 0.459, 0.792)
#endif
#ifndef AMPARO_PURPLE
#define AMPARO_PURPLE RIDGWAY_AMPARO_PURPLE
#endif

#ifndef RIDGWAY_ANDOVER_GREEN
#define RIDGWAY_ANDOVER_GREEN float3(0.443, 0.475, 0.376)
#endif
#ifndef ANDOVER_GREEN
#define ANDOVER_GREEN RIDGWAY_ANDOVER_GREEN
#endif

#ifndef RIDGWAY_ANILINE_BLACK
#define RIDGWAY_ANILINE_BLACK float3(0.259, 0.251, 0.239)
#endif
#ifndef ANILINE_BLACK
#define ANILINE_BLACK RIDGWAY_ANILINE_BLACK
#endif

#ifndef RIDGWAY_ANILINE_LILAC
#define RIDGWAY_ANILINE_LILAC float3(0.686, 0.690, 0.784)
#endif
#ifndef ANILINE_LILAC
#define ANILINE_LILAC RIDGWAY_ANILINE_LILAC
#endif

#ifndef RIDGWAY_ANILINE_YELLOW
#define RIDGWAY_ANILINE_YELLOW float3(0.835, 0.643, 0.078)
#endif
#ifndef ANILINE_YELLOW
#define ANILINE_YELLOW RIDGWAY_ANILINE_YELLOW
#endif

#ifndef RIDGWAY_ANTHRACENE_GREEN
#define RIDGWAY_ANTHRACENE_GREEN float3(0.161, 0.439, 0.412)
#endif
#ifndef ANTHRACENE_GREEN
#define ANTHRACENE_GREEN RIDGWAY_ANTHRACENE_GREEN
#endif

#ifndef RIDGWAY_ANTHRACENE_PURPLE
#define RIDGWAY_ANTHRACENE_PURPLE float3(0.376, 0.302, 0.318)
#endif
#ifndef ANTHRACENE_PURPLE
#define ANTHRACENE_PURPLE RIDGWAY_ANTHRACENE_PURPLE
#endif

#ifndef RIDGWAY_ANTHRACENE_VIOLET
#define RIDGWAY_ANTHRACENE_VIOLET float3(0.365, 0.286, 0.451)
#endif
#ifndef ANTHRACENE_VIOLET
#define ANTHRACENE_VIOLET RIDGWAY_ANTHRACENE_VIOLET
#endif

#ifndef RIDGWAY_ANTIMONY_YELLOW
#define RIDGWAY_ANTIMONY_YELLOW float3(0.976, 0.722, 0.404)
#endif
#ifndef ANTIMONY_YELLOW
#define ANTIMONY_YELLOW RIDGWAY_ANTIMONY_YELLOW
#endif

#ifndef RIDGWAY_ANTIQUE_BROWN
#define RIDGWAY_ANTIQUE_BROWN float3(0.588, 0.400, 0.165)
#endif
#ifndef ANTIQUE_BROWN
#define ANTIQUE_BROWN RIDGWAY_ANTIQUE_BROWN
#endif

#ifndef RIDGWAY_ANTIQUE_GREEN
#define RIDGWAY_ANTIQUE_GREEN float3(0.247, 0.388, 0.322)
#endif
#ifndef ANTIQUE_GREEN
#define ANTIQUE_GREEN RIDGWAY_ANTIQUE_GREEN
#endif

#ifndef RIDGWAY_ANTWERP_BLUE
#define RIDGWAY_ANTWERP_BLUE float3(0.031, 0.365, 0.576)
#endif
#ifndef ANTWERP_BLUE
#define ANTWERP_BLUE RIDGWAY_ANTWERP_BLUE
#endif

#ifndef RIDGWAY_APPLE_GREEN
#define RIDGWAY_APPLE_GREEN float3(0.690, 0.737, 0.412)
#endif
#ifndef APPLE_GREEN
#define APPLE_GREEN RIDGWAY_APPLE_GREEN
#endif

#ifndef RIDGWAY_APRICOT_BUFF
#define RIDGWAY_APRICOT_BUFF float3(0.914, 0.604, 0.424)
#endif
#ifndef APRICOT_BUFF
#define APRICOT_BUFF RIDGWAY_APRICOT_BUFF
#endif

#ifndef RIDGWAY_APRICOT_ORANGE
#define RIDGWAY_APRICOT_ORANGE float3(0.941, 0.518, 0.333)
#endif
#ifndef APRICOT_ORANGE
#define APRICOT_ORANGE RIDGWAY_APRICOT_ORANGE
#endif

#ifndef RIDGWAY_APRICOT_YELLOW
#define RIDGWAY_APRICOT_YELLOW float3(0.925, 0.745, 0.341)
#endif
#ifndef APRICOT_YELLOW
#define APRICOT_YELLOW RIDGWAY_APRICOT_YELLOW
#endif

#ifndef RIDGWAY_ARGUS_BROWN
#define RIDGWAY_ARGUS_BROWN float3(0.475, 0.325, 0.192)
#endif
#ifndef ARGUS_BROWN
#define ARGUS_BROWN RIDGWAY_ARGUS_BROWN
#endif

#ifndef RIDGWAY_ARGYLE_PURPLE
#define RIDGWAY_ARGYLE_PURPLE float3(0.686, 0.522, 0.616)
#endif
#ifndef ARGYLE_PURPLE
#define ARGYLE_PURPLE RIDGWAY_ARGYLE_PURPLE
#endif

#ifndef RIDGWAY_ARMY_BROWN
#define RIDGWAY_ARMY_BROWN float3(0.588, 0.439, 0.369)
#endif
#ifndef ARMY_BROWN
#define ARMY_BROWN RIDGWAY_ARMY_BROWN
#endif

#ifndef RIDGWAY_ARTEMISIA_GREEN
#define RIDGWAY_ARTEMISIA_GREEN float3(0.467, 0.561, 0.514)
#endif
#ifndef ARTEMISIA_GREEN
#define ARTEMISIA_GREEN RIDGWAY_ARTEMISIA_GREEN
#endif

#ifndef RIDGWAY_ASPHODEL_GREEN
#define RIDGWAY_ASPHODEL_GREEN float3(0.565, 0.631, 0.435)
#endif
#ifndef ASPHODEL_GREEN
#define ASPHODEL_GREEN RIDGWAY_ASPHODEL_GREEN
#endif

#ifndef RIDGWAY_ASTER_PURPLE
#define RIDGWAY_ASTER_PURPLE float3(0.631, 0.224, 0.404)
#endif
#ifndef ASTER_PURPLE
#define ASTER_PURPLE RIDGWAY_ASTER_PURPLE
#endif

#ifndef RIDGWAY_AUBURN
#define RIDGWAY_AUBURN float3(0.502, 0.329, 0.235)
#endif
#ifndef AUBURN
#define AUBURN RIDGWAY_AUBURN
#endif

#ifndef RIDGWAY_AURICULA_PURPLE
#define RIDGWAY_AURICULA_PURPLE float3(0.478, 0.275, 0.376)
#endif
#ifndef AURICULA_PURPLE
#define AURICULA_PURPLE RIDGWAY_AURICULA_PURPLE
#endif

#ifndef RIDGWAY_AVELLANEOUS
#define RIDGWAY_AVELLANEOUS float3(0.761, 0.620, 0.510)
#endif
#ifndef AVELLANEOUS
#define AVELLANEOUS RIDGWAY_AVELLANEOUS
#endif

#ifndef RIDGWAY_AZURITE_BLUE
#define RIDGWAY_AZURITE_BLUE float3(0.263, 0.302, 0.482)
#endif
#ifndef AZURITE_BLUE
#define AZURITE_BLUE RIDGWAY_AZURITE_BLUE
#endif

#ifndef RIDGWAY_BARIUM_YELLOW
#define RIDGWAY_BARIUM_YELLOW float3(0.976, 0.890, 0.549)
#endif
#ifndef BARIUM_YELLOW
#define BARIUM_YELLOW RIDGWAY_BARIUM_YELLOW
#endif

#ifndef RIDGWAY_BARYTA_YELLOW
#define RIDGWAY_BARYTA_YELLOW float3(0.886, 0.812, 0.561)
#endif
#ifndef BARYTA_YELLOW
#define BARYTA_YELLOW RIDGWAY_BARYTA_YELLOW
#endif

#ifndef RIDGWAY_BAY
#define RIDGWAY_BAY float3(0.455, 0.294, 0.224)
#endif
#ifndef BAY
#define BAY RIDGWAY_BAY
#endif

#ifndef RIDGWAY_BEGONIA_ROSE
#define RIDGWAY_BEGONIA_ROSE float3(0.969, 0.392, 0.439)
#endif
#ifndef BEGONIA_ROSE
#define BEGONIA_ROSE RIDGWAY_BEGONIA_ROSE
#endif

#ifndef RIDGWAY_BENZO_BROWN
#define RIDGWAY_BENZO_BROWN float3(0.506, 0.443, 0.392)
#endif
#ifndef BENZO_BROWN
#define BENZO_BROWN RIDGWAY_BENZO_BROWN
#endif

#ifndef RIDGWAY_BENZOL_GREEN
#define RIDGWAY_BENZOL_GREEN float3(0.004, 0.580, 0.647)
#endif
#ifndef BENZOL_GREEN
#define BENZOL_GREEN RIDGWAY_BENZOL_GREEN
#endif

#ifndef RIDGWAY_BERLIN_BLUE
#define RIDGWAY_BERLIN_BLUE float3(0.157, 0.337, 0.459)
#endif
#ifndef BERLIN_BLUE
#define BERLIN_BLUE RIDGWAY_BERLIN_BLUE
#endif

#ifndef RIDGWAY_BERYL_BLUE
#define RIDGWAY_BERYL_BLUE float3(0.714, 0.894, 0.922)
#endif
#ifndef BERYL_BLUE
#define BERYL_BLUE RIDGWAY_BERYL_BLUE
#endif

#ifndef RIDGWAY_BERYL_GREEN
#define RIDGWAY_BERYL_GREEN float3(0.392, 0.737, 0.729)
#endif
#ifndef BERYL_GREEN
#define BERYL_GREEN RIDGWAY_BERYL_GREEN
#endif

#ifndef RIDGWAY_BICE_GREEN
#define RIDGWAY_BICE_GREEN float3(0.498, 0.573, 0.412)
#endif
#ifndef BICE_GREEN
#define BICE_GREEN RIDGWAY_BICE_GREEN
#endif

#ifndef RIDGWAY_BISCAY_GREEN
#define RIDGWAY_BISCAY_GREEN float3(0.592, 0.620, 0.396)
#endif
#ifndef BISCAY_GREEN
#define BISCAY_GREEN RIDGWAY_BISCAY_GREEN
#endif

#ifndef RIDGWAY_BISHOPS_PURPLE
#define RIDGWAY_BISHOPS_PURPLE float3(0.608, 0.408, 0.545)
#endif
#ifndef BISHOPS_PURPLE
#define BISHOPS_PURPLE RIDGWAY_BISHOPS_PURPLE
#endif

#ifndef RIDGWAY_BISTER
#define RIDGWAY_BISTER float3(0.424, 0.337, 0.251)
#endif
#ifndef BISTER
#define BISTER RIDGWAY_BISTER
#endif

#ifndef RIDGWAY_BITTERSWEET_ORANGE
#define RIDGWAY_BITTERSWEET_ORANGE float3(0.996, 0.510, 0.314)
#endif
#ifndef BITTERSWEET_ORANGE
#define BITTERSWEET_ORANGE RIDGWAY_BITTERSWEET_ORANGE
#endif

#ifndef RIDGWAY_BITTERSWEET_PINK
#define RIDGWAY_BITTERSWEET_PINK float3(0.992, 0.624, 0.498)
#endif
#ifndef BITTERSWEET_PINK
#define BITTERSWEET_PINK RIDGWAY_BITTERSWEET_PINK
#endif

#ifndef RIDGWAY_BLACK
#define RIDGWAY_BLACK float3(0.196, 0.247, 0.224)
#endif
#ifndef BLACK
#define BLACK RIDGWAY_BLACK
#endif

#ifndef RIDGWAY_BLACKISH_BROWN_1
#define RIDGWAY_BLACKISH_BROWN_1 float3(0.263, 0.275, 0.255)
#endif
#ifndef BLACKISH_BROWN_1
#define BLACKISH_BROWN_1 RIDGWAY_BLACKISH_BROWN_1
#endif

#ifndef RIDGWAY_BLACKISH_BROWN_2
#define RIDGWAY_BLACKISH_BROWN_2 float3(0.275, 0.286, 0.263)
#endif
#ifndef BLACKISH_BROWN_2
#define BLACKISH_BROWN_2 RIDGWAY_BLACKISH_BROWN_2
#endif

#ifndef RIDGWAY_BLACKISH_BROWN_3
#define RIDGWAY_BLACKISH_BROWN_3 float3(0.290, 0.306, 0.278)
#endif
#ifndef BLACKISH_BROWN_3
#define BLACKISH_BROWN_3 RIDGWAY_BLACKISH_BROWN_3
#endif

#ifndef RIDGWAY_BLACKISH_GREEN_BLUE
#define RIDGWAY_BLACKISH_GREEN_BLUE float3(0.047, 0.353, 0.443)
#endif
#ifndef BLACKISH_GREEN_BLUE
#define BLACKISH_GREEN_BLUE RIDGWAY_BLACKISH_GREEN_BLUE
#endif

#ifndef RIDGWAY_BLACKISH_GREEN_GRAY
#define RIDGWAY_BLACKISH_GREEN_GRAY float3(0.208, 0.271, 0.255)
#endif
#ifndef BLACKISH_GREEN_GRAY
#define BLACKISH_GREEN_GRAY RIDGWAY_BLACKISH_GREEN_GRAY
#endif

#ifndef RIDGWAY_BLACKISH_MOUSE_GRAY
#define RIDGWAY_BLACKISH_MOUSE_GRAY float3(0.314, 0.333, 0.314)
#endif
#ifndef BLACKISH_MOUSE_GRAY
#define BLACKISH_MOUSE_GRAY RIDGWAY_BLACKISH_MOUSE_GRAY
#endif

#ifndef RIDGWAY_BLACKISH_PLUMBEOUS
#define RIDGWAY_BLACKISH_PLUMBEOUS float3(0.271, 0.322, 0.329)
#endif
#ifndef BLACKISH_PLUMBEOUS
#define BLACKISH_PLUMBEOUS RIDGWAY_BLACKISH_PLUMBEOUS
#endif

#ifndef RIDGWAY_BLACKISH_PURPLE
#define RIDGWAY_BLACKISH_PURPLE float3(0.349, 0.212, 0.294)
#endif
#ifndef BLACKISH_PURPLE
#define BLACKISH_PURPLE RIDGWAY_BLACKISH_PURPLE
#endif

#ifndef RIDGWAY_BLACKISH_RED_PURPLE
#define RIDGWAY_BLACKISH_RED_PURPLE float3(0.357, 0.212, 0.267)
#endif
#ifndef BLACKISH_RED_PURPLE
#define BLACKISH_RED_PURPLE RIDGWAY_BLACKISH_RED_PURPLE
#endif

#ifndef RIDGWAY_BLACKISH_SLATE
#define RIDGWAY_BLACKISH_SLATE float3(0.251, 0.298, 0.286)
#endif
#ifndef BLACKISH_SLATE
#define BLACKISH_SLATE RIDGWAY_BLACKISH_SLATE
#endif

#ifndef RIDGWAY_BLACKISH_VIOLET
#define RIDGWAY_BLACKISH_VIOLET float3(0.278, 0.231, 0.388)
#endif
#ifndef BLACKISH_VIOLET
#define BLACKISH_VIOLET RIDGWAY_BLACKISH_VIOLET
#endif

#ifndef RIDGWAY_BLACKISH_VIOLET_GRAY
#define RIDGWAY_BLACKISH_VIOLET_GRAY float3(0.243, 0.278, 0.275)
#endif
#ifndef BLACKISH_VIOLET_GRAY
#define BLACKISH_VIOLET_GRAY RIDGWAY_BLACKISH_VIOLET_GRAY
#endif

#ifndef RIDGWAY_BLANCS_BLUE
#define RIDGWAY_BLANCS_BLUE float3(0.216, 0.431, 0.616)
#endif
#ifndef BLANCS_BLUE
#define BLANCS_BLUE RIDGWAY_BLANCS_BLUE
#endif

#ifndef RIDGWAY_BLANCS_VIOLET
#define RIDGWAY_BLANCS_VIOLET float3(0.400, 0.345, 0.533)
#endif
#ifndef BLANCS_VIOLET
#define BLANCS_VIOLET RIDGWAY_BLANCS_VIOLET
#endif

#ifndef RIDGWAY_BLUE_VIOLET
#define RIDGWAY_BLUE_VIOLET float3(0.369, 0.306, 0.769)
#endif
#ifndef BLUE_VIOLET
#define BLUE_VIOLET RIDGWAY_BLUE_VIOLET
#endif

#ifndef RIDGWAY_BLUE_VIOLET_BLACK
#define RIDGWAY_BLUE_VIOLET_BLACK float3(0.239, 0.282, 0.294)
#endif
#ifndef BLUE_VIOLET_BLACK
#define BLUE_VIOLET_BLACK RIDGWAY_BLUE_VIOLET_BLACK
#endif

#ifndef RIDGWAY_BLUISH_BLACK
#define RIDGWAY_BLUISH_BLACK float3(0.192, 0.278, 0.298)
#endif
#ifndef BLUISH_BLACK
#define BLUISH_BLACK RIDGWAY_BLUISH_BLACK
#endif

#ifndef RIDGWAY_BLUISH_GLAUCOUS
#define RIDGWAY_BLUISH_GLAUCOUS float3(0.694, 0.792, 0.761)
#endif
#ifndef BLUISH_GLAUCOUS
#define BLUISH_GLAUCOUS RIDGWAY_BLUISH_GLAUCOUS
#endif

#ifndef RIDGWAY_BLUISH_GRAY_GREEN
#define RIDGWAY_BLUISH_GRAY_GREEN float3(0.467, 0.604, 0.576)
#endif
#ifndef BLUISH_GRAY_GREEN
#define BLUISH_GRAY_GREEN RIDGWAY_BLUISH_GRAY_GREEN
#endif

#ifndef RIDGWAY_BLUISH_LAVENDER
#define RIDGWAY_BLUISH_LAVENDER float3(0.671, 0.635, 0.773)
#endif
#ifndef BLUISH_LAVENDER
#define BLUISH_LAVENDER RIDGWAY_BLUISH_LAVENDER
#endif

#ifndef RIDGWAY_BLUISH_SLATE_BLACK
#define RIDGWAY_BLUISH_SLATE_BLACK float3(0.184, 0.275, 0.286)
#endif
#ifndef BLUISH_SLATE_BLACK
#define BLUISH_SLATE_BLACK RIDGWAY_BLUISH_SLATE_BLACK
#endif

#ifndef RIDGWAY_BLUISH_VIOLET
#define RIDGWAY_BLUISH_VIOLET float3(0.384, 0.271, 0.753)
#endif
#ifndef BLUISH_VIOLET
#define BLUISH_VIOLET RIDGWAY_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_BONE_BROWN
#define RIDGWAY_BONE_BROWN float3(0.349, 0.306, 0.271)
#endif
#ifndef BONE_BROWN
#define BONE_BROWN RIDGWAY_BONE_BROWN
#endif

#ifndef RIDGWAY_BORDEAUX
#define RIDGWAY_BORDEAUX float3(0.459, 0.204, 0.239)
#endif
#ifndef BORDEAUX
#define BORDEAUX RIDGWAY_BORDEAUX
#endif

#ifndef RIDGWAY_BOTTLE_GREEN
#define RIDGWAY_BOTTLE_GREEN float3(0.216, 0.373, 0.341)
#endif
#ifndef BOTTLE_GREEN
#define BOTTLE_GREEN RIDGWAY_BOTTLE_GREEN
#endif

#ifndef RIDGWAY_BRADLEYS_BLUE
#define RIDGWAY_BRADLEYS_BLUE float3(0.196, 0.404, 0.835)
#endif
#ifndef BRADLEYS_BLUE
#define BRADLEYS_BLUE RIDGWAY_BRADLEYS_BLUE
#endif

#ifndef RIDGWAY_BRADLEYS_VIOLET
#define RIDGWAY_BRADLEYS_VIOLET float3(0.502, 0.376, 0.635)
#endif
#ifndef BRADLEYS_VIOLET
#define BRADLEYS_VIOLET RIDGWAY_BRADLEYS_VIOLET
#endif

#ifndef RIDGWAY_BRAZIL_RED
#define RIDGWAY_BRAZIL_RED float3(0.710, 0.251, 0.176)
#endif
#ifndef BRAZIL_RED
#define BRAZIL_RED RIDGWAY_BRAZIL_RED
#endif

#ifndef RIDGWAY_BREMEN_BLUE
#define RIDGWAY_BREMEN_BLUE float3(0.408, 0.745, 0.796)
#endif
#ifndef BREMEN_BLUE
#define BREMEN_BLUE RIDGWAY_BREMEN_BLUE
#endif

#ifndef RIDGWAY_BRICK_RED
#define RIDGWAY_BRICK_RED float3(0.569, 0.322, 0.282)
#endif
#ifndef BRICK_RED
#define BRICK_RED RIDGWAY_BRICK_RED
#endif

#ifndef RIDGWAY_BRIGHT_CHALCEDONY_YELLOW
#define RIDGWAY_BRIGHT_CHALCEDONY_YELLOW float3(0.875, 0.824, 0.416)
#endif
#ifndef BRIGHT_CHALCEDONY_YELLOW
#define BRIGHT_CHALCEDONY_YELLOW RIDGWAY_BRIGHT_CHALCEDONY_YELLOW
#endif

#ifndef RIDGWAY_BRIGHT_GREEN_YELLOW
#define RIDGWAY_BRIGHT_GREEN_YELLOW float3(0.776, 0.765, 0.298)
#endif
#ifndef BRIGHT_GREEN_YELLOW
#define BRIGHT_GREEN_YELLOW RIDGWAY_BRIGHT_GREEN_YELLOW
#endif

#ifndef RIDGWAY_BROWNISH_DRAB
#define RIDGWAY_BROWNISH_DRAB float3(0.580, 0.490, 0.443)
#endif
#ifndef BROWNISH_DRAB
#define BROWNISH_DRAB RIDGWAY_BROWNISH_DRAB
#endif

#ifndef RIDGWAY_BROWNISH_OLIVE
#define RIDGWAY_BROWNISH_OLIVE float3(0.408, 0.361, 0.251)
#endif
#ifndef BROWNISH_OLIVE
#define BROWNISH_OLIVE RIDGWAY_BROWNISH_OLIVE
#endif

#ifndef RIDGWAY_BROWNISH_VINACEOUS
#define RIDGWAY_BROWNISH_VINACEOUS float3(0.761, 0.557, 0.533)
#endif
#ifndef BROWNISH_VINACEOUS
#define BROWNISH_VINACEOUS RIDGWAY_BROWNISH_VINACEOUS
#endif

#ifndef RIDGWAY_BRUSSELS_BROWN
#define RIDGWAY_BRUSSELS_BROWN float3(0.502, 0.357, 0.212)
#endif
#ifndef BRUSSELS_BROWN
#define BRUSSELS_BROWN RIDGWAY_BRUSSELS_BROWN
#endif

#ifndef RIDGWAY_BUCKTHORN_BROWN
#define RIDGWAY_BUCKTHORN_BROWN float3(0.737, 0.529, 0.271)
#endif
#ifndef BUCKTHORN_BROWN
#define BUCKTHORN_BROWN RIDGWAY_BUCKTHORN_BROWN
#endif

#ifndef RIDGWAY_BUFF_PINK
#define RIDGWAY_BUFF_PINK float3(0.906, 0.698, 0.584)
#endif
#ifndef BUFF_PINK
#define BUFF_PINK RIDGWAY_BUFF_PINK
#endif

#ifndef RIDGWAY_BUFF_YELLOW
#define RIDGWAY_BUFF_YELLOW float3(0.984, 0.804, 0.467)
#endif
#ifndef BUFF_YELLOW
#define BUFF_YELLOW RIDGWAY_BUFF_YELLOW
#endif

#ifndef RIDGWAY_BUFFY_BROWN
#define RIDGWAY_BUFFY_BROWN float3(0.592, 0.490, 0.365)
#endif
#ifndef BUFFY_BROWN
#define BUFFY_BROWN RIDGWAY_BUFFY_BROWN
#endif

#ifndef RIDGWAY_BUFFY_CITRINE
#define RIDGWAY_BUFFY_CITRINE float3(0.596, 0.514, 0.290)
#endif
#ifndef BUFFY_CITRINE
#define BUFFY_CITRINE RIDGWAY_BUFFY_CITRINE
#endif

#ifndef RIDGWAY_BUFFY_OLIVE
#define RIDGWAY_BUFFY_OLIVE float3(0.549, 0.486, 0.337)
#endif
#ifndef BUFFY_OLIVE
#define BUFFY_OLIVE RIDGWAY_BUFFY_OLIVE
#endif

#ifndef RIDGWAY_BURN_BLUE
#define RIDGWAY_BURN_BLUE float3(0.690, 0.729, 0.796)
#endif
#ifndef BURN_BLUE
#define BURN_BLUE RIDGWAY_BURN_BLUE
#endif

#ifndef RIDGWAY_BURNT_LAKE
#define RIDGWAY_BURNT_LAKE float3(0.396, 0.231, 0.231)
#endif
#ifndef BURNT_LAKE
#define BURNT_LAKE RIDGWAY_BURNT_LAKE
#endif

#ifndef RIDGWAY_BURNT_SIENNA
#define RIDGWAY_BURNT_SIENNA float3(0.588, 0.290, 0.176)
#endif
#ifndef BURNT_SIENNA
#define BURNT_SIENNA RIDGWAY_BURNT_SIENNA
#endif

#ifndef RIDGWAY_BURNT_UMBER
#define RIDGWAY_BURNT_UMBER float3(0.424, 0.314, 0.263)
#endif
#ifndef BURNT_UMBER
#define BURNT_UMBER RIDGWAY_BURNT_UMBER
#endif

#ifndef RIDGWAY_CACAO_BROWN
#define RIDGWAY_CACAO_BROWN float3(0.686, 0.459, 0.369)
#endif
#ifndef CACAO_BROWN
#define CACAO_BROWN RIDGWAY_CACAO_BROWN
#endif

#ifndef RIDGWAY_CADET_BLUE
#define RIDGWAY_CADET_BLUE float3(0.369, 0.482, 0.702)
#endif
#ifndef CADET_BLUE
#define CADET_BLUE RIDGWAY_CADET_BLUE
#endif

#ifndef RIDGWAY_CADET_GRAY
#define RIDGWAY_CADET_GRAY float3(0.549, 0.627, 0.671)
#endif
#ifndef CADET_GRAY
#define CADET_GRAY RIDGWAY_CADET_GRAY
#endif

#ifndef RIDGWAY_CADMIUM_ORANGE
#define RIDGWAY_CADMIUM_ORANGE float3(0.996, 0.498, 0.090)
#endif
#ifndef CADMIUM_ORANGE
#define CADMIUM_ORANGE RIDGWAY_CADMIUM_ORANGE
#endif

#ifndef RIDGWAY_CADMIUM_YELLOW
#define RIDGWAY_CADMIUM_YELLOW float3(0.992, 0.682, 0.000)
#endif
#ifndef CADMIUM_YELLOW
#define CADMIUM_YELLOW RIDGWAY_CADMIUM_YELLOW
#endif

#ifndef RIDGWAY_CALAMINE_BLUE
#define RIDGWAY_CALAMINE_BLUE float3(0.506, 0.800, 0.863)
#endif
#ifndef CALAMINE_BLUE
#define CALAMINE_BLUE RIDGWAY_CALAMINE_BLUE
#endif

#ifndef RIDGWAY_CALLA_GREEN
#define RIDGWAY_CALLA_GREEN float3(0.431, 0.463, 0.267)
#endif
#ifndef CALLA_GREEN
#define CALLA_GREEN RIDGWAY_CALLA_GREEN
#endif

#ifndef RIDGWAY_CALLISTE_GREEN
#define RIDGWAY_CALLISTE_GREEN float3(0.714, 0.694, 0.294)
#endif
#ifndef CALLISTE_GREEN
#define CALLISTE_GREEN RIDGWAY_CALLISTE_GREEN
#endif

#ifndef RIDGWAY_CAMEO_BROWN
#define RIDGWAY_CAMEO_BROWN float3(0.533, 0.380, 0.325)
#endif
#ifndef CAMEO_BROWN
#define CAMEO_BROWN RIDGWAY_CAMEO_BROWN
#endif

#ifndef RIDGWAY_CAMEO_PINK
#define RIDGWAY_CAMEO_PINK float3(0.933, 0.784, 0.804)
#endif
#ifndef CAMEO_PINK
#define CAMEO_PINK RIDGWAY_CAMEO_PINK
#endif

#ifndef RIDGWAY_CAMPANULA_BLUE
#define RIDGWAY_CAMPANULA_BLUE float3(0.541, 0.600, 0.843)
#endif
#ifndef CAMPANULA_BLUE
#define CAMPANULA_BLUE RIDGWAY_CAMPANULA_BLUE
#endif

#ifndef RIDGWAY_CAPRI_BLUE
#define RIDGWAY_CAPRI_BLUE float3(0.153, 0.529, 0.580)
#endif
#ifndef CAPRI_BLUE
#define CAPRI_BLUE RIDGWAY_CAPRI_BLUE
#endif

#ifndef RIDGWAY_CAPUCINE_BUFF
#define RIDGWAY_CAPUCINE_BUFF float3(0.992, 0.800, 0.596)
#endif
#ifndef CAPUCINE_BUFF
#define CAPUCINE_BUFF RIDGWAY_CAPUCINE_BUFF
#endif

#ifndef RIDGWAY_CAPUCINE_ORANGE
#define RIDGWAY_CAPUCINE_ORANGE float3(0.996, 0.694, 0.349)
#endif
#ifndef CAPUCINE_ORANGE
#define CAPUCINE_ORANGE RIDGWAY_CAPUCINE_ORANGE
#endif

#ifndef RIDGWAY_CAPUCINE_YELLOW
#define RIDGWAY_CAPUCINE_YELLOW float3(0.996, 0.671, 0.227)
#endif
#ifndef CAPUCINE_YELLOW
#define CAPUCINE_YELLOW RIDGWAY_CAPUCINE_YELLOW
#endif

#ifndef RIDGWAY_CARMINE
#define RIDGWAY_CARMINE float3(0.576, 0.184, 0.192)
#endif
#ifndef CARMINE
#define CARMINE RIDGWAY_CARMINE
#endif

#ifndef RIDGWAY_CARNELIAN_RED
#define RIDGWAY_CARNELIAN_RED float3(0.922, 0.455, 0.333)
#endif
#ifndef CARNELIAN_RED
#define CARNELIAN_RED RIDGWAY_CARNELIAN_RED
#endif

#ifndef RIDGWAY_CAROB_BROWN
#define RIDGWAY_CAROB_BROWN float3(0.424, 0.337, 0.290)
#endif
#ifndef CAROB_BROWN
#define CAROB_BROWN RIDGWAY_CAROB_BROWN
#endif

#ifndef RIDGWAY_CARROT_RED
#define RIDGWAY_CARROT_RED float3(0.882, 0.525, 0.455)
#endif
#ifndef CARROT_RED
#define CARROT_RED RIDGWAY_CARROT_RED
#endif

#ifndef RIDGWAY_CARTRIDGE_BUFF
#define RIDGWAY_CARTRIDGE_BUFF float3(0.953, 0.867, 0.749)
#endif
#ifndef CARTRIDGE_BUFF
#define CARTRIDGE_BUFF RIDGWAY_CARTRIDGE_BUFF
#endif

#ifndef RIDGWAY_CASTOR_GRAY
#define RIDGWAY_CASTOR_GRAY float3(0.373, 0.431, 0.400)
#endif
#ifndef CASTOR_GRAY
#define CASTOR_GRAY RIDGWAY_CASTOR_GRAY
#endif

#ifndef RIDGWAY_CEDAR_GREEN
#define RIDGWAY_CEDAR_GREEN float3(0.388, 0.435, 0.298)
#endif
#ifndef CEDAR_GREEN
#define CEDAR_GREEN RIDGWAY_CEDAR_GREEN
#endif

#ifndef RIDGWAY_CELANDINE_GREEN
#define RIDGWAY_CELANDINE_GREEN float3(0.541, 0.631, 0.549)
#endif
#ifndef CELANDINE_GREEN
#define CELANDINE_GREEN RIDGWAY_CELANDINE_GREEN
#endif

#ifndef RIDGWAY_CENDRE_BLUE
#define RIDGWAY_CENDRE_BLUE float3(0.341, 0.690, 0.792)
#endif
#ifndef CENDRE_BLUE
#define CENDRE_BLUE RIDGWAY_CENDRE_BLUE
#endif

#ifndef RIDGWAY_CENDRE_GREEN
#define RIDGWAY_CENDRE_GREEN float3(0.490, 0.757, 0.545)
#endif
#ifndef CENDRE_GREEN
#define CENDRE_GREEN RIDGWAY_CENDRE_GREEN
#endif

#ifndef RIDGWAY_CERRO_GREEN
#define RIDGWAY_CERRO_GREEN float3(0.420, 0.459, 0.267)
#endif
#ifndef CERRO_GREEN
#define CERRO_GREEN RIDGWAY_CERRO_GREEN
#endif

#ifndef RIDGWAY_CERULEAN_BLUE
#define RIDGWAY_CERULEAN_BLUE float3(0.051, 0.533, 0.804)
#endif
#ifndef CERULEAN_BLUE
#define CERULEAN_BLUE RIDGWAY_CERULEAN_BLUE
#endif

#ifndef RIDGWAY_CHAETURA_BLACK
#define RIDGWAY_CHAETURA_BLACK float3(0.271, 0.290, 0.259)
#endif
#ifndef CHAETURA_BLACK
#define CHAETURA_BLACK RIDGWAY_CHAETURA_BLACK
#endif

#ifndef RIDGWAY_CHAETURA_DRAB
#define RIDGWAY_CHAETURA_DRAB float3(0.345, 0.345, 0.294)
#endif
#ifndef CHAETURA_DRAB
#define CHAETURA_DRAB RIDGWAY_CHAETURA_DRAB
#endif

#ifndef RIDGWAY_CHALCEDONY_YELLOW
#define RIDGWAY_CHALCEDONY_YELLOW float3(0.890, 0.835, 0.490)
#endif
#ifndef CHALCEDONY_YELLOW
#define CHALCEDONY_YELLOW RIDGWAY_CHALCEDONY_YELLOW
#endif

#ifndef RIDGWAY_CHAMOIS
#define RIDGWAY_CHAMOIS float3(0.831, 0.675, 0.443)
#endif
#ifndef CHAMOIS
#define CHAMOIS RIDGWAY_CHAMOIS
#endif

#ifndef RIDGWAY_CHAPMANS_BLUE
#define RIDGWAY_CHAPMANS_BLUE float3(0.361, 0.447, 0.620)
#endif
#ifndef CHAPMANS_BLUE
#define CHAPMANS_BLUE RIDGWAY_CHAPMANS_BLUE
#endif

#ifndef RIDGWAY_CHARTREUSE_YELLOW
#define RIDGWAY_CHARTREUSE_YELLOW float3(0.894, 0.827, 0.580)
#endif
#ifndef CHARTREUSE_YELLOW
#define CHARTREUSE_YELLOW RIDGWAY_CHARTREUSE_YELLOW
#endif

#ifndef RIDGWAY_CHATENAY_PINK
#define RIDGWAY_CHATENAY_PINK float3(0.933, 0.753, 0.741)
#endif
#ifndef CHATENAY_PINK
#define CHATENAY_PINK RIDGWAY_CHATENAY_PINK
#endif

#ifndef RIDGWAY_CHESSYLITE_BLUE
#define RIDGWAY_CHESSYLITE_BLUE float3(0.255, 0.482, 0.588)
#endif
#ifndef CHESSYLITE_BLUE
#define CHESSYLITE_BLUE RIDGWAY_CHESSYLITE_BLUE
#endif

#ifndef RIDGWAY_CHESTNUT
#define RIDGWAY_CHESTNUT float3(0.490, 0.282, 0.192)
#endif
#ifndef CHESTNUT
#define CHESTNUT RIDGWAY_CHESTNUT
#endif

#ifndef RIDGWAY_CHESTNUT_BROWN
#define RIDGWAY_CHESTNUT_BROWN float3(0.435, 0.341, 0.298)
#endif
#ifndef CHESTNUT_BROWN
#define CHESTNUT_BROWN RIDGWAY_CHESTNUT_BROWN
#endif

#ifndef RIDGWAY_CHICORY_BLUE
#define RIDGWAY_CHICORY_BLUE float3(0.600, 0.631, 0.839)
#endif
#ifndef CHICORY_BLUE
#define CHICORY_BLUE RIDGWAY_CHICORY_BLUE
#endif

#ifndef RIDGWAY_CHINA_BLUE
#define RIDGWAY_CHINA_BLUE float3(0.325, 0.545, 0.663)
#endif
#ifndef CHINA_BLUE
#define CHINA_BLUE RIDGWAY_CHINA_BLUE
#endif

#ifndef RIDGWAY_CHINESE_VIOLET
#define RIDGWAY_CHINESE_VIOLET float3(0.702, 0.510, 0.776)
#endif
#ifndef CHINESE_VIOLET
#define CHINESE_VIOLET RIDGWAY_CHINESE_VIOLET
#endif

#ifndef RIDGWAY_CHOCOLATE
#define RIDGWAY_CHOCOLATE float3(0.427, 0.306, 0.263)
#endif
#ifndef CHOCOLATE
#define CHOCOLATE RIDGWAY_CHOCOLATE
#endif

#ifndef RIDGWAY_CHROMIUM_GREEN
#define RIDGWAY_CHROMIUM_GREEN float3(0.514, 0.573, 0.380)
#endif
#ifndef CHROMIUM_GREEN
#define CHROMIUM_GREEN RIDGWAY_CHROMIUM_GREEN
#endif

#ifndef RIDGWAY_CHRYSOLITE_GREEN
#define RIDGWAY_CHRYSOLITE_GREEN float3(0.784, 0.776, 0.498)
#endif
#ifndef CHRYSOLITE_GREEN
#define CHRYSOLITE_GREEN RIDGWAY_CHRYSOLITE_GREEN
#endif

#ifndef RIDGWAY_CHRYSOPRASE_GREEN
#define RIDGWAY_CHRYSOPRASE_GREEN float3(0.541, 0.792, 0.553)
#endif
#ifndef CHRYSOPRASE_GREEN
#define CHRYSOPRASE_GREEN RIDGWAY_CHRYSOPRASE_GREEN
#endif

#ifndef RIDGWAY_CINEREOUS
#define RIDGWAY_CINEREOUS float3(0.667, 0.675, 0.671)
#endif
#ifndef CINEREOUS
#define CINEREOUS RIDGWAY_CINEREOUS
#endif

#ifndef RIDGWAY_CINNAMON
#define RIDGWAY_CINNAMON float3(0.800, 0.573, 0.373)
#endif
#ifndef CINNAMON
#define CINNAMON RIDGWAY_CINNAMON
#endif

#ifndef RIDGWAY_CINNAMON_BROWN
#define RIDGWAY_CINNAMON_BROWN float3(0.569, 0.404, 0.267)
#endif
#ifndef CINNAMON_BROWN
#define CINNAMON_BROWN RIDGWAY_CINNAMON_BROWN
#endif

#ifndef RIDGWAY_CINNAMON_BUFF
#define RIDGWAY_CINNAMON_BUFF float3(0.851, 0.659, 0.455)
#endif
#ifndef CINNAMON_BUFF
#define CINNAMON_BUFF RIDGWAY_CINNAMON_BUFF
#endif

#ifndef RIDGWAY_CINNAMON_DRAB
#define RIDGWAY_CINNAMON_DRAB float3(0.639, 0.533, 0.459)
#endif
#ifndef CINNAMON_DRAB
#define CINNAMON_DRAB RIDGWAY_CINNAMON_DRAB
#endif

#ifndef RIDGWAY_CINNAMON_RUFOUS
#define RIDGWAY_CINNAMON_RUFOUS float3(0.729, 0.416, 0.294)
#endif
#ifndef CINNAMON_RUFOUS
#define CINNAMON_RUFOUS RIDGWAY_CINNAMON_RUFOUS
#endif

#ifndef RIDGWAY_CITRINE
#define RIDGWAY_CITRINE float3(0.584, 0.498, 0.227)
#endif
#ifndef CITRINE
#define CITRINE RIDGWAY_CITRINE
#endif

#ifndef RIDGWAY_CITRINE_DRAB
#define RIDGWAY_CITRINE_DRAB float3(0.565, 0.510, 0.376)
#endif
#ifndef CITRINE_DRAB
#define CITRINE_DRAB RIDGWAY_CITRINE_DRAB
#endif

#ifndef RIDGWAY_CITRON_GREEN
#define RIDGWAY_CITRON_GREEN float3(0.780, 0.725, 0.435)
#endif
#ifndef CITRON_GREEN
#define CITRON_GREEN RIDGWAY_CITRON_GREEN
#endif

#ifndef RIDGWAY_CITRON_YELLOW
#define RIDGWAY_CITRON_YELLOW float3(0.957, 0.867, 0.431)
#endif
#ifndef CITRON_YELLOW
#define CITRON_YELLOW RIDGWAY_CITRON_YELLOW
#endif

#ifndef RIDGWAY_CIVETTE_GREEN
#define RIDGWAY_CIVETTE_GREEN float3(0.408, 0.518, 0.384)
#endif
#ifndef CIVETTE_GREEN
#define CIVETTE_GREEN RIDGWAY_CIVETTE_GREEN
#endif

#ifndef RIDGWAY_CLARET_BROWN
#define RIDGWAY_CLARET_BROWN float3(0.412, 0.235, 0.200)
#endif
#ifndef CLARET_BROWN
#define CLARET_BROWN RIDGWAY_CLARET_BROWN
#endif

#ifndef RIDGWAY_CLAY_COLOR
#define RIDGWAY_CLAY_COLOR float3(0.769, 0.573, 0.325)
#endif
#ifndef CLAY_COLOR
#define CLAY_COLOR RIDGWAY_CLAY_COLOR
#endif

#ifndef RIDGWAY_CLEAR_CADET_BLUE
#define RIDGWAY_CLEAR_CADET_BLUE float3(0.412, 0.541, 0.808)
#endif
#ifndef CLEAR_CADET_BLUE
#define CLEAR_CADET_BLUE RIDGWAY_CLEAR_CADET_BLUE
#endif

#ifndef RIDGWAY_CLEAR_DULL_GREEN_YELLOW
#define RIDGWAY_CLEAR_DULL_GREEN_YELLOW float3(0.886, 0.863, 0.486)
#endif
#ifndef CLEAR_DULL_GREEN_YELLOW
#define CLEAR_DULL_GREEN_YELLOW RIDGWAY_CLEAR_DULL_GREEN_YELLOW
#endif

#ifndef RIDGWAY_CLEAR_FLUORITE_GREEN
#define RIDGWAY_CLEAR_FLUORITE_GREEN float3(0.655, 0.757, 0.545)
#endif
#ifndef CLEAR_FLUORITE_GREEN
#define CLEAR_FLUORITE_GREEN RIDGWAY_CLEAR_FLUORITE_GREEN
#endif

#ifndef RIDGWAY_CLEAR_GREEN_BLUE_GRAY
#define RIDGWAY_CLEAR_GREEN_BLUE_GRAY float3(0.553, 0.627, 0.639)
#endif
#ifndef CLEAR_GREEN_BLUE_GRAY
#define CLEAR_GREEN_BLUE_GRAY RIDGWAY_CLEAR_GREEN_BLUE_GRAY
#endif

#ifndef RIDGWAY_CLEAR_PAYNES_GRAY
#define RIDGWAY_CLEAR_PAYNES_GRAY float3(0.467, 0.533, 0.565)
#endif
#ifndef CLEAR_PAYNES_GRAY
#define CLEAR_PAYNES_GRAY RIDGWAY_CLEAR_PAYNES_GRAY
#endif

#ifndef RIDGWAY_CLEAR_WINDSOR_BLUE
#define RIDGWAY_CLEAR_WINDSOR_BLUE float3(0.388, 0.467, 0.620)
#endif
#ifndef CLEAR_WINDSOR_BLUE
#define CLEAR_WINDSOR_BLUE RIDGWAY_CLEAR_WINDSOR_BLUE
#endif

#ifndef RIDGWAY_CLEAR_YELLOW_GREEN
#define RIDGWAY_CLEAR_YELLOW_GREEN float3(0.906, 0.867, 0.388)
#endif
#ifndef CLEAR_YELLOW_GREEN
#define CLEAR_YELLOW_GREEN RIDGWAY_CLEAR_YELLOW_GREEN
#endif

#ifndef RIDGWAY_CLOVE_BROWN
#define RIDGWAY_CLOVE_BROWN float3(0.353, 0.325, 0.278)
#endif
#ifndef CLOVE_BROWN
#define CLOVE_BROWN RIDGWAY_CLOVE_BROWN
#endif

#ifndef RIDGWAY_COBALT_GREEN
#define RIDGWAY_COBALT_GREEN float3(0.482, 0.776, 0.627)
#endif
#ifndef COBALT_GREEN
#define COBALT_GREEN RIDGWAY_COBALT_GREEN
#endif

#ifndef RIDGWAY_COLONIAL_BUFF
#define RIDGWAY_COLONIAL_BUFF float3(0.922, 0.808, 0.569)
#endif
#ifndef COLONIAL_BUFF
#define COLONIAL_BUFF RIDGWAY_COLONIAL_BUFF
#endif

#ifndef RIDGWAY_COLUMBIA_BLUE
#define RIDGWAY_COLUMBIA_BLUE float3(0.514, 0.612, 0.706)
#endif
#ifndef COLUMBIA_BLUE
#define COLUMBIA_BLUE RIDGWAY_COLUMBIA_BLUE
#endif

#ifndef RIDGWAY_COMMELINA_BLUE
#define RIDGWAY_COMMELINA_BLUE float3(0.412, 0.502, 0.835)
#endif
#ifndef COMMELINA_BLUE
#define COMMELINA_BLUE RIDGWAY_COMMELINA_BLUE
#endif

#ifndef RIDGWAY_CONGO_PINK
#define RIDGWAY_CONGO_PINK float3(0.831, 0.561, 0.478)
#endif
#ifndef CONGO_PINK
#define CONGO_PINK RIDGWAY_CONGO_PINK
#endif

#ifndef RIDGWAY_CORAL_PINK
#define RIDGWAY_CORAL_PINK float3(0.894, 0.580, 0.537)
#endif
#ifndef CORAL_PINK
#define CORAL_PINK RIDGWAY_CORAL_PINK
#endif

#ifndef RIDGWAY_CORAL_RED
#define RIDGWAY_CORAL_RED float3(0.863, 0.361, 0.294)
#endif
#ifndef CORAL_RED
#define CORAL_RED RIDGWAY_CORAL_RED
#endif

#ifndef RIDGWAY_CORINTHIAN_PINK
#define RIDGWAY_CORINTHIAN_PINK float3(0.796, 0.612, 0.616)
#endif
#ifndef CORINTHIAN_PINK
#define CORINTHIAN_PINK RIDGWAY_CORINTHIAN_PINK
#endif

#ifndef RIDGWAY_CORINTHIAN_PURPLE
#define RIDGWAY_CORINTHIAN_PURPLE float3(0.518, 0.310, 0.333)
#endif
#ifndef CORINTHIAN_PURPLE
#define CORINTHIAN_PURPLE RIDGWAY_CORINTHIAN_PURPLE
#endif

#ifndef RIDGWAY_CORINTHIAN_RED
#define RIDGWAY_CORINTHIAN_RED float3(0.612, 0.404, 0.388)
#endif
#ifndef CORINTHIAN_RED
#define CORINTHIAN_RED RIDGWAY_CORINTHIAN_RED
#endif

#ifndef RIDGWAY_CORNFLOWER_BLUE
#define RIDGWAY_CORNFLOWER_BLUE float3(0.439, 0.471, 0.808)
#endif
#ifndef CORNFLOWER_BLUE
#define CORNFLOWER_BLUE RIDGWAY_CORNFLOWER_BLUE
#endif

#ifndef RIDGWAY_CORYDALIS_GREEN
#define RIDGWAY_CORYDALIS_GREEN float3(0.729, 0.769, 0.651)
#endif
#ifndef CORYDALIS_GREEN
#define CORYDALIS_GREEN RIDGWAY_CORYDALIS_GREEN
#endif

#ifndef RIDGWAY_COSSACK_GREEN
#define RIDGWAY_COSSACK_GREEN float3(0.282, 0.427, 0.302)
#endif
#ifndef COSSACK_GREEN
#define COSSACK_GREEN RIDGWAY_COSSACK_GREEN
#endif

#ifndef RIDGWAY_COSSE_GREEN
#define RIDGWAY_COSSE_GREEN float3(0.667, 0.682, 0.275)
#endif
#ifndef COSSE_GREEN
#define COSSE_GREEN RIDGWAY_COSSE_GREEN
#endif

#ifndef RIDGWAY_COTINGA_PURPLE
#define RIDGWAY_COTINGA_PURPLE float3(0.408, 0.231, 0.404)
#endif
#ifndef COTINGA_PURPLE
#define COTINGA_PURPLE RIDGWAY_COTINGA_PURPLE
#endif

#ifndef RIDGWAY_COURGE_GREEN
#define RIDGWAY_COURGE_GREEN float3(0.631, 0.624, 0.388)
#endif
#ifndef COURGE_GREEN
#define COURGE_GREEN RIDGWAY_COURGE_GREEN
#endif

#ifndef RIDGWAY_COURT_GRAY
#define RIDGWAY_COURT_GRAY float3(0.694, 0.733, 0.690)
#endif
#ifndef COURT_GRAY
#define COURT_GRAY RIDGWAY_COURT_GRAY
#endif

#ifndef RIDGWAY_CREAM_COLOR
#define RIDGWAY_CREAM_COLOR float3(0.984, 0.882, 0.659)
#endif
#ifndef CREAM_COLOR
#define CREAM_COLOR RIDGWAY_CREAM_COLOR
#endif

#ifndef RIDGWAY_CREAM_BUFF
#define RIDGWAY_CREAM_BUFF float3(0.898, 0.757, 0.553)
#endif
#ifndef CREAM_BUFF
#define CREAM_BUFF RIDGWAY_CREAM_BUFF
#endif

#ifndef RIDGWAY_CRESS_GREEN
#define RIDGWAY_CRESS_GREEN float3(0.431, 0.494, 0.310)
#endif
#ifndef CRESS_GREEN
#define CRESS_GREEN RIDGWAY_CRESS_GREEN
#endif

#ifndef RIDGWAY_CYANINE_BLUE
#define RIDGWAY_CYANINE_BLUE float3(0.208, 0.294, 0.525)
#endif
#ifndef CYANINE_BLUE
#define CYANINE_BLUE RIDGWAY_CYANINE_BLUE
#endif

#ifndef RIDGWAY_DAHLIA_CARMINE
#define RIDGWAY_DAHLIA_CARMINE float3(0.463, 0.251, 0.302)
#endif
#ifndef DAHLIA_CARMINE
#define DAHLIA_CARMINE RIDGWAY_DAHLIA_CARMINE
#endif

#ifndef RIDGWAY_DAHLIA_PURPLE
#define RIDGWAY_DAHLIA_PURPLE float3(0.435, 0.192, 0.310)
#endif
#ifndef DAHLIA_PURPLE
#define DAHLIA_PURPLE RIDGWAY_DAHLIA_PURPLE
#endif

#ifndef RIDGWAY_DANUBE_GREEN
#define RIDGWAY_DANUBE_GREEN float3(0.278, 0.396, 0.310)
#endif
#ifndef DANUBE_GREEN
#define DANUBE_GREEN RIDGWAY_DANUBE_GREEN
#endif

#ifndef RIDGWAY_DAPHNE_PINK
#define RIDGWAY_DAPHNE_PINK float3(0.808, 0.525, 0.592)
#endif
#ifndef DAPHNE_PINK
#define DAPHNE_PINK RIDGWAY_DAPHNE_PINK
#endif

#ifndef RIDGWAY_DAPHNE_RED
#define RIDGWAY_DAPHNE_RED float3(0.651, 0.404, 0.498)
#endif
#ifndef DAPHNE_RED
#define DAPHNE_RED RIDGWAY_DAPHNE_RED
#endif

#ifndef RIDGWAY_DARK_AMERICAN_GREEN
#define RIDGWAY_DARK_AMERICAN_GREEN float3(0.306, 0.427, 0.353)
#endif
#ifndef DARK_AMERICAN_GREEN
#define DARK_AMERICAN_GREEN RIDGWAY_DARK_AMERICAN_GREEN
#endif

#ifndef RIDGWAY_DARK_ANILINE_BLUE
#define RIDGWAY_DARK_ANILINE_BLUE float3(0.212, 0.259, 0.380)
#endif
#ifndef DARK_ANILINE_BLUE
#define DARK_ANILINE_BLUE RIDGWAY_DARK_ANILINE_BLUE
#endif

#ifndef RIDGWAY_DARK_ANTHRACENE_VIOLET
#define RIDGWAY_DARK_ANTHRACENE_VIOLET float3(0.263, 0.278, 0.349)
#endif
#ifndef DARK_ANTHRACENE_VIOLET
#define DARK_ANTHRACENE_VIOLET RIDGWAY_DARK_ANTHRACENE_VIOLET
#endif

#ifndef RIDGWAY_DARK_BLUISH_GLAUCOUS
#define RIDGWAY_DARK_BLUISH_GLAUCOUS float3(0.565, 0.675, 0.604)
#endif
#ifndef DARK_BLUISH_GLAUCOUS
#define DARK_BLUISH_GLAUCOUS RIDGWAY_DARK_BLUISH_GLAUCOUS
#endif

#ifndef RIDGWAY_DARK_BLUISH_GRAY_GREEN
#define RIDGWAY_DARK_BLUISH_GRAY_GREEN float3(0.239, 0.404, 0.412)
#endif
#ifndef DARK_BLUISH_GRAY_GREEN
#define DARK_BLUISH_GRAY_GREEN RIDGWAY_DARK_BLUISH_GRAY_GREEN
#endif

#ifndef RIDGWAY_DARK_BLUISH_VIOLET
#define RIDGWAY_DARK_BLUISH_VIOLET float3(0.271, 0.263, 0.376)
#endif
#ifndef DARK_BLUISH_VIOLET
#define DARK_BLUISH_VIOLET RIDGWAY_DARK_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_DARK_CADET_BLUE
#define RIDGWAY_DARK_CADET_BLUE float3(0.278, 0.380, 0.506)
#endif
#ifndef DARK_CADET_BLUE
#define DARK_CADET_BLUE RIDGWAY_DARK_CADET_BLUE
#endif

#ifndef RIDGWAY_DARK_CHESSYLITE_BLUE
#define RIDGWAY_DARK_CHESSYLITE_BLUE float3(0.196, 0.376, 0.427)
#endif
#ifndef DARK_CHESSYLITE_BLUE
#define DARK_CHESSYLITE_BLUE RIDGWAY_DARK_CHESSYLITE_BLUE
#endif

#ifndef RIDGWAY_DARK_CINNABAR_GREEN
#define RIDGWAY_DARK_CINNABAR_GREEN float3(0.243, 0.467, 0.416)
#endif
#ifndef DARK_CINNABAR_GREEN
#define DARK_CINNABAR_GREEN RIDGWAY_DARK_CINNABAR_GREEN
#endif

#ifndef RIDGWAY_DARK_CITRINE
#define RIDGWAY_DARK_CITRINE float3(0.467, 0.420, 0.224)
#endif
#ifndef DARK_CITRINE
#define DARK_CITRINE RIDGWAY_DARK_CITRINE
#endif

#ifndef RIDGWAY_DARK_CORINTHIAN_PURPLE
#define RIDGWAY_DARK_CORINTHIAN_PURPLE float3(0.412, 0.278, 0.278)
#endif
#ifndef DARK_CORINTHIAN_PURPLE
#define DARK_CORINTHIAN_PURPLE RIDGWAY_DARK_CORINTHIAN_PURPLE
#endif

#ifndef RIDGWAY_DARK_CRESS_GREEN
#define RIDGWAY_DARK_CRESS_GREEN float3(0.341, 0.388, 0.278)
#endif
#ifndef DARK_CRESS_GREEN
#define DARK_CRESS_GREEN RIDGWAY_DARK_CRESS_GREEN
#endif

#ifndef RIDGWAY_DARK_DELFT_BLUE
#define RIDGWAY_DARK_DELFT_BLUE float3(0.192, 0.318, 0.349)
#endif
#ifndef DARK_DELFT_BLUE
#define DARK_DELFT_BLUE RIDGWAY_DARK_DELFT_BLUE
#endif

#ifndef RIDGWAY_DARK_DIVA_BLUE
#define RIDGWAY_DARK_DIVA_BLUE float3(0.318, 0.392, 0.624)
#endif
#ifndef DARK_DIVA_BLUE
#define DARK_DIVA_BLUE RIDGWAY_DARK_DIVA_BLUE
#endif

#ifndef RIDGWAY_DARK_DULL_BLUISH_VIOLET_1
#define RIDGWAY_DARK_DULL_BLUISH_VIOLET_1 float3(0.298, 0.294, 0.435)
#endif
#ifndef DARK_DULL_BLUISH_VIOLET_1
#define DARK_DULL_BLUISH_VIOLET_1 RIDGWAY_DARK_DULL_BLUISH_VIOLET_1
#endif

#ifndef RIDGWAY_DARK_DULL_BLUISH_VIOLET_2
#define RIDGWAY_DARK_DULL_BLUISH_VIOLET_2 float3(0.333, 0.361, 0.459)
#endif
#ifndef DARK_DULL_BLUISH_VIOLET_2
#define DARK_DULL_BLUISH_VIOLET_2 RIDGWAY_DARK_DULL_BLUISH_VIOLET_2
#endif

#ifndef RIDGWAY_DARK_DULL_BLUISH_VIOLET_3
#define RIDGWAY_DARK_DULL_BLUISH_VIOLET_3 float3(0.384, 0.325, 0.435)
#endif
#ifndef DARK_DULL_BLUISH_VIOLET_3
#define DARK_DULL_BLUISH_VIOLET_3 RIDGWAY_DARK_DULL_BLUISH_VIOLET_3
#endif

#ifndef RIDGWAY_DARK_DULL_VIOLET_BLUE
#define RIDGWAY_DARK_DULL_VIOLET_BLUE float3(0.282, 0.314, 0.443)
#endif
#ifndef DARK_DULL_VIOLET_BLUE
#define DARK_DULL_VIOLET_BLUE RIDGWAY_DARK_DULL_VIOLET_BLUE
#endif

#ifndef RIDGWAY_DARK_DULL_VIOLET_BLUE
#define RIDGWAY_DARK_DULL_VIOLET_BLUE float3(0.357, 0.345, 0.439)
#endif
#ifndef DARK_DULL_VIOLET_BLUE
#define DARK_DULL_VIOLET_BLUE RIDGWAY_DARK_DULL_VIOLET_BLUE
#endif

#ifndef RIDGWAY_DARK_DULL_YELLOW_GREEN
#define RIDGWAY_DARK_DULL_YELLOW_GREEN float3(0.310, 0.376, 0.267)
#endif
#ifndef DARK_DULL_YELLOW_GREEN
#define DARK_DULL_YELLOW_GREEN RIDGWAY_DARK_DULL_YELLOW_GREEN
#endif

#ifndef RIDGWAY_DARK_GLAUCOUS_GRAY
#define RIDGWAY_DARK_GLAUCOUS_GRAY float3(0.482, 0.588, 0.557)
#endif
#ifndef DARK_GLAUCOUS_GRAY
#define DARK_GLAUCOUS_GRAY RIDGWAY_DARK_GLAUCOUS_GRAY
#endif

#ifndef RIDGWAY_DARK_GOBELIN_BLUE
#define RIDGWAY_DARK_GOBELIN_BLUE float3(0.275, 0.424, 0.420)
#endif
#ifndef DARK_GOBELIN_BLUE
#define DARK_GOBELIN_BLUE RIDGWAY_DARK_GOBELIN_BLUE
#endif

#ifndef RIDGWAY_DARK_GRAYISH_BLUE_GREEN
#define RIDGWAY_DARK_GRAYISH_BLUE_GREEN float3(0.357, 0.439, 0.475)
#endif
#ifndef DARK_GRAYISH_BLUE_GREEN
#define DARK_GRAYISH_BLUE_GREEN RIDGWAY_DARK_GRAYISH_BLUE_GREEN
#endif

#ifndef RIDGWAY_DARK_GRAYISH_BLUE_VIOLET
#define RIDGWAY_DARK_GRAYISH_BLUE_VIOLET float3(0.302, 0.306, 0.459)
#endif
#ifndef DARK_GRAYISH_BLUE_VIOLET
#define DARK_GRAYISH_BLUE_VIOLET RIDGWAY_DARK_GRAYISH_BLUE_VIOLET
#endif

#ifndef RIDGWAY_DARK_GRAYISH_BROWN
#define RIDGWAY_DARK_GRAYISH_BROWN float3(0.384, 0.369, 0.341)
#endif
#ifndef DARK_GRAYISH_BROWN
#define DARK_GRAYISH_BROWN RIDGWAY_DARK_GRAYISH_BROWN
#endif

#ifndef RIDGWAY_DARK_GRAYISH_LAVENDER
#define RIDGWAY_DARK_GRAYISH_LAVENDER float3(0.588, 0.580, 0.682)
#endif
#ifndef DARK_GRAYISH_LAVENDER
#define DARK_GRAYISH_LAVENDER RIDGWAY_DARK_GRAYISH_LAVENDER
#endif

#ifndef RIDGWAY_DARK_GRAYISH_OLIVE
#define RIDGWAY_DARK_GRAYISH_OLIVE float3(0.345, 0.365, 0.310)
#endif
#ifndef DARK_GRAYISH_OLIVE
#define DARK_GRAYISH_OLIVE RIDGWAY_DARK_GRAYISH_OLIVE
#endif

#ifndef RIDGWAY_DARK_GREEN
#define RIDGWAY_DARK_GREEN float3(0.294, 0.416, 0.337)
#endif
#ifndef DARK_GREEN
#define DARK_GREEN RIDGWAY_DARK_GREEN
#endif

#ifndef RIDGWAY_DARK_GREEN_BLUE_GRAY
#define RIDGWAY_DARK_GREEN_BLUE_GRAY float3(0.412, 0.494, 0.518)
#endif
#ifndef DARK_GREEN_BLUE_GRAY
#define DARK_GREEN_BLUE_GRAY RIDGWAY_DARK_GREEN_BLUE_GRAY
#endif

#ifndef RIDGWAY_DARK_GREEN_BLUE_SLATE
#define RIDGWAY_DARK_GREEN_BLUE_SLATE float3(0.184, 0.310, 0.341)
#endif
#ifndef DARK_GREEN_BLUE_SLATE
#define DARK_GREEN_BLUE_SLATE RIDGWAY_DARK_GREEN_BLUE_SLATE
#endif

#ifndef RIDGWAY_DARK_GREENISH_GLAUCOUS
#define RIDGWAY_DARK_GREENISH_GLAUCOUS float3(0.604, 0.694, 0.569)
#endif
#ifndef DARK_GREENISH_GLAUCOUS
#define DARK_GREENISH_GLAUCOUS RIDGWAY_DARK_GREENISH_GLAUCOUS
#endif

#ifndef RIDGWAY_DARK_GREENISH_OLIVE
#define RIDGWAY_DARK_GREENISH_OLIVE float3(0.365, 0.373, 0.267)
#endif
#ifndef DARK_GREENISH_OLIVE
#define DARK_GREENISH_OLIVE RIDGWAY_DARK_GREENISH_OLIVE
#endif

#ifndef RIDGWAY_DARK_GULL_GRAY
#define RIDGWAY_DARK_GULL_GRAY float3(0.502, 0.522, 0.510)
#endif
#ifndef DARK_GULL_GRAY
#define DARK_GULL_GRAY RIDGWAY_DARK_GULL_GRAY
#endif

#ifndef RIDGWAY_DARK_HELIOTROPE_GRAY
#define RIDGWAY_DARK_HELIOTROPE_GRAY float3(0.498, 0.467, 0.490)
#endif
#ifndef DARK_HELIOTROPE_GRAY
#define DARK_HELIOTROPE_GRAY RIDGWAY_DARK_HELIOTROPE_GRAY
#endif

#ifndef RIDGWAY_DARK_HELIOTROPE_SLATE
#define RIDGWAY_DARK_HELIOTROPE_SLATE float3(0.314, 0.322, 0.333)
#endif
#ifndef DARK_HELIOTROPE_SLATE
#define DARK_HELIOTROPE_SLATE RIDGWAY_DARK_HELIOTROPE_SLATE
#endif

#ifndef RIDGWAY_DARK_HYSSOP_VIOLET
#define RIDGWAY_DARK_HYSSOP_VIOLET float3(0.412, 0.333, 0.424)
#endif
#ifndef DARK_HYSSOP_VIOLET
#define DARK_HYSSOP_VIOLET RIDGWAY_DARK_HYSSOP_VIOLET
#endif

#ifndef RIDGWAY_DARK_INDIAN_RED
#define RIDGWAY_DARK_INDIAN_RED float3(0.431, 0.306, 0.294)
#endif
#ifndef DARK_INDIAN_RED
#define DARK_INDIAN_RED RIDGWAY_DARK_INDIAN_RED
#endif

#ifndef RIDGWAY_DARK_IVY_GREEN
#define RIDGWAY_DARK_IVY_GREEN float3(0.329, 0.365, 0.278)
#endif
#ifndef DARK_IVY_GREEN
#define DARK_IVY_GREEN RIDGWAY_DARK_IVY_GREEN
#endif

#ifndef RIDGWAY_DARK_LAVENDER
#define RIDGWAY_DARK_LAVENDER float3(0.604, 0.537, 0.627)
#endif
#ifndef DARK_LAVENDER
#define DARK_LAVENDER RIDGWAY_DARK_LAVENDER
#endif

#ifndef RIDGWAY_DARK_LIVID_BROWN
#define RIDGWAY_DARK_LIVID_BROWN float3(0.435, 0.329, 0.314)
#endif
#ifndef DARK_LIVID_BROWN
#define DARK_LIVID_BROWN RIDGWAY_DARK_LIVID_BROWN
#endif

#ifndef RIDGWAY_DARK_LIVID_PURPLE
#define RIDGWAY_DARK_LIVID_PURPLE float3(0.365, 0.259, 0.290)
#endif
#ifndef DARK_LIVID_PURPLE
#define DARK_LIVID_PURPLE RIDGWAY_DARK_LIVID_PURPLE
#endif

#ifndef RIDGWAY_DARK_MADDER_BLUE
#define RIDGWAY_DARK_MADDER_BLUE float3(0.322, 0.361, 0.416)
#endif
#ifndef DARK_MADDER_BLUE
#define DARK_MADDER_BLUE RIDGWAY_DARK_MADDER_BLUE
#endif

#ifndef RIDGWAY_DARK_MADDER_VIOLET
#define RIDGWAY_DARK_MADDER_VIOLET float3(0.290, 0.271, 0.349)
#endif
#ifndef DARK_MADDER_VIOLET
#define DARK_MADDER_VIOLET RIDGWAY_DARK_MADDER_VIOLET
#endif

#ifndef RIDGWAY_DARK_MAROON_PURPLE
#define RIDGWAY_DARK_MAROON_PURPLE float3(0.392, 0.263, 0.302)
#endif
#ifndef DARK_MAROON_PURPLE
#define DARK_MAROON_PURPLE RIDGWAY_DARK_MAROON_PURPLE
#endif

#ifndef RIDGWAY_DARK_MEDICI_BLUE
#define RIDGWAY_DARK_MEDICI_BLUE float3(0.353, 0.463, 0.467)
#endif
#ifndef DARK_MEDICI_BLUE
#define DARK_MEDICI_BLUE RIDGWAY_DARK_MEDICI_BLUE
#endif

#ifndef RIDGWAY_DARK_MINERAL_RED
#define RIDGWAY_DARK_MINERAL_RED float3(0.420, 0.318, 0.306)
#endif
#ifndef DARK_MINERAL_RED
#define DARK_MINERAL_RED RIDGWAY_DARK_MINERAL_RED
#endif

#ifndef RIDGWAY_DARK_MOUSE_GRAY
#define RIDGWAY_DARK_MOUSE_GRAY float3(0.314, 0.333, 0.314)
#endif
#ifndef DARK_MOUSE_GRAY
#define DARK_MOUSE_GRAY RIDGWAY_DARK_MOUSE_GRAY
#endif

#ifndef RIDGWAY_DARK_NAPHTHALENE_VIOLET
#define RIDGWAY_DARK_NAPHTHALENE_VIOLET float3(0.333, 0.255, 0.286)
#endif
#ifndef DARK_NAPHTHALENE_VIOLET
#define DARK_NAPHTHALENE_VIOLET RIDGWAY_DARK_NAPHTHALENE_VIOLET
#endif

#ifndef RIDGWAY_DARK_NEUTRAL_GRAY
#define RIDGWAY_DARK_NEUTRAL_GRAY float3(0.298, 0.341, 0.318)
#endif
#ifndef DARK_NEUTRAL_GRAY
#define DARK_NEUTRAL_GRAY RIDGWAY_DARK_NEUTRAL_GRAY
#endif

#ifndef RIDGWAY_DARK_NIGROSIN_VIOLET
#define RIDGWAY_DARK_NIGROSIN_VIOLET float3(0.286, 0.259, 0.318)
#endif
#ifndef DARK_NIGROSIN_VIOLET
#define DARK_NIGROSIN_VIOLET RIDGWAY_DARK_NIGROSIN_VIOLET
#endif

#ifndef RIDGWAY_DARK_OLIVE
#define RIDGWAY_DARK_OLIVE float3(0.337, 0.333, 0.267)
#endif
#ifndef DARK_OLIVE
#define DARK_OLIVE RIDGWAY_DARK_OLIVE
#endif

#ifndef RIDGWAY_DARK_OLIVE_BUFF
#define RIDGWAY_DARK_OLIVE_BUFF float3(0.714, 0.624, 0.404)
#endif
#ifndef DARK_OLIVE_BUFF
#define DARK_OLIVE_BUFF RIDGWAY_DARK_OLIVE_BUFF
#endif

#ifndef RIDGWAY_DARK_OLIVE_GRAY
#define RIDGWAY_DARK_OLIVE_GRAY float3(0.404, 0.424, 0.361)
#endif
#ifndef DARK_OLIVE_GRAY
#define DARK_OLIVE_GRAY RIDGWAY_DARK_OLIVE_GRAY
#endif

#ifndef RIDGWAY_DARK_ORIENT_BLUE
#define RIDGWAY_DARK_ORIENT_BLUE float3(0.263, 0.400, 0.467)
#endif
#ifndef DARK_ORIENT_BLUE
#define DARK_ORIENT_BLUE RIDGWAY_DARK_ORIENT_BLUE
#endif

#ifndef RIDGWAY_DARK_PAYNES_GRAY
#define RIDGWAY_DARK_PAYNES_GRAY float3(0.239, 0.322, 0.357)
#endif
#ifndef DARK_PAYNES_GRAY
#define DARK_PAYNES_GRAY RIDGWAY_DARK_PAYNES_GRAY
#endif

#ifndef RIDGWAY_DARK_PERILLA_PURPLE
#define RIDGWAY_DARK_PERILLA_PURPLE float3(0.396, 0.251, 0.267)
#endif
#ifndef DARK_PERILLA_PURPLE
#define DARK_PERILLA_PURPLE RIDGWAY_DARK_PERILLA_PURPLE
#endif

#ifndef RIDGWAY_DARK_PLUMBAGO_BLUE
#define RIDGWAY_DARK_PLUMBAGO_BLUE float3(0.569, 0.580, 0.682)
#endif
#ifndef DARK_PLUMBAGO_BLUE
#define DARK_PLUMBAGO_BLUE RIDGWAY_DARK_PLUMBAGO_BLUE
#endif

#ifndef RIDGWAY_DARK_PLUMBAGO_GRAY
#define RIDGWAY_DARK_PLUMBAGO_GRAY float3(0.471, 0.478, 0.529)
#endif
#ifndef DARK_PLUMBAGO_GRAY
#define DARK_PLUMBAGO_GRAY RIDGWAY_DARK_PLUMBAGO_GRAY
#endif

#ifndef RIDGWAY_DARK_PLUMBAGO_SLATE
#define RIDGWAY_DARK_PLUMBAGO_SLATE float3(0.286, 0.306, 0.329)
#endif
#ifndef DARK_PLUMBAGO_SLATE
#define DARK_PLUMBAGO_SLATE RIDGWAY_DARK_PLUMBAGO_SLATE
#endif

#ifndef RIDGWAY_DARK_PLUMBEOUS
#define RIDGWAY_DARK_PLUMBEOUS float3(0.369, 0.416, 0.424)
#endif
#ifndef DARK_PLUMBEOUS
#define DARK_PLUMBEOUS RIDGWAY_DARK_PLUMBEOUS
#endif

#ifndef RIDGWAY_DARK_PORCELAIN_GREEN
#define RIDGWAY_DARK_PORCELAIN_GREEN float3(0.302, 0.435, 0.384)
#endif
#ifndef DARK_PORCELAIN_GREEN
#define DARK_PORCELAIN_GREEN RIDGWAY_DARK_PORCELAIN_GREEN
#endif

#ifndef RIDGWAY_DARK_PURPLE_DRAB
#define RIDGWAY_DARK_PURPLE_DRAB float3(0.431, 0.369, 0.349)
#endif
#ifndef DARK_PURPLE_DRAB
#define DARK_PURPLE_DRAB RIDGWAY_DARK_PURPLE_DRAB
#endif

#ifndef RIDGWAY_DARK_PURPLISH_GRAY
#define RIDGWAY_DARK_PURPLISH_GRAY float3(0.322, 0.353, 0.349)
#endif
#ifndef DARK_PURPLISH_GRAY
#define DARK_PURPLISH_GRAY RIDGWAY_DARK_PURPLISH_GRAY
#endif

#ifndef RIDGWAY_DARK_QUAKER_DRAB
#define RIDGWAY_DARK_QUAKER_DRAB float3(0.314, 0.333, 0.314)
#endif
#ifndef DARK_QUAKER_DRAB
#define DARK_QUAKER_DRAB RIDGWAY_DARK_QUAKER_DRAB
#endif

#ifndef RIDGWAY_DARK_RUSSIAN_GREEN
#define RIDGWAY_DARK_RUSSIAN_GREEN float3(0.255, 0.408, 0.369)
#endif
#ifndef DARK_RUSSIAN_GREEN
#define DARK_RUSSIAN_GREEN RIDGWAY_DARK_RUSSIAN_GREEN
#endif

#ifndef RIDGWAY_DARK_SLATE_PURPLE
#define RIDGWAY_DARK_SLATE_PURPLE float3(0.388, 0.337, 0.369)
#endif
#ifndef DARK_SLATE_PURPLE
#define DARK_SLATE_PURPLE RIDGWAY_DARK_SLATE_PURPLE
#endif

#ifndef RIDGWAY_DARK_SLATE_VIOLET_1
#define RIDGWAY_DARK_SLATE_VIOLET_1 float3(0.341, 0.341, 0.388)
#endif
#ifndef DARK_SLATE_VIOLET_1
#define DARK_SLATE_VIOLET_1 RIDGWAY_DARK_SLATE_VIOLET_1
#endif

#ifndef RIDGWAY_DARK_SLATE_VIOLET_2
#define RIDGWAY_DARK_SLATE_VIOLET_2 float3(0.337, 0.318, 0.365)
#endif
#ifndef DARK_SLATE_VIOLET_2
#define DARK_SLATE_VIOLET_2 RIDGWAY_DARK_SLATE_VIOLET_2
#endif

#ifndef RIDGWAY_DARK_SOFT_BLUE_VIOLET
#define RIDGWAY_DARK_SOFT_BLUE_VIOLET float3(0.349, 0.345, 0.561)
#endif
#ifndef DARK_SOFT_BLUE_VIOLET
#define DARK_SOFT_BLUE_VIOLET RIDGWAY_DARK_SOFT_BLUE_VIOLET
#endif

#ifndef RIDGWAY_DARK_SOFT_BLUISH_VIOLET
#define RIDGWAY_DARK_SOFT_BLUISH_VIOLET float3(0.400, 0.345, 0.553)
#endif
#ifndef DARK_SOFT_BLUISH_VIOLET
#define DARK_SOFT_BLUISH_VIOLET RIDGWAY_DARK_SOFT_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_DARK_SULPHATE_GREEN
#define RIDGWAY_DARK_SULPHATE_GREEN float3(0.286, 0.553, 0.478)
#endif
#ifndef DARK_SULPHATE_GREEN
#define DARK_SULPHATE_GREEN RIDGWAY_DARK_SULPHATE_GREEN
#endif

#ifndef RIDGWAY_DARK_TERRE_VERTE
#define RIDGWAY_DARK_TERRE_VERTE float3(0.282, 0.424, 0.384)
#endif
#ifndef DARK_TERRE_VERTE
#define DARK_TERRE_VERTE RIDGWAY_DARK_TERRE_VERTE
#endif

#ifndef RIDGWAY_DARK_TYRIAN_BLUE
#define RIDGWAY_DARK_TYRIAN_BLUE float3(0.290, 0.392, 0.498)
#endif
#ifndef DARK_TYRIAN_BLUE
#define DARK_TYRIAN_BLUE RIDGWAY_DARK_TYRIAN_BLUE
#endif

#ifndef RIDGWAY_DARK_VARLEYS_GRAY
#define RIDGWAY_DARK_VARLEYS_GRAY float3(0.282, 0.318, 0.349)
#endif
#ifndef DARK_VARLEYS_GRAY
#define DARK_VARLEYS_GRAY RIDGWAY_DARK_VARLEYS_GRAY
#endif

#ifndef RIDGWAY_DARK_VINACEOUS
#define RIDGWAY_DARK_VINACEOUS float3(0.643, 0.392, 0.392)
#endif
#ifndef DARK_VINACEOUS
#define DARK_VINACEOUS RIDGWAY_DARK_VINACEOUS
#endif

#ifndef RIDGWAY_DARK_VINACEOUS_BROWN
#define RIDGWAY_DARK_VINACEOUS_BROWN float3(0.451, 0.341, 0.314)
#endif
#ifndef DARK_VINACEOUS_BROWN
#define DARK_VINACEOUS_BROWN RIDGWAY_DARK_VINACEOUS_BROWN
#endif

#ifndef RIDGWAY_DARK_VINACEOUS_DRAB
#define RIDGWAY_DARK_VINACEOUS_DRAB float3(0.463, 0.400, 0.369)
#endif
#ifndef DARK_VINACEOUS_DRAB
#define DARK_VINACEOUS_DRAB RIDGWAY_DARK_VINACEOUS_DRAB
#endif

#ifndef RIDGWAY_DARK_VINACEOUS_GRAY
#define RIDGWAY_DARK_VINACEOUS_GRAY float3(0.514, 0.471, 0.478)
#endif
#ifndef DARK_VINACEOUS_GRAY
#define DARK_VINACEOUS_GRAY RIDGWAY_DARK_VINACEOUS_GRAY
#endif

#ifndef RIDGWAY_DARK_VINACEOUS_PURPLE
#define RIDGWAY_DARK_VINACEOUS_PURPLE float3(0.482, 0.294, 0.318)
#endif
#ifndef DARK_VINACEOUS_PURPLE
#define DARK_VINACEOUS_PURPLE RIDGWAY_DARK_VINACEOUS_PURPLE
#endif

#ifndef RIDGWAY_DARK_VIOLET
#define RIDGWAY_DARK_VIOLET float3(0.325, 0.298, 0.486)
#endif
#ifndef DARK_VIOLET
#define DARK_VIOLET RIDGWAY_DARK_VIOLET
#endif

#ifndef RIDGWAY_DARK_VIOLET_GRAY
#define RIDGWAY_DARK_VIOLET_GRAY float3(0.298, 0.325, 0.341)
#endif
#ifndef DARK_VIOLET_GRAY
#define DARK_VIOLET_GRAY RIDGWAY_DARK_VIOLET_GRAY
#endif

#ifndef RIDGWAY_DARK_VIOLET_SLATE
#define RIDGWAY_DARK_VIOLET_SLATE float3(0.278, 0.329, 0.365)
#endif
#ifndef DARK_VIOLET_SLATE
#define DARK_VIOLET_SLATE RIDGWAY_DARK_VIOLET_SLATE
#endif

#ifndef RIDGWAY_DARK_VIRIDIAN_GREEN
#define RIDGWAY_DARK_VIRIDIAN_GREEN float3(0.063, 0.498, 0.427)
#endif
#ifndef DARK_VIRIDIAN_GREEN
#define DARK_VIRIDIAN_GREEN RIDGWAY_DARK_VIRIDIAN_GREEN
#endif

#ifndef RIDGWAY_DARK_YELLOWISH_GREEN
#define RIDGWAY_DARK_YELLOWISH_GREEN float3(0.318, 0.420, 0.329)
#endif
#ifndef DARK_YELLOWISH_GREEN
#define DARK_YELLOWISH_GREEN RIDGWAY_DARK_YELLOWISH_GREEN
#endif

#ifndef RIDGWAY_DARK_YVETTE_VIOLET
#define RIDGWAY_DARK_YVETTE_VIOLET float3(0.278, 0.278, 0.329)
#endif
#ifndef DARK_YVETTE_VIOLET
#define DARK_YVETTE_VIOLET RIDGWAY_DARK_YVETTE_VIOLET
#endif

#ifndef RIDGWAY_DARK_ZINC_GREEN
#define RIDGWAY_DARK_ZINC_GREEN float3(0.298, 0.471, 0.400)
#endif
#ifndef DARK_ZINC_GREEN
#define DARK_ZINC_GREEN RIDGWAY_DARK_ZINC_GREEN
#endif

#ifndef RIDGWAY_DAUPHINS_VIOLET
#define RIDGWAY_DAUPHINS_VIOLET float3(0.447, 0.361, 0.573)
#endif
#ifndef DAUPHINS_VIOLET
#define DAUPHINS_VIOLET RIDGWAY_DAUPHINS_VIOLET
#endif

#ifndef RIDGWAY_DAWN_GRAY
#define RIDGWAY_DAWN_GRAY float3(0.624, 0.643, 0.608)
#endif
#ifndef DAWN_GRAY
#define DAWN_GRAY RIDGWAY_DAWN_GRAY
#endif

#ifndef RIDGWAY_DEEP_ANILINE_LILAC
#define RIDGWAY_DEEP_ANILINE_LILAC float3(0.569, 0.616, 0.765)
#endif
#ifndef DEEP_ANILINE_LILAC
#define DEEP_ANILINE_LILAC RIDGWAY_DEEP_ANILINE_LILAC
#endif

#ifndef RIDGWAY_DEEP_BLUE_VIOLET
#define RIDGWAY_DEEP_BLUE_VIOLET float3(0.318, 0.306, 0.624)
#endif
#ifndef DEEP_BLUE_VIOLET
#define DEEP_BLUE_VIOLET RIDGWAY_DEEP_BLUE_VIOLET
#endif

#ifndef RIDGWAY_DEEP_BLUISH_GLAUCOUS
#define RIDGWAY_DEEP_BLUISH_GLAUCOUS float3(0.643, 0.769, 0.733)
#endif
#ifndef DEEP_BLUISH_GLAUCOUS
#define DEEP_BLUISH_GLAUCOUS RIDGWAY_DEEP_BLUISH_GLAUCOUS
#endif

#ifndef RIDGWAY_DEEP_BLUISH_GRAY_GREEN
#define RIDGWAY_DEEP_BLUISH_GRAY_GREEN float3(0.392, 0.502, 0.486)
#endif
#ifndef DEEP_BLUISH_GRAY_GREEN
#define DEEP_BLUISH_GRAY_GREEN RIDGWAY_DEEP_BLUISH_GRAY_GREEN
#endif

#ifndef RIDGWAY_DEEP_BROWNISH_DRAB
#define RIDGWAY_DEEP_BROWNISH_DRAB float3(0.486, 0.420, 0.373)
#endif
#ifndef DEEP_BROWNISH_DRAB
#define DEEP_BROWNISH_DRAB RIDGWAY_DEEP_BROWNISH_DRAB
#endif

#ifndef RIDGWAY_DEEP_BROWNISH_VINACEOUS
#define RIDGWAY_DEEP_BROWNISH_VINACEOUS float3(0.690, 0.486, 0.443)
#endif
#ifndef DEEP_BROWNISH_VINACEOUS
#define DEEP_BROWNISH_VINACEOUS RIDGWAY_DEEP_BROWNISH_VINACEOUS
#endif

#ifndef RIDGWAY_DEEP_CADET_BLUE
#define RIDGWAY_DEEP_CADET_BLUE float3(0.306, 0.420, 0.608)
#endif
#ifndef DEEP_CADET_BLUE
#define DEEP_CADET_BLUE RIDGWAY_DEEP_CADET_BLUE
#endif

#ifndef RIDGWAY_DEEP_CHICORY_BLUE
#define RIDGWAY_DEEP_CHICORY_BLUE float3(0.502, 0.545, 0.808)
#endif
#ifndef DEEP_CHICORY_BLUE
#define DEEP_CHICORY_BLUE RIDGWAY_DEEP_CHICORY_BLUE
#endif

#ifndef RIDGWAY_DEEP_CHROME
#define RIDGWAY_DEEP_CHROME float3(0.996, 0.698, 0.224)
#endif
#ifndef DEEP_CHROME
#define DEEP_CHROME RIDGWAY_DEEP_CHROME
#endif

#ifndef RIDGWAY_DEEP_CHRYSOLITE_GREEN
#define RIDGWAY_DEEP_CHRYSOLITE_GREEN float3(0.686, 0.710, 0.396)
#endif
#ifndef DEEP_CHRYSOLITE_GREEN
#define DEEP_CHRYSOLITE_GREEN RIDGWAY_DEEP_CHRYSOLITE_GREEN
#endif

#ifndef RIDGWAY_DEEP_COLONIAL_BUFF
#define RIDGWAY_DEEP_COLONIAL_BUFF float3(0.831, 0.675, 0.443)
#endif
#ifndef DEEP_COLONIAL_BUFF
#define DEEP_COLONIAL_BUFF RIDGWAY_DEEP_COLONIAL_BUFF
#endif

#ifndef RIDGWAY_DEEP_CORINTHIAN_RED
#define RIDGWAY_DEEP_CORINTHIAN_RED float3(0.624, 0.376, 0.353)
#endif
#ifndef DEEP_CORINTHIAN_RED
#define DEEP_CORINTHIAN_RED RIDGWAY_DEEP_CORINTHIAN_RED
#endif

#ifndef RIDGWAY_DEEP_DELFT_BLUE
#define RIDGWAY_DEEP_DELFT_BLUE float3(0.204, 0.361, 0.416)
#endif
#ifndef DEEP_DELFT_BLUE
#define DEEP_DELFT_BLUE RIDGWAY_DEEP_DELFT_BLUE
#endif

#ifndef RIDGWAY_DEEP_DULL_BLUISH_VIOLET_1
#define RIDGWAY_DEEP_DULL_BLUISH_VIOLET_1 float3(0.361, 0.353, 0.533)
#endif
#ifndef DEEP_DULL_BLUISH_VIOLET_1
#define DEEP_DULL_BLUISH_VIOLET_1 RIDGWAY_DEEP_DULL_BLUISH_VIOLET_1
#endif

#ifndef RIDGWAY_DEEP_DULL_BLUISH_VIOLET_2
#define RIDGWAY_DEEP_DULL_BLUISH_VIOLET_2 float3(0.404, 0.427, 0.565)
#endif
#ifndef DEEP_DULL_BLUISH_VIOLET_2
#define DEEP_DULL_BLUISH_VIOLET_2 RIDGWAY_DEEP_DULL_BLUISH_VIOLET_2
#endif

#ifndef RIDGWAY_DEEP_DULL_BLUISH_VIOLET_3
#define RIDGWAY_DEEP_DULL_BLUISH_VIOLET_3 float3(0.427, 0.376, 0.502)
#endif
#ifndef DEEP_DULL_BLUISH_VIOLET_3
#define DEEP_DULL_BLUISH_VIOLET_3 RIDGWAY_DEEP_DULL_BLUISH_VIOLET_3
#endif

#ifndef RIDGWAY_DEEP_DULL_LAVENDER
#define RIDGWAY_DEEP_DULL_LAVENDER float3(0.675, 0.612, 0.678)
#endif
#ifndef DEEP_DULL_LAVENDER
#define DEEP_DULL_LAVENDER RIDGWAY_DEEP_DULL_LAVENDER
#endif

#ifndef RIDGWAY_DEEP_DULL_VIOLACEOUS_BLUE
#define RIDGWAY_DEEP_DULL_VIOLACEOUS_BLUE float3(0.278, 0.329, 0.490)
#endif
#ifndef DEEP_DULL_VIOLACEOUS_BLUE
#define DEEP_DULL_VIOLACEOUS_BLUE RIDGWAY_DEEP_DULL_VIOLACEOUS_BLUE
#endif

#ifndef RIDGWAY_DEEP_DULL_VIOLET_BLUE
#define RIDGWAY_DEEP_DULL_VIOLET_BLUE float3(0.427, 0.420, 0.553)
#endif
#ifndef DEEP_DULL_VIOLET_BLUE
#define DEEP_DULL_VIOLET_BLUE RIDGWAY_DEEP_DULL_VIOLET_BLUE
#endif

#ifndef RIDGWAY_DEEP_DULL_YELLOW_GREEN_1
#define RIDGWAY_DEEP_DULL_YELLOW_GREEN_1 float3(0.427, 0.498, 0.353)
#endif
#ifndef DEEP_DULL_YELLOW_GREEN_1
#define DEEP_DULL_YELLOW_GREEN_1 RIDGWAY_DEEP_DULL_YELLOW_GREEN_1
#endif

#ifndef RIDGWAY_DEEP_DULL_YELLOW_GREEN_2
#define RIDGWAY_DEEP_DULL_YELLOW_GREEN_2 float3(0.388, 0.498, 0.380)
#endif
#ifndef DEEP_DULL_YELLOW_GREEN_2
#define DEEP_DULL_YELLOW_GREEN_2 RIDGWAY_DEEP_DULL_YELLOW_GREEN_2
#endif

#ifndef RIDGWAY_DEEP_DUTCH_BLUE
#define RIDGWAY_DEEP_DUTCH_BLUE float3(0.467, 0.529, 0.612)
#endif
#ifndef DEEP_DUTCH_BLUE
#define DEEP_DUTCH_BLUE RIDGWAY_DEEP_DUTCH_BLUE
#endif

#ifndef RIDGWAY_DEEP_GLAUCOUS_GRAY
#define RIDGWAY_DEEP_GLAUCOUS_GRAY float3(0.545, 0.627, 0.624)
#endif
#ifndef DEEP_GLAUCOUS_GRAY
#define DEEP_GLAUCOUS_GRAY RIDGWAY_DEEP_GLAUCOUS_GRAY
#endif

#ifndef RIDGWAY_DEEP_GLAUCOUS_GREEN
#define RIDGWAY_DEEP_GLAUCOUS_GREEN float3(0.604, 0.714, 0.608)
#endif
#ifndef DEEP_GLAUCOUS_GREEN
#define DEEP_GLAUCOUS_GREEN RIDGWAY_DEEP_GLAUCOUS_GREEN
#endif

#ifndef RIDGWAY_DEEP_GRAPE_GREEN
#define RIDGWAY_DEEP_GRAPE_GREEN float3(0.533, 0.549, 0.396)
#endif
#ifndef DEEP_GRAPE_GREEN
#define DEEP_GRAPE_GREEN RIDGWAY_DEEP_GRAPE_GREEN
#endif

#ifndef RIDGWAY_DEEP_GRAYISH_BLUE_GREEN
#define RIDGWAY_DEEP_GRAYISH_BLUE_GREEN float3(0.373, 0.463, 0.447)
#endif
#ifndef DEEP_GRAYISH_BLUE_GREEN
#define DEEP_GRAYISH_BLUE_GREEN RIDGWAY_DEEP_GRAYISH_BLUE_GREEN
#endif

#ifndef RIDGWAY_DEEP_GRAYISH_LAVENDER
#define RIDGWAY_DEEP_GRAYISH_LAVENDER float3(0.671, 0.639, 0.706)
#endif
#ifndef DEEP_GRAYISH_LAVENDER
#define DEEP_GRAYISH_LAVENDER RIDGWAY_DEEP_GRAYISH_LAVENDER
#endif

#ifndef RIDGWAY_DEEP_GRAYISH_OLIVE
#define RIDGWAY_DEEP_GRAYISH_OLIVE float3(0.486, 0.475, 0.396)
#endif
#ifndef DEEP_GRAYISH_OLIVE
#define DEEP_GRAYISH_OLIVE RIDGWAY_DEEP_GRAYISH_OLIVE
#endif

#ifndef RIDGWAY_DEEP_GREEN_BLUE_GRAY
#define RIDGWAY_DEEP_GREEN_BLUE_GRAY float3(0.455, 0.549, 0.565)
#endif
#ifndef DEEP_GREEN_BLUE_GRAY
#define DEEP_GREEN_BLUE_GRAY RIDGWAY_DEEP_GREEN_BLUE_GRAY
#endif

#ifndef RIDGWAY_DEEP_GREENISH_GLAUCOUS
#define RIDGWAY_DEEP_GREENISH_GLAUCOUS float3(0.659, 0.780, 0.682)
#endif
#ifndef DEEP_GREENISH_GLAUCOUS
#define DEEP_GREENISH_GLAUCOUS RIDGWAY_DEEP_GREENISH_GLAUCOUS
#endif

#ifndef RIDGWAY_DEEP_GULL_GRAY
#define RIDGWAY_DEEP_GULL_GRAY float3(0.545, 0.561, 0.545)
#endif
#ifndef DEEP_GULL_GRAY
#define DEEP_GULL_GRAY RIDGWAY_DEEP_GULL_GRAY
#endif

#ifndef RIDGWAY_DEEP_HELIOTROPE_GRAY
#define RIDGWAY_DEEP_HELIOTROPE_GRAY float3(0.553, 0.529, 0.569)
#endif
#ifndef DEEP_HELIOTROPE_GRAY
#define DEEP_HELIOTROPE_GRAY RIDGWAY_DEEP_HELIOTROPE_GRAY
#endif

#ifndef RIDGWAY_DEEP_HELLEBORE_RED
#define RIDGWAY_DEEP_HELLEBORE_RED float3(0.624, 0.361, 0.400)
#endif
#ifndef DEEP_HELLEBORE_RED
#define DEEP_HELLEBORE_RED RIDGWAY_DEEP_HELLEBORE_RED
#endif

#ifndef RIDGWAY_DEEP_HYSSOP_VIOLET
#define RIDGWAY_DEEP_HYSSOP_VIOLET float3(0.475, 0.396, 0.514)
#endif
#ifndef DEEP_HYSSOP_VIOLET
#define DEEP_HYSSOP_VIOLET RIDGWAY_DEEP_HYSSOP_VIOLET
#endif

#ifndef RIDGWAY_DEEP_LAVENDER
#define RIDGWAY_DEEP_LAVENDER float3(0.729, 0.663, 0.769)
#endif
#ifndef DEEP_LAVENDER
#define DEEP_LAVENDER RIDGWAY_DEEP_LAVENDER
#endif

#ifndef RIDGWAY_DEEP_LAVENDER_BLUE
#define RIDGWAY_DEEP_LAVENDER_BLUE float3(0.573, 0.604, 0.878)
#endif
#ifndef DEEP_LAVENDER_BLUE
#define DEEP_LAVENDER_BLUE RIDGWAY_DEEP_LAVENDER_BLUE
#endif

#ifndef RIDGWAY_DEEP_LICHEN_GREEN
#define RIDGWAY_DEEP_LICHEN_GREEN float3(0.718, 0.765, 0.651)
#endif
#ifndef DEEP_LICHEN_GREEN
#define DEEP_LICHEN_GREEN RIDGWAY_DEEP_LICHEN_GREEN
#endif

#ifndef RIDGWAY_DEEP_LIVID_BROWN
#define RIDGWAY_DEEP_LIVID_BROWN float3(0.525, 0.380, 0.369)
#endif
#ifndef DEEP_LIVID_BROWN
#define DEEP_LIVID_BROWN RIDGWAY_DEEP_LIVID_BROWN
#endif

#ifndef RIDGWAY_DEEP_LIVID_PURPLE
#define RIDGWAY_DEEP_LIVID_PURPLE float3(0.478, 0.322, 0.380)
#endif
#ifndef DEEP_LIVID_PURPLE
#define DEEP_LIVID_PURPLE RIDGWAY_DEEP_LIVID_PURPLE
#endif

#ifndef RIDGWAY_DEEP_MADDER_BLUE
#define RIDGWAY_DEEP_MADDER_BLUE float3(0.392, 0.427, 0.502)
#endif
#ifndef DEEP_MADDER_BLUE
#define DEEP_MADDER_BLUE RIDGWAY_DEEP_MADDER_BLUE
#endif

#ifndef RIDGWAY_DEEP_MALACHITE_GREEN
#define RIDGWAY_DEEP_MALACHITE_GREEN float3(0.451, 0.631, 0.510)
#endif
#ifndef DEEP_MALACHITE_GREEN
#define DEEP_MALACHITE_GREEN RIDGWAY_DEEP_MALACHITE_GREEN
#endif

#ifndef RIDGWAY_DEEP_MEDICI_BLUE
#define RIDGWAY_DEEP_MEDICI_BLUE float3(0.424, 0.518, 0.518)
#endif
#ifndef DEEP_MEDICI_BLUE
#define DEEP_MEDICI_BLUE RIDGWAY_DEEP_MEDICI_BLUE
#endif

#ifndef RIDGWAY_DEEP_MOUSE_GRAY
#define RIDGWAY_DEEP_MOUSE_GRAY float3(0.408, 0.420, 0.380)
#endif
#ifndef DEEP_MOUSE_GRAY
#define DEEP_MOUSE_GRAY RIDGWAY_DEEP_MOUSE_GRAY
#endif

#ifndef RIDGWAY_DEEP_NEUTRAL_GRAY
#define RIDGWAY_DEEP_NEUTRAL_GRAY float3(0.384, 0.408, 0.388)
#endif
#ifndef DEEP_NEUTRAL_GRAY
#define DEEP_NEUTRAL_GRAY RIDGWAY_DEEP_NEUTRAL_GRAY
#endif

#ifndef RIDGWAY_DEEP_OLIVE
#define RIDGWAY_DEEP_OLIVE float3(0.447, 0.416, 0.318)
#endif
#ifndef DEEP_OLIVE
#define DEEP_OLIVE RIDGWAY_DEEP_OLIVE
#endif

#ifndef RIDGWAY_DEEP_OLIVE_BUFF
#define RIDGWAY_DEEP_OLIVE_BUFF float3(0.776, 0.694, 0.541)
#endif
#ifndef DEEP_OLIVE_BUFF
#define DEEP_OLIVE_BUFF RIDGWAY_DEEP_OLIVE_BUFF
#endif

#ifndef RIDGWAY_DEEP_OLIVE_GRAY
#define RIDGWAY_DEEP_OLIVE_GRAY float3(0.541, 0.545, 0.475)
#endif
#ifndef DEEP_OLIVE_GRAY
#define DEEP_OLIVE_GRAY RIDGWAY_DEEP_OLIVE_GRAY
#endif

#ifndef RIDGWAY_DEEP_ORIENT_BLUE
#define RIDGWAY_DEEP_ORIENT_BLUE float3(0.388, 0.506, 0.584)
#endif
#ifndef DEEP_ORIENT_BLUE
#define DEEP_ORIENT_BLUE RIDGWAY_DEEP_ORIENT_BLUE
#endif

#ifndef RIDGWAY_DEEP_PAYNES_GRAY
#define RIDGWAY_DEEP_PAYNES_GRAY float3(0.361, 0.427, 0.451)
#endif
#ifndef DEEP_PAYNES_GRAY
#define DEEP_PAYNES_GRAY RIDGWAY_DEEP_PAYNES_GRAY
#endif

#ifndef RIDGWAY_DEEP_PLUMBAGO_BLUE
#define RIDGWAY_DEEP_PLUMBAGO_BLUE float3(0.655, 0.655, 0.733)
#endif
#ifndef DEEP_PLUMBAGO_BLUE
#define DEEP_PLUMBAGO_BLUE RIDGWAY_DEEP_PLUMBAGO_BLUE
#endif

#ifndef RIDGWAY_DEEP_PLUMBAGO_GRAY
#define RIDGWAY_DEEP_PLUMBAGO_GRAY float3(0.525, 0.525, 0.557)
#endif
#ifndef DEEP_PLUMBAGO_GRAY
#define DEEP_PLUMBAGO_GRAY RIDGWAY_DEEP_PLUMBAGO_GRAY
#endif

#ifndef RIDGWAY_DEEP_PLUMBEOUS
#define RIDGWAY_DEEP_PLUMBEOUS float3(0.502, 0.525, 0.545)
#endif
#ifndef DEEP_PLUMBEOUS
#define DEEP_PLUMBEOUS RIDGWAY_DEEP_PLUMBEOUS
#endif

#ifndef RIDGWAY_DEEP_PURPLISH_GRAY
#define RIDGWAY_DEEP_PURPLISH_GRAY float3(0.404, 0.420, 0.408)
#endif
#ifndef DEEP_PURPLISH_GRAY
#define DEEP_PURPLISH_GRAY RIDGWAY_DEEP_PURPLISH_GRAY
#endif

#ifndef RIDGWAY_DEEP_PURPLISH_VINACEOUS
#define RIDGWAY_DEEP_PURPLISH_VINACEOUS float3(0.561, 0.404, 0.431)
#endif
#ifndef DEEP_PURPLISH_VINACEOUS
#define DEEP_PURPLISH_VINACEOUS RIDGWAY_DEEP_PURPLISH_VINACEOUS
#endif

#ifndef RIDGWAY_DEEP_QUAKER_DRAB
#define RIDGWAY_DEEP_QUAKER_DRAB float3(0.435, 0.439, 0.408)
#endif
#ifndef DEEP_QUAKER_DRAB
#define DEEP_QUAKER_DRAB RIDGWAY_DEEP_QUAKER_DRAB
#endif

#ifndef RIDGWAY_DEEP_ROSE_PINK
#define RIDGWAY_DEEP_ROSE_PINK float3(0.973, 0.573, 0.741)
#endif
#ifndef DEEP_ROSE_PINK
#define DEEP_ROSE_PINK RIDGWAY_DEEP_ROSE_PINK
#endif

#ifndef RIDGWAY_DEEP_SEAFOAM_GREEN
#define RIDGWAY_DEEP_SEAFOAM_GREEN float3(0.855, 0.808, 0.561)
#endif
#ifndef DEEP_SEAFOAM_GREEN
#define DEEP_SEAFOAM_GREEN RIDGWAY_DEEP_SEAFOAM_GREEN
#endif

#ifndef RIDGWAY_DEEP_SLATE_BLUE
#define RIDGWAY_DEEP_SLATE_BLUE float3(0.282, 0.357, 0.424)
#endif
#ifndef DEEP_SLATE_BLUE
#define DEEP_SLATE_BLUE RIDGWAY_DEEP_SLATE_BLUE
#endif

#ifndef RIDGWAY_DEEP_SLATE_GREEN
#define RIDGWAY_DEEP_SLATE_GREEN float3(0.278, 0.353, 0.318)
#endif
#ifndef DEEP_SLATE_GREEN
#define DEEP_SLATE_GREEN RIDGWAY_DEEP_SLATE_GREEN
#endif

#ifndef RIDGWAY_DEEP_SLATE_OLIVE
#define RIDGWAY_DEEP_SLATE_OLIVE float3(0.318, 0.373, 0.322)
#endif
#ifndef DEEP_SLATE_OLIVE
#define DEEP_SLATE_OLIVE RIDGWAY_DEEP_SLATE_OLIVE
#endif

#ifndef RIDGWAY_DEEP_SLATE_VIOLET
#define RIDGWAY_DEEP_SLATE_VIOLET float3(0.408, 0.365, 0.435)
#endif
#ifndef DEEP_SLATE_VIOLET
#define DEEP_SLATE_VIOLET RIDGWAY_DEEP_SLATE_VIOLET
#endif

#ifndef RIDGWAY_DEEP_SLATY_BROWN
#define RIDGWAY_DEEP_SLATY_BROWN float3(0.322, 0.318, 0.322)
#endif
#ifndef DEEP_SLATY_BROWN
#define DEEP_SLATY_BROWN RIDGWAY_DEEP_SLATY_BROWN
#endif

#ifndef RIDGWAY_DEEP_SOFT_BLUE_VIOLET
#define RIDGWAY_DEEP_SOFT_BLUE_VIOLET float3(0.404, 0.400, 0.631)
#endif
#ifndef DEEP_SOFT_BLUE_VIOLET
#define DEEP_SOFT_BLUE_VIOLET RIDGWAY_DEEP_SOFT_BLUE_VIOLET
#endif

#ifndef RIDGWAY_DEEP_SOFT_BLUISH_VIOLET
#define RIDGWAY_DEEP_SOFT_BLUISH_VIOLET float3(0.431, 0.384, 0.604)
#endif
#ifndef DEEP_SOFT_BLUISH_VIOLET
#define DEEP_SOFT_BLUISH_VIOLET RIDGWAY_DEEP_SOFT_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_DEEP_TURTLE_GREEN
#define RIDGWAY_DEEP_TURTLE_GREEN float3(0.537, 0.671, 0.455)
#endif
#ifndef DEEP_TURTLE_GREEN
#define DEEP_TURTLE_GREEN RIDGWAY_DEEP_TURTLE_GREEN
#endif

#ifndef RIDGWAY_DEEP_VARLEYS_GRAY
#define RIDGWAY_DEEP_VARLEYS_GRAY float3(0.388, 0.412, 0.435)
#endif
#ifndef DEEP_VARLEYS_GRAY
#define DEEP_VARLEYS_GRAY RIDGWAY_DEEP_VARLEYS_GRAY
#endif

#ifndef RIDGWAY_DEEP_VINACEOUS
#define RIDGWAY_DEEP_VINACEOUS float3(0.686, 0.463, 0.471)
#endif
#ifndef DEEP_VINACEOUS
#define DEEP_VINACEOUS RIDGWAY_DEEP_VINACEOUS
#endif

#ifndef RIDGWAY_DEEP_VINACEOUS_GRAY
#define RIDGWAY_DEEP_VINACEOUS_GRAY float3(0.588, 0.541, 0.557)
#endif
#ifndef DEEP_VINACEOUS_GRAY
#define DEEP_VINACEOUS_GRAY RIDGWAY_DEEP_VINACEOUS_GRAY
#endif

#ifndef RIDGWAY_DEEP_VINACEOUS_LAVENDER
#define RIDGWAY_DEEP_VINACEOUS_LAVENDER float3(0.710, 0.631, 0.690)
#endif
#ifndef DEEP_VINACEOUS_LAVENDER
#define DEEP_VINACEOUS_LAVENDER RIDGWAY_DEEP_VINACEOUS_LAVENDER
#endif

#ifndef RIDGWAY_DEEP_VIOLET_GRAY
#define RIDGWAY_DEEP_VIOLET_GRAY float3(0.376, 0.404, 0.416)
#endif
#ifndef DEEP_VIOLET_GRAY
#define DEEP_VIOLET_GRAY RIDGWAY_DEEP_VIOLET_GRAY
#endif

#ifndef RIDGWAY_DEEP_VIOLET_PLUMBEOUS
#define RIDGWAY_DEEP_VIOLET_PLUMBEOUS float3(0.467, 0.498, 0.545)
#endif
#ifndef DEEP_VIOLET_PLUMBEOUS
#define DEEP_VIOLET_PLUMBEOUS RIDGWAY_DEEP_VIOLET_PLUMBEOUS
#endif

#ifndef RIDGWAY_DEEP_WEDGEWOOD_BLUE
#define RIDGWAY_DEEP_WEDGEWOOD_BLUE float3(0.671, 0.722, 0.941)
#endif
#ifndef DEEP_WEDGEWOOD_BLUE
#define DEEP_WEDGEWOOD_BLUE RIDGWAY_DEEP_WEDGEWOOD_BLUE
#endif

#ifndef RIDGWAY_DELFT_BLUE
#define RIDGWAY_DELFT_BLUE float3(0.369, 0.478, 0.541)
#endif
#ifndef DELFT_BLUE
#define DELFT_BLUE RIDGWAY_DELFT_BLUE
#endif

#ifndef RIDGWAY_DIAMIN_AZO_BLUE
#define RIDGWAY_DIAMIN_AZO_BLUE float3(0.282, 0.302, 0.384)
#endif
#ifndef DIAMIN_AZO_BLUE
#define DIAMIN_AZO_BLUE RIDGWAY_DIAMIN_AZO_BLUE
#endif

#ifndef RIDGWAY_DIAMINE_BROWN
#define RIDGWAY_DIAMINE_BROWN float3(0.388, 0.275, 0.267)
#endif
#ifndef DIAMINE_BROWN
#define DIAMINE_BROWN RIDGWAY_DIAMINE_BROWN
#endif

#ifndef RIDGWAY_DIAMINE_GREEN
#define RIDGWAY_DIAMINE_GREEN float3(0.224, 0.435, 0.369)
#endif
#ifndef DIAMINE_GREEN
#define DIAMINE_GREEN RIDGWAY_DIAMINE_GREEN
#endif

#ifndef RIDGWAY_DIVA_BLUE
#define RIDGWAY_DIVA_BLUE float3(0.353, 0.439, 0.710)
#endif
#ifndef DIVA_BLUE
#define DIVA_BLUE RIDGWAY_DIVA_BLUE
#endif

#ifndef RIDGWAY_DRAB
#define RIDGWAY_DRAB float3(0.608, 0.533, 0.447)
#endif
#ifndef DRAB
#define DRAB RIDGWAY_DRAB
#endif

#ifndef RIDGWAY_DRAB_GRAY
#define RIDGWAY_DRAB_GRAY float3(0.733, 0.675, 0.600)
#endif
#ifndef DRAB_GRAY
#define DRAB_GRAY RIDGWAY_DRAB_GRAY
#endif

#ifndef RIDGWAY_DRAGONS_BLOOD_RED
#define RIDGWAY_DRAGONS_BLOOD_RED float3(0.725, 0.318, 0.259)
#endif
#ifndef DRAGONS_BLOOD_RED
#define DRAGONS_BLOOD_RED RIDGWAY_DRAGONS_BLOOD_RED
#endif

#ifndef RIDGWAY_DRESDEN_BROWN
#define RIDGWAY_DRESDEN_BROWN float3(0.549, 0.420, 0.251)
#endif
#ifndef DRESDEN_BROWN
#define DRESDEN_BROWN RIDGWAY_DRESDEN_BROWN
#endif

#ifndef RIDGWAY_DUCK_GREEN
#define RIDGWAY_DUCK_GREEN float3(0.161, 0.361, 0.361)
#endif
#ifndef DUCK_GREEN
#define DUCK_GREEN RIDGWAY_DUCK_GREEN
#endif

#ifndef RIDGWAY_DULL_BLACKISH_GREEN
#define RIDGWAY_DULL_BLACKISH_GREEN float3(0.231, 0.333, 0.286)
#endif
#ifndef DULL_BLACKISH_GREEN
#define DULL_BLACKISH_GREEN RIDGWAY_DULL_BLACKISH_GREEN
#endif

#ifndef RIDGWAY_DULL_BLUE_GREEN_BLACK
#define RIDGWAY_DULL_BLUE_GREEN_BLACK float3(0.173, 0.278, 0.290)
#endif
#ifndef DULL_BLUE_GREEN_BLACK
#define DULL_BLUE_GREEN_BLACK RIDGWAY_DULL_BLUE_GREEN_BLACK
#endif

#ifndef RIDGWAY_DULL_BLUE_VIOLET_1
#define RIDGWAY_DULL_BLUE_VIOLET_1 float3(0.353, 0.392, 0.667)
#endif
#ifndef DULL_BLUE_VIOLET_1
#define DULL_BLUE_VIOLET_1 RIDGWAY_DULL_BLUE_VIOLET_1
#endif

#ifndef RIDGWAY_DULL_BLUE_VIOLET_2
#define RIDGWAY_DULL_BLUE_VIOLET_2 float3(0.416, 0.380, 0.498)
#endif
#ifndef DULL_BLUE_VIOLET_2
#define DULL_BLUE_VIOLET_2 RIDGWAY_DULL_BLUE_VIOLET_2
#endif

#ifndef RIDGWAY_DULL_BLUISH_VIOLET_1
#define RIDGWAY_DULL_BLUISH_VIOLET_1 float3(0.361, 0.353, 0.612)
#endif
#ifndef DULL_BLUISH_VIOLET_1
#define DULL_BLUISH_VIOLET_1 RIDGWAY_DULL_BLUISH_VIOLET_1
#endif

#ifndef RIDGWAY_DULL_BLUISH_VIOLET_2
#define RIDGWAY_DULL_BLUISH_VIOLET_2 float3(0.431, 0.451, 0.616)
#endif
#ifndef DULL_BLUISH_VIOLET_2
#define DULL_BLUISH_VIOLET_2 RIDGWAY_DULL_BLUISH_VIOLET_2
#endif

#ifndef RIDGWAY_DULL_BLUISH_VIOLET_3
#define RIDGWAY_DULL_BLUISH_VIOLET_3 float3(0.514, 0.455, 0.608)
#endif
#ifndef DULL_BLUISH_VIOLET_3
#define DULL_BLUISH_VIOLET_3 RIDGWAY_DULL_BLUISH_VIOLET_3
#endif

#ifndef RIDGWAY_DULL_CITRINE
#define RIDGWAY_DULL_CITRINE float3(0.553, 0.522, 0.322)
#endif
#ifndef DULL_CITRINE
#define DULL_CITRINE RIDGWAY_DULL_CITRINE
#endif

#ifndef RIDGWAY_DULL_DARK_PURPLE
#define RIDGWAY_DULL_DARK_PURPLE float3(0.482, 0.290, 0.424)
#endif
#ifndef DULL_DARK_PURPLE
#define DULL_DARK_PURPLE RIDGWAY_DULL_DARK_PURPLE
#endif

#ifndef RIDGWAY_DULL_DUSKY_PURPLE
#define RIDGWAY_DULL_DUSKY_PURPLE float3(0.357, 0.271, 0.345)
#endif
#ifndef DULL_DUSKY_PURPLE
#define DULL_DUSKY_PURPLE RIDGWAY_DULL_DUSKY_PURPLE
#endif

#ifndef RIDGWAY_DULL_GREEN_YELLOW
#define RIDGWAY_DULL_GREEN_YELLOW float3(0.780, 0.780, 0.416)
#endif
#ifndef DULL_GREEN_YELLOW
#define DULL_GREEN_YELLOW RIDGWAY_DULL_GREEN_YELLOW
#endif

#ifndef RIDGWAY_DULL_GREENISH_BLACK_1
#define RIDGWAY_DULL_GREENISH_BLACK_1 float3(0.239, 0.306, 0.275)
#endif
#ifndef DULL_GREENISH_BLACK_1
#define DULL_GREENISH_BLACK_1 RIDGWAY_DULL_GREENISH_BLACK_1
#endif

#ifndef RIDGWAY_DULL_GREENISH_BLACK_2
#define RIDGWAY_DULL_GREENISH_BLACK_2 float3(0.227, 0.298, 0.271)
#endif
#ifndef DULL_GREENISH_BLACK_2
#define DULL_GREENISH_BLACK_2 RIDGWAY_DULL_GREENISH_BLACK_2
#endif

#ifndef RIDGWAY_DULL_INDIAN_PURPLE
#define RIDGWAY_DULL_INDIAN_PURPLE float3(0.498, 0.380, 0.416)
#endif
#ifndef DULL_INDIAN_PURPLE
#define DULL_INDIAN_PURPLE RIDGWAY_DULL_INDIAN_PURPLE
#endif

#ifndef RIDGWAY_DULL_LAVENDER
#define RIDGWAY_DULL_LAVENDER float3(0.773, 0.702, 0.741)
#endif
#ifndef DULL_LAVENDER
#define DULL_LAVENDER RIDGWAY_DULL_LAVENDER
#endif

#ifndef RIDGWAY_DULL_MAGENTA_PURPLE
#define RIDGWAY_DULL_MAGENTA_PURPLE float3(0.580, 0.294, 0.463)
#endif
#ifndef DULL_MAGENTA_PURPLE
#define DULL_MAGENTA_PURPLE RIDGWAY_DULL_MAGENTA_PURPLE
#endif

#ifndef RIDGWAY_DULL_OPALINE_GREEN
#define RIDGWAY_DULL_OPALINE_GREEN float3(0.788, 0.890, 0.800)
#endif
#ifndef DULL_OPALINE_GREEN
#define DULL_OPALINE_GREEN RIDGWAY_DULL_OPALINE_GREEN
#endif

#ifndef RIDGWAY_DULL_PURPLISH_BLACK
#define RIDGWAY_DULL_PURPLISH_BLACK float3(0.247, 0.259, 0.255)
#endif
#ifndef DULL_PURPLISH_BLACK
#define DULL_PURPLISH_BLACK RIDGWAY_DULL_PURPLISH_BLACK
#endif

#ifndef RIDGWAY_DULL_VIOLACEOUS_BLUE
#define RIDGWAY_DULL_VIOLACEOUS_BLUE float3(0.369, 0.447, 0.694)
#endif
#ifndef DULL_VIOLACEOUS_BLUE
#define DULL_VIOLACEOUS_BLUE RIDGWAY_DULL_VIOLACEOUS_BLUE
#endif

#ifndef RIDGWAY_DULL_VIOLET_BLACK_1
#define RIDGWAY_DULL_VIOLET_BLACK_1 float3(0.267, 0.271, 0.298)
#endif
#ifndef DULL_VIOLET_BLACK_1
#define DULL_VIOLET_BLACK_1 RIDGWAY_DULL_VIOLET_BLACK_1
#endif

#ifndef RIDGWAY_DULL_VIOLET_BLACK_2
#define RIDGWAY_DULL_VIOLET_BLACK_2 float3(0.212, 0.271, 0.298)
#endif
#ifndef DULL_VIOLET_BLACK_2
#define DULL_VIOLET_BLACK_2 RIDGWAY_DULL_VIOLET_BLACK_2
#endif

#ifndef RIDGWAY_DULL_VIOLET_BLACK_3
#define RIDGWAY_DULL_VIOLET_BLACK_3 float3(0.243, 0.271, 0.271)
#endif
#ifndef DULL_VIOLET_BLACK_3
#define DULL_VIOLET_BLACK_3 RIDGWAY_DULL_VIOLET_BLACK_3
#endif

#ifndef RIDGWAY_DULL_VIOLET_BLUE
#define RIDGWAY_DULL_VIOLET_BLUE float3(0.467, 0.455, 0.620)
#endif
#ifndef DULL_VIOLET_BLUE
#define DULL_VIOLET_BLUE RIDGWAY_DULL_VIOLET_BLUE
#endif

#ifndef RIDGWAY_DULL_VIOLET_BLUE
#define RIDGWAY_DULL_VIOLET_BLUE float3(0.349, 0.412, 0.659)
#endif
#ifndef DULL_VIOLET_BLUE
#define DULL_VIOLET_BLUE RIDGWAY_DULL_VIOLET_BLUE
#endif

#ifndef RIDGWAY_DUSKY_AURICULA_PURPLE
#define RIDGWAY_DUSKY_AURICULA_PURPLE float3(0.369, 0.271, 0.337)
#endif
#ifndef DUSKY_AURICULA_PURPLE
#define DUSKY_AURICULA_PURPLE RIDGWAY_DUSKY_AURICULA_PURPLE
#endif

#ifndef RIDGWAY_DUSKY_BLUE
#define RIDGWAY_DUSKY_BLUE float3(0.208, 0.251, 0.369)
#endif
#ifndef DUSKY_BLUE
#define DUSKY_BLUE RIDGWAY_DUSKY_BLUE
#endif

#ifndef RIDGWAY_DUSKY_BLUE_GREEN
#define RIDGWAY_DUSKY_BLUE_GREEN float3(0.271, 0.369, 0.341)
#endif
#ifndef DUSKY_BLUE_GREEN
#define DUSKY_BLUE_GREEN RIDGWAY_DUSKY_BLUE_GREEN
#endif

#ifndef RIDGWAY_DUSKY_BLUE_VIOLET_1
#define RIDGWAY_DUSKY_BLUE_VIOLET_1 float3(0.298, 0.302, 0.420)
#endif
#ifndef DUSKY_BLUE_VIOLET_1
#define DUSKY_BLUE_VIOLET_1 RIDGWAY_DUSKY_BLUE_VIOLET_1
#endif

#ifndef RIDGWAY_DUSKY_BLUE_VIOLET_2
#define RIDGWAY_DUSKY_BLUE_VIOLET_2 float3(0.200, 0.208, 0.314)
#endif
#ifndef DUSKY_BLUE_VIOLET_2
#define DUSKY_BLUE_VIOLET_2 RIDGWAY_DUSKY_BLUE_VIOLET_2
#endif

#ifndef RIDGWAY_DUSKY_BLUISH_GREEN
#define RIDGWAY_DUSKY_BLUISH_GREEN float3(0.239, 0.353, 0.341)
#endif
#ifndef DUSKY_BLUISH_GREEN
#define DUSKY_BLUISH_GREEN RIDGWAY_DUSKY_BLUISH_GREEN
#endif

#ifndef RIDGWAY_DUSKY_BROWN
#define RIDGWAY_DUSKY_BROWN float3(0.345, 0.318, 0.298)
#endif
#ifndef DUSKY_BROWN
#define DUSKY_BROWN RIDGWAY_DUSKY_BROWN
#endif

#ifndef RIDGWAY_DUSKY_DRAB
#define RIDGWAY_DUSKY_DRAB float3(0.384, 0.357, 0.318)
#endif
#ifndef DUSKY_DRAB
#define DUSKY_DRAB RIDGWAY_DUSKY_DRAB
#endif

#ifndef RIDGWAY_DUSKY_DULL_BLUISH_GREEN
#define RIDGWAY_DUSKY_DULL_BLUISH_GREEN float3(0.165, 0.322, 0.337)
#endif
#ifndef DUSKY_DULL_BLUISH_GREEN
#define DUSKY_DULL_BLUISH_GREEN RIDGWAY_DUSKY_DULL_BLUISH_GREEN
#endif

#ifndef RIDGWAY_DUSKY_DULL_GREEN
#define RIDGWAY_DUSKY_DULL_GREEN float3(0.184, 0.314, 0.294)
#endif
#ifndef DUSKY_DULL_GREEN
#define DUSKY_DULL_GREEN RIDGWAY_DUSKY_DULL_GREEN
#endif

#ifndef RIDGWAY_DUSKY_DULL_VIOLET_1
#define RIDGWAY_DUSKY_DULL_VIOLET_1 float3(0.298, 0.275, 0.349)
#endif
#ifndef DUSKY_DULL_VIOLET_1
#define DUSKY_DULL_VIOLET_1 RIDGWAY_DUSKY_DULL_VIOLET_1
#endif

#ifndef RIDGWAY_DUSKY_DULL_VIOLET_2
#define RIDGWAY_DUSKY_DULL_VIOLET_2 float3(0.314, 0.275, 0.318)
#endif
#ifndef DUSKY_DULL_VIOLET_2
#define DUSKY_DULL_VIOLET_2 RIDGWAY_DUSKY_DULL_VIOLET_2
#endif

#ifndef RIDGWAY_DUSKY_DULL_VIOLET_BLUE
#define RIDGWAY_DUSKY_DULL_VIOLET_BLUE float3(0.298, 0.294, 0.369)
#endif
#ifndef DUSKY_DULL_VIOLET_BLUE
#define DUSKY_DULL_VIOLET_BLUE RIDGWAY_DUSKY_DULL_VIOLET_BLUE
#endif

#ifndef RIDGWAY_DUSKY_GREEN
#define RIDGWAY_DUSKY_GREEN float3(0.263, 0.349, 0.306)
#endif
#ifndef DUSKY_GREEN
#define DUSKY_GREEN RIDGWAY_DUSKY_GREEN
#endif

#ifndef RIDGWAY_DUSKY_GREEN_BLUE_1
#define RIDGWAY_DUSKY_GREEN_BLUE_1 float3(0.157, 0.361, 0.376)
#endif
#ifndef DUSKY_GREEN_BLUE_1
#define DUSKY_GREEN_BLUE_1 RIDGWAY_DUSKY_GREEN_BLUE_1
#endif

#ifndef RIDGWAY_DUSKY_GREEN_BLUE_2
#define RIDGWAY_DUSKY_GREEN_BLUE_2 float3(0.157, 0.341, 0.361)
#endif
#ifndef DUSKY_GREEN_BLUE_2
#define DUSKY_GREEN_BLUE_2 RIDGWAY_DUSKY_GREEN_BLUE_2
#endif

#ifndef RIDGWAY_DUSKY_GREEN_GRAY
#define RIDGWAY_DUSKY_GREEN_GRAY float3(0.278, 0.337, 0.314)
#endif
#ifndef DUSKY_GREEN_GRAY
#define DUSKY_GREEN_GRAY RIDGWAY_DUSKY_GREEN_GRAY
#endif

#ifndef RIDGWAY_DUSKY_GREENISH_BLUE
#define RIDGWAY_DUSKY_GREENISH_BLUE float3(0.169, 0.373, 0.486)
#endif
#ifndef DUSKY_GREENISH_BLUE
#define DUSKY_GREENISH_BLUE RIDGWAY_DUSKY_GREENISH_BLUE
#endif

#ifndef RIDGWAY_DUSKY_NEUTRAL_GRAY
#define RIDGWAY_DUSKY_NEUTRAL_GRAY float3(0.235, 0.286, 0.271)
#endif
#ifndef DUSKY_NEUTRAL_GRAY
#define DUSKY_NEUTRAL_GRAY RIDGWAY_DUSKY_NEUTRAL_GRAY
#endif

#ifndef RIDGWAY_DUSKY_OLIVE_GREEN
#define RIDGWAY_DUSKY_OLIVE_GREEN float3(0.298, 0.345, 0.275)
#endif
#ifndef DUSKY_OLIVE_GREEN
#define DUSKY_OLIVE_GREEN RIDGWAY_DUSKY_OLIVE_GREEN
#endif

#ifndef RIDGWAY_DUSKY_ORIENT_BLUE
#define RIDGWAY_DUSKY_ORIENT_BLUE float3(0.180, 0.349, 0.404)
#endif
#ifndef DUSKY_ORIENT_BLUE
#define DUSKY_ORIENT_BLUE RIDGWAY_DUSKY_ORIENT_BLUE
#endif

#ifndef RIDGWAY_DUSKY_PURPLISH_GRAY
#define RIDGWAY_DUSKY_PURPLISH_GRAY float3(0.239, 0.271, 0.263)
#endif
#ifndef DUSKY_PURPLISH_GRAY
#define DUSKY_PURPLISH_GRAY RIDGWAY_DUSKY_PURPLISH_GRAY
#endif

#ifndef RIDGWAY_DUSKY_SLATE_BLUE
#define RIDGWAY_DUSKY_SLATE_BLUE float3(0.200, 0.286, 0.325)
#endif
#ifndef DUSKY_SLATE_BLUE
#define DUSKY_SLATE_BLUE RIDGWAY_DUSKY_SLATE_BLUE
#endif

#ifndef RIDGWAY_DUSKY_SLATE_VIOLET
#define RIDGWAY_DUSKY_SLATE_VIOLET float3(0.263, 0.282, 0.298)
#endif
#ifndef DUSKY_SLATE_VIOLET
#define DUSKY_SLATE_VIOLET RIDGWAY_DUSKY_SLATE_VIOLET
#endif

#ifndef RIDGWAY_DUSKY_VIOLET
#define RIDGWAY_DUSKY_VIOLET float3(0.310, 0.298, 0.404)
#endif
#ifndef DUSKY_VIOLET
#define DUSKY_VIOLET RIDGWAY_DUSKY_VIOLET
#endif

#ifndef RIDGWAY_DUSKY_VIOLET_BLUE_1
#define RIDGWAY_DUSKY_VIOLET_BLUE_1 float3(0.271, 0.306, 0.400)
#endif
#ifndef DUSKY_VIOLET_BLUE_1
#define DUSKY_VIOLET_BLUE_1 RIDGWAY_DUSKY_VIOLET_BLUE_1
#endif

#ifndef RIDGWAY_DUSKY_VIOLET_BLUE_2
#define RIDGWAY_DUSKY_VIOLET_BLUE_2 float3(0.220, 0.267, 0.314)
#endif
#ifndef DUSKY_VIOLET_BLUE_2
#define DUSKY_VIOLET_BLUE_2 RIDGWAY_DUSKY_VIOLET_BLUE_2
#endif

#ifndef RIDGWAY_DUSKY_YELLOWISH_GREEN
#define RIDGWAY_DUSKY_YELLOWISH_GREEN float3(0.263, 0.349, 0.282)
#endif
#ifndef DUSKY_YELLOWISH_GREEN
#define DUSKY_YELLOWISH_GREEN RIDGWAY_DUSKY_YELLOWISH_GREEN
#endif

#ifndef RIDGWAY_DUTCH_BLUE
#define RIDGWAY_DUTCH_BLUE float3(0.553, 0.600, 0.671)
#endif
#ifndef DUTCH_BLUE
#define DUTCH_BLUE RIDGWAY_DUTCH_BLUE
#endif

#ifndef RIDGWAY_ECRU_DRAB
#define RIDGWAY_ECRU_DRAB float3(0.722, 0.659, 0.616)
#endif
#ifndef ECRU_DRAB
#define ECRU_DRAB RIDGWAY_ECRU_DRAB
#endif

#ifndef RIDGWAY_ECRU_OLIVE
#define RIDGWAY_ECRU_OLIVE float3(0.667, 0.592, 0.376)
#endif
#ifndef ECRU_OLIVE
#define ECRU_OLIVE RIDGWAY_ECRU_OLIVE
#endif

#ifndef RIDGWAY_ELM_GREEN
#define RIDGWAY_ELM_GREEN float3(0.376, 0.427, 0.294)
#endif
#ifndef ELM_GREEN
#define ELM_GREEN RIDGWAY_ELM_GREEN
#endif

#ifndef RIDGWAY_EMERALD_GREEN
#define RIDGWAY_EMERALD_GREEN float3(0.604, 0.812, 0.494)
#endif
#ifndef EMERALD_GREEN
#define EMERALD_GREEN RIDGWAY_EMERALD_GREEN
#endif

#ifndef RIDGWAY_EMPIRE_GREEN
#define RIDGWAY_EMPIRE_GREEN float3(0.306, 0.392, 0.302)
#endif
#ifndef EMPIRE_GREEN
#define EMPIRE_GREEN RIDGWAY_EMPIRE_GREEN
#endif

#ifndef RIDGWAY_EMPIRE_YELLOW
#define RIDGWAY_EMPIRE_YELLOW float3(0.757, 0.678, 0.341)
#endif
#ifndef EMPIRE_YELLOW
#define EMPIRE_YELLOW RIDGWAY_EMPIRE_YELLOW
#endif

#ifndef RIDGWAY_ENDIVE_BLUE
#define RIDGWAY_ENDIVE_BLUE float3(0.643, 0.667, 0.714)
#endif
#ifndef ENDIVE_BLUE
#define ENDIVE_BLUE RIDGWAY_ENDIVE_BLUE
#endif

#ifndef RIDGWAY_ENGLISH_RED
#define RIDGWAY_ENGLISH_RED float3(0.741, 0.318, 0.169)
#endif
#ifndef ENGLISH_RED
#define ENGLISH_RED RIDGWAY_ENGLISH_RED
#endif

#ifndef RIDGWAY_EOSINE_PINK
#define RIDGWAY_EOSINE_PINK float3(0.992, 0.529, 0.565)
#endif
#ifndef EOSINE_PINK
#define EOSINE_PINK RIDGWAY_EOSINE_PINK
#endif

#ifndef RIDGWAY_ETAIN_BLUE
#define RIDGWAY_ETAIN_BLUE float3(0.729, 0.800, 0.784)
#endif
#ifndef ETAIN_BLUE
#define ETAIN_BLUE RIDGWAY_ETAIN_BLUE
#endif

#ifndef RIDGWAY_ETHYL_GREEN
#define RIDGWAY_ETHYL_GREEN float3(0.031, 0.478, 0.514)
#endif
#ifndef ETHYL_GREEN
#define ETHYL_GREEN RIDGWAY_ETHYL_GREEN
#endif

#ifndef RIDGWAY_ETON_BLUE
#define RIDGWAY_ETON_BLUE float3(0.286, 0.369, 0.545)
#endif
#ifndef ETON_BLUE
#define ETON_BLUE RIDGWAY_ETON_BLUE
#endif

#ifndef RIDGWAY_ETRUSCAN_RED
#define RIDGWAY_ETRUSCAN_RED float3(0.678, 0.420, 0.376)
#endif
#ifndef ETRUSCAN_RED
#define ETRUSCAN_RED RIDGWAY_ETRUSCAN_RED
#endif

#ifndef RIDGWAY_EUGENIA_RED
#define RIDGWAY_EUGENIA_RED float3(0.788, 0.337, 0.357)
#endif
#ifndef EUGENIA_RED
#define EUGENIA_RED RIDGWAY_EUGENIA_RED
#endif

#ifndef RIDGWAY_EUPATORIUM_PURPLE
#define RIDGWAY_EUPATORIUM_PURPLE float3(0.659, 0.467, 0.592)
#endif
#ifndef EUPATORIUM_PURPLE
#define EUPATORIUM_PURPLE RIDGWAY_EUPATORIUM_PURPLE
#endif

#ifndef RIDGWAY_FAWN_COLOR
#define RIDGWAY_FAWN_COLOR float3(0.690, 0.525, 0.412)
#endif
#ifndef FAWN_COLOR
#define FAWN_COLOR RIDGWAY_FAWN_COLOR
#endif

#ifndef RIDGWAY_FERRUGINOUS
#define RIDGWAY_FERRUGINOUS float3(0.702, 0.380, 0.286)
#endif
#ifndef FERRUGINOUS
#define FERRUGINOUS RIDGWAY_FERRUGINOUS
#endif

#ifndef RIDGWAY_FLAME_SCARLET
#define RIDGWAY_FLAME_SCARLET float3(0.992, 0.420, 0.184)
#endif
#ifndef FLAME_SCARLET
#define FLAME_SCARLET RIDGWAY_FLAME_SCARLET
#endif

#ifndef RIDGWAY_FLAX_FLOWER_BLUE
#define RIDGWAY_FLAX_FLOWER_BLUE float3(0.541, 0.624, 0.894)
#endif
#ifndef FLAX_FLOWER_BLUE
#define FLAX_FLOWER_BLUE RIDGWAY_FLAX_FLOWER_BLUE
#endif

#ifndef RIDGWAY_FLESH_COLOR
#define RIDGWAY_FLESH_COLOR float3(0.945, 0.647, 0.553)
#endif
#ifndef FLESH_COLOR
#define FLESH_COLOR RIDGWAY_FLESH_COLOR
#endif

#ifndef RIDGWAY_FLESH_OCHER
#define RIDGWAY_FLESH_OCHER float3(0.941, 0.580, 0.439)
#endif
#ifndef FLESH_OCHER
#define FLESH_OCHER RIDGWAY_FLESH_OCHER
#endif

#ifndef RIDGWAY_FLESH_PINK
#define RIDGWAY_FLESH_PINK float3(0.941, 0.761, 0.722)
#endif
#ifndef FLESH_PINK
#define FLESH_PINK RIDGWAY_FLESH_PINK
#endif

#ifndef RIDGWAY_FLUORITE_GREEN
#define RIDGWAY_FLUORITE_GREEN float3(0.486, 0.663, 0.494)
#endif
#ifndef FLUORITE_GREEN
#define FLUORITE_GREEN RIDGWAY_FLUORITE_GREEN
#endif

#ifndef RIDGWAY_FLUORITE_VIOLET
#define RIDGWAY_FLUORITE_VIOLET float3(0.314, 0.231, 0.349)
#endif
#ifndef FLUORITE_VIOLET
#define FLUORITE_VIOLET RIDGWAY_FLUORITE_VIOLET
#endif

#ifndef RIDGWAY_FOREST_GREEN
#define RIDGWAY_FOREST_GREEN float3(0.384, 0.459, 0.294)
#endif
#ifndef FOREST_GREEN
#define FOREST_GREEN RIDGWAY_FOREST_GREEN
#endif

#ifndef RIDGWAY_FORGET_ME_NOT_BLUE
#define RIDGWAY_FORGET_ME_NOT_BLUE float3(0.541, 0.627, 0.796)
#endif
#ifndef FORGET_ME_NOT_BLUE
#define FORGET_ME_NOT_BLUE RIDGWAY_FORGET_ME_NOT_BLUE
#endif

#ifndef RIDGWAY_FRENCH_GRAY
#define RIDGWAY_FRENCH_GRAY float3(0.714, 0.710, 0.690)
#endif
#ifndef FRENCH_GRAY
#define FRENCH_GRAY RIDGWAY_FRENCH_GRAY
#endif

#ifndef RIDGWAY_FRENCH_GREEN
#define RIDGWAY_FRENCH_GREEN float3(0.357, 0.557, 0.443)
#endif
#ifndef FRENCH_GREEN
#define FRENCH_GREEN RIDGWAY_FRENCH_GREEN
#endif

#ifndef RIDGWAY_FUSCOUS
#define RIDGWAY_FUSCOUS float3(0.361, 0.345, 0.290)
#endif
#ifndef FUSCOUS
#define FUSCOUS RIDGWAY_FUSCOUS
#endif

#ifndef RIDGWAY_FUSCOUS_BLACK
#define RIDGWAY_FUSCOUS_BLACK float3(0.275, 0.290, 0.259)
#endif
#ifndef FUSCOUS_BLACK
#define FUSCOUS_BLACK RIDGWAY_FUSCOUS_BLACK
#endif

#ifndef RIDGWAY_GARNET_BROWN
#define RIDGWAY_GARNET_BROWN float3(0.506, 0.224, 0.196)
#endif
#ifndef GARNET_BROWN
#define GARNET_BROWN RIDGWAY_GARNET_BROWN
#endif

#ifndef RIDGWAY_GENDARME_BLUE
#define RIDGWAY_GENDARME_BLUE float3(0.271, 0.365, 0.514)
#endif
#ifndef GENDARME_BLUE
#define GENDARME_BLUE RIDGWAY_GENDARME_BLUE
#endif

#ifndef RIDGWAY_GENTIAN_BLUE
#define RIDGWAY_GENTIAN_BLUE float3(0.380, 0.416, 0.702)
#endif
#ifndef GENTIAN_BLUE
#define GENTIAN_BLUE RIDGWAY_GENTIAN_BLUE
#endif

#ifndef RIDGWAY_GERANIUM_PINK
#define RIDGWAY_GERANIUM_PINK float3(0.988, 0.514, 0.541)
#endif
#ifndef GERANIUM_PINK
#define GERANIUM_PINK RIDGWAY_GERANIUM_PINK
#endif

#ifndef RIDGWAY_GLASS_GREEN
#define RIDGWAY_GLASS_GREEN float3(0.851, 0.824, 0.588)
#endif
#ifndef GLASS_GREEN
#define GLASS_GREEN RIDGWAY_GLASS_GREEN
#endif

#ifndef RIDGWAY_GLAUCOUS
#define RIDGWAY_GLAUCOUS float3(0.780, 0.847, 0.737)
#endif
#ifndef GLAUCOUS
#define GLAUCOUS RIDGWAY_GLAUCOUS
#endif

#ifndef RIDGWAY_GLAUCOUS_BLUE
#define RIDGWAY_GLAUCOUS_BLUE float3(0.506, 0.651, 0.667)
#endif
#ifndef GLAUCOUS_BLUE
#define GLAUCOUS_BLUE RIDGWAY_GLAUCOUS_BLUE
#endif

#ifndef RIDGWAY_GLAUCOUS_GRAY
#define RIDGWAY_GLAUCOUS_GRAY float3(0.667, 0.710, 0.698)
#endif
#ifndef GLAUCOUS_GRAY
#define GLAUCOUS_GRAY RIDGWAY_GLAUCOUS_GRAY
#endif

#ifndef RIDGWAY_GLAUCOUS_GREEN
#define RIDGWAY_GLAUCOUS_GREEN float3(0.737, 0.796, 0.718)
#endif
#ifndef GLAUCOUS_GREEN
#define GLAUCOUS_GREEN RIDGWAY_GLAUCOUS_GREEN
#endif

#ifndef RIDGWAY_GNAPHALIUM_GREEN
#define RIDGWAY_GNAPHALIUM_GREEN float3(0.616, 0.675, 0.612)
#endif
#ifndef GNAPHALIUM_GREEN
#define GNAPHALIUM_GREEN RIDGWAY_GNAPHALIUM_GREEN
#endif

#ifndef RIDGWAY_GOBELIN_BLUE
#define RIDGWAY_GOBELIN_BLUE float3(0.361, 0.506, 0.525)
#endif
#ifndef GOBELIN_BLUE
#define GOBELIN_BLUE RIDGWAY_GOBELIN_BLUE
#endif

#ifndef RIDGWAY_GRAPE_GREEN
#define RIDGWAY_GRAPE_GREEN float3(0.635, 0.631, 0.380)
#endif
#ifndef GRAPE_GREEN
#define GRAPE_GREEN RIDGWAY_GRAPE_GREEN
#endif

#ifndef RIDGWAY_GRASS_GREEN
#define RIDGWAY_GRASS_GREEN float3(0.451, 0.498, 0.322)
#endif
#ifndef GRASS_GREEN
#define GRASS_GREEN RIDGWAY_GRASS_GREEN
#endif

#ifndef RIDGWAY_GRAYISH_BLUE_GREEN
#define RIDGWAY_GRAYISH_BLUE_GREEN float3(0.431, 0.541, 0.529)
#endif
#ifndef GRAYISH_BLUE_GREEN
#define GRAYISH_BLUE_GREEN RIDGWAY_GRAYISH_BLUE_GREEN
#endif

#ifndef RIDGWAY_GRAYISH_BLUE_VIOLET_1
#define RIDGWAY_GRAYISH_BLUE_VIOLET_1 float3(0.365, 0.380, 0.580)
#endif
#ifndef GRAYISH_BLUE_VIOLET_1
#define GRAYISH_BLUE_VIOLET_1 RIDGWAY_GRAYISH_BLUE_VIOLET_1
#endif

#ifndef RIDGWAY_GRAYISH_BLUE_VIOLET_2
#define RIDGWAY_GRAYISH_BLUE_VIOLET_2 float3(0.529, 0.592, 0.729)
#endif
#ifndef GRAYISH_BLUE_VIOLET_2
#define GRAYISH_BLUE_VIOLET_2 RIDGWAY_GRAYISH_BLUE_VIOLET_2
#endif

#ifndef RIDGWAY_GRAYISH_LAVENDER
#define RIDGWAY_GRAYISH_LAVENDER float3(0.737, 0.714, 0.745)
#endif
#ifndef GRAYISH_LAVENDER
#define GRAYISH_LAVENDER RIDGWAY_GRAYISH_LAVENDER
#endif

#ifndef RIDGWAY_GRAYISH_OLIVE
#define RIDGWAY_GRAYISH_OLIVE float3(0.553, 0.525, 0.424)
#endif
#ifndef GRAYISH_OLIVE
#define GRAYISH_OLIVE RIDGWAY_GRAYISH_OLIVE
#endif

#ifndef RIDGWAY_GRAYISH_VIOLACEOUS_BLUE
#define RIDGWAY_GRAYISH_VIOLACEOUS_BLUE float3(0.337, 0.400, 0.576)
#endif
#ifndef GRAYISH_VIOLACEOUS_BLUE
#define GRAYISH_VIOLACEOUS_BLUE RIDGWAY_GRAYISH_VIOLACEOUS_BLUE
#endif

#ifndef RIDGWAY_GRAYISH_VIOLET_BLUE
#define RIDGWAY_GRAYISH_VIOLET_BLUE float3(0.365, 0.396, 0.580)
#endif
#ifndef GRAYISH_VIOLET_BLUE
#define GRAYISH_VIOLET_BLUE RIDGWAY_GRAYISH_VIOLET_BLUE
#endif

#ifndef RIDGWAY_GREEN_BLUE_SLATE
#define RIDGWAY_GREEN_BLUE_SLATE float3(0.357, 0.439, 0.475)
#endif
#ifndef GREEN_BLUE_SLATE
#define GREEN_BLUE_SLATE RIDGWAY_GREEN_BLUE_SLATE
#endif

#ifndef RIDGWAY_GREEN_YELLOW
#define RIDGWAY_GREEN_YELLOW float3(0.898, 0.886, 0.427)
#endif
#ifndef GREEN_YELLOW
#define GREEN_YELLOW RIDGWAY_GREEN_YELLOW
#endif

#ifndef RIDGWAY_GREENISH_GLAUCOUS
#define RIDGWAY_GREENISH_GLAUCOUS float3(0.745, 0.800, 0.710)
#endif
#ifndef GREENISH_GLAUCOUS
#define GREENISH_GLAUCOUS RIDGWAY_GREENISH_GLAUCOUS
#endif

#ifndef RIDGWAY_GREENISH_GLAUCOUS_BLUE
#define RIDGWAY_GREENISH_GLAUCOUS_BLUE float3(0.576, 0.678, 0.651)
#endif
#ifndef GREENISH_GLAUCOUS_BLUE
#define GREENISH_GLAUCOUS_BLUE RIDGWAY_GREENISH_GLAUCOUS_BLUE
#endif

#ifndef RIDGWAY_GREENISH_SLATE_BLACK
#define RIDGWAY_GREENISH_SLATE_BLACK float3(0.196, 0.286, 0.278)
#endif
#ifndef GREENISH_SLATE_BLACK
#define GREENISH_SLATE_BLACK RIDGWAY_GREENISH_SLATE_BLACK
#endif

#ifndef RIDGWAY_GREENISH_YELLOW
#define RIDGWAY_GREENISH_YELLOW float3(0.757, 0.702, 0.302)
#endif
#ifndef GREENISH_YELLOW
#define GREENISH_YELLOW RIDGWAY_GREENISH_YELLOW
#endif

#ifndef RIDGWAY_GRENADINE
#define RIDGWAY_GRENADINE float3(0.996, 0.506, 0.369)
#endif
#ifndef GRENADINE
#define GRENADINE RIDGWAY_GRENADINE
#endif

#ifndef RIDGWAY_GRENADINE_PINK
#define RIDGWAY_GRENADINE_PINK float3(0.996, 0.624, 0.525)
#endif
#ifndef GRENADINE_PINK
#define GRENADINE_PINK RIDGWAY_GRENADINE_PINK
#endif

#ifndef RIDGWAY_GRENADINE_RED
#define RIDGWAY_GRENADINE_RED float3(0.957, 0.318, 0.122)
#endif
#ifndef GRENADINE_RED
#define GRENADINE_RED RIDGWAY_GRENADINE_RED
#endif

#ifndef RIDGWAY_GUINEA_GREEN
#define RIDGWAY_GUINEA_GREEN float3(0.051, 0.463, 0.447)
#endif
#ifndef GUINEA_GREEN
#define GUINEA_GREEN RIDGWAY_GUINEA_GREEN
#endif

#ifndef RIDGWAY_GULL_GRAY
#define RIDGWAY_GULL_GRAY float3(0.647, 0.647, 0.620)
#endif
#ifndef GULL_GRAY
#define GULL_GRAY RIDGWAY_GULL_GRAY
#endif

#ifndef RIDGWAY_HAEMATITE_RED
#define RIDGWAY_HAEMATITE_RED float3(0.439, 0.322, 0.298)
#endif
#ifndef HAEMATITE_RED
#define HAEMATITE_RED RIDGWAY_HAEMATITE_RED
#endif

#ifndef RIDGWAY_HAEMATOXYLIN_VIOLET
#define RIDGWAY_HAEMATOXYLIN_VIOLET float3(0.439, 0.314, 0.537)
#endif
#ifndef HAEMATOXYLIN_VIOLET
#define HAEMATOXYLIN_VIOLET RIDGWAY_HAEMATOXYLIN_VIOLET
#endif

#ifndef RIDGWAY_HAIR_BROWN
#define RIDGWAY_HAIR_BROWN float3(0.494, 0.459, 0.396)
#endif
#ifndef HAIR_BROWN
#define HAIR_BROWN RIDGWAY_HAIR_BROWN
#endif

#ifndef RIDGWAY_HATHI_GRAY
#define RIDGWAY_HATHI_GRAY float3(0.561, 0.596, 0.569)
#endif
#ifndef HATHI_GRAY
#define HATHI_GRAY RIDGWAY_HATHI_GRAY
#endif

#ifndef RIDGWAY_HAYS_BLUE
#define RIDGWAY_HAYS_BLUE float3(0.231, 0.298, 0.580)
#endif
#ifndef HAYS_BLUE
#define HAYS_BLUE RIDGWAY_HAYS_BLUE
#endif

#ifndef RIDGWAY_HAYS_BROWN
#define RIDGWAY_HAYS_BROWN float3(0.459, 0.357, 0.306)
#endif
#ifndef HAYS_BROWN
#define HAYS_BROWN RIDGWAY_HAYS_BROWN
#endif

#ifndef RIDGWAY_HAYS_GREEN
#define RIDGWAY_HAYS_GREEN float3(0.361, 0.510, 0.365)
#endif
#ifndef HAYS_GREEN
#define HAYS_GREEN RIDGWAY_HAYS_GREEN
#endif

#ifndef RIDGWAY_HAYS_LILAC
#define RIDGWAY_HAYS_LILAC float3(0.702, 0.596, 0.718)
#endif
#ifndef HAYS_LILAC
#define HAYS_LILAC RIDGWAY_HAYS_LILAC
#endif

#ifndef RIDGWAY_HAYS_MAROON
#define RIDGWAY_HAYS_MAROON float3(0.396, 0.271, 0.263)
#endif
#ifndef HAYS_MAROON
#define HAYS_MAROON RIDGWAY_HAYS_MAROON
#endif

#ifndef RIDGWAY_HAYS_RUSSET
#define RIDGWAY_HAYS_RUSSET float3(0.573, 0.318, 0.243)
#endif
#ifndef HAYS_RUSSET
#define HAYS_RUSSET RIDGWAY_HAYS_RUSSET
#endif

#ifndef RIDGWAY_HAZEL
#define RIDGWAY_HAZEL float3(0.639, 0.392, 0.259)
#endif
#ifndef HAZEL
#define HAZEL RIDGWAY_HAZEL
#endif

#ifndef RIDGWAY_HELIOTROPE_GRAY
#define RIDGWAY_HELIOTROPE_GRAY float3(0.624, 0.600, 0.631)
#endif
#ifndef HELIOTROPE_GRAY
#define HELIOTROPE_GRAY RIDGWAY_HELIOTROPE_GRAY
#endif

#ifndef RIDGWAY_HELIOTROPE_SLATE
#define RIDGWAY_HELIOTROPE_SLATE float3(0.384, 0.373, 0.404)
#endif
#ifndef HELIOTROPE_SLATE
#define HELIOTROPE_SLATE RIDGWAY_HELIOTROPE_SLATE
#endif

#ifndef RIDGWAY_HELLEBORE_GREEN
#define RIDGWAY_HELLEBORE_GREEN float3(0.392, 0.431, 0.275)
#endif
#ifndef HELLEBORE_GREEN
#define HELLEBORE_GREEN RIDGWAY_HELLEBORE_GREEN
#endif

#ifndef RIDGWAY_HELLEBORE_RED
#define RIDGWAY_HELLEBORE_RED float3(0.702, 0.475, 0.533)
#endif
#ifndef HELLEBORE_RED
#define HELLEBORE_RED RIDGWAY_HELLEBORE_RED
#endif

#ifndef RIDGWAY_HELVETIA_BLUE
#define RIDGWAY_HELVETIA_BLUE float3(0.220, 0.318, 0.631)
#endif
#ifndef HELVETIA_BLUE
#define HELVETIA_BLUE RIDGWAY_HELVETIA_BLUE
#endif

#ifndef RIDGWAY_HERMOSA_PINK
#define RIDGWAY_HERMOSA_PINK float3(0.976, 0.769, 0.796)
#endif
#ifndef HERMOSA_PINK
#define HERMOSA_PINK RIDGWAY_HERMOSA_PINK
#endif

#ifndef RIDGWAY_HESSIAN_BROWN
#define RIDGWAY_HESSIAN_BROWN float3(0.404, 0.263, 0.243)
#endif
#ifndef HESSIAN_BROWN
#define HESSIAN_BROWN RIDGWAY_HESSIAN_BROWN
#endif

#ifndef RIDGWAY_HONEY_YELLOW
#define RIDGWAY_HONEY_YELLOW float3(0.737, 0.600, 0.353)
#endif
#ifndef HONEY_YELLOW
#define HONEY_YELLOW RIDGWAY_HONEY_YELLOW
#endif

#ifndef RIDGWAY_HORTENSE_BLUE
#define RIDGWAY_HORTENSE_BLUE float3(0.184, 0.259, 0.373)
#endif
#ifndef HORTENSE_BLUE
#define HORTENSE_BLUE RIDGWAY_HORTENSE_BLUE
#endif

#ifndef RIDGWAY_HORTENSE_VIOLET
#define RIDGWAY_HORTENSE_VIOLET float3(0.667, 0.435, 0.792)
#endif
#ifndef HORTENSE_VIOLET
#define HORTENSE_VIOLET RIDGWAY_HORTENSE_VIOLET
#endif

#ifndef RIDGWAY_HYACINTH_BLUE
#define RIDGWAY_HYACINTH_BLUE float3(0.314, 0.286, 0.533)
#endif
#ifndef HYACINTH_BLUE
#define HYACINTH_BLUE RIDGWAY_HYACINTH_BLUE
#endif

#ifndef RIDGWAY_HYACINTH_VIOLET
#define RIDGWAY_HYACINTH_VIOLET float3(0.490, 0.212, 0.545)
#endif
#ifndef HYACINTH_VIOLET
#define HYACINTH_VIOLET RIDGWAY_HYACINTH_VIOLET
#endif

#ifndef RIDGWAY_HYDRANGEA_PINK
#define RIDGWAY_HYDRANGEA_PINK float3(0.882, 0.757, 0.729)
#endif
#ifndef HYDRANGEA_PINK
#define HYDRANGEA_PINK RIDGWAY_HYDRANGEA_PINK
#endif

#ifndef RIDGWAY_HYDRANGEA_RED
#define RIDGWAY_HYDRANGEA_RED float3(0.612, 0.380, 0.349)
#endif
#ifndef HYDRANGEA_RED
#define HYDRANGEA_RED RIDGWAY_HYDRANGEA_RED
#endif

#ifndef RIDGWAY_HYSSOP_VIOLET
#define RIDGWAY_HYSSOP_VIOLET float3(0.525, 0.439, 0.576)
#endif
#ifndef HYSSOP_VIOLET
#define HYSSOP_VIOLET RIDGWAY_HYSSOP_VIOLET
#endif

#ifndef RIDGWAY_INDIAN_LAKE
#define RIDGWAY_INDIAN_LAKE float3(0.541, 0.286, 0.333)
#endif
#ifndef INDIAN_LAKE
#define INDIAN_LAKE RIDGWAY_INDIAN_LAKE
#endif

#ifndef RIDGWAY_INDIAN_PURPLE
#define RIDGWAY_INDIAN_PURPLE float3(0.392, 0.263, 0.259)
#endif
#ifndef INDIAN_PURPLE
#define INDIAN_PURPLE RIDGWAY_INDIAN_PURPLE
#endif

#ifndef RIDGWAY_INDIAN_RED
#define RIDGWAY_INDIAN_RED float3(0.533, 0.345, 0.325)
#endif
#ifndef INDIAN_RED
#define INDIAN_RED RIDGWAY_INDIAN_RED
#endif

#ifndef RIDGWAY_INDIGO_BLUE
#define RIDGWAY_INDIGO_BLUE float3(0.243, 0.345, 0.424)
#endif
#ifndef INDIGO_BLUE
#define INDIGO_BLUE RIDGWAY_INDIGO_BLUE
#endif

#ifndef RIDGWAY_INDULIN_BLUE
#define RIDGWAY_INDULIN_BLUE float3(0.412, 0.518, 0.729)
#endif
#ifndef INDULIN_BLUE
#define INDULIN_BLUE RIDGWAY_INDULIN_BLUE
#endif

#ifndef RIDGWAY_INVISIBLE_GREEN
#define RIDGWAY_INVISIBLE_GREEN float3(0.224, 0.380, 0.361)
#endif
#ifndef INVISIBLE_GREEN
#define INVISIBLE_GREEN RIDGWAY_INVISIBLE_GREEN
#endif

#ifndef RIDGWAY_IRON_GRAY
#define RIDGWAY_IRON_GRAY float3(0.314, 0.333, 0.314)
#endif
#ifndef IRON_GRAY
#define IRON_GRAY RIDGWAY_IRON_GRAY
#endif

#ifndef RIDGWAY_ISABELLA_COLOR
#define RIDGWAY_ISABELLA_COLOR float3(0.663, 0.533, 0.337)
#endif
#ifndef ISABELLA_COLOR
#define ISABELLA_COLOR RIDGWAY_ISABELLA_COLOR
#endif

#ifndef RIDGWAY_ITALIAN_BLUE
#define RIDGWAY_ITALIAN_BLUE float3(0.016, 0.576, 0.729)
#endif
#ifndef ITALIAN_BLUE
#define ITALIAN_BLUE RIDGWAY_ITALIAN_BLUE
#endif

#ifndef RIDGWAY_IVORY_YELLOW
#define RIDGWAY_IVORY_YELLOW float3(0.965, 0.894, 0.761)
#endif
#ifndef IVORY_YELLOW
#define IVORY_YELLOW RIDGWAY_IVORY_YELLOW
#endif

#ifndef RIDGWAY_IVY_GREEN
#define RIDGWAY_IVY_GREEN float3(0.365, 0.388, 0.275)
#endif
#ifndef IVY_GREEN
#define IVY_GREEN RIDGWAY_IVY_GREEN
#endif

#ifndef RIDGWAY_JADE_GREEN
#define RIDGWAY_JADE_GREEN float3(0.463, 0.482, 0.310)
#endif
#ifndef JADE_GREEN
#define JADE_GREEN RIDGWAY_JADE_GREEN
#endif

#ifndef RIDGWAY_JAPAN_ROSE
#define RIDGWAY_JAPAN_ROSE float3(0.863, 0.569, 0.463)
#endif
#ifndef JAPAN_ROSE
#define JAPAN_ROSE RIDGWAY_JAPAN_ROSE
#endif

#ifndef RIDGWAY_JASPER_GREEN
#define RIDGWAY_JASPER_GREEN float3(0.306, 0.502, 0.459)
#endif
#ifndef JASPER_GREEN
#define JASPER_GREEN RIDGWAY_JASPER_GREEN
#endif

#ifndef RIDGWAY_JASPER_PINK
#define RIDGWAY_JASPER_PINK float3(0.914, 0.569, 0.576)
#endif
#ifndef JASPER_PINK
#define JASPER_PINK RIDGWAY_JASPER_PINK
#endif

#ifndef RIDGWAY_JASPER_RED
#define RIDGWAY_JASPER_RED float3(0.851, 0.329, 0.310)
#endif
#ifndef JASPER_RED
#define JASPER_RED RIDGWAY_JASPER_RED
#endif

#ifndef RIDGWAY_JAVEL_GREEN
#define RIDGWAY_JAVEL_GREEN float3(0.718, 0.690, 0.259)
#endif
#ifndef JAVEL_GREEN
#define JAVEL_GREEN RIDGWAY_JAVEL_GREEN
#endif

#ifndef RIDGWAY_JAY_BLUE
#define RIDGWAY_JAY_BLUE float3(0.337, 0.427, 0.576)
#endif
#ifndef JAY_BLUE
#define JAY_BLUE RIDGWAY_JAY_BLUE
#endif

#ifndef RIDGWAY_JOUVENCE_BLUE
#define RIDGWAY_JOUVENCE_BLUE float3(0.106, 0.443, 0.478)
#endif
#ifndef JOUVENCE_BLUE
#define JOUVENCE_BLUE RIDGWAY_JOUVENCE_BLUE
#endif

#ifndef RIDGWAY_KAISER_BROWN
#define RIDGWAY_KAISER_BROWN float3(0.576, 0.337, 0.255)
#endif
#ifndef KAISER_BROWN
#define KAISER_BROWN RIDGWAY_KAISER_BROWN
#endif

#ifndef RIDGWAY_KILDARE_GREEN
#define RIDGWAY_KILDARE_GREEN float3(0.725, 0.753, 0.522)
#endif
#ifndef KILDARE_GREEN
#define KILDARE_GREEN RIDGWAY_KILDARE_GREEN
#endif

#ifndef RIDGWAY_KILLARNEY_GREEN
#define RIDGWAY_KILLARNEY_GREEN float3(0.388, 0.573, 0.435)
#endif
#ifndef KILLARNEY_GREEN
#define KILLARNEY_GREEN RIDGWAY_KILLARNEY_GREEN
#endif

#ifndef RIDGWAY_KINGS_BLUE
#define RIDGWAY_KINGS_BLUE float3(0.471, 0.588, 0.757)
#endif
#ifndef KINGS_BLUE
#define KINGS_BLUE RIDGWAY_KINGS_BLUE
#endif

#ifndef RIDGWAY_KRONBERGS_GREEN
#define RIDGWAY_KRONBERGS_GREEN float3(0.486, 0.490, 0.322)
#endif
#ifndef KRONBERGS_GREEN
#define KRONBERGS_GREEN RIDGWAY_KRONBERGS_GREEN
#endif

#ifndef RIDGWAY_LA_FRANCE_PINK
#define RIDGWAY_LA_FRANCE_PINK float3(0.992, 0.741, 0.773)
#endif
#ifndef LA_FRANCE_PINK
#define LA_FRANCE_PINK RIDGWAY_LA_FRANCE_PINK
#endif

#ifndef RIDGWAY_LAELIA_PINK
#define RIDGWAY_LAELIA_PINK float3(0.816, 0.604, 0.667)
#endif
#ifndef LAELIA_PINK
#define LAELIA_PINK RIDGWAY_LAELIA_PINK
#endif

#ifndef RIDGWAY_LAVENDER
#define RIDGWAY_LAVENDER float3(0.843, 0.792, 0.831)
#endif
#ifndef LAVENDER
#define LAVENDER RIDGWAY_LAVENDER
#endif

#ifndef RIDGWAY_LAVENDER_BLUE
#define RIDGWAY_LAVENDER_BLUE float3(0.659, 0.698, 0.918)
#endif
#ifndef LAVENDER_BLUE
#define LAVENDER_BLUE RIDGWAY_LAVENDER_BLUE
#endif

#ifndef RIDGWAY_LAVENDER_GRAY
#define RIDGWAY_LAVENDER_GRAY float3(0.702, 0.722, 0.757)
#endif
#ifndef LAVENDER_GRAY
#define LAVENDER_GRAY RIDGWAY_LAVENDER_GRAY
#endif

#ifndef RIDGWAY_LAVENDER_VIOLET
#define RIDGWAY_LAVENDER_VIOLET float3(0.655, 0.533, 0.839)
#endif
#ifndef LAVENDER_VIOLET
#define LAVENDER_VIOLET RIDGWAY_LAVENDER_VIOLET
#endif

#ifndef RIDGWAY_LEAF_GREEN
#define RIDGWAY_LEAF_GREEN float3(0.376, 0.439, 0.349)
#endif
#ifndef LEAF_GREEN
#define LEAF_GREEN RIDGWAY_LEAF_GREEN
#endif

#ifndef RIDGWAY_LEITCHS_BLUE
#define RIDGWAY_LEITCHS_BLUE float3(0.055, 0.380, 0.659)
#endif
#ifndef LEITCHS_BLUE
#define LEITCHS_BLUE RIDGWAY_LEITCHS_BLUE
#endif

#ifndef RIDGWAY_LEMON_CHROME
#define RIDGWAY_LEMON_CHROME float3(0.996, 0.816, 0.114)
#endif
#ifndef LEMON_CHROME
#define LEMON_CHROME RIDGWAY_LEMON_CHROME
#endif

#ifndef RIDGWAY_LEMON_YELLOW
#define RIDGWAY_LEMON_YELLOW float3(0.831, 0.741, 0.306)
#endif
#ifndef LEMON_YELLOW
#define LEMON_YELLOW RIDGWAY_LEMON_YELLOW
#endif

#ifndef RIDGWAY_LETTUCE_GREEN
#define RIDGWAY_LETTUCE_GREEN float3(0.573, 0.596, 0.310)
#endif
#ifndef LETTUCE_GREEN
#define LETTUCE_GREEN RIDGWAY_LETTUCE_GREEN
#endif

#ifndef RIDGWAY_LICHEN_GREEN
#define RIDGWAY_LICHEN_GREEN float3(0.761, 0.847, 0.788)
#endif
#ifndef LICHEN_GREEN
#define LICHEN_GREEN RIDGWAY_LICHEN_GREEN
#endif

#ifndef RIDGWAY_LIGHT_ALICE_BLUE
#define RIDGWAY_LIGHT_ALICE_BLUE float3(0.635, 0.710, 0.757)
#endif
#ifndef LIGHT_ALICE_BLUE
#define LIGHT_ALICE_BLUE RIDGWAY_LIGHT_ALICE_BLUE
#endif

#ifndef RIDGWAY_LIGHT_AMPARO_BLUE
#define RIDGWAY_LIGHT_AMPARO_BLUE float3(0.561, 0.690, 0.953)
#endif
#ifndef LIGHT_AMPARO_BLUE
#define LIGHT_AMPARO_BLUE RIDGWAY_LIGHT_AMPARO_BLUE
#endif

#ifndef RIDGWAY_LIGHT_AMPARO_PURPLE
#define RIDGWAY_LIGHT_AMPARO_PURPLE float3(0.812, 0.569, 0.855)
#endif
#ifndef LIGHT_AMPARO_PURPLE
#define LIGHT_AMPARO_PURPLE RIDGWAY_LIGHT_AMPARO_PURPLE
#endif

#ifndef RIDGWAY_LIGHT_BICE_GREEN
#define RIDGWAY_LIGHT_BICE_GREEN float3(0.529, 0.592, 0.404)
#endif
#ifndef LIGHT_BICE_GREEN
#define LIGHT_BICE_GREEN RIDGWAY_LIGHT_BICE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_BLUE_GREEN
#define RIDGWAY_LIGHT_BLUE_GREEN float3(0.518, 0.816, 0.729)
#endif
#ifndef LIGHT_BLUE_GREEN
#define LIGHT_BLUE_GREEN RIDGWAY_LIGHT_BLUE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_BLUE_VIOLET
#define RIDGWAY_LIGHT_BLUE_VIOLET float3(0.537, 0.576, 0.882)
#endif
#ifndef LIGHT_BLUE_VIOLET
#define LIGHT_BLUE_VIOLET RIDGWAY_LIGHT_BLUE_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_BLUISH_VIOLET
#define RIDGWAY_LIGHT_BLUISH_VIOLET float3(0.553, 0.557, 0.867)
#endif
#ifndef LIGHT_BLUISH_VIOLET
#define LIGHT_BLUISH_VIOLET RIDGWAY_LIGHT_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_BROWNISH_DRAB
#define RIDGWAY_LIGHT_BROWNISH_DRAB float3(0.635, 0.557, 0.522)
#endif
#ifndef LIGHT_BROWNISH_DRAB
#define LIGHT_BROWNISH_DRAB RIDGWAY_LIGHT_BROWNISH_DRAB
#endif

#ifndef RIDGWAY_LIGHT_BROWNISH_OLIVE
#define RIDGWAY_LIGHT_BROWNISH_OLIVE float3(0.545, 0.463, 0.325)
#endif
#ifndef LIGHT_BROWNISH_OLIVE
#define LIGHT_BROWNISH_OLIVE RIDGWAY_LIGHT_BROWNISH_OLIVE
#endif

#ifndef RIDGWAY_LIGHT_BROWNISH_VINACEOUS
#define RIDGWAY_LIGHT_BROWNISH_VINACEOUS float3(0.808, 0.690, 0.671)
#endif
#ifndef LIGHT_BROWNISH_VINACEOUS
#define LIGHT_BROWNISH_VINACEOUS RIDGWAY_LIGHT_BROWNISH_VINACEOUS
#endif

#ifndef RIDGWAY_LIGHT_BUFF
#define RIDGWAY_LIGHT_BUFF float3(0.992, 0.878, 0.714)
#endif
#ifndef LIGHT_BUFF
#define LIGHT_BUFF RIDGWAY_LIGHT_BUFF
#endif

#ifndef RIDGWAY_LIGHT_CADET_BLUE
#define RIDGWAY_LIGHT_CADET_BLUE float3(0.541, 0.655, 0.894)
#endif
#ifndef LIGHT_CADET_BLUE
#define LIGHT_CADET_BLUE RIDGWAY_LIGHT_CADET_BLUE
#endif

#ifndef RIDGWAY_LIGHT_CADMIUM
#define RIDGWAY_LIGHT_CADMIUM float3(0.804, 0.667, 0.278)
#endif
#ifndef LIGHT_CADMIUM
#define LIGHT_CADMIUM RIDGWAY_LIGHT_CADMIUM
#endif

#ifndef RIDGWAY_LIGHT_CAMPANULA_BLUE
#define RIDGWAY_LIGHT_CAMPANULA_BLUE float3(0.655, 0.698, 0.871)
#endif
#ifndef LIGHT_CAMPANULA_BLUE
#define LIGHT_CAMPANULA_BLUE RIDGWAY_LIGHT_CAMPANULA_BLUE
#endif

#ifndef RIDGWAY_LIGHT_CELANDINE_GREEN
#define RIDGWAY_LIGHT_CELANDINE_GREEN float3(0.592, 0.667, 0.639)
#endif
#ifndef LIGHT_CELANDINE_GREEN
#define LIGHT_CELANDINE_GREEN RIDGWAY_LIGHT_CELANDINE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_CENDRE_GREEN
#define RIDGWAY_LIGHT_CENDRE_GREEN float3(0.651, 0.847, 0.612)
#endif
#ifndef LIGHT_CENDRE_GREEN
#define LIGHT_CENDRE_GREEN RIDGWAY_LIGHT_CENDRE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_CERULEAN_BLUE
#define RIDGWAY_LIGHT_CERULEAN_BLUE float3(0.400, 0.686, 0.886)
#endif
#ifndef LIGHT_CERULEAN_BLUE
#define LIGHT_CERULEAN_BLUE RIDGWAY_LIGHT_CERULEAN_BLUE
#endif

#ifndef RIDGWAY_LIGHT_CHALCEDONY_YELLOW
#define RIDGWAY_LIGHT_CHALCEDONY_YELLOW float3(0.945, 0.898, 0.584)
#endif
#ifndef LIGHT_CHALCEDONY_YELLOW
#define LIGHT_CHALCEDONY_YELLOW RIDGWAY_LIGHT_CHALCEDONY_YELLOW
#endif

#ifndef RIDGWAY_LIGHT_CHICORY_BLUE
#define RIDGWAY_LIGHT_CHICORY_BLUE float3(0.729, 0.737, 0.859)
#endif
#ifndef LIGHT_CHICORY_BLUE
#define LIGHT_CHICORY_BLUE RIDGWAY_LIGHT_CHICORY_BLUE
#endif

#ifndef RIDGWAY_LIGHT_CINNAMON_DRAB
#define RIDGWAY_LIGHT_CINNAMON_DRAB float3(0.686, 0.588, 0.522)
#endif
#ifndef LIGHT_CINNAMON_DRAB
#define LIGHT_CINNAMON_DRAB RIDGWAY_LIGHT_CINNAMON_DRAB
#endif

#ifndef RIDGWAY_LIGHT_COLUMBIA_BLUE
#define RIDGWAY_LIGHT_COLUMBIA_BLUE float3(0.592, 0.671, 0.753)
#endif
#ifndef LIGHT_COLUMBIA_BLUE
#define LIGHT_COLUMBIA_BLUE RIDGWAY_LIGHT_COLUMBIA_BLUE
#endif

#ifndef RIDGWAY_LIGHT_CONGO_PINK
#define RIDGWAY_LIGHT_CONGO_PINK float3(0.890, 0.690, 0.624)
#endif
#ifndef LIGHT_CONGO_PINK
#define LIGHT_CONGO_PINK RIDGWAY_LIGHT_CONGO_PINK
#endif

#ifndef RIDGWAY_LIGHT_CORAL_RED
#define RIDGWAY_LIGHT_CORAL_RED float3(0.933, 0.467, 0.404)
#endif
#ifndef LIGHT_CORAL_RED
#define LIGHT_CORAL_RED RIDGWAY_LIGHT_CORAL_RED
#endif

#ifndef RIDGWAY_LIGHT_CORINTHIAN_RED
#define RIDGWAY_LIGHT_CORINTHIAN_RED float3(0.702, 0.678, 0.608)
#endif
#ifndef LIGHT_CORINTHIAN_RED
#define LIGHT_CORINTHIAN_RED RIDGWAY_LIGHT_CORINTHIAN_RED
#endif

#ifndef RIDGWAY_LIGHT_CRESS_GREEN
#define RIDGWAY_LIGHT_CRESS_GREEN float3(0.580, 0.592, 0.376)
#endif
#ifndef LIGHT_CRESS_GREEN
#define LIGHT_CRESS_GREEN RIDGWAY_LIGHT_CRESS_GREEN
#endif

#ifndef RIDGWAY_LIGHT_DANUBE_GREEN
#define RIDGWAY_LIGHT_DANUBE_GREEN float3(0.271, 0.455, 0.384)
#endif
#ifndef LIGHT_DANUBE_GREEN
#define LIGHT_DANUBE_GREEN RIDGWAY_LIGHT_DANUBE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_DRAB
#define RIDGWAY_LIGHT_DRAB float3(0.675, 0.596, 0.502)
#endif
#ifndef LIGHT_DRAB
#define LIGHT_DRAB RIDGWAY_LIGHT_DRAB
#endif

#ifndef RIDGWAY_LIGHT_DULL_BLUISH_VIOLET
#define RIDGWAY_LIGHT_DULL_BLUISH_VIOLET float3(0.616, 0.608, 0.741)
#endif
#ifndef LIGHT_DULL_BLUISH_VIOLET
#define LIGHT_DULL_BLUISH_VIOLET RIDGWAY_LIGHT_DULL_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_DULL_GLAUCOUS_BLUE
#define RIDGWAY_LIGHT_DULL_GLAUCOUS_BLUE float3(0.576, 0.725, 0.733)
#endif
#ifndef LIGHT_DULL_GLAUCOUS_BLUE
#define LIGHT_DULL_GLAUCOUS_BLUE RIDGWAY_LIGHT_DULL_GLAUCOUS_BLUE
#endif

#ifndef RIDGWAY_LIGHT_DULL_GREEN_YELLOW
#define RIDGWAY_LIGHT_DULL_GREEN_YELLOW float3(0.894, 0.882, 0.592)
#endif
#ifndef LIGHT_DULL_GREEN_YELLOW
#define LIGHT_DULL_GREEN_YELLOW RIDGWAY_LIGHT_DULL_GREEN_YELLOW
#endif

#ifndef RIDGWAY_LIGHT_ELM_GREEN
#define RIDGWAY_LIGHT_ELM_GREEN float3(0.498, 0.537, 0.376)
#endif
#ifndef LIGHT_ELM_GREEN
#define LIGHT_ELM_GREEN RIDGWAY_LIGHT_ELM_GREEN
#endif

#ifndef RIDGWAY_LIGHT_FLUORITE_GREEN
#define RIDGWAY_LIGHT_FLUORITE_GREEN float3(0.792, 0.827, 0.643)
#endif
#ifndef LIGHT_FLUORITE_GREEN
#define LIGHT_FLUORITE_GREEN RIDGWAY_LIGHT_FLUORITE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_FORGET_ME_NOT_BLUE
#define RIDGWAY_LIGHT_FORGET_ME_NOT_BLUE float3(0.643, 0.706, 0.820)
#endif
#ifndef LIGHT_FORGET_ME_NOT_BLUE
#define LIGHT_FORGET_ME_NOT_BLUE RIDGWAY_LIGHT_FORGET_ME_NOT_BLUE
#endif

#ifndef RIDGWAY_LIGHT_GLAUCOUS_BLUE
#define RIDGWAY_LIGHT_GLAUCOUS_BLUE float3(0.635, 0.741, 0.741)
#endif
#ifndef LIGHT_GLAUCOUS_BLUE
#define LIGHT_GLAUCOUS_BLUE RIDGWAY_LIGHT_GLAUCOUS_BLUE
#endif

#ifndef RIDGWAY_LIGHT_GRAPE_GREEN
#define RIDGWAY_LIGHT_GRAPE_GREEN float3(0.643, 0.651, 0.490)
#endif
#ifndef LIGHT_GRAPE_GREEN
#define LIGHT_GRAPE_GREEN RIDGWAY_LIGHT_GRAPE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_GRAYISH_BLUE_VIOLET
#define RIDGWAY_LIGHT_GRAYISH_BLUE_VIOLET float3(0.663, 0.706, 0.800)
#endif
#ifndef LIGHT_GRAYISH_BLUE_VIOLET
#define LIGHT_GRAYISH_BLUE_VIOLET RIDGWAY_LIGHT_GRAYISH_BLUE_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_GRAYISH_OLIVE
#define RIDGWAY_LIGHT_GRAYISH_OLIVE float3(0.608, 0.588, 0.510)
#endif
#ifndef LIGHT_GRAYISH_OLIVE
#define LIGHT_GRAYISH_OLIVE RIDGWAY_LIGHT_GRAYISH_OLIVE
#endif

#ifndef RIDGWAY_LIGHT_GRAYISH_VINACEOUS
#define RIDGWAY_LIGHT_GRAYISH_VINACEOUS float3(0.804, 0.694, 0.659)
#endif
#ifndef LIGHT_GRAYISH_VINACEOUS
#define LIGHT_GRAYISH_VINACEOUS RIDGWAY_LIGHT_GRAYISH_VINACEOUS
#endif

#ifndef RIDGWAY_LIGHT_GRAYISH_VIOLET_BLUE
#define RIDGWAY_LIGHT_GRAYISH_VIOLET_BLUE float3(0.494, 0.569, 0.804)
#endif
#ifndef LIGHT_GRAYISH_VIOLET_BLUE
#define LIGHT_GRAYISH_VIOLET_BLUE RIDGWAY_LIGHT_GRAYISH_VIOLET_BLUE
#endif

#ifndef RIDGWAY_LIGHT_GREEN_YELLOW
#define RIDGWAY_LIGHT_GREEN_YELLOW float3(0.941, 0.929, 0.569)
#endif
#ifndef LIGHT_GREEN_YELLOW
#define LIGHT_GREEN_YELLOW RIDGWAY_LIGHT_GREEN_YELLOW
#endif

#ifndef RIDGWAY_LIGHT_GREENISH_YELLOW
#define RIDGWAY_LIGHT_GREENISH_YELLOW float3(0.765, 0.702, 0.376)
#endif
#ifndef LIGHT_GREENISH_YELLOW
#define LIGHT_GREENISH_YELLOW RIDGWAY_LIGHT_GREENISH_YELLOW
#endif

#ifndef RIDGWAY_LIGHT_GULL_GRAY
#define RIDGWAY_LIGHT_GULL_GRAY float3(0.690, 0.686, 0.651)
#endif
#ifndef LIGHT_GULL_GRAY
#define LIGHT_GULL_GRAY RIDGWAY_LIGHT_GULL_GRAY
#endif

#ifndef RIDGWAY_LIGHT_HELIOTROPE_GRAY
#define RIDGWAY_LIGHT_HELIOTROPE_GRAY float3(0.702, 0.663, 0.682)
#endif
#ifndef LIGHT_HELIOTROPE_GRAY
#define LIGHT_HELIOTROPE_GRAY RIDGWAY_LIGHT_HELIOTROPE_GRAY
#endif

#ifndef RIDGWAY_LIGHT_HELLEBORE_GREEN
#define RIDGWAY_LIGHT_HELLEBORE_GREEN float3(0.494, 0.510, 0.369)
#endif
#ifndef LIGHT_HELLEBORE_GREEN
#define LIGHT_HELLEBORE_GREEN RIDGWAY_LIGHT_HELLEBORE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_HORTENSE_VIOLET
#define RIDGWAY_LIGHT_HORTENSE_VIOLET float3(0.757, 0.486, 0.827)
#endif
#ifndef LIGHT_HORTENSE_VIOLET
#define LIGHT_HORTENSE_VIOLET RIDGWAY_LIGHT_HORTENSE_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_HYSSOP_VIOLET
#define RIDGWAY_LIGHT_HYSSOP_VIOLET float3(0.620, 0.569, 0.714)
#endif
#ifndef LIGHT_HYSSOP_VIOLET
#define LIGHT_HYSSOP_VIOLET RIDGWAY_LIGHT_HYSSOP_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_JASPER_RED
#define RIDGWAY_LIGHT_JASPER_RED float3(0.890, 0.427, 0.427)
#endif
#ifndef LIGHT_JASPER_RED
#define LIGHT_JASPER_RED RIDGWAY_LIGHT_JASPER_RED
#endif

#ifndef RIDGWAY_LIGHT_KINGS_BLUE
#define RIDGWAY_LIGHT_KINGS_BLUE float3(0.620, 0.706, 0.800)
#endif
#ifndef LIGHT_KINGS_BLUE
#define LIGHT_KINGS_BLUE RIDGWAY_LIGHT_KINGS_BLUE
#endif

#ifndef RIDGWAY_LIGHT_LAVENDER_BLUE
#define RIDGWAY_LIGHT_LAVENDER_BLUE float3(0.757, 0.780, 0.949)
#endif
#ifndef LIGHT_LAVENDER_BLUE
#define LIGHT_LAVENDER_BLUE RIDGWAY_LIGHT_LAVENDER_BLUE
#endif

#ifndef RIDGWAY_LIGHT_LAVENDER_VIOLET
#define RIDGWAY_LIGHT_LAVENDER_VIOLET float3(0.725, 0.631, 0.894)
#endif
#ifndef LIGHT_LAVENDER_VIOLET
#define LIGHT_LAVENDER_VIOLET RIDGWAY_LIGHT_LAVENDER_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_LOBELIA_VIOLET
#define RIDGWAY_LIGHT_LOBELIA_VIOLET float3(0.698, 0.616, 0.729)
#endif
#ifndef LIGHT_LOBELIA_VIOLET
#define LIGHT_LOBELIA_VIOLET RIDGWAY_LIGHT_LOBELIA_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_LUMIERE_GREEN
#define RIDGWAY_LIGHT_LUMIERE_GREEN float3(0.851, 0.875, 0.604)
#endif
#ifndef LIGHT_LUMIERE_GREEN
#define LIGHT_LUMIERE_GREEN RIDGWAY_LIGHT_LUMIERE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_MALLOW_PURPLE
#define RIDGWAY_LIGHT_MALLOW_PURPLE float3(0.914, 0.537, 0.808)
#endif
#ifndef LIGHT_MALLOW_PURPLE
#define LIGHT_MALLOW_PURPLE RIDGWAY_LIGHT_MALLOW_PURPLE
#endif

#ifndef RIDGWAY_LIGHT_MAUVE
#define RIDGWAY_LIGHT_MAUVE float3(0.812, 0.671, 0.867)
#endif
#ifndef LIGHT_MAUVE
#define LIGHT_MAUVE RIDGWAY_LIGHT_MAUVE
#endif

#ifndef RIDGWAY_LIGHT_MEDICI_BLUE
#define RIDGWAY_LIGHT_MEDICI_BLUE float3(0.545, 0.631, 0.643)
#endif
#ifndef LIGHT_MEDICI_BLUE
#define LIGHT_MEDICI_BLUE RIDGWAY_LIGHT_MEDICI_BLUE
#endif

#ifndef RIDGWAY_LIGHT_METHYL_BLUE
#define RIDGWAY_LIGHT_METHYL_BLUE float3(0.353, 0.635, 0.875)
#endif
#ifndef LIGHT_METHYL_BLUE
#define LIGHT_METHYL_BLUE RIDGWAY_LIGHT_METHYL_BLUE
#endif

#ifndef RIDGWAY_LIGHT_MINERAL_GRAY
#define RIDGWAY_LIGHT_MINERAL_GRAY float3(0.725, 0.737, 0.690)
#endif
#ifndef LIGHT_MINERAL_GRAY
#define LIGHT_MINERAL_GRAY RIDGWAY_LIGHT_MINERAL_GRAY
#endif

#ifndef RIDGWAY_LIGHT_MOUSE_GRAY
#define RIDGWAY_LIGHT_MOUSE_GRAY float3(0.588, 0.573, 0.541)
#endif
#ifndef LIGHT_MOUSE_GRAY
#define LIGHT_MOUSE_GRAY RIDGWAY_LIGHT_MOUSE_GRAY
#endif

#ifndef RIDGWAY_LIGHT_NEROPALIN_BLUE
#define RIDGWAY_LIGHT_NEROPALIN_BLUE float3(0.635, 0.714, 0.824)
#endif
#ifndef LIGHT_NEROPALIN_BLUE
#define LIGHT_NEROPALIN_BLUE RIDGWAY_LIGHT_NEROPALIN_BLUE
#endif

#ifndef RIDGWAY_LIGHT_NEUTRAL_GRAY
#define RIDGWAY_LIGHT_NEUTRAL_GRAY float3(0.576, 0.588, 0.569)
#endif
#ifndef LIGHT_NEUTRAL_GRAY
#define LIGHT_NEUTRAL_GRAY RIDGWAY_LIGHT_NEUTRAL_GRAY
#endif

#ifndef RIDGWAY_LIGHT_NIAGARA_GREEN
#define RIDGWAY_LIGHT_NIAGARA_GREEN float3(0.675, 0.773, 0.718)
#endif
#ifndef LIGHT_NIAGARA_GREEN
#define LIGHT_NIAGARA_GREEN RIDGWAY_LIGHT_NIAGARA_GREEN
#endif

#ifndef RIDGWAY_LIGHT_OCHRACEOUS_BUFF
#define RIDGWAY_LIGHT_OCHRACEOUS_BUFF float3(0.984, 0.769, 0.565)
#endif
#ifndef LIGHT_OCHRACEOUS_BUFF
#define LIGHT_OCHRACEOUS_BUFF RIDGWAY_LIGHT_OCHRACEOUS_BUFF
#endif

#ifndef RIDGWAY_LIGHT_OCHRACEOUS_SALMON
#define RIDGWAY_LIGHT_OCHRACEOUS_SALMON float3(0.933, 0.729, 0.573)
#endif
#ifndef LIGHT_OCHRACEOUS_SALMON
#define LIGHT_OCHRACEOUS_SALMON RIDGWAY_LIGHT_OCHRACEOUS_SALMON
#endif

#ifndef RIDGWAY_LIGHT_OLIVE_GRAY
#define RIDGWAY_LIGHT_OLIVE_GRAY float3(0.647, 0.643, 0.584)
#endif
#ifndef LIGHT_OLIVE_GRAY
#define LIGHT_OLIVE_GRAY RIDGWAY_LIGHT_OLIVE_GRAY
#endif

#ifndef RIDGWAY_LIGHT_ORANGE_YELLOW
#define RIDGWAY_LIGHT_ORANGE_YELLOW float3(0.996, 0.812, 0.333)
#endif
#ifndef LIGHT_ORANGE_YELLOW
#define LIGHT_ORANGE_YELLOW RIDGWAY_LIGHT_ORANGE_YELLOW
#endif

#ifndef RIDGWAY_LIGHT_ORIENTAL_GREEN
#define RIDGWAY_LIGHT_ORIENTAL_GREEN float3(0.541, 0.733, 0.541)
#endif
#ifndef LIGHT_ORIENTAL_GREEN
#define LIGHT_ORIENTAL_GREEN RIDGWAY_LIGHT_ORIENTAL_GREEN
#endif

#ifndef RIDGWAY_LIGHT_PARIS_GREEN
#define RIDGWAY_LIGHT_PARIS_GREEN float3(0.706, 0.824, 0.647)
#endif
#ifndef LIGHT_PARIS_GREEN
#define LIGHT_PARIS_GREEN RIDGWAY_LIGHT_PARIS_GREEN
#endif

#ifndef RIDGWAY_LIGHT_PAYNES_GRAY
#define RIDGWAY_LIGHT_PAYNES_GRAY float3(0.565, 0.608, 0.631)
#endif
#ifndef LIGHT_PAYNES_GRAY
#define LIGHT_PAYNES_GRAY RIDGWAY_LIGHT_PAYNES_GRAY
#endif

#ifndef RIDGWAY_LIGHT_PERILLA_PURPLE
#define RIDGWAY_LIGHT_PERILLA_PURPLE float3(0.584, 0.396, 0.482)
#endif
#ifndef LIGHT_PERILLA_PURPLE
#define LIGHT_PERILLA_PURPLE RIDGWAY_LIGHT_PERILLA_PURPLE
#endif

#ifndef RIDGWAY_LIGHT_PHLOX_PURPLE
#define RIDGWAY_LIGHT_PHLOX_PURPLE float3(0.855, 0.537, 0.855)
#endif
#ifndef LIGHT_PHLOX_PURPLE
#define LIGHT_PHLOX_PURPLE RIDGWAY_LIGHT_PHLOX_PURPLE
#endif

#ifndef RIDGWAY_LIGHT_PINKISH_CINNAMON
#define RIDGWAY_LIGHT_PINKISH_CINNAMON float3(0.910, 0.729, 0.588)
#endif
#ifndef LIGHT_PINKISH_CINNAMON
#define LIGHT_PINKISH_CINNAMON RIDGWAY_LIGHT_PINKISH_CINNAMON
#endif

#ifndef RIDGWAY_LIGHT_PINKISH_LILAC
#define RIDGWAY_LIGHT_PINKISH_LILAC float3(0.882, 0.784, 0.800)
#endif
#ifndef LIGHT_PINKISH_LILAC
#define LIGHT_PINKISH_LILAC RIDGWAY_LIGHT_PINKISH_LILAC
#endif

#ifndef RIDGWAY_LIGHT_PLUMBAGO_GRAY
#define RIDGWAY_LIGHT_PLUMBAGO_GRAY float3(0.675, 0.659, 0.682)
#endif
#ifndef LIGHT_PLUMBAGO_GRAY
#define LIGHT_PLUMBAGO_GRAY RIDGWAY_LIGHT_PLUMBAGO_GRAY
#endif

#ifndef RIDGWAY_LIGHT_PORCELAIN_GREEN
#define RIDGWAY_LIGHT_PORCELAIN_GREEN float3(0.373, 0.573, 0.533)
#endif
#ifndef LIGHT_PORCELAIN_GREEN
#define LIGHT_PORCELAIN_GREEN RIDGWAY_LIGHT_PORCELAIN_GREEN
#endif

#ifndef RIDGWAY_LIGHT_PURPLE_DRAB
#define RIDGWAY_LIGHT_PURPLE_DRAB float3(0.616, 0.541, 0.533)
#endif
#ifndef LIGHT_PURPLE_DRAB
#define LIGHT_PURPLE_DRAB RIDGWAY_LIGHT_PURPLE_DRAB
#endif

#ifndef RIDGWAY_LIGHT_PURPLISH_GRAY
#define RIDGWAY_LIGHT_PURPLISH_GRAY float3(0.525, 0.514, 0.498)
#endif
#ifndef LIGHT_PURPLISH_GRAY
#define LIGHT_PURPLISH_GRAY RIDGWAY_LIGHT_PURPLISH_GRAY
#endif

#ifndef RIDGWAY_LIGHT_PURPLISH_VINACEOUS
#define RIDGWAY_LIGHT_PURPLISH_VINACEOUS float3(0.769, 0.639, 0.651)
#endif
#ifndef LIGHT_PURPLISH_VINACEOUS
#define LIGHT_PURPLISH_VINACEOUS RIDGWAY_LIGHT_PURPLISH_VINACEOUS
#endif

#ifndef RIDGWAY_LIGHT_QUAKER_DRAB
#define RIDGWAY_LIGHT_QUAKER_DRAB float3(0.537, 0.529, 0.518)
#endif
#ifndef LIGHT_QUAKER_DRAB
#define LIGHT_QUAKER_DRAB RIDGWAY_LIGHT_QUAKER_DRAB
#endif

#ifndef RIDGWAY_LIGHT_ROSOLANE_PURPLE
#define RIDGWAY_LIGHT_ROSOLANE_PURPLE float3(0.867, 0.459, 0.678)
#endif
#ifndef LIGHT_ROSOLANE_PURPLE
#define LIGHT_ROSOLANE_PURPLE RIDGWAY_LIGHT_ROSOLANE_PURPLE
#endif

#ifndef RIDGWAY_LIGHT_RUSSET_VINACEOUS
#define RIDGWAY_LIGHT_RUSSET_VINACEOUS float3(0.769, 0.596, 0.545)
#endif
#ifndef LIGHT_RUSSET_VINACEOUS
#define LIGHT_RUSSET_VINACEOUS RIDGWAY_LIGHT_RUSSET_VINACEOUS
#endif

#ifndef RIDGWAY_LIGHT_SALMON_ORANGE
#define RIDGWAY_LIGHT_SALMON_ORANGE float3(0.996, 0.678, 0.510)
#endif
#ifndef LIGHT_SALMON_ORANGE
#define LIGHT_SALMON_ORANGE RIDGWAY_LIGHT_SALMON_ORANGE
#endif

#ifndef RIDGWAY_LIGHT_SEAL_BROWN
#define RIDGWAY_LIGHT_SEAL_BROWN float3(0.333, 0.290, 0.259)
#endif
#ifndef LIGHT_SEAL_BROWN
#define LIGHT_SEAL_BROWN RIDGWAY_LIGHT_SEAL_BROWN
#endif

#ifndef RIDGWAY_LIGHT_SKY_BLUE
#define RIDGWAY_LIGHT_SKY_BLUE float3(0.741, 0.839, 0.929)
#endif
#ifndef LIGHT_SKY_BLUE
#define LIGHT_SKY_BLUE RIDGWAY_LIGHT_SKY_BLUE
#endif

#ifndef RIDGWAY_LIGHT_SOFT_BLUE_VIOLET
#define RIDGWAY_LIGHT_SOFT_BLUE_VIOLET float3(0.561, 0.584, 0.890)
#endif
#ifndef LIGHT_SOFT_BLUE_VIOLET
#define LIGHT_SOFT_BLUE_VIOLET RIDGWAY_LIGHT_SOFT_BLUE_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_SQUILL_BLUE
#define RIDGWAY_LIGHT_SQUILL_BLUE float3(0.596, 0.776, 0.890)
#endif
#ifndef LIGHT_SQUILL_BLUE
#define LIGHT_SQUILL_BLUE RIDGWAY_LIGHT_SQUILL_BLUE
#endif

#ifndef RIDGWAY_LIGHT_SULPHATE_GREEN
#define RIDGWAY_LIGHT_SULPHATE_GREEN float3(0.431, 0.773, 0.698)
#endif
#ifndef LIGHT_SULPHATE_GREEN
#define LIGHT_SULPHATE_GREEN RIDGWAY_LIGHT_SULPHATE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_TERRE_VERTE
#define RIDGWAY_LIGHT_TERRE_VERTE float3(0.361, 0.573, 0.553)
#endif
#ifndef LIGHT_TERRE_VERTE
#define LIGHT_TERRE_VERTE RIDGWAY_LIGHT_TERRE_VERTE
#endif

#ifndef RIDGWAY_LIGHT_TURTLE_GREEN
#define RIDGWAY_LIGHT_TURTLE_GREEN float3(0.765, 0.753, 0.549)
#endif
#ifndef LIGHT_TURTLE_GREEN
#define LIGHT_TURTLE_GREEN RIDGWAY_LIGHT_TURTLE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_TYRIAN_BLUE
#define RIDGWAY_LIGHT_TYRIAN_BLUE float3(0.420, 0.506, 0.600)
#endif
#ifndef LIGHT_TYRIAN_BLUE
#define LIGHT_TYRIAN_BLUE RIDGWAY_LIGHT_TYRIAN_BLUE
#endif

#ifndef RIDGWAY_LIGHT_VARLEYS_GRAY
#define RIDGWAY_LIGHT_VARLEYS_GRAY float3(0.506, 0.518, 0.545)
#endif
#ifndef LIGHT_VARLEYS_GRAY
#define LIGHT_VARLEYS_GRAY RIDGWAY_LIGHT_VARLEYS_GRAY
#endif

#ifndef RIDGWAY_LIGHT_VINACEOUS_CINNAMON
#define RIDGWAY_LIGHT_VINACEOUS_CINNAMON float3(0.906, 0.702, 0.584)
#endif
#ifndef LIGHT_VINACEOUS_CINNAMON
#define LIGHT_VINACEOUS_CINNAMON RIDGWAY_LIGHT_VINACEOUS_CINNAMON
#endif

#ifndef RIDGWAY_LIGHT_VINACEOUS_DRAB
#define RIDGWAY_LIGHT_VINACEOUS_DRAB float3(0.631, 0.557, 0.525)
#endif
#ifndef LIGHT_VINACEOUS_DRAB
#define LIGHT_VINACEOUS_DRAB RIDGWAY_LIGHT_VINACEOUS_DRAB
#endif

#ifndef RIDGWAY_LIGHT_VINACEOUS_FAWN
#define RIDGWAY_LIGHT_VINACEOUS_FAWN float3(0.816, 0.698, 0.643)
#endif
#ifndef LIGHT_VINACEOUS_FAWN
#define LIGHT_VINACEOUS_FAWN RIDGWAY_LIGHT_VINACEOUS_FAWN
#endif

#ifndef RIDGWAY_LIGHT_VINACEOUS_GRAY
#define RIDGWAY_LIGHT_VINACEOUS_GRAY float3(0.776, 0.714, 0.725)
#endif
#ifndef LIGHT_VINACEOUS_GRAY
#define LIGHT_VINACEOUS_GRAY RIDGWAY_LIGHT_VINACEOUS_GRAY
#endif

#ifndef RIDGWAY_LIGHT_VINACEOUS_LILAC
#define RIDGWAY_LIGHT_VINACEOUS_LILAC float3(0.765, 0.635, 0.659)
#endif
#ifndef LIGHT_VINACEOUS_LILAC
#define LIGHT_VINACEOUS_LILAC RIDGWAY_LIGHT_VINACEOUS_LILAC
#endif

#ifndef RIDGWAY_LIGHT_VINACEOUS_PURPLE
#define RIDGWAY_LIGHT_VINACEOUS_PURPLE float3(0.635, 0.518, 0.592)
#endif
#ifndef LIGHT_VINACEOUS_PURPLE
#define LIGHT_VINACEOUS_PURPLE RIDGWAY_LIGHT_VINACEOUS_PURPLE
#endif

#ifndef RIDGWAY_LIGHT_VIOLET
#define RIDGWAY_LIGHT_VIOLET float3(0.584, 0.553, 0.839)
#endif
#ifndef LIGHT_VIOLET
#define LIGHT_VIOLET RIDGWAY_LIGHT_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_VIOLET_BLUE
#define RIDGWAY_LIGHT_VIOLET_BLUE float3(0.510, 0.592, 0.875)
#endif
#ifndef LIGHT_VIOLET_BLUE
#define LIGHT_VIOLET_BLUE RIDGWAY_LIGHT_VIOLET_BLUE
#endif

#ifndef RIDGWAY_LIGHT_VIOLET_GRAY
#define RIDGWAY_LIGHT_VIOLET_GRAY float3(0.545, 0.557, 0.561)
#endif
#ifndef LIGHT_VIOLET_GRAY
#define LIGHT_VIOLET_GRAY RIDGWAY_LIGHT_VIOLET_GRAY
#endif

#ifndef RIDGWAY_LIGHT_VIOLET_PLUMBEOUS
#define RIDGWAY_LIGHT_VIOLET_PLUMBEOUS float3(0.592, 0.620, 0.643)
#endif
#ifndef LIGHT_VIOLET_PLUMBEOUS
#define LIGHT_VIOLET_PLUMBEOUS RIDGWAY_LIGHT_VIOLET_PLUMBEOUS
#endif

#ifndef RIDGWAY_LIGHT_VIRIDINE_GREEN
#define RIDGWAY_LIGHT_VIRIDINE_GREEN float3(0.937, 0.925, 0.690)
#endif
#ifndef LIGHT_VIRIDINE_GREEN
#define LIGHT_VIRIDINE_GREEN RIDGWAY_LIGHT_VIRIDINE_GREEN
#endif

#ifndef RIDGWAY_LIGHT_VIRIDINE_YELLOW
#define RIDGWAY_LIGHT_VIRIDINE_YELLOW float3(0.761, 0.722, 0.439)
#endif
#ifndef LIGHT_VIRIDINE_YELLOW
#define LIGHT_VIRIDINE_YELLOW RIDGWAY_LIGHT_VIRIDINE_YELLOW
#endif

#ifndef RIDGWAY_LIGHT_WINDSOR_BLUE
#define RIDGWAY_LIGHT_WINDSOR_BLUE float3(0.475, 0.557, 0.694)
#endif
#ifndef LIGHT_WINDSOR_BLUE
#define LIGHT_WINDSOR_BLUE RIDGWAY_LIGHT_WINDSOR_BLUE
#endif

#ifndef RIDGWAY_LIGHT_WISTARIA_BLUE
#define RIDGWAY_LIGHT_WISTARIA_BLUE float3(0.686, 0.682, 0.914)
#endif
#ifndef LIGHT_WISTARIA_BLUE
#define LIGHT_WISTARIA_BLUE RIDGWAY_LIGHT_WISTARIA_BLUE
#endif

#ifndef RIDGWAY_LIGHT_WISTARIA_VIOLET
#define RIDGWAY_LIGHT_WISTARIA_VIOLET float3(0.710, 0.678, 0.925)
#endif
#ifndef LIGHT_WISTARIA_VIOLET
#define LIGHT_WISTARIA_VIOLET RIDGWAY_LIGHT_WISTARIA_VIOLET
#endif

#ifndef RIDGWAY_LIGHT_YELLOW_GREEN
#define RIDGWAY_LIGHT_YELLOW_GREEN float3(0.933, 0.878, 0.447)
#endif
#ifndef LIGHT_YELLOW_GREEN
#define LIGHT_YELLOW_GREEN RIDGWAY_LIGHT_YELLOW_GREEN
#endif

#ifndef RIDGWAY_LIGHT_YELLOWISH_OLIVE
#define RIDGWAY_LIGHT_YELLOWISH_OLIVE float3(0.651, 0.584, 0.365)
#endif
#ifndef LIGHT_YELLOWISH_OLIVE
#define LIGHT_YELLOWISH_OLIVE RIDGWAY_LIGHT_YELLOWISH_OLIVE
#endif

#ifndef RIDGWAY_LILAC
#define RIDGWAY_LILAC float3(0.808, 0.675, 0.855)
#endif
#ifndef LILAC
#define LILAC RIDGWAY_LILAC
#endif

#ifndef RIDGWAY_LILAC_GRAY
#define RIDGWAY_LILAC_GRAY float3(0.745, 0.733, 0.718)
#endif
#ifndef LILAC_GRAY
#define LILAC_GRAY RIDGWAY_LILAC_GRAY
#endif

#ifndef RIDGWAY_LILY_GREEN
#define RIDGWAY_LILY_GREEN float3(0.353, 0.451, 0.424)
#endif
#ifndef LILY_GREEN
#define LILY_GREEN RIDGWAY_LILY_GREEN
#endif

#ifndef RIDGWAY_LIME_GREEN
#define RIDGWAY_LIME_GREEN float3(0.741, 0.714, 0.380)
#endif
#ifndef LIME_GREEN
#define LIME_GREEN RIDGWAY_LIME_GREEN
#endif

#ifndef RIDGWAY_LINCOLN_GREEN
#define RIDGWAY_LINCOLN_GREEN float3(0.396, 0.427, 0.310)
#endif
#ifndef LINCOLN_GREEN
#define LINCOLN_GREEN RIDGWAY_LINCOLN_GREEN
#endif

#ifndef RIDGWAY_LISERAN_PURPLE
#define RIDGWAY_LISERAN_PURPLE float3(0.816, 0.506, 0.745)
#endif
#ifndef LISERAN_PURPLE
#define LISERAN_PURPLE RIDGWAY_LISERAN_PURPLE
#endif

#ifndef RIDGWAY_LITHO_PURPLE
#define RIDGWAY_LITHO_PURPLE float3(0.471, 0.345, 0.553)
#endif
#ifndef LITHO_PURPLE
#define LITHO_PURPLE RIDGWAY_LITHO_PURPLE
#endif

#ifndef RIDGWAY_LIVER_BROWN
#define RIDGWAY_LIVER_BROWN float3(0.396, 0.278, 0.243)
#endif
#ifndef LIVER_BROWN
#define LIVER_BROWN RIDGWAY_LIVER_BROWN
#endif

#ifndef RIDGWAY_LIVID_BROWN
#define RIDGWAY_LIVID_BROWN float3(0.643, 0.471, 0.459)
#endif
#ifndef LIVID_BROWN
#define LIVID_BROWN RIDGWAY_LIVID_BROWN
#endif

#ifndef RIDGWAY_LIVID_PINK
#define RIDGWAY_LIVID_PINK float3(0.933, 0.784, 0.780)
#endif
#ifndef LIVID_PINK
#define LIVID_PINK RIDGWAY_LIVID_PINK
#endif

#ifndef RIDGWAY_LIVID_PURPLE
#define RIDGWAY_LIVID_PURPLE float3(0.525, 0.380, 0.482)
#endif
#ifndef LIVID_PURPLE
#define LIVID_PURPLE RIDGWAY_LIVID_PURPLE
#endif

#ifndef RIDGWAY_LIVID_VIOLET
#define RIDGWAY_LIVID_VIOLET float3(0.482, 0.369, 0.475)
#endif
#ifndef LIVID_VIOLET
#define LIVID_VIOLET RIDGWAY_LIVID_VIOLET
#endif

#ifndef RIDGWAY_LOBELIA_VIOLET
#define RIDGWAY_LOBELIA_VIOLET float3(0.624, 0.553, 0.663)
#endif
#ifndef LOBELIA_VIOLET
#define LOBELIA_VIOLET RIDGWAY_LOBELIA_VIOLET
#endif

#ifndef RIDGWAY_LUMIERE_BLUE
#define RIDGWAY_LUMIERE_BLUE float3(0.600, 0.757, 0.737)
#endif
#ifndef LUMIERE_BLUE
#define LUMIERE_BLUE RIDGWAY_LUMIERE_BLUE
#endif

#ifndef RIDGWAY_LUMIERE_GREEN
#define RIDGWAY_LUMIERE_GREEN float3(0.796, 0.831, 0.494)
#endif
#ifndef LUMIERE_GREEN
#define LUMIERE_GREEN RIDGWAY_LUMIERE_GREEN
#endif

#ifndef RIDGWAY_LYONS_BLUE
#define RIDGWAY_LYONS_BLUE float3(0.145, 0.329, 0.761)
#endif
#ifndef LYONS_BLUE
#define LYONS_BLUE RIDGWAY_LYONS_BLUE
#endif

#ifndef RIDGWAY_MADDER_BLUE
#define RIDGWAY_MADDER_BLUE float3(0.471, 0.490, 0.584)
#endif
#ifndef MADDER_BLUE
#define MADDER_BLUE RIDGWAY_MADDER_BLUE
#endif

#ifndef RIDGWAY_MADDER_BROWN
#define RIDGWAY_MADDER_BROWN float3(0.522, 0.282, 0.255)
#endif
#ifndef MADDER_BROWN
#define MADDER_BROWN RIDGWAY_MADDER_BROWN
#endif

#ifndef RIDGWAY_MADDER_VIOLET
#define RIDGWAY_MADDER_VIOLET float3(0.373, 0.278, 0.416)
#endif
#ifndef MADDER_VIOLET
#define MADDER_VIOLET RIDGWAY_MADDER_VIOLET
#endif

#ifndef RIDGWAY_MAGENTA
#define RIDGWAY_MAGENTA float3(0.682, 0.322, 0.529)
#endif
#ifndef MAGENTA
#define MAGENTA RIDGWAY_MAGENTA
#endif

#ifndef RIDGWAY_MAHOGANY_RED
#define RIDGWAY_MAHOGANY_RED float3(0.506, 0.282, 0.192)
#endif
#ifndef MAHOGANY_RED
#define MAHOGANY_RED RIDGWAY_MAHOGANY_RED
#endif

#ifndef RIDGWAY_MAIZE_YELLOW
#define RIDGWAY_MAIZE_YELLOW float3(0.988, 0.878, 0.604)
#endif
#ifndef MAIZE_YELLOW
#define MAIZE_YELLOW RIDGWAY_MAIZE_YELLOW
#endif

#ifndef RIDGWAY_MALACHITE_GREEN
#define RIDGWAY_MALACHITE_GREEN float3(0.612, 0.729, 0.537)
#endif
#ifndef MALACHITE_GREEN
#define MALACHITE_GREEN RIDGWAY_MALACHITE_GREEN
#endif

#ifndef RIDGWAY_MALLOW_PINK
#define RIDGWAY_MALLOW_PINK float3(0.969, 0.686, 0.922)
#endif
#ifndef MALLOW_PINK
#define MALLOW_PINK RIDGWAY_MALLOW_PINK
#endif

#ifndef RIDGWAY_MALLOW_PURPLE
#define RIDGWAY_MALLOW_PURPLE float3(0.867, 0.408, 0.702)
#endif
#ifndef MALLOW_PURPLE
#define MALLOW_PURPLE RIDGWAY_MALLOW_PURPLE
#endif

#ifndef RIDGWAY_MANGANESE_VIOLET
#define RIDGWAY_MANGANESE_VIOLET float3(0.537, 0.361, 0.608)
#endif
#ifndef MANGANESE_VIOLET
#define MANGANESE_VIOLET RIDGWAY_MANGANESE_VIOLET
#endif

#ifndef RIDGWAY_MARGUERITE_YELLOW
#define RIDGWAY_MARGUERITE_YELLOW float3(0.957, 0.898, 0.741)
#endif
#ifndef MARGUERITE_YELLOW
#define MARGUERITE_YELLOW RIDGWAY_MARGUERITE_YELLOW
#endif

#ifndef RIDGWAY_MARINE_BLUE
#define RIDGWAY_MARINE_BLUE float3(0.122, 0.357, 0.494)
#endif
#ifndef MARINE_BLUE
#define MARINE_BLUE RIDGWAY_MARINE_BLUE
#endif

#ifndef RIDGWAY_MAROON
#define RIDGWAY_MAROON float3(0.357, 0.231, 0.204)
#endif
#ifndef MAROON
#define MAROON RIDGWAY_MAROON
#endif

#ifndef RIDGWAY_MARS_BROWN
#define RIDGWAY_MARS_BROWN float3(0.467, 0.341, 0.259)
#endif
#ifndef MARS_BROWN
#define MARS_BROWN RIDGWAY_MARS_BROWN
#endif

#ifndef RIDGWAY_MARS_ORANGE
#define RIDGWAY_MARS_ORANGE float3(0.753, 0.333, 0.157)
#endif
#ifndef MARS_ORANGE
#define MARS_ORANGE RIDGWAY_MARS_ORANGE
#endif

#ifndef RIDGWAY_MARS_VIOLET
#define RIDGWAY_MARS_VIOLET float3(0.400, 0.290, 0.282)
#endif
#ifndef MARS_VIOLET
#define MARS_VIOLET RIDGWAY_MARS_VIOLET
#endif

#ifndef RIDGWAY_MARS_YELLOW
#define RIDGWAY_MARS_YELLOW float3(0.765, 0.463, 0.102)
#endif
#ifndef MARS_YELLOW
#define MARS_YELLOW RIDGWAY_MARS_YELLOW
#endif

#ifndef RIDGWAY_MARTIUS_YELLOW
#define RIDGWAY_MARTIUS_YELLOW float3(0.988, 0.922, 0.624)
#endif
#ifndef MARTIUS_YELLOW
#define MARTIUS_YELLOW RIDGWAY_MARTIUS_YELLOW
#endif

#ifndef RIDGWAY_MASSICOT_YELLOW
#define RIDGWAY_MASSICOT_YELLOW float3(0.965, 0.894, 0.651)
#endif
#ifndef MASSICOT_YELLOW
#define MASSICOT_YELLOW RIDGWAY_MASSICOT_YELLOW
#endif

#ifndef RIDGWAY_MATHEWS_BLUE
#define RIDGWAY_MATHEWS_BLUE float3(0.282, 0.580, 0.769)
#endif
#ifndef MATHEWS_BLUE
#define MATHEWS_BLUE RIDGWAY_MATHEWS_BLUE
#endif

#ifndef RIDGWAY_MATHEWS_PURPLE
#define RIDGWAY_MATHEWS_PURPLE float3(0.624, 0.369, 0.612)
#endif
#ifndef MATHEWS_PURPLE
#define MATHEWS_PURPLE RIDGWAY_MATHEWS_PURPLE
#endif

#ifndef RIDGWAY_MAUVE
#define RIDGWAY_MAUVE float3(0.655, 0.529, 0.808)
#endif
#ifndef MAUVE
#define MAUVE RIDGWAY_MAUVE
#endif

#ifndef RIDGWAY_MAUVETTE
#define RIDGWAY_MAUVETTE float3(0.878, 0.792, 0.886)
#endif
#ifndef MAUVETTE
#define MAUVETTE RIDGWAY_MAUVETTE
#endif

#ifndef RIDGWAY_MAZARINE_BLUE
#define RIDGWAY_MAZARINE_BLUE float3(0.557, 0.710, 0.949)
#endif
#ifndef MAZARINE_BLUE
#define MAZARINE_BLUE RIDGWAY_MAZARINE_BLUE
#endif

#ifndef RIDGWAY_MEADOW_GREEN
#define RIDGWAY_MEADOW_GREEN float3(0.298, 0.471, 0.373)
#endif
#ifndef MEADOW_GREEN
#define MEADOW_GREEN RIDGWAY_MEADOW_GREEN
#endif

#ifndef RIDGWAY_MEDAL_BRONZE
#define RIDGWAY_MEDAL_BRONZE float3(0.459, 0.376, 0.200)
#endif
#ifndef MEDAL_BRONZE
#define MEDAL_BRONZE RIDGWAY_MEDAL_BRONZE
#endif

#ifndef RIDGWAY_MEDICI_BLUE
#define RIDGWAY_MEDICI_BLUE float3(0.455, 0.565, 0.561)
#endif
#ifndef MEDICI_BLUE
#define MEDICI_BLUE RIDGWAY_MEDICI_BLUE
#endif

#ifndef RIDGWAY_METHYL_BLUE
#define RIDGWAY_METHYL_BLUE float3(0.137, 0.471, 0.792)
#endif
#ifndef METHYL_BLUE
#define METHYL_BLUE RIDGWAY_METHYL_BLUE
#endif

#ifndef RIDGWAY_METHYL_GREEN
#define RIDGWAY_METHYL_GREEN float3(0.251, 0.604, 0.608)
#endif
#ifndef METHYL_GREEN
#define METHYL_GREEN RIDGWAY_METHYL_GREEN
#endif

#ifndef RIDGWAY_MICROCLINE_GREEN
#define RIDGWAY_MICROCLINE_GREEN float3(0.757, 0.894, 0.831)
#endif
#ifndef MICROCLINE_GREEN
#define MICROCLINE_GREEN RIDGWAY_MICROCLINE_GREEN
#endif

#ifndef RIDGWAY_MIGNONETTE_GREEN
#define RIDGWAY_MIGNONETTE_GREEN float3(0.659, 0.620, 0.384)
#endif
#ifndef MIGNONETTE_GREEN
#define MIGNONETTE_GREEN RIDGWAY_MIGNONETTE_GREEN
#endif

#ifndef RIDGWAY_MIKADO_BROWN
#define RIDGWAY_MIKADO_BROWN float3(0.667, 0.459, 0.325)
#endif
#ifndef MIKADO_BROWN
#define MIKADO_BROWN RIDGWAY_MIKADO_BROWN
#endif

#ifndef RIDGWAY_MIKADO_ORANGE
#define RIDGWAY_MIKADO_ORANGE float3(0.996, 0.580, 0.263)
#endif
#ifndef MIKADO_ORANGE
#define MIKADO_ORANGE RIDGWAY_MIKADO_ORANGE
#endif

#ifndef RIDGWAY_MINERAL_GRAY
#define RIDGWAY_MINERAL_GRAY float3(0.682, 0.694, 0.639)
#endif
#ifndef MINERAL_GRAY
#define MINERAL_GRAY RIDGWAY_MINERAL_GRAY
#endif

#ifndef RIDGWAY_MINERAL_GREEN
#define RIDGWAY_MINERAL_GREEN float3(0.678, 0.745, 0.376)
#endif
#ifndef MINERAL_GREEN
#define MINERAL_GREEN RIDGWAY_MINERAL_GREEN
#endif

#ifndef RIDGWAY_MINERAL_RED
#define RIDGWAY_MINERAL_RED float3(0.537, 0.325, 0.318)
#endif
#ifndef MINERAL_RED
#define MINERAL_RED RIDGWAY_MINERAL_RED
#endif

#ifndef RIDGWAY_MONTPELLIER_GREEN
#define RIDGWAY_MONTPELLIER_GREEN float3(0.392, 0.588, 0.533)
#endif
#ifndef MONTPELLIER_GREEN
#define MONTPELLIER_GREEN RIDGWAY_MONTPELLIER_GREEN
#endif

#ifndef RIDGWAY_MOROCCO_RED
#define RIDGWAY_MOROCCO_RED float3(0.510, 0.243, 0.188)
#endif
#ifndef MOROCCO_RED
#define MOROCCO_RED RIDGWAY_MOROCCO_RED
#endif

#ifndef RIDGWAY_MOTMOT_BLUE
#define RIDGWAY_MOTMOT_BLUE float3(0.224, 0.600, 0.671)
#endif
#ifndef MOTMOT_BLUE
#define MOTMOT_BLUE RIDGWAY_MOTMOT_BLUE
#endif

#ifndef RIDGWAY_MOTMOT_GREEN
#define RIDGWAY_MOTMOT_GREEN float3(0.400, 0.616, 0.478)
#endif
#ifndef MOTMOT_GREEN
#define MOTMOT_GREEN RIDGWAY_MOTMOT_GREEN
#endif

#ifndef RIDGWAY_MOUSE_GRAY
#define RIDGWAY_MOUSE_GRAY float3(0.514, 0.494, 0.439)
#endif
#ifndef MOUSE_GRAY
#define MOUSE_GRAY RIDGWAY_MOUSE_GRAY
#endif

#ifndef RIDGWAY_MULBERRY_PURPLE
#define RIDGWAY_MULBERRY_PURPLE float3(0.396, 0.255, 0.435)
#endif
#ifndef MULBERRY_PURPLE
#define MULBERRY_PURPLE RIDGWAY_MULBERRY_PURPLE
#endif

#ifndef RIDGWAY_MUMMY_BROWN
#define RIDGWAY_MUMMY_BROWN float3(0.408, 0.333, 0.239)
#endif
#ifndef MUMMY_BROWN
#define MUMMY_BROWN RIDGWAY_MUMMY_BROWN
#endif

#ifndef RIDGWAY_MUSTARD_YELLOW
#define RIDGWAY_MUSTARD_YELLOW float3(0.957, 0.784, 0.388)
#endif
#ifndef MUSTARD_YELLOW
#define MUSTARD_YELLOW RIDGWAY_MUSTARD_YELLOW
#endif

#ifndef RIDGWAY_MYRTLE_GREEN
#define RIDGWAY_MYRTLE_GREEN float3(0.098, 0.380, 0.392)
#endif
#ifndef MYRTLE_GREEN
#define MYRTLE_GREEN RIDGWAY_MYRTLE_GREEN
#endif

#ifndef RIDGWAY_MYTHO_GREEN
#define RIDGWAY_MYTHO_GREEN float3(0.612, 0.678, 0.545)
#endif
#ifndef MYTHO_GREEN
#define MYTHO_GREEN RIDGWAY_MYTHO_GREEN
#endif

#ifndef RIDGWAY_NAPHTHALENE_VIOLET
#define RIDGWAY_NAPHTHALENE_VIOLET float3(0.431, 0.322, 0.376)
#endif
#ifndef NAPHTHALENE_VIOLET
#define NAPHTHALENE_VIOLET RIDGWAY_NAPHTHALENE_VIOLET
#endif

#ifndef RIDGWAY_NAPHTHALENE_YELLOW
#define RIDGWAY_NAPHTHALENE_YELLOW float3(0.976, 0.914, 0.655)
#endif
#ifndef NAPHTHALENE_YELLOW
#define NAPHTHALENE_YELLOW RIDGWAY_NAPHTHALENE_YELLOW
#endif

#ifndef RIDGWAY_NAPLES_YELLOW
#define RIDGWAY_NAPLES_YELLOW float3(0.925, 0.808, 0.533)
#endif
#ifndef NAPLES_YELLOW
#define NAPLES_YELLOW RIDGWAY_NAPLES_YELLOW
#endif

#ifndef RIDGWAY_NATAL_BROWN
#define RIDGWAY_NATAL_BROWN float3(0.467, 0.369, 0.294)
#endif
#ifndef NATAL_BROWN
#define NATAL_BROWN RIDGWAY_NATAL_BROWN
#endif

#ifndef RIDGWAY_NAVY_BLUE
#define RIDGWAY_NAVY_BLUE float3(0.318, 0.349, 0.482)
#endif
#ifndef NAVY_BLUE
#define NAVY_BLUE RIDGWAY_NAVY_BLUE
#endif

#ifndef RIDGWAY_NEROPALIN_BLUE
#define RIDGWAY_NEROPALIN_BLUE float3(0.494, 0.592, 0.753)
#endif
#ifndef NEROPALIN_BLUE
#define NEROPALIN_BLUE RIDGWAY_NEROPALIN_BLUE
#endif

#ifndef RIDGWAY_NEUTRAL_GRAY
#define RIDGWAY_NEUTRAL_GRAY float3(0.980, 0.961, 0.918)
#endif
#ifndef NEUTRAL_GRAY
#define NEUTRAL_GRAY RIDGWAY_NEUTRAL_GRAY
#endif

#ifndef RIDGWAY_NEUTRAL_RED
#define RIDGWAY_NEUTRAL_RED float3(0.514, 0.282, 0.298)
#endif
#ifndef NEUTRAL_RED
#define NEUTRAL_RED RIDGWAY_NEUTRAL_RED
#endif

#ifndef RIDGWAY_NEUVIDER_GREEN
#define RIDGWAY_NEUVIDER_GREEN float3(0.725, 0.875, 0.659)
#endif
#ifndef NEUVIDER_GREEN
#define NEUVIDER_GREEN RIDGWAY_NEUVIDER_GREEN
#endif

#ifndef RIDGWAY_NEVA_GREEN
#define RIDGWAY_NEVA_GREEN float3(0.639, 0.714, 0.361)
#endif
#ifndef NEVA_GREEN
#define NEVA_GREEN RIDGWAY_NEVA_GREEN
#endif

#ifndef RIDGWAY_NIAGARA_GREEN
#define RIDGWAY_NIAGARA_GREEN float3(0.576, 0.714, 0.651)
#endif
#ifndef NIAGARA_GREEN
#define NIAGARA_GREEN RIDGWAY_NIAGARA_GREEN
#endif

#ifndef RIDGWAY_NICKEL_GREEN
#define RIDGWAY_NICKEL_GREEN float3(0.314, 0.416, 0.349)
#endif
#ifndef NICKEL_GREEN
#define NICKEL_GREEN RIDGWAY_NICKEL_GREEN
#endif

#ifndef RIDGWAY_NIGHT_GREEN
#define RIDGWAY_NIGHT_GREEN float3(0.776, 0.847, 0.341)
#endif
#ifndef NIGHT_GREEN
#define NIGHT_GREEN RIDGWAY_NIGHT_GREEN
#endif

#ifndef RIDGWAY_NIGROSIN_BLUE
#define RIDGWAY_NIGROSIN_BLUE float3(0.267, 0.314, 0.404)
#endif
#ifndef NIGROSIN_BLUE
#define NIGROSIN_BLUE RIDGWAY_NIGROSIN_BLUE
#endif

#ifndef RIDGWAY_NIGROSIN_VIOLET
#define RIDGWAY_NIGROSIN_VIOLET float3(0.396, 0.278, 0.416)
#endif
#ifndef NIGROSIN_VIOLET
#define NIGROSIN_VIOLET RIDGWAY_NIGROSIN_VIOLET
#endif

#ifndef RIDGWAY_NILE_BLUE
#define RIDGWAY_NILE_BLUE float3(0.549, 0.792, 0.769)
#endif
#ifndef NILE_BLUE
#define NILE_BLUE RIDGWAY_NILE_BLUE
#endif

#ifndef RIDGWAY_NOPAL_RED
#define RIDGWAY_NOPAL_RED float3(0.765, 0.220, 0.216)
#endif
#ifndef NOPAL_RED
#define NOPAL_RED RIDGWAY_NOPAL_RED
#endif

#ifndef RIDGWAY_OCHER_RED
#define RIDGWAY_OCHER_RED float3(0.651, 0.396, 0.345)
#endif
#ifndef OCHER_RED
#define OCHER_RED RIDGWAY_OCHER_RED
#endif

#ifndef RIDGWAY_OCHRACEOUS_BUFF
#define RIDGWAY_OCHRACEOUS_BUFF float3(0.933, 0.667, 0.412)
#endif
#ifndef OCHRACEOUS_BUFF
#define OCHRACEOUS_BUFF RIDGWAY_OCHRACEOUS_BUFF
#endif

#ifndef RIDGWAY_OCHRACEOUS_ORANGE
#define RIDGWAY_OCHRACEOUS_ORANGE float3(0.941, 0.584, 0.231)
#endif
#ifndef OCHRACEOUS_ORANGE
#define OCHRACEOUS_ORANGE RIDGWAY_OCHRACEOUS_ORANGE
#endif

#ifndef RIDGWAY_OCHRACEOUS_SALMON
#define RIDGWAY_OCHRACEOUS_SALMON float3(0.980, 0.651, 0.431)
#endif
#ifndef OCHRACEOUS_SALMON
#define OCHRACEOUS_SALMON RIDGWAY_OCHRACEOUS_SALMON
#endif

#ifndef RIDGWAY_OCHRACEOUS_TAWNY
#define RIDGWAY_OCHRACEOUS_TAWNY float3(0.776, 0.522, 0.271)
#endif
#ifndef OCHRACEOUS_TAWNY
#define OCHRACEOUS_TAWNY RIDGWAY_OCHRACEOUS_TAWNY
#endif

#ifndef RIDGWAY_OIL_GREEN
#define RIDGWAY_OIL_GREEN float3(0.518, 0.537, 0.267)
#endif
#ifndef OIL_GREEN
#define OIL_GREEN RIDGWAY_OIL_GREEN
#endif

#ifndef RIDGWAY_OIL_YELLOW
#define RIDGWAY_OIL_YELLOW float3(0.718, 0.671, 0.275)
#endif
#ifndef OIL_YELLOW
#define OIL_YELLOW RIDGWAY_OIL_YELLOW
#endif

#ifndef RIDGWAY_OLD_GOLD
#define RIDGWAY_OLD_GOLD float3(0.733, 0.600, 0.286)
#endif
#ifndef OLD_GOLD
#define OLD_GOLD RIDGWAY_OLD_GOLD
#endif

#ifndef RIDGWAY_OLD_ROSE
#define RIDGWAY_OLD_ROSE float3(0.851, 0.412, 0.435)
#endif
#ifndef OLD_ROSE
#define OLD_ROSE RIDGWAY_OLD_ROSE
#endif

#ifndef RIDGWAY_OLIVACEOUS_BLACK_1
#define RIDGWAY_OLIVACEOUS_BLACK_1 float3(0.278, 0.302, 0.251)
#endif
#ifndef OLIVACEOUS_BLACK_1
#define OLIVACEOUS_BLACK_1 RIDGWAY_OLIVACEOUS_BLACK_1
#endif

#ifndef RIDGWAY_OLIVACEOUS_BLACK_2
#define RIDGWAY_OLIVACEOUS_BLACK_2 float3(0.259, 0.302, 0.255)
#endif
#ifndef OLIVACEOUS_BLACK_2
#define OLIVACEOUS_BLACK_2 RIDGWAY_OLIVACEOUS_BLACK_2
#endif

#ifndef RIDGWAY_OLIVACEOUS_BLACK_3
#define RIDGWAY_OLIVACEOUS_BLACK_3 float3(0.314, 0.333, 0.314)
#endif
#ifndef OLIVACEOUS_BLACK_3
#define OLIVACEOUS_BLACK_3 RIDGWAY_OLIVACEOUS_BLACK_3
#endif

#ifndef RIDGWAY_OLIVE
#define RIDGWAY_OLIVE float3(0.392, 0.373, 0.275)
#endif
#ifndef OLIVE
#define OLIVE RIDGWAY_OLIVE
#endif

#ifndef RIDGWAY_OLIVE_LAKE
#define RIDGWAY_OLIVE_LAKE float3(0.620, 0.537, 0.298)
#endif
#ifndef OLIVE_LAKE
#define OLIVE_LAKE RIDGWAY_OLIVE_LAKE
#endif

#ifndef RIDGWAY_OLIVE_BROWN
#define RIDGWAY_OLIVE_BROWN float3(0.443, 0.373, 0.290)
#endif
#ifndef OLIVE_BROWN
#define OLIVE_BROWN RIDGWAY_OLIVE_BROWN
#endif

#ifndef RIDGWAY_OLIVE_BUFF
#define RIDGWAY_OLIVE_BUFF float3(0.812, 0.761, 0.631)
#endif
#ifndef OLIVE_BUFF
#define OLIVE_BUFF RIDGWAY_OLIVE_BUFF
#endif

#ifndef RIDGWAY_OLIVE_CITRINE
#define RIDGWAY_OLIVE_CITRINE float3(0.435, 0.427, 0.267)
#endif
#ifndef OLIVE_CITRINE
#define OLIVE_CITRINE RIDGWAY_OLIVE_CITRINE
#endif

#ifndef RIDGWAY_OLIVE_GRAY
#define RIDGWAY_OLIVE_GRAY float3(0.576, 0.580, 0.522)
#endif
#ifndef OLIVE_GRAY
#define OLIVE_GRAY RIDGWAY_OLIVE_GRAY
#endif

#ifndef RIDGWAY_OLIVE_GREEN
#define RIDGWAY_OLIVE_GREEN float3(0.427, 0.427, 0.247)
#endif
#ifndef OLIVE_GREEN
#define OLIVE_GREEN RIDGWAY_OLIVE_GREEN
#endif

#ifndef RIDGWAY_OLIVE_OCHER
#define RIDGWAY_OLIVE_OCHER float3(0.776, 0.639, 0.298)
#endif
#ifndef OLIVE_OCHER
#define OLIVE_OCHER RIDGWAY_OLIVE_OCHER
#endif

#ifndef RIDGWAY_OLIVE_YELLOW
#define RIDGWAY_OLIVE_YELLOW float3(0.773, 0.710, 0.329)
#endif
#ifndef OLIVE_YELLOW
#define OLIVE_YELLOW RIDGWAY_OLIVE_YELLOW
#endif

#ifndef RIDGWAY_OLIVINE
#define RIDGWAY_OLIVINE float3(0.737, 0.788, 0.604)
#endif
#ifndef OLIVINE
#define OLIVINE RIDGWAY_OLIVINE
#endif

#ifndef RIDGWAY_OLYMPIC_BLUE
#define RIDGWAY_OLYMPIC_BLUE float3(0.353, 0.576, 0.820)
#endif
#ifndef OLYMPIC_BLUE
#define OLYMPIC_BLUE RIDGWAY_OLYMPIC_BLUE
#endif

#ifndef RIDGWAY_ONION_SKIN_PINK
#define RIDGWAY_ONION_SKIN_PINK float3(0.855, 0.588, 0.471)
#endif
#ifndef ONION_SKIN_PINK
#define ONION_SKIN_PINK RIDGWAY_ONION_SKIN_PINK
#endif

#ifndef RIDGWAY_ONTARIO_VIOLET
#define RIDGWAY_ONTARIO_VIOLET float3(0.569, 0.600, 0.757)
#endif
#ifndef ONTARIO_VIOLET
#define ONTARIO_VIOLET RIDGWAY_ONTARIO_VIOLET
#endif

#ifndef RIDGWAY_OPALINE_GREEN
#define RIDGWAY_OPALINE_GREEN float3(0.863, 0.914, 0.761)
#endif
#ifndef OPALINE_GREEN
#define OPALINE_GREEN RIDGWAY_OPALINE_GREEN
#endif

#ifndef RIDGWAY_ORANGE
#define RIDGWAY_ORANGE float3(0.996, 0.557, 0.027)
#endif
#ifndef ORANGE
#define ORANGE RIDGWAY_ORANGE
#endif

#ifndef RIDGWAY_ORANGE_CHROME
#define RIDGWAY_ORANGE_CHROME float3(0.992, 0.490, 0.122)
#endif
#ifndef ORANGE_CHROME
#define ORANGE_CHROME RIDGWAY_ORANGE_CHROME
#endif

#ifndef RIDGWAY_ORANGE_BUFF
#define RIDGWAY_ORANGE_BUFF float3(0.996, 0.827, 0.612)
#endif
#ifndef ORANGE_BUFF
#define ORANGE_BUFF RIDGWAY_ORANGE_BUFF
#endif

#ifndef RIDGWAY_ORANGE_CINNAMON
#define RIDGWAY_ORANGE_CINNAMON float3(0.769, 0.510, 0.337)
#endif
#ifndef ORANGE_CINNAMON
#define ORANGE_CINNAMON RIDGWAY_ORANGE_CINNAMON
#endif

#ifndef RIDGWAY_ORANGE_CITRINE
#define RIDGWAY_ORANGE_CITRINE float3(0.580, 0.463, 0.161)
#endif
#ifndef ORANGE_CITRINE
#define ORANGE_CITRINE RIDGWAY_ORANGE_CITRINE
#endif

#ifndef RIDGWAY_ORANGE_PINK
#define RIDGWAY_ORANGE_PINK float3(0.996, 0.796, 0.655)
#endif
#ifndef ORANGE_PINK
#define ORANGE_PINK RIDGWAY_ORANGE_PINK
#endif

#ifndef RIDGWAY_ORANGE_RUFOUS
#define RIDGWAY_ORANGE_RUFOUS float3(0.796, 0.388, 0.145)
#endif
#ifndef ORANGE_RUFOUS
#define ORANGE_RUFOUS RIDGWAY_ORANGE_RUFOUS
#endif

#ifndef RIDGWAY_ORANGE_VINACEOUS
#define RIDGWAY_ORANGE_VINACEOUS float3(0.780, 0.533, 0.498)
#endif
#ifndef ORANGE_VINACEOUS
#define ORANGE_VINACEOUS RIDGWAY_ORANGE_VINACEOUS
#endif

#ifndef RIDGWAY_ORIENT_BLUE
#define RIDGWAY_ORIENT_BLUE float3(0.392, 0.537, 0.647)
#endif
#ifndef ORIENT_BLUE
#define ORIENT_BLUE RIDGWAY_ORIENT_BLUE
#endif

#ifndef RIDGWAY_ORIENT_PINK
#define RIDGWAY_ORIENT_PINK float3(0.996, 0.773, 0.686)
#endif
#ifndef ORIENT_PINK
#define ORIENT_PINK RIDGWAY_ORIENT_PINK
#endif

#ifndef RIDGWAY_ORIENTAL_GREEN
#define RIDGWAY_ORIENTAL_GREEN float3(0.459, 0.675, 0.475)
#endif
#ifndef ORIENTAL_GREEN
#define ORIENTAL_GREEN RIDGWAY_ORIENTAL_GREEN
#endif

#ifndef RIDGWAY_OURAL_GREEN
#define RIDGWAY_OURAL_GREEN float3(0.816, 0.878, 0.729)
#endif
#ifndef OURAL_GREEN
#define OURAL_GREEN RIDGWAY_OURAL_GREEN
#endif

#ifndef RIDGWAY_OX_BLOOD_RED
#define RIDGWAY_OX_BLOOD_RED float3(0.478, 0.212, 0.200)
#endif
#ifndef OX_BLOOD_RED
#define OX_BLOOD_RED RIDGWAY_OX_BLOOD_RED
#endif

#ifndef RIDGWAY_OXIDE_BLUE
#define RIDGWAY_OXIDE_BLUE float3(0.012, 0.416, 0.678)
#endif
#ifndef OXIDE_BLUE
#define OXIDE_BLUE RIDGWAY_OXIDE_BLUE
#endif

#ifndef RIDGWAY_PALE_AMARANTH_PINK
#define RIDGWAY_PALE_AMARANTH_PINK float3(0.988, 0.753, 0.933)
#endif
#ifndef PALE_AMARANTH_PINK
#define PALE_AMARANTH_PINK RIDGWAY_PALE_AMARANTH_PINK
#endif

#ifndef RIDGWAY_PALE_AMPARO_BLUE
#define RIDGWAY_PALE_AMPARO_BLUE float3(0.765, 0.835, 0.969)
#endif
#ifndef PALE_AMPARO_BLUE
#define PALE_AMPARO_BLUE RIDGWAY_PALE_AMPARO_BLUE
#endif

#ifndef RIDGWAY_PALE_AMPARO_PURPLE
#define RIDGWAY_PALE_AMPARO_PURPLE float3(0.922, 0.702, 0.945)
#endif
#ifndef PALE_AMPARO_PURPLE
#define PALE_AMPARO_PURPLE RIDGWAY_PALE_AMPARO_PURPLE
#endif

#ifndef RIDGWAY_PALE_ANILINE_LILAC
#define RIDGWAY_PALE_ANILINE_LILAC float3(0.788, 0.761, 0.808)
#endif
#ifndef PALE_ANILINE_LILAC
#define PALE_ANILINE_LILAC RIDGWAY_PALE_ANILINE_LILAC
#endif

#ifndef RIDGWAY_PALE_BLUE_ETHYL_BLUE
#define RIDGWAY_PALE_BLUE_ETHYL_BLUE float3(0.741, 0.886, 0.925)
#endif
#ifndef PALE_BLUE_ETHYL_BLUE
#define PALE_BLUE_ETHYL_BLUE RIDGWAY_PALE_BLUE_ETHYL_BLUE
#endif

#ifndef RIDGWAY_PALE_BLUE_GREEN
#define RIDGWAY_PALE_BLUE_GREEN float3(0.835, 0.937, 0.820)
#endif
#ifndef PALE_BLUE_GREEN
#define PALE_BLUE_GREEN RIDGWAY_PALE_BLUE_GREEN
#endif

#ifndef RIDGWAY_PALE_BLUE_VIOLET
#define RIDGWAY_PALE_BLUE_VIOLET float3(0.678, 0.729, 0.953)
#endif
#ifndef PALE_BLUE_VIOLET
#define PALE_BLUE_VIOLET RIDGWAY_PALE_BLUE_VIOLET
#endif

#ifndef RIDGWAY_PALE_BLUISH_LAVENDER
#define RIDGWAY_PALE_BLUISH_LAVENDER float3(0.831, 0.796, 0.843)
#endif
#ifndef PALE_BLUISH_LAVENDER
#define PALE_BLUISH_LAVENDER RIDGWAY_PALE_BLUISH_LAVENDER
#endif

#ifndef RIDGWAY_PALE_BLUISH_VIOLET
#define RIDGWAY_PALE_BLUISH_VIOLET float3(0.698, 0.714, 0.937)
#endif
#ifndef PALE_BLUISH_VIOLET
#define PALE_BLUISH_VIOLET RIDGWAY_PALE_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_PALE_BROWNISH_DRAB
#define RIDGWAY_PALE_BROWNISH_DRAB float3(0.729, 0.671, 0.639)
#endif
#ifndef PALE_BROWNISH_DRAB
#define PALE_BROWNISH_DRAB RIDGWAY_PALE_BROWNISH_DRAB
#endif

#ifndef RIDGWAY_PALE_BROWNISH_VINACEOUS
#define RIDGWAY_PALE_BROWNISH_VINACEOUS float3(0.867, 0.765, 0.733)
#endif
#ifndef PALE_BROWNISH_VINACEOUS
#define PALE_BROWNISH_VINACEOUS RIDGWAY_PALE_BROWNISH_VINACEOUS
#endif

#ifndef RIDGWAY_PALE_CADET_BLUE
#define RIDGWAY_PALE_CADET_BLUE float3(0.647, 0.737, 0.929)
#endif
#ifndef PALE_CADET_BLUE
#define PALE_CADET_BLUE RIDGWAY_PALE_CADET_BLUE
#endif

#ifndef RIDGWAY_PALE_CAMPANULA_BLUE
#define RIDGWAY_PALE_CAMPANULA_BLUE float3(0.780, 0.800, 0.890)
#endif
#ifndef PALE_CAMPANULA_BLUE
#define PALE_CAMPANULA_BLUE RIDGWAY_PALE_CAMPANULA_BLUE
#endif

#ifndef RIDGWAY_PALE_CENDRE_GREEN
#define RIDGWAY_PALE_CENDRE_GREEN float3(0.925, 0.925, 0.737)
#endif
#ifndef PALE_CENDRE_GREEN
#define PALE_CENDRE_GREEN RIDGWAY_PALE_CENDRE_GREEN
#endif

#ifndef RIDGWAY_PALE_CERULEAN_BLUE
#define RIDGWAY_PALE_CERULEAN_BLUE float3(0.580, 0.800, 0.929)
#endif
#ifndef PALE_CERULEAN_BLUE
#define PALE_CERULEAN_BLUE RIDGWAY_PALE_CERULEAN_BLUE
#endif

#ifndef RIDGWAY_PALE_CHALCEDONY_YELLOW
#define RIDGWAY_PALE_CHALCEDONY_YELLOW float3(0.941, 0.910, 0.710)
#endif
#ifndef PALE_CHALCEDONY_YELLOW
#define PALE_CHALCEDONY_YELLOW RIDGWAY_PALE_CHALCEDONY_YELLOW
#endif

#ifndef RIDGWAY_PALE_CINNAMON_PINK
#define RIDGWAY_PALE_CINNAMON_PINK float3(0.961, 0.827, 0.765)
#endif
#ifndef PALE_CINNAMON_PINK
#define PALE_CINNAMON_PINK RIDGWAY_PALE_CINNAMON_PINK
#endif

#ifndef RIDGWAY_PALE_CONGO_PINK
#define RIDGWAY_PALE_CONGO_PINK float3(0.898, 0.769, 0.718)
#endif
#ifndef PALE_CONGO_PINK
#define PALE_CONGO_PINK RIDGWAY_PALE_CONGO_PINK
#endif

#ifndef RIDGWAY_PALE_DRAB_GRAY
#define RIDGWAY_PALE_DRAB_GRAY float3(0.765, 0.737, 0.698)
#endif
#ifndef PALE_DRAB_GRAY
#define PALE_DRAB_GRAY RIDGWAY_PALE_DRAB_GRAY
#endif

#ifndef RIDGWAY_PALE_DULL_GLAUCOUS_BLUE
#define RIDGWAY_PALE_DULL_GLAUCOUS_BLUE float3(0.714, 0.800, 0.792)
#endif
#ifndef PALE_DULL_GLAUCOUS_BLUE
#define PALE_DULL_GLAUCOUS_BLUE RIDGWAY_PALE_DULL_GLAUCOUS_BLUE
#endif

#ifndef RIDGWAY_PALE_DULL_GREEN_YELLOW
#define RIDGWAY_PALE_DULL_GREEN_YELLOW float3(0.937, 0.914, 0.690)
#endif
#ifndef PALE_DULL_GREEN_YELLOW
#define PALE_DULL_GREEN_YELLOW RIDGWAY_PALE_DULL_GREEN_YELLOW
#endif

#ifndef RIDGWAY_PALE_ECRU_DRAB
#define RIDGWAY_PALE_ECRU_DRAB float3(0.761, 0.718, 0.678)
#endif
#ifndef PALE_ECRU_DRAB
#define PALE_ECRU_DRAB RIDGWAY_PALE_ECRU_DRAB
#endif

#ifndef RIDGWAY_PALE_FLESH_COLOR
#define RIDGWAY_PALE_FLESH_COLOR float3(0.961, 0.808, 0.753)
#endif
#ifndef PALE_FLESH_COLOR
#define PALE_FLESH_COLOR RIDGWAY_PALE_FLESH_COLOR
#endif

#ifndef RIDGWAY_PALE_FLUORITE_GREEN
#define RIDGWAY_PALE_FLUORITE_GREEN float3(0.855, 0.867, 0.737)
#endif
#ifndef PALE_FLUORITE_GREEN
#define PALE_FLUORITE_GREEN RIDGWAY_PALE_FLUORITE_GREEN
#endif

#ifndef RIDGWAY_PALE_FORGET_ME_NOT_BLUE
#define RIDGWAY_PALE_FORGET_ME_NOT_BLUE float3(0.729, 0.769, 0.831)
#endif
#ifndef PALE_FORGET_ME_NOT_BLUE
#define PALE_FORGET_ME_NOT_BLUE RIDGWAY_PALE_FORGET_ME_NOT_BLUE
#endif

#ifndef RIDGWAY_PALE_GLASS_GREEN
#define RIDGWAY_PALE_GLASS_GREEN float3(0.894, 0.863, 0.694)
#endif
#ifndef PALE_GLASS_GREEN
#define PALE_GLASS_GREEN RIDGWAY_PALE_GLASS_GREEN
#endif

#ifndef RIDGWAY_PALE_GLAUCOUS_BLUE
#define RIDGWAY_PALE_GLAUCOUS_BLUE float3(0.737, 0.800, 0.800)
#endif
#ifndef PALE_GLAUCOUS_BLUE
#define PALE_GLAUCOUS_BLUE RIDGWAY_PALE_GLAUCOUS_BLUE
#endif

#ifndef RIDGWAY_PALE_GLAUCOUS_GREEN
#define RIDGWAY_PALE_GLAUCOUS_GREEN float3(0.839, 0.867, 0.800)
#endif
#ifndef PALE_GLAUCOUS_GREEN
#define PALE_GLAUCOUS_GREEN RIDGWAY_PALE_GLAUCOUS_GREEN
#endif

#ifndef RIDGWAY_PALE_GRAYISH_BLUE
#define RIDGWAY_PALE_GRAYISH_BLUE float3(0.773, 0.847, 0.965)
#endif
#ifndef PALE_GRAYISH_BLUE
#define PALE_GRAYISH_BLUE RIDGWAY_PALE_GRAYISH_BLUE
#endif

#ifndef RIDGWAY_PALE_GRAYISH_BLUE_VIOLET
#define RIDGWAY_PALE_GRAYISH_BLUE_VIOLET float3(0.761, 0.753, 0.812)
#endif
#ifndef PALE_GRAYISH_BLUE_VIOLET
#define PALE_GRAYISH_BLUE_VIOLET RIDGWAY_PALE_GRAYISH_BLUE_VIOLET
#endif

#ifndef RIDGWAY_PALE_GRAYISH_VINACEOUS
#define RIDGWAY_PALE_GRAYISH_VINACEOUS float3(0.863, 0.773, 0.722)
#endif
#ifndef PALE_GRAYISH_VINACEOUS
#define PALE_GRAYISH_VINACEOUS RIDGWAY_PALE_GRAYISH_VINACEOUS
#endif

#ifndef RIDGWAY_PALE_GRAYISH_VIOLET_BLUE
#define RIDGWAY_PALE_GRAYISH_VIOLET_BLUE float3(0.624, 0.675, 0.851)
#endif
#ifndef PALE_GRAYISH_VIOLET_BLUE
#define PALE_GRAYISH_VIOLET_BLUE RIDGWAY_PALE_GRAYISH_VIOLET_BLUE
#endif

#ifndef RIDGWAY_PALE_GREEN_BLUE_GRAY
#define RIDGWAY_PALE_GREEN_BLUE_GRAY float3(0.659, 0.698, 0.706)
#endif
#ifndef PALE_GREEN_BLUE_GRAY
#define PALE_GREEN_BLUE_GRAY RIDGWAY_PALE_GREEN_BLUE_GRAY
#endif

#ifndef RIDGWAY_PALE_GREEN_YELLOW
#define RIDGWAY_PALE_GREEN_YELLOW float3(0.973, 0.933, 0.639)
#endif
#ifndef PALE_GREEN_YELLOW
#define PALE_GREEN_YELLOW RIDGWAY_PALE_GREEN_YELLOW
#endif

#ifndef RIDGWAY_PALE_GREENISH_YELLOW
#define RIDGWAY_PALE_GREENISH_YELLOW float3(0.761, 0.702, 0.451)
#endif
#ifndef PALE_GREENISH_YELLOW
#define PALE_GREENISH_YELLOW RIDGWAY_PALE_GREENISH_YELLOW
#endif

#ifndef RIDGWAY_PALE_GULL_GRAY
#define RIDGWAY_PALE_GULL_GRAY float3(0.769, 0.749, 0.694)
#endif
#ifndef PALE_GULL_GRAY
#define PALE_GULL_GRAY RIDGWAY_PALE_GULL_GRAY
#endif

#ifndef RIDGWAY_PALE_HORTENSE_VIOLET
#define RIDGWAY_PALE_HORTENSE_VIOLET float3(0.878, 0.718, 0.949)
#endif
#ifndef PALE_HORTENSE_VIOLET
#define PALE_HORTENSE_VIOLET RIDGWAY_PALE_HORTENSE_VIOLET
#endif

#ifndef RIDGWAY_PALE_KINGS_BLUE
#define RIDGWAY_PALE_KINGS_BLUE float3(0.757, 0.800, 0.831)
#endif
#ifndef PALE_KINGS_BLUE
#define PALE_KINGS_BLUE RIDGWAY_PALE_KINGS_BLUE
#endif

#ifndef RIDGWAY_PALE_LAELIA_PINK
#define RIDGWAY_PALE_LAELIA_PINK float3(0.859, 0.741, 0.769)
#endif
#ifndef PALE_LAELIA_PINK
#define PALE_LAELIA_PINK RIDGWAY_PALE_LAELIA_PINK
#endif

#ifndef RIDGWAY_PALE_LAVENDER_VIOLET
#define RIDGWAY_PALE_LAVENDER_VIOLET float3(0.843, 0.773, 0.882)
#endif
#ifndef PALE_LAVENDER_VIOLET
#define PALE_LAVENDER_VIOLET RIDGWAY_PALE_LAVENDER_VIOLET
#endif

#ifndef RIDGWAY_PALE_LEMON_YELLOW
#define RIDGWAY_PALE_LEMON_YELLOW float3(0.996, 0.898, 0.384)
#endif
#ifndef PALE_LEMON_YELLOW
#define PALE_LEMON_YELLOW RIDGWAY_PALE_LEMON_YELLOW
#endif

#ifndef RIDGWAY_PALE_LILAC
#define RIDGWAY_PALE_LILAC float3(0.847, 0.773, 0.816)
#endif
#ifndef PALE_LILAC
#define PALE_LILAC RIDGWAY_PALE_LILAC
#endif

#ifndef RIDGWAY_PALE_LOBELIA_VIOLET
#define RIDGWAY_PALE_LOBELIA_VIOLET float3(0.824, 0.765, 0.800)
#endif
#ifndef PALE_LOBELIA_VIOLET
#define PALE_LOBELIA_VIOLET RIDGWAY_PALE_LOBELIA_VIOLET
#endif

#ifndef RIDGWAY_PALE_LUMIERE_GREEN
#define RIDGWAY_PALE_LUMIERE_GREEN float3(0.898, 0.906, 0.698)
#endif
#ifndef PALE_LUMIERE_GREEN
#define PALE_LUMIERE_GREEN RIDGWAY_PALE_LUMIERE_GREEN
#endif

#ifndef RIDGWAY_PALE_MAUVE
#define RIDGWAY_PALE_MAUVE float3(0.851, 0.784, 0.937)
#endif
#ifndef PALE_MAUVE
#define PALE_MAUVE RIDGWAY_PALE_MAUVE
#endif

#ifndef RIDGWAY_PALE_MAZARINE_BLUE
#define RIDGWAY_PALE_MAZARINE_BLUE float3(0.769, 0.855, 0.965)
#endif
#ifndef PALE_MAZARINE_BLUE
#define PALE_MAZARINE_BLUE RIDGWAY_PALE_MAZARINE_BLUE
#endif

#ifndef RIDGWAY_PALE_MEDICI_BLUE
#define RIDGWAY_PALE_MEDICI_BLUE float3(0.647, 0.690, 0.690)
#endif
#ifndef PALE_MEDICI_BLUE
#define PALE_MEDICI_BLUE RIDGWAY_PALE_MEDICI_BLUE
#endif

#ifndef RIDGWAY_PALE_METHYL_BLUE
#define RIDGWAY_PALE_METHYL_BLUE float3(0.569, 0.769, 0.894)
#endif
#ifndef PALE_METHYL_BLUE
#define PALE_METHYL_BLUE RIDGWAY_PALE_METHYL_BLUE
#endif

#ifndef RIDGWAY_PALE_MOUSE_GRAY
#define RIDGWAY_PALE_MOUSE_GRAY float3(0.663, 0.643, 0.604)
#endif
#ifndef PALE_MOUSE_GRAY
#define PALE_MOUSE_GRAY RIDGWAY_PALE_MOUSE_GRAY
#endif

#ifndef RIDGWAY_PALE_NEROPALIN_BLUE
#define RIDGWAY_PALE_NEROPALIN_BLUE float3(0.722, 0.773, 0.839)
#endif
#ifndef PALE_NEROPALIN_BLUE
#define PALE_NEROPALIN_BLUE RIDGWAY_PALE_NEROPALIN_BLUE
#endif

#ifndef RIDGWAY_PALE_NEUTRAL_GRAY
#define RIDGWAY_PALE_NEUTRAL_GRAY float3(0.635, 0.635, 0.604)
#endif
#ifndef PALE_NEUTRAL_GRAY
#define PALE_NEUTRAL_GRAY RIDGWAY_PALE_NEUTRAL_GRAY
#endif

#ifndef RIDGWAY_PALE_NIAGARA_GREEN
#define RIDGWAY_PALE_NIAGARA_GREEN float3(0.784, 0.839, 0.776)
#endif
#ifndef PALE_NIAGARA_GREEN
#define PALE_NIAGARA_GREEN RIDGWAY_PALE_NIAGARA_GREEN
#endif

#ifndef RIDGWAY_PALE_NILE_BLUE
#define RIDGWAY_PALE_NILE_BLUE float3(0.725, 0.871, 0.843)
#endif
#ifndef PALE_NILE_BLUE
#define PALE_NILE_BLUE RIDGWAY_PALE_NILE_BLUE
#endif

#ifndef RIDGWAY_PALE_OCHRACEOUS_BUFF
#define RIDGWAY_PALE_OCHRACEOUS_BUFF float3(0.988, 0.851, 0.714)
#endif
#ifndef PALE_OCHRACEOUS_BUFF
#define PALE_OCHRACEOUS_BUFF RIDGWAY_PALE_OCHRACEOUS_BUFF
#endif

#ifndef RIDGWAY_PALE_OCHRACEOUS_SALMON
#define RIDGWAY_PALE_OCHRACEOUS_SALMON float3(0.996, 0.851, 0.733)
#endif
#ifndef PALE_OCHRACEOUS_SALMON
#define PALE_OCHRACEOUS_SALMON RIDGWAY_PALE_OCHRACEOUS_SALMON
#endif

#ifndef RIDGWAY_PALE_OLIVE_BUFF
#define RIDGWAY_PALE_OLIVE_BUFF float3(0.863, 0.816, 0.714)
#endif
#ifndef PALE_OLIVE_BUFF
#define PALE_OLIVE_BUFF RIDGWAY_PALE_OLIVE_BUFF
#endif

#ifndef RIDGWAY_PALE_OLIVE_GRAY
#define RIDGWAY_PALE_OLIVE_GRAY float3(0.722, 0.706, 0.643)
#endif
#ifndef PALE_OLIVE_GRAY
#define PALE_OLIVE_GRAY RIDGWAY_PALE_OLIVE_GRAY
#endif

#ifndef RIDGWAY_PALE_OLIVINE
#define RIDGWAY_PALE_OLIVINE float3(0.820, 0.851, 0.737)
#endif
#ifndef PALE_OLIVINE
#define PALE_OLIVINE RIDGWAY_PALE_OLIVINE
#endif

#ifndef RIDGWAY_PALE_ORANGE_YELLOW
#define RIDGWAY_PALE_ORANGE_YELLOW float3(0.996, 0.835, 0.565)
#endif
#ifndef PALE_ORANGE_YELLOW
#define PALE_ORANGE_YELLOW RIDGWAY_PALE_ORANGE_YELLOW
#endif

#ifndef RIDGWAY_PALE_PAYNES_GRAY
#define RIDGWAY_PALE_PAYNES_GRAY float3(0.624, 0.659, 0.682)
#endif
#ifndef PALE_PAYNES_GRAY
#define PALE_PAYNES_GRAY RIDGWAY_PALE_PAYNES_GRAY
#endif

#ifndef RIDGWAY_PALE_PERSIAN_LILAC
#define RIDGWAY_PALE_PERSIAN_LILAC float3(0.894, 0.753, 0.788)
#endif
#ifndef PALE_PERSIAN_LILAC
#define PALE_PERSIAN_LILAC RIDGWAY_PALE_PERSIAN_LILAC
#endif

#ifndef RIDGWAY_PALE_PINKISH_BUFF
#define RIDGWAY_PALE_PINKISH_BUFF float3(0.949, 0.839, 0.737)
#endif
#ifndef PALE_PINKISH_BUFF
#define PALE_PINKISH_BUFF RIDGWAY_PALE_PINKISH_BUFF
#endif

#ifndef RIDGWAY_PALE_PINKISH_CINNAMON
#define RIDGWAY_PALE_PINKISH_CINNAMON float3(0.953, 0.831, 0.761)
#endif
#ifndef PALE_PINKISH_CINNAMON
#define PALE_PINKISH_CINNAMON RIDGWAY_PALE_PINKISH_CINNAMON
#endif

#ifndef RIDGWAY_PALE_PURPLE_DRAB
#define RIDGWAY_PALE_PURPLE_DRAB float3(0.702, 0.635, 0.620)
#endif
#ifndef PALE_PURPLE_DRAB
#define PALE_PURPLE_DRAB RIDGWAY_PALE_PURPLE_DRAB
#endif

#ifndef RIDGWAY_PALE_PURPLISH_GRAY
#define RIDGWAY_PALE_PURPLISH_GRAY float3(0.616, 0.604, 0.584)
#endif
#ifndef PALE_PURPLISH_GRAY
#define PALE_PURPLISH_GRAY RIDGWAY_PALE_PURPLISH_GRAY
#endif

#ifndef RIDGWAY_PALE_PURPLISH_VINACEOUS
#define RIDGWAY_PALE_PURPLISH_VINACEOUS float3(0.816, 0.729, 0.710)
#endif
#ifndef PALE_PURPLISH_VINACEOUS
#define PALE_PURPLISH_VINACEOUS RIDGWAY_PALE_PURPLISH_VINACEOUS
#endif

#ifndef RIDGWAY_PALE_QUAKER_DRAB
#define RIDGWAY_PALE_QUAKER_DRAB float3(0.620, 0.604, 0.584)
#endif
#ifndef PALE_QUAKER_DRAB
#define PALE_QUAKER_DRAB RIDGWAY_PALE_QUAKER_DRAB
#endif

#ifndef RIDGWAY_PALE_RHODONITE_PINK
#define RIDGWAY_PALE_RHODONITE_PINK float3(0.933, 0.776, 0.792)
#endif
#ifndef PALE_RHODONITE_PINK
#define PALE_RHODONITE_PINK RIDGWAY_PALE_RHODONITE_PINK
#endif

#ifndef RIDGWAY_PALE_ROSE_PURPLE
#define RIDGWAY_PALE_ROSE_PURPLE float3(0.902, 0.769, 0.843)
#endif
#ifndef PALE_ROSE_PURPLE
#define PALE_ROSE_PURPLE RIDGWAY_PALE_ROSE_PURPLE
#endif

#ifndef RIDGWAY_PALE_ROSOLANE_PURPLE
#define RIDGWAY_PALE_ROSOLANE_PURPLE float3(0.914, 0.627, 0.788)
#endif
#ifndef PALE_ROSOLANE_PURPLE
#define PALE_ROSOLANE_PURPLE RIDGWAY_PALE_ROSOLANE_PURPLE
#endif

#ifndef RIDGWAY_PALE_RUSSIAN_BLUE
#define RIDGWAY_PALE_RUSSIAN_BLUE float3(0.710, 0.776, 0.792)
#endif
#ifndef PALE_RUSSIAN_BLUE
#define PALE_RUSSIAN_BLUE RIDGWAY_PALE_RUSSIAN_BLUE
#endif

#ifndef RIDGWAY_PALE_SALMON_COLOR
#define RIDGWAY_PALE_SALMON_COLOR float3(0.973, 0.839, 0.757)
#endif
#ifndef PALE_SALMON_COLOR
#define PALE_SALMON_COLOR RIDGWAY_PALE_SALMON_COLOR
#endif

#ifndef RIDGWAY_PALE_SMOKE_GRAY
#define RIDGWAY_PALE_SMOKE_GRAY float3(0.749, 0.725, 0.675)
#endif
#ifndef PALE_SMOKE_GRAY
#define PALE_SMOKE_GRAY RIDGWAY_PALE_SMOKE_GRAY
#endif

#ifndef RIDGWAY_PALE_SOFT_BLUE_VIOLET
#define RIDGWAY_PALE_SOFT_BLUE_VIOLET float3(0.671, 0.686, 0.918)
#endif
#ifndef PALE_SOFT_BLUE_VIOLET
#define PALE_SOFT_BLUE_VIOLET RIDGWAY_PALE_SOFT_BLUE_VIOLET
#endif

#ifndef RIDGWAY_PALE_SULPHATE_GREEN
#define RIDGWAY_PALE_SULPHATE_GREEN float3(0.616, 0.839, 0.765)
#endif
#ifndef PALE_SULPHATE_GREEN
#define PALE_SULPHATE_GREEN RIDGWAY_PALE_SULPHATE_GREEN
#endif

#ifndef RIDGWAY_PALE_TIBER_GREEN
#define RIDGWAY_PALE_TIBER_GREEN float3(0.855, 0.898, 0.706)
#endif
#ifndef PALE_TIBER_GREEN
#define PALE_TIBER_GREEN RIDGWAY_PALE_TIBER_GREEN
#endif

#ifndef RIDGWAY_PALE_TURQUOISE_GREEN
#define RIDGWAY_PALE_TURQUOISE_GREEN float3(0.757, 0.871, 0.820)
#endif
#ifndef PALE_TURQUOISE_GREEN
#define PALE_TURQUOISE_GREEN RIDGWAY_PALE_TURQUOISE_GREEN
#endif

#ifndef RIDGWAY_PALE_TURTLE_GREEN
#define RIDGWAY_PALE_TURTLE_GREEN float3(0.851, 0.839, 0.682)
#endif
#ifndef PALE_TURTLE_GREEN
#define PALE_TURTLE_GREEN RIDGWAY_PALE_TURTLE_GREEN
#endif

#ifndef RIDGWAY_PALE_VARLEYS_GRAY
#define RIDGWAY_PALE_VARLEYS_GRAY float3(0.596, 0.600, 0.624)
#endif
#ifndef PALE_VARLEYS_GRAY
#define PALE_VARLEYS_GRAY RIDGWAY_PALE_VARLEYS_GRAY
#endif

#ifndef RIDGWAY_PALE_VERBENA_VIOLET
#define RIDGWAY_PALE_VERBENA_VIOLET float3(0.808, 0.788, 0.847)
#endif
#ifndef PALE_VERBENA_VIOLET
#define PALE_VERBENA_VIOLET RIDGWAY_PALE_VERBENA_VIOLET
#endif

#ifndef RIDGWAY_PALE_VERONESE_GREEN
#define RIDGWAY_PALE_VERONESE_GREEN float3(0.875, 0.906, 0.725)
#endif
#ifndef PALE_VERONESE_GREEN
#define PALE_VERONESE_GREEN RIDGWAY_PALE_VERONESE_GREEN
#endif

#ifndef RIDGWAY_PALE_VINACEOUS
#define RIDGWAY_PALE_VINACEOUS float3(0.843, 0.722, 0.729)
#endif
#ifndef PALE_VINACEOUS
#define PALE_VINACEOUS RIDGWAY_PALE_VINACEOUS
#endif

#ifndef RIDGWAY_PALE_VINACEOUS_DRAB
#define RIDGWAY_PALE_VINACEOUS_DRAB float3(0.729, 0.659, 0.627)
#endif
#ifndef PALE_VINACEOUS_DRAB
#define PALE_VINACEOUS_DRAB RIDGWAY_PALE_VINACEOUS_DRAB
#endif

#ifndef RIDGWAY_PALE_VINACEOUS_FAWN
#define RIDGWAY_PALE_VINACEOUS_FAWN float3(0.820, 0.761, 0.702)
#endif
#ifndef PALE_VINACEOUS_FAWN
#define PALE_VINACEOUS_FAWN RIDGWAY_PALE_VINACEOUS_FAWN
#endif

#ifndef RIDGWAY_PALE_VINACEOUS_LILAC
#define RIDGWAY_PALE_VINACEOUS_LILAC float3(0.859, 0.773, 0.784)
#endif
#ifndef PALE_VINACEOUS_LILAC
#define PALE_VINACEOUS_LILAC RIDGWAY_PALE_VINACEOUS_LILAC
#endif

#ifndef RIDGWAY_PALE_VINACEOUS_PINK
#define RIDGWAY_PALE_VINACEOUS_PINK float3(0.945, 0.812, 0.761)
#endif
#ifndef PALE_VINACEOUS_PINK
#define PALE_VINACEOUS_PINK RIDGWAY_PALE_VINACEOUS_PINK
#endif

#ifndef RIDGWAY_PALE_VIOLET
#define RIDGWAY_PALE_VIOLET float3(0.702, 0.686, 0.906)
#endif
#ifndef PALE_VIOLET
#define PALE_VIOLET RIDGWAY_PALE_VIOLET
#endif

#ifndef RIDGWAY_PALE_VIOLET_BLUE
#define RIDGWAY_PALE_VIOLET_BLUE float3(0.639, 0.710, 0.925)
#endif
#ifndef PALE_VIOLET_BLUE
#define PALE_VIOLET_BLUE RIDGWAY_PALE_VIOLET_BLUE
#endif

#ifndef RIDGWAY_PALE_VIOLET_GRAY
#define RIDGWAY_PALE_VIOLET_GRAY float3(0.647, 0.643, 0.643)
#endif
#ifndef PALE_VIOLET_GRAY
#define PALE_VIOLET_GRAY RIDGWAY_PALE_VIOLET_GRAY
#endif

#ifndef RIDGWAY_PALE_VIOLET_PLUMBEOUS
#define RIDGWAY_PALE_VIOLET_PLUMBEOUS float3(0.702, 0.710, 0.725)
#endif
#ifndef PALE_VIOLET_PLUMBEOUS
#define PALE_VIOLET_PLUMBEOUS RIDGWAY_PALE_VIOLET_PLUMBEOUS
#endif

#ifndef RIDGWAY_PALE_VIRIDINE_YELLOW
#define RIDGWAY_PALE_VIRIDINE_YELLOW float3(0.957, 0.941, 0.675)
#endif
#ifndef PALE_VIRIDINE_YELLOW
#define PALE_VIRIDINE_YELLOW RIDGWAY_PALE_VIRIDINE_YELLOW
#endif

#ifndef RIDGWAY_PALE_WINDSOR_BLUE
#define RIDGWAY_PALE_WINDSOR_BLUE float3(0.624, 0.678, 0.769)
#endif
#ifndef PALE_WINDSOR_BLUE
#define PALE_WINDSOR_BLUE RIDGWAY_PALE_WINDSOR_BLUE
#endif

#ifndef RIDGWAY_PALE_WISTARIA_BLUE
#define RIDGWAY_PALE_WISTARIA_BLUE float3(0.757, 0.749, 0.933)
#endif
#ifndef PALE_WISTARIA_BLUE
#define PALE_WISTARIA_BLUE RIDGWAY_PALE_WISTARIA_BLUE
#endif

#ifndef RIDGWAY_PALE_WISTARIA_VIOLET
#define RIDGWAY_PALE_WISTARIA_VIOLET float3(0.792, 0.769, 0.945)
#endif
#ifndef PALE_WISTARIA_VIOLET
#define PALE_WISTARIA_VIOLET RIDGWAY_PALE_WISTARIA_VIOLET
#endif

#ifndef RIDGWAY_PALE_YELLOW_GREEN
#define RIDGWAY_PALE_YELLOW_GREEN float3(0.855, 0.906, 0.678)
#endif
#ifndef PALE_YELLOW_GREEN
#define PALE_YELLOW_GREEN RIDGWAY_PALE_YELLOW_GREEN
#endif

#ifndef RIDGWAY_PALE_YELLOW_ORANGE
#define RIDGWAY_PALE_YELLOW_ORANGE float3(0.996, 0.827, 0.612)
#endif
#ifndef PALE_YELLOW_ORANGE
#define PALE_YELLOW_ORANGE RIDGWAY_PALE_YELLOW_ORANGE
#endif

#ifndef RIDGWAY_PALLID_BLUE_VIOLET
#define RIDGWAY_PALLID_BLUE_VIOLET float3(0.808, 0.824, 0.957)
#endif
#ifndef PALLID_BLUE_VIOLET
#define PALLID_BLUE_VIOLET RIDGWAY_PALLID_BLUE_VIOLET
#endif

#ifndef RIDGWAY_PALLID_BLUISH_VIOLET
#define RIDGWAY_PALLID_BLUISH_VIOLET float3(0.804, 0.808, 0.961)
#endif
#ifndef PALLID_BLUISH_VIOLET
#define PALLID_BLUISH_VIOLET RIDGWAY_PALLID_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_PALLID_BROWNISH_DRAB
#define RIDGWAY_PALLID_BROWNISH_DRAB float3(0.800, 0.761, 0.718)
#endif
#ifndef PALLID_BROWNISH_DRAB
#define PALLID_BROWNISH_DRAB RIDGWAY_PALLID_BROWNISH_DRAB
#endif

#ifndef RIDGWAY_PALLID_GRAYISH_VIOLET_BLUE
#define RIDGWAY_PALLID_GRAYISH_VIOLET_BLUE float3(0.714, 0.741, 0.835)
#endif
#ifndef PALLID_GRAYISH_VIOLET_BLUE
#define PALLID_GRAYISH_VIOLET_BLUE RIDGWAY_PALLID_GRAYISH_VIOLET_BLUE
#endif

#ifndef RIDGWAY_PALLID_METHYL_BLUE
#define RIDGWAY_PALLID_METHYL_BLUE float3(0.749, 0.878, 0.953)
#endif
#ifndef PALLID_METHYL_BLUE
#define PALLID_METHYL_BLUE RIDGWAY_PALLID_METHYL_BLUE
#endif

#ifndef RIDGWAY_PALLID_MOUSE_GRAY
#define RIDGWAY_PALLID_MOUSE_GRAY float3(0.725, 0.706, 0.655)
#endif
#ifndef PALLID_MOUSE_GRAY
#define PALLID_MOUSE_GRAY RIDGWAY_PALLID_MOUSE_GRAY
#endif

#ifndef RIDGWAY_PALLID_NEUTRAL_GRAY
#define RIDGWAY_PALLID_NEUTRAL_GRAY float3(0.733, 0.722, 0.682)
#endif
#ifndef PALLID_NEUTRAL_GRAY
#define PALLID_NEUTRAL_GRAY RIDGWAY_PALLID_NEUTRAL_GRAY
#endif

#ifndef RIDGWAY_PALLID_PURPLE_DRAB
#define RIDGWAY_PALLID_PURPLE_DRAB float3(0.773, 0.741, 0.722)
#endif
#ifndef PALLID_PURPLE_DRAB
#define PALLID_PURPLE_DRAB RIDGWAY_PALLID_PURPLE_DRAB
#endif

#ifndef RIDGWAY_PALLID_PURPLISH_GRAY
#define RIDGWAY_PALLID_PURPLISH_GRAY float3(0.733, 0.714, 0.678)
#endif
#ifndef PALLID_PURPLISH_GRAY
#define PALLID_PURPLISH_GRAY RIDGWAY_PALLID_PURPLISH_GRAY
#endif

#ifndef RIDGWAY_PALLID_QUAKER_DRAB
#define RIDGWAY_PALLID_QUAKER_DRAB float3(0.686, 0.659, 0.616)
#endif
#ifndef PALLID_QUAKER_DRAB
#define PALLID_QUAKER_DRAB RIDGWAY_PALLID_QUAKER_DRAB
#endif

#ifndef RIDGWAY_PALLID_SOFT_BLUE_VIOLET
#define RIDGWAY_PALLID_SOFT_BLUE_VIOLET float3(0.765, 0.780, 0.953)
#endif
#ifndef PALLID_SOFT_BLUE_VIOLET
#define PALLID_SOFT_BLUE_VIOLET RIDGWAY_PALLID_SOFT_BLUE_VIOLET
#endif

#ifndef RIDGWAY_PALLID_VINACEOUS_DRAB
#define RIDGWAY_PALLID_VINACEOUS_DRAB float3(0.804, 0.761, 0.729)
#endif
#ifndef PALLID_VINACEOUS_DRAB
#define PALLID_VINACEOUS_DRAB RIDGWAY_PALLID_VINACEOUS_DRAB
#endif

#ifndef RIDGWAY_PALLID_VIOLET
#define RIDGWAY_PALLID_VIOLET float3(0.808, 0.792, 0.945)
#endif
#ifndef PALLID_VIOLET
#define PALLID_VIOLET RIDGWAY_PALLID_VIOLET
#endif

#ifndef RIDGWAY_PALLID_VIOLET_BLUE
#define RIDGWAY_PALLID_VIOLET_BLUE float3(0.757, 0.808, 0.937)
#endif
#ifndef PALLID_VIOLET_BLUE
#define PALLID_VIOLET_BLUE RIDGWAY_PALLID_VIOLET_BLUE
#endif

#ifndef RIDGWAY_PANSY_PURPLE
#define RIDGWAY_PANSY_PURPLE float3(0.518, 0.216, 0.318)
#endif
#ifndef PANSY_PURPLE
#define PANSY_PURPLE RIDGWAY_PANSY_PURPLE
#endif

#ifndef RIDGWAY_PANSY_VIOLET
#define RIDGWAY_PANSY_VIOLET float3(0.518, 0.239, 0.459)
#endif
#ifndef PANSY_VIOLET
#define PANSY_VIOLET RIDGWAY_PANSY_VIOLET
#endif

#ifndef RIDGWAY_PARIS_BLUE
#define RIDGWAY_PARIS_BLUE float3(0.157, 0.373, 0.576)
#endif
#ifndef PARIS_BLUE
#define PARIS_BLUE RIDGWAY_PARIS_BLUE
#endif

#ifndef RIDGWAY_PARIS_GREEN
#define RIDGWAY_PARIS_GREEN float3(0.518, 0.698, 0.537)
#endif
#ifndef PARIS_GREEN
#define PARIS_GREEN RIDGWAY_PARIS_GREEN
#endif

#ifndef RIDGWAY_PARROT_GREEN
#define RIDGWAY_PARROT_GREEN float3(0.533, 0.549, 0.302)
#endif
#ifndef PARROT_GREEN
#define PARROT_GREEN RIDGWAY_PARROT_GREEN
#endif

#ifndef RIDGWAY_PARULA_BLUE
#define RIDGWAY_PARULA_BLUE float3(0.431, 0.565, 0.631)
#endif
#ifndef PARULA_BLUE
#define PARULA_BLUE RIDGWAY_PARULA_BLUE
#endif

#ifndef RIDGWAY_PATENT_BLUE
#define RIDGWAY_PATENT_BLUE float3(0.078, 0.353, 0.447)
#endif
#ifndef PATENT_BLUE
#define PATENT_BLUE RIDGWAY_PATENT_BLUE
#endif

#ifndef RIDGWAY_PAYNES_GRAY
#define RIDGWAY_PAYNES_GRAY float3(0.439, 0.490, 0.533)
#endif
#ifndef PAYNES_GRAY
#define PAYNES_GRAY RIDGWAY_PAYNES_GRAY
#endif

#ifndef RIDGWAY_PEA_GREEN
#define RIDGWAY_PEA_GREEN float3(0.573, 0.635, 0.529)
#endif
#ifndef PEA_GREEN
#define PEA_GREEN RIDGWAY_PEA_GREEN
#endif

#ifndef RIDGWAY_PEACH_RED
#define RIDGWAY_PEACH_RED float3(0.976, 0.447, 0.361)
#endif
#ifndef PEACH_RED
#define PEACH_RED RIDGWAY_PEACH_RED
#endif

#ifndef RIDGWAY_PEACOCK_BLUE
#define RIDGWAY_PEACOCK_BLUE float3(0.008, 0.412, 0.596)
#endif
#ifndef PEACOCK_BLUE
#define PEACOCK_BLUE RIDGWAY_PEACOCK_BLUE
#endif

#ifndef RIDGWAY_PEACOCK_GREEN
#define RIDGWAY_PEACOCK_GREEN float3(0.329, 0.545, 0.404)
#endif
#ifndef PEACOCK_GREEN
#define PEACOCK_GREEN RIDGWAY_PEACOCK_GREEN
#endif

#ifndef RIDGWAY_PEARL_BLUE
#define RIDGWAY_PEARL_BLUE float3(0.749, 0.757, 0.804)
#endif
#ifndef PEARL_BLUE
#define PEARL_BLUE RIDGWAY_PEARL_BLUE
#endif

#ifndef RIDGWAY_PEARL_GRAY
#define RIDGWAY_PEARL_GRAY float3(0.694, 0.690, 0.639)
#endif
#ifndef PEARL_GRAY
#define PEARL_GRAY RIDGWAY_PEARL_GRAY
#endif

#ifndef RIDGWAY_PECAN_BROWN
#define RIDGWAY_PECAN_BROWN float3(0.682, 0.447, 0.341)
#endif
#ifndef PECAN_BROWN
#define PECAN_BROWN RIDGWAY_PECAN_BROWN
#endif

#ifndef RIDGWAY_PERILLA_PURPLE
#define RIDGWAY_PERILLA_PURPLE float3(0.475, 0.302, 0.345)
#endif
#ifndef PERILLA_PURPLE
#define PERILLA_PURPLE RIDGWAY_PERILLA_PURPLE
#endif

#ifndef RIDGWAY_PERSIAN_BLUE
#define RIDGWAY_PERSIAN_BLUE float3(0.745, 0.847, 0.925)
#endif
#ifndef PERSIAN_BLUE
#define PERSIAN_BLUE RIDGWAY_PERSIAN_BLUE
#endif

#ifndef RIDGWAY_PERSIAN_LILAC
#define RIDGWAY_PERSIAN_LILAC float3(0.851, 0.604, 0.663)
#endif
#ifndef PERSIAN_LILAC
#define PERSIAN_LILAC RIDGWAY_PERSIAN_LILAC
#endif

#ifndef RIDGWAY_PETUNIA_VIOLET
#define RIDGWAY_PETUNIA_VIOLET float3(0.553, 0.380, 0.588)
#endif
#ifndef PETUNIA_VIOLET
#define PETUNIA_VIOLET RIDGWAY_PETUNIA_VIOLET
#endif

#ifndef RIDGWAY_PHENYL_BLUE
#define RIDGWAY_PHENYL_BLUE float3(0.243, 0.361, 0.804)
#endif
#ifndef PHENYL_BLUE
#define PHENYL_BLUE RIDGWAY_PHENYL_BLUE
#endif

#ifndef RIDGWAY_PHLOX_PINK
#define RIDGWAY_PHLOX_PINK float3(0.941, 0.745, 0.918)
#endif
#ifndef PHLOX_PINK
#define PHLOX_PINK RIDGWAY_PHLOX_PINK
#endif

#ifndef RIDGWAY_PHLOX_PURPLE
#define RIDGWAY_PHLOX_PURPLE float3(0.788, 0.380, 0.710)
#endif
#ifndef PHLOX_PURPLE
#define PHLOX_PURPLE RIDGWAY_PHLOX_PURPLE
#endif

#ifndef RIDGWAY_PICNIC_YELLOW
#define RIDGWAY_PICNIC_YELLOW float3(0.996, 0.906, 0.412)
#endif
#ifndef PICNIC_YELLOW
#define PICNIC_YELLOW RIDGWAY_PICNIC_YELLOW
#endif

#ifndef RIDGWAY_PINARD_YELLOW
#define RIDGWAY_PINARD_YELLOW float3(0.996, 0.914, 0.498)
#endif
#ifndef PINARD_YELLOW
#define PINARD_YELLOW RIDGWAY_PINARD_YELLOW
#endif

#ifndef RIDGWAY_PINKISH_BUFF
#define RIDGWAY_PINKISH_BUFF float3(0.910, 0.753, 0.596)
#endif
#ifndef PINKISH_BUFF
#define PINKISH_BUFF RIDGWAY_PINKISH_BUFF
#endif

#ifndef RIDGWAY_PINKISH_CINNAMON
#define RIDGWAY_PINKISH_CINNAMON float3(0.878, 0.627, 0.455)
#endif
#ifndef PINKISH_CINNAMON
#define PINKISH_CINNAMON RIDGWAY_PINKISH_CINNAMON
#endif

#ifndef RIDGWAY_PINKISH_VINACEOUS
#define RIDGWAY_PINKISH_VINACEOUS float3(0.804, 0.631, 0.620)
#endif
#ifndef PINKISH_VINACEOUS
#define PINKISH_VINACEOUS RIDGWAY_PINKISH_VINACEOUS
#endif

#ifndef RIDGWAY_PISTACHIO_GREEN
#define RIDGWAY_PISTACHIO_GREEN float3(0.478, 0.608, 0.486)
#endif
#ifndef PISTACHIO_GREEN
#define PISTACHIO_GREEN RIDGWAY_PISTACHIO_GREEN
#endif

#ifndef RIDGWAY_PLEROMA_VIOLET
#define RIDGWAY_PLEROMA_VIOLET float3(0.529, 0.349, 0.635)
#endif
#ifndef PLEROMA_VIOLET
#define PLEROMA_VIOLET RIDGWAY_PLEROMA_VIOLET
#endif

#ifndef RIDGWAY_PLUM_PURPLE
#define RIDGWAY_PLUM_PURPLE float3(0.208, 0.220, 0.306)
#endif
#ifndef PLUM_PURPLE
#define PLUM_PURPLE RIDGWAY_PLUM_PURPLE
#endif

#ifndef RIDGWAY_PLUMBAGO_BLUE
#define RIDGWAY_PLUMBAGO_BLUE float3(0.733, 0.733, 0.776)
#endif
#ifndef PLUMBAGO_BLUE
#define PLUMBAGO_BLUE RIDGWAY_PLUMBAGO_BLUE
#endif

#ifndef RIDGWAY_PLUMBAGO_GRAY
#define RIDGWAY_PLUMBAGO_GRAY float3(0.596, 0.584, 0.616)
#endif
#ifndef PLUMBAGO_GRAY
#define PLUMBAGO_GRAY RIDGWAY_PLUMBAGO_GRAY
#endif

#ifndef RIDGWAY_PLUMBAGO_SLATE
#define RIDGWAY_PLUMBAGO_SLATE float3(0.388, 0.396, 0.427)
#endif
#ifndef PLUMBAGO_SLATE
#define PLUMBAGO_SLATE RIDGWAY_PLUMBAGO_SLATE
#endif

#ifndef RIDGWAY_PLUMBEOUS
#define RIDGWAY_PLUMBEOUS float3(0.545, 0.573, 0.596)
#endif
#ifndef PLUMBEOUS
#define PLUMBEOUS RIDGWAY_PLUMBEOUS
#endif

#ifndef RIDGWAY_PLUMBEOUS_BLACK
#define RIDGWAY_PLUMBEOUS_BLACK float3(0.224, 0.275, 0.278)
#endif
#ifndef PLUMBEOUS_BLACK
#define PLUMBEOUS_BLACK RIDGWAY_PLUMBEOUS_BLACK
#endif

#ifndef RIDGWAY_POIS_GREEN
#define RIDGWAY_POIS_GREEN float3(0.510, 0.545, 0.408)
#endif
#ifndef POIS_GREEN
#define POIS_GREEN RIDGWAY_POIS_GREEN
#endif

#ifndef RIDGWAY_POMEGRANATE_PURPLE
#define RIDGWAY_POMEGRANATE_PURPLE float3(0.722, 0.196, 0.314)
#endif
#ifndef POMEGRANATE_PURPLE
#define POMEGRANATE_PURPLE RIDGWAY_POMEGRANATE_PURPLE
#endif

#ifndef RIDGWAY_POMPEIAN_RED
#define RIDGWAY_POMPEIAN_RED float3(0.675, 0.322, 0.298)
#endif
#ifndef POMPEIAN_RED
#define POMPEIAN_RED RIDGWAY_POMPEIAN_RED
#endif

#ifndef RIDGWAY_PORCELAIN_BLUE
#define RIDGWAY_PORCELAIN_BLUE float3(0.416, 0.580, 0.612)
#endif
#ifndef PORCELAIN_BLUE
#define PORCELAIN_BLUE RIDGWAY_PORCELAIN_BLUE
#endif

#ifndef RIDGWAY_PORCELAIN_GREEN
#define RIDGWAY_PORCELAIN_GREEN float3(0.310, 0.522, 0.510)
#endif
#ifndef PORCELAIN_GREEN
#define PORCELAIN_GREEN RIDGWAY_PORCELAIN_GREEN
#endif

#ifndef RIDGWAY_PRIMROSE_YELLOW
#define RIDGWAY_PRIMROSE_YELLOW float3(0.925, 0.835, 0.588)
#endif
#ifndef PRIMROSE_YELLOW
#define PRIMROSE_YELLOW RIDGWAY_PRIMROSE_YELLOW
#endif

#ifndef RIDGWAY_PRIMULINE_YELLOW
#define RIDGWAY_PRIMULINE_YELLOW float3(0.937, 0.722, 0.243)
#endif
#ifndef PRIMULINE_YELLOW
#define PRIMULINE_YELLOW RIDGWAY_PRIMULINE_YELLOW
#endif

#ifndef RIDGWAY_PROUTS_BROWN
#define RIDGWAY_PROUTS_BROWN float3(0.471, 0.349, 0.243)
#endif
#ifndef PROUTS_BROWN
#define PROUTS_BROWN RIDGWAY_PROUTS_BROWN
#endif

#ifndef RIDGWAY_PRUNE_PURPLE
#define RIDGWAY_PRUNE_PURPLE float3(0.329, 0.208, 0.337)
#endif
#ifndef PRUNE_PURPLE
#define PRUNE_PURPLE RIDGWAY_PRUNE_PURPLE
#endif

#ifndef RIDGWAY_PRUSSIAN_BLUE
#define RIDGWAY_PRUSSIAN_BLUE float3(0.200, 0.314, 0.518)
#endif
#ifndef PRUSSIAN_BLUE
#define PRUSSIAN_BLUE RIDGWAY_PRUSSIAN_BLUE
#endif

#ifndef RIDGWAY_PRUSSIAN_GREEN
#define RIDGWAY_PRUSSIAN_GREEN float3(0.176, 0.478, 0.447)
#endif
#ifndef PRUSSIAN_GREEN
#define PRUSSIAN_GREEN RIDGWAY_PRUSSIAN_GREEN
#endif

#ifndef RIDGWAY_PRUSSIAN_RED
#define RIDGWAY_PRUSSIAN_RED float3(0.537, 0.357, 0.318)
#endif
#ifndef PRUSSIAN_RED
#define PRUSSIAN_RED RIDGWAY_PRUSSIAN_RED
#endif

#ifndef RIDGWAY_PURITAN_GRAY
#define RIDGWAY_PURITAN_GRAY float3(0.671, 0.714, 0.686)
#endif
#ifndef PURITAN_GRAY
#define PURITAN_GRAY RIDGWAY_PURITAN_GRAY
#endif

#ifndef RIDGWAY_PURPLE_TRUE
#define RIDGWAY_PURPLE_TRUE float3(0.745, 0.153, 0.627)
#endif
#ifndef PURPLE_TRUE
#define PURPLE_TRUE RIDGWAY_PURPLE_TRUE
#endif

#ifndef RIDGWAY_PURPLE_DRAB
#define RIDGWAY_PURPLE_DRAB float3(0.573, 0.478, 0.475)
#endif
#ifndef PURPLE_DRAB
#define PURPLE_DRAB RIDGWAY_PURPLE_DRAB
#endif

#ifndef RIDGWAY_PURPLISH_GRAY
#define RIDGWAY_PURPLISH_GRAY float3(0.475, 0.463, 0.455)
#endif
#ifndef PURPLISH_GRAY
#define PURPLISH_GRAY RIDGWAY_PURPLISH_GRAY
#endif

#ifndef RIDGWAY_PURPLISH_LILAC
#define RIDGWAY_PURPLISH_LILAC float3(0.765, 0.631, 0.702)
#endif
#ifndef PURPLISH_LILAC
#define PURPLISH_LILAC RIDGWAY_PURPLISH_LILAC
#endif

#ifndef RIDGWAY_PURPLISH_VINACEOUS
#define RIDGWAY_PURPLISH_VINACEOUS float3(0.745, 0.553, 0.557)
#endif
#ifndef PURPLISH_VINACEOUS
#define PURPLISH_VINACEOUS RIDGWAY_PURPLISH_VINACEOUS
#endif

#ifndef RIDGWAY_PYRITE_YELLOW
#define RIDGWAY_PYRITE_YELLOW float3(0.741, 0.639, 0.247)
#endif
#ifndef PYRITE_YELLOW
#define PYRITE_YELLOW RIDGWAY_PYRITE_YELLOW
#endif

#ifndef RIDGWAY_QUAKER_DRAB
#define RIDGWAY_QUAKER_DRAB float3(0.522, 0.502, 0.471)
#endif
#ifndef QUAKER_DRAB
#define QUAKER_DRAB RIDGWAY_QUAKER_DRAB
#endif

#ifndef RIDGWAY_RAINETTE_GREEN
#define RIDGWAY_RAINETTE_GREEN float3(0.612, 0.600, 0.373)
#endif
#ifndef RAINETTE_GREEN
#define RAINETTE_GREEN RIDGWAY_RAINETTE_GREEN
#endif

#ifndef RIDGWAY_RAISIN_BLACK
#define RIDGWAY_RAISIN_BLACK float3(0.282, 0.267, 0.278)
#endif
#ifndef RAISIN_BLACK
#define RAISIN_BLACK RIDGWAY_RAISIN_BLACK
#endif

#ifndef RIDGWAY_RAISIN_PURPLE
#define RIDGWAY_RAISIN_PURPLE float3(0.494, 0.255, 0.396)
#endif
#ifndef RAISIN_PURPLE
#define RAISIN_PURPLE RIDGWAY_RAISIN_PURPLE
#endif

#ifndef RIDGWAY_RAMIER_BLUE
#define RIDGWAY_RAMIER_BLUE float3(0.478, 0.486, 0.557)
#endif
#ifndef RAMIER_BLUE
#define RAMIER_BLUE RIDGWAY_RAMIER_BLUE
#endif

#ifndef RIDGWAY_RAW_SIENNA
#define RIDGWAY_RAW_SIENNA float3(0.765, 0.510, 0.075)
#endif
#ifndef RAW_SIENNA
#define RAW_SIENNA RIDGWAY_RAW_SIENNA
#endif

#ifndef RIDGWAY_RAW_UMBER
#define RIDGWAY_RAW_UMBER float3(0.412, 0.325, 0.196)
#endif
#ifndef RAW_UMBER
#define RAW_UMBER RIDGWAY_RAW_UMBER
#endif

#ifndef RIDGWAY_REED_YELLOW
#define RIDGWAY_REED_YELLOW float3(0.871, 0.776, 0.498)
#endif
#ifndef REED_YELLOW
#define REED_YELLOW RIDGWAY_REED_YELLOW
#endif

#ifndef RIDGWAY_REJANE_GREEN
#define RIDGWAY_REJANE_GREEN float3(0.627, 0.722, 0.576)
#endif
#ifndef REJANE_GREEN
#define REJANE_GREEN RIDGWAY_REJANE_GREEN
#endif

#ifndef RIDGWAY_RHODAMINE_PURPLE
#define RIDGWAY_RHODAMINE_PURPLE float3(0.816, 0.137, 0.584)
#endif
#ifndef RHODAMINE_PURPLE
#define RHODAMINE_PURPLE RIDGWAY_RHODAMINE_PURPLE
#endif

#ifndef RIDGWAY_RHODONITE_PINK
#define RIDGWAY_RHODONITE_PINK float3(0.875, 0.624, 0.659)
#endif
#ifndef RHODONITE_PINK
#define RHODONITE_PINK RIDGWAY_RHODONITE_PINK
#endif

#ifndef RIDGWAY_RINNEMANNS_GREEN
#define RIDGWAY_RINNEMANNS_GREEN float3(0.467, 0.565, 0.392)
#endif
#ifndef RINNEMANNS_GREEN
#define RINNEMANNS_GREEN RIDGWAY_RINNEMANNS_GREEN
#endif

#ifndef RIDGWAY_RIVAGE_GREEN
#define RIDGWAY_RIVAGE_GREEN float3(0.698, 0.800, 0.506)
#endif
#ifndef RIVAGE_GREEN
#define RIVAGE_GREEN RIDGWAY_RIVAGE_GREEN
#endif

#ifndef RIDGWAY_ROCELLIN_PURPLE
#define RIDGWAY_ROCELLIN_PURPLE float3(0.824, 0.514, 0.561)
#endif
#ifndef ROCELLIN_PURPLE
#define ROCELLIN_PURPLE RIDGWAY_ROCELLIN_PURPLE
#endif

#ifndef RIDGWAY_ROMAN_GREEN
#define RIDGWAY_ROMAN_GREEN float3(0.435, 0.439, 0.267)
#endif
#ifndef ROMAN_GREEN
#define ROMAN_GREEN RIDGWAY_ROMAN_GREEN
#endif

#ifndef RIDGWAY_ROODS_BLUE
#define RIDGWAY_ROODS_BLUE float3(0.169, 0.341, 0.659)
#endif
#ifndef ROODS_BLUE
#define ROODS_BLUE RIDGWAY_ROODS_BLUE
#endif

#ifndef RIDGWAY_ROODS_BROWN
#define RIDGWAY_ROODS_BROWN float3(0.561, 0.408, 0.322)
#endif
#ifndef ROODS_BROWN
#define ROODS_BROWN RIDGWAY_ROODS_BROWN
#endif

#ifndef RIDGWAY_ROODS_LAVENDER
#define RIDGWAY_ROODS_LAVENDER float3(0.659, 0.659, 0.675)
#endif
#ifndef ROODS_LAVENDER
#define ROODS_LAVENDER RIDGWAY_ROODS_LAVENDER
#endif

#ifndef RIDGWAY_ROODS_VIOLET
#define RIDGWAY_ROODS_VIOLET float3(0.537, 0.251, 0.404)
#endif
#ifndef ROODS_VIOLET
#define ROODS_VIOLET RIDGWAY_ROODS_VIOLET
#endif

#ifndef RIDGWAY_ROSE_COLOR
#define RIDGWAY_ROSE_COLOR float3(0.918, 0.349, 0.561)
#endif
#ifndef ROSE_COLOR
#define ROSE_COLOR RIDGWAY_ROSE_COLOR
#endif

#ifndef RIDGWAY_ROSE_DOREE
#define RIDGWAY_ROSE_DOREE float3(0.914, 0.412, 0.420)
#endif
#ifndef ROSE_DOREE
#define ROSE_DOREE RIDGWAY_ROSE_DOREE
#endif

#ifndef RIDGWAY_ROSE_PINK
#define RIDGWAY_ROSE_PINK float3(0.996, 0.761, 0.894)
#endif
#ifndef ROSE_PINK
#define ROSE_PINK RIDGWAY_ROSE_PINK
#endif

#ifndef RIDGWAY_ROSE_RED
#define RIDGWAY_ROSE_RED float3(0.820, 0.161, 0.306)
#endif
#ifndef ROSE_RED
#define ROSE_RED RIDGWAY_ROSE_RED
#endif

#ifndef RIDGWAY_ROSE_PURPLE
#define RIDGWAY_ROSE_PURPLE float3(0.878, 0.616, 0.875)
#endif
#ifndef ROSE_PURPLE
#define ROSE_PURPLE RIDGWAY_ROSE_PURPLE
#endif

#ifndef RIDGWAY_ROSLYN_BLUE
#define RIDGWAY_ROSLYN_BLUE float3(0.314, 0.271, 0.494)
#endif
#ifndef ROSLYN_BLUE
#define ROSLYN_BLUE RIDGWAY_ROSLYN_BLUE
#endif

#ifndef RIDGWAY_ROSOLANE_PINK
#define RIDGWAY_ROSOLANE_PINK float3(0.945, 0.769, 0.847)
#endif
#ifndef ROSOLANE_PINK
#define ROSOLANE_PINK RIDGWAY_ROSOLANE_PINK
#endif

#ifndef RIDGWAY_ROSOLANE_PURPLE
#define RIDGWAY_ROSOLANE_PURPLE float3(0.749, 0.314, 0.494)
#endif
#ifndef ROSOLANE_PURPLE
#define ROSOLANE_PURPLE RIDGWAY_ROSOLANE_PURPLE
#endif

#ifndef RIDGWAY_ROYAL_PURPLE
#define RIDGWAY_ROYAL_PURPLE float3(0.412, 0.318, 0.604)
#endif
#ifndef ROYAL_PURPLE
#define ROYAL_PURPLE RIDGWAY_ROYAL_PURPLE
#endif

#ifndef RIDGWAY_RUFOUS
#define RIDGWAY_RUFOUS float3(0.914, 0.486, 0.333)
#endif
#ifndef RUFOUS
#define RUFOUS RIDGWAY_RUFOUS
#endif

#ifndef RIDGWAY_RUSSET
#define RIDGWAY_RUSSET float3(0.588, 0.392, 0.263)
#endif
#ifndef RUSSET
#define RUSSET RIDGWAY_RUSSET
#endif

#ifndef RIDGWAY_RUSSET_VINACEOUS
#define RIDGWAY_RUSSET_VINACEOUS float3(0.718, 0.494, 0.424)
#endif
#ifndef RUSSET_VINACEOUS
#define RUSSET_VINACEOUS RIDGWAY_RUSSET_VINACEOUS
#endif

#ifndef RIDGWAY_RUSSIAN_BLUE
#define RIDGWAY_RUSSIAN_BLUE float3(0.592, 0.690, 0.725)
#endif
#ifndef RUSSIAN_BLUE
#define RUSSIAN_BLUE RIDGWAY_RUSSIAN_BLUE
#endif

#ifndef RIDGWAY_RUSSIAN_GREEN
#define RIDGWAY_RUSSIAN_GREEN float3(0.412, 0.502, 0.424)
#endif
#ifndef RUSSIAN_GREEN
#define RUSSIAN_GREEN RIDGWAY_RUSSIAN_GREEN
#endif

#ifndef RIDGWAY_SACCARDOS_OLIVE
#define RIDGWAY_SACCARDOS_OLIVE float3(0.506, 0.455, 0.298)
#endif
#ifndef SACCARDOS_OLIVE
#define SACCARDOS_OLIVE RIDGWAY_SACCARDOS_OLIVE
#endif

#ifndef RIDGWAY_SACCARDOS_SLATE
#define RIDGWAY_SACCARDOS_SLATE float3(0.239, 0.345, 0.365)
#endif
#ifndef SACCARDOS_SLATE
#define SACCARDOS_SLATE RIDGWAY_SACCARDOS_SLATE
#endif

#ifndef RIDGWAY_SACCARDOS_UMBER
#define RIDGWAY_SACCARDOS_UMBER float3(0.537, 0.435, 0.298)
#endif
#ifndef SACCARDOS_UMBER
#define SACCARDOS_UMBER RIDGWAY_SACCARDOS_UMBER
#endif

#ifndef RIDGWAY_SACCARDOS_VIOLET
#define RIDGWAY_SACCARDOS_VIOLET float3(0.549, 0.451, 0.604)
#endif
#ifndef SACCARDOS_VIOLET
#define SACCARDOS_VIOLET RIDGWAY_SACCARDOS_VIOLET
#endif

#ifndef RIDGWAY_SAFRANO_PINK
#define RIDGWAY_SAFRANO_PINK float3(0.996, 0.800, 0.745)
#endif
#ifndef SAFRANO_PINK
#define SAFRANO_PINK RIDGWAY_SAFRANO_PINK
#endif

#ifndef RIDGWAY_SAGE_GREEN
#define RIDGWAY_SAGE_GREEN float3(0.502, 0.588, 0.482)
#endif
#ifndef SAGE_GREEN
#define SAGE_GREEN RIDGWAY_SAGE_GREEN
#endif

#ifndef RIDGWAY_SAILOR_BLUE
#define RIDGWAY_SAILOR_BLUE float3(0.337, 0.373, 0.588)
#endif
#ifndef SAILOR_BLUE
#define SAILOR_BLUE RIDGWAY_SAILOR_BLUE
#endif

#ifndef RIDGWAY_SALMON_COLOR
#define RIDGWAY_SALMON_COLOR float3(0.953, 0.671, 0.537)
#endif
#ifndef SALMON_COLOR
#define SALMON_COLOR RIDGWAY_SALMON_COLOR
#endif

#ifndef RIDGWAY_SALMON_BUFF
#define RIDGWAY_SALMON_BUFF float3(0.992, 0.765, 0.612)
#endif
#ifndef SALMON_BUFF
#define SALMON_BUFF RIDGWAY_SALMON_BUFF
#endif

#ifndef RIDGWAY_SALMON_ORANGE
#define RIDGWAY_SALMON_ORANGE float3(0.996, 0.569, 0.286)
#endif
#ifndef SALMON_ORANGE
#define SALMON_ORANGE RIDGWAY_SALMON_ORANGE
#endif

#ifndef RIDGWAY_SALVIA_BLUE
#define RIDGWAY_SALVIA_BLUE float3(0.380, 0.565, 0.922)
#endif
#ifndef SALVIA_BLUE
#define SALVIA_BLUE RIDGWAY_SALVIA_BLUE
#endif

#ifndef RIDGWAY_SANFORDS_BROWN
#define RIDGWAY_SANFORDS_BROWN float3(0.631, 0.337, 0.184)
#endif
#ifndef SANFORDS_BROWN
#define SANFORDS_BROWN RIDGWAY_SANFORDS_BROWN
#endif

#ifndef RIDGWAY_SAYAL_BROWN
#define RIDGWAY_SAYAL_BROWN float3(0.675, 0.494, 0.337)
#endif
#ifndef SAYAL_BROWN
#define SAYAL_BROWN RIDGWAY_SAYAL_BROWN
#endif

#ifndef RIDGWAY_SCARLET
#define RIDGWAY_SCARLET float3(0.914, 0.271, 0.153)
#endif
#ifndef SCARLET
#define SCARLET RIDGWAY_SCARLET
#endif

#ifndef RIDGWAY_SCARLET_RED
#define RIDGWAY_SCARLET_RED float3(0.882, 0.165, 0.196)
#endif
#ifndef SCARLET_RED
#define SCARLET_RED RIDGWAY_SCARLET_RED
#endif

#ifndef RIDGWAY_SCHEELES_GREEN
#define RIDGWAY_SCHEELES_GREEN float3(0.643, 0.671, 0.349)
#endif
#ifndef SCHEELES_GREEN
#define SCHEELES_GREEN RIDGWAY_SCHEELES_GREEN
#endif

#ifndef RIDGWAY_SCHOENFELDS_PURPLE
#define RIDGWAY_SCHOENFELDS_PURPLE float3(0.616, 0.275, 0.451)
#endif
#ifndef SCHOENFELDS_PURPLE
#define SCHOENFELDS_PURPLE RIDGWAY_SCHOENFELDS_PURPLE
#endif

#ifndef RIDGWAY_SEA_GREEN
#define RIDGWAY_SEA_GREEN float3(0.220, 0.529, 0.514)
#endif
#ifndef SEA_GREEN
#define SEA_GREEN RIDGWAY_SEA_GREEN
#endif

#ifndef RIDGWAY_SEAFOAM_GREEN
#define RIDGWAY_SEAFOAM_GREEN float3(0.914, 0.878, 0.718)
#endif
#ifndef SEAFOAM_GREEN
#define SEAFOAM_GREEN RIDGWAY_SEAFOAM_GREEN
#endif

#ifndef RIDGWAY_SEAFOAM_YELLOW
#define RIDGWAY_SEAFOAM_YELLOW float3(0.918, 0.875, 0.733)
#endif
#ifndef SEAFOAM_YELLOW
#define SEAFOAM_YELLOW RIDGWAY_SEAFOAM_YELLOW
#endif

#ifndef RIDGWAY_SEAL_BROWN
#define RIDGWAY_SEAL_BROWN float3(0.341, 0.298, 0.275)
#endif
#ifndef SEAL_BROWN
#define SEAL_BROWN RIDGWAY_SEAL_BROWN
#endif

#ifndef RIDGWAY_SEASHELL_PINK
#define RIDGWAY_SEASHELL_PINK float3(0.965, 0.839, 0.737)
#endif
#ifndef SEASHELL_PINK
#define SEASHELL_PINK RIDGWAY_SEASHELL_PINK
#endif

#ifndef RIDGWAY_SEPIA
#define RIDGWAY_SEPIA float3(0.400, 0.345, 0.255)
#endif
#ifndef SEPIA
#define SEPIA RIDGWAY_SEPIA
#endif

#ifndef RIDGWAY_SERPENTINE_GREEN
#define RIDGWAY_SERPENTINE_GREEN float3(0.545, 0.525, 0.278)
#endif
#ifndef SERPENTINE_GREEN
#define SERPENTINE_GREEN RIDGWAY_SERPENTINE_GREEN
#endif

#ifndef RIDGWAY_SHAMROCK_GREEN
#define RIDGWAY_SHAMROCK_GREEN float3(0.471, 0.592, 0.416)
#endif
#ifndef SHAMROCK_GREEN
#define SHAMROCK_GREEN RIDGWAY_SHAMROCK_GREEN
#endif

#ifndef RIDGWAY_SHELL_PINK
#define RIDGWAY_SHELL_PINK float3(0.953, 0.820, 0.749)
#endif
#ifndef SHELL_PINK
#define SHELL_PINK RIDGWAY_SHELL_PINK
#endif

#ifndef RIDGWAY_SHRIMP_PINK
#define RIDGWAY_SHRIMP_PINK float3(0.992, 0.792, 0.737)
#endif
#ifndef SHRIMP_PINK
#define SHRIMP_PINK RIDGWAY_SHRIMP_PINK
#endif

#ifndef RIDGWAY_SKOBELOFF_GREEN
#define RIDGWAY_SKOBELOFF_GREEN float3(0.012, 0.549, 0.518)
#endif
#ifndef SKOBELOFF_GREEN
#define SKOBELOFF_GREEN RIDGWAY_SKOBELOFF_GREEN
#endif

#ifndef RIDGWAY_SKY_BLUE
#define RIDGWAY_SKY_BLUE float3(0.584, 0.757, 0.906)
#endif
#ifndef SKY_BLUE
#define SKY_BLUE RIDGWAY_SKY_BLUE
#endif

#ifndef RIDGWAY_SKY_GRAY
#define RIDGWAY_SKY_GRAY float3(0.725, 0.769, 0.812)
#endif
#ifndef SKY_GRAY
#define SKY_GRAY RIDGWAY_SKY_GRAY
#endif

#ifndef RIDGWAY_SLATE_COLOR
#define RIDGWAY_SLATE_COLOR float3(0.310, 0.357, 0.365)
#endif
#ifndef SLATE_COLOR
#define SLATE_COLOR RIDGWAY_SLATE_COLOR
#endif

#ifndef RIDGWAY_SLATE_BLACK
#define RIDGWAY_SLATE_BLACK float3(0.200, 0.247, 0.227)
#endif
#ifndef SLATE_BLACK
#define SLATE_BLACK RIDGWAY_SLATE_BLACK
#endif

#ifndef RIDGWAY_SLATE_BLUE
#define RIDGWAY_SLATE_BLUE float3(0.388, 0.447, 0.518)
#endif
#ifndef SLATE_BLUE
#define SLATE_BLUE RIDGWAY_SLATE_BLUE
#endif

#ifndef RIDGWAY_SLATE_GRAY
#define RIDGWAY_SLATE_GRAY float3(0.408, 0.451, 0.447)
#endif
#ifndef SLATE_GRAY
#define SLATE_GRAY RIDGWAY_SLATE_GRAY
#endif

#ifndef RIDGWAY_SLATE_OLIVE
#define RIDGWAY_SLATE_OLIVE float3(0.396, 0.455, 0.396)
#endif
#ifndef SLATE_OLIVE
#define SLATE_OLIVE RIDGWAY_SLATE_OLIVE
#endif

#ifndef RIDGWAY_SLATE_PURPLE
#define RIDGWAY_SLATE_PURPLE float3(0.471, 0.376, 0.439)
#endif
#ifndef SLATE_PURPLE
#define SLATE_PURPLE RIDGWAY_SLATE_PURPLE
#endif

#ifndef RIDGWAY_SLATE_VIOLET_1
#define RIDGWAY_SLATE_VIOLET_1 float3(0.380, 0.380, 0.451)
#endif
#ifndef SLATE_VIOLET_1
#define SLATE_VIOLET_1 RIDGWAY_SLATE_VIOLET_1
#endif

#ifndef RIDGWAY_SLATE_VIOLET_2
#define RIDGWAY_SLATE_VIOLET_2 float3(0.490, 0.443, 0.514)
#endif
#ifndef SLATE_VIOLET_2
#define SLATE_VIOLET_2 RIDGWAY_SLATE_VIOLET_2
#endif

#ifndef RIDGWAY_SMALT_BLUE
#define RIDGWAY_SMALT_BLUE float3(0.290, 0.341, 0.702)
#endif
#ifndef SMALT_BLUE
#define SMALT_BLUE RIDGWAY_SMALT_BLUE
#endif

#ifndef RIDGWAY_SMOKE_GRAY
#define RIDGWAY_SMOKE_GRAY float3(0.690, 0.659, 0.588)
#endif
#ifndef SMOKE_GRAY
#define SMOKE_GRAY RIDGWAY_SMOKE_GRAY
#endif

#ifndef RIDGWAY_SNUFF_BROWN
#define RIDGWAY_SNUFF_BROWN float3(0.561, 0.424, 0.298)
#endif
#ifndef SNUFF_BROWN
#define SNUFF_BROWN RIDGWAY_SNUFF_BROWN
#endif

#ifndef RIDGWAY_SOFT_BLUE_VIOLET
#define RIDGWAY_SOFT_BLUE_VIOLET float3(0.471, 0.435, 0.729)
#endif
#ifndef SOFT_BLUE_VIOLET
#define SOFT_BLUE_VIOLET RIDGWAY_SOFT_BLUE_VIOLET
#endif

#ifndef RIDGWAY_SOFT_BLUISH_VIOLET
#define RIDGWAY_SOFT_BLUISH_VIOLET float3(0.498, 0.424, 0.710)
#endif
#ifndef SOFT_BLUISH_VIOLET
#define SOFT_BLUISH_VIOLET RIDGWAY_SOFT_BLUISH_VIOLET
#endif

#ifndef RIDGWAY_SOOTY_BLACK
#define RIDGWAY_SOOTY_BLACK float3(0.314, 0.333, 0.314)
#endif
#ifndef SOOTY_BLACK
#define SOOTY_BLACK RIDGWAY_SOOTY_BLACK
#endif

#ifndef RIDGWAY_SORGHUM_BROWN
#define RIDGWAY_SORGHUM_BROWN float3(0.576, 0.431, 0.373)
#endif
#ifndef SORGHUM_BROWN
#define SORGHUM_BROWN RIDGWAY_SORGHUM_BROWN
#endif

#ifndef RIDGWAY_SORRENTO_GREEN
#define RIDGWAY_SORRENTO_GREEN float3(0.067, 0.435, 0.459)
#endif
#ifndef SORRENTO_GREEN
#define SORRENTO_GREEN RIDGWAY_SORRENTO_GREEN
#endif

#ifndef RIDGWAY_SPECTRUM_BLUE
#define RIDGWAY_SPECTRUM_BLUE float3(0.098, 0.424, 0.839)
#endif
#ifndef SPECTRUM_BLUE
#define SPECTRUM_BLUE RIDGWAY_SPECTRUM_BLUE
#endif

#ifndef RIDGWAY_SPECTRUM_RED
#define RIDGWAY_SPECTRUM_RED float3(0.643, 0.208, 0.188)
#endif
#ifndef SPECTRUM_RED
#define SPECTRUM_RED RIDGWAY_SPECTRUM_RED
#endif

#ifndef RIDGWAY_SPECTRUM_VIOLET
#define RIDGWAY_SPECTRUM_VIOLET float3(0.404, 0.251, 0.651)
#endif
#ifndef SPECTRUM_VIOLET
#define SPECTRUM_VIOLET RIDGWAY_SPECTRUM_VIOLET
#endif

#ifndef RIDGWAY_SPINACH_GREEN
#define RIDGWAY_SPINACH_GREEN float3(0.408, 0.482, 0.310)
#endif
#ifndef SPINACH_GREEN
#define SPINACH_GREEN RIDGWAY_SPINACH_GREEN
#endif

#ifndef RIDGWAY_SPINEL_PINK
#define RIDGWAY_SPINEL_PINK float3(0.847, 0.424, 0.522)
#endif
#ifndef SPINEL_PINK
#define SPINEL_PINK RIDGWAY_SPINEL_PINK
#endif

#ifndef RIDGWAY_SPINEL_RED
#define RIDGWAY_SPINEL_RED float3(0.800, 0.322, 0.420)
#endif
#ifndef SPINEL_RED
#define SPINEL_RED RIDGWAY_SPINEL_RED
#endif

#ifndef RIDGWAY_SQUILL_BLUE
#define RIDGWAY_SQUILL_BLUE float3(0.447, 0.686, 0.843)
#endif
#ifndef SQUILL_BLUE
#define SQUILL_BLUE RIDGWAY_SQUILL_BLUE
#endif

#ifndef RIDGWAY_STONE_GREEN
#define RIDGWAY_STONE_GREEN float3(0.408, 0.569, 0.463)
#endif
#ifndef STONE_GREEN
#define STONE_GREEN RIDGWAY_STONE_GREEN
#endif

#ifndef RIDGWAY_STORM_GRAY
#define RIDGWAY_STORM_GRAY float3(0.514, 0.553, 0.498)
#endif
#ifndef STORM_GRAY
#define STORM_GRAY RIDGWAY_STORM_GRAY
#endif

#ifndef RIDGWAY_STRAW_YELLOW
#define RIDGWAY_STRAW_YELLOW float3(0.988, 0.894, 0.600)
#endif
#ifndef STRAW_YELLOW
#define STRAW_YELLOW RIDGWAY_STRAW_YELLOW
#endif

#ifndef RIDGWAY_STRAWBERRY_PINK
#define RIDGWAY_STRAWBERRY_PINK float3(0.992, 0.541, 0.451)
#endif
#ifndef STRAWBERRY_PINK
#define STRAWBERRY_PINK RIDGWAY_STRAWBERRY_PINK
#endif

#ifndef RIDGWAY_STRONTIAN_YELLOW
#define RIDGWAY_STRONTIAN_YELLOW float3(0.965, 0.820, 0.294)
#endif
#ifndef STRONTIAN_YELLOW
#define STRONTIAN_YELLOW RIDGWAY_STRONTIAN_YELLOW
#endif

#ifndef RIDGWAY_SUDAN_BROWN
#define RIDGWAY_SUDAN_BROWN float3(0.592, 0.384, 0.176)
#endif
#ifndef SUDAN_BROWN
#define SUDAN_BROWN RIDGWAY_SUDAN_BROWN
#endif

#ifndef RIDGWAY_SULPHATE_GREEN
#define RIDGWAY_SULPHATE_GREEN float3(0.255, 0.624, 0.565)
#endif
#ifndef SULPHATE_GREEN
#define SULPHATE_GREEN RIDGWAY_SULPHATE_GREEN
#endif

#ifndef RIDGWAY_SULPHINE_YELLOW
#define RIDGWAY_SULPHINE_YELLOW float3(0.776, 0.651, 0.255)
#endif
#ifndef SULPHINE_YELLOW
#define SULPHINE_YELLOW RIDGWAY_SULPHINE_YELLOW
#endif

#ifndef RIDGWAY_SULPHUR_YELLOW
#define RIDGWAY_SULPHUR_YELLOW float3(0.980, 0.929, 0.678)
#endif
#ifndef SULPHUR_YELLOW
#define SULPHUR_YELLOW RIDGWAY_SULPHUR_YELLOW
#endif

#ifndef RIDGWAY_TAUPE_BROWN
#define RIDGWAY_TAUPE_BROWN float3(0.306, 0.259, 0.259)
#endif
#ifndef TAUPE_BROWN
#define TAUPE_BROWN RIDGWAY_TAUPE_BROWN
#endif

#ifndef RIDGWAY_TAWNY
#define RIDGWAY_TAWNY float3(0.761, 0.475, 0.275)
#endif
#ifndef TAWNY
#define TAWNY RIDGWAY_TAWNY
#endif

#ifndef RIDGWAY_TAWNY_OLIVE
#define RIDGWAY_TAWNY_OLIVE float3(0.678, 0.522, 0.341)
#endif
#ifndef TAWNY_OLIVE
#define TAWNY_OLIVE RIDGWAY_TAWNY_OLIVE
#endif

#ifndef RIDGWAY_TEA_GREEN
#define RIDGWAY_TEA_GREEN float3(0.620, 0.631, 0.522)
#endif
#ifndef TEA_GREEN
#define TEA_GREEN RIDGWAY_TEA_GREEN
#endif

#ifndef RIDGWAY_TERRA_COTTA
#define RIDGWAY_TERRA_COTTA float3(0.769, 0.467, 0.365)
#endif
#ifndef TERRA_COTTA
#define TERRA_COTTA RIDGWAY_TERRA_COTTA
#endif

#ifndef RIDGWAY_TERRE_VERTE
#define RIDGWAY_TERRE_VERTE float3(0.329, 0.518, 0.471)
#endif
#ifndef TERRE_VERTE
#define TERRE_VERTE RIDGWAY_TERRE_VERTE
#endif

#ifndef RIDGWAY_TESTACEOUS
#define RIDGWAY_TESTACEOUS float3(0.796, 0.502, 0.384)
#endif
#ifndef TESTACEOUS
#define TESTACEOUS RIDGWAY_TESTACEOUS
#endif

#ifndef RIDGWAY_THULITE_PINK
#define RIDGWAY_THULITE_PINK float3(0.918, 0.596, 0.710)
#endif
#ifndef THULITE_PINK
#define THULITE_PINK RIDGWAY_THULITE_PINK
#endif

#ifndef RIDGWAY_TIBER_GREEN
#define RIDGWAY_TIBER_GREEN float3(0.741, 0.851, 0.624)
#endif
#ifndef TIBER_GREEN
#define TIBER_GREEN RIDGWAY_TIBER_GREEN
#endif

#ifndef RIDGWAY_TILLEUL_BUFF
#define RIDGWAY_TILLEUL_BUFF float3(0.894, 0.820, 0.741)
#endif
#ifndef TILLEUL_BUFF
#define TILLEUL_BUFF RIDGWAY_TILLEUL_BUFF
#endif

#ifndef RIDGWAY_TOURMALINE_PINK
#define RIDGWAY_TOURMALINE_PINK float3(0.757, 0.502, 0.584)
#endif
#ifndef TOURMALINE_PINK
#define TOURMALINE_PINK RIDGWAY_TOURMALINE_PINK
#endif

#ifndef RIDGWAY_TURQUOISE_GREEN
#define RIDGWAY_TURQUOISE_GREEN float3(0.553, 0.847, 0.784)
#endif
#ifndef TURQUOISE_GREEN
#define TURQUOISE_GREEN RIDGWAY_TURQUOISE_GREEN
#endif

#ifndef RIDGWAY_TURTLE_GREEN
#define RIDGWAY_TURTLE_GREEN float3(0.686, 0.757, 0.506)
#endif
#ifndef TURTLE_GREEN
#define TURTLE_GREEN RIDGWAY_TURTLE_GREEN
#endif

#ifndef RIDGWAY_TYRIAN_BLUE
#define RIDGWAY_TYRIAN_BLUE float3(0.392, 0.482, 0.588)
#endif
#ifndef TYRIAN_BLUE
#define TYRIAN_BLUE RIDGWAY_TYRIAN_BLUE
#endif

#ifndef RIDGWAY_TYRIAN_PINK
#define RIDGWAY_TYRIAN_PINK float3(0.902, 0.380, 0.627)
#endif
#ifndef TYRIAN_PINK
#define TYRIAN_PINK RIDGWAY_TYRIAN_PINK
#endif

#ifndef RIDGWAY_TYRIAN_ROSE
#define RIDGWAY_TYRIAN_ROSE float3(0.855, 0.125, 0.408)
#endif
#ifndef TYRIAN_ROSE
#define TYRIAN_ROSE RIDGWAY_TYRIAN_ROSE
#endif

#ifndef RIDGWAY_TYROLITE_GREEN
#define RIDGWAY_TYROLITE_GREEN float3(0.337, 0.682, 0.631)
#endif
#ifndef TYROLITE_GREEN
#define TYROLITE_GREEN RIDGWAY_TYROLITE_GREEN
#endif

#ifndef RIDGWAY_ULTRAMARINE_ASH
#define RIDGWAY_ULTRAMARINE_ASH float3(0.380, 0.471, 0.702)
#endif
#ifndef ULTRAMARINE_ASH
#define ULTRAMARINE_ASH RIDGWAY_ULTRAMARINE_ASH
#endif

#ifndef RIDGWAY_ULTRAMARINE_BLUE
#define RIDGWAY_ULTRAMARINE_BLUE float3(0.098, 0.365, 0.776)
#endif
#ifndef ULTRAMARINE_BLUE
#define ULTRAMARINE_BLUE RIDGWAY_ULTRAMARINE_BLUE
#endif

#ifndef RIDGWAY_URANIA_BLUE
#define RIDGWAY_URANIA_BLUE float3(0.196, 0.212, 0.298)
#endif
#ifndef URANIA_BLUE
#define URANIA_BLUE RIDGWAY_URANIA_BLUE
#endif

#ifndef RIDGWAY_VANDERPOELS_BLUE
#define RIDGWAY_VANDERPOELS_BLUE float3(0.357, 0.533, 0.729)
#endif
#ifndef VANDERPOELS_BLUE
#define VANDERPOELS_BLUE RIDGWAY_VANDERPOELS_BLUE
#endif

#ifndef RIDGWAY_VANDERPOELS_GREEN
#define RIDGWAY_VANDERPOELS_GREEN float3(0.506, 0.659, 0.447)
#endif
#ifndef VANDERPOELS_GREEN
#define VANDERPOELS_GREEN RIDGWAY_VANDERPOELS_GREEN
#endif

#ifndef RIDGWAY_VANDERPOELS_VIOLET
#define RIDGWAY_VANDERPOELS_VIOLET float3(0.478, 0.443, 0.604)
#endif
#ifndef VANDERPOELS_VIOLET
#define VANDERPOELS_VIOLET RIDGWAY_VANDERPOELS_VIOLET
#endif

#ifndef RIDGWAY_VANDYKE_BROWN
#define RIDGWAY_VANDYKE_BROWN float3(0.416, 0.314, 0.251)
#endif
#ifndef VANDYKE_BROWN
#define VANDYKE_BROWN RIDGWAY_VANDYKE_BROWN
#endif

#ifndef RIDGWAY_VANDYKE_RED
#define RIDGWAY_VANDYKE_RED float3(0.506, 0.251, 0.259)
#endif
#ifndef VANDYKE_RED
#define VANDYKE_RED RIDGWAY_VANDYKE_RED
#endif

#ifndef RIDGWAY_VARISCITE_GREEN
#define RIDGWAY_VARISCITE_GREEN float3(0.635, 0.831, 0.710)
#endif
#ifndef VARISCITE_GREEN
#define VARISCITE_GREEN RIDGWAY_VARISCITE_GREEN
#endif

#ifndef RIDGWAY_VARLEYS_GRAY
#define RIDGWAY_VARLEYS_GRAY float3(0.455, 0.475, 0.522)
#endif
#ifndef VARLEYS_GRAY
#define VARLEYS_GRAY RIDGWAY_VARLEYS_GRAY
#endif

#ifndef RIDGWAY_VARLEYS_GREEN
#define RIDGWAY_VARLEYS_GREEN float3(0.333, 0.412, 0.298)
#endif
#ifndef VARLEYS_GREEN
#define VARLEYS_GREEN RIDGWAY_VARLEYS_GREEN
#endif

#ifndef RIDGWAY_VENETIAN_BLUE
#define RIDGWAY_VENETIAN_BLUE float3(0.412, 0.518, 0.729)
#endif
#ifndef VENETIAN_BLUE
#define VENETIAN_BLUE RIDGWAY_VENETIAN_BLUE
#endif

#ifndef RIDGWAY_VENETIAN_PINK
#define RIDGWAY_VENETIAN_PINK float3(0.949, 0.749, 0.749)
#endif
#ifndef VENETIAN_PINK
#define VENETIAN_PINK RIDGWAY_VENETIAN_PINK
#endif

#ifndef RIDGWAY_VENICE_GREEN
#define RIDGWAY_VENICE_GREEN float3(0.361, 0.784, 0.725)
#endif
#ifndef VENICE_GREEN
#define VENICE_GREEN RIDGWAY_VENICE_GREEN
#endif

#ifndef RIDGWAY_VERBENA_VIOLET
#define RIDGWAY_VERBENA_VIOLET float3(0.663, 0.655, 0.769)
#endif
#ifndef VERBENA_VIOLET
#define VERBENA_VIOLET RIDGWAY_VERBENA_VIOLET
#endif

#ifndef RIDGWAY_VERDIGRIS_GREEN
#define RIDGWAY_VERDIGRIS_GREEN float3(0.275, 0.612, 0.494)
#endif
#ifndef VERDIGRIS_GREEN
#define VERDIGRIS_GREEN RIDGWAY_VERDIGRIS_GREEN
#endif

#ifndef RIDGWAY_VERNONIA_PURPLE
#define RIDGWAY_VERNONIA_PURPLE float3(0.604, 0.376, 0.420)
#endif
#ifndef VERNONIA_PURPLE
#define VERNONIA_PURPLE RIDGWAY_VERNONIA_PURPLE
#endif

#ifndef RIDGWAY_VERONA_BROWN
#define RIDGWAY_VERONA_BROWN float3(0.553, 0.416, 0.306)
#endif
#ifndef VERONA_BROWN
#define VERONA_BROWN RIDGWAY_VERONA_BROWN
#endif

#ifndef RIDGWAY_VERONESE_GREEN
#define RIDGWAY_VERONESE_GREEN float3(0.792, 0.855, 0.588)
#endif
#ifndef VERONESE_GREEN
#define VERONESE_GREEN RIDGWAY_VERONESE_GREEN
#endif

#ifndef RIDGWAY_VETIVER_GREEN
#define RIDGWAY_VETIVER_GREEN float3(0.596, 0.600, 0.451)
#endif
#ifndef VETIVER_GREEN
#define VETIVER_GREEN RIDGWAY_VETIVER_GREEN
#endif

#ifndef RIDGWAY_VICTORIA_LAKE
#define RIDGWAY_VICTORIA_LAKE float3(0.384, 0.235, 0.220)
#endif
#ifndef VICTORIA_LAKE
#define VICTORIA_LAKE RIDGWAY_VICTORIA_LAKE
#endif

#ifndef RIDGWAY_VINACEOUS
#define RIDGWAY_VINACEOUS float3(0.776, 0.584, 0.612)
#endif
#ifndef VINACEOUS
#define VINACEOUS RIDGWAY_VINACEOUS
#endif

#ifndef RIDGWAY_VINACEOUS_BROWN
#define RIDGWAY_VINACEOUS_BROWN float3(0.569, 0.416, 0.380)
#endif
#ifndef VINACEOUS_BROWN
#define VINACEOUS_BROWN RIDGWAY_VINACEOUS_BROWN
#endif

#ifndef RIDGWAY_VINACEOUS_BUFF
#define RIDGWAY_VINACEOUS_BUFF float3(0.808, 0.698, 0.604)
#endif
#ifndef VINACEOUS_BUFF
#define VINACEOUS_BUFF RIDGWAY_VINACEOUS_BUFF
#endif

#ifndef RIDGWAY_VINACEOUS_CINNAMON
#define RIDGWAY_VINACEOUS_CINNAMON float3(0.831, 0.592, 0.447)
#endif
#ifndef VINACEOUS_CINNAMON
#define VINACEOUS_CINNAMON RIDGWAY_VINACEOUS_CINNAMON
#endif

#ifndef RIDGWAY_VINACEOUS_DRAB
#define RIDGWAY_VINACEOUS_DRAB float3(0.584, 0.482, 0.455)
#endif
#ifndef VINACEOUS_DRAB
#define VINACEOUS_DRAB RIDGWAY_VINACEOUS_DRAB
#endif

#ifndef RIDGWAY_VINACEOUS_FAWN
#define RIDGWAY_VINACEOUS_FAWN float3(0.753, 0.584, 0.502)
#endif
#ifndef VINACEOUS_FAWN
#define VINACEOUS_FAWN RIDGWAY_VINACEOUS_FAWN
#endif

#ifndef RIDGWAY_VINACEOUS_GRAY
#define RIDGWAY_VINACEOUS_GRAY float3(0.659, 0.608, 0.627)
#endif
#ifndef VINACEOUS_GRAY
#define VINACEOUS_GRAY RIDGWAY_VINACEOUS_GRAY
#endif

#ifndef RIDGWAY_VINACEOUS_LAVENDER
#define RIDGWAY_VINACEOUS_LAVENDER float3(0.800, 0.729, 0.757)
#endif
#ifndef VINACEOUS_LAVENDER
#define VINACEOUS_LAVENDER RIDGWAY_VINACEOUS_LAVENDER
#endif

#ifndef RIDGWAY_VINACEOUS_LILAC
#define RIDGWAY_VINACEOUS_LILAC float3(0.710, 0.541, 0.588)
#endif
#ifndef VINACEOUS_LILAC
#define VINACEOUS_LILAC RIDGWAY_VINACEOUS_LILAC
#endif

#ifndef RIDGWAY_VINACEOUS_PINK
#define RIDGWAY_VINACEOUS_PINK float3(0.922, 0.714, 0.624)
#endif
#ifndef VINACEOUS_PINK
#define VINACEOUS_PINK RIDGWAY_VINACEOUS_PINK
#endif

#ifndef RIDGWAY_VINACEOUS_PURPLE_1
#define RIDGWAY_VINACEOUS_PURPLE_1 float3(0.576, 0.376, 0.431)
#endif
#ifndef VINACEOUS_PURPLE_1
#define VINACEOUS_PURPLE_1 RIDGWAY_VINACEOUS_PURPLE_1
#endif

#ifndef RIDGWAY_VINACEOUS_PURPLE_2
#define RIDGWAY_VINACEOUS_PURPLE_2 float3(0.533, 0.439, 0.510)
#endif
#ifndef VINACEOUS_PURPLE_2
#define VINACEOUS_PURPLE_2 RIDGWAY_VINACEOUS_PURPLE_2
#endif

#ifndef RIDGWAY_VINACEOUS_RUFOUS
#define RIDGWAY_VINACEOUS_RUFOUS float3(0.710, 0.353, 0.251)
#endif
#ifndef VINACEOUS_RUFOUS
#define VINACEOUS_RUFOUS RIDGWAY_VINACEOUS_RUFOUS
#endif

#ifndef RIDGWAY_VINACEOUS_RUSSET
#define RIDGWAY_VINACEOUS_RUSSET float3(0.631, 0.435, 0.357)
#endif
#ifndef VINACEOUS_RUSSET
#define VINACEOUS_RUSSET RIDGWAY_VINACEOUS_RUSSET
#endif

#ifndef RIDGWAY_VINACEOUS_SLATE
#define RIDGWAY_VINACEOUS_SLATE float3(0.396, 0.369, 0.376)
#endif
#ifndef VINACEOUS_SLATE
#define VINACEOUS_SLATE RIDGWAY_VINACEOUS_SLATE
#endif

#ifndef RIDGWAY_VINACEOUS_TAWNY
#define RIDGWAY_VINACEOUS_TAWNY float3(0.796, 0.498, 0.353)
#endif
#ifndef VINACEOUS_TAWNY
#define VINACEOUS_TAWNY RIDGWAY_VINACEOUS_TAWNY
#endif

#ifndef RIDGWAY_VIOLET_CARMINE
#define RIDGWAY_VIOLET_CARMINE float3(0.380, 0.216, 0.239)
#endif
#ifndef VIOLET_CARMINE
#define VIOLET_CARMINE RIDGWAY_VIOLET_CARMINE
#endif

#ifndef RIDGWAY_VIOLET_ULTRAMARINE
#define RIDGWAY_VIOLET_ULTRAMARINE float3(0.369, 0.278, 0.671)
#endif
#ifndef VIOLET_ULTRAMARINE
#define VIOLET_ULTRAMARINE RIDGWAY_VIOLET_ULTRAMARINE
#endif

#ifndef RIDGWAY_VIOLET_GRAY
#define RIDGWAY_VIOLET_GRAY float3(0.478, 0.490, 0.502)
#endif
#ifndef VIOLET_GRAY
#define VIOLET_GRAY RIDGWAY_VIOLET_GRAY
#endif

#ifndef RIDGWAY_VIOLET_PLUMBEOUS
#define RIDGWAY_VIOLET_PLUMBEOUS float3(0.514, 0.541, 0.596)
#endif
#ifndef VIOLET_PLUMBEOUS
#define VIOLET_PLUMBEOUS RIDGWAY_VIOLET_PLUMBEOUS
#endif

#ifndef RIDGWAY_VIOLET_PURPLE
#define RIDGWAY_VIOLET_PURPLE float3(0.631, 0.235, 0.659)
#endif
#ifndef VIOLET_PURPLE
#define VIOLET_PURPLE RIDGWAY_VIOLET_PURPLE
#endif

#ifndef RIDGWAY_VIOLET_SLATE
#define RIDGWAY_VIOLET_SLATE float3(0.373, 0.408, 0.435)
#endif
#ifndef VIOLET_SLATE
#define VIOLET_SLATE RIDGWAY_VIOLET_SLATE
#endif

#ifndef RIDGWAY_VIRIDIAN_GREEN
#define RIDGWAY_VIRIDIAN_GREEN float3(0.047, 0.537, 0.439)
#endif
#ifndef VIRIDIAN_GREEN
#define VIRIDIAN_GREEN RIDGWAY_VIRIDIAN_GREEN
#endif

#ifndef RIDGWAY_VIRIDINE_GREEN
#define RIDGWAY_VIRIDINE_GREEN float3(0.867, 0.894, 0.565)
#endif
#ifndef VIRIDINE_GREEN
#define VIRIDINE_GREEN RIDGWAY_VIRIDINE_GREEN
#endif

#ifndef RIDGWAY_VIRIDINE_YELLOW
#define RIDGWAY_VIRIDINE_YELLOW float3(0.694, 0.753, 0.376)
#endif
#ifndef VIRIDINE_YELLOW
#define VIRIDINE_YELLOW RIDGWAY_VIRIDINE_YELLOW
#endif

#ifndef RIDGWAY_VIVID_GREEN
#define RIDGWAY_VIVID_GREEN float3(0.212, 0.647, 0.482)
#endif
#ifndef VIVID_GREEN
#define VIVID_GREEN RIDGWAY_VIVID_GREEN
#endif

#ifndef RIDGWAY_WALL_GREEN
#define RIDGWAY_WALL_GREEN float3(0.016, 0.459, 0.443)
#endif
#ifndef WALL_GREEN
#define WALL_GREEN RIDGWAY_WALL_GREEN
#endif

#ifndef RIDGWAY_WALNUT_BROWN
#define RIDGWAY_WALNUT_BROWN float3(0.561, 0.392, 0.314)
#endif
#ifndef WALNUT_BROWN
#define WALNUT_BROWN RIDGWAY_WALNUT_BROWN
#endif

#ifndef RIDGWAY_WARBLER_GREEN
#define RIDGWAY_WARBLER_GREEN float3(0.565, 0.522, 0.220)
#endif
#ifndef WARBLER_GREEN
#define WARBLER_GREEN RIDGWAY_WARBLER_GREEN
#endif

#ifndef RIDGWAY_WARM_BLACKISH_BROWN
#define RIDGWAY_WARM_BLACKISH_BROWN float3(0.333, 0.290, 0.271)
#endif
#ifndef WARM_BLACKISH_BROWN
#define WARM_BLACKISH_BROWN RIDGWAY_WARM_BLACKISH_BROWN
#endif

#ifndef RIDGWAY_WARM_BUFF
#define RIDGWAY_WARM_BUFF float3(0.976, 0.780, 0.557)
#endif
#ifndef WARM_BUFF
#define WARM_BUFF RIDGWAY_WARM_BUFF
#endif

#ifndef RIDGWAY_WARM_SEPIA
#define RIDGWAY_WARM_SEPIA float3(0.431, 0.337, 0.267)
#endif
#ifndef WARM_SEPIA
#define WARM_SEPIA RIDGWAY_WARM_SEPIA
#endif

#ifndef RIDGWAY_WATER_GREEN
#define RIDGWAY_WATER_GREEN float3(0.757, 0.776, 0.627)
#endif
#ifndef WATER_GREEN
#define WATER_GREEN RIDGWAY_WATER_GREEN
#endif

#ifndef RIDGWAY_WAX_YELLOW
#define RIDGWAY_WAX_YELLOW float3(0.941, 0.769, 0.255)
#endif
#ifndef WAX_YELLOW
#define WAX_YELLOW RIDGWAY_WAX_YELLOW
#endif

#ifndef RIDGWAY_WEDGEWOOD_BLUE
#define RIDGWAY_WEDGEWOOD_BLUE float3(0.753, 0.796, 0.957)
#endif
#ifndef WEDGEWOOD_BLUE
#define WEDGEWOOD_BLUE RIDGWAY_WEDGEWOOD_BLUE
#endif

#ifndef RIDGWAY_WHITE
#define RIDGWAY_WHITE float3(0.980, 0.961, 0.918)
#endif
#ifndef WHITE
#define WHITE RIDGWAY_WHITE
#endif

#ifndef RIDGWAY_WINDSOR_BLUE
#define RIDGWAY_WINDSOR_BLUE float3(0.400, 0.451, 0.600)
#endif
#ifndef WINDSOR_BLUE
#define WINDSOR_BLUE RIDGWAY_WINDSOR_BLUE
#endif

#ifndef RIDGWAY_WINTER_GREEN
#define RIDGWAY_WINTER_GREEN float3(0.416, 0.561, 0.412)
#endif
#ifndef WINTER_GREEN
#define WINTER_GREEN RIDGWAY_WINTER_GREEN
#endif

#ifndef RIDGWAY_WISTARIA_BLUE
#define RIDGWAY_WISTARIA_BLUE float3(0.584, 0.573, 0.863)
#endif
#ifndef WISTARIA_BLUE
#define WISTARIA_BLUE RIDGWAY_WISTARIA_BLUE
#endif

#ifndef RIDGWAY_WISTARIA_VIOLET
#define RIDGWAY_WISTARIA_VIOLET float3(0.627, 0.573, 0.867)
#endif
#ifndef WISTARIA_VIOLET
#define WISTARIA_VIOLET RIDGWAY_WISTARIA_VIOLET
#endif

#ifndef RIDGWAY_WOOD_BROWN
#define RIDGWAY_WOOD_BROWN float3(0.698, 0.565, 0.431)
#endif
#ifndef WOOD_BROWN
#define WOOD_BROWN RIDGWAY_WOOD_BROWN
#endif

#ifndef RIDGWAY_XANTHINE_ORANGE
#define RIDGWAY_XANTHINE_ORANGE float3(0.816, 0.427, 0.114)
#endif
#ifndef XANTHINE_ORANGE
#define XANTHINE_ORANGE RIDGWAY_XANTHINE_ORANGE
#endif

#ifndef RIDGWAY_YALE_BLUE
#define RIDGWAY_YALE_BLUE float3(0.518, 0.671, 0.867)
#endif
#ifndef YALE_BLUE
#define YALE_BLUE RIDGWAY_YALE_BLUE
#endif

#ifndef RIDGWAY_YELLOW_OCHER
#define RIDGWAY_YELLOW_OCHER float3(0.875, 0.604, 0.267)
#endif
#ifndef YELLOW_OCHER
#define YELLOW_OCHER RIDGWAY_YELLOW_OCHER
#endif

#ifndef RIDGWAY_YELLOW_GREEN
#define RIDGWAY_YELLOW_GREEN float3(0.855, 0.824, 0.247)
#endif
#ifndef YELLOW_GREEN
#define YELLOW_GREEN RIDGWAY_YELLOW_GREEN
#endif

#ifndef RIDGWAY_YELLOWISH_CITRINE
#define RIDGWAY_YELLOWISH_CITRINE float3(0.678, 0.620, 0.294)
#endif
#ifndef YELLOWISH_CITRINE
#define YELLOWISH_CITRINE RIDGWAY_YELLOWISH_CITRINE
#endif

#ifndef RIDGWAY_YELLOWISH_GLAUCOUS
#define RIDGWAY_YELLOWISH_GLAUCOUS float3(0.780, 0.784, 0.686)
#endif
#ifndef YELLOWISH_GLAUCOUS
#define YELLOWISH_GLAUCOUS RIDGWAY_YELLOWISH_GLAUCOUS
#endif

#ifndef RIDGWAY_YELLOWISH_OIL_GREEN
#define RIDGWAY_YELLOWISH_OIL_GREEN float3(0.553, 0.529, 0.271)
#endif
#ifndef YELLOWISH_OIL_GREEN
#define YELLOWISH_OIL_GREEN RIDGWAY_YELLOWISH_OIL_GREEN
#endif

#ifndef RIDGWAY_YELLOWISH_OLIVE
#define RIDGWAY_YELLOWISH_OLIVE float3(0.486, 0.463, 0.302)
#endif
#ifndef YELLOWISH_OLIVE
#define YELLOWISH_OLIVE RIDGWAY_YELLOWISH_OLIVE
#endif

#ifndef RIDGWAY_YEW_GREEN
#define RIDGWAY_YEW_GREEN float3(0.333, 0.380, 0.278)
#endif
#ifndef YEW_GREEN
#define YEW_GREEN RIDGWAY_YEW_GREEN
#endif

#ifndef RIDGWAY_YVETTE_VIOLET
#define RIDGWAY_YVETTE_VIOLET float3(0.349, 0.318, 0.416)
#endif
#ifndef YVETTE_VIOLET
#define YVETTE_VIOLET RIDGWAY_YVETTE_VIOLET
#endif

#ifndef RIDGWAY_ZINC_GREEN
#define RIDGWAY_ZINC_GREEN float3(0.353, 0.557, 0.455)
#endif
#ifndef ZINC_GREEN
#define ZINC_GREEN RIDGWAY_ZINC_GREEN
#endif

#ifndef RIDGWAY_ZINC_ORANGE
#define RIDGWAY_ZINC_ORANGE float3(0.929, 0.553, 0.294)
#endif
#ifndef ZINC_ORANGE
#define ZINC_ORANGE RIDGWAY_ZINC_ORANGE
#endif

