(ns vybe.blender
  (:require
   [nrepl.core :as nrepl]))

(def ^:no-doc ^:dynamic *nrepl-init* nil)

(defn connect
  "Connect to a running basilisp blender nREPL server.

  Returns a session map containing connection and the client (you can use it
  with other functions from this namespace)."
  [port]
  (let [conn (nrepl/connect :port port)
        client (nrepl/client conn Long/MAX_VALUE)]
    {:conn conn
     :client client}))
#_ (def session (connect 7889))

(defn disconnect
  [{:keys [conn]}]
  (.close conn))

(defn eval*
  "Eval from the blender session."
  [code-str {:keys [client]}]
  (-> client
      (nrepl/message {:ns "vybe.basilisp.bake"
                      :op "eval"
                      :code code-str})
      doall
      nrepl/combine-responses))
#_ (-> (pr-str '(+ 2 4))
       (eval* session))
