/*
contributors: Patricio Gonzalez Vivo
description: "Converts a Lch ot Lab color space. \nNote: LCh is simply Lab but converted to polar coordinates (in degrees).\n"
use: <float3|float4> lch2lab(<float3|float4> color)
license:
    - Copyright (c) 2021 Patricio Gonzalez Vivo under Prosperity License - https://prosperitylicense.com/versions/3.0.0
    - Copyright (c) 2021 Patricio Gonzalez Vivo under Patron License - https://lygia.xyz/license
*/

#ifndef FNC_LCH2LAB
#define FNC_LCH2LAB
float3 lch2lab(float3 lch) {
    return float3(
        lch.x,
        lch.y * cos(lch.z * 0.01745329251),
        lch.y * sin(lch.z * 0.01745329251)
    );
}
float4 lch2lab(float4 lch) { return float4(lch2lab(lch.xyz),lch.a);}
#endif