/*
 * Decompiled with CFR 0.152.
 */
package org.vybe.netcode;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.vybe.netcode.cn_ack_system_config_t;
import org.vybe.netcode.cn_circular_buffer_t;
import org.vybe.netcode.cn_crypto_key_t;
import org.vybe.netcode.cn_endpoint_t;
import org.vybe.netcode.cn_result_t;
import org.vybe.netcode.cn_server_config_t;
import org.vybe.netcode.cn_transport_config_t;

public class netcode {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup("/tmp/pfeodrippe_vybe_native/libvybe_cutenet.dylib", LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;
    private static final int CN_CONNECT_TOKEN_SIZE = 1114;
    private static final int CN_CONNECT_TOKEN_USER_DATA_SIZE = 256;
    private static final int CN_SERVER_MAX_CLIENTS = 32;
    private static final int CN_KB = 1024;
    private static final int CN_MACOSX = 1;
    private static final int HYDRO_VERSION_MAJOR = 1;
    private static final int HYDRO_VERSION_MINOR = 0;
    private static final int hydro_random_SEEDBYTES = 32;
    private static final int hydro_hash_BYTES = 32;
    private static final int hydro_hash_BYTES_MAX = 65535;
    private static final int hydro_hash_BYTES_MIN = 16;
    private static final int hydro_hash_CONTEXTBYTES = 8;
    private static final int hydro_hash_KEYBYTES = 32;
    private static final int hydro_secretbox_CONTEXTBYTES = 8;
    private static final int hydro_secretbox_KEYBYTES = 32;
    private static final int hydro_secretbox_PROBEBYTES = 16;
    private static final int hydro_kdf_CONTEXTBYTES = 8;
    private static final int hydro_kdf_KEYBYTES = 32;
    private static final int hydro_kdf_BYTES_MAX = 65535;
    private static final int hydro_kdf_BYTES_MIN = 16;
    private static final int hydro_sign_BYTES = 64;
    private static final int hydro_sign_CONTEXTBYTES = 8;
    private static final int hydro_sign_PUBLICKEYBYTES = 32;
    private static final int hydro_sign_SECRETKEYBYTES = 64;
    private static final int hydro_sign_SEEDBYTES = 32;
    private static final int hydro_kx_SESSIONKEYBYTES = 32;
    private static final int hydro_kx_PUBLICKEYBYTES = 32;
    private static final int hydro_kx_SECRETKEYBYTES = 32;
    private static final int hydro_kx_PSKBYTES = 32;
    private static final int hydro_kx_SEEDBYTES = 32;
    private static final int hydro_pwhash_CONTEXTBYTES = 8;
    private static final int hydro_pwhash_MASTERKEYBYTES = 32;
    private static final int hydro_pwhash_STOREDBYTES = 128;
    private static final int HYDRO_HWTYPE_ATMEGA328 = 1;
    private static final int __unix__ = 1;
    private static final int gimli_BLOCKBYTES = 48;
    private static final int gimli_CAPACITY = 32;
    private static final int gimli_RATE = 16;
    private static final int gimli_TAG_HEADER = 1;
    private static final int gimli_TAG_PAYLOAD = 2;
    private static final int gimli_TAG_FINAL = 8;
    private static final int gimli_TAG_FINAL0 = 248;
    private static final int gimli_TAG_KEY0 = 254;
    private static final int gimli_TAG_KEY = 255;
    private static final int gimli_DOMAIN_AEAD = 0;
    private static final int gimli_DOMAIN_XOF = 15;
    private static final int hydro_secretbox_NONCEBYTES = 20;
    private static final int hydro_secretbox_MACBYTES = 16;
    private static final int hydro_x25519_BYTES = 32;
    private static final int hydro_x25519_PUBLICKEYBYTES = 32;
    private static final int hydro_x25519_SECRETKEYBYTES = 32;
    private static final int hydro_secretbox_IVBYTES = 20;
    private static final int hydro_secretbox_SIVBYTES = 20;
    private static final int hydro_x25519_WBITS = 64;
    private static final int hydro_kx_AEAD_MACBYTES = 16;
    private static final int hydro_pwhash_ENC_ALGBYTES = 1;
    private static final int hydro_pwhash_HASH_ALGBYTES = 1;
    private static final int hydro_pwhash_THREADSBYTES = 1;
    private static final int hydro_pwhash_OPSLIMITBYTES = 8;
    private static final int hydro_pwhash_MEMLIMITBYTES = 8;
    private static final int hydro_pwhash_HASHBYTES = 32;
    private static final int hydro_pwhash_SALTBYTES = 16;
    private static final int hydro_pwhash_ENC_ALG = 1;
    private static final int hydro_pwhash_HASH_ALG = 1;
    private static final int hydro_sign_CHALLENGEBYTES = 32;
    private static final int hydro_sign_NONCEBYTES = 32;
    private static final int hydro_sign_PREHASHBYTES = 64;
    private static final int CN_PROTOCOL_SERVER_MAX_CLIENTS = 32;
    private static final int CN_PROTOCOL_SIGNATURE_SIZE = 64;
    private static final int CN_PROTOCOL_CONNECT_TOKEN_PACKET_SIZE = 1024;
    private static final int CN_PROTOCOL_CONNECT_TOKEN_SIZE = 1114;
    private static final int CN_PROTOCOL_CONNECT_TOKEN_USER_DATA_SIZE = 256;
    private static final int CN_PROTOCOL_CONNECT_TOKEN_ENDPOINT_MAX = 32;
    private static final int CN_PROTOCOL_REPLAY_BUFFER_SIZE = 256;
    private static final int CN_PROTOCOL_DISCONNECT_REDUNDANT_PACKET_COUNT = 10;
    private static final int CN_PROTOCOL_CHALLENGE_DATA_SIZE = 256;
    private static final int CN_PROTOCOL_REDUNDANT_DISCONNECT_PACKET_COUNT = 10;
    private static final int CN_ACK_SYSTEM_MAX_PACKET_SIZE = 1180;
    private static final int CN_TRANSPORT_MAX_FRAGMENT_SIZE = 1100;
    private static final int CN_ADDRESS_TYPE_NONE = 0;
    private static final int CN_ADDRESS_TYPE_IPV4 = 1;
    private static final int CN_ADDRESS_TYPE_IPV6 = 2;
    private static final int CN_CLIENT_STATE_CONNECT_TOKEN_EXPIRED = -6;
    private static final int CN_CLIENT_STATE_INVALID_CONNECT_TOKEN = -5;
    private static final int CN_CLIENT_STATE_CONNECTION_TIMED_OUT = -4;
    private static final int CN_CLIENT_STATE_CHALLENGE_RESPONSE_TIMED_OUT = -3;
    private static final int CN_CLIENT_STATE_CONNECTION_REQUEST_TIMED_OUT = -2;
    private static final int CN_CLIENT_STATE_CONNECTION_DENIED = -1;
    private static final int CN_CLIENT_STATE_DISCONNECTED = 0;
    private static final int CN_CLIENT_STATE_SENDING_CONNECTION_REQUEST = 1;
    private static final int CN_CLIENT_STATE_SENDING_CHALLENGE_RESPONSE = 2;
    private static final int CN_CLIENT_STATE_CONNECTED = 3;
    private static final int CN_SERVER_EVENT_TYPE_NEW_CONNECTION = 0;
    private static final int CN_SERVER_EVENT_TYPE_DISCONNECTED = 1;
    private static final int CN_SERVER_EVENT_TYPE_PAYLOAD_PACKET = 2;
    public static final ValueLayout.OfLong hydro_x25519_limb_t = C_LONG_LONG;
    private static final int CN_PROTOCOL_PACKET_TYPE_CONNECT_TOKEN = 0;
    private static final int CN_PROTOCOL_PACKET_TYPE_CONNECTION_ACCEPTED = 1;
    private static final int CN_PROTOCOL_PACKET_TYPE_CONNECTION_DENIED = 2;
    private static final int CN_PROTOCOL_PACKET_TYPE_KEEPALIVE = 3;
    private static final int CN_PROTOCOL_PACKET_TYPE_DISCONNECT = 4;
    private static final int CN_PROTOCOL_PACKET_TYPE_CHALLENGE_REQUEST = 5;
    private static final int CN_PROTOCOL_PACKET_TYPE_CHALLENGE_RESPONSE = 6;
    private static final int CN_PROTOCOL_PACKET_TYPE_PAYLOAD = 7;
    private static final int CN_PROTOCOL_PACKET_TYPE_COUNT = 8;
    private static final int CN_PROTOCOL_CLIENT_STATE_CONNECT_TOKEN_EXPIRED = -6;
    private static final int CN_PROTOCOL_CLIENT_STATE_INVALID_CONNECT_TOKEN = -5;
    private static final int CN_PROTOCOL_CLIENT_STATE_CONNECTION_TIMED_OUT = -4;
    private static final int CN_PROTOCOL_CLIENT_STATE_CHALLENGED_RESPONSE_TIMED_OUT = -3;
    private static final int CN_PROTOCOL_CLIENT_STATE_CONNECTION_REQUEST_TIMED_OUT = -2;
    private static final int CN_PROTOCOL_CLIENT_STATE_CONNECTION_DENIED = -1;
    private static final int CN_PROTOCOL_CLIENT_STATE_DISCONNECTED = 0;
    private static final int CN_PROTOCOL_CLIENT_STATE_SENDING_CONNECTION_REQUEST = 1;
    private static final int CN_PROTOCOL_CLIENT_STATE_SENDING_CHALLENGE_RESPONSE = 2;
    private static final int CN_PROTOCOL_CLIENT_STATE_CONNECTED = 3;
    private static final int CN_PROTOCOL_SERVER_EVENT_NEW_CONNECTION = 0;
    private static final int CN_PROTOCOL_SERVER_EVENT_DISCONNECTED = 1;
    private static final int CN_PROTOCOL_SERVER_EVENT_PAYLOAD_PACKET = 2;
    public static final ValueLayout.OfInt cn_socket_cn_handle_t = C_INT;
    public static final ValueLayout.OfLong cn_handle_t = C_LONG_LONG;
    private static final int CN_ACK_SYSTEM_COUNTERS_PACKETS_SENT = 0;
    private static final int CN_ACK_SYSTEM_COUNTERS_PACKETS_RECEIVED = 1;
    private static final int CN_ACK_SYSTEM_COUNTERS_PACKETS_ACKED = 2;
    private static final int CN_ACK_SYSTEM_COUNTERS_PACKETS_STALE = 3;
    private static final int CN_ACK_SYSTEM_COUNTERS_PACKETS_INVALID = 4;
    private static final int CN_ACK_SYSTEM_COUNTERS_PACKETS_TOO_LARGE_TO_SEND = 5;
    private static final int CN_ACK_SYSTEM_COUNTERS_PACKETS_TOO_LARGE_TO_RECEIVE = 6;
    private static final int CN_ACK_SYSTEM_COUNTERS_MAX = 7;
    private static final int CN_ERROR_SUCCESS = 0;
    private static final int CN_ERROR_FAILURE = -1;
    private static final int CN_CRYPTO_HEADER_BYTES = 36;
    private static final int CN_MB = 0x100000;
    private static final int hydro_secretbox_HEADERBYTES = 36;
    private static final int hydro_kx_N_PACKET1BYTES = 48;
    private static final int hydro_kx_KK_PACKET1BYTES = 48;
    private static final int hydro_kx_KK_PACKET2BYTES = 48;
    private static final int hydro_kx_XX_PACKET1BYTES = 48;
    private static final int hydro_kx_XX_PACKET2BYTES = 96;
    private static final int hydro_kx_XX_PACKET3BYTES = 64;
    private static final int hydro_kx_NK_PACKET1BYTES = 48;
    private static final int hydro_kx_NK_PACKET2BYTES = 48;
    private static final int hydro_x25519_NLIMBS = 4;
    private static final int hydro_kx_AEAD_KEYBYTES = 32;
    private static final int hydro_pwhash_PARAMSBYTES = 66;
    private static final int CN_PROTOCOL_VERSION_STRING_LEN = 10;
    private static final int CN_PROTOCOL_PACKET_SIZE_MAX = 1280;
    private static final int CN_PROTOCOL_PACKET_PAYLOAD_MAX = 1205;
    private static final int CN_PROTOCOL_CLIENT_SEND_BUFFER_SIZE = 262144;
    private static final int CN_PROTOCOL_CLIENT_RECEIVE_BUFFER_SIZE = 262144;
    private static final int CN_PROTOCOL_SERVER_SEND_BUFFER_SIZE = 0x200000;
    private static final int CN_PROTOCOL_SERVER_RECEIVE_BUFFER_SIZE = 0x200000;
    private static final int CN_PROTOCOL_EVENT_QUEUE_SIZE = 0x400000;
    private static final int CN_PROTOCOL_CONNECT_TOKEN_SECRET_SECTION_SIZE = 392;
    private static final float CN_PROTOCOL_SEND_RATE = 0.1f;
    private static final int CN_HASHTABLE_KEY_BYTES = 32;
    private static final int CN_HASHTABLE_HASH_BYTES = 32;
    private static final int CN_PROTOCOL_CONNECT_TOKEN_ENTRIES_MAX = 256;
    private static final int CN_PROTOCOL_ENCRYPTION_STATES_MAX = 64;
    private static final int CN_ENDPOINT_STRING_MAX_LENGTH = 46;
    private static final int CN_PROTOCOL_NET_SIMULATOR_MAX_PACKETS = 5120;
    private static final long CN_INVALID_HANDLE = -1L;
    private static final int CN_ACK_SYSTEM_HEADER_SIZE = 8;
    private static final int CN_TRANSPORT_HEADER_SIZE = 9;
    private static final int CN_TRANSPORT_SEND_QUEUE_MAX_ENTRIES = 1024;
    private static final int CN_TRANSPORT_PACKET_PAYLOAD_MAX = 1200;
    private static final int CN_SEQUENCE_BUFFER_EMPTY = -1;
    private static final int CN_PACKET_QUEUE_MAX_ENTRIES = 1024;

    netcode() {
    }

    static void traceDowncall(String string, Object ... objectArray) {
        String string2 = Arrays.stream(objectArray).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", string, string2);
    }

    static MemorySegment findOrThrow(String string) {
        return SYMBOL_LOOKUP.find(string).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + string));
    }

    static MethodHandle upcallHandle(Class<?> clazz, String string, FunctionDescriptor functionDescriptor) {
        try {
            return MethodHandles.lookup().findVirtual(clazz, string, functionDescriptor.toMethodType());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    static MemoryLayout align(MemoryLayout memoryLayout2, long l) {
        MemoryLayout memoryLayout3 = memoryLayout2;
        Objects.requireNonNull(memoryLayout3);
        MemoryLayout memoryLayout4 = memoryLayout3;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout4, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout var5_4;
                yield var5_4 = (PaddingLayout)memoryLayout4;
            }
            case 1 -> {
                ValueLayout var6_5 = (ValueLayout)memoryLayout4;
                yield var6_5.withByteAlignment(l);
            }
            case 2 -> {
                GroupLayout var7_6 = (GroupLayout)memoryLayout4;
                MemoryLayout[] var8_7 = (MemoryLayout[])var7_6.memberLayouts().stream().map(memoryLayout -> netcode.align(memoryLayout, l)).toArray(MemoryLayout[]::new);
                if (var7_6 instanceof StructLayout) {
                    yield MemoryLayout.structLayout(var8_7);
                }
                yield MemoryLayout.unionLayout(var8_7);
            }
            case 3 -> {
                SequenceLayout var8_8 = (SequenceLayout)memoryLayout4;
                yield MemoryLayout.sequenceLayout(var8_8.elementCount(), netcode.align(var8_8.elementLayout(), l));
            }
        };
    }

    public static int CN_CONNECT_TOKEN_SIZE() {
        return 1114;
    }

    public static int CN_CONNECT_TOKEN_USER_DATA_SIZE() {
        return 256;
    }

    public static int CN_SERVER_MAX_CLIENTS() {
        return 32;
    }

    public static int CN_KB() {
        return 1024;
    }

    public static int CN_MACOSX() {
        return 1;
    }

    public static int HYDRO_VERSION_MAJOR() {
        return 1;
    }

    public static int HYDRO_VERSION_MINOR() {
        return 0;
    }

    public static int hydro_random_SEEDBYTES() {
        return 32;
    }

    public static int hydro_hash_BYTES() {
        return 32;
    }

    public static int hydro_hash_BYTES_MAX() {
        return 65535;
    }

    public static int hydro_hash_BYTES_MIN() {
        return 16;
    }

    public static int hydro_hash_CONTEXTBYTES() {
        return 8;
    }

    public static int hydro_hash_KEYBYTES() {
        return 32;
    }

    public static int hydro_secretbox_CONTEXTBYTES() {
        return 8;
    }

    public static int hydro_secretbox_KEYBYTES() {
        return 32;
    }

    public static int hydro_secretbox_PROBEBYTES() {
        return 16;
    }

    public static int hydro_kdf_CONTEXTBYTES() {
        return 8;
    }

    public static int hydro_kdf_KEYBYTES() {
        return 32;
    }

    public static int hydro_kdf_BYTES_MAX() {
        return 65535;
    }

    public static int hydro_kdf_BYTES_MIN() {
        return 16;
    }

    public static int hydro_sign_BYTES() {
        return 64;
    }

    public static int hydro_sign_CONTEXTBYTES() {
        return 8;
    }

    public static int hydro_sign_PUBLICKEYBYTES() {
        return 32;
    }

    public static int hydro_sign_SECRETKEYBYTES() {
        return 64;
    }

    public static int hydro_sign_SEEDBYTES() {
        return 32;
    }

    public static int hydro_kx_SESSIONKEYBYTES() {
        return 32;
    }

    public static int hydro_kx_PUBLICKEYBYTES() {
        return 32;
    }

    public static int hydro_kx_SECRETKEYBYTES() {
        return 32;
    }

    public static int hydro_kx_PSKBYTES() {
        return 32;
    }

    public static int hydro_kx_SEEDBYTES() {
        return 32;
    }

    public static int hydro_pwhash_CONTEXTBYTES() {
        return 8;
    }

    public static int hydro_pwhash_MASTERKEYBYTES() {
        return 32;
    }

    public static int hydro_pwhash_STOREDBYTES() {
        return 128;
    }

    public static int HYDRO_HWTYPE_ATMEGA328() {
        return 1;
    }

    public static int __unix__() {
        return 1;
    }

    public static int gimli_BLOCKBYTES() {
        return 48;
    }

    public static int gimli_CAPACITY() {
        return 32;
    }

    public static int gimli_RATE() {
        return 16;
    }

    public static int gimli_TAG_HEADER() {
        return 1;
    }

    public static int gimli_TAG_PAYLOAD() {
        return 2;
    }

    public static int gimli_TAG_FINAL() {
        return 8;
    }

    public static int gimli_TAG_FINAL0() {
        return 248;
    }

    public static int gimli_TAG_KEY0() {
        return 254;
    }

    public static int gimli_TAG_KEY() {
        return 255;
    }

    public static int gimli_DOMAIN_AEAD() {
        return 0;
    }

    public static int gimli_DOMAIN_XOF() {
        return 15;
    }

    public static int hydro_secretbox_NONCEBYTES() {
        return 20;
    }

    public static int hydro_secretbox_MACBYTES() {
        return 16;
    }

    public static int hydro_x25519_BYTES() {
        return 32;
    }

    public static int hydro_x25519_PUBLICKEYBYTES() {
        return 32;
    }

    public static int hydro_x25519_SECRETKEYBYTES() {
        return 32;
    }

    public static int hydro_secretbox_IVBYTES() {
        return 20;
    }

    public static int hydro_secretbox_SIVBYTES() {
        return 20;
    }

    public static int hydro_x25519_WBITS() {
        return 64;
    }

    public static int hydro_kx_AEAD_MACBYTES() {
        return 16;
    }

    public static int hydro_pwhash_ENC_ALGBYTES() {
        return 1;
    }

    public static int hydro_pwhash_HASH_ALGBYTES() {
        return 1;
    }

    public static int hydro_pwhash_THREADSBYTES() {
        return 1;
    }

    public static int hydro_pwhash_OPSLIMITBYTES() {
        return 8;
    }

    public static int hydro_pwhash_MEMLIMITBYTES() {
        return 8;
    }

    public static int hydro_pwhash_HASHBYTES() {
        return 32;
    }

    public static int hydro_pwhash_SALTBYTES() {
        return 16;
    }

    public static int hydro_pwhash_ENC_ALG() {
        return 1;
    }

    public static int hydro_pwhash_HASH_ALG() {
        return 1;
    }

    public static int hydro_sign_CHALLENGEBYTES() {
        return 32;
    }

    public static int hydro_sign_NONCEBYTES() {
        return 32;
    }

    public static int hydro_sign_PREHASHBYTES() {
        return 64;
    }

    public static int CN_PROTOCOL_SERVER_MAX_CLIENTS() {
        return 32;
    }

    public static int CN_PROTOCOL_SIGNATURE_SIZE() {
        return 64;
    }

    public static int CN_PROTOCOL_CONNECT_TOKEN_PACKET_SIZE() {
        return 1024;
    }

    public static int CN_PROTOCOL_CONNECT_TOKEN_SIZE() {
        return 1114;
    }

    public static int CN_PROTOCOL_CONNECT_TOKEN_USER_DATA_SIZE() {
        return 256;
    }

    public static int CN_PROTOCOL_CONNECT_TOKEN_ENDPOINT_MAX() {
        return 32;
    }

    public static int CN_PROTOCOL_REPLAY_BUFFER_SIZE() {
        return 256;
    }

    public static int CN_PROTOCOL_DISCONNECT_REDUNDANT_PACKET_COUNT() {
        return 10;
    }

    public static int CN_PROTOCOL_CHALLENGE_DATA_SIZE() {
        return 256;
    }

    public static int CN_PROTOCOL_REDUNDANT_DISCONNECT_PACKET_COUNT() {
        return 10;
    }

    public static int CN_ACK_SYSTEM_MAX_PACKET_SIZE() {
        return 1180;
    }

    public static int CN_TRANSPORT_MAX_FRAGMENT_SIZE() {
        return 1100;
    }

    public static int CN_ADDRESS_TYPE_NONE() {
        return 0;
    }

    public static int CN_ADDRESS_TYPE_IPV4() {
        return 1;
    }

    public static int CN_ADDRESS_TYPE_IPV6() {
        return 2;
    }

    public static FunctionDescriptor cn_endpoint_init$descriptor() {
        return cn_endpoint_init.DESC;
    }

    public static MethodHandle cn_endpoint_init$handle() {
        return cn_endpoint_init.HANDLE;
    }

    public static MemorySegment cn_endpoint_init$address() {
        return cn_endpoint_init.ADDR;
    }

    public static int cn_endpoint_init(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_endpoint_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_endpoint_init", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_endpoint_to_string$descriptor() {
        return cn_endpoint_to_string.DESC;
    }

    public static MethodHandle cn_endpoint_to_string$handle() {
        return cn_endpoint_to_string.HANDLE;
    }

    public static MemorySegment cn_endpoint_to_string$address() {
        return cn_endpoint_to_string.ADDR;
    }

    public static void cn_endpoint_to_string(MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_endpoint_to_string.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_endpoint_to_string", memorySegment, memorySegment2, n);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_endpoint_equals$descriptor() {
        return cn_endpoint_equals.DESC;
    }

    public static MethodHandle cn_endpoint_equals$handle() {
        return cn_endpoint_equals.HANDLE;
    }

    public static MemorySegment cn_endpoint_equals$address() {
        return cn_endpoint_equals.ADDR;
    }

    public static int cn_endpoint_equals(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_endpoint_equals.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_endpoint_equals", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_crypto_random_bytes$descriptor() {
        return cn_crypto_random_bytes.DESC;
    }

    public static MethodHandle cn_crypto_random_bytes$handle() {
        return cn_crypto_random_bytes.HANDLE;
    }

    public static MemorySegment cn_crypto_random_bytes$address() {
        return cn_crypto_random_bytes.ADDR;
    }

    public static void cn_crypto_random_bytes(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_crypto_random_bytes.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_crypto_random_bytes", memorySegment, n);
            }
            methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_crypto_sign_keygen$descriptor() {
        return cn_crypto_sign_keygen.DESC;
    }

    public static MethodHandle cn_crypto_sign_keygen$handle() {
        return cn_crypto_sign_keygen.HANDLE;
    }

    public static MemorySegment cn_crypto_sign_keygen$address() {
        return cn_crypto_sign_keygen.ADDR;
    }

    public static void cn_crypto_sign_keygen(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_crypto_sign_keygen.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_crypto_sign_keygen", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_generate_connect_token$descriptor() {
        return cn_generate_connect_token.DESC;
    }

    public static MethodHandle cn_generate_connect_token$handle() {
        return cn_generate_connect_token.HANDLE;
    }

    public static MemorySegment cn_generate_connect_token$address() {
        return cn_generate_connect_token.ADDR;
    }

    public static MemorySegment cn_generate_connect_token(SegmentAllocator segmentAllocator, long l, long l2, MemorySegment memorySegment, MemorySegment memorySegment2, long l3, int n, int n2, MemorySegment memorySegment3, long l4, MemorySegment memorySegment4, MemorySegment memorySegment5, MemorySegment memorySegment6) {
        MethodHandle methodHandle = cn_generate_connect_token.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_generate_connect_token", segmentAllocator, l, l2, memorySegment, memorySegment2, l3, n, n2, memorySegment3, l4, memorySegment4, memorySegment5, memorySegment6);
            }
            return methodHandle.invokeExact(segmentAllocator, l, l2, memorySegment, memorySegment2, l3, n, n2, memorySegment3, l4, memorySegment4, memorySegment5, memorySegment6);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_create$descriptor() {
        return cn_client_create.DESC;
    }

    public static MethodHandle cn_client_create$handle() {
        return cn_client_create.HANDLE;
    }

    public static MemorySegment cn_client_create$address() {
        return cn_client_create.ADDR;
    }

    public static MemorySegment cn_client_create(short s, long l, boolean bl, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_create", s, l, bl, memorySegment);
            }
            return methodHandle.invokeExact(s, l, bl, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_destroy$descriptor() {
        return cn_client_destroy.DESC;
    }

    public static MethodHandle cn_client_destroy$handle() {
        return cn_client_destroy.HANDLE;
    }

    public static MemorySegment cn_client_destroy$address() {
        return cn_client_destroy.ADDR;
    }

    public static void cn_client_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_connect$descriptor() {
        return cn_client_connect.DESC;
    }

    public static MethodHandle cn_client_connect$handle() {
        return cn_client_connect.HANDLE;
    }

    public static MemorySegment cn_client_connect$address() {
        return cn_client_connect.ADDR;
    }

    public static MemorySegment cn_client_connect(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_client_connect.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_connect", segmentAllocator, memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_disconnect$descriptor() {
        return cn_client_disconnect.DESC;
    }

    public static MethodHandle cn_client_disconnect$handle() {
        return cn_client_disconnect.HANDLE;
    }

    public static MemorySegment cn_client_disconnect$address() {
        return cn_client_disconnect.ADDR;
    }

    public static void cn_client_disconnect(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_disconnect.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_disconnect", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_update$descriptor() {
        return cn_client_update.DESC;
    }

    public static MethodHandle cn_client_update$handle() {
        return cn_client_update.HANDLE;
    }

    public static MemorySegment cn_client_update$address() {
        return cn_client_update.ADDR;
    }

    public static void cn_client_update(MemorySegment memorySegment, double d, long l) {
        MethodHandle methodHandle = cn_client_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_update", memorySegment, d, l);
            }
            methodHandle.invokeExact(memorySegment, d, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_pop_packet$descriptor() {
        return cn_client_pop_packet.DESC;
    }

    public static MethodHandle cn_client_pop_packet$handle() {
        return cn_client_pop_packet.HANDLE;
    }

    public static MemorySegment cn_client_pop_packet$address() {
        return cn_client_pop_packet.ADDR;
    }

    public static boolean cn_client_pop_packet(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = cn_client_pop_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_pop_packet", memorySegment, memorySegment2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_free_packet$descriptor() {
        return cn_client_free_packet.DESC;
    }

    public static MethodHandle cn_client_free_packet$handle() {
        return cn_client_free_packet.HANDLE;
    }

    public static MemorySegment cn_client_free_packet$address() {
        return cn_client_free_packet.ADDR;
    }

    public static void cn_client_free_packet(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_client_free_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_free_packet", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_send$descriptor() {
        return cn_client_send.DESC;
    }

    public static MethodHandle cn_client_send$handle() {
        return cn_client_send.HANDLE;
    }

    public static MemorySegment cn_client_send$address() {
        return cn_client_send.ADDR;
    }

    public static MemorySegment cn_client_send(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n, boolean bl) {
        MethodHandle methodHandle = cn_client_send.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_send", segmentAllocator, memorySegment, memorySegment2, n, bl);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n, bl);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static int CN_CLIENT_STATE_CONNECT_TOKEN_EXPIRED() {
        return -6;
    }

    public static int CN_CLIENT_STATE_INVALID_CONNECT_TOKEN() {
        return -5;
    }

    public static int CN_CLIENT_STATE_CONNECTION_TIMED_OUT() {
        return -4;
    }

    public static int CN_CLIENT_STATE_CHALLENGE_RESPONSE_TIMED_OUT() {
        return -3;
    }

    public static int CN_CLIENT_STATE_CONNECTION_REQUEST_TIMED_OUT() {
        return -2;
    }

    public static int CN_CLIENT_STATE_CONNECTION_DENIED() {
        return -1;
    }

    public static int CN_CLIENT_STATE_DISCONNECTED() {
        return 0;
    }

    public static int CN_CLIENT_STATE_SENDING_CONNECTION_REQUEST() {
        return 1;
    }

    public static int CN_CLIENT_STATE_SENDING_CHALLENGE_RESPONSE() {
        return 2;
    }

    public static int CN_CLIENT_STATE_CONNECTED() {
        return 3;
    }

    public static FunctionDescriptor cn_client_state_get$descriptor() {
        return cn_client_state_get.DESC;
    }

    public static MethodHandle cn_client_state_get$handle() {
        return cn_client_state_get.HANDLE;
    }

    public static MemorySegment cn_client_state_get$address() {
        return cn_client_state_get.ADDR;
    }

    public static int cn_client_state_get(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_state_get.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_state_get", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_state_string$descriptor() {
        return cn_client_state_string.DESC;
    }

    public static MethodHandle cn_client_state_string$handle() {
        return cn_client_state_string.HANDLE;
    }

    public static MemorySegment cn_client_state_string$address() {
        return cn_client_state_string.ADDR;
    }

    public static MemorySegment cn_client_state_string(int n) {
        MethodHandle methodHandle = cn_client_state_string.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_state_string", n);
            }
            return methodHandle.invokeExact(n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_enable_network_simulator$descriptor() {
        return cn_client_enable_network_simulator.DESC;
    }

    public static MethodHandle cn_client_enable_network_simulator$handle() {
        return cn_client_enable_network_simulator.HANDLE;
    }

    public static MemorySegment cn_client_enable_network_simulator$address() {
        return cn_client_enable_network_simulator.ADDR;
    }

    public static void cn_client_enable_network_simulator(MemorySegment memorySegment, double d, double d2, double d3, double d4) {
        MethodHandle methodHandle = cn_client_enable_network_simulator.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_enable_network_simulator", memorySegment, d, d2, d3, d4);
            }
            methodHandle.invokeExact(memorySegment, d, d2, d3, d4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_get_packet_loss_estimate$descriptor() {
        return cn_client_get_packet_loss_estimate.DESC;
    }

    public static MethodHandle cn_client_get_packet_loss_estimate$handle() {
        return cn_client_get_packet_loss_estimate.HANDLE;
    }

    public static MemorySegment cn_client_get_packet_loss_estimate$address() {
        return cn_client_get_packet_loss_estimate.ADDR;
    }

    public static float cn_client_get_packet_loss_estimate(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_get_packet_loss_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_get_packet_loss_estimate", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_get_rtt_estimate$descriptor() {
        return cn_client_get_rtt_estimate.DESC;
    }

    public static MethodHandle cn_client_get_rtt_estimate$handle() {
        return cn_client_get_rtt_estimate.HANDLE;
    }

    public static MemorySegment cn_client_get_rtt_estimate$address() {
        return cn_client_get_rtt_estimate.ADDR;
    }

    public static float cn_client_get_rtt_estimate(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_get_rtt_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_get_rtt_estimate", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_get_incoming_kbps_estimate$descriptor() {
        return cn_client_get_incoming_kbps_estimate.DESC;
    }

    public static MethodHandle cn_client_get_incoming_kbps_estimate$handle() {
        return cn_client_get_incoming_kbps_estimate.HANDLE;
    }

    public static MemorySegment cn_client_get_incoming_kbps_estimate$address() {
        return cn_client_get_incoming_kbps_estimate.ADDR;
    }

    public static float cn_client_get_incoming_kbps_estimate(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_get_incoming_kbps_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_get_incoming_kbps_estimate", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_client_get_outgoing_kbps_estimate$descriptor() {
        return cn_client_get_outgoing_kbps_estimate.DESC;
    }

    public static MethodHandle cn_client_get_outgoing_kbps_estimate$handle() {
        return cn_client_get_outgoing_kbps_estimate.HANDLE;
    }

    public static MemorySegment cn_client_get_outgoing_kbps_estimate$address() {
        return cn_client_get_outgoing_kbps_estimate.ADDR;
    }

    public static float cn_client_get_outgoing_kbps_estimate(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_client_get_outgoing_kbps_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_client_get_outgoing_kbps_estimate", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_config_defaults$descriptor() {
        return cn_server_config_defaults.DESC;
    }

    public static MethodHandle cn_server_config_defaults$handle() {
        return cn_server_config_defaults.HANDLE;
    }

    public static MemorySegment cn_server_config_defaults$address() {
        return cn_server_config_defaults.ADDR;
    }

    public static MemorySegment cn_server_config_defaults(SegmentAllocator segmentAllocator) {
        MethodHandle methodHandle = cn_server_config_defaults.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_config_defaults", segmentAllocator);
            }
            return methodHandle.invokeExact(segmentAllocator);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_create$descriptor() {
        return cn_server_create.DESC;
    }

    public static MethodHandle cn_server_create$handle() {
        return cn_server_create.HANDLE;
    }

    public static MemorySegment cn_server_create$address() {
        return cn_server_create.ADDR;
    }

    public static MemorySegment cn_server_create(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_server_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_create", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_destroy$descriptor() {
        return cn_server_destroy.DESC;
    }

    public static MethodHandle cn_server_destroy$handle() {
        return cn_server_destroy.HANDLE;
    }

    public static MemorySegment cn_server_destroy$address() {
        return cn_server_destroy.ADDR;
    }

    public static void cn_server_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_server_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_start$descriptor() {
        return cn_server_start.DESC;
    }

    public static MethodHandle cn_server_start$handle() {
        return cn_server_start.HANDLE;
    }

    public static MemorySegment cn_server_start$address() {
        return cn_server_start.ADDR;
    }

    public static MemorySegment cn_server_start(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_server_start.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_start", segmentAllocator, memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_stop$descriptor() {
        return cn_server_stop.DESC;
    }

    public static MethodHandle cn_server_stop$handle() {
        return cn_server_stop.HANDLE;
    }

    public static MemorySegment cn_server_stop$address() {
        return cn_server_stop.ADDR;
    }

    public static void cn_server_stop(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_server_stop.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_stop", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static int CN_SERVER_EVENT_TYPE_NEW_CONNECTION() {
        return 0;
    }

    public static int CN_SERVER_EVENT_TYPE_DISCONNECTED() {
        return 1;
    }

    public static int CN_SERVER_EVENT_TYPE_PAYLOAD_PACKET() {
        return 2;
    }

    public static FunctionDescriptor cn_server_pop_event$descriptor() {
        return cn_server_pop_event.DESC;
    }

    public static MethodHandle cn_server_pop_event$handle() {
        return cn_server_pop_event.HANDLE;
    }

    public static MemorySegment cn_server_pop_event$address() {
        return cn_server_pop_event.ADDR;
    }

    public static boolean cn_server_pop_event(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_server_pop_event.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_pop_event", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_free_packet$descriptor() {
        return cn_server_free_packet.DESC;
    }

    public static MethodHandle cn_server_free_packet$handle() {
        return cn_server_free_packet.HANDLE;
    }

    public static MemorySegment cn_server_free_packet$address() {
        return cn_server_free_packet.ADDR;
    }

    public static void cn_server_free_packet(MemorySegment memorySegment, int n, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_server_free_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_free_packet", memorySegment, n, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, n, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_update$descriptor() {
        return cn_server_update.DESC;
    }

    public static MethodHandle cn_server_update$handle() {
        return cn_server_update.HANDLE;
    }

    public static MemorySegment cn_server_update$address() {
        return cn_server_update.ADDR;
    }

    public static void cn_server_update(MemorySegment memorySegment, double d, long l) {
        MethodHandle methodHandle = cn_server_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_update", memorySegment, d, l);
            }
            methodHandle.invokeExact(memorySegment, d, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_disconnect_client$descriptor() {
        return cn_server_disconnect_client.DESC;
    }

    public static MethodHandle cn_server_disconnect_client$handle() {
        return cn_server_disconnect_client.HANDLE;
    }

    public static MemorySegment cn_server_disconnect_client$address() {
        return cn_server_disconnect_client.ADDR;
    }

    public static void cn_server_disconnect_client(MemorySegment memorySegment, int n, boolean bl) {
        MethodHandle methodHandle = cn_server_disconnect_client.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_disconnect_client", memorySegment, n, bl);
            }
            methodHandle.invokeExact(memorySegment, n, bl);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_send$descriptor() {
        return cn_server_send.DESC;
    }

    public static MethodHandle cn_server_send$handle() {
        return cn_server_send.HANDLE;
    }

    public static MemorySegment cn_server_send$address() {
        return cn_server_send.ADDR;
    }

    public static MemorySegment cn_server_send(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n, int n2, boolean bl) {
        MethodHandle methodHandle = cn_server_send.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_send", segmentAllocator, memorySegment, memorySegment2, n, n2, bl);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n, n2, bl);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_is_client_connected$descriptor() {
        return cn_server_is_client_connected.DESC;
    }

    public static MethodHandle cn_server_is_client_connected$handle() {
        return cn_server_is_client_connected.HANDLE;
    }

    public static MemorySegment cn_server_is_client_connected$address() {
        return cn_server_is_client_connected.ADDR;
    }

    public static boolean cn_server_is_client_connected(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_server_is_client_connected.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_is_client_connected", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_set_public_ip$descriptor() {
        return cn_server_set_public_ip.DESC;
    }

    public static MethodHandle cn_server_set_public_ip$handle() {
        return cn_server_set_public_ip.HANDLE;
    }

    public static MemorySegment cn_server_set_public_ip$address() {
        return cn_server_set_public_ip.ADDR;
    }

    public static void cn_server_set_public_ip(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_server_set_public_ip.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_set_public_ip", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_enable_network_simulator$descriptor() {
        return cn_server_enable_network_simulator.DESC;
    }

    public static MethodHandle cn_server_enable_network_simulator$handle() {
        return cn_server_enable_network_simulator.HANDLE;
    }

    public static MemorySegment cn_server_enable_network_simulator$address() {
        return cn_server_enable_network_simulator.ADDR;
    }

    public static void cn_server_enable_network_simulator(MemorySegment memorySegment, double d, double d2, double d3, double d4) {
        MethodHandle methodHandle = cn_server_enable_network_simulator.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_enable_network_simulator", memorySegment, d, d2, d3, d4);
            }
            methodHandle.invokeExact(memorySegment, d, d2, d3, d4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_get_packet_loss_estimate$descriptor() {
        return cn_server_get_packet_loss_estimate.DESC;
    }

    public static MethodHandle cn_server_get_packet_loss_estimate$handle() {
        return cn_server_get_packet_loss_estimate.HANDLE;
    }

    public static MemorySegment cn_server_get_packet_loss_estimate$address() {
        return cn_server_get_packet_loss_estimate.ADDR;
    }

    public static float cn_server_get_packet_loss_estimate(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_server_get_packet_loss_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_get_packet_loss_estimate", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_get_rtt_estimate$descriptor() {
        return cn_server_get_rtt_estimate.DESC;
    }

    public static MethodHandle cn_server_get_rtt_estimate$handle() {
        return cn_server_get_rtt_estimate.HANDLE;
    }

    public static MemorySegment cn_server_get_rtt_estimate$address() {
        return cn_server_get_rtt_estimate.ADDR;
    }

    public static float cn_server_get_rtt_estimate(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_server_get_rtt_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_get_rtt_estimate", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_get_incoming_kbps_estimate$descriptor() {
        return cn_server_get_incoming_kbps_estimate.DESC;
    }

    public static MethodHandle cn_server_get_incoming_kbps_estimate$handle() {
        return cn_server_get_incoming_kbps_estimate.HANDLE;
    }

    public static MemorySegment cn_server_get_incoming_kbps_estimate$address() {
        return cn_server_get_incoming_kbps_estimate.ADDR;
    }

    public static float cn_server_get_incoming_kbps_estimate(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_server_get_incoming_kbps_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_get_incoming_kbps_estimate", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_server_get_outgoing_kbps_estimate$descriptor() {
        return cn_server_get_outgoing_kbps_estimate.DESC;
    }

    public static MethodHandle cn_server_get_outgoing_kbps_estimate$handle() {
        return cn_server_get_outgoing_kbps_estimate.HANDLE;
    }

    public static MemorySegment cn_server_get_outgoing_kbps_estimate$address() {
        return cn_server_get_outgoing_kbps_estimate.ADDR;
    }

    public static float cn_server_get_outgoing_kbps_estimate(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_server_get_outgoing_kbps_estimate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_server_get_outgoing_kbps_estimate", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_is_error$descriptor() {
        return cn_is_error.DESC;
    }

    public static MethodHandle cn_is_error$handle() {
        return cn_is_error.HANDLE;
    }

    public static MemorySegment cn_is_error$address() {
        return cn_is_error.ADDR;
    }

    public static boolean cn_is_error(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_is_error.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_is_error", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_error_failure$descriptor() {
        return cn_error_failure.DESC;
    }

    public static MethodHandle cn_error_failure$handle() {
        return cn_error_failure.HANDLE;
    }

    public static MemorySegment cn_error_failure$address() {
        return cn_error_failure.ADDR;
    }

    public static MemorySegment cn_error_failure(SegmentAllocator segmentAllocator, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_error_failure.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_error_failure", segmentAllocator, memorySegment);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_error_success$descriptor() {
        return cn_error_success.DESC;
    }

    public static MethodHandle cn_error_success$handle() {
        return cn_error_success.HANDLE;
    }

    public static MemorySegment cn_error_success$address() {
        return cn_error_success.ADDR;
    }

    public static MemorySegment cn_error_success(SegmentAllocator segmentAllocator) {
        MethodHandle methodHandle = cn_error_success.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_error_success", segmentAllocator);
            }
            return methodHandle.invokeExact(segmentAllocator);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_init$descriptor() {
        return hydro_init.DESC;
    }

    public static MethodHandle hydro_init$handle() {
        return hydro_init.HANDLE;
    }

    public static MemorySegment hydro_init$address() {
        return hydro_init.ADDR;
    }

    public static int hydro_init() {
        MethodHandle methodHandle = hydro_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_init", new Object[0]);
            }
            return methodHandle.invokeExact();
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_random_u32$descriptor() {
        return hydro_random_u32.DESC;
    }

    public static MethodHandle hydro_random_u32$handle() {
        return hydro_random_u32.HANDLE;
    }

    public static MemorySegment hydro_random_u32$address() {
        return hydro_random_u32.ADDR;
    }

    public static int hydro_random_u32() {
        MethodHandle methodHandle = hydro_random_u32.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_random_u32", new Object[0]);
            }
            return methodHandle.invokeExact();
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_random_uniform$descriptor() {
        return hydro_random_uniform.DESC;
    }

    public static MethodHandle hydro_random_uniform$handle() {
        return hydro_random_uniform.HANDLE;
    }

    public static MemorySegment hydro_random_uniform$address() {
        return hydro_random_uniform.ADDR;
    }

    public static int hydro_random_uniform(int n) {
        MethodHandle methodHandle = hydro_random_uniform.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_random_uniform", n);
            }
            return methodHandle.invokeExact(n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_random_buf$descriptor() {
        return hydro_random_buf.DESC;
    }

    public static MethodHandle hydro_random_buf$handle() {
        return hydro_random_buf.HANDLE;
    }

    public static MemorySegment hydro_random_buf$address() {
        return hydro_random_buf.ADDR;
    }

    public static void hydro_random_buf(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = hydro_random_buf.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_random_buf", memorySegment, l);
            }
            methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_random_buf_deterministic$descriptor() {
        return hydro_random_buf_deterministic.DESC;
    }

    public static MethodHandle hydro_random_buf_deterministic$handle() {
        return hydro_random_buf_deterministic.HANDLE;
    }

    public static MemorySegment hydro_random_buf_deterministic$address() {
        return hydro_random_buf_deterministic.ADDR;
    }

    public static void hydro_random_buf_deterministic(MemorySegment memorySegment, long l, MemorySegment memorySegment2) {
        MethodHandle methodHandle = hydro_random_buf_deterministic.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_random_buf_deterministic", memorySegment, l, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, l, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_random_ratchet$descriptor() {
        return hydro_random_ratchet.DESC;
    }

    public static MethodHandle hydro_random_ratchet$handle() {
        return hydro_random_ratchet.HANDLE;
    }

    public static MemorySegment hydro_random_ratchet$address() {
        return hydro_random_ratchet.ADDR;
    }

    public static void hydro_random_ratchet() {
        MethodHandle methodHandle = hydro_random_ratchet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_random_ratchet", new Object[0]);
            }
            methodHandle.invokeExact();
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_random_reseed$descriptor() {
        return hydro_random_reseed.DESC;
    }

    public static MethodHandle hydro_random_reseed$handle() {
        return hydro_random_reseed.HANDLE;
    }

    public static MemorySegment hydro_random_reseed$address() {
        return hydro_random_reseed.ADDR;
    }

    public static void hydro_random_reseed() {
        MethodHandle methodHandle = hydro_random_reseed.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_random_reseed", new Object[0]);
            }
            methodHandle.invokeExact();
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_hash_keygen$descriptor() {
        return hydro_hash_keygen.DESC;
    }

    public static MethodHandle hydro_hash_keygen$handle() {
        return hydro_hash_keygen.HANDLE;
    }

    public static MemorySegment hydro_hash_keygen$address() {
        return hydro_hash_keygen.ADDR;
    }

    public static void hydro_hash_keygen(MemorySegment memorySegment) {
        MethodHandle methodHandle = hydro_hash_keygen.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_hash_keygen", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_hash_init$descriptor() {
        return hydro_hash_init.DESC;
    }

    public static MethodHandle hydro_hash_init$handle() {
        return hydro_hash_init.HANDLE;
    }

    public static MemorySegment hydro_hash_init$address() {
        return hydro_hash_init.ADDR;
    }

    public static int hydro_hash_init(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = hydro_hash_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_hash_init", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_hash_update$descriptor() {
        return hydro_hash_update.DESC;
    }

    public static MethodHandle hydro_hash_update$handle() {
        return hydro_hash_update.HANDLE;
    }

    public static MemorySegment hydro_hash_update$address() {
        return hydro_hash_update.ADDR;
    }

    public static int hydro_hash_update(MemorySegment memorySegment, MemorySegment memorySegment2, long l) {
        MethodHandle methodHandle = hydro_hash_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_hash_update", memorySegment, memorySegment2, l);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_hash_final$descriptor() {
        return hydro_hash_final.DESC;
    }

    public static MethodHandle hydro_hash_final$handle() {
        return hydro_hash_final.HANDLE;
    }

    public static MemorySegment hydro_hash_final$address() {
        return hydro_hash_final.ADDR;
    }

    public static int hydro_hash_final(MemorySegment memorySegment, MemorySegment memorySegment2, long l) {
        MethodHandle methodHandle = hydro_hash_final.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_hash_final", memorySegment, memorySegment2, l);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_hash_hash$descriptor() {
        return hydro_hash_hash.DESC;
    }

    public static MethodHandle hydro_hash_hash$handle() {
        return hydro_hash_hash.HANDLE;
    }

    public static MemorySegment hydro_hash_hash$address() {
        return hydro_hash_hash.ADDR;
    }

    public static int hydro_hash_hash(MemorySegment memorySegment, long l, MemorySegment memorySegment2, long l2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_hash_hash.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_hash_hash", memorySegment, l, memorySegment2, l2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, l, memorySegment2, l2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_secretbox_keygen$descriptor() {
        return hydro_secretbox_keygen.DESC;
    }

    public static MethodHandle hydro_secretbox_keygen$handle() {
        return hydro_secretbox_keygen.HANDLE;
    }

    public static MemorySegment hydro_secretbox_keygen$address() {
        return hydro_secretbox_keygen.ADDR;
    }

    public static void hydro_secretbox_keygen(MemorySegment memorySegment) {
        MethodHandle methodHandle = hydro_secretbox_keygen.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_secretbox_keygen", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_secretbox_encrypt$descriptor() {
        return hydro_secretbox_encrypt.DESC;
    }

    public static MethodHandle hydro_secretbox_encrypt$handle() {
        return hydro_secretbox_encrypt.HANDLE;
    }

    public static MemorySegment hydro_secretbox_encrypt$address() {
        return hydro_secretbox_encrypt.ADDR;
    }

    public static int hydro_secretbox_encrypt(MemorySegment memorySegment, MemorySegment memorySegment2, long l, long l2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_secretbox_encrypt.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_secretbox_encrypt", memorySegment, memorySegment2, l, l2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, l2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_secretbox_decrypt$descriptor() {
        return hydro_secretbox_decrypt.DESC;
    }

    public static MethodHandle hydro_secretbox_decrypt$handle() {
        return hydro_secretbox_decrypt.HANDLE;
    }

    public static MemorySegment hydro_secretbox_decrypt$address() {
        return hydro_secretbox_decrypt.ADDR;
    }

    public static int hydro_secretbox_decrypt(MemorySegment memorySegment, MemorySegment memorySegment2, long l, long l2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_secretbox_decrypt.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_secretbox_decrypt", memorySegment, memorySegment2, l, l2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, l2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_secretbox_probe_create$descriptor() {
        return hydro_secretbox_probe_create.DESC;
    }

    public static MethodHandle hydro_secretbox_probe_create$handle() {
        return hydro_secretbox_probe_create.HANDLE;
    }

    public static MemorySegment hydro_secretbox_probe_create$address() {
        return hydro_secretbox_probe_create.ADDR;
    }

    public static void hydro_secretbox_probe_create(MemorySegment memorySegment, MemorySegment memorySegment2, long l, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_secretbox_probe_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_secretbox_probe_create", memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_secretbox_probe_verify$descriptor() {
        return hydro_secretbox_probe_verify.DESC;
    }

    public static MethodHandle hydro_secretbox_probe_verify$handle() {
        return hydro_secretbox_probe_verify.HANDLE;
    }

    public static MemorySegment hydro_secretbox_probe_verify$address() {
        return hydro_secretbox_probe_verify.ADDR;
    }

    public static int hydro_secretbox_probe_verify(MemorySegment memorySegment, MemorySegment memorySegment2, long l, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_secretbox_probe_verify.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_secretbox_probe_verify", memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kdf_keygen$descriptor() {
        return hydro_kdf_keygen.DESC;
    }

    public static MethodHandle hydro_kdf_keygen$handle() {
        return hydro_kdf_keygen.HANDLE;
    }

    public static MemorySegment hydro_kdf_keygen$address() {
        return hydro_kdf_keygen.ADDR;
    }

    public static void hydro_kdf_keygen(MemorySegment memorySegment) {
        MethodHandle methodHandle = hydro_kdf_keygen.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kdf_keygen", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kdf_derive_from_key$descriptor() {
        return hydro_kdf_derive_from_key.DESC;
    }

    public static MethodHandle hydro_kdf_derive_from_key$handle() {
        return hydro_kdf_derive_from_key.HANDLE;
    }

    public static MemorySegment hydro_kdf_derive_from_key$address() {
        return hydro_kdf_derive_from_key.ADDR;
    }

    public static int hydro_kdf_derive_from_key(MemorySegment memorySegment, long l, long l2, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = hydro_kdf_derive_from_key.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kdf_derive_from_key", memorySegment, l, l2, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, l, l2, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_keygen$descriptor() {
        return hydro_sign_keygen.DESC;
    }

    public static MethodHandle hydro_sign_keygen$handle() {
        return hydro_sign_keygen.HANDLE;
    }

    public static MemorySegment hydro_sign_keygen$address() {
        return hydro_sign_keygen.ADDR;
    }

    public static void hydro_sign_keygen(MemorySegment memorySegment) {
        MethodHandle methodHandle = hydro_sign_keygen.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_keygen", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_keygen_deterministic$descriptor() {
        return hydro_sign_keygen_deterministic.DESC;
    }

    public static MethodHandle hydro_sign_keygen_deterministic$handle() {
        return hydro_sign_keygen_deterministic.HANDLE;
    }

    public static MemorySegment hydro_sign_keygen_deterministic$address() {
        return hydro_sign_keygen_deterministic.ADDR;
    }

    public static void hydro_sign_keygen_deterministic(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = hydro_sign_keygen_deterministic.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_keygen_deterministic", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_init$descriptor() {
        return hydro_sign_init.DESC;
    }

    public static MethodHandle hydro_sign_init$handle() {
        return hydro_sign_init.HANDLE;
    }

    public static MemorySegment hydro_sign_init$address() {
        return hydro_sign_init.ADDR;
    }

    public static int hydro_sign_init(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = hydro_sign_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_init", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_update$descriptor() {
        return hydro_sign_update.DESC;
    }

    public static MethodHandle hydro_sign_update$handle() {
        return hydro_sign_update.HANDLE;
    }

    public static MemorySegment hydro_sign_update$address() {
        return hydro_sign_update.ADDR;
    }

    public static int hydro_sign_update(MemorySegment memorySegment, MemorySegment memorySegment2, long l) {
        MethodHandle methodHandle = hydro_sign_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_update", memorySegment, memorySegment2, l);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_final_create$descriptor() {
        return hydro_sign_final_create.DESC;
    }

    public static MethodHandle hydro_sign_final_create$handle() {
        return hydro_sign_final_create.HANDLE;
    }

    public static MemorySegment hydro_sign_final_create$address() {
        return hydro_sign_final_create.ADDR;
    }

    public static int hydro_sign_final_create(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = hydro_sign_final_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_final_create", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_final_verify$descriptor() {
        return hydro_sign_final_verify.DESC;
    }

    public static MethodHandle hydro_sign_final_verify$handle() {
        return hydro_sign_final_verify.HANDLE;
    }

    public static MemorySegment hydro_sign_final_verify$address() {
        return hydro_sign_final_verify.ADDR;
    }

    public static int hydro_sign_final_verify(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = hydro_sign_final_verify.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_final_verify", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_create$descriptor() {
        return hydro_sign_create.DESC;
    }

    public static MethodHandle hydro_sign_create$handle() {
        return hydro_sign_create.HANDLE;
    }

    public static MemorySegment hydro_sign_create$address() {
        return hydro_sign_create.ADDR;
    }

    public static int hydro_sign_create(MemorySegment memorySegment, MemorySegment memorySegment2, long l, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_sign_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_create", memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_sign_verify$descriptor() {
        return hydro_sign_verify.DESC;
    }

    public static MethodHandle hydro_sign_verify$handle() {
        return hydro_sign_verify.HANDLE;
    }

    public static MemorySegment hydro_sign_verify$address() {
        return hydro_sign_verify.ADDR;
    }

    public static int hydro_sign_verify(MemorySegment memorySegment, MemorySegment memorySegment2, long l, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_sign_verify.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_sign_verify", memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_keygen$descriptor() {
        return hydro_kx_keygen.DESC;
    }

    public static MethodHandle hydro_kx_keygen$handle() {
        return hydro_kx_keygen.HANDLE;
    }

    public static MemorySegment hydro_kx_keygen$address() {
        return hydro_kx_keygen.ADDR;
    }

    public static void hydro_kx_keygen(MemorySegment memorySegment) {
        MethodHandle methodHandle = hydro_kx_keygen.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_keygen", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_keygen_deterministic$descriptor() {
        return hydro_kx_keygen_deterministic.DESC;
    }

    public static MethodHandle hydro_kx_keygen_deterministic$handle() {
        return hydro_kx_keygen_deterministic.HANDLE;
    }

    public static MemorySegment hydro_kx_keygen_deterministic$address() {
        return hydro_kx_keygen_deterministic.ADDR;
    }

    public static void hydro_kx_keygen_deterministic(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = hydro_kx_keygen_deterministic.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_keygen_deterministic", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_n_1$descriptor() {
        return hydro_kx_n_1.DESC;
    }

    public static MethodHandle hydro_kx_n_1$handle() {
        return hydro_kx_n_1.HANDLE;
    }

    public static MemorySegment hydro_kx_n_1$address() {
        return hydro_kx_n_1.ADDR;
    }

    public static int hydro_kx_n_1(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_kx_n_1.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_n_1", memorySegment, memorySegment2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_n_2$descriptor() {
        return hydro_kx_n_2.DESC;
    }

    public static MethodHandle hydro_kx_n_2$handle() {
        return hydro_kx_n_2.HANDLE;
    }

    public static MemorySegment hydro_kx_n_2$address() {
        return hydro_kx_n_2.ADDR;
    }

    public static int hydro_kx_n_2(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_kx_n_2.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_n_2", memorySegment, memorySegment2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_kk_1$descriptor() {
        return hydro_kx_kk_1.DESC;
    }

    public static MethodHandle hydro_kx_kk_1$handle() {
        return hydro_kx_kk_1.HANDLE;
    }

    public static MemorySegment hydro_kx_kk_1$address() {
        return hydro_kx_kk_1.ADDR;
    }

    public static int hydro_kx_kk_1(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_kx_kk_1.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_kk_1", memorySegment, memorySegment2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_kk_2$descriptor() {
        return hydro_kx_kk_2.DESC;
    }

    public static MethodHandle hydro_kx_kk_2$handle() {
        return hydro_kx_kk_2.HANDLE;
    }

    public static MemorySegment hydro_kx_kk_2$address() {
        return hydro_kx_kk_2.ADDR;
    }

    public static int hydro_kx_kk_2(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, MemorySegment memorySegment5) {
        MethodHandle methodHandle = hydro_kx_kk_2.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_kk_2", memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_kk_3$descriptor() {
        return hydro_kx_kk_3.DESC;
    }

    public static MethodHandle hydro_kx_kk_3$handle() {
        return hydro_kx_kk_3.HANDLE;
    }

    public static MemorySegment hydro_kx_kk_3$address() {
        return hydro_kx_kk_3.ADDR;
    }

    public static int hydro_kx_kk_3(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_kx_kk_3.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_kk_3", memorySegment, memorySegment2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_xx_1$descriptor() {
        return hydro_kx_xx_1.DESC;
    }

    public static MethodHandle hydro_kx_xx_1$handle() {
        return hydro_kx_xx_1.HANDLE;
    }

    public static MemorySegment hydro_kx_xx_1$address() {
        return hydro_kx_xx_1.ADDR;
    }

    public static int hydro_kx_xx_1(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = hydro_kx_xx_1.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_xx_1", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_xx_2$descriptor() {
        return hydro_kx_xx_2.DESC;
    }

    public static MethodHandle hydro_kx_xx_2$handle() {
        return hydro_kx_xx_2.HANDLE;
    }

    public static MemorySegment hydro_kx_xx_2$address() {
        return hydro_kx_xx_2.ADDR;
    }

    public static int hydro_kx_xx_2(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, MemorySegment memorySegment5) {
        MethodHandle methodHandle = hydro_kx_xx_2.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_xx_2", memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_xx_3$descriptor() {
        return hydro_kx_xx_3.DESC;
    }

    public static MethodHandle hydro_kx_xx_3$handle() {
        return hydro_kx_xx_3.HANDLE;
    }

    public static MemorySegment hydro_kx_xx_3$address() {
        return hydro_kx_xx_3.ADDR;
    }

    public static int hydro_kx_xx_3(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, MemorySegment memorySegment5, MemorySegment memorySegment6, MemorySegment memorySegment7) {
        MethodHandle methodHandle = hydro_kx_xx_3.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_xx_3", memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5, memorySegment6, memorySegment7);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5, memorySegment6, memorySegment7);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_xx_4$descriptor() {
        return hydro_kx_xx_4.DESC;
    }

    public static MethodHandle hydro_kx_xx_4$handle() {
        return hydro_kx_xx_4.HANDLE;
    }

    public static MemorySegment hydro_kx_xx_4$address() {
        return hydro_kx_xx_4.ADDR;
    }

    public static int hydro_kx_xx_4(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, MemorySegment memorySegment5) {
        MethodHandle methodHandle = hydro_kx_xx_4.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_xx_4", memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_nk_1$descriptor() {
        return hydro_kx_nk_1.DESC;
    }

    public static MethodHandle hydro_kx_nk_1$handle() {
        return hydro_kx_nk_1.HANDLE;
    }

    public static MemorySegment hydro_kx_nk_1$address() {
        return hydro_kx_nk_1.ADDR;
    }

    public static int hydro_kx_nk_1(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_kx_nk_1.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_nk_1", memorySegment, memorySegment2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_nk_2$descriptor() {
        return hydro_kx_nk_2.DESC;
    }

    public static MethodHandle hydro_kx_nk_2$handle() {
        return hydro_kx_nk_2.HANDLE;
    }

    public static MemorySegment hydro_kx_nk_2$address() {
        return hydro_kx_nk_2.ADDR;
    }

    public static int hydro_kx_nk_2(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, MemorySegment memorySegment5) {
        MethodHandle methodHandle = hydro_kx_nk_2.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_nk_2", memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_kx_nk_3$descriptor() {
        return hydro_kx_nk_3.DESC;
    }

    public static MethodHandle hydro_kx_nk_3$handle() {
        return hydro_kx_nk_3.HANDLE;
    }

    public static MemorySegment hydro_kx_nk_3$address() {
        return hydro_kx_nk_3.ADDR;
    }

    public static int hydro_kx_nk_3(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = hydro_kx_nk_3.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_kx_nk_3", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pwhash_keygen$descriptor() {
        return hydro_pwhash_keygen.DESC;
    }

    public static MethodHandle hydro_pwhash_keygen$handle() {
        return hydro_pwhash_keygen.HANDLE;
    }

    public static MemorySegment hydro_pwhash_keygen$address() {
        return hydro_pwhash_keygen.ADDR;
    }

    public static void hydro_pwhash_keygen(MemorySegment memorySegment) {
        MethodHandle methodHandle = hydro_pwhash_keygen.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pwhash_keygen", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pwhash_deterministic$descriptor() {
        return hydro_pwhash_deterministic.DESC;
    }

    public static MethodHandle hydro_pwhash_deterministic$handle() {
        return hydro_pwhash_deterministic.HANDLE;
    }

    public static MemorySegment hydro_pwhash_deterministic$address() {
        return hydro_pwhash_deterministic.ADDR;
    }

    public static int hydro_pwhash_deterministic(MemorySegment memorySegment, long l, MemorySegment memorySegment2, long l2, MemorySegment memorySegment3, MemorySegment memorySegment4, long l3, long l4, byte by) {
        MethodHandle methodHandle = hydro_pwhash_deterministic.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pwhash_deterministic", memorySegment, l, memorySegment2, l2, memorySegment3, memorySegment4, l3, l4, by);
            }
            return methodHandle.invokeExact(memorySegment, l, memorySegment2, l2, memorySegment3, memorySegment4, l3, l4, by);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pwhash_create$descriptor() {
        return hydro_pwhash_create.DESC;
    }

    public static MethodHandle hydro_pwhash_create$handle() {
        return hydro_pwhash_create.HANDLE;
    }

    public static MemorySegment hydro_pwhash_create$address() {
        return hydro_pwhash_create.ADDR;
    }

    public static int hydro_pwhash_create(MemorySegment memorySegment, MemorySegment memorySegment2, long l, MemorySegment memorySegment3, long l2, long l3, byte by) {
        MethodHandle methodHandle = hydro_pwhash_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pwhash_create", memorySegment, memorySegment2, l, memorySegment3, l2, l3, by);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, memorySegment3, l2, l3, by);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pwhash_verify$descriptor() {
        return hydro_pwhash_verify.DESC;
    }

    public static MethodHandle hydro_pwhash_verify$handle() {
        return hydro_pwhash_verify.HANDLE;
    }

    public static MemorySegment hydro_pwhash_verify$address() {
        return hydro_pwhash_verify.ADDR;
    }

    public static int hydro_pwhash_verify(MemorySegment memorySegment, MemorySegment memorySegment2, long l, MemorySegment memorySegment3, long l2, long l3, byte by) {
        MethodHandle methodHandle = hydro_pwhash_verify.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pwhash_verify", memorySegment, memorySegment2, l, memorySegment3, l2, l3, by);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, memorySegment3, l2, l3, by);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pwhash_derive_static_key$descriptor() {
        return hydro_pwhash_derive_static_key.DESC;
    }

    public static MethodHandle hydro_pwhash_derive_static_key$handle() {
        return hydro_pwhash_derive_static_key.HANDLE;
    }

    public static MemorySegment hydro_pwhash_derive_static_key$address() {
        return hydro_pwhash_derive_static_key.ADDR;
    }

    public static int hydro_pwhash_derive_static_key(MemorySegment memorySegment, long l, MemorySegment memorySegment2, MemorySegment memorySegment3, long l2, MemorySegment memorySegment4, MemorySegment memorySegment5, long l3, long l4, byte by) {
        MethodHandle methodHandle = hydro_pwhash_derive_static_key.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pwhash_derive_static_key", memorySegment, l, memorySegment2, memorySegment3, l2, memorySegment4, memorySegment5, l3, l4, by);
            }
            return methodHandle.invokeExact(memorySegment, l, memorySegment2, memorySegment3, l2, memorySegment4, memorySegment5, l3, l4, by);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pwhash_reencrypt$descriptor() {
        return hydro_pwhash_reencrypt.DESC;
    }

    public static MethodHandle hydro_pwhash_reencrypt$handle() {
        return hydro_pwhash_reencrypt.HANDLE;
    }

    public static MemorySegment hydro_pwhash_reencrypt$address() {
        return hydro_pwhash_reencrypt.ADDR;
    }

    public static int hydro_pwhash_reencrypt(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = hydro_pwhash_reencrypt.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pwhash_reencrypt", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pwhash_upgrade$descriptor() {
        return hydro_pwhash_upgrade.DESC;
    }

    public static MethodHandle hydro_pwhash_upgrade$handle() {
        return hydro_pwhash_upgrade.HANDLE;
    }

    public static MemorySegment hydro_pwhash_upgrade$address() {
        return hydro_pwhash_upgrade.ADDR;
    }

    public static int hydro_pwhash_upgrade(MemorySegment memorySegment, MemorySegment memorySegment2, long l, long l2, byte by) {
        MethodHandle methodHandle = hydro_pwhash_upgrade.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pwhash_upgrade", memorySegment, memorySegment2, l, l2, by);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, l2, by);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_memzero$descriptor() {
        return hydro_memzero.DESC;
    }

    public static MethodHandle hydro_memzero$handle() {
        return hydro_memzero.HANDLE;
    }

    public static MemorySegment hydro_memzero$address() {
        return hydro_memzero.ADDR;
    }

    public static void hydro_memzero(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = hydro_memzero.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_memzero", memorySegment, l);
            }
            methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_increment$descriptor() {
        return hydro_increment.DESC;
    }

    public static MethodHandle hydro_increment$handle() {
        return hydro_increment.HANDLE;
    }

    public static MemorySegment hydro_increment$address() {
        return hydro_increment.ADDR;
    }

    public static void hydro_increment(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = hydro_increment.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_increment", memorySegment, l);
            }
            methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_equal$descriptor() {
        return hydro_equal.DESC;
    }

    public static MethodHandle hydro_equal$handle() {
        return hydro_equal.HANDLE;
    }

    public static MemorySegment hydro_equal$address() {
        return hydro_equal.ADDR;
    }

    public static boolean hydro_equal(MemorySegment memorySegment, MemorySegment memorySegment2, long l) {
        MethodHandle methodHandle = hydro_equal.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_equal", memorySegment, memorySegment2, l);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_compare$descriptor() {
        return hydro_compare.DESC;
    }

    public static MethodHandle hydro_compare$handle() {
        return hydro_compare.HANDLE;
    }

    public static MemorySegment hydro_compare$address() {
        return hydro_compare.ADDR;
    }

    public static int hydro_compare(MemorySegment memorySegment, MemorySegment memorySegment2, long l) {
        MethodHandle methodHandle = hydro_compare.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_compare", memorySegment, memorySegment2, l);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_bin2hex$descriptor() {
        return hydro_bin2hex.DESC;
    }

    public static MethodHandle hydro_bin2hex$handle() {
        return hydro_bin2hex.HANDLE;
    }

    public static MemorySegment hydro_bin2hex$address() {
        return hydro_bin2hex.ADDR;
    }

    public static MemorySegment hydro_bin2hex(MemorySegment memorySegment, long l, MemorySegment memorySegment2, long l2) {
        MethodHandle methodHandle = hydro_bin2hex.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_bin2hex", memorySegment, l, memorySegment2, l2);
            }
            return methodHandle.invokeExact(memorySegment, l, memorySegment2, l2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_hex2bin$descriptor() {
        return hydro_hex2bin.DESC;
    }

    public static MethodHandle hydro_hex2bin$handle() {
        return hydro_hex2bin.HANDLE;
    }

    public static MemorySegment hydro_hex2bin$address() {
        return hydro_hex2bin.ADDR;
    }

    public static int hydro_hex2bin(MemorySegment memorySegment, long l, MemorySegment memorySegment2, long l2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = hydro_hex2bin.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_hex2bin", memorySegment, l, memorySegment2, l2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, l, memorySegment2, l2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_pad$descriptor() {
        return hydro_pad.DESC;
    }

    public static MethodHandle hydro_pad$handle() {
        return hydro_pad.HANDLE;
    }

    public static MemorySegment hydro_pad$address() {
        return hydro_pad.ADDR;
    }

    public static int hydro_pad(MemorySegment memorySegment, long l, long l2, long l3) {
        MethodHandle methodHandle = hydro_pad.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_pad", memorySegment, l, l2, l3);
            }
            return methodHandle.invokeExact(memorySegment, l, l2, l3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor hydro_unpad$descriptor() {
        return hydro_unpad.DESC;
    }

    public static MethodHandle hydro_unpad$handle() {
        return hydro_unpad.HANDLE;
    }

    public static MemorySegment hydro_unpad$address() {
        return hydro_unpad.ADDR;
    }

    public static int hydro_unpad(MemorySegment memorySegment, long l, long l2) {
        MethodHandle methodHandle = hydro_unpad.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("hydro_unpad", memorySegment, l, l2);
            }
            return methodHandle.invokeExact(memorySegment, l, l2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static int CN_PROTOCOL_PACKET_TYPE_CONNECT_TOKEN() {
        return 0;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_CONNECTION_ACCEPTED() {
        return 1;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_CONNECTION_DENIED() {
        return 2;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_KEEPALIVE() {
        return 3;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_DISCONNECT() {
        return 4;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_CHALLENGE_REQUEST() {
        return 5;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_CHALLENGE_RESPONSE() {
        return 6;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_PAYLOAD() {
        return 7;
    }

    public static int CN_PROTOCOL_PACKET_TYPE_COUNT() {
        return 8;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_CONNECT_TOKEN_EXPIRED() {
        return -6;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_INVALID_CONNECT_TOKEN() {
        return -5;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_CONNECTION_TIMED_OUT() {
        return -4;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_CHALLENGED_RESPONSE_TIMED_OUT() {
        return -3;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_CONNECTION_REQUEST_TIMED_OUT() {
        return -2;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_CONNECTION_DENIED() {
        return -1;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_DISCONNECTED() {
        return 0;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_SENDING_CONNECTION_REQUEST() {
        return 1;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_SENDING_CHALLENGE_RESPONSE() {
        return 2;
    }

    public static int CN_PROTOCOL_CLIENT_STATE_CONNECTED() {
        return 3;
    }

    public static int CN_PROTOCOL_SERVER_EVENT_NEW_CONNECTION() {
        return 0;
    }

    public static int CN_PROTOCOL_SERVER_EVENT_DISCONNECTED() {
        return 1;
    }

    public static int CN_PROTOCOL_SERVER_EVENT_PAYLOAD_PACKET() {
        return 2;
    }

    public static FunctionDescriptor cn_write_uint8$descriptor() {
        return cn_write_uint8.DESC;
    }

    public static MethodHandle cn_write_uint8$handle() {
        return cn_write_uint8.HANDLE;
    }

    public static MemorySegment cn_write_uint8$address() {
        return cn_write_uint8.ADDR;
    }

    public static void cn_write_uint8(MemorySegment memorySegment, byte by) {
        MethodHandle methodHandle = cn_write_uint8.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_uint8", memorySegment, by);
            }
            methodHandle.invokeExact(memorySegment, by);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_uint16$descriptor() {
        return cn_write_uint16.DESC;
    }

    public static MethodHandle cn_write_uint16$handle() {
        return cn_write_uint16.HANDLE;
    }

    public static MemorySegment cn_write_uint16$address() {
        return cn_write_uint16.ADDR;
    }

    public static void cn_write_uint16(MemorySegment memorySegment, short s) {
        MethodHandle methodHandle = cn_write_uint16.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_uint16", memorySegment, s);
            }
            methodHandle.invokeExact(memorySegment, s);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_uint32$descriptor() {
        return cn_write_uint32.DESC;
    }

    public static MethodHandle cn_write_uint32$handle() {
        return cn_write_uint32.HANDLE;
    }

    public static MemorySegment cn_write_uint32$address() {
        return cn_write_uint32.ADDR;
    }

    public static void cn_write_uint32(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_write_uint32.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_uint32", memorySegment, n);
            }
            methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_float$descriptor() {
        return cn_write_float.DESC;
    }

    public static MethodHandle cn_write_float$handle() {
        return cn_write_float.HANDLE;
    }

    public static MemorySegment cn_write_float$address() {
        return cn_write_float.ADDR;
    }

    public static void cn_write_float(MemorySegment memorySegment, float f) {
        MethodHandle methodHandle = cn_write_float.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_float", memorySegment, Float.valueOf(f));
            }
            methodHandle.invokeExact(memorySegment, f);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_uint64$descriptor() {
        return cn_write_uint64.DESC;
    }

    public static MethodHandle cn_write_uint64$handle() {
        return cn_write_uint64.HANDLE;
    }

    public static MemorySegment cn_write_uint64$address() {
        return cn_write_uint64.ADDR;
    }

    public static void cn_write_uint64(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = cn_write_uint64.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_uint64", memorySegment, l);
            }
            methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_bytes$descriptor() {
        return cn_write_bytes.DESC;
    }

    public static MethodHandle cn_write_bytes$handle() {
        return cn_write_bytes.HANDLE;
    }

    public static MemorySegment cn_write_bytes$address() {
        return cn_write_bytes.ADDR;
    }

    public static void cn_write_bytes(MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_write_bytes.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_bytes", memorySegment, memorySegment2, n);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_endpoint$descriptor() {
        return cn_write_endpoint.DESC;
    }

    public static MethodHandle cn_write_endpoint$handle() {
        return cn_write_endpoint.HANDLE;
    }

    public static MemorySegment cn_write_endpoint$address() {
        return cn_write_endpoint.ADDR;
    }

    public static void cn_write_endpoint(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_write_endpoint.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_endpoint", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_key$descriptor() {
        return cn_write_key.DESC;
    }

    public static MethodHandle cn_write_key$handle() {
        return cn_write_key.HANDLE;
    }

    public static MemorySegment cn_write_key$address() {
        return cn_write_key.ADDR;
    }

    public static void cn_write_key(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_write_key.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_key", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_write_fourcc$descriptor() {
        return cn_write_fourcc.DESC;
    }

    public static MethodHandle cn_write_fourcc$handle() {
        return cn_write_fourcc.HANDLE;
    }

    public static MemorySegment cn_write_fourcc$address() {
        return cn_write_fourcc.ADDR;
    }

    public static void cn_write_fourcc(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_write_fourcc.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_write_fourcc", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_uint8$descriptor() {
        return cn_read_uint8.DESC;
    }

    public static MethodHandle cn_read_uint8$handle() {
        return cn_read_uint8.HANDLE;
    }

    public static MemorySegment cn_read_uint8$address() {
        return cn_read_uint8.ADDR;
    }

    public static byte cn_read_uint8(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_read_uint8.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_uint8", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_uint16$descriptor() {
        return cn_read_uint16.DESC;
    }

    public static MethodHandle cn_read_uint16$handle() {
        return cn_read_uint16.HANDLE;
    }

    public static MemorySegment cn_read_uint16$address() {
        return cn_read_uint16.ADDR;
    }

    public static short cn_read_uint16(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_read_uint16.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_uint16", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_uint32$descriptor() {
        return cn_read_uint32.DESC;
    }

    public static MethodHandle cn_read_uint32$handle() {
        return cn_read_uint32.HANDLE;
    }

    public static MemorySegment cn_read_uint32$address() {
        return cn_read_uint32.ADDR;
    }

    public static int cn_read_uint32(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_read_uint32.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_uint32", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_float$descriptor() {
        return cn_read_float.DESC;
    }

    public static MethodHandle cn_read_float$handle() {
        return cn_read_float.HANDLE;
    }

    public static MemorySegment cn_read_float$address() {
        return cn_read_float.ADDR;
    }

    public static float cn_read_float(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_read_float.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_float", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_uint64$descriptor() {
        return cn_read_uint64.DESC;
    }

    public static MethodHandle cn_read_uint64$handle() {
        return cn_read_uint64.HANDLE;
    }

    public static MemorySegment cn_read_uint64$address() {
        return cn_read_uint64.ADDR;
    }

    public static long cn_read_uint64(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_read_uint64.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_uint64", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_bytes$descriptor() {
        return cn_read_bytes.DESC;
    }

    public static MethodHandle cn_read_bytes$handle() {
        return cn_read_bytes.HANDLE;
    }

    public static MemorySegment cn_read_bytes$address() {
        return cn_read_bytes.ADDR;
    }

    public static void cn_read_bytes(MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_read_bytes.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_bytes", memorySegment, memorySegment2, n);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_endpoint$descriptor() {
        return cn_read_endpoint.DESC;
    }

    public static MethodHandle cn_read_endpoint$handle() {
        return cn_read_endpoint.HANDLE;
    }

    public static MemorySegment cn_read_endpoint$address() {
        return cn_read_endpoint.ADDR;
    }

    public static MemorySegment cn_read_endpoint(SegmentAllocator segmentAllocator, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_read_endpoint.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_endpoint", segmentAllocator, memorySegment);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_key$descriptor() {
        return cn_read_key.DESC;
    }

    public static MethodHandle cn_read_key$handle() {
        return cn_read_key.HANDLE;
    }

    public static MemorySegment cn_read_key$address() {
        return cn_read_key.ADDR;
    }

    public static MemorySegment cn_read_key(SegmentAllocator segmentAllocator, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_read_key.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_key", segmentAllocator, memorySegment);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_read_fourcc$descriptor() {
        return cn_read_fourcc.DESC;
    }

    public static MethodHandle cn_read_fourcc$handle() {
        return cn_read_fourcc.HANDLE;
    }

    public static MemorySegment cn_read_fourcc$address() {
        return cn_read_fourcc.ADDR;
    }

    public static void cn_read_fourcc(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_read_fourcc.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_read_fourcc", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_init_node$descriptor() {
        return cn_list_init_node.DESC;
    }

    public static MethodHandle cn_list_init_node$handle() {
        return cn_list_init_node.HANDLE;
    }

    public static MemorySegment cn_list_init_node$address() {
        return cn_list_init_node.ADDR;
    }

    public static void cn_list_init_node(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_init_node.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_init_node", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_init$descriptor() {
        return cn_list_init.DESC;
    }

    public static MethodHandle cn_list_init$handle() {
        return cn_list_init.HANDLE;
    }

    public static MemorySegment cn_list_init$address() {
        return cn_list_init.ADDR;
    }

    public static void cn_list_init(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_init", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_push_front$descriptor() {
        return cn_list_push_front.DESC;
    }

    public static MethodHandle cn_list_push_front$handle() {
        return cn_list_push_front.HANDLE;
    }

    public static MemorySegment cn_list_push_front$address() {
        return cn_list_push_front.ADDR;
    }

    public static void cn_list_push_front(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_list_push_front.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_push_front", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_push_back$descriptor() {
        return cn_list_push_back.DESC;
    }

    public static MethodHandle cn_list_push_back$handle() {
        return cn_list_push_back.HANDLE;
    }

    public static MemorySegment cn_list_push_back$address() {
        return cn_list_push_back.ADDR;
    }

    public static void cn_list_push_back(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_list_push_back.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_push_back", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_remove$descriptor() {
        return cn_list_remove.DESC;
    }

    public static MethodHandle cn_list_remove$handle() {
        return cn_list_remove.HANDLE;
    }

    public static MemorySegment cn_list_remove$address() {
        return cn_list_remove.ADDR;
    }

    public static void cn_list_remove(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_remove.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_remove", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_pop_front$descriptor() {
        return cn_list_pop_front.DESC;
    }

    public static MethodHandle cn_list_pop_front$handle() {
        return cn_list_pop_front.HANDLE;
    }

    public static MemorySegment cn_list_pop_front$address() {
        return cn_list_pop_front.ADDR;
    }

    public static MemorySegment cn_list_pop_front(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_pop_front.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_pop_front", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_pop_back$descriptor() {
        return cn_list_pop_back.DESC;
    }

    public static MethodHandle cn_list_pop_back$handle() {
        return cn_list_pop_back.HANDLE;
    }

    public static MemorySegment cn_list_pop_back$address() {
        return cn_list_pop_back.ADDR;
    }

    public static MemorySegment cn_list_pop_back(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_pop_back.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_pop_back", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_empty$descriptor() {
        return cn_list_empty.DESC;
    }

    public static MethodHandle cn_list_empty$handle() {
        return cn_list_empty.HANDLE;
    }

    public static MemorySegment cn_list_empty$address() {
        return cn_list_empty.ADDR;
    }

    public static int cn_list_empty(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_empty.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_empty", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_begin$descriptor() {
        return cn_list_begin.DESC;
    }

    public static MethodHandle cn_list_begin$handle() {
        return cn_list_begin.HANDLE;
    }

    public static MemorySegment cn_list_begin$address() {
        return cn_list_begin.ADDR;
    }

    public static MemorySegment cn_list_begin(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_begin.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_begin", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_end$descriptor() {
        return cn_list_end.DESC;
    }

    public static MethodHandle cn_list_end$handle() {
        return cn_list_end.HANDLE;
    }

    public static MemorySegment cn_list_end$address() {
        return cn_list_end.ADDR;
    }

    public static MemorySegment cn_list_end(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_end.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_end", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_front$descriptor() {
        return cn_list_front.DESC;
    }

    public static MethodHandle cn_list_front$handle() {
        return cn_list_front.HANDLE;
    }

    public static MemorySegment cn_list_front$address() {
        return cn_list_front.ADDR;
    }

    public static MemorySegment cn_list_front(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_front.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_front", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_list_back$descriptor() {
        return cn_list_back.DESC;
    }

    public static MethodHandle cn_list_back$handle() {
        return cn_list_back.HANDLE;
    }

    public static MemorySegment cn_list_back$address() {
        return cn_list_back.ADDR;
    }

    public static MemorySegment cn_list_back(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_list_back.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_list_back", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_circular_buffer_create$descriptor() {
        return cn_circular_buffer_create.DESC;
    }

    public static MethodHandle cn_circular_buffer_create$handle() {
        return cn_circular_buffer_create.HANDLE;
    }

    public static MemorySegment cn_circular_buffer_create$address() {
        return cn_circular_buffer_create.ADDR;
    }

    public static MemorySegment cn_circular_buffer_create(SegmentAllocator segmentAllocator, int n, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_circular_buffer_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_circular_buffer_create", segmentAllocator, n, memorySegment);
            }
            return methodHandle.invokeExact(segmentAllocator, n, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_circular_buffer_free$descriptor() {
        return cn_circular_buffer_free.DESC;
    }

    public static MethodHandle cn_circular_buffer_free$handle() {
        return cn_circular_buffer_free.HANDLE;
    }

    public static MemorySegment cn_circular_buffer_free$address() {
        return cn_circular_buffer_free.ADDR;
    }

    public static void cn_circular_buffer_free(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_circular_buffer_free.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_circular_buffer_free", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_circular_buffer_reset$descriptor() {
        return cn_circular_buffer_reset.DESC;
    }

    public static MethodHandle cn_circular_buffer_reset$handle() {
        return cn_circular_buffer_reset.HANDLE;
    }

    public static MemorySegment cn_circular_buffer_reset$address() {
        return cn_circular_buffer_reset.ADDR;
    }

    public static void cn_circular_buffer_reset(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_circular_buffer_reset.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_circular_buffer_reset", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_circular_buffer_push$descriptor() {
        return cn_circular_buffer_push.DESC;
    }

    public static MethodHandle cn_circular_buffer_push$handle() {
        return cn_circular_buffer_push.HANDLE;
    }

    public static MemorySegment cn_circular_buffer_push$address() {
        return cn_circular_buffer_push.ADDR;
    }

    public static int cn_circular_buffer_push(MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_circular_buffer_push.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_circular_buffer_push", memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_circular_buffer_pull$descriptor() {
        return cn_circular_buffer_pull.DESC;
    }

    public static MethodHandle cn_circular_buffer_pull$handle() {
        return cn_circular_buffer_pull.HANDLE;
    }

    public static MemorySegment cn_circular_buffer_pull$address() {
        return cn_circular_buffer_pull.ADDR;
    }

    public static int cn_circular_buffer_pull(MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_circular_buffer_pull.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_circular_buffer_pull", memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_circular_buffer_grow$descriptor() {
        return cn_circular_buffer_grow.DESC;
    }

    public static MethodHandle cn_circular_buffer_grow$handle() {
        return cn_circular_buffer_grow.HANDLE;
    }

    public static MemorySegment cn_circular_buffer_grow$address() {
        return cn_circular_buffer_grow.ADDR;
    }

    public static int cn_circular_buffer_grow(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_circular_buffer_grow.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_circular_buffer_grow", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_socket_cleanup$descriptor() {
        return cn_socket_cleanup.DESC;
    }

    public static MethodHandle cn_socket_cleanup$handle() {
        return cn_socket_cleanup.HANDLE;
    }

    public static MemorySegment cn_socket_cleanup$address() {
        return cn_socket_cleanup.ADDR;
    }

    public static void cn_socket_cleanup(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_socket_cleanup.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_socket_cleanup", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_socket_init1$descriptor() {
        return cn_socket_init1.DESC;
    }

    public static MethodHandle cn_socket_init1$handle() {
        return cn_socket_init1.HANDLE;
    }

    public static MemorySegment cn_socket_init1$address() {
        return cn_socket_init1.ADDR;
    }

    public static int cn_socket_init1(MemorySegment memorySegment, int n, short s, int n2, int n3) {
        MethodHandle methodHandle = cn_socket_init1.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_socket_init1", memorySegment, n, s, n2, n3);
            }
            return methodHandle.invokeExact(memorySegment, n, s, n2, n3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_socket_init2$descriptor() {
        return cn_socket_init2.DESC;
    }

    public static MethodHandle cn_socket_init2$handle() {
        return cn_socket_init2.HANDLE;
    }

    public static MemorySegment cn_socket_init2$address() {
        return cn_socket_init2.ADDR;
    }

    public static int cn_socket_init2(MemorySegment memorySegment, MemorySegment memorySegment2, int n, int n2) {
        MethodHandle methodHandle = cn_socket_init2.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_socket_init2", memorySegment, memorySegment2, n, n2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, n, n2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_socket_send_internal$descriptor() {
        return cn_socket_send_internal.DESC;
    }

    public static MethodHandle cn_socket_send_internal$handle() {
        return cn_socket_send_internal.HANDLE;
    }

    public static MemorySegment cn_socket_send_internal$address() {
        return cn_socket_send_internal.ADDR;
    }

    public static int cn_socket_send_internal(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, int n) {
        MethodHandle methodHandle = cn_socket_send_internal.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_socket_send_internal", memorySegment, memorySegment2, memorySegment3, n);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_socket_receive$descriptor() {
        return cn_socket_receive.DESC;
    }

    public static MethodHandle cn_socket_receive$handle() {
        return cn_socket_receive.HANDLE;
    }

    public static MemorySegment cn_socket_receive$address() {
        return cn_socket_receive.ADDR;
    }

    public static int cn_socket_receive(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, int n) {
        MethodHandle methodHandle = cn_socket_receive.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_socket_receive", memorySegment, memorySegment2, memorySegment3, n);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_crypto_encrypt$descriptor() {
        return cn_crypto_encrypt.DESC;
    }

    public static MethodHandle cn_crypto_encrypt$handle() {
        return cn_crypto_encrypt.HANDLE;
    }

    public static MemorySegment cn_crypto_encrypt$address() {
        return cn_crypto_encrypt.ADDR;
    }

    public static void cn_crypto_encrypt(MemorySegment memorySegment, MemorySegment memorySegment2, int n, long l) {
        MethodHandle methodHandle = cn_crypto_encrypt.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_crypto_encrypt", memorySegment, memorySegment2, n, l);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, n, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_crypto_decrypt$descriptor() {
        return cn_crypto_decrypt.DESC;
    }

    public static MethodHandle cn_crypto_decrypt$handle() {
        return cn_crypto_decrypt.HANDLE;
    }

    public static MemorySegment cn_crypto_decrypt$address() {
        return cn_crypto_decrypt.ADDR;
    }

    public static MemorySegment cn_crypto_decrypt(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n, long l) {
        MethodHandle methodHandle = cn_crypto_decrypt.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_crypto_decrypt", segmentAllocator, memorySegment, memorySegment2, n, l);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_crypto_sign_create$descriptor() {
        return cn_crypto_sign_create.DESC;
    }

    public static MethodHandle cn_crypto_sign_create$handle() {
        return cn_crypto_sign_create.HANDLE;
    }

    public static MemorySegment cn_crypto_sign_create$address() {
        return cn_crypto_sign_create.ADDR;
    }

    public static void cn_crypto_sign_create(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, int n) {
        MethodHandle methodHandle = cn_crypto_sign_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_crypto_sign_create", memorySegment, memorySegment2, memorySegment3, n);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_crypto_sign_verify$descriptor() {
        return cn_crypto_sign_verify.DESC;
    }

    public static MethodHandle cn_crypto_sign_verify$handle() {
        return cn_crypto_sign_verify.HANDLE;
    }

    public static MemorySegment cn_crypto_sign_verify$address() {
        return cn_crypto_sign_verify.ADDR;
    }

    public static MemorySegment cn_crypto_sign_verify(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, int n) {
        MethodHandle methodHandle = cn_crypto_sign_verify.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_crypto_sign_verify", segmentAllocator, memorySegment, memorySegment2, memorySegment3, n);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, memorySegment3, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_simulator_create$descriptor() {
        return cn_simulator_create.DESC;
    }

    public static MethodHandle cn_simulator_create$handle() {
        return cn_simulator_create.HANDLE;
    }

    public static MemorySegment cn_simulator_create$address() {
        return cn_simulator_create.ADDR;
    }

    public static MemorySegment cn_simulator_create(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_simulator_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_simulator_create", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_simulator_destroy$descriptor() {
        return cn_simulator_destroy.DESC;
    }

    public static MethodHandle cn_simulator_destroy$handle() {
        return cn_simulator_destroy.HANDLE;
    }

    public static MemorySegment cn_simulator_destroy$address() {
        return cn_simulator_destroy.ADDR;
    }

    public static void cn_simulator_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_simulator_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_simulator_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_simulator_add$descriptor() {
        return cn_simulator_add.DESC;
    }

    public static MethodHandle cn_simulator_add$handle() {
        return cn_simulator_add.HANDLE;
    }

    public static MemorySegment cn_simulator_add$address() {
        return cn_simulator_add.ADDR;
    }

    public static void cn_simulator_add(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, int n) {
        MethodHandle methodHandle = cn_simulator_add.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_simulator_add", memorySegment, memorySegment2, memorySegment3, n);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_simulator_update$descriptor() {
        return cn_simulator_update.DESC;
    }

    public static MethodHandle cn_simulator_update$handle() {
        return cn_simulator_update.HANDLE;
    }

    public static MemorySegment cn_simulator_update$address() {
        return cn_simulator_update.ADDR;
    }

    public static void cn_simulator_update(MemorySegment memorySegment, double d) {
        MethodHandle methodHandle = cn_simulator_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_simulator_update", memorySegment, d);
            }
            methodHandle.invokeExact(memorySegment, d);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_socket_send$descriptor() {
        return cn_socket_send.DESC;
    }

    public static MethodHandle cn_socket_send$handle() {
        return cn_socket_send.HANDLE;
    }

    public static MemorySegment cn_socket_send$address() {
        return cn_socket_send.ADDR;
    }

    public static int cn_socket_send(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, int n) {
        MethodHandle methodHandle = cn_socket_send.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_socket_send", memorySegment, memorySegment2, memorySegment3, memorySegment4, n);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_replay_buffer_init$descriptor() {
        return cn_protocol_replay_buffer_init.DESC;
    }

    public static MethodHandle cn_protocol_replay_buffer_init$handle() {
        return cn_protocol_replay_buffer_init.HANDLE;
    }

    public static MemorySegment cn_protocol_replay_buffer_init$address() {
        return cn_protocol_replay_buffer_init.ADDR;
    }

    public static void cn_protocol_replay_buffer_init(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_replay_buffer_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_replay_buffer_init", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_replay_buffer_cull_duplicate$descriptor() {
        return cn_protocol_replay_buffer_cull_duplicate.DESC;
    }

    public static MethodHandle cn_protocol_replay_buffer_cull_duplicate$handle() {
        return cn_protocol_replay_buffer_cull_duplicate.HANDLE;
    }

    public static MemorySegment cn_protocol_replay_buffer_cull_duplicate$address() {
        return cn_protocol_replay_buffer_cull_duplicate.ADDR;
    }

    public static int cn_protocol_replay_buffer_cull_duplicate(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = cn_protocol_replay_buffer_cull_duplicate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_replay_buffer_cull_duplicate", memorySegment, l);
            }
            return methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_replay_buffer_update$descriptor() {
        return cn_protocol_replay_buffer_update.DESC;
    }

    public static MethodHandle cn_protocol_replay_buffer_update$handle() {
        return cn_protocol_replay_buffer_update.HANDLE;
    }

    public static MemorySegment cn_protocol_replay_buffer_update$address() {
        return cn_protocol_replay_buffer_update.ADDR;
    }

    public static void cn_protocol_replay_buffer_update(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = cn_protocol_replay_buffer_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_replay_buffer_update", memorySegment, l);
            }
            methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_memory_pool_create$descriptor() {
        return cn_memory_pool_create.DESC;
    }

    public static MethodHandle cn_memory_pool_create$handle() {
        return cn_memory_pool_create.HANDLE;
    }

    public static MemorySegment cn_memory_pool_create$address() {
        return cn_memory_pool_create.ADDR;
    }

    public static MemorySegment cn_memory_pool_create(int n, int n2, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_memory_pool_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_memory_pool_create", n, n2, memorySegment);
            }
            return methodHandle.invokeExact(n, n2, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_memory_pool_destroy$descriptor() {
        return cn_memory_pool_destroy.DESC;
    }

    public static MethodHandle cn_memory_pool_destroy$handle() {
        return cn_memory_pool_destroy.HANDLE;
    }

    public static MemorySegment cn_memory_pool_destroy$address() {
        return cn_memory_pool_destroy.ADDR;
    }

    public static void cn_memory_pool_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_memory_pool_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_memory_pool_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_memory_pool_try_alloc$descriptor() {
        return cn_memory_pool_try_alloc.DESC;
    }

    public static MethodHandle cn_memory_pool_try_alloc$handle() {
        return cn_memory_pool_try_alloc.HANDLE;
    }

    public static MemorySegment cn_memory_pool_try_alloc$address() {
        return cn_memory_pool_try_alloc.ADDR;
    }

    public static MemorySegment cn_memory_pool_try_alloc(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_memory_pool_try_alloc.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_memory_pool_try_alloc", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_memory_pool_alloc$descriptor() {
        return cn_memory_pool_alloc.DESC;
    }

    public static MethodHandle cn_memory_pool_alloc$handle() {
        return cn_memory_pool_alloc.HANDLE;
    }

    public static MemorySegment cn_memory_pool_alloc$address() {
        return cn_memory_pool_alloc.ADDR;
    }

    public static MemorySegment cn_memory_pool_alloc(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_memory_pool_alloc.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_memory_pool_alloc", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_memory_pool_free$descriptor() {
        return cn_memory_pool_free.DESC;
    }

    public static MethodHandle cn_memory_pool_free$handle() {
        return cn_memory_pool_free.HANDLE;
    }

    public static MemorySegment cn_memory_pool_free$address() {
        return cn_memory_pool_free.ADDR;
    }

    public static void cn_memory_pool_free(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_memory_pool_free.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_memory_pool_free", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_packet_allocator_create$descriptor() {
        return cn_protocol_packet_allocator_create.DESC;
    }

    public static MethodHandle cn_protocol_packet_allocator_create$handle() {
        return cn_protocol_packet_allocator_create.HANDLE;
    }

    public static MemorySegment cn_protocol_packet_allocator_create$address() {
        return cn_protocol_packet_allocator_create.ADDR;
    }

    public static MemorySegment cn_protocol_packet_allocator_create(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_packet_allocator_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_packet_allocator_create", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_packet_allocator_destroy$descriptor() {
        return cn_protocol_packet_allocator_destroy.DESC;
    }

    public static MethodHandle cn_protocol_packet_allocator_destroy$handle() {
        return cn_protocol_packet_allocator_destroy.HANDLE;
    }

    public static MemorySegment cn_protocol_packet_allocator_destroy$address() {
        return cn_protocol_packet_allocator_destroy.ADDR;
    }

    public static void cn_protocol_packet_allocator_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_packet_allocator_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_packet_allocator_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_packet_allocator_alloc$descriptor() {
        return cn_protocol_packet_allocator_alloc.DESC;
    }

    public static MethodHandle cn_protocol_packet_allocator_alloc$handle() {
        return cn_protocol_packet_allocator_alloc.HANDLE;
    }

    public static MemorySegment cn_protocol_packet_allocator_alloc$address() {
        return cn_protocol_packet_allocator_alloc.ADDR;
    }

    public static MemorySegment cn_protocol_packet_allocator_alloc(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_protocol_packet_allocator_alloc.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_packet_allocator_alloc", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_packet_allocator_free$descriptor() {
        return cn_protocol_packet_allocator_free.DESC;
    }

    public static MethodHandle cn_protocol_packet_allocator_free$handle() {
        return cn_protocol_packet_allocator_free.HANDLE;
    }

    public static MemorySegment cn_protocol_packet_allocator_free$address() {
        return cn_protocol_packet_allocator_free.ADDR;
    }

    public static void cn_protocol_packet_allocator_free(MemorySegment memorySegment, int n, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_packet_allocator_free.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_packet_allocator_free", memorySegment, n, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, n, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_read_connect_token_packet_public_section$descriptor() {
        return cn_protocol_read_connect_token_packet_public_section.DESC;
    }

    public static MethodHandle cn_protocol_read_connect_token_packet_public_section$handle() {
        return cn_protocol_read_connect_token_packet_public_section.HANDLE;
    }

    public static MemorySegment cn_protocol_read_connect_token_packet_public_section$address() {
        return cn_protocol_read_connect_token_packet_public_section.ADDR;
    }

    public static MemorySegment cn_protocol_read_connect_token_packet_public_section(SegmentAllocator segmentAllocator, MemorySegment memorySegment, long l, long l2, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_read_connect_token_packet_public_section.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_read_connect_token_packet_public_section", segmentAllocator, memorySegment, l, l2, memorySegment2);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, l, l2, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_packet_write$descriptor() {
        return cn_protocol_packet_write.DESC;
    }

    public static MethodHandle cn_protocol_packet_write$handle() {
        return cn_protocol_packet_write.HANDLE;
    }

    public static MemorySegment cn_protocol_packet_write$address() {
        return cn_protocol_packet_write.ADDR;
    }

    public static int cn_protocol_packet_write(MemorySegment memorySegment, MemorySegment memorySegment2, long l, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_protocol_packet_write.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_packet_write", memorySegment, memorySegment2, l, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, l, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_packet_open$descriptor() {
        return cn_protocol_packet_open.DESC;
    }

    public static MethodHandle cn_protocol_packet_open$handle() {
        return cn_protocol_packet_open.HANDLE;
    }

    public static MemorySegment cn_protocol_packet_open$address() {
        return cn_protocol_packet_open.ADDR;
    }

    public static MemorySegment cn_protocol_packet_open(MemorySegment memorySegment, int n, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4, MemorySegment memorySegment5) {
        MethodHandle methodHandle = cn_protocol_packet_open.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_packet_open", memorySegment, n, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
            }
            return methodHandle.invokeExact(memorySegment, n, memorySegment2, memorySegment3, memorySegment4, memorySegment5);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_read_connect_token_from_web_service$descriptor() {
        return cn_protocol_client_read_connect_token_from_web_service.DESC;
    }

    public static MethodHandle cn_protocol_client_read_connect_token_from_web_service$handle() {
        return cn_protocol_client_read_connect_token_from_web_service.HANDLE;
    }

    public static MemorySegment cn_protocol_client_read_connect_token_from_web_service$address() {
        return cn_protocol_client_read_connect_token_from_web_service.ADDR;
    }

    public static MemorySegment cn_protocol_client_read_connect_token_from_web_service(MemorySegment memorySegment, long l, long l2, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_client_read_connect_token_from_web_service.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_read_connect_token_from_web_service", memorySegment, l, l2, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, l, l2, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_decrypt_connect_token_packet$descriptor() {
        return cn_protocol_server_decrypt_connect_token_packet.DESC;
    }

    public static MethodHandle cn_protocol_server_decrypt_connect_token_packet$handle() {
        return cn_protocol_server_decrypt_connect_token_packet.HANDLE;
    }

    public static MemorySegment cn_protocol_server_decrypt_connect_token_packet$address() {
        return cn_protocol_server_decrypt_connect_token_packet.ADDR;
    }

    public static MemorySegment cn_protocol_server_decrypt_connect_token_packet(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, long l, long l2, MemorySegment memorySegment4) {
        MethodHandle methodHandle = cn_protocol_server_decrypt_connect_token_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_decrypt_connect_token_packet", segmentAllocator, memorySegment, memorySegment2, memorySegment3, l, l2, memorySegment4);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, memorySegment3, l, l2, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_init$descriptor() {
        return cn_hashtable_init.DESC;
    }

    public static MethodHandle cn_hashtable_init$handle() {
        return cn_hashtable_init.HANDLE;
    }

    public static MemorySegment cn_hashtable_init$address() {
        return cn_hashtable_init.ADDR;
    }

    public static void cn_hashtable_init(MemorySegment memorySegment, int n, int n2, int n3, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_hashtable_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_init", memorySegment, n, n2, n3, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, n, n2, n3, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_cleanup$descriptor() {
        return cn_hashtable_cleanup.DESC;
    }

    public static MethodHandle cn_hashtable_cleanup$handle() {
        return cn_hashtable_cleanup.HANDLE;
    }

    public static MemorySegment cn_hashtable_cleanup$address() {
        return cn_hashtable_cleanup.ADDR;
    }

    public static void cn_hashtable_cleanup(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_hashtable_cleanup.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_cleanup", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_insert$descriptor() {
        return cn_hashtable_insert.DESC;
    }

    public static MethodHandle cn_hashtable_insert$handle() {
        return cn_hashtable_insert.HANDLE;
    }

    public static MemorySegment cn_hashtable_insert$address() {
        return cn_hashtable_insert.ADDR;
    }

    public static MemorySegment cn_hashtable_insert(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_hashtable_insert.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_insert", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_remove$descriptor() {
        return cn_hashtable_remove.DESC;
    }

    public static MethodHandle cn_hashtable_remove$handle() {
        return cn_hashtable_remove.HANDLE;
    }

    public static MemorySegment cn_hashtable_remove$address() {
        return cn_hashtable_remove.ADDR;
    }

    public static void cn_hashtable_remove(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_hashtable_remove.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_remove", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_clear$descriptor() {
        return cn_hashtable_clear.DESC;
    }

    public static MethodHandle cn_hashtable_clear$handle() {
        return cn_hashtable_clear.HANDLE;
    }

    public static MemorySegment cn_hashtable_clear$address() {
        return cn_hashtable_clear.ADDR;
    }

    public static void cn_hashtable_clear(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_hashtable_clear.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_clear", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_find$descriptor() {
        return cn_hashtable_find.DESC;
    }

    public static MethodHandle cn_hashtable_find$handle() {
        return cn_hashtable_find.HANDLE;
    }

    public static MemorySegment cn_hashtable_find$address() {
        return cn_hashtable_find.ADDR;
    }

    public static MemorySegment cn_hashtable_find(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_hashtable_find.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_find", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_count$descriptor() {
        return cn_hashtable_count.DESC;
    }

    public static MethodHandle cn_hashtable_count$handle() {
        return cn_hashtable_count.HANDLE;
    }

    public static MemorySegment cn_hashtable_count$address() {
        return cn_hashtable_count.ADDR;
    }

    public static int cn_hashtable_count(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_hashtable_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_count", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_items$descriptor() {
        return cn_hashtable_items.DESC;
    }

    public static MethodHandle cn_hashtable_items$handle() {
        return cn_hashtable_items.HANDLE;
    }

    public static MemorySegment cn_hashtable_items$address() {
        return cn_hashtable_items.ADDR;
    }

    public static MemorySegment cn_hashtable_items(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_hashtable_items.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_items", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_keys$descriptor() {
        return cn_hashtable_keys.DESC;
    }

    public static MethodHandle cn_hashtable_keys$handle() {
        return cn_hashtable_keys.HANDLE;
    }

    public static MemorySegment cn_hashtable_keys$address() {
        return cn_hashtable_keys.ADDR;
    }

    public static MemorySegment cn_hashtable_keys(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_hashtable_keys.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_keys", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_hashtable_swap$descriptor() {
        return cn_hashtable_swap.DESC;
    }

    public static MethodHandle cn_hashtable_swap$handle() {
        return cn_hashtable_swap.HANDLE;
    }

    public static MemorySegment cn_hashtable_swap$address() {
        return cn_hashtable_swap.ADDR;
    }

    public static void cn_hashtable_swap(MemorySegment memorySegment, int n, int n2) {
        MethodHandle methodHandle = cn_hashtable_swap.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_hashtable_swap", memorySegment, n, n2);
            }
            methodHandle.invokeExact(memorySegment, n, n2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_connect_token_cache_init$descriptor() {
        return cn_protocol_connect_token_cache_init.DESC;
    }

    public static MethodHandle cn_protocol_connect_token_cache_init$handle() {
        return cn_protocol_connect_token_cache_init.HANDLE;
    }

    public static MemorySegment cn_protocol_connect_token_cache_init$address() {
        return cn_protocol_connect_token_cache_init.ADDR;
    }

    public static void cn_protocol_connect_token_cache_init(MemorySegment memorySegment, int n, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_connect_token_cache_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_connect_token_cache_init", memorySegment, n, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, n, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_connect_token_cache_cleanup$descriptor() {
        return cn_protocol_connect_token_cache_cleanup.DESC;
    }

    public static MethodHandle cn_protocol_connect_token_cache_cleanup$handle() {
        return cn_protocol_connect_token_cache_cleanup.HANDLE;
    }

    public static MemorySegment cn_protocol_connect_token_cache_cleanup$address() {
        return cn_protocol_connect_token_cache_cleanup.ADDR;
    }

    public static void cn_protocol_connect_token_cache_cleanup(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_connect_token_cache_cleanup.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_connect_token_cache_cleanup", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_connect_token_cache_find$descriptor() {
        return cn_protocol_connect_token_cache_find.DESC;
    }

    public static MethodHandle cn_protocol_connect_token_cache_find$handle() {
        return cn_protocol_connect_token_cache_find.HANDLE;
    }

    public static MemorySegment cn_protocol_connect_token_cache_find$address() {
        return cn_protocol_connect_token_cache_find.ADDR;
    }

    public static MemorySegment cn_protocol_connect_token_cache_find(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_connect_token_cache_find.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_connect_token_cache_find", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_connect_token_cache_add$descriptor() {
        return cn_protocol_connect_token_cache_add.DESC;
    }

    public static MethodHandle cn_protocol_connect_token_cache_add$handle() {
        return cn_protocol_connect_token_cache_add.HANDLE;
    }

    public static MemorySegment cn_protocol_connect_token_cache_add$address() {
        return cn_protocol_connect_token_cache_add.ADDR;
    }

    public static void cn_protocol_connect_token_cache_add(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_connect_token_cache_add.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_connect_token_cache_add", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_init$descriptor() {
        return cn_protocol_encryption_map_init.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_init$handle() {
        return cn_protocol_encryption_map_init.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_init$address() {
        return cn_protocol_encryption_map_init.ADDR;
    }

    public static void cn_protocol_encryption_map_init(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_encryption_map_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_init", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_cleanup$descriptor() {
        return cn_protocol_encryption_map_cleanup.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_cleanup$handle() {
        return cn_protocol_encryption_map_cleanup.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_cleanup$address() {
        return cn_protocol_encryption_map_cleanup.ADDR;
    }

    public static void cn_protocol_encryption_map_cleanup(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_encryption_map_cleanup.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_cleanup", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_clear$descriptor() {
        return cn_protocol_encryption_map_clear.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_clear$handle() {
        return cn_protocol_encryption_map_clear.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_clear$address() {
        return cn_protocol_encryption_map_clear.ADDR;
    }

    public static void cn_protocol_encryption_map_clear(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_encryption_map_clear.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_clear", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_count$descriptor() {
        return cn_protocol_encryption_map_count.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_count$handle() {
        return cn_protocol_encryption_map_count.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_count$address() {
        return cn_protocol_encryption_map_count.ADDR;
    }

    public static int cn_protocol_encryption_map_count(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_encryption_map_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_count", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_insert$descriptor() {
        return cn_protocol_encryption_map_insert.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_insert$handle() {
        return cn_protocol_encryption_map_insert.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_insert$address() {
        return cn_protocol_encryption_map_insert.ADDR;
    }

    public static void cn_protocol_encryption_map_insert(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_protocol_encryption_map_insert.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_insert", memorySegment, memorySegment2, memorySegment3);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_find$descriptor() {
        return cn_protocol_encryption_map_find.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_find$handle() {
        return cn_protocol_encryption_map_find.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_find$address() {
        return cn_protocol_encryption_map_find.ADDR;
    }

    public static MemorySegment cn_protocol_encryption_map_find(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_encryption_map_find.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_find", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_remove$descriptor() {
        return cn_protocol_encryption_map_remove.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_remove$handle() {
        return cn_protocol_encryption_map_remove.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_remove$address() {
        return cn_protocol_encryption_map_remove.ADDR;
    }

    public static void cn_protocol_encryption_map_remove(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_encryption_map_remove.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_remove", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_get_endpoints$descriptor() {
        return cn_protocol_encryption_map_get_endpoints.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_get_endpoints$handle() {
        return cn_protocol_encryption_map_get_endpoints.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_get_endpoints$address() {
        return cn_protocol_encryption_map_get_endpoints.ADDR;
    }

    public static MemorySegment cn_protocol_encryption_map_get_endpoints(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_encryption_map_get_endpoints.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_get_endpoints", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_get_states$descriptor() {
        return cn_protocol_encryption_map_get_states.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_get_states$handle() {
        return cn_protocol_encryption_map_get_states.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_get_states$address() {
        return cn_protocol_encryption_map_get_states.ADDR;
    }

    public static MemorySegment cn_protocol_encryption_map_get_states(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_encryption_map_get_states.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_get_states", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_encryption_map_look_for_timeouts_or_expirations$descriptor() {
        return cn_protocol_encryption_map_look_for_timeouts_or_expirations.DESC;
    }

    public static MethodHandle cn_protocol_encryption_map_look_for_timeouts_or_expirations$handle() {
        return cn_protocol_encryption_map_look_for_timeouts_or_expirations.HANDLE;
    }

    public static MemorySegment cn_protocol_encryption_map_look_for_timeouts_or_expirations$address() {
        return cn_protocol_encryption_map_look_for_timeouts_or_expirations.ADDR;
    }

    public static void cn_protocol_encryption_map_look_for_timeouts_or_expirations(MemorySegment memorySegment, double d, long l) {
        MethodHandle methodHandle = cn_protocol_encryption_map_look_for_timeouts_or_expirations.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_encryption_map_look_for_timeouts_or_expirations", memorySegment, d, l);
            }
            methodHandle.invokeExact(memorySegment, d, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_protocol_client_state_str$descriptor() {
        return s_protocol_client_state_str.DESC;
    }

    public static MethodHandle s_protocol_client_state_str$handle() {
        return s_protocol_client_state_str.HANDLE;
    }

    public static MemorySegment s_protocol_client_state_str$address() {
        return s_protocol_client_state_str.ADDR;
    }

    public static MemorySegment s_protocol_client_state_str(int n) {
        MethodHandle methodHandle = s_protocol_client_state_str.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_protocol_client_state_str", n);
            }
            return methodHandle.invokeExact(n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_create$descriptor() {
        return cn_protocol_client_create.DESC;
    }

    public static MethodHandle cn_protocol_client_create$handle() {
        return cn_protocol_client_create.HANDLE;
    }

    public static MemorySegment cn_protocol_client_create$address() {
        return cn_protocol_client_create.ADDR;
    }

    public static MemorySegment cn_protocol_client_create(short s, long l, boolean bl, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_create", s, l, bl, memorySegment);
            }
            return methodHandle.invokeExact(s, l, bl, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_destroy$descriptor() {
        return cn_protocol_client_destroy.DESC;
    }

    public static MethodHandle cn_protocol_client_destroy$handle() {
        return cn_protocol_client_destroy.HANDLE;
    }

    public static MemorySegment cn_protocol_client_destroy$address() {
        return cn_protocol_client_destroy.ADDR;
    }

    public static void cn_protocol_client_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_connect$descriptor() {
        return cn_protocol_client_connect.DESC;
    }

    public static MethodHandle cn_protocol_client_connect$handle() {
        return cn_protocol_client_connect.HANDLE;
    }

    public static MemorySegment cn_protocol_client_connect$address() {
        return cn_protocol_client_connect.ADDR;
    }

    public static MemorySegment cn_protocol_client_connect(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_client_connect.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_connect", segmentAllocator, memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_protocol_server_endpoint$descriptor() {
        return s_protocol_server_endpoint.DESC;
    }

    public static MethodHandle s_protocol_server_endpoint$handle() {
        return s_protocol_server_endpoint.HANDLE;
    }

    public static MemorySegment s_protocol_server_endpoint$address() {
        return s_protocol_server_endpoint.ADDR;
    }

    public static MemorySegment s_protocol_server_endpoint(SegmentAllocator segmentAllocator, MemorySegment memorySegment) {
        MethodHandle methodHandle = s_protocol_server_endpoint.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_protocol_server_endpoint", segmentAllocator, memorySegment);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_protocol_packet_str$descriptor() {
        return s_protocol_packet_str.DESC;
    }

    public static MethodHandle s_protocol_packet_str$handle() {
        return s_protocol_packet_str.HANDLE;
    }

    public static MemorySegment s_protocol_packet_str$address() {
        return s_protocol_packet_str.ADDR;
    }

    public static MemorySegment s_protocol_packet_str(byte by) {
        MethodHandle methodHandle = s_protocol_packet_str.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_protocol_packet_str", by);
            }
            return methodHandle.invokeExact(by);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_get_packet$descriptor() {
        return cn_protocol_client_get_packet.DESC;
    }

    public static MethodHandle cn_protocol_client_get_packet$handle() {
        return cn_protocol_client_get_packet.HANDLE;
    }

    public static MemorySegment cn_protocol_client_get_packet$address() {
        return cn_protocol_client_get_packet.ADDR;
    }

    public static boolean cn_protocol_client_get_packet(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3, MemorySegment memorySegment4) {
        MethodHandle methodHandle = cn_protocol_client_get_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_get_packet", memorySegment, memorySegment2, memorySegment3, memorySegment4);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3, memorySegment4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_free_packet$descriptor() {
        return cn_protocol_client_free_packet.DESC;
    }

    public static MethodHandle cn_protocol_client_free_packet$handle() {
        return cn_protocol_client_free_packet.HANDLE;
    }

    public static MemorySegment cn_protocol_client_free_packet$address() {
        return cn_protocol_client_free_packet.ADDR;
    }

    public static void cn_protocol_client_free_packet(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_client_free_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_free_packet", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_disconnect$descriptor() {
        return cn_protocol_client_disconnect.DESC;
    }

    public static MethodHandle cn_protocol_client_disconnect$handle() {
        return cn_protocol_client_disconnect.HANDLE;
    }

    public static MemorySegment cn_protocol_client_disconnect$address() {
        return cn_protocol_client_disconnect.ADDR;
    }

    public static void cn_protocol_client_disconnect(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_disconnect.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_disconnect", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_update$descriptor() {
        return cn_protocol_client_update.DESC;
    }

    public static MethodHandle cn_protocol_client_update$handle() {
        return cn_protocol_client_update.HANDLE;
    }

    public static MemorySegment cn_protocol_client_update$address() {
        return cn_protocol_client_update.ADDR;
    }

    public static void cn_protocol_client_update(MemorySegment memorySegment, double d, long l) {
        MethodHandle methodHandle = cn_protocol_client_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_update", memorySegment, d, l);
            }
            methodHandle.invokeExact(memorySegment, d, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_send$descriptor() {
        return cn_protocol_client_send.DESC;
    }

    public static MethodHandle cn_protocol_client_send$handle() {
        return cn_protocol_client_send.HANDLE;
    }

    public static MemorySegment cn_protocol_client_send$address() {
        return cn_protocol_client_send.ADDR;
    }

    public static MemorySegment cn_protocol_client_send(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_protocol_client_send.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_send", segmentAllocator, memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_get_state$descriptor() {
        return cn_protocol_client_get_state.DESC;
    }

    public static MethodHandle cn_protocol_client_get_state$handle() {
        return cn_protocol_client_get_state.HANDLE;
    }

    public static MemorySegment cn_protocol_client_get_state$address() {
        return cn_protocol_client_get_state.ADDR;
    }

    public static int cn_protocol_client_get_state(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_get_state.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_get_state", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_get_id$descriptor() {
        return cn_protocol_client_get_id.DESC;
    }

    public static MethodHandle cn_protocol_client_get_id$handle() {
        return cn_protocol_client_get_id.HANDLE;
    }

    public static MemorySegment cn_protocol_client_get_id$address() {
        return cn_protocol_client_get_id.ADDR;
    }

    public static long cn_protocol_client_get_id(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_get_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_get_id", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_get_max_clients$descriptor() {
        return cn_protocol_client_get_max_clients.DESC;
    }

    public static MethodHandle cn_protocol_client_get_max_clients$handle() {
        return cn_protocol_client_get_max_clients.HANDLE;
    }

    public static MemorySegment cn_protocol_client_get_max_clients$address() {
        return cn_protocol_client_get_max_clients.ADDR;
    }

    public static int cn_protocol_client_get_max_clients(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_get_max_clients.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_get_max_clients", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_get_server_address$descriptor() {
        return cn_protocol_client_get_server_address.DESC;
    }

    public static MethodHandle cn_protocol_client_get_server_address$handle() {
        return cn_protocol_client_get_server_address.HANDLE;
    }

    public static MemorySegment cn_protocol_client_get_server_address$address() {
        return cn_protocol_client_get_server_address.ADDR;
    }

    public static MemorySegment cn_protocol_client_get_server_address(SegmentAllocator segmentAllocator, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_get_server_address.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_get_server_address", segmentAllocator, memorySegment);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_get_port$descriptor() {
        return cn_protocol_client_get_port.DESC;
    }

    public static MethodHandle cn_protocol_client_get_port$handle() {
        return cn_protocol_client_get_port.HANDLE;
    }

    public static MemorySegment cn_protocol_client_get_port$address() {
        return cn_protocol_client_get_port.ADDR;
    }

    public static short cn_protocol_client_get_port(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_client_get_port.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_get_port", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_client_enable_network_simulator$descriptor() {
        return cn_protocol_client_enable_network_simulator.DESC;
    }

    public static MethodHandle cn_protocol_client_enable_network_simulator$handle() {
        return cn_protocol_client_enable_network_simulator.HANDLE;
    }

    public static MemorySegment cn_protocol_client_enable_network_simulator$address() {
        return cn_protocol_client_enable_network_simulator.ADDR;
    }

    public static void cn_protocol_client_enable_network_simulator(MemorySegment memorySegment, double d, double d2, double d3, double d4) {
        MethodHandle methodHandle = cn_protocol_client_enable_network_simulator.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_client_enable_network_simulator", memorySegment, d, d2, d3, d4);
            }
            methodHandle.invokeExact(memorySegment, d, d2, d3, d4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_handle_allocator_create$descriptor() {
        return cn_handle_allocator_create.DESC;
    }

    public static MethodHandle cn_handle_allocator_create$handle() {
        return cn_handle_allocator_create.HANDLE;
    }

    public static MemorySegment cn_handle_allocator_create$address() {
        return cn_handle_allocator_create.ADDR;
    }

    public static MemorySegment cn_handle_allocator_create(int n, MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_handle_allocator_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_handle_allocator_create", n, memorySegment);
            }
            return methodHandle.invokeExact(n, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_handle_allocator_destroy$descriptor() {
        return cn_handle_allocator_destroy.DESC;
    }

    public static MethodHandle cn_handle_allocator_destroy$handle() {
        return cn_handle_allocator_destroy.HANDLE;
    }

    public static MemorySegment cn_handle_allocator_destroy$address() {
        return cn_handle_allocator_destroy.ADDR;
    }

    public static void cn_handle_allocator_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_handle_allocator_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_handle_allocator_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_handle_allocator_alloc$descriptor() {
        return cn_handle_allocator_alloc.DESC;
    }

    public static MethodHandle cn_handle_allocator_alloc$handle() {
        return cn_handle_allocator_alloc.HANDLE;
    }

    public static MemorySegment cn_handle_allocator_alloc$address() {
        return cn_handle_allocator_alloc.ADDR;
    }

    public static long cn_handle_allocator_alloc(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_handle_allocator_alloc.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_handle_allocator_alloc", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_table_index$descriptor() {
        return s_table_index.DESC;
    }

    public static MethodHandle s_table_index$handle() {
        return s_table_index.HANDLE;
    }

    public static MemorySegment s_table_index$address() {
        return s_table_index.ADDR;
    }

    public static int s_table_index(long l) {
        MethodHandle methodHandle = s_table_index.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_table_index", l);
            }
            return methodHandle.invokeExact(l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_handle_allocator_get_index$descriptor() {
        return cn_handle_allocator_get_index.DESC;
    }

    public static MethodHandle cn_handle_allocator_get_index$handle() {
        return cn_handle_allocator_get_index.HANDLE;
    }

    public static MemorySegment cn_handle_allocator_get_index$address() {
        return cn_handle_allocator_get_index.ADDR;
    }

    public static int cn_handle_allocator_get_index(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = cn_handle_allocator_get_index.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_handle_allocator_get_index", memorySegment, l);
            }
            return methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_handle_allocator_update_index$descriptor() {
        return cn_handle_allocator_update_index.DESC;
    }

    public static MethodHandle cn_handle_allocator_update_index$handle() {
        return cn_handle_allocator_update_index.HANDLE;
    }

    public static MemorySegment cn_handle_allocator_update_index$address() {
        return cn_handle_allocator_update_index.ADDR;
    }

    public static void cn_handle_allocator_update_index(MemorySegment memorySegment, long l, int n) {
        MethodHandle methodHandle = cn_handle_allocator_update_index.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_handle_allocator_update_index", memorySegment, l, n);
            }
            methodHandle.invokeExact(memorySegment, l, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_handle_allocator_free$descriptor() {
        return cn_handle_allocator_free.DESC;
    }

    public static MethodHandle cn_handle_allocator_free$handle() {
        return cn_handle_allocator_free.HANDLE;
    }

    public static MemorySegment cn_handle_allocator_free$address() {
        return cn_handle_allocator_free.ADDR;
    }

    public static void cn_handle_allocator_free(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = cn_handle_allocator_free.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_handle_allocator_free", memorySegment, l);
            }
            methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_handle_allocator_is_handle_valid$descriptor() {
        return cn_handle_allocator_is_handle_valid.DESC;
    }

    public static MethodHandle cn_handle_allocator_is_handle_valid$handle() {
        return cn_handle_allocator_is_handle_valid.HANDLE;
    }

    public static MemorySegment cn_handle_allocator_is_handle_valid$address() {
        return cn_handle_allocator_is_handle_valid.ADDR;
    }

    public static int cn_handle_allocator_is_handle_valid(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = cn_handle_allocator_is_handle_valid.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_handle_allocator_is_handle_valid", memorySegment, l);
            }
            return methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_create$descriptor() {
        return cn_protocol_server_create.DESC;
    }

    public static MethodHandle cn_protocol_server_create$handle() {
        return cn_protocol_server_create.HANDLE;
    }

    public static MemorySegment cn_protocol_server_create$address() {
        return cn_protocol_server_create.ADDR;
    }

    public static MemorySegment cn_protocol_server_create(long l, MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_protocol_server_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_create", l, memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(l, memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_destroy$descriptor() {
        return cn_protocol_server_destroy.DESC;
    }

    public static MethodHandle cn_protocol_server_destroy$handle() {
        return cn_protocol_server_destroy.HANDLE;
    }

    public static MemorySegment cn_protocol_server_destroy$address() {
        return cn_protocol_server_destroy.ADDR;
    }

    public static void cn_protocol_server_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_server_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_start$descriptor() {
        return cn_protocol_server_start.DESC;
    }

    public static MethodHandle cn_protocol_server_start$handle() {
        return cn_protocol_server_start.HANDLE;
    }

    public static MemorySegment cn_protocol_server_start$address() {
        return cn_protocol_server_start.ADDR;
    }

    public static MemorySegment cn_protocol_server_start(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_protocol_server_start.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_start", segmentAllocator, memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_protocol_server_event_pull$descriptor() {
        return s_protocol_server_event_pull.DESC;
    }

    public static MethodHandle s_protocol_server_event_pull$handle() {
        return s_protocol_server_event_pull.HANDLE;
    }

    public static MemorySegment s_protocol_server_event_pull$address() {
        return s_protocol_server_event_pull.ADDR;
    }

    public static int s_protocol_server_event_pull(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = s_protocol_server_event_pull.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_protocol_server_event_pull", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_protocol_server_event_push$descriptor() {
        return s_protocol_server_event_push.DESC;
    }

    public static MethodHandle s_protocol_server_event_push$handle() {
        return s_protocol_server_event_push.HANDLE;
    }

    public static MemorySegment s_protocol_server_event_push$address() {
        return s_protocol_server_event_push.ADDR;
    }

    public static int s_protocol_server_event_push(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = s_protocol_server_event_push.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_protocol_server_event_push", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_pop_event$descriptor() {
        return cn_protocol_server_pop_event.DESC;
    }

    public static MethodHandle cn_protocol_server_pop_event$handle() {
        return cn_protocol_server_pop_event.HANDLE;
    }

    public static MemorySegment cn_protocol_server_pop_event$address() {
        return cn_protocol_server_pop_event.ADDR;
    }

    public static boolean cn_protocol_server_pop_event(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_server_pop_event.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_pop_event", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_free_packet$descriptor() {
        return cn_protocol_server_free_packet.DESC;
    }

    public static MethodHandle cn_protocol_server_free_packet$handle() {
        return cn_protocol_server_free_packet.HANDLE;
    }

    public static MemorySegment cn_protocol_server_free_packet$address() {
        return cn_protocol_server_free_packet.ADDR;
    }

    public static void cn_protocol_server_free_packet(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_protocol_server_free_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_free_packet", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_stop$descriptor() {
        return cn_protocol_server_stop.DESC;
    }

    public static MethodHandle cn_protocol_server_stop$handle() {
        return cn_protocol_server_stop.HANDLE;
    }

    public static MemorySegment cn_protocol_server_stop$address() {
        return cn_protocol_server_stop.ADDR;
    }

    public static void cn_protocol_server_stop(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_server_stop.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_stop", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_running$descriptor() {
        return cn_protocol_server_running.DESC;
    }

    public static MethodHandle cn_protocol_server_running$handle() {
        return cn_protocol_server_running.HANDLE;
    }

    public static MemorySegment cn_protocol_server_running$address() {
        return cn_protocol_server_running.ADDR;
    }

    public static boolean cn_protocol_server_running(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_server_running.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_running", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_disconnect_client$descriptor() {
        return cn_protocol_server_disconnect_client.DESC;
    }

    public static MethodHandle cn_protocol_server_disconnect_client$handle() {
        return cn_protocol_server_disconnect_client.HANDLE;
    }

    public static MemorySegment cn_protocol_server_disconnect_client$address() {
        return cn_protocol_server_disconnect_client.ADDR;
    }

    public static void cn_protocol_server_disconnect_client(MemorySegment memorySegment, int n, boolean bl) {
        MethodHandle methodHandle = cn_protocol_server_disconnect_client.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_disconnect_client", memorySegment, n, bl);
            }
            methodHandle.invokeExact(memorySegment, n, bl);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_send_to_client$descriptor() {
        return cn_protocol_server_send_to_client.DESC;
    }

    public static MethodHandle cn_protocol_server_send_to_client$handle() {
        return cn_protocol_server_send_to_client.HANDLE;
    }

    public static MemorySegment cn_protocol_server_send_to_client$address() {
        return cn_protocol_server_send_to_client.ADDR;
    }

    public static MemorySegment cn_protocol_server_send_to_client(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n, int n2) {
        MethodHandle methodHandle = cn_protocol_server_send_to_client.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_send_to_client", segmentAllocator, memorySegment, memorySegment2, n, n2);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n, n2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_update$descriptor() {
        return cn_protocol_server_update.DESC;
    }

    public static MethodHandle cn_protocol_server_update$handle() {
        return cn_protocol_server_update.HANDLE;
    }

    public static MemorySegment cn_protocol_server_update$address() {
        return cn_protocol_server_update.ADDR;
    }

    public static void cn_protocol_server_update(MemorySegment memorySegment, double d, long l) {
        MethodHandle methodHandle = cn_protocol_server_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_update", memorySegment, d, l);
            }
            methodHandle.invokeExact(memorySegment, d, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_client_count$descriptor() {
        return cn_protocol_server_client_count.DESC;
    }

    public static MethodHandle cn_protocol_server_client_count$handle() {
        return cn_protocol_server_client_count.HANDLE;
    }

    public static MemorySegment cn_protocol_server_client_count$address() {
        return cn_protocol_server_client_count.ADDR;
    }

    public static int cn_protocol_server_client_count(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_protocol_server_client_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_client_count", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_get_client_id$descriptor() {
        return cn_protocol_server_get_client_id.DESC;
    }

    public static MethodHandle cn_protocol_server_get_client_id$handle() {
        return cn_protocol_server_get_client_id.HANDLE;
    }

    public static MemorySegment cn_protocol_server_get_client_id$address() {
        return cn_protocol_server_get_client_id.ADDR;
    }

    public static long cn_protocol_server_get_client_id(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_protocol_server_get_client_id.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_get_client_id", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_is_client_connected$descriptor() {
        return cn_protocol_server_is_client_connected.DESC;
    }

    public static MethodHandle cn_protocol_server_is_client_connected$handle() {
        return cn_protocol_server_is_client_connected.HANDLE;
    }

    public static MemorySegment cn_protocol_server_is_client_connected$address() {
        return cn_protocol_server_is_client_connected.ADDR;
    }

    public static boolean cn_protocol_server_is_client_connected(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_protocol_server_is_client_connected.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_is_client_connected", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_protocol_server_enable_network_simulator$descriptor() {
        return cn_protocol_server_enable_network_simulator.DESC;
    }

    public static MethodHandle cn_protocol_server_enable_network_simulator$handle() {
        return cn_protocol_server_enable_network_simulator.HANDLE;
    }

    public static MemorySegment cn_protocol_server_enable_network_simulator$address() {
        return cn_protocol_server_enable_network_simulator.ADDR;
    }

    public static void cn_protocol_server_enable_network_simulator(MemorySegment memorySegment, double d, double d2, double d3, double d4) {
        MethodHandle methodHandle = cn_protocol_server_enable_network_simulator.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_protocol_server_enable_network_simulator", memorySegment, d, d2, d3, d4);
            }
            methodHandle.invokeExact(memorySegment, d, d2, d3, d4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static int CN_ACK_SYSTEM_COUNTERS_PACKETS_SENT() {
        return 0;
    }

    public static int CN_ACK_SYSTEM_COUNTERS_PACKETS_RECEIVED() {
        return 1;
    }

    public static int CN_ACK_SYSTEM_COUNTERS_PACKETS_ACKED() {
        return 2;
    }

    public static int CN_ACK_SYSTEM_COUNTERS_PACKETS_STALE() {
        return 3;
    }

    public static int CN_ACK_SYSTEM_COUNTERS_PACKETS_INVALID() {
        return 4;
    }

    public static int CN_ACK_SYSTEM_COUNTERS_PACKETS_TOO_LARGE_TO_SEND() {
        return 5;
    }

    public static int CN_ACK_SYSTEM_COUNTERS_PACKETS_TOO_LARGE_TO_RECEIVE() {
        return 6;
    }

    public static int CN_ACK_SYSTEM_COUNTERS_MAX() {
        return 7;
    }

    public static FunctionDescriptor cn_sequence_buffer_remove$descriptor() {
        return cn_sequence_buffer_remove.DESC;
    }

    public static MethodHandle cn_sequence_buffer_remove$handle() {
        return cn_sequence_buffer_remove.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_remove$address() {
        return cn_sequence_buffer_remove.ADDR;
    }

    public static void cn_sequence_buffer_remove(MemorySegment memorySegment, short s, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_sequence_buffer_remove.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_remove", memorySegment, s, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, s, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_sequence_buffer_reset$descriptor() {
        return cn_sequence_buffer_reset.DESC;
    }

    public static MethodHandle cn_sequence_buffer_reset$handle() {
        return cn_sequence_buffer_reset.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_reset$address() {
        return cn_sequence_buffer_reset.ADDR;
    }

    public static void cn_sequence_buffer_reset(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_sequence_buffer_reset.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_reset", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_sequence_buffer_init$descriptor() {
        return cn_sequence_buffer_init.DESC;
    }

    public static MethodHandle cn_sequence_buffer_init$handle() {
        return cn_sequence_buffer_init.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_init$address() {
        return cn_sequence_buffer_init.ADDR;
    }

    public static int cn_sequence_buffer_init(MemorySegment memorySegment, int n, int n2, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_sequence_buffer_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_init", memorySegment, n, n2, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, n, n2, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_sequence_buffer_cleanup$descriptor() {
        return cn_sequence_buffer_cleanup.DESC;
    }

    public static MethodHandle cn_sequence_buffer_cleanup$handle() {
        return cn_sequence_buffer_cleanup.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_cleanup$address() {
        return cn_sequence_buffer_cleanup.ADDR;
    }

    public static void cn_sequence_buffer_cleanup(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_sequence_buffer_cleanup.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_cleanup", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_sequence_greater_than$descriptor() {
        return s_sequence_greater_than.DESC;
    }

    public static MethodHandle s_sequence_greater_than$handle() {
        return s_sequence_greater_than.HANDLE;
    }

    public static MemorySegment s_sequence_greater_than$address() {
        return s_sequence_greater_than.ADDR;
    }

    public static int s_sequence_greater_than(short s, short s2) {
        MethodHandle methodHandle = s_sequence_greater_than.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_sequence_greater_than", s, s2);
            }
            return methodHandle.invokeExact(s, s2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_sequence_less_than$descriptor() {
        return s_sequence_less_than.DESC;
    }

    public static MethodHandle s_sequence_less_than$handle() {
        return s_sequence_less_than.HANDLE;
    }

    public static MemorySegment s_sequence_less_than$address() {
        return s_sequence_less_than.ADDR;
    }

    public static int s_sequence_less_than(short s, short s2) {
        MethodHandle methodHandle = s_sequence_less_than.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_sequence_less_than", s, s2);
            }
            return methodHandle.invokeExact(s, s2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_sequence_is_stale$descriptor() {
        return s_sequence_is_stale.DESC;
    }

    public static MethodHandle s_sequence_is_stale$handle() {
        return s_sequence_is_stale.HANDLE;
    }

    public static MemorySegment s_sequence_is_stale$address() {
        return s_sequence_is_stale.ADDR;
    }

    public static int s_sequence_is_stale(MemorySegment memorySegment, short s) {
        MethodHandle methodHandle = s_sequence_is_stale.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_sequence_is_stale", memorySegment, s);
            }
            return methodHandle.invokeExact(memorySegment, s);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_sequence_buffer_insert$descriptor() {
        return cn_sequence_buffer_insert.DESC;
    }

    public static MethodHandle cn_sequence_buffer_insert$handle() {
        return cn_sequence_buffer_insert.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_insert$address() {
        return cn_sequence_buffer_insert.ADDR;
    }

    public static MemorySegment cn_sequence_buffer_insert(MemorySegment memorySegment, short s, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_sequence_buffer_insert.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_insert", memorySegment, s, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, s, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_sequence_buffer_is_empty$descriptor() {
        return cn_sequence_buffer_is_empty.DESC;
    }

    public static MethodHandle cn_sequence_buffer_is_empty$handle() {
        return cn_sequence_buffer_is_empty.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_is_empty$address() {
        return cn_sequence_buffer_is_empty.ADDR;
    }

    public static int cn_sequence_buffer_is_empty(MemorySegment memorySegment, short s) {
        MethodHandle methodHandle = cn_sequence_buffer_is_empty.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_is_empty", memorySegment, s);
            }
            return methodHandle.invokeExact(memorySegment, s);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_sequence_buffer_find$descriptor() {
        return cn_sequence_buffer_find.DESC;
    }

    public static MethodHandle cn_sequence_buffer_find$handle() {
        return cn_sequence_buffer_find.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_find$address() {
        return cn_sequence_buffer_find.ADDR;
    }

    public static MemorySegment cn_sequence_buffer_find(MemorySegment memorySegment, short s) {
        MethodHandle methodHandle = cn_sequence_buffer_find.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_find", memorySegment, s);
            }
            return methodHandle.invokeExact(memorySegment, s);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_sequence_buffer_generate_ack_bits$descriptor() {
        return cn_sequence_buffer_generate_ack_bits.DESC;
    }

    public static MethodHandle cn_sequence_buffer_generate_ack_bits$handle() {
        return cn_sequence_buffer_generate_ack_bits.HANDLE;
    }

    public static MemorySegment cn_sequence_buffer_generate_ack_bits$address() {
        return cn_sequence_buffer_generate_ack_bits.ADDR;
    }

    public static void cn_sequence_buffer_generate_ack_bits(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_sequence_buffer_generate_ack_bits.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_sequence_buffer_generate_ack_bits", memorySegment, memorySegment2, memorySegment3);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_packet_queue_init$descriptor() {
        return cn_packet_queue_init.DESC;
    }

    public static MethodHandle cn_packet_queue_init$handle() {
        return cn_packet_queue_init.HANDLE;
    }

    public static MemorySegment cn_packet_queue_init$address() {
        return cn_packet_queue_init.ADDR;
    }

    public static void cn_packet_queue_init(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_packet_queue_init.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_packet_queue_init", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_packet_queue_push$descriptor() {
        return cn_packet_queue_push.DESC;
    }

    public static MethodHandle cn_packet_queue_push$handle() {
        return cn_packet_queue_push.HANDLE;
    }

    public static MemorySegment cn_packet_queue_push$address() {
        return cn_packet_queue_push.ADDR;
    }

    public static int cn_packet_queue_push(MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_packet_queue_push.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_packet_queue_push", memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_packet_queue_pop$descriptor() {
        return cn_packet_queue_pop.DESC;
    }

    public static MethodHandle cn_packet_queue_pop$handle() {
        return cn_packet_queue_pop.HANDLE;
    }

    public static MemorySegment cn_packet_queue_pop$address() {
        return cn_packet_queue_pop.ADDR;
    }

    public static int cn_packet_queue_pop(MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_packet_queue_pop.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_packet_queue_pop", memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_create$descriptor() {
        return cn_ack_system_create.DESC;
    }

    public static MethodHandle cn_ack_system_create$handle() {
        return cn_ack_system_create.HANDLE;
    }

    public static MemorySegment cn_ack_system_create$address() {
        return cn_ack_system_create.ADDR;
    }

    public static MemorySegment cn_ack_system_create(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_create", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_destroy$descriptor() {
        return cn_ack_system_destroy.DESC;
    }

    public static MethodHandle cn_ack_system_destroy$handle() {
        return cn_ack_system_destroy.HANDLE;
    }

    public static MemorySegment cn_ack_system_destroy$address() {
        return cn_ack_system_destroy.ADDR;
    }

    public static void cn_ack_system_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_reset$descriptor() {
        return cn_ack_system_reset.DESC;
    }

    public static MethodHandle cn_ack_system_reset$handle() {
        return cn_ack_system_reset.HANDLE;
    }

    public static MemorySegment cn_ack_system_reset$address() {
        return cn_ack_system_reset.ADDR;
    }

    public static void cn_ack_system_reset(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_reset.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_reset", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_send_packet$descriptor() {
        return cn_ack_system_send_packet.DESC;
    }

    public static MethodHandle cn_ack_system_send_packet$handle() {
        return cn_ack_system_send_packet.HANDLE;
    }

    public static MemorySegment cn_ack_system_send_packet$address() {
        return cn_ack_system_send_packet.ADDR;
    }

    public static MemorySegment cn_ack_system_send_packet(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_ack_system_send_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_send_packet", segmentAllocator, memorySegment, memorySegment2, n, memorySegment3);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_get_sequence$descriptor() {
        return cn_ack_system_get_sequence.DESC;
    }

    public static MethodHandle cn_ack_system_get_sequence$handle() {
        return cn_ack_system_get_sequence.HANDLE;
    }

    public static MemorySegment cn_ack_system_get_sequence$address() {
        return cn_ack_system_get_sequence.ADDR;
    }

    public static short cn_ack_system_get_sequence(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_get_sequence.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_get_sequence", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_receive_packet$descriptor() {
        return cn_ack_system_receive_packet.DESC;
    }

    public static MethodHandle cn_ack_system_receive_packet$handle() {
        return cn_ack_system_receive_packet.HANDLE;
    }

    public static MemorySegment cn_ack_system_receive_packet$address() {
        return cn_ack_system_receive_packet.ADDR;
    }

    public static MemorySegment cn_ack_system_receive_packet(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_ack_system_receive_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_receive_packet", segmentAllocator, memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_get_acks$descriptor() {
        return cn_ack_system_get_acks.DESC;
    }

    public static MethodHandle cn_ack_system_get_acks$handle() {
        return cn_ack_system_get_acks.HANDLE;
    }

    public static MemorySegment cn_ack_system_get_acks$address() {
        return cn_ack_system_get_acks.ADDR;
    }

    public static MemorySegment cn_ack_system_get_acks(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_get_acks.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_get_acks", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_get_acks_count$descriptor() {
        return cn_ack_system_get_acks_count.DESC;
    }

    public static MethodHandle cn_ack_system_get_acks_count$handle() {
        return cn_ack_system_get_acks_count.HANDLE;
    }

    public static MemorySegment cn_ack_system_get_acks_count$address() {
        return cn_ack_system_get_acks_count.ADDR;
    }

    public static int cn_ack_system_get_acks_count(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_get_acks_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_get_acks_count", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_clear_acks$descriptor() {
        return cn_ack_system_clear_acks.DESC;
    }

    public static MethodHandle cn_ack_system_clear_acks$handle() {
        return cn_ack_system_clear_acks.HANDLE;
    }

    public static MemorySegment cn_ack_system_clear_acks$address() {
        return cn_ack_system_clear_acks.ADDR;
    }

    public static void cn_ack_system_clear_acks(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_clear_acks.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_clear_acks", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_calc_packet_loss$descriptor() {
        return s_calc_packet_loss.DESC;
    }

    public static MethodHandle s_calc_packet_loss$handle() {
        return s_calc_packet_loss.HANDLE;
    }

    public static MemorySegment s_calc_packet_loss$address() {
        return s_calc_packet_loss.ADDR;
    }

    public static double s_calc_packet_loss(double d, MemorySegment memorySegment) {
        MethodHandle methodHandle = s_calc_packet_loss.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_calc_packet_loss", d, memorySegment);
            }
            return methodHandle.invokeExact(d, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_calc_bandwidth$descriptor() {
        return s_calc_bandwidth.DESC;
    }

    public static MethodHandle s_calc_bandwidth$handle() {
        return s_calc_bandwidth.HANDLE;
    }

    public static MemorySegment s_calc_bandwidth$address() {
        return s_calc_bandwidth.ADDR;
    }

    public static double s_calc_bandwidth(double d, MemorySegment memorySegment) {
        MethodHandle methodHandle = s_calc_bandwidth.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_calc_bandwidth", d, memorySegment);
            }
            return methodHandle.invokeExact(d, memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_update$descriptor() {
        return cn_ack_system_update.DESC;
    }

    public static MethodHandle cn_ack_system_update$handle() {
        return cn_ack_system_update.HANDLE;
    }

    public static MemorySegment cn_ack_system_update$address() {
        return cn_ack_system_update.ADDR;
    }

    public static void cn_ack_system_update(MemorySegment memorySegment, double d) {
        MethodHandle methodHandle = cn_ack_system_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_update", memorySegment, d);
            }
            methodHandle.invokeExact(memorySegment, d);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_rtt$descriptor() {
        return cn_ack_system_rtt.DESC;
    }

    public static MethodHandle cn_ack_system_rtt$handle() {
        return cn_ack_system_rtt.HANDLE;
    }

    public static MemorySegment cn_ack_system_rtt$address() {
        return cn_ack_system_rtt.ADDR;
    }

    public static double cn_ack_system_rtt(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_rtt.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_rtt", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_packet_loss$descriptor() {
        return cn_ack_system_packet_loss.DESC;
    }

    public static MethodHandle cn_ack_system_packet_loss$handle() {
        return cn_ack_system_packet_loss.HANDLE;
    }

    public static MemorySegment cn_ack_system_packet_loss$address() {
        return cn_ack_system_packet_loss.ADDR;
    }

    public static double cn_ack_system_packet_loss(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_packet_loss.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_packet_loss", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_bandwidth_outgoing_kbps$descriptor() {
        return cn_ack_system_bandwidth_outgoing_kbps.DESC;
    }

    public static MethodHandle cn_ack_system_bandwidth_outgoing_kbps$handle() {
        return cn_ack_system_bandwidth_outgoing_kbps.HANDLE;
    }

    public static MemorySegment cn_ack_system_bandwidth_outgoing_kbps$address() {
        return cn_ack_system_bandwidth_outgoing_kbps.ADDR;
    }

    public static double cn_ack_system_bandwidth_outgoing_kbps(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_bandwidth_outgoing_kbps.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_bandwidth_outgoing_kbps", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_bandwidth_incoming_kbps$descriptor() {
        return cn_ack_system_bandwidth_incoming_kbps.DESC;
    }

    public static MethodHandle cn_ack_system_bandwidth_incoming_kbps$handle() {
        return cn_ack_system_bandwidth_incoming_kbps.HANDLE;
    }

    public static MemorySegment cn_ack_system_bandwidth_incoming_kbps$address() {
        return cn_ack_system_bandwidth_incoming_kbps.ADDR;
    }

    public static double cn_ack_system_bandwidth_incoming_kbps(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_ack_system_bandwidth_incoming_kbps.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_bandwidth_incoming_kbps", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_ack_system_get_counter$descriptor() {
        return cn_ack_system_get_counter.DESC;
    }

    public static MethodHandle cn_ack_system_get_counter$handle() {
        return cn_ack_system_get_counter.HANDLE;
    }

    public static MemorySegment cn_ack_system_get_counter$address() {
        return cn_ack_system_get_counter.ADDR;
    }

    public static long cn_ack_system_get_counter(MemorySegment memorySegment, int n) {
        MethodHandle methodHandle = cn_ack_system_get_counter.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_ack_system_get_counter", memorySegment, n);
            }
            return methodHandle.invokeExact(memorySegment, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_create$descriptor() {
        return cn_transport_create.DESC;
    }

    public static MethodHandle cn_transport_create$handle() {
        return cn_transport_create.HANDLE;
    }

    public static MemorySegment cn_transport_create$address() {
        return cn_transport_create.ADDR;
    }

    public static MemorySegment cn_transport_create(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_transport_create.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_create", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_destroy$descriptor() {
        return cn_transport_destroy.DESC;
    }

    public static MethodHandle cn_transport_destroy$handle() {
        return cn_transport_destroy.HANDLE;
    }

    public static MemorySegment cn_transport_destroy$address() {
        return cn_transport_destroy.ADDR;
    }

    public static void cn_transport_destroy(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_transport_destroy.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_destroy", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_transport_write_header$descriptor() {
        return s_transport_write_header.DESC;
    }

    public static MethodHandle s_transport_write_header$handle() {
        return s_transport_write_header.HANDLE;
    }

    public static MemorySegment s_transport_write_header$address() {
        return s_transport_write_header.ADDR;
    }

    public static int s_transport_write_header(MemorySegment memorySegment, int n, byte by, short s, short s2, short s3, short s4) {
        MethodHandle methodHandle = s_transport_write_header.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_transport_write_header", memorySegment, n, by, s, s2, s3, s4);
            }
            return methodHandle.invokeExact(memorySegment, n, by, s, s2, s3, s4);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_transport_send_reliably$descriptor() {
        return s_transport_send_reliably.DESC;
    }

    public static MethodHandle s_transport_send_reliably$handle() {
        return s_transport_send_reliably.HANDLE;
    }

    public static MemorySegment s_transport_send_reliably$address() {
        return s_transport_send_reliably.ADDR;
    }

    public static MemorySegment s_transport_send_reliably(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = s_transport_send_reliably.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_transport_send_reliably", segmentAllocator, memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_transport_send$descriptor() {
        return s_transport_send.DESC;
    }

    public static MethodHandle s_transport_send$handle() {
        return s_transport_send.HANDLE;
    }

    public static MemorySegment s_transport_send$address() {
        return s_transport_send.ADDR;
    }

    public static MemorySegment s_transport_send(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = s_transport_send.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_transport_send", segmentAllocator, memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_send$descriptor() {
        return cn_transport_send.DESC;
    }

    public static MethodHandle cn_transport_send$handle() {
        return cn_transport_send.HANDLE;
    }

    public static MemorySegment cn_transport_send$address() {
        return cn_transport_send.ADDR;
    }

    public static MemorySegment cn_transport_send(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n, boolean bl) {
        MethodHandle methodHandle = cn_transport_send.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_send", segmentAllocator, memorySegment, memorySegment2, n, bl);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n, bl);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_receive_reliably_and_in_order$descriptor() {
        return cn_transport_receive_reliably_and_in_order.DESC;
    }

    public static MethodHandle cn_transport_receive_reliably_and_in_order$handle() {
        return cn_transport_receive_reliably_and_in_order.HANDLE;
    }

    public static MemorySegment cn_transport_receive_reliably_and_in_order$address() {
        return cn_transport_receive_reliably_and_in_order.ADDR;
    }

    public static MemorySegment cn_transport_receive_reliably_and_in_order(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_transport_receive_reliably_and_in_order.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_receive_reliably_and_in_order", segmentAllocator, memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_receive_fire_and_forget$descriptor() {
        return cn_transport_receive_fire_and_forget.DESC;
    }

    public static MethodHandle cn_transport_receive_fire_and_forget$handle() {
        return cn_transport_receive_fire_and_forget.HANDLE;
    }

    public static MemorySegment cn_transport_receive_fire_and_forget$address() {
        return cn_transport_receive_fire_and_forget.ADDR;
    }

    public static MemorySegment cn_transport_receive_fire_and_forget(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, MemorySegment memorySegment3) {
        MethodHandle methodHandle = cn_transport_receive_fire_and_forget.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_receive_fire_and_forget", segmentAllocator, memorySegment, memorySegment2, memorySegment3);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, memorySegment3);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_free_packet$descriptor() {
        return cn_transport_free_packet.DESC;
    }

    public static MethodHandle cn_transport_free_packet$handle() {
        return cn_transport_free_packet.HANDLE;
    }

    public static MemorySegment cn_transport_free_packet$address() {
        return cn_transport_free_packet.ADDR;
    }

    public static void cn_transport_free_packet(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = cn_transport_free_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_free_packet", memorySegment, memorySegment2);
            }
            methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_process_packet$descriptor() {
        return cn_transport_process_packet.DESC;
    }

    public static MethodHandle cn_transport_process_packet$handle() {
        return cn_transport_process_packet.HANDLE;
    }

    public static MemorySegment cn_transport_process_packet$address() {
        return cn_transport_process_packet.ADDR;
    }

    public static MemorySegment cn_transport_process_packet(SegmentAllocator segmentAllocator, MemorySegment memorySegment, MemorySegment memorySegment2, int n) {
        MethodHandle methodHandle = cn_transport_process_packet.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_process_packet", segmentAllocator, memorySegment, memorySegment2, n);
            }
            return methodHandle.invokeExact(segmentAllocator, memorySegment, memorySegment2, n);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_remove_flight_fragment$descriptor() {
        return cn_transport_remove_flight_fragment.DESC;
    }

    public static MethodHandle cn_transport_remove_flight_fragment$handle() {
        return cn_transport_remove_flight_fragment.HANDLE;
    }

    public static MemorySegment cn_transport_remove_flight_fragment$address() {
        return cn_transport_remove_flight_fragment.ADDR;
    }

    public static void cn_transport_remove_flight_fragment(MemorySegment memorySegment, long l) {
        MethodHandle methodHandle = cn_transport_remove_flight_fragment.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_remove_flight_fragment", memorySegment, l);
            }
            methodHandle.invokeExact(memorySegment, l);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_process_acks$descriptor() {
        return cn_transport_process_acks.DESC;
    }

    public static MethodHandle cn_transport_process_acks$handle() {
        return cn_transport_process_acks.HANDLE;
    }

    public static MemorySegment cn_transport_process_acks$address() {
        return cn_transport_process_acks.ADDR;
    }

    public static void cn_transport_process_acks(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_transport_process_acks.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_process_acks", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_send_fragments$descriptor() {
        return cn_transport_send_fragments.DESC;
    }

    public static MethodHandle cn_transport_send_fragments$handle() {
        return cn_transport_send_fragments.HANDLE;
    }

    public static MemorySegment cn_transport_send_fragments$address() {
        return cn_transport_send_fragments.ADDR;
    }

    public static void cn_transport_send_fragments(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_transport_send_fragments.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_send_fragments", memorySegment);
            }
            methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_unacked_fragment_count$descriptor() {
        return cn_transport_unacked_fragment_count.DESC;
    }

    public static MethodHandle cn_transport_unacked_fragment_count$handle() {
        return cn_transport_unacked_fragment_count.HANDLE;
    }

    public static MemorySegment cn_transport_unacked_fragment_count$address() {
        return cn_transport_unacked_fragment_count.ADDR;
    }

    public static int cn_transport_unacked_fragment_count(MemorySegment memorySegment) {
        MethodHandle methodHandle = cn_transport_unacked_fragment_count.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_unacked_fragment_count", memorySegment);
            }
            return methodHandle.invokeExact(memorySegment);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor cn_transport_update$descriptor() {
        return cn_transport_update.DESC;
    }

    public static MethodHandle cn_transport_update$handle() {
        return cn_transport_update.HANDLE;
    }

    public static MemorySegment cn_transport_update$address() {
        return cn_transport_update.ADDR;
    }

    public static void cn_transport_update(MemorySegment memorySegment, double d) {
        MethodHandle methodHandle = cn_transport_update.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("cn_transport_update", memorySegment, d);
            }
            methodHandle.invokeExact(memorySegment, d);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_server_event_pull$descriptor() {
        return s_server_event_pull.DESC;
    }

    public static MethodHandle s_server_event_pull$handle() {
        return s_server_event_pull.HANDLE;
    }

    public static MemorySegment s_server_event_pull$address() {
        return s_server_event_pull.ADDR;
    }

    public static int s_server_event_pull(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = s_server_event_pull.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_server_event_pull", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static FunctionDescriptor s_server_event_push$descriptor() {
        return s_server_event_push.DESC;
    }

    public static MethodHandle s_server_event_push$handle() {
        return s_server_event_push.HANDLE;
    }

    public static MemorySegment s_server_event_push$address() {
        return s_server_event_push.ADDR;
    }

    public static int s_server_event_push(MemorySegment memorySegment, MemorySegment memorySegment2) {
        MethodHandle methodHandle = s_server_event_push.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                netcode.traceDowncall("s_server_event_push", memorySegment, memorySegment2);
            }
            return methodHandle.invokeExact(memorySegment, memorySegment2);
        }
        catch (Throwable throwable) {
            throw new AssertionError("should not reach here", throwable);
        }
    }

    public static int CN_ERROR_SUCCESS() {
        return 0;
    }

    public static int CN_ERROR_FAILURE() {
        return -1;
    }

    public static int CN_CRYPTO_HEADER_BYTES() {
        return 36;
    }

    public static int CN_MB() {
        return 0x100000;
    }

    public static int hydro_secretbox_HEADERBYTES() {
        return 36;
    }

    public static int hydro_kx_N_PACKET1BYTES() {
        return 48;
    }

    public static int hydro_kx_KK_PACKET1BYTES() {
        return 48;
    }

    public static int hydro_kx_KK_PACKET2BYTES() {
        return 48;
    }

    public static int hydro_kx_XX_PACKET1BYTES() {
        return 48;
    }

    public static int hydro_kx_XX_PACKET2BYTES() {
        return 96;
    }

    public static int hydro_kx_XX_PACKET3BYTES() {
        return 64;
    }

    public static int hydro_kx_NK_PACKET1BYTES() {
        return 48;
    }

    public static int hydro_kx_NK_PACKET2BYTES() {
        return 48;
    }

    public static int hydro_x25519_NLIMBS() {
        return 4;
    }

    public static int hydro_kx_AEAD_KEYBYTES() {
        return 32;
    }

    public static MemorySegment hydro_kx_CONTEXT() {
        class Holder {
            static final MemorySegment hydro_kx_CONTEXT = LIBRARY_ARENA.allocateFrom("hydro_kx");

            Holder() {
            }
        }
        return Holder.hydro_kx_CONTEXT;
    }

    public static int hydro_pwhash_PARAMSBYTES() {
        return 66;
    }

    public static MemorySegment hydro_pwhash_CONTEXT() {
        class Holder {
            static final MemorySegment hydro_pwhash_CONTEXT = LIBRARY_ARENA.allocateFrom("hydro_pw");

            Holder() {
            }
        }
        return Holder.hydro_pwhash_CONTEXT;
    }

    public static int CN_PROTOCOL_VERSION_STRING_LEN() {
        return 10;
    }

    public static int CN_PROTOCOL_PACKET_SIZE_MAX() {
        return 1280;
    }

    public static int CN_PROTOCOL_PACKET_PAYLOAD_MAX() {
        return 1205;
    }

    public static int CN_PROTOCOL_CLIENT_SEND_BUFFER_SIZE() {
        return 262144;
    }

    public static int CN_PROTOCOL_CLIENT_RECEIVE_BUFFER_SIZE() {
        return 262144;
    }

    public static int CN_PROTOCOL_SERVER_SEND_BUFFER_SIZE() {
        return 0x200000;
    }

    public static int CN_PROTOCOL_SERVER_RECEIVE_BUFFER_SIZE() {
        return 0x200000;
    }

    public static int CN_PROTOCOL_EVENT_QUEUE_SIZE() {
        return 0x400000;
    }

    public static int CN_PROTOCOL_CONNECT_TOKEN_SECRET_SECTION_SIZE() {
        return 392;
    }

    public static float CN_PROTOCOL_SEND_RATE() {
        return 0.1f;
    }

    public static int CN_HASHTABLE_KEY_BYTES() {
        return 32;
    }

    public static int CN_HASHTABLE_HASH_BYTES() {
        return 32;
    }

    public static int CN_PROTOCOL_CONNECT_TOKEN_ENTRIES_MAX() {
        return 256;
    }

    public static int CN_PROTOCOL_ENCRYPTION_STATES_MAX() {
        return 64;
    }

    public static int CN_ENDPOINT_STRING_MAX_LENGTH() {
        return 46;
    }

    public static int CN_PROTOCOL_NET_SIMULATOR_MAX_PACKETS() {
        return 5120;
    }

    public static long CN_INVALID_HANDLE() {
        return -1L;
    }

    public static int CN_ACK_SYSTEM_HEADER_SIZE() {
        return 8;
    }

    public static int CN_TRANSPORT_HEADER_SIZE() {
        return 9;
    }

    public static int CN_TRANSPORT_SEND_QUEUE_MAX_ENTRIES() {
        return 1024;
    }

    public static int CN_TRANSPORT_PACKET_PAYLOAD_MAX() {
        return 1200;
    }

    public static int CN_SEQUENCE_BUFFER_EMPTY() {
        return -1;
    }

    public static int CN_PACKET_QUEUE_MAX_ENTRIES() {
        return 1024;
    }

    private static class cn_endpoint_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_endpoint_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_endpoint_init() {
        }
    }

    private static class cn_endpoint_to_string {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(cn_endpoint_t.layout(), C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_endpoint_to_string");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_endpoint_to_string() {
        }
    }

    private static class cn_endpoint_equals {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, cn_endpoint_t.layout(), cn_endpoint_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_endpoint_equals");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_endpoint_equals() {
        }
    }

    private static class cn_crypto_random_bytes {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_random_bytes");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_crypto_random_bytes() {
        }
    }

    private static class cn_crypto_sign_keygen {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_sign_keygen");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_crypto_sign_keygen() {
        }
    }

    private static class cn_generate_connect_token {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_LONG_LONG, C_LONG_LONG, C_POINTER, C_POINTER, C_LONG_LONG, C_INT, C_INT, C_POINTER, C_LONG_LONG, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_generate_connect_token");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_generate_connect_token() {
        }
    }

    private static class cn_client_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_SHORT, C_LONG_LONG, C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_create() {
        }
    }

    private static class cn_client_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_destroy() {
        }
    }

    private static class cn_client_connect {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_connect");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_connect() {
        }
    }

    private static class cn_client_disconnect {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_disconnect");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_disconnect() {
        }
    }

    private static class cn_client_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_update() {
        }
    }

    private static class cn_client_pop_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_pop_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_pop_packet() {
        }
    }

    private static class cn_client_free_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_free_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_free_packet() {
        }
    }

    private static class cn_client_send {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT, C_BOOL);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_send");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_send() {
        }
    }

    private static class cn_client_state_get {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_state_get");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_state_get() {
        }
    }

    private static class cn_client_state_string {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_state_string");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_state_string() {
        }
    }

    private static class cn_client_enable_network_simulator {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_DOUBLE, C_DOUBLE, C_DOUBLE);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_enable_network_simulator");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_enable_network_simulator() {
        }
    }

    private static class cn_client_get_packet_loss_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_get_packet_loss_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_get_packet_loss_estimate() {
        }
    }

    private static class cn_client_get_rtt_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_get_rtt_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_get_rtt_estimate() {
        }
    }

    private static class cn_client_get_incoming_kbps_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_get_incoming_kbps_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_get_incoming_kbps_estimate() {
        }
    }

    private static class cn_client_get_outgoing_kbps_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_client_get_outgoing_kbps_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_client_get_outgoing_kbps_estimate() {
        }
    }

    private static class cn_server_config_defaults {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_server_config_t.layout(), new MemoryLayout[0]);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_config_defaults");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_config_defaults() {
        }
    }

    private static class cn_server_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, cn_server_config_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_create() {
        }
    }

    private static class cn_server_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_destroy() {
        }
    }

    private static class cn_server_start {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_start");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_start() {
        }
    }

    private static class cn_server_stop {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_stop");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_stop() {
        }
    }

    private static class cn_server_pop_event {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_pop_event");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_pop_event() {
        }
    }

    private static class cn_server_free_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_free_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_free_packet() {
        }
    }

    private static class cn_server_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_update() {
        }
    }

    private static class cn_server_disconnect_client {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_BOOL);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_disconnect_client");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_disconnect_client() {
        }
    }

    private static class cn_server_send {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT, C_INT, C_BOOL);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_send");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_send() {
        }
    }

    private static class cn_server_is_client_connected {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_is_client_connected");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_is_client_connected() {
        }
    }

    private static class cn_server_set_public_ip {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_set_public_ip");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_set_public_ip() {
        }
    }

    private static class cn_server_enable_network_simulator {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_DOUBLE, C_DOUBLE, C_DOUBLE);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_enable_network_simulator");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_enable_network_simulator() {
        }
    }

    private static class cn_server_get_packet_loss_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_get_packet_loss_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_get_packet_loss_estimate() {
        }
    }

    private static class cn_server_get_rtt_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_get_rtt_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_get_rtt_estimate() {
        }
    }

    private static class cn_server_get_incoming_kbps_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_get_incoming_kbps_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_get_incoming_kbps_estimate() {
        }
    }

    private static class cn_server_get_outgoing_kbps_estimate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_server_get_outgoing_kbps_estimate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_server_get_outgoing_kbps_estimate() {
        }
    }

    private static class cn_is_error {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, cn_result_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_is_error");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_is_error() {
        }
    }

    private static class cn_error_failure {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_error_failure");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_error_failure() {
        }
    }

    private static class cn_error_success {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), new MemoryLayout[0]);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_error_success");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_error_success() {
        }
    }

    private static class hydro_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, new MemoryLayout[0]);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_init() {
        }
    }

    private static class hydro_random_u32 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, new MemoryLayout[0]);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_random_u32");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_random_u32() {
        }
    }

    private static class hydro_random_uniform {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_random_uniform");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_random_uniform() {
        }
    }

    private static class hydro_random_buf {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_random_buf");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_random_buf() {
        }
    }

    private static class hydro_random_buf_deterministic {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_random_buf_deterministic");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_random_buf_deterministic() {
        }
    }

    private static class hydro_random_ratchet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(new MemoryLayout[0]);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_random_ratchet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_random_ratchet() {
        }
    }

    private static class hydro_random_reseed {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(new MemoryLayout[0]);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_random_reseed");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_random_reseed() {
        }
    }

    private static class hydro_hash_keygen {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_hash_keygen");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_hash_keygen() {
        }
    }

    private static class hydro_hash_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_hash_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_hash_init() {
        }
    }

    private static class hydro_hash_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_hash_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_hash_update() {
        }
    }

    private static class hydro_hash_final {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_hash_final");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_hash_final() {
        }
    }

    private static class hydro_hash_hash {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG, C_POINTER, C_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_hash_hash");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_hash_hash() {
        }
    }

    private static class hydro_secretbox_keygen {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_secretbox_keygen");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_secretbox_keygen() {
        }
    }

    private static class hydro_secretbox_encrypt {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG, C_LONG_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_secretbox_encrypt");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_secretbox_encrypt() {
        }
    }

    private static class hydro_secretbox_decrypt {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG, C_LONG_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_secretbox_decrypt");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_secretbox_decrypt() {
        }
    }

    private static class hydro_secretbox_probe_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_secretbox_probe_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_secretbox_probe_create() {
        }
    }

    private static class hydro_secretbox_probe_verify {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_secretbox_probe_verify");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_secretbox_probe_verify() {
        }
    }

    private static class hydro_kdf_keygen {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kdf_keygen");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kdf_keygen() {
        }
    }

    private static class hydro_kdf_derive_from_key {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG, C_LONG_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kdf_derive_from_key");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kdf_derive_from_key() {
        }
    }

    private static class hydro_sign_keygen {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_keygen");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_keygen() {
        }
    }

    private static class hydro_sign_keygen_deterministic {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_keygen_deterministic");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_keygen_deterministic() {
        }
    }

    private static class hydro_sign_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_init() {
        }
    }

    private static class hydro_sign_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_update() {
        }
    }

    private static class hydro_sign_final_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_final_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_final_create() {
        }
    }

    private static class hydro_sign_final_verify {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_final_verify");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_final_verify() {
        }
    }

    private static class hydro_sign_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_create() {
        }
    }

    private static class hydro_sign_verify {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_sign_verify");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_sign_verify() {
        }
    }

    private static class hydro_kx_keygen {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_keygen");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_keygen() {
        }
    }

    private static class hydro_kx_keygen_deterministic {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_keygen_deterministic");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_keygen_deterministic() {
        }
    }

    private static class hydro_kx_n_1 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_n_1");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_n_1() {
        }
    }

    private static class hydro_kx_n_2 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_n_2");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_n_2() {
        }
    }

    private static class hydro_kx_kk_1 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_kk_1");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_kk_1() {
        }
    }

    private static class hydro_kx_kk_2 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_kk_2");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_kk_2() {
        }
    }

    private static class hydro_kx_kk_3 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_kk_3");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_kk_3() {
        }
    }

    private static class hydro_kx_xx_1 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_xx_1");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_xx_1() {
        }
    }

    private static class hydro_kx_xx_2 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_xx_2");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_xx_2() {
        }
    }

    private static class hydro_kx_xx_3 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_xx_3");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_xx_3() {
        }
    }

    private static class hydro_kx_xx_4 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_xx_4");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_xx_4() {
        }
    }

    private static class hydro_kx_nk_1 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_nk_1");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_nk_1() {
        }
    }

    private static class hydro_kx_nk_2 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_nk_2");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_nk_2() {
        }
    }

    private static class hydro_kx_nk_3 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_kx_nk_3");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_kx_nk_3() {
        }
    }

    private static class hydro_pwhash_keygen {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pwhash_keygen");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pwhash_keygen() {
        }
    }

    private static class hydro_pwhash_deterministic {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG, C_POINTER, C_LONG, C_POINTER, C_POINTER, C_LONG_LONG, C_LONG, C_CHAR);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pwhash_deterministic");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pwhash_deterministic() {
        }
    }

    private static class hydro_pwhash_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG, C_POINTER, C_LONG_LONG, C_LONG, C_CHAR);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pwhash_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pwhash_create() {
        }
    }

    private static class hydro_pwhash_verify {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG, C_POINTER, C_LONG_LONG, C_LONG, C_CHAR);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pwhash_verify");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pwhash_verify() {
        }
    }

    private static class hydro_pwhash_derive_static_key {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG, C_POINTER, C_POINTER, C_LONG, C_POINTER, C_POINTER, C_LONG_LONG, C_LONG, C_CHAR);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pwhash_derive_static_key");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pwhash_derive_static_key() {
        }
    }

    private static class hydro_pwhash_reencrypt {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pwhash_reencrypt");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pwhash_reencrypt() {
        }
    }

    private static class hydro_pwhash_upgrade {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG_LONG, C_LONG, C_CHAR);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pwhash_upgrade");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pwhash_upgrade() {
        }
    }

    private static class hydro_memzero {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_memzero");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_memzero() {
        }
    }

    private static class hydro_increment {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_increment");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_increment() {
        }
    }

    private static class hydro_equal {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_equal");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_equal() {
        }
    }

    private static class hydro_compare {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_compare");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_compare() {
        }
    }

    private static class hydro_bin2hex {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_LONG, C_POINTER, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_bin2hex");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_bin2hex() {
        }
    }

    private static class hydro_hex2bin {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG, C_POINTER, C_LONG, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_hex2bin");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_hex2bin() {
        }
    }

    private static class hydro_pad {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG, C_LONG, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_pad");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_pad() {
        }
    }

    private static class hydro_unpad {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG, C_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("hydro_unpad");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private hydro_unpad() {
        }
    }

    private static class cn_write_uint8 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_CHAR);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_uint8");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_uint8() {
        }
    }

    private static class cn_write_uint16 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_uint16");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_uint16() {
        }
    }

    private static class cn_write_uint32 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_uint32");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_uint32() {
        }
    }

    private static class cn_write_float {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_FLOAT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_float");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_float() {
        }
    }

    private static class cn_write_uint64 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_uint64");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_uint64() {
        }
    }

    private static class cn_write_bytes {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_bytes");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_bytes() {
        }
    }

    private static class cn_write_endpoint {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, cn_endpoint_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_endpoint");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_endpoint() {
        }
    }

    private static class cn_write_key {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_key");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_key() {
        }
    }

    private static class cn_write_fourcc {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_write_fourcc");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_write_fourcc() {
        }
    }

    private static class cn_read_uint8 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_CHAR, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_uint8");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_uint8() {
        }
    }

    private static class cn_read_uint16 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_uint16");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_uint16() {
        }
    }

    private static class cn_read_uint32 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_uint32");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_uint32() {
        }
    }

    private static class cn_read_float {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_FLOAT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_float");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_float() {
        }
    }

    private static class cn_read_uint64 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG_LONG, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_uint64");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_uint64() {
        }
    }

    private static class cn_read_bytes {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_bytes");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_bytes() {
        }
    }

    private static class cn_read_endpoint {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_endpoint_t.layout(), C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_endpoint");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_endpoint() {
        }
    }

    private static class cn_read_key {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_crypto_key_t.layout(), C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_key");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_key() {
        }
    }

    private static class cn_read_fourcc {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_read_fourcc");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_read_fourcc() {
        }
    }

    private static class cn_list_init_node {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_init_node");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_init_node() {
        }
    }

    private static class cn_list_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_init() {
        }
    }

    private static class cn_list_push_front {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_push_front");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_push_front() {
        }
    }

    private static class cn_list_push_back {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_push_back");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_push_back() {
        }
    }

    private static class cn_list_remove {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_remove");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_remove() {
        }
    }

    private static class cn_list_pop_front {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_pop_front");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_pop_front() {
        }
    }

    private static class cn_list_pop_back {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_pop_back");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_pop_back() {
        }
    }

    private static class cn_list_empty {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_empty");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_empty() {
        }
    }

    private static class cn_list_begin {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_begin");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_begin() {
        }
    }

    private static class cn_list_end {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_end");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_end() {
        }
    }

    private static class cn_list_front {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_front");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_front() {
        }
    }

    private static class cn_list_back {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_list_back");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_list_back() {
        }
    }

    private static class cn_circular_buffer_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_circular_buffer_t.layout(), C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_circular_buffer_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_circular_buffer_create() {
        }
    }

    private static class cn_circular_buffer_free {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_circular_buffer_free");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_circular_buffer_free() {
        }
    }

    private static class cn_circular_buffer_reset {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_circular_buffer_reset");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_circular_buffer_reset() {
        }
    }

    private static class cn_circular_buffer_push {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_circular_buffer_push");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_circular_buffer_push() {
        }
    }

    private static class cn_circular_buffer_pull {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_circular_buffer_pull");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_circular_buffer_pull() {
        }
    }

    private static class cn_circular_buffer_grow {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_circular_buffer_grow");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_circular_buffer_grow() {
        }
    }

    private static class cn_socket_cleanup {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_socket_cleanup");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_socket_cleanup() {
        }
    }

    private static class cn_socket_init1 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT, C_SHORT, C_INT, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_socket_init1");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_socket_init1() {
        }
    }

    private static class cn_socket_init2 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_INT, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_socket_init2");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_socket_init2() {
        }
    }

    private static class cn_socket_send_internal {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, cn_endpoint_t.layout(), C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_socket_send_internal");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_socket_send_internal() {
        }
    }

    private static class cn_socket_receive {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_socket_receive");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_socket_receive() {
        }
    }

    private static class cn_crypto_encrypt {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_INT, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_encrypt");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_crypto_encrypt() {
        }
    }

    private static class cn_crypto_decrypt {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_decrypt");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_crypto_decrypt() {
        }
    }

    private static class cn_crypto_sign_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_sign_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_crypto_sign_create() {
        }
    }

    private static class cn_crypto_sign_verify {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_sign_verify");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_crypto_sign_verify() {
        }
    }

    private static class cn_simulator_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_simulator_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_simulator_create() {
        }
    }

    private static class cn_simulator_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_simulator_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_simulator_destroy() {
        }
    }

    private static class cn_simulator_add {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, cn_endpoint_t.layout(), C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_simulator_add");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_simulator_add() {
        }
    }

    private static class cn_simulator_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_simulator_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_simulator_update() {
        }
    }

    private static class cn_socket_send {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, cn_endpoint_t.layout(), C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_socket_send");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_socket_send() {
        }
    }

    private static class cn_protocol_replay_buffer_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_replay_buffer_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_replay_buffer_init() {
        }
    }

    private static class cn_protocol_replay_buffer_cull_duplicate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_replay_buffer_cull_duplicate");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_replay_buffer_cull_duplicate() {
        }
    }

    private static class cn_protocol_replay_buffer_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_replay_buffer_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_replay_buffer_update() {
        }
    }

    private static class cn_memory_pool_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_INT, C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_memory_pool_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_memory_pool_create() {
        }
    }

    private static class cn_memory_pool_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_memory_pool_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_memory_pool_destroy() {
        }
    }

    private static class cn_memory_pool_try_alloc {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_memory_pool_try_alloc");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_memory_pool_try_alloc() {
        }
    }

    private static class cn_memory_pool_alloc {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_memory_pool_alloc");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_memory_pool_alloc() {
        }
    }

    private static class cn_memory_pool_free {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_memory_pool_free");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_memory_pool_free() {
        }
    }

    private static class cn_protocol_packet_allocator_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_packet_allocator_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_packet_allocator_create() {
        }
    }

    private static class cn_protocol_packet_allocator_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_packet_allocator_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_packet_allocator_destroy() {
        }
    }

    private static class cn_protocol_packet_allocator_alloc {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_packet_allocator_alloc");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_packet_allocator_alloc() {
        }
    }

    private static class cn_protocol_packet_allocator_free {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_packet_allocator_free");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_packet_allocator_free() {
        }
    }

    private static class cn_protocol_read_connect_token_packet_public_section {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_LONG_LONG, C_LONG_LONG, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_read_connect_token_packet_public_section");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_read_connect_token_packet_public_section() {
        }
    }

    private static class cn_protocol_packet_write {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_LONG_LONG, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_packet_write");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_packet_write() {
        }
    }

    private static class cn_protocol_packet_open {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_packet_open");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_packet_open() {
        }
    }

    private static class cn_protocol_client_read_connect_token_from_web_service {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_LONG_LONG, C_LONG_LONG, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_read_connect_token_from_web_service");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_read_connect_token_from_web_service() {
        }
    }

    private static class cn_protocol_server_decrypt_connect_token_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_POINTER, C_LONG_LONG, C_LONG_LONG, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_decrypt_connect_token_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_decrypt_connect_token_packet() {
        }
    }

    private static class cn_hashtable_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_INT, C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_init() {
        }
    }

    private static class cn_hashtable_cleanup {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_cleanup");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_cleanup() {
        }
    }

    private static class cn_hashtable_insert {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_insert");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_insert() {
        }
    }

    private static class cn_hashtable_remove {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_remove");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_remove() {
        }
    }

    private static class cn_hashtable_clear {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_clear");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_clear() {
        }
    }

    private static class cn_hashtable_find {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_find");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_find() {
        }
    }

    private static class cn_hashtable_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_count() {
        }
    }

    private static class cn_hashtable_items {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_items");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_items() {
        }
    }

    private static class cn_hashtable_keys {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_keys");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_keys() {
        }
    }

    private static class cn_hashtable_swap {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_hashtable_swap");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_hashtable_swap() {
        }
    }

    private static class cn_protocol_connect_token_cache_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_connect_token_cache_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_connect_token_cache_init() {
        }
    }

    private static class cn_protocol_connect_token_cache_cleanup {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_connect_token_cache_cleanup");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_connect_token_cache_cleanup() {
        }
    }

    private static class cn_protocol_connect_token_cache_find {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_connect_token_cache_find");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_connect_token_cache_find() {
        }
    }

    private static class cn_protocol_connect_token_cache_add {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_connect_token_cache_add");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_connect_token_cache_add() {
        }
    }

    private static class cn_protocol_encryption_map_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_init() {
        }
    }

    private static class cn_protocol_encryption_map_cleanup {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_cleanup");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_cleanup() {
        }
    }

    private static class cn_protocol_encryption_map_clear {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_clear");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_clear() {
        }
    }

    private static class cn_protocol_encryption_map_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_count() {
        }
    }

    private static class cn_protocol_encryption_map_insert {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, cn_endpoint_t.layout(), C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_insert");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_insert() {
        }
    }

    private static class cn_protocol_encryption_map_find {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, cn_endpoint_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_find");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_find() {
        }
    }

    private static class cn_protocol_encryption_map_remove {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, cn_endpoint_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_remove");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_remove() {
        }
    }

    private static class cn_protocol_encryption_map_get_endpoints {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_get_endpoints");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_get_endpoints() {
        }
    }

    private static class cn_protocol_encryption_map_get_states {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_get_states");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_get_states() {
        }
    }

    private static class cn_protocol_encryption_map_look_for_timeouts_or_expirations {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_encryption_map_look_for_timeouts_or_expirations");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_encryption_map_look_for_timeouts_or_expirations() {
        }
    }

    private static class s_protocol_client_state_str {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_protocol_client_state_str");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_protocol_client_state_str() {
        }
    }

    private static class cn_protocol_client_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_SHORT, C_LONG_LONG, C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_create() {
        }
    }

    private static class cn_protocol_client_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_destroy() {
        }
    }

    private static class cn_protocol_client_connect {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_connect");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_connect() {
        }
    }

    private static class s_protocol_server_endpoint {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_endpoint_t.layout(), C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_protocol_server_endpoint");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_protocol_server_endpoint() {
        }
    }

    private static class s_protocol_packet_str {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_CHAR);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_protocol_packet_str");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_protocol_packet_str() {
        }
    }

    private static class cn_protocol_client_get_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_get_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_get_packet() {
        }
    }

    private static class cn_protocol_client_free_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_free_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_free_packet() {
        }
    }

    private static class cn_protocol_client_disconnect {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_disconnect");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_disconnect() {
        }
    }

    private static class cn_protocol_client_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_update() {
        }
    }

    private static class cn_protocol_client_send {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_send");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_send() {
        }
    }

    private static class cn_protocol_client_get_state {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_get_state");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_get_state() {
        }
    }

    private static class cn_protocol_client_get_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG_LONG, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_get_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_get_id() {
        }
    }

    private static class cn_protocol_client_get_max_clients {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_get_max_clients");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_get_max_clients() {
        }
    }

    private static class cn_protocol_client_get_server_address {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_endpoint_t.layout(), C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_get_server_address");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_get_server_address() {
        }
    }

    private static class cn_protocol_client_get_port {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_get_port");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_get_port() {
        }
    }

    private static class cn_protocol_client_enable_network_simulator {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_DOUBLE, C_DOUBLE, C_DOUBLE);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_client_enable_network_simulator");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_client_enable_network_simulator() {
        }
    }

    private static class cn_handle_allocator_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_handle_allocator_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_handle_allocator_create() {
        }
    }

    private static class cn_handle_allocator_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_handle_allocator_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_handle_allocator_destroy() {
        }
    }

    private static class cn_handle_allocator_alloc {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG_LONG, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_handle_allocator_alloc");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_handle_allocator_alloc() {
        }
    }

    private static class s_table_index {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_table_index");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_table_index() {
        }
    }

    private static class cn_handle_allocator_get_index {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_handle_allocator_get_index");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_handle_allocator_get_index() {
        }
    }

    private static class cn_handle_allocator_update_index {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG_LONG, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_handle_allocator_update_index");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_handle_allocator_update_index() {
        }
    }

    private static class cn_handle_allocator_free {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_handle_allocator_free");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_handle_allocator_free() {
        }
    }

    private static class cn_handle_allocator_is_handle_valid {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_handle_allocator_is_handle_valid");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_handle_allocator_is_handle_valid() {
        }
    }

    private static class cn_protocol_server_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_LONG_LONG, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_create() {
        }
    }

    private static class cn_protocol_server_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_destroy() {
        }
    }

    private static class cn_protocol_server_start {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_start");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_start() {
        }
    }

    private static class s_protocol_server_event_pull {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_protocol_server_event_pull");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_protocol_server_event_pull() {
        }
    }

    private static class s_protocol_server_event_push {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_protocol_server_event_push");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_protocol_server_event_push() {
        }
    }

    private static class cn_protocol_server_pop_event {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_pop_event");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_pop_event() {
        }
    }

    private static class cn_protocol_server_free_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_free_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_free_packet() {
        }
    }

    private static class cn_protocol_server_stop {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_stop");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_stop() {
        }
    }

    private static class cn_protocol_server_running {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_running");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_running() {
        }
    }

    private static class cn_protocol_server_disconnect_client {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_INT, C_BOOL);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_disconnect_client");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_disconnect_client() {
        }
    }

    private static class cn_protocol_server_send_to_client {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_send_to_client");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_send_to_client() {
        }
    }

    private static class cn_protocol_server_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_update() {
        }
    }

    private static class cn_protocol_server_client_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_client_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_client_count() {
        }
    }

    private static class cn_protocol_server_get_client_id {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG_LONG, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_get_client_id");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_get_client_id() {
        }
    }

    private static class cn_protocol_server_is_client_connected {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_BOOL, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_is_client_connected");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_is_client_connected() {
        }
    }

    private static class cn_protocol_server_enable_network_simulator {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE, C_DOUBLE, C_DOUBLE, C_DOUBLE);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_protocol_server_enable_network_simulator");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_protocol_server_enable_network_simulator() {
        }
    }

    private static class cn_sequence_buffer_remove {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_SHORT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_remove");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_remove() {
        }
    }

    private static class cn_sequence_buffer_reset {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_reset");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_reset() {
        }
    }

    private static class cn_sequence_buffer_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT, C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_init() {
        }
    }

    private static class cn_sequence_buffer_cleanup {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_cleanup");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_cleanup() {
        }
    }

    private static class s_sequence_greater_than {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_SHORT, C_SHORT);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_sequence_greater_than");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_sequence_greater_than() {
        }
    }

    private static class s_sequence_less_than {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_SHORT, C_SHORT);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_sequence_less_than");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_sequence_less_than() {
        }
    }

    private static class s_sequence_is_stale {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_sequence_is_stale");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_sequence_is_stale() {
        }
    }

    private static class cn_sequence_buffer_insert {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_SHORT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_insert");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_insert() {
        }
    }

    private static class cn_sequence_buffer_is_empty {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_is_empty");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_is_empty() {
        }
    }

    private static class cn_sequence_buffer_find {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_SHORT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_find");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_find() {
        }
    }

    private static class cn_sequence_buffer_generate_ack_bits {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_sequence_buffer_generate_ack_bits");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_sequence_buffer_generate_ack_bits() {
        }
    }

    private static class cn_packet_queue_init {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_packet_queue_init");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_packet_queue_init() {
        }
    }

    private static class cn_packet_queue_push {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_packet_queue_push");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_packet_queue_push() {
        }
    }

    private static class cn_packet_queue_pop {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_packet_queue_pop");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_packet_queue_pop() {
        }
    }

    private static class cn_ack_system_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, cn_ack_system_config_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_create() {
        }
    }

    private static class cn_ack_system_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_destroy() {
        }
    }

    private static class cn_ack_system_reset {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_reset");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_reset() {
        }
    }

    private static class cn_ack_system_send_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_send_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_send_packet() {
        }
    }

    private static class cn_ack_system_get_sequence {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_SHORT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_get_sequence");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_get_sequence() {
        }
    }

    private static class cn_ack_system_receive_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_receive_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_receive_packet() {
        }
    }

    private static class cn_ack_system_get_acks {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_get_acks");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_get_acks() {
        }
    }

    private static class cn_ack_system_get_acks_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_get_acks_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_get_acks_count() {
        }
    }

    private static class cn_ack_system_clear_acks {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_clear_acks");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_clear_acks() {
        }
    }

    private static class s_calc_packet_loss {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_DOUBLE, C_DOUBLE, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_calc_packet_loss");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_calc_packet_loss() {
        }
    }

    private static class s_calc_bandwidth {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_DOUBLE, C_DOUBLE, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_calc_bandwidth");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_calc_bandwidth() {
        }
    }

    private static class cn_ack_system_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_update() {
        }
    }

    private static class cn_ack_system_rtt {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_DOUBLE, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_rtt");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_rtt() {
        }
    }

    private static class cn_ack_system_packet_loss {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_DOUBLE, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_packet_loss");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_packet_loss() {
        }
    }

    private static class cn_ack_system_bandwidth_outgoing_kbps {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_DOUBLE, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_bandwidth_outgoing_kbps");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_bandwidth_outgoing_kbps() {
        }
    }

    private static class cn_ack_system_bandwidth_incoming_kbps {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_DOUBLE, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_bandwidth_incoming_kbps");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_bandwidth_incoming_kbps() {
        }
    }

    private static class cn_ack_system_get_counter {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG_LONG, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_get_counter");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_ack_system_get_counter() {
        }
    }

    private static class cn_transport_create {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, cn_transport_config_t.layout());
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_create");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_create() {
        }
    }

    private static class cn_transport_destroy {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_destroy");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_destroy() {
        }
    }

    private static class s_transport_write_header {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_INT, C_CHAR, C_SHORT, C_SHORT, C_SHORT, C_SHORT);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_transport_write_header");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_transport_write_header() {
        }
    }

    private static class s_transport_send_reliably {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_transport_send_reliably");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_transport_send_reliably() {
        }
    }

    private static class s_transport_send {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_transport_send");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_transport_send() {
        }
    }

    private static class cn_transport_send {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT, C_BOOL);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_send");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_send() {
        }
    }

    private static class cn_transport_receive_reliably_and_in_order {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_receive_reliably_and_in_order");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_receive_reliably_and_in_order() {
        }
    }

    private static class cn_transport_receive_fire_and_forget {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_receive_fire_and_forget");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_receive_fire_and_forget() {
        }
    }

    private static class cn_transport_free_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_free_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_free_packet() {
        }
    }

    private static class cn_transport_process_packet {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(cn_result_t.layout(), C_POINTER, C_POINTER, C_INT);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_process_packet");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_process_packet() {
        }
    }

    private static class cn_transport_remove_flight_fragment {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_LONG_LONG);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_remove_flight_fragment");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_remove_flight_fragment() {
        }
    }

    private static class cn_transport_process_acks {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_process_acks");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_process_acks() {
        }
    }

    private static class cn_transport_send_fragments {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_send_fragments");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_send_fragments() {
        }
    }

    private static class cn_transport_unacked_fragment_count {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_unacked_fragment_count");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_unacked_fragment_count() {
        }
    }

    private static class cn_transport_update {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_POINTER, C_DOUBLE);
        public static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_update");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private cn_transport_update() {
        }
    }

    private static class s_server_event_pull {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_server_event_pull");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_server_event_pull() {
        }
    }

    private static class s_server_event_push {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER);
        public static final MemorySegment ADDR = netcode.findOrThrow("s_server_event_push");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private s_server_event_push() {
        }
    }

    public static class cn_transport_config_defaults {
        private static final FunctionDescriptor BASE_DESC = FunctionDescriptor.of(cn_transport_config_t.layout(), new MemoryLayout[0]);
        private static final MemorySegment ADDR = netcode.findOrThrow("cn_transport_config_defaults");
        private final MethodHandle handle;
        private final FunctionDescriptor descriptor;
        private final MethodHandle spreader;

        private cn_transport_config_defaults(MethodHandle methodHandle, FunctionDescriptor functionDescriptor, MethodHandle methodHandle2) {
            this.handle = methodHandle;
            this.descriptor = functionDescriptor;
            this.spreader = methodHandle2;
        }

        public static cn_transport_config_defaults makeInvoker(MemoryLayout ... memoryLayoutArray) {
            FunctionDescriptor functionDescriptor = BASE_DESC.appendArgumentLayouts(memoryLayoutArray);
            Linker.Option option = Linker.Option.firstVariadicArg(BASE_DESC.argumentLayouts().size());
            MethodHandle methodHandle = Linker.nativeLinker().downcallHandle(ADDR, functionDescriptor, option);
            MethodHandle methodHandle2 = methodHandle.asSpreader(Object[].class, memoryLayoutArray.length);
            return new cn_transport_config_defaults(methodHandle, functionDescriptor, methodHandle2);
        }

        public static MemorySegment address() {
            return ADDR;
        }

        public MethodHandle handle() {
            return this.handle;
        }

        public FunctionDescriptor descriptor() {
            return this.descriptor;
        }

        public MemorySegment apply(SegmentAllocator segmentAllocator, Object ... objectArray) {
            try {
                if (TRACE_DOWNCALLS) {
                    netcode.traceDowncall("cn_transport_config_defaults", segmentAllocator, objectArray);
                }
                return this.spreader.invokeExact(segmentAllocator, objectArray);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new AssertionError("should not reach here", throwable);
            }
        }
    }

    public static class cn_ack_system_config_defaults {
        private static final FunctionDescriptor BASE_DESC = FunctionDescriptor.of(cn_ack_system_config_t.layout(), new MemoryLayout[0]);
        private static final MemorySegment ADDR = netcode.findOrThrow("cn_ack_system_config_defaults");
        private final MethodHandle handle;
        private final FunctionDescriptor descriptor;
        private final MethodHandle spreader;

        private cn_ack_system_config_defaults(MethodHandle methodHandle, FunctionDescriptor functionDescriptor, MethodHandle methodHandle2) {
            this.handle = methodHandle;
            this.descriptor = functionDescriptor;
            this.spreader = methodHandle2;
        }

        public static cn_ack_system_config_defaults makeInvoker(MemoryLayout ... memoryLayoutArray) {
            FunctionDescriptor functionDescriptor = BASE_DESC.appendArgumentLayouts(memoryLayoutArray);
            Linker.Option option = Linker.Option.firstVariadicArg(BASE_DESC.argumentLayouts().size());
            MethodHandle methodHandle = Linker.nativeLinker().downcallHandle(ADDR, functionDescriptor, option);
            MethodHandle methodHandle2 = methodHandle.asSpreader(Object[].class, memoryLayoutArray.length);
            return new cn_ack_system_config_defaults(methodHandle, functionDescriptor, methodHandle2);
        }

        public static MemorySegment address() {
            return ADDR;
        }

        public MethodHandle handle() {
            return this.handle;
        }

        public FunctionDescriptor descriptor() {
            return this.descriptor;
        }

        public MemorySegment apply(SegmentAllocator segmentAllocator, Object ... objectArray) {
            try {
                if (TRACE_DOWNCALLS) {
                    netcode.traceDowncall("cn_ack_system_config_defaults", segmentAllocator, objectArray);
                }
                return this.spreader.invokeExact(segmentAllocator, objectArray);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new AssertionError("should not reach here", throwable);
            }
        }
    }

    public static class cn_cleanup {
        private static final FunctionDescriptor BASE_DESC = FunctionDescriptor.ofVoid(new MemoryLayout[0]);
        private static final MemorySegment ADDR = netcode.findOrThrow("cn_cleanup");
        private final MethodHandle handle;
        private final FunctionDescriptor descriptor;
        private final MethodHandle spreader;

        private cn_cleanup(MethodHandle methodHandle, FunctionDescriptor functionDescriptor, MethodHandle methodHandle2) {
            this.handle = methodHandle;
            this.descriptor = functionDescriptor;
            this.spreader = methodHandle2;
        }

        public static cn_cleanup makeInvoker(MemoryLayout ... memoryLayoutArray) {
            FunctionDescriptor functionDescriptor = BASE_DESC.appendArgumentLayouts(memoryLayoutArray);
            Linker.Option option = Linker.Option.firstVariadicArg(BASE_DESC.argumentLayouts().size());
            MethodHandle methodHandle = Linker.nativeLinker().downcallHandle(ADDR, functionDescriptor, option);
            MethodHandle methodHandle2 = methodHandle.asSpreader(Object[].class, memoryLayoutArray.length);
            return new cn_cleanup(methodHandle, functionDescriptor, methodHandle2);
        }

        public static MemorySegment address() {
            return ADDR;
        }

        public MethodHandle handle() {
            return this.handle;
        }

        public FunctionDescriptor descriptor() {
            return this.descriptor;
        }

        public void apply(Object ... objectArray) {
            try {
                if (TRACE_DOWNCALLS) {
                    netcode.traceDowncall("cn_cleanup", objectArray);
                }
                this.spreader.invokeExact(objectArray);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new AssertionError("should not reach here", throwable);
            }
        }
    }

    public static class s_cn_init_check {
        private static final FunctionDescriptor BASE_DESC = FunctionDescriptor.of(cn_result_t.layout(), new MemoryLayout[0]);
        private static final MemorySegment ADDR = netcode.findOrThrow("s_cn_init_check");
        private final MethodHandle handle;
        private final FunctionDescriptor descriptor;
        private final MethodHandle spreader;

        private s_cn_init_check(MethodHandle methodHandle, FunctionDescriptor functionDescriptor, MethodHandle methodHandle2) {
            this.handle = methodHandle;
            this.descriptor = functionDescriptor;
            this.spreader = methodHandle2;
        }

        public static s_cn_init_check makeInvoker(MemoryLayout ... memoryLayoutArray) {
            FunctionDescriptor functionDescriptor = BASE_DESC.appendArgumentLayouts(memoryLayoutArray);
            Linker.Option option = Linker.Option.firstVariadicArg(BASE_DESC.argumentLayouts().size());
            MethodHandle methodHandle = Linker.nativeLinker().downcallHandle(ADDR, functionDescriptor, option);
            MethodHandle methodHandle2 = methodHandle.asSpreader(Object[].class, memoryLayoutArray.length);
            return new s_cn_init_check(methodHandle, functionDescriptor, methodHandle2);
        }

        public static MemorySegment address() {
            return ADDR;
        }

        public MethodHandle handle() {
            return this.handle;
        }

        public FunctionDescriptor descriptor() {
            return this.descriptor;
        }

        public MemorySegment apply(SegmentAllocator segmentAllocator, Object ... objectArray) {
            try {
                if (TRACE_DOWNCALLS) {
                    netcode.traceDowncall("s_cn_init_check", segmentAllocator, objectArray);
                }
                return this.spreader.invokeExact(segmentAllocator, objectArray);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new AssertionError("should not reach here", throwable);
            }
        }
    }

    public static class cn_init {
        private static final FunctionDescriptor BASE_DESC = FunctionDescriptor.of(cn_result_t.layout(), new MemoryLayout[0]);
        private static final MemorySegment ADDR = netcode.findOrThrow("cn_init");
        private final MethodHandle handle;
        private final FunctionDescriptor descriptor;
        private final MethodHandle spreader;

        private cn_init(MethodHandle methodHandle, FunctionDescriptor functionDescriptor, MethodHandle methodHandle2) {
            this.handle = methodHandle;
            this.descriptor = functionDescriptor;
            this.spreader = methodHandle2;
        }

        public static cn_init makeInvoker(MemoryLayout ... memoryLayoutArray) {
            FunctionDescriptor functionDescriptor = BASE_DESC.appendArgumentLayouts(memoryLayoutArray);
            Linker.Option option = Linker.Option.firstVariadicArg(BASE_DESC.argumentLayouts().size());
            MethodHandle methodHandle = Linker.nativeLinker().downcallHandle(ADDR, functionDescriptor, option);
            MethodHandle methodHandle2 = methodHandle.asSpreader(Object[].class, memoryLayoutArray.length);
            return new cn_init(methodHandle, functionDescriptor, methodHandle2);
        }

        public static MemorySegment address() {
            return ADDR;
        }

        public MethodHandle handle() {
            return this.handle;
        }

        public FunctionDescriptor descriptor() {
            return this.descriptor;
        }

        public MemorySegment apply(SegmentAllocator segmentAllocator, Object ... objectArray) {
            try {
                if (TRACE_DOWNCALLS) {
                    netcode.traceDowncall("cn_init", segmentAllocator, objectArray);
                }
                return this.spreader.invokeExact(segmentAllocator, objectArray);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new AssertionError("should not reach here", throwable);
            }
        }
    }

    public static class cn_crypto_init {
        private static final FunctionDescriptor BASE_DESC = FunctionDescriptor.of(cn_result_t.layout(), new MemoryLayout[0]);
        private static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_init");
        private final MethodHandle handle;
        private final FunctionDescriptor descriptor;
        private final MethodHandle spreader;

        private cn_crypto_init(MethodHandle methodHandle, FunctionDescriptor functionDescriptor, MethodHandle methodHandle2) {
            this.handle = methodHandle;
            this.descriptor = functionDescriptor;
            this.spreader = methodHandle2;
        }

        public static cn_crypto_init makeInvoker(MemoryLayout ... memoryLayoutArray) {
            FunctionDescriptor functionDescriptor = BASE_DESC.appendArgumentLayouts(memoryLayoutArray);
            Linker.Option option = Linker.Option.firstVariadicArg(BASE_DESC.argumentLayouts().size());
            MethodHandle methodHandle = Linker.nativeLinker().downcallHandle(ADDR, functionDescriptor, option);
            MethodHandle methodHandle2 = methodHandle.asSpreader(Object[].class, memoryLayoutArray.length);
            return new cn_crypto_init(methodHandle, functionDescriptor, methodHandle2);
        }

        public static MemorySegment address() {
            return ADDR;
        }

        public MethodHandle handle() {
            return this.handle;
        }

        public FunctionDescriptor descriptor() {
            return this.descriptor;
        }

        public MemorySegment apply(SegmentAllocator segmentAllocator, Object ... objectArray) {
            try {
                if (TRACE_DOWNCALLS) {
                    netcode.traceDowncall("cn_crypto_init", segmentAllocator, objectArray);
                }
                return this.spreader.invokeExact(segmentAllocator, objectArray);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new AssertionError("should not reach here", throwable);
            }
        }
    }

    public static class cn_crypto_generate_key {
        private static final FunctionDescriptor BASE_DESC = FunctionDescriptor.of(cn_crypto_key_t.layout(), new MemoryLayout[0]);
        private static final MemorySegment ADDR = netcode.findOrThrow("cn_crypto_generate_key");
        private final MethodHandle handle;
        private final FunctionDescriptor descriptor;
        private final MethodHandle spreader;

        private cn_crypto_generate_key(MethodHandle methodHandle, FunctionDescriptor functionDescriptor, MethodHandle methodHandle2) {
            this.handle = methodHandle;
            this.descriptor = functionDescriptor;
            this.spreader = methodHandle2;
        }

        public static cn_crypto_generate_key makeInvoker(MemoryLayout ... memoryLayoutArray) {
            FunctionDescriptor functionDescriptor = BASE_DESC.appendArgumentLayouts(memoryLayoutArray);
            Linker.Option option = Linker.Option.firstVariadicArg(BASE_DESC.argumentLayouts().size());
            MethodHandle methodHandle = Linker.nativeLinker().downcallHandle(ADDR, functionDescriptor, option);
            MethodHandle methodHandle2 = methodHandle.asSpreader(Object[].class, memoryLayoutArray.length);
            return new cn_crypto_generate_key(methodHandle, functionDescriptor, methodHandle2);
        }

        public static MemorySegment address() {
            return ADDR;
        }

        public MethodHandle handle() {
            return this.handle;
        }

        public FunctionDescriptor descriptor() {
            return this.descriptor;
        }

        public MemorySegment apply(SegmentAllocator segmentAllocator, Object ... objectArray) {
            try {
                if (TRACE_DOWNCALLS) {
                    netcode.traceDowncall("cn_crypto_generate_key", segmentAllocator, objectArray);
                }
                return this.spreader.invokeExact(segmentAllocator, objectArray);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new AssertionError("should not reach here", throwable);
            }
        }
    }
}

