#include "type.hlsl"

/*
contributors: Patricio Gonzalez Vivo
description: given a quaternion, returns a rotation 3x3 matrix
use: <mat3> quat2mat3(<QUAT> Q)
license:
    - Copyright (c) 2021 Patricio Gonzalez Vivo under Prosperity License - https://prosperitylicense.com/versions/3.0.0
    - Copyright (c) 2021 Patricio Gonzalez Vivo under Patron License - https://lygia.xyz/license
*/

#ifndef FNC_QUAT2MAT3
#define FNC_QUAT2MAT3

float3x3 quat2mat3(QUAT q) {
    float qxx = q.x * q.x;
    float qyy = q.y * q.y;
    float qzz = q.z * q.z;
    float qxz = q.x * q.z;
    float qxy = q.x * q.y;
    float qyw = q.y * q.w;
    float qzw = q.z * q.w;
    float qyz = q.y * q.z;
    float qxw = q.x * q.w;

    return float3x3(
        float3(1.0 - 2.0 * (qyy + qzz), 2.0 * (qxy - qzw), 2.0 * (qxz + qyw)),
        float3(2.0 * (qxy + qzw), 1.0 - 2.0 * (qxx + qzz), 2.0 * (qyz - qxw)),
        float3(2.0 * (qxz - qyw), 2.0 * (qyz + qxw), 1.0 - 2.0 * (qxx + qyy))
    );
}
#endif