/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.net.URI;
import java.rmi.RemoteException;
import tlc2.tool.TLCState;
import tlc2.tool.WorkerException;
import tlc2.tool.distributed.NextStateResult;
import tlc2.tool.distributed.TLCWorkerRMI;

public class TLCWorkerSmartProxy
implements TLCWorkerRMI {
    private final TLCWorkerRMI worker;
    private double networkOverhead = Double.MAX_VALUE;

    public TLCWorkerSmartProxy(TLCWorkerRMI aWorker) {
        this.worker = aWorker;
    }

    @Override
    public NextStateResult getNextStates(TLCState[] states) throws RemoteException, WorkerException {
        long start2 = System.currentTimeMillis();
        NextStateResult nextStates = this.worker.getNextStates(states);
        long roundTripTime = System.currentTimeMillis() - start2 + 1L;
        long computationTime = this.sanitizeComputationTime(nextStates.getComputationTime());
        double networkTime = Math.max((double)(roundTripTime - computationTime), 1.0E-5);
        double percentageNetworkOverhead = networkTime / (double)roundTripTime;
        this.networkOverhead = percentageNetworkOverhead / (double)states.length;
        return nextStates;
    }

    private long sanitizeComputationTime(Long computationTime) {
        return Math.max(Math.abs(computationTime), 1L);
    }

    public double getNetworkOverhead() {
        return this.networkOverhead;
    }

    @Override
    public void exit() throws RemoteException {
        this.worker.exit();
    }

    @Override
    public URI getURI() throws RemoteException {
        return this.worker.getURI();
    }

    @Override
    public boolean isAlive() throws RemoteException {
        return this.worker.isAlive();
    }

    @Override
    public double getCacheRateRatio() throws RemoteException {
        return this.worker.getCacheRateRatio();
    }
}

