/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.math.BigInteger;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsOrRcdsValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.UniqueString;

public class SetOfRcdsValue
extends SetOfFcnsOrRcdsValue
implements Enumerable {
    public final UniqueString[] names;
    public final Value[] values;
    protected SetEnumValue rcdSet;

    public SetOfRcdsValue(UniqueString[] names, Value[] values, boolean isNorm) {
        assert (names.length == values.length);
        this.names = names;
        this.values = values;
        this.rcdSet = null;
        if (!isNorm) {
            this.sortByNames();
        }
    }

    public SetOfRcdsValue(UniqueString[] names, Value[] values, boolean isNorm, CostModel cm) {
        this(names, values, isNorm);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 14;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.rcdSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof SetOfRcdsValue) {
                SetOfRcdsValue rcds = (SetOfRcdsValue)obj;
                boolean isEmpty1 = this.isEmpty();
                if (isEmpty1) {
                    return rcds.isEmpty();
                }
                if (rcds.isEmpty()) {
                    return isEmpty1;
                }
                if (this.names.length != rcds.names.length) {
                    return false;
                }
                for (int i = 0; i < this.names.length; ++i) {
                    if (this.names[i].equals(rcds.names[i]) && this.values[i].equals(rcds.values[i])) continue;
                    return false;
                }
                return true;
            }
            this.convertAndCache();
            return this.rcdSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            RecordValue rcd = (RecordValue)elem.toRcd();
            if (rcd == null) {
                if (elem instanceof ModelValue) {
                    return ((ModelValue)elem).modelValueMember(this);
                }
                Assert.fail((String)("Attempted to check if non-record\n" + elem + "\nis in the set of records:\n" + Values.ppr(this.toString())), (SemanticNode)this.getSource());
            }
            rcd.normalize();
            if (this.names.length != rcd.names.length) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i].equals(rcd.names[i]) && this.values[i].member(rcd.values[i])) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i].isFinite()) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail((String)("Attempted to apply EXCEPT to the set of records:\n" + Values.ppr(this.toString())), (SemanticNode)this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail((String)("Attempted to apply EXCEPT to the set of records:\n" + Values.ppr(this.toString())), (SemanticNode)this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            long sz = 1L;
            for (int i = 0; i < this.values.length; ++i) {
                if ((sz *= (long)this.values[i].size()) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
                Assert.fail((int)2178, (String)("the number of elements in:\n" + Values.ppr(this.toString())));
            }
            return (int)sz;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    protected boolean needBigInteger() {
        long sz = 1L;
        for (int i = 0; i < this.values.length; ++i) {
            if ((sz *= (long)this.values[i].size()) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.rcdSet == null || this.rcdSet == SetEnumValue.DummyEnum) {
                for (int i = 0; i < this.names.length; ++i) {
                    if (this.values[i].isNormalized()) continue;
                    return false;
                }
                return true;
            }
            return this.rcdSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.rcdSet == null || this.rcdSet == SetEnumValue.DummyEnum) {
                for (int i = 0; i < this.names.length; ++i) {
                    this.values[i].normalize();
                }
            } else {
                this.rcdSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].deepNormalize();
            }
            if (this.rcdSet == null) {
                this.rcdSet = SetEnumValue.DummyEnum;
            } else if (this.rcdSet != SetEnumValue.DummyEnum) {
                this.rcdSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void sortByNames() {
        int i;
        for (i = 1; i < this.names.length; ++i) {
            int cmp = this.names[0].compareTo(this.names[i]);
            if (cmp == 0) {
                Assert.fail((String)("Field name " + this.names[0] + " occurs multiple times in set of records."), (SemanticNode)this.getSource());
                continue;
            }
            if (cmp <= 0) continue;
            UniqueString ts = this.names[0];
            this.names[0] = this.names[i];
            this.names[i] = ts;
            Value tv = this.values[0];
            this.values[0] = this.values[i];
            this.values[i] = tv;
        }
        for (i = 2; i < this.names.length; ++i) {
            int cmp;
            int j = i;
            UniqueString st = this.names[i];
            Value val = this.values[i];
            while ((cmp = st.compareTo(this.names[j - 1])) < 0) {
                this.names[j] = this.names[j - 1];
                this.values[j] = this.values[j - 1];
                --j;
            }
            if (cmp == 0) {
                Assert.fail((String)("Field name " + this.names[i] + " occurs multiple times in set of records."), (SemanticNode)this.getSource());
            }
            this.names[j] = st;
            this.values[j] = val;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean isDefined = true;
            for (int i = 0; i < this.values.length; ++i) {
                isDefined = isDefined && this.values[i].isDefined();
            }
            return isDefined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.rcdSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.rcdSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.rcdSet == null) {
            this.rcdSet = (SetEnumValue)this.toSetEnum();
        } else if (this.rcdSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = null;
            SetOfRcdsValue setOfRcdsValue = this;
            synchronized (setOfRcdsValue) {
                if (this.rcdSet == SetEnumValue.DummyEnum) {
                    val = (SetEnumValue)this.toSetEnum();
                    val.deepNormalize();
                }
            }
            setOfRcdsValue = this;
            synchronized (setOfRcdsValue) {
                if (this.rcdSet == SetEnumValue.DummyEnum) {
                    this.rcdSet = val;
                }
            }
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.rcdSet != null && this.rcdSet != SetEnumValue.DummyEnum) {
            return this.rcdSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, this.isNormalized(), this.cm);
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.rcdSet.write(vos);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            boolean unlazy = TLCGlobals.expand;
            try {
                if (unlazy) {
                    long sz = 1L;
                    for (int i = 0; i < this.values.length; ++i) {
                        if ((sz *= (long)this.values[i].size()) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
                        unlazy = false;
                        break;
                    }
                    unlazy = sz < (long)TLCGlobals.enumBound;
                }
            }
            catch (Throwable e) {
                if (swallow) {
                    unlazy = false;
                }
                throw e;
            }
            if (unlazy) {
                Value val = this.toSetEnum();
                return val.toString(sb, offset, swallow);
            }
            sb.append("[");
            int len = this.names.length;
            if (len != 0) {
                sb.append(this.names[0] + ": ");
                this.values[0].toString(sb, offset, swallow);
            }
            for (int i = 1; i < len; ++i) {
                sb.append(", ");
                sb.append(this.names[i] + ": ");
                this.values[i].toString(sb, offset, swallow);
            }
            sb.append("]");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.rcdSet == null || this.rcdSet == SetEnumValue.DummyEnum) {
                return new Enumerator();
            }
            return this.rcdSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    protected SetOfFcnsOrRcdsValue.SubsetEnumerator getSubsetEnumerator(int k, int n) {
        return new SubsetEnumerator(k, n);
    }

    @Override
    protected BigIntegerSubsetEnumerator getBigSubsetEnumerator(int k) {
        return new BigIntegerSubsetEnumerator(k);
    }

    class BigIntegerSubsetEnumerator
    extends SetOfFcnsOrRcdsValue.BigIntegerSubsetEnumerator {
        private final SetEnumValue[] convert;
        private final BigInteger[] rescaleBy;

        public BigIntegerSubsetEnumerator(int k) {
            super(k);
            this.convert = new SetEnumValue[SetOfRcdsValue.this.values.length];
            this.rescaleBy = new BigInteger[SetOfRcdsValue.this.values.length];
            BigInteger numElems = BigInteger.ONE;
            for (int i = SetOfRcdsValue.this.values.length - 1; i >= 0; --i) {
                this.convert[i] = (SetEnumValue)SetOfRcdsValue.this.values[i].toSetEnum();
                this.rescaleBy[i] = numElems;
                numElems = numElems.multiply(BigInteger.valueOf(this.convert[i].elems.size()));
            }
            this.sz = numElems;
        }

        @Override
        protected Value elementAt(BigInteger idx) {
            Value[] val = new Value[SetOfRcdsValue.this.names.length];
            for (int i = 0; i < val.length; ++i) {
                SetEnumValue sev = this.convert[i];
                int mod = sev.elems.size();
                BigInteger d = idx.divide(this.rescaleBy[i]);
                BigInteger m = d.mod(BigInteger.valueOf(mod));
                int elementAt = m.intValueExact();
                val[i] = sev.elems.elementAt(elementAt);
            }
            return new RecordValue(SetOfRcdsValue.this.names, val, false, SetOfRcdsValue.this.cm);
        }
    }

    class SubsetEnumerator
    extends SetOfFcnsOrRcdsValue.SubsetEnumerator {
        private final SetEnumValue[] convert;
        private final int[] rescaleBy;

        SubsetEnumerator(int k, int n) {
            super(k, n);
            this.convert = new SetEnumValue[SetOfRcdsValue.this.values.length];
            this.rescaleBy = new int[SetOfRcdsValue.this.values.length];
            int numElems = 1;
            for (int i = SetOfRcdsValue.this.values.length - 1; i >= 0; --i) {
                this.convert[i] = (SetEnumValue)SetOfRcdsValue.this.values[i].toSetEnum();
                this.rescaleBy[i] = numElems;
                numElems *= this.convert[i].elems.size();
            }
        }

        @Override
        protected RecordValue elementAt(int idx) {
            assert (0 <= idx && idx < SetOfRcdsValue.this.size());
            Value[] val = new Value[SetOfRcdsValue.this.names.length];
            for (int i = 0; i < val.length; ++i) {
                SetEnumValue sev = this.convert[i];
                int mod = sev.elems.size();
                int rescaledIdx = (int)Math.floor(idx / this.rescaleBy[i]);
                int elementAt = rescaledIdx % mod;
                val[i] = sev.elems.elementAt(elementAt);
            }
            return new RecordValue(SetOfRcdsValue.this.names, val, false, SetOfRcdsValue.this.cm);
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        private ValueEnumeration[] enums;
        private Value[] currentElems;
        private boolean isDone;

        public Enumerator() {
            this.enums = new ValueEnumeration[SetOfRcdsValue.this.values.length];
            this.currentElems = new Value[SetOfRcdsValue.this.values.length];
            this.isDone = false;
            for (int i = 0; i < SetOfRcdsValue.this.values.length; ++i) {
                if (SetOfRcdsValue.this.values[i] instanceof Enumerable) {
                    this.enums[i] = ((Enumerable)((Object)SetOfRcdsValue.this.values[i])).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] != null) continue;
                    this.enums = null;
                    this.isDone = true;
                    break;
                }
                Assert.fail((String)("Attempted to enumerate a set of the form [l1 : v1, ..., ln : vn],\nbut can't enumerate the value of the `" + SetOfRcdsValue.this.names[i] + "' field:\n" + Values.ppr(SetOfRcdsValue.this.values[i].toString())), (SemanticNode)SetOfRcdsValue.this.getSource());
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                for (int i = 0; i < this.enums.length; ++i) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            int i;
            if (this.isDone) {
                return null;
            }
            Value[] elems = new Value[this.currentElems.length];
            if (Value.coverage) {
                SetOfRcdsValue.this.cm.incSecondary(elems.length);
            }
            for (i = 0; i < elems.length; ++i) {
                elems[i] = this.currentElems[i];
            }
            for (i = elems.length - 1; i >= 0; --i) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == 0) {
                    this.isDone = true;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
            }
            return new RecordValue(SetOfRcdsValue.this.names, elems, true, SetOfRcdsValue.this.cm);
        }
    }
}

