/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.File;
import java.io.IOException;
import java.util.List;
import model.InJarFilenameToStream;
import model.ModelInJar;
import tlc2.TLCGlobals;
import tlc2.tool.Action;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.WorkerException;
import tlc2.tool.distributed.DistApp;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.impl.CallStackTool;
import tlc2.tool.impl.FastTool;
import tlc2.util.FP64;
import util.FileUtil;
import util.FilenameToStream;
import util.ToolIO;
import util.UniqueString;

public class TLCApp
extends DistApp {
    private String config;
    public ITool tool;
    public Action[] invariants;
    public Action[] impliedInits;
    public Action[] impliedActions;
    public Action[] actions;
    private boolean checkDeadlock;
    private final boolean preprocess;
    private String fromChkpt = null;
    private String metadir = null;
    private FPSetConfiguration fpSetConfig;

    public TLCApp(String specFile, String configFile, boolean deadlock, String fromChkpt, FPSetConfiguration fpSetConfig) throws IOException {
        this(specFile, configFile, deadlock, null);
        this.fromChkpt = fromChkpt;
        this.metadir = FileUtil.makeMetaDir((String)this.tool.getSpecDir(), (String)fromChkpt);
        this.fpSetConfig = fpSetConfig;
    }

    public TLCApp(String specFile, String configFile, boolean deadlock, String fromChkpt, FPSetConfiguration fpSetConfig, FilenameToStream fts) throws IOException {
        this(specFile, configFile, deadlock, fts);
        this.fromChkpt = fromChkpt;
        this.metadir = FileUtil.makeMetaDir((String)this.tool.getSpecDir(), (String)fromChkpt);
        this.fpSetConfig = fpSetConfig;
    }

    public TLCApp(String specFile, String configFile, Boolean deadlock, FilenameToStream fts) throws IOException {
        int lastSep = specFile.lastIndexOf(File.separatorChar);
        String specDir = lastSep == -1 ? "" : specFile.substring(0, lastSep + 1);
        specFile = specFile.substring(lastSep + 1);
        this.config = configFile;
        this.checkDeadlock = deadlock;
        this.preprocess = true;
        this.tool = new FastTool(specDir, specFile, configFile, fts);
        this.impliedInits = this.tool.getImpliedInits();
        this.invariants = this.tool.getInvariants();
        this.impliedActions = this.tool.getImpliedActions();
        this.actions = this.tool.getActions();
    }

    @Override
    public final Boolean getCheckDeadlock() {
        return new Boolean(this.checkDeadlock);
    }

    @Override
    public final Boolean getPreprocess() {
        return new Boolean(this.preprocess);
    }

    @Override
    public final String getFileName() {
        return this.tool.getRootFile();
    }

    @Override
    public String getSpecDir() {
        return this.tool.getSpecDir();
    }

    @Override
    public String getConfigName() {
        return this.config;
    }

    @Override
    public final String getMetadir() {
        return this.metadir;
    }

    @Override
    public final boolean canRecover() {
        return this.fromChkpt != null;
    }

    public List<File> getModuleFiles() {
        return this.tool.getModuleFiles(new InJarFilenameToStream("/model/"));
    }

    @Override
    public final void getInitStates(IStateFunctor functor) {
        this.tool.getInitStates(functor);
    }

    @Override
    public final TLCState[] getNextStates(TLCState curState) throws WorkerException {
        StateVec nextStates = new StateVec(10);
        for (int i = 0; i < this.actions.length; ++i) {
            Action curAction = this.actions[i];
            StateVec nstates = this.tool.getNextStates(curAction, curState);
            nextStates = nextStates.addElements(nstates);
        }
        int len = nextStates.size();
        if (len == 0 && this.checkDeadlock) {
            throw new WorkerException("Error: deadlock reached.", curState, null, false);
        }
        TLCState[] res = new TLCState[nextStates.size()];
        for (int i = 0; i < nextStates.size(); ++i) {
            TLCState succState = nextStates.elementAt(i);
            if (!this.tool.isGoodState(succState)) {
                String msg = "Error: Successor state is not completely specified by the next-state action.";
                throw new WorkerException(msg, curState, succState, false);
            }
            res[i] = succState;
        }
        return res;
    }

    @Override
    public final void checkState(TLCState s1, TLCState s2) throws WorkerException {
        int i;
        TLCState ts2 = s2;
        for (i = 0; i < this.invariants.length; ++i) {
            if (this.tool.isValid(this.invariants[i], ts2)) continue;
            String msg = "Error: Invariant " + this.tool.getInvNames()[i] + " is violated.";
            throw new WorkerException(msg, s1, s2, false);
        }
        if (s1 == null) {
            for (i = 0; i < this.impliedInits.length; ++i) {
                if (this.tool.isValid(this.impliedInits[i], ts2)) continue;
                String msg = "Error: Implied-init " + this.tool.getImpliedInitNames()[i] + " is violated.";
                throw new WorkerException(msg, s1, s2, false);
            }
        } else {
            TLCState ts1 = s1;
            for (int i2 = 0; i2 < this.impliedActions.length; ++i2) {
                if (this.tool.isValid(this.impliedActions[i2], ts1, ts2)) continue;
                String msg = "Error: Implied-action " + this.tool.getImpliedActNames()[i2] + " is violated.";
                throw new WorkerException(msg, s1, s2, false);
            }
        }
    }

    @Override
    public final boolean isInModel(TLCState s) {
        return this.tool.isInModel(s);
    }

    @Override
    public final boolean isInActions(TLCState s1, TLCState s2) {
        return this.tool.isInActions(s1, s2);
    }

    @Override
    public final TLCStateInfo getState(long fp) {
        return this.tool.getState(fp);
    }

    @Override
    public final TLCStateInfo getState(long fp, TLCState s) {
        return this.tool.getState(fp, s);
    }

    @Override
    public TLCStateInfo getState(TLCState s1, TLCState s) {
        return this.tool.getState(s1, s);
    }

    @Override
    public TLCStateInfo evalAlias(TLCStateInfo current, TLCState successor) {
        return this.tool.evalAlias(current, successor);
    }

    @Override
    public final void setCallStack() {
        this.tool = new CallStackTool(this.tool);
    }

    @Override
    public final String printCallStack() {
        return this.tool.toString();
    }

    public static TLCApp create(String[] args) throws IOException {
        String specFile = null;
        String configFile = null;
        boolean deadlock = true;
        int fpIndex = 0;
        String fromChkpt = null;
        FPSetConfiguration fpSetConfig = new FPSetConfiguration();
        int index = 0;
        while (index < args.length) {
            if (args[index].equals("-config")) {
                if (++index < args.length) {
                    configFile = args[index];
                    if (configFile.endsWith(".cfg")) {
                        configFile = configFile.substring(0, configFile.length() - ".cfg".length());
                    }
                    ++index;
                    continue;
                }
                TLCApp.printErrorMsg("Error: configuration file required.");
                return null;
            }
            if (args[index].equals("-tool")) {
                ++index;
                TLCGlobals.tool = true;
                continue;
            }
            if (args[index].equals("-deadlock")) {
                ++index;
                deadlock = false;
                continue;
            }
            if (args[index].equals("-recover")) {
                if (++index < args.length) {
                    fromChkpt = args[index++] + FileUtil.separator;
                    continue;
                }
                TLCApp.printErrorMsg("Error: need to specify the metadata directory for recovery.");
                return null;
            }
            if (args[index].equals("-checkpoint")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.chkptDuration = Integer.parseInt(args[index]) * 1000 * 60;
                        if (TLCGlobals.chkptDuration < 0L) {
                            TLCApp.printErrorMsg("Error: expect a nonnegative integer for -checkpoint option.");
                        }
                        ++index;
                    }
                    catch (Exception e) {
                        TLCApp.printErrorMsg("Error: An integer for checkpoint interval is required. But encountered " + args[index]);
                    }
                    continue;
                }
                TLCApp.printErrorMsg("Error: checkpoint interval required.");
                continue;
            }
            if (args[index].equals("-coverage")) {
                if (++index < args.length) {
                    try {
                        ToolIO.out.println("Warning: coverage reporting not supported in distributed TLC, ignoring -coverage " + args[index] + " parameter.");
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        TLCApp.printErrorMsg("Error: An integer for coverage report interval required. But encountered " + args[index]);
                        return null;
                    }
                }
                TLCApp.printErrorMsg("Error: coverage report interval required.");
                return null;
            }
            if (args[index].equals("-terse")) {
                ++index;
                TLCGlobals.expand = false;
                continue;
            }
            if (args[index].equals("-nowarning")) {
                ++index;
                TLCGlobals.warn = false;
                continue;
            }
            if (args[index].equals("-maxSetSize")) {
                if (++index < args.length) {
                    try {
                        int bound = Integer.parseInt(args[index]);
                        if (!TLCGlobals.isValidSetSize(bound)) {
                            int maxValue = Integer.MAX_VALUE;
                            TLCApp.printErrorMsg("Error: Value in interval [0, " + maxValue + "] for maxSetSize required. But encountered " + args[index]);
                            return null;
                        }
                        TLCGlobals.setBound = bound;
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        TLCApp.printErrorMsg("Error: An integer for maxSetSize required. But encountered " + args[index]);
                        return null;
                    }
                }
                TLCApp.printErrorMsg("Error: maxSetSize required.");
                return null;
            }
            if (args[index].equals("-fp")) {
                if (++index < args.length) {
                    try {
                        fpIndex = Integer.parseInt(args[index]);
                        if (fpIndex < 0 || fpIndex >= FP64.Polys.length) {
                            TLCApp.printErrorMsg("Error: The number for -fp must be between 0 and " + (FP64.Polys.length - 1) + " (inclusive).");
                            return null;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        TLCApp.printErrorMsg("Error: A number for -fp is required. But encountered " + args[index]);
                        return null;
                    }
                }
                TLCApp.printErrorMsg("Error: expect an integer for -workers option.");
                return null;
            }
            if (args[index].equals("-fpbits")) {
                if (++index < args.length) {
                    try {
                        int fpBits = Integer.parseInt(args[index]);
                        if (!FPSet.isValid(fpBits)) {
                            TLCApp.printErrorMsg("Error: Value in interval [0, 30] for fpbits required. But encountered " + args[index]);
                            return null;
                        }
                        fpSetConfig.setFpBits(fpBits);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        TLCApp.printErrorMsg("Error: A number for -fpbits is required. But encountered " + args[index]);
                        return null;
                    }
                }
                TLCApp.printErrorMsg("Error: expect an integer for -workers option.");
                return null;
            }
            if (args[index].equals("-fpmem")) {
                if (++index >= args.length) continue;
                try {
                    double fpmem = Double.parseDouble(args[index]);
                    if (fpmem < 0.0) {
                        TLCApp.printErrorMsg("Error: An positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index]);
                        return null;
                    }
                    if (fpmem > 1.0) {
                        ToolIO.out.println("Using -fpmem with an abolute memory value has been deprecated. Please allocate memory for the TLC process via the JVM mechanisms and use -fpmem to set the fraction to be used for fingerprint storage.");
                        fpSetConfig.setMemory((long)fpmem);
                        fpSetConfig.setRatio(1.0);
                    } else {
                        fpSetConfig.setRatio(fpmem);
                    }
                    ++index;
                    continue;
                }
                catch (Exception e) {
                    TLCApp.printErrorMsg("Error: A positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index]);
                    return null;
                }
            }
            if (args[index].equals("-metadir")) {
                if (++index < args.length) {
                    TLCGlobals.metaDir = args[index++] + FileUtil.separator;
                    continue;
                }
                TLCApp.printErrorMsg("Error: need to specify the metadata directory.");
                return null;
            }
            if (args[index].charAt(0) == '-') {
                TLCApp.printErrorMsg("Error: unrecognized option: " + args[index]);
                return null;
            }
            if (specFile != null) {
                TLCApp.printErrorMsg("Error: more than one input files: " + specFile + " and " + args[index]);
                return null;
            }
            if (!(specFile = args[index++]).endsWith(".tla")) continue;
            specFile = specFile.substring(0, specFile.length() - ".tla".length());
        }
        if (specFile == null) {
            if (ModelInJar.hasModel()) {
                ModelInJar.loadProperties();
                TLCGlobals.tool = true;
                TLCGlobals.chkptDuration = 0L;
                FP64.Init(fpIndex);
                InJarFilenameToStream resolver = new InJarFilenameToStream("/model/");
                return new TLCApp("MC", "MC", deadlock, fromChkpt, fpSetConfig, resolver);
            }
            TLCApp.printErrorMsg("Error: Missing input TLA+ module.");
            return null;
        }
        if (configFile == null) {
            configFile = specFile;
        }
        if (fromChkpt != null) {
            UniqueString.internTbl.recover(fromChkpt);
        }
        FP64.Init(fpIndex);
        return new TLCApp(specFile, configFile, deadlock, fromChkpt, fpSetConfig);
    }

    private static void printErrorMsg(String msg) {
        ToolIO.out.println(msg);
        ToolIO.out.println("Usage: java tlc2.tool.TLCServer [-option] inputfile");
    }

    public FPSetConfiguration getFPSetConfiguration() {
        return this.fpSetConfig;
    }
}

