/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import tlc2.util.BigInt;
import tlc2.util.ByteUtils;
import util.FileUtil;
import util.Set;

public class BigSet
implements Cloneable {
    private static int MaxSize = 10000;
    private static int InitialSize = 840;
    private boolean USEBUFFERS = true;
    private boolean USEGZIP = false;
    private int BUFFERSIZE = 1024;
    private int maxSize;
    private int initialSize;
    private String file;
    private int filePtr;
    public Set els;

    public BigSet(String file) {
        this(MaxSize, InitialSize, file);
    }

    public BigSet(int maxSize, String file) {
        this(maxSize, InitialSize, file);
    }

    public BigSet(int maxSize, int initialSize, String file) {
        this.maxSize = maxSize;
        this.initialSize = initialSize;
        this.file = file;
        this.filePtr = 0;
        this.els = new Set(initialSize);
        try {
            new File(file + "0").createNewFile();
            new File(file + "1").createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.els.size();
    }

    public void write() throws IOException {
        int i;
        Enumeration e = this.els.elements();
        OutputStream out = FileUtil.newBZFileOutputStream((String)(this.file + this.filePtr), (boolean)this.USEGZIP, (boolean)this.USEBUFFERS, (int)this.BUFFERSIZE, (boolean)true);
        int size = this.size();
        Object[] bA = new BigInt[size];
        for (i = 0; i < this.size(); ++i) {
            bA[i] = (BigInt)e.nextElement();
        }
        Arrays.sort(bA, 0, size - 1);
        ByteUtils.writeInt(out, size);
        for (i = 0; i < this.size(); ++i) {
        }
        out.close();
        this.filePtr = this.filePtr == 0 ? 1 : 0;
    }

    public void clear() throws IOException {
        this.delete();
        this.els = new Set();
    }

    public void delete() throws IOException {
        File f0 = new File(this.file + "0");
        File f1 = new File(this.file + "1");
        f0.delete();
        f1.delete();
        this.filePtr = 0;
    }

    public void put(Object key) throws IOException {
        this.els.put(key);
        if (this.size() >= this.maxSize) {
            this.write();
            this.els = new Set(this.initialSize);
        }
    }

    public boolean contains(Object key) {
        return this.els.contains(key);
    }
}

