/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.IBoolValue;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;

public class BoolValue
extends Value
implements IBoolValue {
    public boolean val;
    public static final BoolValue ValFalse = new BoolValue(false);
    public static final BoolValue ValTrue = new BoolValue(true);

    public BoolValue(boolean b) {
        this.val = b;
    }

    @Override
    public final boolean getVal() {
        return this.val;
    }

    @Override
    public final byte getKind() {
        return 0;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof BoolValue) {
                int x = this.val ? 1 : 0;
                int y = ((BoolValue)obj).val ? 1 : 0;
                return x - y;
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail((String)("Attempted to compare boolean " + Values.ppr(this.toString()) + " with non-boolean:\n" + Values.ppr(obj.toString())), (SemanticNode)this.getSource());
            }
            return 1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof BoolValue) {
                return this.val == ((BoolValue)obj).val;
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail((String)("Attempted to compare equality of boolean " + Values.ppr(this.toString()) + " with non-boolean:\n" + Values.ppr(obj.toString())), (SemanticNode)this.getSource());
            }
            return ((ModelValue)obj).modelValueEquals(this);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail((String)("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the boolean " + Values.ppr(this.toString())), (SemanticNode)this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail((String)("Attempted to check if the boolean " + Values.ppr(this.toString()) + " is a finite set."), (SemanticNode)this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail((String)("Attempted to apply EXCEPT construct to the boolean " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail((String)("Attempted to apply EXCEPT construct to the boolean " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail((String)("Attempted to compute the number of elements in the boolean " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public boolean mutates() {
        return false;
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return val instanceof BoolValue && this.val == ((BoolValue)val).val;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        vos.writeByte((byte)0);
        vos.writeBoolean(this.val);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            fp = FP64.Extend(fp, (byte)0);
            fp = FP64.Extend(fp, this.val ? (char)'t' : 'f');
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        return this;
    }

    public final StringBuffer toString(StringBuffer sb, int offset) {
        return this.toString(sb, offset, true);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            return sb.append(this.val ? "TRUE" : "FALSE");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }
}

