/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.util.Context;
import tlc2.value.IBoolValue;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class SetPredValue
extends EnumerableValue
implements Enumerable {
    public final Object vars;
    public Value inVal;
    public final SemanticNode pred;
    public final ITool tool;
    private boolean converted = false;
    public final Context con;
    public final TLCState state;
    public final TLCState pstate;
    public final int control;

    public SetPredValue(Object vars, Value inVal, SemanticNode pred, ITool tool, Context con, TLCState s0, TLCState s1, int control) {
        this.vars = vars;
        this.inVal = inVal;
        this.pred = pred;
        this.tool = tool;
        this.con = con;
        this.state = s0.copy();
        this.pstate = s1 != null ? s1.copy() : null;
        this.control = control;
    }

    public SetPredValue(Object vars, Value inVal, SemanticNode pred, ITool tool, Context con, TLCState s0, TLCState s1, int control, CostModel cm) {
        this(vars, inVal, pred, tool, con, s0, s1, control);
        this.cm = cm;
    }

    public SetPredValue(SetPredValue other, ITool tool) {
        this(other.vars, other.inVal, other.pred, tool, other.con, other.state, other.pstate, other.control, other.cm);
    }

    @Override
    public final byte getKind() {
        return 6;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.inVal = this.toSetEnum();
            this.converted = true;
            return this.inVal.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.inVal = this.toSetEnum();
            this.converted = true;
            return this.inVal.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            if (this.converted) {
                return this.inVal.member(elem);
            }
            try {
                if (this.inVal.member(elem)) {
                    Context con1 = this.con;
                    if (this.vars instanceof FormalParamNode) {
                        con1 = con1.cons((SymbolNode)((FormalParamNode)this.vars), elem);
                    } else {
                        FormalParamNode[] ids = (FormalParamNode[])this.vars;
                        TupleValue tv = (TupleValue)elem.toTuple();
                        if (tv != null && tv.elems.length == ids.length) {
                            Value[] vals = tv.elems;
                            for (int i = 0; i < ids.length; ++i) {
                                con1 = con1.cons((SymbolNode)ids[i], vals[i]);
                            }
                        } else {
                            Assert.fail((String)("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of a set of " + ids.length + "-tuples."), (SemanticNode)this.getSource());
                        }
                    }
                    Value res = (Value)this.tool.eval(this.pred, con1, this.state, this.pstate, this.control);
                    if (!(res instanceof IBoolValue)) {
                        Assert.fail((String)("The evaluation of predicate " + this.pred + " yielded non-Boolean value."), (SemanticNode)this.getSource());
                    }
                    return ((BoolValue)res).val;
                }
            }
            catch (EvalException e) {
                Assert.fail((String)("Cannot decide if element:\n" + Values.ppr(elem.toString()) + "\n is element of:\n" + Values.ppr(this.inVal.toString()) + "\nand satisfies the predicate " + this.pred), (SemanticNode)this.getSource());
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (!this.inVal.isFinite()) {
                Assert.fail((String)("Attempted to check if expression of form {x \\in S : p(x)} is a finite set, but cannot check if S:\n" + Values.ppr(this.inVal.toString()) + "\nis finite."), (SemanticNode)this.getSource());
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail((String)("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail((String)("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.inVal = this.toSetEnum();
            this.converted = true;
            return this.inVal.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.inVal = (Value)ois.readObject();
        this.converted = true;
    }

    private final void writeObject(ObjectOutputStream oos) throws IOException {
        if (!this.converted) {
            this.inVal = this.toSetEnum();
            this.converted = true;
        }
        oos.writeObject(this.inVal);
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.inVal.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            this.inVal.normalize();
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            this.inVal.deepNormalize();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.inVal = this.toSetEnum();
            this.converted = true;
            return this.inVal.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.inVal = this.toSetEnum();
            this.converted = true;
            return this.inVal.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public Value toSetEnum() {
        Value elem;
        if (this.converted) {
            return (SetEnumValue)this.inVal;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, this.isNormalized(), this.cm);
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        this.inVal.write(vos);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            block10: {
                try {
                    if (TLCGlobals.expand) {
                        Value val = this.toSetEnum();
                        return val.toString(sb, offset, swallow);
                    }
                }
                catch (Throwable e) {
                    if (swallow) break block10;
                    throw e;
                }
            }
            sb.append("{");
            if (this.vars instanceof FormalParamNode) {
                sb.append(((FormalParamNode)this.vars).getName());
            } else {
                FormalParamNode[] ids = (FormalParamNode[])this.vars;
                if (ids.length != 0) {
                    sb.append(ids[0].getName());
                }
                for (int i = 1; i < ids.length; ++i) {
                    sb.append(", " + ids[i].getName());
                }
            }
            sb.append(" \\in " + this.inVal + " : <expression ");
            sb.append(this.pred + "> }");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.converted) {
                return ((SetEnumValue)this.inVal).elements();
            }
            return new Enumerator();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration Enum;

        public Enumerator() {
            if (!(SetPredValue.this.inVal instanceof Enumerable)) {
                Assert.fail((String)("Attempted to enumerate { x \\in S : p(x) } when S:\n" + Values.ppr(SetPredValue.this.inVal.toString()) + "\nis not enumerable"), (SemanticNode)SetPredValue.this.getSource());
            }
            this.Enum = ((Enumerable)((Object)SetPredValue.this.inVal)).elements();
        }

        @Override
        public final void reset() {
            this.Enum.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem;
            while ((elem = this.Enum.nextElement()) != null) {
                if (Value.coverage) {
                    SetPredValue.this.cm.incSecondary();
                }
                Context con1 = SetPredValue.this.con;
                if (SetPredValue.this.vars instanceof FormalParamNode) {
                    con1 = con1.cons((SymbolNode)((FormalParamNode)SetPredValue.this.vars), elem);
                } else {
                    FormalParamNode[] ids = (FormalParamNode[])SetPredValue.this.vars;
                    TupleValue tv = (TupleValue)elem.toTuple();
                    if (tv != null && tv.elems.length == ids.length) {
                        Value[] vals = tv.elems;
                        for (int i = 0; i < ids.length; ++i) {
                            con1 = con1.cons((SymbolNode)ids[i], vals[i]);
                        }
                    } else {
                        Assert.fail((String)("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of a set of " + ids.length + "-tuples."), (SemanticNode)SetPredValue.this.getSource());
                    }
                }
                Value res = (Value)SetPredValue.this.tool.eval(SetPredValue.this.pred, con1, SetPredValue.this.state, SetPredValue.this.pstate, SetPredValue.this.control, SetPredValue.this.cm);
                if (!(res instanceof IBoolValue)) {
                    Assert.fail((String)("Evaluating predicate " + SetPredValue.this.pred + " yielded non-Boolean value."), (SemanticNode)SetPredValue.this.getSource());
                }
                if (!((BoolValue)res).val) continue;
                return elem;
            }
            return null;
        }
    }
}

