/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import tlc2.util.statistics.AbstractBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class BucketStatistics
extends AbstractBucketStatistics
implements IBucketStatistics {
    private long observations;
    private final Map<Integer, Long> buckets = new HashMap<Integer, Long>();

    public BucketStatistics(String aTitle) {
        super(aTitle);
    }

    public BucketStatistics(String aTitle, String pkg, String name) {
        super(aTitle, pkg, name);
    }

    @Override
    public void addSample(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Negative amount invalid");
        }
        Long l = this.buckets.get(amount);
        if (l == null) {
            this.buckets.put(amount, 1L);
        } else {
            l = l + 1L;
            this.buckets.replace(amount, l);
        }
        ++this.observations;
    }

    @Override
    public long getObservations() {
        return this.observations;
    }

    @Override
    public NavigableMap<Integer, Long> getSamples() {
        TreeMap<Integer, Long> res = new TreeMap<Integer, Long>();
        for (Map.Entry<Integer, Long> entry : this.buckets.entrySet()) {
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public void add(IBucketStatistics stat) {
        this.observations += stat.getObservations();
        for (Map.Entry entry : stat.getSamples().entrySet()) {
            Long l = this.buckets.get(entry.getKey());
            if (l == null) {
                this.buckets.put((Integer)entry.getKey(), (Long)entry.getValue());
                continue;
            }
            this.buckets.replace((Integer)entry.getKey(), l + (Long)entry.getValue());
        }
    }
}

