/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class FP64 {
    public static final long Zero = 0L;
    private static final long One = Long.MIN_VALUE;
    private static final long X63 = 1L;
    public static final long[] Polys = new long[]{-7992595565342442794L, -2699332217222594175L, -4598430943791379041L, -3019739338591406062L, -4107963342645125260L, -2515093551313386284L, -776505536601402557L, -5630083135614502665L, -5254575548073654734L, -2327445340997796541L, -4882326079550032221L, -2615270644067662454L, -775008587996898081L, -3864272197278230456L, -9158070649602106719L, -6101220841033661071L, -4672680293510637099L, -7810615416689784242L, -5219208432626862671L, -8360777200461061214L, -1390698851726181805L, -419610530161549174L, -5412757708991914716L, -5783355893217150078L, -7439549329653649681L, -2195228445618577884L, -400314349269779072L, -8570009277684955799L, -3497100286267038746L, -1486686929982606155L, -7856540860260807595L, -6198151276665267479L, -8887938262783927330L, -1453422371545293086L, -6692414561611172656L, -6371809181269344695L, -2749998840421264870L, -7915153096708349877L, -338744388332153299L, -6297374585171501888L, -5523088617805144195L, -7939644929312186686L, -1124655544753184592L, -3792770428913307562L, -3281234478852038216L, -4892463364675254365L, -2217832603206668234L, -1331374287250686233L, -7267523466606867786L, -1738321455462685282L, -6150802277380229060L, -110113725235445376L, -4457128072119866268L, -3624671914112399857L, -4182571553282356575L, -6804213555496406219L, -6569412558207616258L, -4533627881549836176L, -1392269234450390036L, -4985513195125133560L, -2388718663239152830L, -7346272704004454181L, -7312961309885046341L, -5254431361206867195L, -990652367664475459L, -5209471475080475700L, -5532212174813790233L, -2644902469694984290L, -2000688556195925322L, -1665820305993667152L, -3342085367906296698L, -7564694082789388165L, -5718631349457502426L, -6726535006146817876L, -1970522998145721530L, -1843942613412389290L, -2239846009696965701L, -6288268672470903517L, -4704458737221873887L, -2903040481684477777L, -8830960495520397895L, -1736201464746712572L, -6486013831446214924L, -5118025515346833515L, -5475128067245503664L, -1388890570226085940L, -2266513791608236321L, -2963220520140972714L, -673278291838526045L, -399491431216514107L, -6866103513044862948L, -8324780541890576965L, -4228476923883220959L, -5731449652569774110L, -7861979307350773445L, -5779900630015930330L, -1042795336841932406L, -538788514646451924L, -3267309680961036418L, -3033274552568566369L, -4991703735361978865L, -3027395882654934139L, -6106175853669704702L, -5210324884174482454L, -372280819128404427L, -7627993098881222211L, -8587394804323399534L, -3411737919000533220L, -4818836799761841740L, -8897708142162611478L, -2247154345763986796L, -8160912105029609286L, -709725579108489918L, -2968847426337416759L, -4850979823886965104L, -7889888261561005066L, -6024846458603998795L, -2968976614455703520L, -1025136612270310441L, -6037682727139788891L, -4824965849458527978L, -7765771248582875730L, -1952252023502360901L, -1645419755945995996L, -5782093672904635258L, -2312513459318282133L, -8418937898626476469L, -9187706222534533617L, -6643529451767645187L, -8909386485861945547L, -7929249073132661339L};
    private static final long[] ByteModTable_7 = new long[256];
    private static long IrredPoly;

    public static long New() {
        return IrredPoly;
    }

    public static long New(String s) {
        return FP64.Extend(IrredPoly, s);
    }

    public static long New(char[] c) {
        return FP64.Extend(IrredPoly, c, 0, c.length);
    }

    public static long New(char[] c, int off, int len) {
        return FP64.Extend(IrredPoly, c, off, len);
    }

    public static long New(byte[] bytes) {
        return FP64.Extend(IrredPoly, bytes, 0, bytes.length);
    }

    public static long New(InputStream is) throws IOException {
        return FP64.Extend(IrredPoly, is);
    }

    public static long Extend(long fp, String s) {
        long[] mod = ByteModTable_7;
        int mask = 255;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            fp = fp >>> 8 ^ mod[(c ^ (int)fp) & 0xFF];
        }
        return fp;
    }

    public static long Extend(long fp, char[] chars, int start2, int len) {
        long[] mod = ByteModTable_7;
        int end = start2 + len;
        for (int i = start2; i < end; ++i) {
            fp = fp >>> 8 ^ mod[(chars[i] ^ (int)fp) & 0xFF];
        }
        return fp;
    }

    public static long Extend(long fp, byte[] bytes, int start2, int len) {
        long[] mod = ByteModTable_7;
        int end = start2 + len;
        for (int i = start2; i < end; ++i) {
            fp = fp >>> 8 ^ mod[(bytes[i] ^ (int)fp) & 0xFF];
        }
        return fp;
    }

    public static long Extend(long fp, InputStream is) throws IOException {
        int i;
        long[] mod = ByteModTable_7;
        int mask = 255;
        while ((i = is.read()) != -1) {
            fp = fp >>> 8 ^ mod[(i ^ (int)fp) & 0xFF];
        }
        return fp;
    }

    public static long Extend(long fp, char c) {
        long[] mod = ByteModTable_7;
        fp = fp >>> 8 ^ mod[(c ^ (int)fp) & 0xFF];
        return fp;
    }

    public static long Extend(long fp, byte b) {
        long[] mod = ByteModTable_7;
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        return fp;
    }

    public static long ExtendLoop(long fp, int x) {
        long[] mod = ByteModTable_7;
        for (int i = 0; i < 4; ++i) {
            byte b = (byte)(x & 0xFF);
            fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
            x >>>= 8;
        }
        return fp;
    }

    public static long Extend(long fp, int x) {
        long[] mod = ByteModTable_7;
        byte b = (byte)(x & 0xFF);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((x >>>= 8) & 0xFF);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((x >>>= 8) & 0xFF);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((x >>>= 8) & 0xFF);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        return fp;
    }

    public static long Extend(long fp, long fp1) {
        long[] mod = ByteModTable_7;
        byte b = (byte)(fp1 & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((fp1 >>>= 8) & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((fp1 >>>= 8) & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((fp1 >>>= 8) & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((fp1 >>>= 8) & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((fp1 >>>= 8) & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((fp1 >>>= 8) & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        b = (byte)((fp1 >>>= 8) & 0xFFL);
        fp = fp >>> 8 ^ mod[(b ^ (int)fp) & 0xFF];
        return fp;
    }

    public static int Hash(long fp) {
        return (int)fp;
    }

    public static long getIrredPoly() {
        return IrredPoly;
    }

    public static void InitRnd() {
        FP64.Init(new Random().nextInt(Polys.length));
    }

    public static void Init() {
        FP64.Init(0);
    }

    public static void Init(int n) {
        FP64.Init(Polys[n]);
    }

    public static void Init(long poly) {
        IrredPoly = poly;
        int plength = 72;
        long[] PowerTable = new long[plength];
        long t = Long.MIN_VALUE;
        for (int i = 0; i < plength; ++i) {
            PowerTable[i] = t;
            long mask = (t & 1L) != 0L ? IrredPoly : 0L;
            t = t >>> 1 ^ mask;
        }
        for (int j = 0; j <= 255; ++j) {
            long v = 0L;
            for (int k = 0; k <= 7; ++k) {
                if (((long)j & 1L << k) == 0L) continue;
                v ^= PowerTable[71 - k];
            }
            FP64.ByteModTable_7[j] = v;
        }
    }
}

