/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.fp;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tlc2.tool.distributed.fp.FPSetRMI;
import tlc2.tool.distributed.fp.IFPSetManager;
import tlc2.tool.distributed.fp.callable.BitVectorWrapper;
import tlc2.tool.distributed.fp.callable.CheckFPsCallable;
import tlc2.tool.distributed.fp.callable.CheckInvariantCallable;
import tlc2.tool.distributed.fp.callable.ContainsBlockCallable;
import tlc2.tool.distributed.fp.callable.PutBlockCallable;
import tlc2.util.BitVector;
import tlc2.util.LongVec;
import util.Assert;
import util.ToolIO;

public abstract class FPSetManager
implements IFPSetManager {
    private static final Random rnd = new Random();
    private static final Logger LOGGER = Logger.getLogger(FPSetManager.class.getName());
    protected long mask = Long.MAX_VALUE;
    protected List<FPSets> fpSets;
    protected boolean managerIsBroken = false;
    public static int Port = 10998;

    public FPSetManager() {
        this(new ArrayList<FPSets>());
    }

    public FPSetManager(List<FPSets> fpSets) {
        this.fpSets = fpSets;
    }

    public FPSetManager(FPSetRMI fpSet) {
        this();
        this.fpSets.add(new FPSets(fpSet, fpSet.toString()));
    }

    @Override
    public int numOfServers() {
        return this.fpSets.size();
    }

    @Override
    public int numOfAliveServers() {
        HashSet<FPSets> s = new HashSet<FPSets>();
        s.addAll(this.fpSets);
        int aliveServer = 0;
        Iterator itr = s.iterator();
        while (itr.hasNext()) {
            if (!((FPSets)itr.next()).isAvailable()) continue;
            ++aliveServer;
        }
        return aliveServer;
    }

    public synchronized int reassign(int index) {
        if (index < 0 || index >= this.fpSets.size()) {
            throw new IllegalArgumentException("index not within bounds");
        }
        if (this.managerIsBroken) {
            return -1;
        }
        FPSets broken = this.fpSets.get(index);
        broken.setUnavailable();
        int next = (index + 1) % this.fpSets.size();
        while (next != index) {
            FPSets replacement = this.fpSets.get(next);
            if (replacement.isAvailable()) {
                for (int j = index; j < next; ++j) {
                    this.fpSets.set(j, replacement);
                }
                return next;
            }
            next = (next + 1) % this.fpSets.size();
        }
        this.managerIsBroken = true;
        return -1;
    }

    @Override
    public void close(boolean cleanup) throws IOException {
        FPSets last;
        FPSets curr = null;
        int len = this.fpSets.size();
        int idx = 0;
        int lidx = 0;
        for (idx = 0; idx < len && (curr = this.fpSets.get(idx)) == null; ++idx) {
        }
        if (curr == null) {
            return;
        }
        for (lidx = len - 1; lidx > idx && ((last = this.fpSets.get(lidx)) == null || last == curr); --lidx) {
        }
        for (int i = idx + 1; i <= lidx; ++i) {
            FPSets next = this.fpSets.get(i);
            if (next == null || next == curr) continue;
            try {
                curr.exit(cleanup);
            }
            catch (UnmarshalException unmarshalException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            curr = next;
        }
        if (curr != null) {
            try {
                curr.exit(cleanup);
            }
            catch (UnmarshalException i) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getHostName() {
        String hostname = "Unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hostname;
    }

    @Override
    public boolean put(long fp) {
        int fpIdx = this.getFPSetIndex(fp);
        while (true) {
            try {
                return this.fpSets.get(fpIdx).put(fp);
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(fpIdx).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(fpIdx) != -1) continue;
                ToolIO.out.println("Warning: there is no fp server available.");
                return false;
            }
            break;
        }
    }

    @Override
    public boolean contains(long fp) {
        int fpIdx = this.getFPSetIndex(fp);
        while (true) {
            try {
                return this.fpSets.get(fpIdx).contains(fp);
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(fpIdx).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(fpIdx) != -1) continue;
                ToolIO.out.println("Warning: there is no fp server available.");
                return false;
            }
            break;
        }
    }

    @Override
    public int getFPSetIndex(long fp) {
        return (int)((fp & this.mask) % (long)this.numOfServers());
    }

    @Override
    public BitVector[] putBlock(LongVec[] fps) {
        int len = this.fpSets.size();
        BitVector[] res = new BitVector[len];
        for (int i = 0; i < len; ++i) {
            try {
                res[i] = this.fpSets.get(i).putBlock(fps[i]);
                continue;
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(i) == -1) {
                    ToolIO.out.println("Warning: there is no fp server available.");
                    res[i] = new BitVector(fps[i].size(), true);
                    continue;
                }
                --i;
            }
        }
        return res;
    }

    @Override
    public BitVector[] putBlock(LongVec[] fps, ExecutorService executorService) {
        int len = this.fpSets.size();
        ArrayList<Callable<BitVectorWrapper>> solvers = new ArrayList<Callable<BitVectorWrapper>>();
        for (int i = 0; i < len; ++i) {
            solvers.add(new PutBlockCallable(this, this.fpSets, fps, i));
        }
        return this.executeCallablesAndCollect(executorService, solvers);
    }

    @Override
    public BitVector[] containsBlock(LongVec[] fps) {
        int len = this.fpSets.size();
        BitVector[] res = new BitVector[len];
        for (int i = 0; i < len; ++i) {
            try {
                res[i] = this.fpSets.get(i).containsBlock(fps[i]);
                continue;
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(i) == -1) {
                    ToolIO.out.println("Warning: there is no fp server available.");
                    res[i] = new BitVector(fps[i].size(), true);
                    continue;
                }
                --i;
            }
        }
        return res;
    }

    @Override
    public BitVector[] containsBlock(LongVec[] fps, ExecutorService executorService) {
        int len = this.fpSets.size();
        ArrayList<Callable<BitVectorWrapper>> solvers = new ArrayList<Callable<BitVectorWrapper>>();
        for (int i = 0; i < len; ++i) {
            solvers.add(new ContainsBlockCallable(this, this.fpSets, fps, i));
        }
        return this.executeCallablesAndCollect(executorService, solvers);
    }

    private BitVector[] executeCallablesAndCollect(ExecutorService executorService, List<Callable<BitVectorWrapper>> solvers) {
        int retry = 0;
        ExecutorCompletionService<BitVectorWrapper> ecs = new ExecutorCompletionService<BitVectorWrapper>(executorService);
        for (int i = 0; i < solvers.size(); ++i) {
            Callable<BitVectorWrapper> s = solvers.get(i);
            try {
                ecs.submit(s);
                retry = 0;
                continue;
            }
            catch (RejectedExecutionException e) {
                if (retry++ < 3 && !executorService.isShutdown()) {
                    int sleep = 1 + rnd.nextInt(5);
                    LOGGER.log(Level.FINE, "{0}. time throttleing task submission due to overload during FPSetManager callable execution #{1} for {2} seconds", new Object[]{retry, i});
                    try {
                        Thread.sleep((long)sleep * 1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    --i;
                    continue;
                }
                throw e;
            }
        }
        BitVector[] res = new BitVector[solvers.size()];
        for (int i = 0; i < res.length; ++i) {
            try {
                BitVectorWrapper indexBitVector = (BitVectorWrapper)ecs.take().get();
                int index = indexBitVector.getIndex();
                Assert.check((res[index] == null ? 1 : 0) != 0, (int)1000);
                res[index] = indexBitVector.getBitVector();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkFPs() {
        int len = this.fpSets.size();
        ExecutorService executorService = Executors.newFixedThreadPool(len);
        try {
            ExecutorCompletionService<Long> ecs = new ExecutorCompletionService<Long>(executorService);
            for (int i = 0; i < len; ++i) {
                ecs.submit(new CheckFPsCallable(this.fpSets.get(i).getFpset()));
            }
            long res = Long.MAX_VALUE;
            for (int i = 0; i < len; ++i) {
                try {
                    res = Math.min(res, (Long)ecs.take().get());
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            long l = res;
            return l;
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkInvariant() {
        int len = this.fpSets.size();
        ExecutorService executorService = Executors.newFixedThreadPool(len);
        try {
            int i;
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executorService);
            for (i = 0; i < len; ++i) {
                ecs.submit(new CheckInvariantCallable(this.fpSets.get(i).getFpset()));
            }
            for (i = 0; i < len; ++i) {
                try {
                    if (((Boolean)ecs.take().get()).booleanValue()) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            executorService.shutdown();
        }
    }

    @Override
    public long size() {
        int len = this.fpSets.size();
        long res = 0L;
        for (int i = 0; i < len; ++i) {
            try {
                res += this.fpSets.get(i).size();
                continue;
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(i) != -1) continue;
                ToolIO.out.println("Warning: there is no fp server available.");
            }
        }
        return res;
    }

    @Override
    public long getStatesSeen() {
        long res = 1L;
        int len = this.fpSets.size();
        for (int i = 0; i < len; ++i) {
            try {
                res += this.fpSets.get(i).getStatesSeen();
                continue;
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(i) != -1) continue;
                ToolIO.out.println("Warning: there is no fp server available.");
            }
        }
        return res;
    }

    public long getMask() {
        return this.mask;
    }

    private final void chkptInner(String fname, boolean chkpt) throws InterruptedException {
        int i;
        FPSets last;
        int len = this.fpSets.size();
        Checkpoint[] chkpts = new Checkpoint[len];
        FPSets curr = null;
        int cnt = 0;
        int idx = 0;
        int lidx = 0;
        for (idx = 0; idx < len; ++idx) {
            curr = this.fpSets.get(idx);
            if (curr == null) continue;
            chkpts[cnt] = new Checkpoint(idx, fname, chkpt);
            chkpts[cnt].run();
            ++cnt;
            break;
        }
        if (curr == null) {
            return;
        }
        for (lidx = len - 1; lidx > idx && ((last = this.fpSets.get(lidx)) == null || last == curr); --lidx) {
        }
        for (i = idx + 1; i <= lidx; ++i) {
            FPSets next = this.fpSets.get(i);
            if (next == null || next == curr) continue;
            curr = next;
            chkpts[cnt] = new Checkpoint(i, fname, chkpt);
            chkpts[cnt].run();
            ++cnt;
        }
        for (i = 0; i < cnt; ++i) {
            chkpts[i].join();
        }
    }

    @Override
    public void checkpoint(String fname) throws InterruptedException, IOException {
        this.chkptInner(fname, true);
    }

    @Override
    public void commitChkpt() throws IOException {
    }

    @Override
    public void recover(String fname) throws InterruptedException, IOException {
        this.chkptInner(fname, false);
    }

    public static class FPSets
    implements Serializable {
        private final String hostname;
        private final FPSetRMI fpset;
        private boolean isAvailable = true;

        public FPSets(FPSetRMI fpset, String hostname) {
            this.fpset = fpset;
            this.hostname = hostname;
        }

        public void setUnavailable() {
            this.isAvailable = false;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        public void exit(boolean cleanup) throws IOException {
            this.fpset.exit(cleanup);
        }

        public void recover(String filename) throws IOException {
            this.fpset.recover(filename);
        }

        public void commitChkpt(String filename) throws IOException {
            this.fpset.commitChkpt(filename);
        }

        public void beginChkpt(String filename) throws IOException {
            this.fpset.beginChkpt(filename);
        }

        public long getStatesSeen() throws RemoteException {
            return this.fpset.getStatesSeen();
        }

        public long size() throws IOException {
            return this.fpset.size();
        }

        public BitVector containsBlock(LongVec longVec) throws IOException {
            return this.fpset.containsBlock(longVec);
        }

        public BitVector putBlock(LongVec longVec) throws IOException {
            return this.fpset.putBlock(longVec);
        }

        public boolean put(long fp) throws IOException {
            return this.fpset.put(fp);
        }

        public boolean contains(long fp) throws IOException {
            return this.fpset.contains(fp);
        }

        public String getHostname() {
            return this.hostname;
        }

        public FPSetRMI getFpset() {
            return this.fpset;
        }
    }

    final class Checkpoint
    extends Thread {
        int hostIndex;
        String filename;
        boolean isChkpt;

        public Checkpoint(int index, String fname, boolean chkpt) {
            this.hostIndex = index;
            this.filename = fname;
            this.isChkpt = chkpt;
        }

        @Override
        public void run() {
            try {
                if (this.isChkpt) {
                    FPSetManager.this.fpSets.get(this.hostIndex).beginChkpt(this.filename);
                    FPSetManager.this.fpSets.get(this.hostIndex).commitChkpt(this.filename);
                } else {
                    FPSetManager.this.fpSets.get(this.hostIndex).recover(this.filename);
                }
            }
            catch (IOException e) {
                ToolIO.out.println("Error: Failed to checkpoint the fingerprint server at " + FPSetManager.this.fpSets.get(this.hostIndex).getHostname() + ". This server might be down.");
            }
        }
    }
}

