/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import tlc2.tool.distributed.TLCServerRMI;
import util.FilenameToStream;

public class RMIFilenameToStreamResolver
implements FilenameToStream {
    private static final String javaTempDir = System.getProperty("java.io.tmpdir") + File.separator;
    private TLCServerRMI server;
    private final Map<String, File> fileCache = new HashMap<String, File>();
    private final String rndPrefix = this.getRandomStoragePrefix();

    public RMIFilenameToStreamResolver() {
    }

    public RMIFilenameToStreamResolver(String[] libraryPaths) {
    }

    public void setTLCServer(TLCServerRMI aServer) {
        this.server = aServer;
    }

    public File resolve(String filename, boolean isModule) {
        String name = new FilenameToStream.TLAFile(filename, (FilenameToStream)this).getName();
        File file = this.fileCache.get(name);
        if (file == null || !file.exists()) {
            byte[] bs = new byte[]{};
            try {
                bs = this.server.getFile(name);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            file = this.writeToNewTempFile(name, bs);
            this.fileCache.put(name, file);
        }
        return file;
    }

    public boolean isStandardModule(String moduleName) {
        return false;
    }

    private String getRandomStoragePrefix() {
        File file = new File(javaTempDir + System.currentTimeMillis());
        file.deleteOnExit();
        file.mkdir();
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeToNewTempFile(String name, byte[] bs) {
        FilenameToStream.TLAFile f = new FilenameToStream.TLAFile(this.rndPrefix + File.separator + name, (FilenameToStream)this);
        f.deleteOnExit();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream((File)f);
            outputStream.write(bs);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return f;
    }

    public String getFullPath() {
        StringBuffer buf = new StringBuffer();
        String[] strings = this.fileCache.keySet().toArray(new String[this.fileCache.size()]);
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            buf.append(string);
            if (i >= string.length() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

