/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tlc2.model.MCState;
import tlc2.model.MCVariable;

public class MCError {
    private final String message;
    private final MCError cause;
    private final ArrayList<MCState> states;

    public MCError() {
        this(null);
    }

    public MCError(String errorMessage) {
        this(null, errorMessage);
    }

    public MCError(MCError errorCause, String errorMessage) {
        this.cause = errorCause;
        this.message = errorMessage;
        this.states = new ArrayList();
    }

    public void addState(MCState state) {
        this.states.add(state);
    }

    public List<MCState> getStates() {
        return this.states;
    }

    public String getMessage() {
        return this.message;
    }

    public MCError getCause() {
        return this.cause;
    }

    public void updateStatesForTraceExpression(Map<String, String> variableExpressionMap) {
        for (MCState state : this.states) {
            for (MCVariable variable : state.getVariables()) {
                String expression = variableExpressionMap.get(variable.getName());
                if (expression == null) continue;
                variable.setTraceExpression(expression);
            }
        }
    }

    public String toSequenceOfRecords(boolean includeHeaders) {
        StringBuilder buf = new StringBuilder();
        buf.append("<<");
        buf.append("\n");
        for (int i = 0; i < this.states.size(); ++i) {
            MCState tlcState = this.states.get(i);
            if (tlcState.isBackToState() || tlcState.isStuttering()) continue;
            if (tlcState.getVariables().length == 0 && !includeHeaders) break;
            if (i > 0) {
                buf.append(",").append("\n");
            }
            buf.append(tlcState.asRecord(includeHeaders));
        }
        buf.append("\n");
        buf.append(">>");
        return buf.toString();
    }
}

