/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.LSBDiskFPSet;
import tlc2.tool.fp.MSBDiskFPSet;
import tlc2.tool.fp.MultiFPSet;
import tlc2.tool.fp.OffHeapDiskFPSet;
import util.TLCRuntime;

public abstract class FPSetFactory {
    public static final String IMPL_PROPERTY = FPSet.class.getName() + ".impl";

    private static boolean allocatesOnHeap(Class<? extends FPSet> clazz) {
        return !OffHeapDiskFPSet.class.isAssignableFrom(clazz);
    }

    public static boolean allocatesOnHeap(String clazz) {
        try {
            ClassLoader classLoader = FPSet.class.getClassLoader();
            Class<?> cls = classLoader.loadClass(clazz);
            return FPSetFactory.allocatesOnHeap(cls);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean supportsArchitecture(String clazz) {
        try {
            ClassLoader classLoader = FPSet.class.getClassLoader();
            Class<?> cls = classLoader.loadClass(clazz);
            return FPSetFactory.supports32Bits(cls);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean supports32Bits(Class<? extends FPSet> clazz) {
        return TLCRuntime.getInstance().getArchitecture() != TLCRuntime.ARCH.x86 || !OffHeapDiskFPSet.class.isAssignableFrom(clazz);
    }

    private static boolean isDiskFPSet(Class<? extends FPSet> cls) {
        return DiskFPSet.class.isAssignableFrom(cls);
    }

    static boolean isDiskFPSet(String clazz) {
        try {
            ClassLoader classLoader = FPSet.class.getClassLoader();
            Class<?> cls = classLoader.loadClass(clazz);
            return FPSetFactory.isDiskFPSet(cls);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static FPSet getFPSet() throws RemoteException {
        return FPSetFactory.getFPSet(new FPSetConfiguration());
    }

    public static FPSet getFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        String implClassname = fpSetConfig.getImplementation();
        if (fpSetConfig.allowsNesting()) {
            return new MultiFPSet(fpSetConfig);
        }
        if (implClassname != null) {
            if (FPSetFactory.supportsArchitecture(implClassname)) {
                return FPSetFactory.loadImplementation(implClassname, fpSetConfig);
            }
            TLCRuntime.ARCH architecture = TLCRuntime.getInstance().getArchitecture();
            String msg = String.format("Selected fingerprint set (set of visited states) %s does not support current architecture %s. Reverting to default fingerprint set. Off-heap memory allocated via -XX:MaxDirectMemorySize flag cannot be used by default fingerprint set and is therefore wasted.", implClassname, architecture);
            MP.printWarning(2156, msg);
        }
        return new MSBDiskFPSet(fpSetConfig);
    }

    public static Future<FPSet> getFPSetInitialized(final FPSetConfiguration fpSetConfiguration, final String metadir, final String mainFile) {
        final ExecutorService es = Executors.newSingleThreadExecutor();
        return es.submit(new Callable<FPSet>(){

            @Override
            public FPSet call() throws Exception {
                try {
                    FPSet fpSet = FPSetFactory.getFPSet(fpSetConfiguration);
                    fpSet.init(TLCGlobals.getNumWorkers(), metadir, mainFile);
                    FPSet fPSet = fpSet;
                    return fPSet;
                }
                finally {
                    es.shutdown();
                }
            }
        });
    }

    public static String[] getImplementations() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(MSBDiskFPSet.class.getName());
        l.add(LSBDiskFPSet.class.getName());
        l.add(OffHeapDiskFPSet.class.getName());
        return l.toArray(new String[l.size()]);
    }

    public static String getImplementationDefault() {
        return MSBDiskFPSet.class.getName();
    }

    public static String getVMArguments(String clazz, long memory) {
        if (FPSetFactory.allocatesOnHeap(clazz)) {
            return "-Xmx" + memory + "m";
        }
        return "-XX:MaxDirectMemorySize=" + memory + "m";
    }

    private static FPSet loadImplementation(String clazz, FPSetConfiguration fpSetConfig) {
        Exception exp = null;
        try {
            ClassLoader classLoader = FPSet.class.getClassLoader();
            Class<?> factoryClass = classLoader.loadClass(clazz);
            Constructor<?> constructor = factoryClass.getDeclaredConstructor(FPSetConfiguration.class);
            Object instance = constructor.newInstance(fpSetConfig);
            if (instance instanceof FPSet) {
                return (FPSet)instance;
            }
        }
        catch (ClassNotFoundException e) {
            exp = e;
        }
        catch (InstantiationException e) {
            exp = e;
        }
        catch (IllegalAccessException e) {
            exp = e;
        }
        catch (SecurityException e) {
            exp = e;
        }
        catch (NoSuchMethodException e) {
            exp = e;
        }
        catch (IllegalArgumentException e) {
            exp = e;
        }
        catch (InvocationTargetException e) {
            exp = e;
        }
        MP.printWarning(1000, "unsuccessfully trying to load custom FPSet class: " + clazz, exp);
        return null;
    }
}

