/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.overrides.Evaluation;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.Action;
import tlc2.tool.EvalException;
import tlc2.tool.ModelChecker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.util.IdThread;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.Assert;

public class TLCExt {
    public static final long serialVersionUID = 20210223L;
    private static final Scanner scanner = new Scanner(System.in);

    @Evaluation(definition="AssertError", module="TLCExt", warn=false, silent=true)
    public static synchronized Value assertError(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        block2: {
            Assert.check((boolean)(args[0] instanceof StringNode), (String)("In computing AssertError, a non-string expression (" + args[0] + ") was used as the err of an AssertError(err, exp)."));
            try {
                tool.eval((SemanticNode)args[1], c, s0, s1, control, cm);
            }
            catch (EvalException | Assert.TLCRuntimeException e) {
                StringValue err = (StringValue)tool.eval((SemanticNode)args[0], c, s0);
                if (!err.val.equals(e.getMessage())) break block2;
                return BoolValue.ValTrue;
            }
        }
        return BoolValue.ValFalse;
    }

    @Evaluation(definition="PickSuccessor", module="TLCExt", warn=false, silent=true)
    public static synchronized Value pickSuccessor(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            if (TLCGlobals.mainChecker != null && ((ModelChecker)TLCGlobals.mainChecker).theFPSet.contains(s1.fingerPrint())) {
                return BoolValue.ValTrue;
            }
        }
        catch (IOException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            return BoolValue.ValTrue;
        }
        Value guard = tool.eval((SemanticNode)args[0], c, s0, s1, control, cm);
        if (!(guard instanceof BoolValue)) {
            Assert.fail((String)("In evaluating TLCExt!PickSuccessor, a non-boolean expression (" + guard.getKindString() + ") was used as the condition of an IF.\n" + args[0]));
        }
        if (((BoolValue)guard).val) {
            return BoolValue.ValTrue;
        }
        Action action = null;
        if (s1 instanceof TLCStateMutExt) {
            action = s1.getAction();
        } else {
            for (Action act : tool.getActions()) {
                StateVec nextStates = tool.getNextStates(act, s0);
                if (!nextStates.contains(s1)) continue;
                action = act;
                break;
            }
        }
        while (true) {
            MP.printMessage(20000, String.format("Extend behavior of length %s with a \"%s\" step [%s]? (Yes/no/explored/states/diff):", s0.getLevel(), action.getName(), action));
            String nextLine = scanner.nextLine();
            if (nextLine.trim().isEmpty() || nextLine.toLowerCase().startsWith("y")) {
                return BoolValue.ValTrue;
            }
            if (nextLine.charAt(0) == 's') {
                MP.printMessage(20000, String.format("%s\n~>\n%s", s0.toString().trim(), s1.toString().trim()));
                continue;
            }
            if (nextLine.charAt(0) == 'd') {
                MP.printMessage(20000, s1.toString(s0));
                continue;
            }
            if (nextLine.charAt(0) == 'e') {
                if (TLCGlobals.mainChecker != null) {
                    try {
                        ((ModelChecker)TLCGlobals.mainChecker).theFPSet.put(s1.fingerPrint());
                    }
                    catch (IOException notExpectedToHappen) {
                        notExpectedToHappen.printStackTrace();
                    }
                    return BoolValue.ValTrue;
                }
                MP.printMessage(20000, String.format("Marking a state explored is unsupported by the current TLC mode. Is TLC running in simulation mode?", new Object[0]));
                continue;
            }
            if (nextLine.charAt(0) == 'n') break;
        }
        return BoolValue.ValFalse;
    }

    @Evaluation(definition="Trace", module="TLCExt", minLevel=1, warn=false, silent=true)
    public static synchronized TupleValue getTrace(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) throws IOException {
        Object trace;
        if (!s0.allAssigned()) {
            Set<OpDeclNode> unassigned = s0.getUnassigned();
            Assert.fail((int)1000, (String)String.format("In evaluating TLCExt!Trace, the state is not completely specified yet (variable%s %s undefined).", unassigned.size() > 1 ? "s" : "", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))));
        }
        if (TLCGlobals.simulator != null) {
            trace = TLCGlobals.simulator.getTrace(s0);
            Value[] values = new Value[((StateVec)trace).size()];
            for (int j = 0; j < ((StateVec)trace).size(); ++j) {
                TLCState state = ((StateVec)trace).elementAt(j);
                values[j] = new RecordValue(state, state.getAction());
            }
            return new TupleValue(values);
        }
        if (s0.isInitial()) {
            return new TupleValue(new Value[]{new RecordValue(s0)});
        }
        if (s0.uid == -1L) {
            trace = new ArrayList();
            TLCState currentState = IdThread.getCurrentState();
            if (currentState.isInitial()) {
                trace.add(new TLCStateInfo(currentState));
                trace.add(new TLCStateInfo(s0));
            } else {
                trace.addAll(Arrays.asList(TLCGlobals.mainChecker.getTraceInfo(currentState)));
                trace.add(new TLCStateInfo(currentState));
                trace.add(new TLCStateInfo(s0));
                IdThread.setCurrentState(currentState);
            }
            return new TupleValue((Value[])trace.stream().map(si -> new RecordValue(si.state)).toArray(Value[]::new));
        }
        return TLCExt.getTrace0(s0, TLCGlobals.mainChecker.getTraceInfo(s0));
    }

    private static final TupleValue getTrace0(TLCState s0, TLCStateInfo[] trace) {
        Value[] values = new Value[trace.length + 1];
        for (int j = 0; j < trace.length; ++j) {
            values[j] = new RecordValue(trace[j].state);
        }
        values[values.length - 1] = new RecordValue(s0);
        return new TupleValue(values);
    }

    @Evaluation(definition="TLCDefer", module="TLCExt", warn=false, silent=true)
    public static Value tlcDefer(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            s1.setCallable(() -> {
                Value[] argVals = new Value[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argVals[i] = tool.eval((SemanticNode)args[i], c, s0, s1, control, cm);
                }
                return null;
            });
        }
        catch (Throwable e) {
            Assert.fail((int)2154, (String[])new String[]{"TLCDefer", e.getMessage()});
        }
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="TLCNoOp", module="TLCExt", warn=false)
    public static Value tlcNoOp(Value val) {
        return val;
    }
}

