/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.OpDefNode;
import tlc2.model.Assignment;
import tlc2.model.Formula;
import util.StringHelper;

public final class SpecWriterUtilities {
    public static String MODIFICATION_HISTORY = "\\* Modification History";
    public static String LAST_MODIFIED = StringHelper.PLATFORM_NEWLINE + "\\* Last modified ";
    public static String MODIFIED_BY = " by ";
    public static final Pattern ID_MATCHER = Pattern.compile("(spec|init|next|const|symm|def_ov|constr|action_constr|inv|prop)_[0-9]{17,}");
    private static final AtomicLong COUNTER = new AtomicLong(1L);

    public static StringBuilder getModuleClosingTag(int rightMarginWidth, boolean addModificationHistory) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringHelper.copyString((String)"=", (int)rightMarginWidth)).append(StringHelper.PLATFORM_NEWLINE);
        if (addModificationHistory) {
            buffer.append(MODIFICATION_HISTORY).append(StringHelper.PLATFORM_NEWLINE).append("\\* Created ").append(new Date()).append(MODIFIED_BY).append(System.getProperty("user.name")).append(StringHelper.PLATFORM_NEWLINE);
        }
        return buffer;
    }

    public static StringBuilder getGeneratedTimeStampCommentLine() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\\* Generated on ").append(new Date());
        return buffer;
    }

    public static String getValidIdentifier(String scheme) {
        return String.format("%s_%s%s", scheme, System.currentTimeMillis(), 1000L * COUNTER.incrementAndGet());
    }

    public static String getValidIdentifierNoTimestamp(String scheme) {
        return String.format("_%s", scheme);
    }

    public static List<String[]> createListContent(List<Formula> formulaList, String labelingScheme) {
        ArrayList<String[]> resultContent = new ArrayList<String[]>(formulaList.size());
        for (int i = 0; i < formulaList.size(); ++i) {
            String label = SpecWriterUtilities.getValidIdentifier(labelingScheme);
            String[] content = new String[]{label, label + " ==\n" + formulaList.get(i).getFormula(), String.valueOf(i)};
            resultContent.add(content);
        }
        return resultContent;
    }

    public static String getModuleNameChecked(String moduleFilename, boolean checkExistence) {
        File f = new File(moduleFilename);
        int index = f.getName().lastIndexOf(46);
        if (checkExistence) {
            return f.exists() ? (index != -1 ? f.getName().substring(0, index) : f.getName()) : null;
        }
        return index != -1 ? f.getName().substring(0, index) : f.getName();
    }

    public static StringBuilder getExtendingModuleContent(String moduleFilename, String ... extendedModuleName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("----").append(' ').append("MODULE").append(' ');
        buffer.append(SpecWriterUtilities.getModuleNameChecked(moduleFilename, false)).append(' ').append("----").append('\n');
        buffer.append("EXTENDS").append(' ');
        buffer.append(String.join((CharSequence)", ", extendedModuleName));
        buffer.append("\n\n");
        return buffer;
    }

    public static List<String[]> createFalseInit(String var) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String identifier = SpecWriterUtilities.getValidIdentifier("init");
        list.add(new String[]{identifier, identifier + " ==\n" + "FALSE/\\" + var + " = " + "0"});
        return list;
    }

    public static List<String[]> createFalseNext(String var) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String identifier = SpecWriterUtilities.getValidIdentifier("next");
        list.add(new String[]{identifier, identifier + " ==\n" + "FALSE/\\" + var + "'" + " = " + var});
        return list;
    }

    public static List<String[]> createFormulaListContent(List<String> serializedFormulaList, String labelingScheme) {
        List<Formula> formulaList = Formula.deserializeFormulaList(serializedFormulaList);
        return SpecWriterUtilities.createFormulaListContentFormula(formulaList, labelingScheme);
    }

    public static List<String[]> createFormulaListContentFormula(List<Formula> serializedFormulaList, String labelingScheme) {
        return SpecWriterUtilities.createListContent(serializedFormulaList, labelingScheme);
    }

    public static List<String[]> createSourceContent(String value, String labelingScheme) {
        return SpecWriterUtilities.createSourceContent(value, labelingScheme, true);
    }

    public static List<String[]> createSourceContent(String value, String identifierOrLabelingScheme, boolean isScheme) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (value == null || value.trim().length() == 0) {
            return result;
        }
        String identifier = isScheme ? SpecWriterUtilities.getValidIdentifier(identifierOrLabelingScheme) : identifierOrLabelingScheme;
        StringBuilder buffer = new StringBuilder();
        buffer.append(identifier).append(" ==\n");
        buffer.append(value);
        result.add(new String[]{identifier, buffer.toString()});
        return result;
    }

    public static List<String[]> createOverridesContent(List<Assignment> overrides, String labelingScheme, SpecObj specObj) {
        ArrayList<String[]> resultContent = new ArrayList<String[]>(overrides.size());
        if (specObj == null) {
            return resultContent;
        }
        OpDefNode[] opDefNodes = specObj.getExternalModuleTable().getRootModule().getOpDefs();
        HashMap<String, OpDefNode> nodeTable = new HashMap<String, OpDefNode>(opDefNodes.length);
        for (int j = 0; j < opDefNodes.length; ++j) {
            String key = opDefNodes[j].getName().toString();
            nodeTable.put(key, opDefNodes[j]);
        }
        for (int i = 0; i < overrides.size(); ++i) {
            OpDefNode source;
            String id = SpecWriterUtilities.getValidIdentifier(labelingScheme);
            Assignment formula = overrides.get(i);
            OpDefNode defNode = (OpDefNode)nodeTable.get(formula.getLabel());
            String[] content = defNode == null ? null : ((source = defNode.getSource()) == defNode ? (formula.isModelValue() && !formula.isSetOfModelValues() ? new String[]{formula.getLabel() + " = " + formula.getLabel(), ""} : new String[]{formula.getLabel() + " <- " + id, formula.getParametrizedLabel(id) + " ==\n" + formula.getRight()}) : (source.getSource() == source ? (formula.isModelValue() && !formula.isSetOfModelValues() ? new String[]{source.getName().toString() + " <- " + "[" + source.getOriginallyDefinedInModuleNode().getName().toString() + "]" + id + " " + id + " = " + source.getName().toString(), "CONSTANT " + id} : new String[]{source.getName().toString() + " <- " + "[" + source.getOriginallyDefinedInModuleNode().getName().toString() + "]" + id, formula.getParametrizedLabel(id) + " ==\n" + formula.getRight()}) : null));
            resultContent.add(content);
        }
        return resultContent;
    }
}

