/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateFun;
import tlc2.tool.liveness.LNState;
import tlc2.util.Context;

class LNStateEnabled
extends LNState {
    private final ExprNode pred;
    private final ExprNode subscript;
    private final boolean isBox;

    public LNStateEnabled(ExprNode pred, Context con, ExprNode subscript, boolean isBox) {
        super(con);
        this.pred = pred;
        this.subscript = subscript;
        this.isBox = isBox;
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        if (this.isBox && this.subscript != null) {
            return true;
        }
        TLCState sfun = TLCStateFun.Empty;
        Context c1 = Context.branch(this.getContext());
        sfun = this.subscript != null ? tool.enabled((SemanticNode)this.pred, c1, s1, sfun, this.subscript, -3) : tool.enabled((SemanticNode)this.pred, c1, s1, sfun);
        return sfun != null;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        sb.append("ENABLED ");
        if (this.subscript == null) {
            this.pred.toString(sb, padding + "        ");
        } else {
            sb.append(this.isBox ? "[" : "<");
            this.pred.toString(sb, padding + "         ");
            sb.append((this.isBox ? "]_" : ">_") + this.subscript);
        }
    }

    @Override
    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        if (this.pred instanceof OpApplNode) {
            TreeNode[] zero;
            OpApplNode oan = (OpApplNode)this.pred;
            sb.append("(");
            for (TreeNode treeNode : zero = oan.getTreeNode().zero()) {
                SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
                sb.append(stn.getHumanReadableImage());
            }
            TreeNode[] one = oan.getTreeNode().one();
            if (one != null) {
                for (TreeNode treeNode : one) {
                    SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
                    sb.append(stn.getHumanReadableImage());
                }
            }
            sb.append(")");
        } else {
            this.toString(sb, "");
        }
        return sb.toString();
    }
}

