/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import tlc2.TLCGlobals;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.management.DiskFPSetMXWrapper;
import tlc2.util.Striped;
import util.Assert;

public abstract class HeapBasedDiskFPSet
extends DiskFPSet {
    protected static final int LogLockCnt = Integer.getInteger(DiskFPSet.class.getName() + ".logLockCnt", 31 - Integer.numberOfLeadingZeros(TLCGlobals.getNumWorkers()) + 8);
    protected final Striped rwLock;
    protected final int lockCnt = 1 << LogLockCnt;
    protected final int lockMask;
    protected long[][] tbl;
    protected long mask;
    protected final int capacity;
    protected int logMaxMemCnt;
    protected static final int BucketSizeIncrement = 4;
    protected static final int LogDefaultMaxTblCnt = 19;
    static final int DefaultMaxTblCnt = 524288;

    protected HeapBasedDiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        this.rwLock = Striped.readWriteLock(this.lockCnt);
        long maxMemCnt = (long)((double)fpSetConfig.getMemoryInFingerprintCnt() / this.getAuxiliaryStorageRequirement());
        if (maxMemCnt - 4L <= 0L) {
            maxMemCnt = 524288L;
        }
        this.logMaxMemCnt = 63 - Long.numberOfLeadingZeros(maxMemCnt);
        Assert.check((this.logMaxMemCnt - 4 >= 0 ? 1 : 0) != 0, (String)"Underflow when computing HeapBasedDiskFPSet");
        int cap = 1 << this.logMaxMemCnt - 4;
        this.capacity = cap < 0 ? 0x7FFFFFF7 : cap;
        this.maxTblCnt = 1L << this.logMaxMemCnt;
        Assert.check((this.maxTblCnt <= fpSetConfig.getMemoryInFingerprintCnt() ? 1 : 0) != 0, (String)"Exceeded upper memory storage limit");
        Assert.check((this.maxTblCnt > (long)this.capacity && (long)this.capacity > this.getTblCnt() ? 1 : 0) != 0, (String)"negative maxTblCnt");
        this.mask = this.capacity - 1;
        this.lockMask = this.lockCnt - 1;
        this.tbl = new long[this.capacity][];
    }

    @Override
    public long sizeof() {
        long size = 44L;
        this.rwLock.acquireAllLocks();
        size += (long)(16 + this.tbl.length * 4);
        for (int i = 0; i < this.tbl.length; ++i) {
            if (this.tbl[i] == null) continue;
            size += 16L + (long)this.tbl[i].length * 8L;
        }
        this.rwLock.releaseAllLocks();
        return size += this.getIndexCapacity() * 4L;
    }

    @Override
    public int getLockCnt() {
        return this.rwLock.size();
    }

    @Override
    public long getTblCapacity() {
        return this.tbl.length;
    }

    protected int getIndex(long fp) {
        return (int)this.index(fp, this.mask);
    }

    protected int getLockIndex(long fp) {
        return (int)this.index(fp, this.lockMask);
    }

    protected long index(long fp, long aMask) {
        return fp & aMask;
    }

    @Override
    public final boolean contains(long fp) throws IOException {
        fp = this.checkValid(fp);
        long fp0 = fp & Long.MAX_VALUE;
        Lock readLock = this.rwLock.getAt(this.getLockIndex(fp0)).readLock();
        readLock.lock();
        if (this.memLookup(fp0)) {
            readLock.unlock();
            this.memHitCnt.increment();
            return true;
        }
        boolean diskHit = this.diskLookup(fp0);
        if (diskHit) {
            this.diskHitCnt.increment();
        }
        readLock.unlock();
        return diskHit;
    }

    @Override
    boolean memLookup(long fp) {
        long[] bucket = this.tbl[this.getIndex(fp)];
        if (bucket == null) {
            return false;
        }
        int bucketLen = bucket.length;
        for (int i = 0; i < bucketLen && bucket[i] != 0L; ++i) {
            if (fp != (bucket[i] & Long.MAX_VALUE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean put(long fp) throws IOException {
        fp = this.checkValid(fp);
        long fp0 = fp & Long.MAX_VALUE;
        Lock readLock = this.rwLock.getAt(this.getLockIndex(fp0)).readLock();
        readLock.lock();
        if (this.memLookup(fp0)) {
            readLock.unlock();
            this.memHitCnt.increment();
            return true;
        }
        boolean diskHit = this.diskLookup(fp0);
        if (diskHit) {
            readLock.unlock();
            this.diskHitCnt.increment();
            return true;
        }
        readLock.unlock();
        Lock w = this.rwLock.getAt(this.getLockIndex(fp0)).writeLock();
        w.lock();
        if (this.memInsert(fp0)) {
            w.unlock();
            this.memHitCnt.increment();
            return true;
        }
        if (this.needsDiskFlush() && this.flusherChosen.compareAndSet(false, true)) {
            ++this.growDiskMark;
            long timestamp = System.currentTimeMillis();
            long insertions = this.getTblCnt();
            this.rwLock.acquireAllLocks();
            this.flusher.flushTable();
            this.rwLock.releaseAllLocks();
            this.forceFlush = false;
            this.flusherChosen.set(false);
            long l = System.currentTimeMillis() - timestamp;
            this.flushTime += l;
            LOGGER.log(Level.FINE, "Flushed disk {0} {1}. time, in {2} sec after {3} insertions.", new Object[]{((DiskFPSetMXWrapper)this.diskFPSetMXWrapper).getObjectName(), this.getGrowDiskMark(), l, insertions});
        }
        w.unlock();
        return false;
    }

    @Override
    boolean memInsert(long fp) {
        int index = this.getIndex(fp);
        long[] bucket = this.tbl[index];
        if (bucket == null) {
            bucket = new long[16];
            bucket[0] = fp;
            this.tbl[index] = bucket;
            this.bucketsCapacity += 16L;
            this.tblLoad.increment();
        } else {
            int j;
            int bucketLen = bucket.length;
            int i = -1;
            for (j = 0; j < bucketLen && bucket[j] != 0L; ++j) {
                long fp1 = bucket[j];
                long l = fp1 & Long.MAX_VALUE;
                if (fp == l) {
                    return true;
                }
                if (i != -1 || fp1 >= 0L) continue;
                i = j;
            }
            if (i == -1) {
                if (j == bucketLen) {
                    long[] oldBucket = bucket;
                    bucket = new long[bucketLen + 4];
                    System.arraycopy(oldBucket, 0, bucket, 0, bucketLen);
                    this.tbl[index] = bucket;
                    this.bucketsCapacity += 4L;
                }
                bucket[j] = fp;
            } else {
                if (j != bucketLen) {
                    bucket[j] = bucket[i];
                }
                bucket[i] = fp;
            }
        }
        this.tblCnt.increment();
        return false;
    }

    @Override
    void acquireTblWriteLock() {
        this.rwLock.acquireAllLocks();
    }

    @Override
    void releaseTblWriteLock() {
        this.rwLock.releaseAllLocks();
    }
}

