/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.DecimalNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tlc2.TLCGlobals;
import tlc2.module.BuiltInModuleHelper;
import tlc2.module.TLCBuiltInOverrides;
import tlc2.output.MP;
import tlc2.overrides.Evaluation;
import tlc2.overrides.ITLCOverrides;
import tlc2.overrides.TLAPlusCallable;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.Defns;
import tlc2.tool.EvalException;
import tlc2.tool.Specs;
import tlc2.tool.TLCStateMut;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.ToolGlobals;
import tlc2.tool.impl.ModelConfig;
import tlc2.tool.impl.OpDefEvaluator;
import tlc2.tool.impl.SymbolNodeValueLookupProvider;
import tlc2.tool.impl.TLAClass;
import tlc2.tool.impl.TLARegistry;
import tlc2.tool.impl.Tool;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.Context;
import tlc2.util.List;
import tlc2.util.Vect;
import tlc2.value.IBoolValue;
import tlc2.value.IValue;
import tlc2.value.ValueConstants;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.CallableValue;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.MethodValue;
import tlc2.value.impl.OpRcdValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import util.Assert;
import util.FilenameToStream;
import util.ToolIO;
import util.UniqueString;

public class SpecProcessor
implements ValueConstants,
ToolGlobals {
    private final String rootFile;
    private final FilenameToStream resolver;
    private final int toolId;
    private final Defns defns;
    private final ModelConfig config;
    private final OpDefEvaluator opDefEvaluator;
    private final SymbolNodeValueLookupProvider symbolNodeValueLookupProvider;
    private final TLAClass tlaClass;
    private OpDeclNode[] variablesNodes;
    private ExternalModuleTable moduleTbl;
    private ModuleNode rootModule;
    private Set<OpDefNode> processedDefs;
    private SpecObj specObj;
    private Defns snapshot;
    private Vect<Action> initPredVec;
    private Action nextPred;
    private Action[] temporals;
    private String[] temporalNames;
    private Action[] impliedTemporals;
    private String[] impliedTemporalNames;
    private Action[] invariants;
    private String[] invNames;
    private Action[] impliedInits;
    private String[] impliedInitNames;
    private Action[] impliedActions;
    private String[] impliedActNames;
    private ExprNode[] modelConstraints;
    private ExprNode[] actionConstraints;
    private ExprNode[] assumptions;
    private boolean[] assumptionIsAxiom;
    private Vect<Action> invVec = new Vect();
    private Vect<String> invNameVec = new Vect();
    private Vect<Action> impliedInitVec = new Vect();
    private Vect<String> impliedInitNameVec = new Vect();
    private Vect<Action> impliedActionVec = new Vect();
    private Vect<String> impliedActNameVec = new Vect();
    private Vect<Action> temporalVec = new Vect();
    private Vect<String> temporalNameVec = new Vect();
    private Vect<Action> impliedTemporalVec = new Vect();
    private Vect<String> impliedTemporalNameVec = new Vect();
    private final Map<ModuleNode, Map<OpDefOrDeclNode, Object>> constantDefns = new HashMap<ModuleNode, Map<OpDefOrDeclNode, Object>>();
    public static final String LAZY_CONSTANT_OPERATORS = SpecProcessor.class.getName() + ".vetoed";
    private static final Set<String> vetos = new HashSet<String>(Arrays.asList(System.getProperty(LAZY_CONSTANT_OPERATORS, "")));

    public SpecProcessor(String rootFile, FilenameToStream resolver, int toolId, Defns defns, ModelConfig config, SymbolNodeValueLookupProvider snvlp, OpDefEvaluator ode, TLAClass tlaClass, Tool.Mode mode) {
        this.rootFile = rootFile;
        this.resolver = resolver;
        this.toolId = toolId;
        this.defns = defns;
        this.config = config;
        this.tlaClass = tlaClass;
        this.processedDefs = new HashSet<OpDefNode>();
        this.initPredVec = new Vect(5);
        this.opDefEvaluator = ode;
        this.symbolNodeValueLookupProvider = snvlp;
        this.processSpec(mode);
        this.snapshot = defns.snapshot();
        if (this.opDefEvaluator != null) {
            this.processConstantDefns();
        }
        this.processConfig();
    }

    private void processConstantDefns() {
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        for (int i = 0; i < mods.length; ++i) {
            if (mods[i].isInstantiated() && (mods[i].getConstantDecls().length != 0 || mods[i].getVariableDecls().length != 0)) continue;
            this.processConstantDefns(mods[i]);
        }
    }

    public final Map<ModuleNode, Map<OpDefOrDeclNode, Object>> getConstantDefns() {
        return this.constantDefns;
    }

    private void processConstantDefns(ModuleNode mod) {
        OpDefNode opDef;
        OpDeclNode[] consts = mod.getConstantDecls();
        for (int i = 0; i < consts.length; ++i) {
            Object val = consts[i].getToolObject(this.toolId);
            if (val != null && val instanceof IValue) {
                ((IValue)val).initialize();
                this.constantDefns.computeIfAbsent(mod, key -> new HashMap()).put(consts[i], val);
                continue;
            }
            if (val == null || !(val instanceof OpDefNode)) continue;
            opDef = (OpDefNode)val;
            Assert.check((opDef.getArity() == consts[i].getArity() ? 1 : 0) != 0, (int)2225, (String[])new String[]{consts[i].getName().toString(), opDef.getName().toString()});
            if (opDef.getArity() != 0) continue;
            try {
                Object defVal = WorkerValue.demux(this.opDefEvaluator, (SemanticNode)consts[i], opDef);
                opDef.setToolObject(this.toolId, defVal);
                this.constantDefns.computeIfAbsent(mod, key -> new HashMap()).put(opDef, defVal);
                continue;
            }
            catch (EvalException | Assert.TLCRuntimeException e) {
                String addendum = e instanceof EvalException ? "" : " - specifically: " + e.getMessage();
                Assert.fail((int)2281, (String[])new String[]{consts[i].getName().toString(), opDef.getName().toString(), addendum});
            }
        }
        OpDefNode[] opDefs = mod.getOpDefs();
        for (int i = 0; i < opDefs.length; ++i) {
            Object realDef;
            boolean evaluate;
            opDef = opDefs[i];
            ModuleNode moduleNode = opDef.getOriginallyDefinedInModuleNode();
            boolean bl = evaluate = moduleNode == null || !moduleNode.isInstantiated() || moduleNode.getConstantDecls().length == 0 && moduleNode.getVariableDecls().length == 0;
            if (!evaluate || opDef.getArity() != 0 || !((realDef = this.symbolNodeValueLookupProvider.lookup((SymbolNode)opDef, Context.Empty, false, this.toolId)) instanceof OpDefNode) || this.symbolNodeValueLookupProvider.getLevelBound((SemanticNode)(opDef = (OpDefNode)realDef).getBody(), Context.Empty, this.toolId) != 0) continue;
            try {
                UniqueString opName = opDef.getName();
                if (this.isVetoed(opName)) continue;
                Object val = WorkerValue.demux(this.opDefEvaluator, opDef);
                opDef.setToolObject(this.toolId, val);
                Object def = this.defns.get(opName);
                if (def != opDef) continue;
                this.defns.put(opName, val);
                this.constantDefns.computeIfAbsent(opDef.hasSource() ? opDef.getSource().getOriginallyDefinedInModuleNode() : moduleNode, key -> new HashMap()).put(opDef, val);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ModuleNode[] imods = mod.getInnerModules();
        for (int i = 0; i < imods.length; ++i) {
            this.processConstantDefns(imods[i]);
        }
    }

    private boolean isVetoed(UniqueString us) {
        return vetos.contains(us.toString());
    }

    private final void processSpec(Tool.Mode mode) {
        Object modName;
        Object myVal;
        String rhs;
        int i;
        this.specObj = new SpecObj(this.rootFile, this.resolver);
        if (TLCGlobals.tool) {
            MP.printMessage(2220);
        }
        try {
            SANY.frontEndMain((SpecObj)this.specObj, (String)this.rootFile, (PrintStream)ToolIO.out);
        }
        catch (FrontEndException e) {
            Assert.fail((int)2171, (Throwable)e);
        }
        if (TLCGlobals.tool) {
            MP.printMessage(2219);
        }
        MP.printMessage(2185);
        if (!this.specObj.initErrors.isSuccess()) {
            Assert.fail((int)3002, (String[])this.specObj.initErrors.getErrors());
        }
        if (!this.specObj.parseErrors.isSuccess()) {
            Assert.fail((int)3002, (String[])this.specObj.parseErrors.getErrors());
        }
        if (!this.specObj.semanticErrors.isSuccess()) {
            Assert.fail((int)3002, (String[])this.specObj.semanticErrors.getErrors());
        }
        this.moduleTbl = this.specObj.getExternalModuleTable();
        UniqueString rootName = UniqueString.uniqueStringOf((String)this.rootFile);
        this.rootModule = this.moduleTbl.getModuleNode(rootName);
        Assert.check((this.rootModule != null ? 1 : 0) != 0, (int)2171, (String)String.format(" Module-Table lookup failure for module name %s derived from %s file name.", rootName.toString(), this.rootFile));
        OpDeclNode[] varDecls = this.rootModule.getVariableDecls();
        this.variablesNodes = new OpDeclNode[varDecls.length];
        UniqueString[] varNames = new UniqueString[varDecls.length];
        for (int i3 = 0; i3 < varDecls.length; ++i3) {
            this.variablesNodes[i3] = varDecls[i3];
            varNames[i3] = varDecls[i3].getName();
            varNames[i3].setLoc(i3);
        }
        UniqueString.setVariableCount((int)varDecls.length);
        this.defns.setDefnCount(varDecls.length);
        this.defns.put("TRUE", (Object)BoolValue.ValTrue);
        this.defns.put("FALSE", (Object)BoolValue.ValFalse);
        Value[] elems = new Value[]{BoolValue.ValFalse, BoolValue.ValTrue};
        this.defns.put("BOOLEAN", (Object)new SetEnumValue(elems, true));
        Class stringModule = this.tlaClass.loadClass("Strings");
        if (stringModule == null) {
            Assert.fail((int)2119);
        }
        Method[] ms = stringModule.getDeclaredMethods();
        for (int i4 = 0; i4 < ms.length; ++i4) {
            int mod = ms[i4].getModifiers();
            if (!Modifier.isStatic(mod)) continue;
            String name = TLARegistry.mapName(ms[i4].getName());
            int acnt = ms[i4].getParameterTypes().length;
            if (ms[i4].isSynthetic()) continue;
            this.defns.put(name, (Object)MethodValue.get(ms[i4]));
        }
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        HashMap<String, ModuleNode> modSet = new HashMap<String, ModuleNode>();
        for (int i5 = 0; i5 < mods.length; ++i5) {
            this.processConstants((SemanticNode)mods[i5]);
            modSet.put(mods[i5].getName().toString(), mods[i5]);
        }
        AssumeNode[] assumes = this.rootModule.getAssumptions();
        this.assumptions = new ExprNode[assumes.length];
        this.assumptionIsAxiom = new boolean[assumes.length];
        for (int i6 = 0; i6 < assumes.length; ++i6) {
            this.assumptions[i6] = assumes[i6].getAssume();
            this.assumptionIsAxiom[i6] = assumes[i6].getIsAxiom();
        }
        Hashtable constants = this.initializeConstants();
        Hashtable<String, String> overrides = this.config.getOverrides();
        OpDeclNode[] rootConsts = this.rootModule.getConstantDecls();
        for (int i7 = 0; i7 < rootConsts.length; ++i7) {
            UniqueString name = rootConsts[i7].getName();
            Object val = constants.get(name.toString());
            if (val == null && !overrides.containsKey(name.toString())) {
                Assert.fail((int)2222, (String)name.toString());
            }
            rootConsts[i7].setToolObject(this.toolId, val);
            this.defns.put(name, val);
        }
        OpDefNode[] rootOpDefs = this.rootModule.getOpDefs();
        for (int i8 = 0; i8 < rootOpDefs.length; ++i8) {
            UniqueString name = rootOpDefs[i8].getName();
            Object val = constants.get(name.toString());
            if (val == null) {
                this.defns.put(name, (Object)rootOpDefs[i8]);
                continue;
            }
            rootOpDefs[i8].setToolObject(this.toolId, val);
            this.defns.put(name, val);
        }
        Hashtable<String, Hashtable> modConstants = this.initializeModConstants();
        for (int i2 = 0; i2 < mods.length; ++i2) {
            UniqueString modName2 = mods[i2].getName();
            Hashtable mConsts = modConstants.get(modName2.toString());
            if (mConsts == null) continue;
            OpDefNode[] opDefs = mods[i2].getOpDefs();
            for (int j = 0; j < opDefs.length; ++j) {
                UniqueString name = opDefs[j].getName();
                Object val = mConsts.get(name.toString());
                if (val == null) continue;
                opDefs[j].getBody().setToolObject(this.toolId, val);
            }
        }
        for (int i2 = 0; i2 < mods.length; ++i2) {
            UniqueString modName2 = mods[i2].getName();
            String[] userModule = this.tlaClass.loadClass(modName2.toString());
            if (userModule == null) continue;
            HashMap<UniqueString, Integer> opname2arity = new HashMap<UniqueString, Integer>();
            if (!BuiltInModuleHelper.isBuiltInModule(userModule)) {
                for (OpDefNode opDefNode : rootOpDefs) {
                    if (!opDefNode.getOriginallyDefinedInModuleNode().getName().equals(modName2)) continue;
                    opname2arity.put(opDefNode.getName(), opDefNode.getArity());
                }
            }
            Hashtable<UniqueString, Value> javaDefs = new Hashtable<UniqueString, Value>();
            Method[] mds = userModule.getDeclaredMethods();
            for (int j = 0; j < mds.length; ++j) {
                Method method = mds[j];
                int mdf = method.getModifiers();
                if (!Modifier.isPublic(mdf) || !Modifier.isStatic(mdf)) continue;
                String string = TLARegistry.mapName(method.getName());
                UniqueString uname = UniqueString.uniqueStringOf((String)string);
                if (method.getAnnotation(TLAPlusOperator.class) != null || method.getAnnotation(Evaluation.class) != null) continue;
                int acnt = method.getParameterCount();
                Value value = MethodValue.get(method);
                if (!BuiltInModuleHelper.isBuiltInModule(userModule)) {
                    URL resource = userModule.getResource(userModule.getSimpleName() + ".class");
                    Integer arity = (Integer)opname2arity.get(uname);
                    if (arity == null || arity != acnt) {
                        MP.printWarning(2400, uname.toString(), resource.toExternalForm(), value.toString());
                        continue;
                    }
                    javaDefs.put(uname, value);
                    MP.printMessage(2168, uname.toString(), resource.toExternalForm(), value.toString());
                    continue;
                }
                javaDefs.put(uname, value);
            }
            OpDefNode[] opDefs = mods[i2].getOpDefs();
            for (int j = 0; j < opDefs.length; ++j) {
                UniqueString uname = opDefs[j].getName();
                Object v = javaDefs.get(uname);
                if (v == null) continue;
                opDefs[j].getBody().setToolObject(this.toolId, v);
                this.defns.put(uname, v);
            }
        }
        boolean hasCallableValue = false;
        String tlcOverrides = TLCBuiltInOverrides.class.getName() + File.pathSeparator + System.getProperty("tlc2.overrides.TLCOverrides", "tlc2.overrides.TLCOverrides");
        for (String ovrde : tlcOverrides.split(File.pathSeparator)) {
            Class idx = this.tlaClass.loadClass(ovrde);
            if (idx == null || !ITLCOverrides.class.isAssignableFrom(idx)) continue;
            try {
                Class[] candidateClasses;
                ITLCOverrides index = (ITLCOverrides)idx.newInstance();
                for (Class clazz : candidateClasses = index.get()) {
                    Method[] candidateMethods;
                    for (Method m : candidateMethods = clazz.getDeclaredMethods()) {
                        OpDefNode opDef;
                        ModuleNode moduleNode;
                        Evaluation evaluation = m.getAnnotation(Evaluation.class);
                        if (evaluation != null) {
                            EvaluatingValue val = new EvaluatingValue(m, evaluation.minLevel());
                            ModuleNode moduleNode2 = (ModuleNode)modSet.get(evaluation.module());
                            if (moduleNode2 == null) {
                                if (!evaluation.warn()) continue;
                                MP.printMessage(2402, evaluation.module() + "!" + evaluation.definition(), clazz.getResource(clazz.getSimpleName() + ".class").toExternalForm(), val.toString());
                                continue;
                            }
                            OpDefNode opDef2 = moduleNode2.getOpDef(evaluation.definition());
                            if (opDef2 == null) {
                                if (!evaluation.warn()) continue;
                                MP.printMessage(2403, evaluation.module() + "!" + evaluation.definition(), clazz.getResource(clazz.getSimpleName() + ".class").toExternalForm(), val.toString());
                                continue;
                            }
                            opDef2.getBody().setToolObject(this.toolId, (Object)val);
                            this.defns.put(evaluation.definition(), (Object)val);
                            if (evaluation.silent()) continue;
                            MP.printMessage(2168, evaluation.module() + "!" + evaluation.definition(), clazz.getResource(clazz.getSimpleName() + ".class").toExternalForm(), val.toString());
                            continue;
                        }
                        TLAPlusCallable jev = m.getAnnotation(TLAPlusCallable.class);
                        if (jev != null) {
                            CallableValue val = new CallableValue(m, jev.minLevel());
                            moduleNode = (ModuleNode)modSet.get(jev.module());
                            if (moduleNode == null) {
                                if (!jev.warn()) continue;
                                MP.printMessage(2402, jev.module() + "!" + jev.definition(), clazz.getResource(clazz.getSimpleName() + ".class").toExternalForm(), val.toString());
                                continue;
                            }
                            opDef = moduleNode.getOpDef(jev.definition());
                            if (opDef == null) {
                                if (!jev.warn()) continue;
                                MP.printMessage(2403, jev.module() + "!" + jev.definition(), clazz.getResource(clazz.getSimpleName() + ".class").toExternalForm(), val.toString());
                                continue;
                            }
                            opDef.getBody().setToolObject(this.toolId, (Object)val);
                            this.defns.put(jev.definition(), (Object)val);
                            hasCallableValue = true;
                            MP.printMessage(2168, jev.module() + "!" + jev.definition(), clazz.getResource(clazz.getSimpleName() + ".class").toExternalForm(), val.toString());
                            continue;
                        }
                        TLAPlusOperator opOverrideCandidate = m.getAnnotation(TLAPlusOperator.class);
                        if (opOverrideCandidate == null) continue;
                        moduleNode = (ModuleNode)modSet.get(opOverrideCandidate.module());
                        if (moduleNode == null) {
                            if (!opOverrideCandidate.warn()) continue;
                            MP.printWarning(2402, opOverrideCandidate.identifier(), opOverrideCandidate.module(), m.toString());
                            continue;
                        }
                        opDef = moduleNode.getOpDef(opOverrideCandidate.identifier());
                        if (opDef == null) {
                            if (!opOverrideCandidate.warn()) continue;
                            MP.printWarning(2403, opOverrideCandidate.identifier(), opOverrideCandidate.module(), m.toString());
                            continue;
                        }
                        Value val = MethodValue.get(m, opOverrideCandidate.minLevel());
                        if (opDef.getArity() != m.getParameterCount()) {
                            if (!opOverrideCandidate.warn()) continue;
                            MP.printWarning(2400, opDef.getName().toString(), clazz.getName(), val.toString());
                            continue;
                        }
                        if (opOverrideCandidate.warn()) {
                            MP.printMessage(2168, opDef.getName().toString(), clazz.getName(), val instanceof MethodValue ? val.toString() : val.getClass().getName());
                        }
                        opDef.getBody().setToolObject(this.toolId, (Object)val);
                        this.defns.put(opOverrideCandidate.identifier(), (Object)val);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                Assert.fail((int)1000);
                return;
            }
        }
        HashSet<String> overriden = new HashSet<String>();
        for (i = 0; i < rootConsts.length; ++i) {
            UniqueString lhs = rootConsts[i].getName();
            rhs = overrides.get(lhs.toString());
            if (rhs == null) continue;
            if (overrides.containsKey(rhs)) {
                Assert.fail((int)2223, (String)rhs);
            }
            if ((myVal = this.defns.get(rhs)) == null) {
                Assert.fail((int)2224, (String[])new String[]{lhs.toString(), rhs});
            }
            rootConsts[i].setToolObject(this.toolId, myVal);
            this.defns.put(lhs, myVal);
            overriden.add(lhs.toString());
        }
        if (mode == Tool.Mode.Simulation || mode == Tool.Mode.MC_DEBUG) {
            TLCStateMutExt.setVariables(this.variablesNodes);
        } else if (hasCallableValue) {
            assert (mode == Tool.Mode.Executor);
            TLCStateMutExt.setVariables(this.variablesNodes);
        } else {
            assert (mode == Tool.Mode.MC);
            TLCStateMut.setVariables(this.variablesNodes);
        }
        for (i = 0; i < rootOpDefs.length; ++i) {
            UniqueString lhs = rootOpDefs[i].getName();
            rhs = overrides.get(lhs.toString());
            if (rhs == null) continue;
            if (overrides.containsKey(rhs)) {
                Assert.fail((int)2223, (String)rhs);
            }
            if ((myVal = this.defns.get(rhs)) == null) {
                Assert.fail((int)2224, (String[])new String[]{lhs.toString(), rhs});
            }
            if (myVal instanceof OpDefNode && rootOpDefs[i].getNumberOfArgs() != ((OpDefNode)myVal).getNumberOfArgs()) {
                Assert.fail((int)2225, (String[])new String[]{lhs.toString(), rhs});
            }
            rootOpDefs[i].setToolObject(this.toolId, myVal);
            this.defns.put(lhs, myVal);
            overriden.add(lhs.toString());
        }
        Enumeration<String> keys = overrides.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (overriden.contains(key)) continue;
            Assert.fail((int)2226, (String)key.toString());
        }
        Hashtable modOverrides = this.config.getModOverrides();
        for (int i9 = 0; i9 < mods.length; ++i9) {
            modName = mods[i9].getName();
            Hashtable mDefs = (Hashtable)modOverrides.get(modName.toString());
            HashSet<String> modOverriden = new HashSet<String>();
            if (mDefs == null) continue;
            OpDefNode[] opDefNodeArray = mods[i9].getOpDefs();
            for (int j = 0; j < opDefNodeArray.length; ++j) {
                Object myVal2;
                UniqueString lhs = opDefNodeArray[j].getName();
                String string = (String)mDefs.get(lhs.toString());
                if (string == null) continue;
                if (mDefs.containsKey(string)) {
                    Assert.fail((int)2223, (String)string);
                }
                if ((myVal2 = this.defns.get(string)) == null) {
                    Assert.fail((int)2224, (String[])new String[]{lhs.toString(), string});
                }
                if (myVal2 instanceof OpDefNode && opDefNodeArray[j].getNumberOfArgs() != ((OpDefNode)myVal2).getNumberOfArgs()) {
                    Assert.fail((int)2225, (String[])new String[]{lhs.toString(), string});
                }
                opDefNodeArray[j].getBody().setToolObject(this.toolId, myVal2);
                modOverriden.add(lhs.toString());
            }
            Enumeration mkeys = mDefs.keys();
            while (mkeys.hasMoreElements()) {
                Object mkey = mkeys.nextElement();
                if (modOverriden.contains(mkey)) continue;
                Assert.fail((int)2226, (String)mkey.toString());
            }
        }
        Enumeration modKeys = modOverrides.keys();
        while (modKeys.hasMoreElements()) {
            modName = modKeys.nextElement();
            if (modSet.keySet().contains(modName)) continue;
            Assert.fail((int)2245, (String)modName.toString());
        }
    }

    private final void processConfig() {
        int i;
        this.processConfigInvariants();
        String specName = this.config.getSpec();
        if (specName.length() == 0) {
            this.processConfigInitAndNext();
        } else {
            Object spec2;
            if (this.config.getInit().length() != 0 || this.config.getNext().length() != 0) {
                Assert.fail((int)2227);
            }
            if ((spec2 = this.defns.get(specName)) instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)spec2;
                if (opDef.getArity() != 0) {
                    Assert.fail((int)2228, (String[])new String[]{specName});
                }
                this.processConfigSpec(opDef.getBody(), Context.Empty, List.Empty);
            } else if (spec2 == null) {
                Assert.fail((int)2229, (String[])new String[]{"name", specName});
            } else {
                Assert.fail((int)2230, (String[])new String[]{"value", specName, spec2.toString()});
            }
        }
        Vect propNames = this.config.getProperties();
        for (i = 0; i < propNames.size(); ++i) {
            String propName = (String)propNames.elementAt(i);
            Object prop = this.defns.get(propName);
            if (prop instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)prop;
                if (opDef.getArity() != 0) {
                    Assert.fail((int)2228, (String[])new String[]{propName});
                }
                this.processConfigProps(propName, opDef.getBody(), Context.Empty, List.Empty);
                continue;
            }
            if (prop == null) {
                Assert.fail((int)2229, (String[])new String[]{"property", propName});
                continue;
            }
            if (prop instanceof IBoolValue && ((BoolValue)prop).val) continue;
            Assert.fail((int)2230, (String[])new String[]{"property", propName, prop.toString()});
        }
        this.invariants = new Action[this.invVec.size()];
        this.invNames = new String[this.invVec.size()];
        for (i = 0; i < this.invariants.length; ++i) {
            this.invariants[i] = this.invVec.elementAt(i);
            this.invNames[i] = this.invNameVec.elementAt(i);
        }
        this.invVec = null;
        this.invNameVec = null;
        this.impliedInits = new Action[this.impliedInitVec.size()];
        this.impliedInitNames = new String[this.impliedInitVec.size()];
        for (i = 0; i < this.impliedInits.length; ++i) {
            this.impliedInits[i] = this.impliedInitVec.elementAt(i);
            this.impliedInitNames[i] = this.impliedInitNameVec.elementAt(i);
        }
        this.impliedInitVec = null;
        this.impliedInitNameVec = null;
        this.impliedActions = new Action[this.impliedActionVec.size()];
        this.impliedActNames = new String[this.impliedActionVec.size()];
        for (i = 0; i < this.impliedActions.length; ++i) {
            this.impliedActions[i] = this.impliedActionVec.elementAt(i);
            this.impliedActNames[i] = this.impliedActNameVec.elementAt(i);
        }
        this.impliedActionVec = null;
        this.impliedActNameVec = null;
        this.temporals = new Action[this.temporalVec.size()];
        this.temporalNames = new String[this.temporalNameVec.size()];
        for (i = 0; i < this.temporals.length; ++i) {
            this.temporals[i] = this.temporalVec.elementAt(i);
            this.temporalNames[i] = this.temporalNameVec.elementAt(i);
        }
        this.temporalVec = null;
        this.temporalNameVec = null;
        this.impliedTemporals = new Action[this.impliedTemporalVec.size()];
        this.impliedTemporalNames = new String[this.impliedTemporalNameVec.size()];
        for (i = 0; i < this.impliedTemporals.length; ++i) {
            this.impliedTemporals[i] = this.impliedTemporalVec.elementAt(i);
            this.impliedTemporalNames[i] = this.impliedTemporalNameVec.elementAt(i);
        }
        this.impliedTemporalVec = null;
        this.impliedTemporalNameVec = null;
        if (this.initPredVec.size() == 0 && (this.impliedInits.length != 0 || this.impliedActions.length != 0 || this.variablesNodes.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail((int)2231);
        }
        if (this.nextPred == null && (this.impliedActions.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail((int)2232);
        }
        this.processModelConstraints();
        this.processActionConstraints();
    }

    private void processConfigInitAndNext() {
        OpDefNode def;
        String name = this.config.getInit();
        if (name.length() != 0) {
            Object init = this.defns.get(name);
            if (init == null) {
                Assert.fail((int)2229, (String[])new String[]{"initial predicate", name});
            }
            if (!(init instanceof OpDefNode)) {
                Assert.fail((int)2233, (String[])new String[]{"initial predicate", name});
            }
            if ((def = (OpDefNode)init).getArity() != 0) {
                Assert.fail((int)2228, (String[])new String[]{"initial predicate", name});
            }
            this.initPredVec.addElement(new Action((SemanticNode)def.getBody(), Context.Empty, def));
        }
        if ((name = this.config.getNext()).length() != 0) {
            Object next = this.defns.get(name);
            if (next == null) {
                Assert.fail((int)2229, (String[])new String[]{"next state action", name});
            }
            if (!(next instanceof OpDefNode)) {
                Assert.fail((int)2233, (String[])new String[]{"next state action", name});
            }
            if ((def = (OpDefNode)next).getArity() != 0) {
                Assert.fail((int)2228, (String[])new String[]{"next state action", name});
            }
            this.nextPred = new Action((SemanticNode)def.getBody(), Context.Empty, def);
        }
    }

    private void processConfigInvariants() {
        Vect invs = this.config.getInvariants();
        for (int i = 0; i < invs.size(); ++i) {
            String name = (String)invs.elementAt(i);
            Object inv = this.defns.get(name);
            if (inv instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)inv;
                if (def.getArity() != 0) {
                    Assert.fail((int)2228, (String[])new String[]{"invariant", name});
                }
                if (def.getLevel() >= 2) {
                    if (!def.getBody().levelParams.isEmpty()) {
                        Assert.fail((int)2146, (String[])new String[]{def.getName().toString(), "includeWarning"});
                    }
                    Assert.fail((int)2146, (String)def.getName().toString());
                }
                this.invNameVec.addElement(name);
                this.invVec.addElement(new Action((SemanticNode)def.getBody(), Context.Empty, def));
                continue;
            }
            if (inv == null) {
                Assert.fail((int)2229, (String[])new String[]{"invariant", name});
                continue;
            }
            if (inv instanceof IBoolValue && ((BoolValue)inv).val) continue;
            Assert.fail((int)2230, (String[])new String[]{"invariant", name, inv.toString()});
        }
    }

    private final void processConfigSpec(ExprNode pred, Context c, List subs) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigSpec(pred1.getBody(), c, subs.cons(pred1));
            return;
        }
        if (pred instanceof OpApplNode) {
            OpApplNode pred1 = (OpApplNode)pred;
            ExprOrOpArgNode[] args = pred1.getArgs();
            if (args.length == 0) {
                SymbolNode opNode = pred1.getOperator();
                Object val = this.symbolNodeValueLookupProvider.lookup(opNode, c, false, this.toolId);
                if (val instanceof OpDefNode) {
                    ExprNode body;
                    if (((OpDefNode)val).getArity() != 0) {
                        Assert.fail((int)2234, (String[])new String[]{opNode.getName().toString()});
                    }
                    if (this.symbolNodeValueLookupProvider.getLevelBound((SemanticNode)(body = ((OpDefNode)val).getBody()), c, this.toolId) == 1) {
                        this.initPredVec.addElement(new Action((SemanticNode)Specs.addSubsts(body, subs), c, (OpDefNode)val));
                    } else {
                        this.processConfigSpec(body, c, subs);
                    }
                } else if (val == null) {
                    Assert.fail((int)2235, (String[])new String[]{opNode.getName().toString()});
                } else if (val instanceof IBoolValue) {
                    if (!((BoolValue)val).val) {
                        Assert.fail((int)2237, (String)opNode.getName().toString());
                    }
                } else {
                    Assert.fail((int)2236, (String[])new String[]{opNode.getName().toString(), val.toString(), "spec"});
                }
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 55 || opcode == 56) {
                Assert.fail((int)2301);
            }
            if (opcode == 6 || opcode == 36) {
                for (int i = 0; i < args.length; ++i) {
                    this.processConfigSpec((ExprNode)args[i], c, subs);
                }
                return;
            }
            if (opcode == 59) {
                ExprOrOpArgNode boxArg = args[0];
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    ExprNode arg = (ExprNode)((OpApplNode)boxArg).getArgs()[0];
                    ExprNode subscript = (ExprNode)((OpApplNode)boxArg).getArgs()[1];
                    Vect<SymbolNode> varsInSubscript = null;
                    try {
                        class SubscriptCollector {
                            Vect<SymbolNode> components = new Vect();

                            SubscriptCollector() {
                            }

                            void enter(ExprNode subscript, Context c) {
                                SymbolNode var = SpecProcessor.this.symbolNodeValueLookupProvider.getVar((SemanticNode)subscript, c, false, SpecProcessor.this.toolId);
                                if (var != null) {
                                    this.components.addElement(var);
                                    return;
                                }
                                switch (subscript.getKind()) {
                                    case 9: {
                                        OpApplNode subscript1 = (OpApplNode)subscript;
                                        SymbolNode opNode = subscript1.getOperator();
                                        ExprOrOpArgNode[] args = subscript1.getArgs();
                                        int opCode = BuiltInOPs.getOpCode(opNode.getName());
                                        if (opCode == 23) {
                                            for (int i = 0; i < args.length; ++i) {
                                                this.enter((ExprNode)args[i], c);
                                            }
                                            return;
                                        }
                                        if (opCode != 0) {
                                            return;
                                        }
                                        Object opDef = SpecProcessor.this.symbolNodeValueLookupProvider.lookup(opNode, c, false, SpecProcessor.this.toolId);
                                        if (opDef instanceof OpDefNode) {
                                            OpDefNode opDef1 = (OpDefNode)opDef;
                                            this.enter(opDef1.getBody(), SpecProcessor.this.symbolNodeValueLookupProvider.getOpContext(opDef1, args, c, false, SpecProcessor.this.toolId));
                                            return;
                                        }
                                        if (!(opDef instanceof LazyValue)) break;
                                        LazyValue lv = (LazyValue)opDef;
                                        this.enter((ExprNode)lv.expr, lv.con);
                                        return;
                                    }
                                    case 13: {
                                        SubstInNode subscript1 = (SubstInNode)subscript;
                                        Subst[] subs = subscript1.getSubsts();
                                        Context c1 = c;
                                        for (int i = 0; i < subs.length; ++i) {
                                            c1 = c1.cons((SymbolNode)subs[i].getOp(), SpecProcessor.this.symbolNodeValueLookupProvider.getVal(subs[i].getExpr(), c, false, SpecProcessor.this.toolId));
                                        }
                                        this.enter(subscript1.getBody(), c1);
                                        return;
                                    }
                                    case 10: {
                                        LetInNode subscript1 = (LetInNode)subscript;
                                        this.enter(subscript1.getBody(), c);
                                        return;
                                    }
                                    case 29: {
                                        LabelNode subscript1 = (LabelNode)subscript;
                                        this.enter((ExprNode)subscript1.getBody(), c);
                                        return;
                                    }
                                    default: {
                                        Assert.fail((int)2238, (String)subscript.toString());
                                        return;
                                    }
                                }
                            }

                            Vect<SymbolNode> getComponents() {
                                return this.components;
                            }
                        }
                        SubscriptCollector collector = new SubscriptCollector();
                        Context c1 = c;
                        List subs1 = subs;
                        while (!subs1.isEmpty()) {
                            SubstInNode sn = (SubstInNode)subs1.car();
                            Subst[] snsubs = sn.getSubsts();
                            for (int i = 0; i < snsubs.length; ++i) {
                                c1 = c1.cons((SymbolNode)snsubs[i].getOp(), this.symbolNodeValueLookupProvider.getVal(snsubs[i].getExpr(), c, false, this.toolId));
                            }
                            subs1 = subs1.cdr();
                        }
                        collector.enter(subscript, c1);
                        varsInSubscript = collector.getComponents();
                    }
                    catch (Exception e) {
                        MP.printWarning(2139, new String[0]);
                        varsInSubscript = null;
                    }
                    if (varsInSubscript != null) {
                        for (int i = 0; i < this.variablesNodes.length; ++i) {
                            if (varsInSubscript.contains(this.variablesNodes[i])) continue;
                            MP.printWarning(2140, new String[]{this.variablesNodes[i].getName().toString()});
                        }
                    }
                    if (this.nextPred == null) {
                        this.nextPred = new Action((SemanticNode)Specs.addSubsts(arg, subs), c);
                    } else {
                        Assert.fail((int)2240);
                    }
                } else {
                    this.temporalVec.addElement(new Action((SemanticNode)Specs.addSubsts(pred, subs), c));
                    this.temporalNameVec.addElement(pred.toString());
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigSpec((ExprNode)args[0], c, subs);
                return;
            }
        }
        if ((level = this.symbolNodeValueLookupProvider.getLevelBound((SemanticNode)pred, c, this.toolId)) <= 1) {
            this.initPredVec.addElement(new Action((SemanticNode)Specs.addSubsts(pred, subs), c));
        } else if (level == 3) {
            this.temporalVec.addElement(new Action((SemanticNode)Specs.addSubsts(pred, subs), c));
            this.temporalNameVec.addElement(pred.toString());
        } else {
            Assert.fail((int)2239, (String)pred.toString());
        }
    }

    private final void processConfigProps(String name, ExprNode pred, Context c, List subs) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigProps(name, pred1.getBody(), c, subs.cons(pred1));
            return;
        }
        if (pred instanceof OpApplNode) {
            OpApplNode pred1 = (OpApplNode)pred;
            ExprOrOpArgNode[] args = pred1.getArgs();
            if (args.length == 0) {
                SymbolNode opNode = pred1.getOperator();
                Object val = this.symbolNodeValueLookupProvider.lookup(opNode, c, false, this.toolId);
                if (val instanceof OpDefNode) {
                    if (((OpDefNode)val).getArity() != 0) {
                        Assert.fail((int)2234, (String)opNode.getName().toString());
                    }
                    this.processConfigProps(opNode.getName().toString(), ((OpDefNode)val).getBody(), c, subs);
                } else if (val == null) {
                    Assert.fail((int)2235, (String)opNode.getName().toString());
                } else if (val instanceof IBoolValue) {
                    if (!((BoolValue)val).val) {
                        Assert.fail((int)2237, (String)opNode.getName().toString());
                    }
                } else {
                    Assert.fail((int)2236, (String[])new String[]{opNode.getName().toString(), val.toString(), "property"});
                }
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 6 || opcode == 36) {
                for (int i = 0; i < args.length; ++i) {
                    ExprNode conj = (ExprNode)args[i];
                    this.processConfigProps(conj.toString(), conj, c, subs);
                }
                return;
            }
            if (opcode == 59) {
                ExprNode boxArg = (ExprNode)args[0];
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    OpApplNode boxArg1 = (OpApplNode)boxArg;
                    if (boxArg1.getArgs().length == 0) {
                        name = boxArg1.getOperator().getName().toString();
                    }
                    this.impliedActNameVec.addElement(name);
                    this.impliedActionVec.addElement(new Action((SemanticNode)Specs.addSubsts(boxArg, subs), c));
                } else if (this.symbolNodeValueLookupProvider.getLevelBound((SemanticNode)boxArg, c, this.toolId) < 2) {
                    this.invVec.addElement(new Action((SemanticNode)Specs.addSubsts(boxArg, subs), c));
                    if (boxArg instanceof OpApplNode && ((OpApplNode)boxArg).getArgs().length == 0) {
                        name = ((OpApplNode)boxArg).getOperator().getName().toString();
                    }
                    this.invNameVec.addElement(name);
                } else {
                    this.impliedTemporalVec.addElement(new Action((SemanticNode)Specs.addSubsts(pred, subs), c));
                    this.impliedTemporalNameVec.addElement(name);
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigProps(name, (ExprNode)args[0], c, subs);
                return;
            }
        }
        if ((level = this.symbolNodeValueLookupProvider.getLevelBound((SemanticNode)pred, c, this.toolId)) <= 1) {
            this.impliedInitVec.addElement(new Action((SemanticNode)Specs.addSubsts(pred, subs), c));
            this.impliedInitNameVec.addElement(name);
        } else if (level == 3) {
            this.impliedTemporalVec.addElement(new Action((SemanticNode)Specs.addSubsts(pred, subs), c));
            this.impliedTemporalNameVec.addElement(name);
        } else {
            Assert.fail((int)2241, (String)name);
        }
    }

    private void processActionConstraints() {
        Vect names = this.config.getActionConstraints();
        this.actionConstraints = new ExprNode[names.size()];
        int idx = 0;
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            Object constr = this.defns.get(name);
            if (constr instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)constr;
                if (def.getArity() != 0) {
                    Assert.fail((int)2228, (String[])new String[]{"action constraint", name});
                }
                ExprNode body = def.getBody();
                assert (body.getToolObject(this.toolId) == null);
                body.setToolObject(this.toolId, (Object)def);
                this.actionConstraints[idx++] = body;
                continue;
            }
            if (constr != null) {
                if (constr instanceof IBoolValue && ((BoolValue)constr).val) continue;
                Assert.fail((int)2230, (String[])new String[]{"action constraint", name, constr.toString()});
                continue;
            }
            Assert.fail((int)2229, (String[])new String[]{"action constraint", name});
        }
        if (idx < this.actionConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            for (int i = 0; i < idx; ++i) {
                constrs[i] = this.actionConstraints[i];
            }
            this.actionConstraints = constrs;
        }
    }

    private final void processModelConstraints() {
        Vect names = this.config.getConstraints();
        this.modelConstraints = new ExprNode[names.size()];
        int idx = 0;
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            Object constr = this.defns.get(name);
            if (constr instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)constr;
                if (def.getArity() != 0) {
                    Assert.fail((int)2228, (String[])new String[]{"constraint", name});
                }
                ExprNode body = def.getBody();
                assert (body.getToolObject(this.toolId) == null);
                body.setToolObject(this.toolId, (Object)def);
                this.modelConstraints[idx++] = body;
                continue;
            }
            if (constr != null) {
                if (constr instanceof IBoolValue && ((BoolValue)constr).val) continue;
                Assert.fail((int)2230, (String[])new String[]{"constraint", name, constr.toString()});
                continue;
            }
            Assert.fail((int)2229, (String[])new String[]{"constraint", name});
        }
        if (idx < this.modelConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            for (int i = 0; i < idx; ++i) {
                constrs[i] = this.modelConstraints[i];
            }
            this.modelConstraints = constrs;
        }
    }

    private final void processConstants(SemanticNode expr) {
        switch (expr.getKind()) {
            case 1: {
                ModuleNode expr1 = (ModuleNode)expr;
                OpDefNode[] opDefs = expr1.getOpDefs();
                for (int i = 0; i < opDefs.length; ++i) {
                    Object def = opDefs[i].getToolObject(this.toolId);
                    if (def instanceof OpDefNode) {
                        this.processedDefs.add((OpDefNode)def);
                        this.processConstants((SemanticNode)((OpDefNode)def).getBody());
                    }
                    this.processConstants((SemanticNode)opDefs[i].getBody());
                }
                ModuleNode[] imods = expr1.getInnerModules();
                for (int i = 0; i < imods.length; ++i) {
                    this.processConstants((SemanticNode)imods[i]);
                }
                AssumeNode[] assumps = expr1.getAssumptions();
                for (int i = 0; i < assumps.length; ++i) {
                    this.processConstants((SemanticNode)assumps[i]);
                }
                TheoremNode[] thms = expr1.getTheorems();
                for (int i = 0; i < thms.length; ++i) {
                    this.processConstants((SemanticNode)thms[i]);
                }
                return;
            }
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                SymbolNode opNode = expr1.getOperator();
                Object val = this.defns.get(opNode.getName());
                if (val != null) {
                    opNode.setToolObject(this.toolId, val);
                } else {
                    ExprOrOpArgNode[] args = expr1.getArgs();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] == null) continue;
                        this.processConstants((SemanticNode)args[i]);
                    }
                    ExprNode[] bnds = expr1.getBdedQuantBounds();
                    for (int i = 0; i < bnds.length; ++i) {
                        this.processConstants((SemanticNode)bnds[i]);
                    }
                }
                return;
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                OpDefNode[] letDefs = expr1.getLets();
                for (int i = 0; i < letDefs.length; ++i) {
                    this.processConstants((SemanticNode)letDefs[i].getBody());
                }
                this.processConstants((SemanticNode)expr1.getBody());
                return;
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                for (int i = 0; i < subs.length; ++i) {
                    this.processConstants((SemanticNode)subs[i].getExpr());
                }
                this.processConstants((SemanticNode)expr1.getBody());
                return;
            }
            case 30: {
                APSubstInNode expr1 = (APSubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                for (int i = 0; i < subs.length; ++i) {
                    this.processConstants((SemanticNode)subs[i].getExpr());
                }
                this.processConstants((SemanticNode)expr1.getBody());
                return;
            }
            case 16: {
                NumeralNode expr1 = (NumeralNode)expr;
                IntValue val = IntValue.gen(expr1.val());
                if (expr1.bigVal() != null) {
                    Assert.fail((int)2265, (String)expr1.toString());
                    return;
                }
                expr1.setToolObject(this.toolId, (Object)val);
                return;
            }
            case 17: {
                DecimalNode expr1 = (DecimalNode)expr;
                Assert.fail((int)2244, (String)expr1.toString());
                return;
            }
            case 18: {
                StringNode expr1 = (StringNode)expr;
                StringValue val = new StringValue(expr1.getRep());
                expr1.setToolObject(this.toolId, (Object)val);
                return;
            }
            case 20: {
                AssumeNode expr1 = (AssumeNode)expr;
                this.processConstants((SemanticNode)expr1.getAssume());
                return;
            }
            case 12: {
                TheoremNode expr1 = (TheoremNode)expr;
                this.processConstants((SemanticNode)expr1.getTheorem());
                return;
            }
            case 8: {
                OpDefNode opdef;
                SymbolNode opArgNode = ((OpArgNode)expr).getOp();
                if (opArgNode.getKind() == 5 && !this.processedDefs.contains(opdef = (OpDefNode)opArgNode)) {
                    this.processedDefs.add(opdef);
                    this.processConstants((SemanticNode)opdef.getBody());
                }
                return;
            }
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                this.processConstants((SemanticNode)expr1.getBody());
            }
        }
    }

    private final Hashtable<String, Serializable> makeConstantTable(Vect<Vect<String>> consts) {
        Hashtable<String, Serializable> constTbl = new Hashtable<String, Serializable>();
        for (int i = 0; i < consts.size(); ++i) {
            OpRcdValue opVal;
            Vect<String> line = consts.elementAt(i);
            int len = line.size();
            String name = line.elementAt(0);
            if (len <= 2) {
                constTbl.put(name, (Serializable)((Object)line.elementAt(1)));
                continue;
            }
            Serializable val = constTbl.get(name);
            if (val == null) {
                opVal = new OpRcdValue();
                opVal.addLine(line);
                constTbl.put(name, opVal);
                continue;
            }
            opVal = (OpRcdValue)val;
            int arity = ((IValue[])opVal.domain.elementAt(0)).length;
            if (len != arity + 2) {
                Assert.fail((int)2242, (String)name);
            }
            opVal.addLine(line);
        }
        return constTbl;
    }

    private final Hashtable initializeConstants() {
        Vect consts = this.config.getConstants();
        if (consts == null) {
            return new Hashtable();
        }
        return this.makeConstantTable(consts);
    }

    private final Hashtable<String, Hashtable> initializeModConstants() {
        Hashtable modConstants = this.config.getModConstants();
        Hashtable<String, Hashtable> constants = new Hashtable<String, Hashtable>();
        Enumeration mods = modConstants.keys();
        while (mods.hasMoreElements()) {
            String modName = (String)mods.nextElement();
            constants.put(modName, this.makeConstantTable((Vect)modConstants.get(modName)));
        }
        return constants;
    }

    public ModuleNode getRootModule() {
        return this.rootModule;
    }

    public ExternalModuleTable getModuleTbl() {
        return this.moduleTbl;
    }

    public OpDeclNode[] getVariablesNodes() {
        return this.variablesNodes;
    }

    public Vect<Action> getInitPred() {
        return this.initPredVec;
    }

    public Action getNextPred() {
        return this.nextPred;
    }

    public Action[] getTemporal() {
        return this.temporals;
    }

    public String[] getTemporalNames() {
        return this.temporalNames;
    }

    public Action[] getImpliedTemporals() {
        return this.impliedTemporals;
    }

    public String[] getImpliedTemporalNames() {
        return this.impliedTemporalNames;
    }

    public Action[] getInvariants() {
        return this.invariants;
    }

    public String[] getInvariantsNames() {
        return this.invNames;
    }

    public Action[] getImpliedInits() {
        return this.impliedInits;
    }

    public String[] getImpliedInitNames() {
        return this.impliedInitNames;
    }

    public Action[] getImpliedActions() {
        return this.impliedActions;
    }

    public String[] getImpliedActionNames() {
        return this.impliedActNames;
    }

    public ExprNode[] getModelConstraints() {
        return this.modelConstraints;
    }

    public ExprNode[] getActionConstraints() {
        return this.actionConstraints;
    }

    public ExprNode[] getAssumptions() {
        return this.assumptions;
    }

    public boolean[] getAssumptionIsAxiom() {
        return this.assumptionIsAxiom;
    }

    public SpecObj getSpecObj() {
        return this.specObj;
    }

    public Defns getUnprocessedDefns() {
        return this.snapshot;
    }

    public Defns getDefns() {
        return this.defns;
    }
}

