/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.util.Context;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import util.UniqueString;
import util.WrongInvocationException;

public final class TLCStateMutExt
extends TLCState
implements Cloneable,
Serializable {
    private IValue[] values;
    private static ITool mytool = null;
    private static SemanticNode viewMap = null;
    private static IMVPerm[] perms = null;
    private Action action;
    private TLCState predecessor;
    private Callable<?> callable;

    private TLCStateMutExt(IValue[] vals) {
        this.values = vals;
    }

    public static void setVariables(OpDeclNode[] variables) {
        vars = variables;
        IValue[] vals = new IValue[vars.length];
        Empty = new TLCStateMutExt(vals);
    }

    public static void setTool(ITool tool) {
        mytool = tool;
        viewMap = tool.getViewSpec();
        perms = tool.getSymmetryPerms();
    }

    @Override
    public final TLCState createEmpty() {
        IValue[] vals = new IValue[vars.length];
        return new TLCStateMutExt(vals);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TLCStateMutExt) {
            TLCStateMutExt state = (TLCStateMutExt)obj;
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] == null ? state.values[i] != null : state.values[i] == null || !this.values[i].equals(state.values[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final TLCState bind(UniqueString name, IValue value) {
        int loc = name.getVarLoc();
        this.values[loc] = value;
        return this;
    }

    @Override
    public final TLCState bind(SymbolNode id, IValue value) {
        throw new WrongInvocationException("TLCStateMut.bind: This is a TLC bug.");
    }

    @Override
    public final TLCState unbind(UniqueString name) {
        int loc = name.getVarLoc();
        this.values[loc] = null;
        return this;
    }

    @Override
    public final IValue lookup(UniqueString var) {
        int loc = var.getVarLoc();
        if (loc < 0) {
            return null;
        }
        return this.values[loc];
    }

    @Override
    public final boolean containsKey(UniqueString var) {
        return this.lookup(var) != null;
    }

    @Override
    public final TLCState copy() {
        int len = this.values.length;
        IValue[] vals = new IValue[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = this.values[i];
        }
        return this.copyExt(new TLCStateMutExt(vals));
    }

    @Override
    public final TLCState deepCopy() {
        int len = this.values.length;
        IValue[] vals = new IValue[len];
        for (int i = 0; i < len; ++i) {
            IValue val = this.values[i];
            if (val == null) continue;
            vals[i] = val.deepCopy();
        }
        return this.deepCopy(new TLCStateMutExt(vals));
    }

    @Override
    public final StateVec addToVec(StateVec states) {
        return states.addElement(this.copy());
    }

    @Override
    public final void deepNormalize() {
        for (int i = 0; i < this.values.length; ++i) {
            IValue val = this.values[i];
            if (val == null) continue;
            val.deepNormalize();
        }
    }

    @Override
    public final long fingerPrint() {
        int i;
        int sz = this.values.length;
        IValue[] minVals = this.values;
        if (perms != null) {
            IValue[] vals = new IValue[sz];
            block0: for (int i2 = 0; i2 < perms.length; ++i2) {
                int cmp = 0;
                for (int j = 0; j < sz; ++j) {
                    vals[j] = this.values[j].permute(perms[i2]);
                    if (cmp == 0 && (cmp = vals[j].compareTo(minVals[j])) > 0) continue block0;
                }
                if (cmp >= 0) continue;
                if (minVals == this.values) {
                    minVals = vals;
                    vals = new IValue[sz];
                    continue;
                }
                IValue[] temp = minVals;
                minVals = vals;
                vals = temp;
            }
        }
        long fp = FP64.New();
        if (viewMap == null) {
            for (i = 0; i < sz; ++i) {
                fp = minVals[i].fingerPrint(fp);
            }
            if (this.values != minVals) {
                for (i = 0; i < sz; ++i) {
                    this.values[i].deepNormalize();
                }
            }
        } else {
            for (i = 0; i < sz; ++i) {
                this.values[i].deepNormalize();
            }
            TLCStateMutExt state = this;
            if (minVals != this.values) {
                state = new TLCStateMutExt(minVals);
            }
            IValue val = mytool.eval(viewMap, Context.Empty, state);
            fp = val.fingerPrint(fp);
        }
        return fp;
    }

    @Override
    public final boolean allAssigned() {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneAssigned() {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Set<OpDeclNode> getUnassigned() {
        TreeSet<OpDeclNode> unassignedVars = new TreeSet<OpDeclNode>(new Comparator<OpDeclNode>(){

            @Override
            public int compare(OpDeclNode o1, OpDeclNode o2) {
                return o1.getName().toString().compareTo(o2.getName().toString());
            }
        });
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            unassignedVars.add(vars[i]);
        }
        return unassignedVars;
    }

    @Override
    public final void read(IValueInputStream vis) throws IOException {
        super.read(vis);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = vis.read();
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        super.write(vos);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i].write(vos);
        }
    }

    @Override
    public final String toString() {
        if (TLCGlobals.useView && viewMap != null) {
            IValue val = mytool.eval(viewMap, Context.Empty, this);
            return viewMap.toString(val);
        }
        StringBuffer result = new StringBuffer();
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0].getName();
            IValue val = this.lookup(key);
            result.append(key.toString());
            result.append(" = ");
            result.append(Values.ppr(val));
            result.append("\n");
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key = vars[i].getName();
                IValue val = this.lookup(key);
                result.append("/\\ ");
                result.append(key.toString());
                result.append(" = ");
                result.append(Values.ppr(val));
                result.append("\n");
            }
        }
        return result.toString();
    }

    @Override
    public final String toString(TLCState lastState) {
        StringBuffer result = new StringBuffer();
        TLCStateMutExt lstate = (TLCStateMutExt)lastState;
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0].getName();
            IValue val = this.lookup(key);
            IValue lstateVal = lstate.lookup(key);
            if (!lstateVal.equals(val)) {
                result.append(key.toString());
                result.append(" = " + Values.ppr(val) + "\n");
            }
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key = vars[i].getName();
                IValue val = this.lookup(key);
                IValue lstateVal = lstate.lookup(key);
                if (lstateVal.equals(val)) continue;
                result.append("/\\ ");
                result.append(key.toString());
                result.append(" = " + Values.ppr(val) + "\n");
            }
        }
        return result.toString();
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public TLCState setAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public TLCState setPredecessor(TLCState predecessor) {
        this.predecessor = predecessor;
        return super.setPredecessor(predecessor);
    }

    @Override
    public TLCState getPredecessor() {
        return this.predecessor;
    }

    @Override
    public TLCState unsetPredecessor() {
        this.predecessor = null;
        return this;
    }

    @Override
    protected TLCState deepCopy(TLCState copy2) {
        super.deepCopy(copy2);
        return this.copyExt(copy2);
    }

    private TLCState copyExt(TLCState copy2) {
        if (this.predecessor != null) {
            copy2.setPredecessor(this.predecessor);
        }
        return copy2.setAction(this.getAction());
    }

    @Override
    public Object execCallable() throws Exception {
        if (this.callable != null) {
            return this.callable.call();
        }
        return null;
    }

    @Override
    public void setCallable(Callable<?> f) {
        this.callable = f;
    }
}

