/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import tlc2.TLCGlobals;
import tlc2.util.BigInt;
import tlc2.util.ByteUtils;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FilenameToStream;
import util.MonolithSpecExtractor;
import util.NamedInputStream;
import util.ToolIO;

public class FileUtil {
    public static final char separatorChar = File.separatorChar;
    public static final String separator = File.separator;
    public static final String pathSeparator = File.pathSeparator;

    public static String parseDirname(String filename) {
        int lastSep = filename.lastIndexOf(separatorChar);
        if (lastSep == -1) {
            return "";
        }
        return filename.substring(0, lastSep + 1);
    }

    public static boolean deleteDir(File file2, boolean recurse) {
        return FileUtil.doDeleteDir(file2, recurse);
    }

    public static boolean deleteDir(String filename, boolean recurse) {
        return FileUtil.doDeleteDir(new File(filename), recurse);
    }

    private static boolean doDeleteDir(File file2, boolean recurse) {
        if (file2 != null && file2.exists()) {
            if (file2.isFile() || !recurse) {
                return file2.delete();
            }
            String[] fnames = file2.list();
            File child = null;
            for (int i = 0; i < fnames.length; ++i) {
                child = new File(file2, fnames[i]);
                if (FileUtil.doDeleteDir(child, recurse)) continue;
                return false;
            }
            return file2.delete();
        }
        return true;
    }

    public static InputStream newBZFileInputStream(String file2, boolean useGzip, boolean useIBuffers, int buffersize) throws IOException {
        if (useGzip) {
            return new GZIPInputStream((InputStream)new FileInputStream(file2), buffersize);
        }
        if (useIBuffers) {
            return new BufferedInputStream(new FileInputStream(file2), buffersize);
        }
        return new FileInputStream(file2);
    }

    public static InputStream newZFileInputStream(String file2) throws FileNotFoundException, IOException {
        return new GZIPInputStream(new FileInputStream(file2));
    }

    public static OutputStream newBZFileOutputStream(String file2, boolean useGzip, boolean useOBuffers, int buffersize) throws IOException {
        return FileUtil.newBZFileOutputStream(file2, useGzip, useOBuffers, buffersize, false);
    }

    public static OutputStream newBZFileOutputStream(String file2, boolean useGzip, boolean useOBuffers, int buffersize, boolean app) throws IOException {
        if (useGzip) {
            return new GZIPOutputStream((OutputStream)new FileOutputStream(file2, app), buffersize);
        }
        if (useOBuffers) {
            return new BufferedOutputStream(new FileOutputStream(file2, app), buffersize);
        }
        return new FileOutputStream(file2, app);
    }

    public static void printArrayOfBigInts(InputStream in) throws IOException {
        BigInt[] A = ByteUtils.readSizeArrayOfSizeBigInts(in);
        for (int i = 0; i < A.length; ++i) {
            ToolIO.out.println(A[i]);
        }
    }

    public static void printSizeArrayOfSizeBigIntegers(InputStream in) throws IOException {
        BigInt[] A = ByteUtils.readSizeArrayOfSizeBigInts(in);
        for (int i = 0; i < A.length; ++i) {
            ToolIO.out.println(A[i]);
        }
    }

    public static void copyFile(String fromName, String toName) throws IOException {
        FileUtil.copyFile(new File(fromName), new File(toName));
    }

    public static void copyFile(File source2, File destination) throws IOException {
        Files.copy(source2.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void replaceFile(String sourceName, String targetName) throws IOException {
        Files.move(new File(sourceName).toPath(), new File(targetName).toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static String makeMetaDir(String specDir, String fromChkpt) {
        return FileUtil.makeMetaDir(new Date(), specDir, fromChkpt);
    }

    public static String makeMetaDir(Date date, String specDir, String fromChkpt) {
        if (fromChkpt != null) {
            return fromChkpt;
        }
        String metadir = TLCGlobals.metaDir;
        if (metadir == null) {
            metadir = specDir + "states" + separator;
        }
        SimpleDateFormat sdf = Boolean.getBoolean(FileUtil.class.getName() + ".milliseconds") ? new SimpleDateFormat("yy-MM-dd-HH-mm-ss.SSS") : new SimpleDateFormat("yy-MM-dd-HH-mm-ss");
        metadir = metadir + sdf.format(date);
        File filedir = new File(metadir);
        Assert.check(!filedir.exists(), 2162, filedir.getAbsolutePath());
        Assert.check(filedir.mkdirs(), 2163, filedir.getAbsolutePath());
        return metadir;
    }

    public static NamedInputStream createNamedInputStream(String name2, FilenameToStream resolver) {
        return FileUtil.createNamedInputStream(name2, resolver, null);
    }

    public static NamedInputStream createNamedInputStream(String name2, FilenameToStream resolver, NamedInputStream rootFileNis) {
        int n = name2.indexOf(10);
        if (n >= 0) {
            ToolIO.out.println("*** Warning: module name '" + name2 + "' contained NEWLINE; Only the part before NEWLINE is considered.");
            name2 = name2.substring(0, n);
        }
        if (name2.toLowerCase().endsWith(".tla")) {
            name2 = name2.substring(0, name2.length() - ".tla".length());
        }
        String sourceFileName = name2 + ".tla";
        String sourceModuleName = name2.substring(name2.lastIndexOf(separator) + 1);
        File sourceFile = resolver.resolve(sourceFileName, true);
        if (sourceFile != null && sourceFile.exists()) {
            try {
                NamedInputStream nis = new NamedInputStream(sourceFileName, sourceModuleName, sourceFile);
                return nis;
            }
            catch (FileNotFoundException e2) {
                ToolIO.out.println("***Internal error: Unable to create NamedInputStream in toIStream method");
            }
        }
        if (rootFileNis != null) {
            File rootSourceFile = rootFileNis.sourceFile();
            if (rootSourceFile != null) {
                try {
                    NamedInputStream nis = MonolithSpecExtractor.module(rootSourceFile, name2);
                    return nis;
                }
                catch (IOException iOException) {}
            }
        } else if (sourceFile != null) {
            ToolIO.err.println("File does not exist: " + sourceFile.getAbsolutePath() + " while looking in these directories: " + resolver.getFullPath());
        } else {
            ToolIO.err.println("Cannot locate " + sourceFileName + " in path: " + resolver.getFullPath());
        }
        return null;
    }

    public static FileInputStream newFIS(File file2) {
        if (file2 != null && file2.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file2);
                return fis;
            }
            catch (FileNotFoundException e2) {
                ToolIO.out.println("***Internal error: Unable to create FileInputStream");
            }
        }
        return null;
    }

    public static FileOutputStream newFOS(File file2) {
        if (file2 != null && file2.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(file2);
                return fos;
            }
            catch (FileNotFoundException e2) {
                ToolIO.out.println("***Internal error: Unable to create FileOutStream");
            }
        }
        return null;
    }

    public static OutputStream newBFOS(String name2) throws FileNotFoundException {
        try {
            return new FileOutputStream(new File(name2));
        }
        catch (FileNotFoundException e2) {
            ToolIO.out.println("Error: Unable to write to file " + name2);
            throw e2;
        }
    }

    public static BufferedDataInputStream newBdFIS(boolean useGZIP, File file2) throws IOException {
        if (useGZIP) {
            return new BufferedDataInputStream(new GZIPInputStream(new FileInputStream(file2)));
        }
        return new BufferedDataInputStream(new FileInputStream(file2));
    }

    public static BufferedDataInputStream newBdFIS(boolean useGZIP, String filename) throws IOException {
        return FileUtil.newBdFIS(useGZIP, new File(filename));
    }

    public static BufferedDataOutputStream newBdFOS(boolean useGZIP, File file2) throws FileNotFoundException, IOException {
        if (useGZIP) {
            return new BufferedDataOutputStream(new GZIPOutputStream(new FileOutputStream(file2)));
        }
        return new BufferedDataOutputStream(new FileOutputStream(file2));
    }

    public static BufferedDataOutputStream newBdFOS(boolean useGZIP, String filename) throws IOException {
        return FileUtil.newBdFOS(useGZIP, new File(filename));
    }

    public static ObjectInputStream newOBFIS(File file2) throws FileNotFoundException, IOException {
        return new ObjectInputStream(new BufferedInputStream(new FileInputStream(file2)));
    }

    public static ObjectInputStream newOBFIS(String filename) throws FileNotFoundException, IOException {
        return FileUtil.newOBFIS(new File(filename));
    }

    public static ObjectOutputStream newOBFOS(File file2) throws FileNotFoundException, IOException {
        return new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
    }

    public static ObjectOutputStream newOBFOS(String filename) throws FileNotFoundException, IOException {
        return FileUtil.newOBFOS(new File(filename));
    }

    public static DataInputStream newDFIS(String filename) throws FileNotFoundException {
        return new DataInputStream(new FileInputStream(new File(filename)));
    }

    public static DataOutputStream newDFOS(String filename) throws FileNotFoundException {
        return new DataOutputStream(new FileOutputStream(new File(filename)));
    }

    public static File createTempFile(String fileName) {
        File file2;
        if (TLCGlobals.metaDir != null) {
            file2 = new File(TLCGlobals.metaDir + separatorChar + fileName);
        } else {
            String tDir = System.getProperty("java.io.tmpdir");
            file2 = new File(tDir + separatorChar + fileName);
        }
        file2.deleteOnExit();
        return file2;
    }

    public static long copyStream(InputStream is2, OutputStream os) throws IOException {
        int n;
        BufferedOutputStream bos;
        byte[] buffer = new byte[4096];
        long byteCount = 0L;
        BufferedInputStream bis = is2 instanceof BufferedInputStream ? (BufferedInputStream)is2 : new BufferedInputStream(is2);
        BufferedOutputStream bufferedOutputStream = bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
        while ((n = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, n);
            byteCount += (long)n;
        }
        bos.flush();
        return byteCount;
    }
}

