/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.FingerprintException;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueInputStream;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.UndefValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.UniqueString;

public class RecordValue
extends Value
implements Applicable {
    public final UniqueString[] names;
    public final Value[] values;
    private boolean isNorm;
    public static final RecordValue EmptyRcd = new RecordValue(new UniqueString[0], new Value[0], true);

    public RecordValue(UniqueString[] names, Value[] values, boolean isNorm) {
        this.names = names;
        this.values = values;
        this.isNorm = isNorm;
    }

    public RecordValue(UniqueString[] names, Value[] values, boolean isNorm, CostModel cm) {
        this(names, values, isNorm);
        this.cm = cm;
    }

    public RecordValue(UniqueString name2, Value v, boolean isNorm) {
        this(new UniqueString[]{name2}, new Value[]{v}, isNorm);
    }

    public RecordValue(UniqueString name2, Value v) {
        this(new UniqueString[]{name2}, new Value[]{v}, false);
    }

    public RecordValue(Location location) {
        this.names = new UniqueString[5];
        this.values = new Value[5];
        this.names[0] = UniqueString.of("beginLine");
        this.values[0] = IntValue.gen(location.beginLine());
        this.names[1] = UniqueString.of("beginColumn");
        this.values[1] = IntValue.gen(location.beginColumn());
        this.names[2] = UniqueString.of("endLine");
        this.values[2] = IntValue.gen(location.endLine());
        this.names[3] = UniqueString.of("endColumn");
        this.values[3] = IntValue.gen(location.endColumn());
        this.names[4] = UniqueString.of("module");
        this.values[4] = new StringValue(location.source());
        this.isNorm = false;
    }

    public RecordValue(Action action) {
        this.names = new UniqueString[2];
        this.values = new Value[2];
        this.names[0] = UniqueString.of("name");
        this.values[0] = new StringValue(action.getName());
        this.names[1] = UniqueString.of("location");
        this.values[1] = new RecordValue(action.getDefinition());
        this.isNorm = false;
    }

    public RecordValue(TLCState state) {
        OpDeclNode[] vars = state.getVars();
        this.names = new UniqueString[vars.length];
        this.values = new Value[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            this.names[i] = vars[i].getName();
            this.values[i] = (Value)state.lookup(this.names[i]);
        }
        this.isNorm = false;
    }

    public RecordValue(TLCState state, Action action) {
        OpDeclNode[] vars = state.getVars();
        this.names = new UniqueString[vars.length + 1];
        this.values = new Value[vars.length + 1];
        this.names[0] = UniqueString.of("_action");
        this.values[0] = new RecordValue(action);
        for (int i = 0; i < vars.length; ++i) {
            this.names[i + 1] = vars[i].getName();
            this.values[i + 1] = (Value)state.lookup(this.names[i + 1]);
        }
        this.isNorm = false;
    }

    public RecordValue(TLCState state, Value defVal) {
        this(state);
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            this.values[i] = defVal;
        }
    }

    public RecordValue(TLCState state, TLCState successor, Value defVal) {
        assert (state.getVars().length == successor.getVars().length);
        OpDeclNode[] vars = state.getVars();
        this.names = new UniqueString[vars.length * 2];
        this.values = new Value[vars.length * 2];
        for (int i = 0; i < vars.length; ++i) {
            int j = i * 2;
            UniqueString var = vars[i].getName();
            this.names[j] = UniqueString.of(var + " ");
            this.names[j + 1] = UniqueString.of(var + "'");
            this.values[j] = (Value)state.lookup(var);
            if (this.values[j] == null) {
                this.values[j] = defVal;
            }
            this.values[j + 1] = (Value)successor.lookup(var);
            if (this.values[j + 1] != null) continue;
            this.values[j + 1] = defVal;
        }
        this.isNorm = false;
    }

    @Override
    public final byte getKind() {
        return 4;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            RecordValue rcd;
            RecordValue recordValue = rcd = obj instanceof Value ? (RecordValue)((Value)obj).toRcd() : null;
            if (rcd == null) {
                if (obj instanceof ModelValue) {
                    return 1;
                }
                Assert.fail("Attempted to compare record:\n" + Values.ppr(this.toString()) + "\nwith non-record\n" + Values.ppr(obj.toString()), this.getSource());
            }
            this.normalize();
            rcd.normalize();
            int len = this.names.length;
            int cmp = len - rcd.names.length;
            if (cmp == 0) {
                for (int i = 0; i < len && (cmp = this.names[i].compareTo(rcd.names[i])) == 0 && (cmp = this.values[i].compareTo(rcd.values[i])) == 0; ++i) {
                }
            }
            return cmp;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final boolean equals(Object obj) {
        try {
            RecordValue rcd;
            RecordValue recordValue = rcd = obj instanceof Value ? (RecordValue)((Value)obj).toRcd() : null;
            if (rcd == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueEquals(this);
                }
                Assert.fail("Attempted to check equality of record:\n" + Values.ppr(this.toString()) + "\nwith non-record\n" + Values.ppr(obj.toString()), this.getSource());
            }
            this.normalize();
            rcd.normalize();
            int len = this.names.length;
            if (len != rcd.names.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (this.names[i].equals(rcd.names[i]) && this.values[i].equals(rcd.values[i])) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if element:\n" + Values.ppr(elem.toString()) + "\nis in the record:\n" + Values.ppr(this.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                int rlen = this.names.length;
                Value[] newValues = new Value[rlen];
                Value arcVal = ex.path[ex.idx];
                if (arcVal instanceof StringValue) {
                    UniqueString arc = ((StringValue)arcVal).val;
                    for (int i = 0; i < rlen; ++i) {
                        if (this.names[i].equals(arc)) {
                            ++ex.idx;
                            newValues[i] = this.values[i].takeExcept(ex);
                            continue;
                        }
                        newValues[i] = this.values[i];
                    }
                    UniqueString[] newNames = this.names;
                    if (!this.isNorm) {
                        newNames = new UniqueString[rlen];
                        for (int i = 0; i < rlen; ++i) {
                            newNames[i] = this.names[i];
                        }
                    }
                    return new RecordValue(newNames, newValues, this.isNorm);
                }
                MP.printWarning(2142, new String[]{Values.ppr(arcVal.toString())});
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Value res2 = this;
            for (int i = 0; i < exs.length; ++i) {
                res2 = ((Value)res2).takeExcept(exs[i]);
            }
            return res2;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value toRcd() {
        return this;
    }

    @Override
    public final Value toTuple() {
        return this.size() == 0 ? TupleValue.EmptyTuple : super.toTuple();
    }

    @Override
    public final Value toFcnRcd() {
        this.normalize();
        Value[] dom = new Value[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            dom[i] = new StringValue(this.names[i], this.cm);
        }
        if (coverage) {
            this.cm.incSecondary(dom.length);
        }
        return new FcnRcdValue(dom, this.values, this.isNormalized(), this.cm);
    }

    @Override
    public final int size() {
        try {
            return this.names.length;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            if (!(arg instanceof StringValue)) {
                Assert.fail("Attempted to access record by a non-string argument: " + Values.ppr(arg.toString()), this.getSource());
            }
            UniqueString name2 = ((StringValue)arg).getVal();
            int rlen = this.names.length;
            for (int i = 0; i < rlen; ++i) {
                if (!name2.equals(this.names[i])) continue;
                return this.values[i];
            }
            Assert.fail("Attempted to access nonexistent field '" + name2 + "' of record\n" + Values.ppr(this.toString()), this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            if (args.length != 1) {
                Assert.fail("Attempted to apply record to more than one arguments.", this.getSource());
            }
            return this.apply(args[0], control);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            if (!(arg instanceof StringValue)) {
                Assert.fail("Attempted to access record by a non-string argument: " + Values.ppr(arg.toString()), this.getSource());
            }
            UniqueString name2 = ((StringValue)arg).getVal();
            int rlen = this.names.length;
            for (int i = 0; i < rlen; ++i) {
                if (!name2.equals(this.names[i])) continue;
                return this.values[i];
            }
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            Value[] dElems = new Value[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                dElems[i] = new StringValue(this.names[i]);
            }
            return new SetEnumValue(dElems, this.isNormalized());
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final boolean assign(UniqueString name2, Value val2) {
        try {
            for (int i = 0; i < this.names.length; ++i) {
                if (!name2.equals(this.names[i])) continue;
                if (this.values[i] == UndefValue.ValUndef || this.values[i].equals(val2)) {
                    this.values[i] = val2;
                    return true;
                }
                return false;
            }
            Assert.fail("Attempted to assign to nonexistent record field " + name2 + ".", this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isNormalized() {
        return this.isNorm;
    }

    @Override
    public final Value normalize() {
        try {
            if (!this.isNorm) {
                int i;
                int len = this.names.length;
                for (i = 1; i < len; ++i) {
                    int cmp = this.names[0].compareTo(this.names[i]);
                    if (cmp == 0) {
                        Assert.fail("Field name " + this.names[i] + " occurs multiple times in record.", this.getSource());
                        continue;
                    }
                    if (cmp <= 0) continue;
                    UniqueString ts = this.names[0];
                    this.names[0] = this.names[i];
                    this.names[i] = ts;
                    Value tv = this.values[0];
                    this.values[0] = this.values[i];
                    this.values[i] = tv;
                }
                for (i = 2; i < len; ++i) {
                    int cmp;
                    int j = i;
                    UniqueString st = this.names[i];
                    Value val2 = this.values[i];
                    while ((cmp = st.compareTo(this.names[j - 1])) < 0) {
                        this.names[j] = this.names[j - 1];
                        this.values[j] = this.values[j - 1];
                        --j;
                    }
                    if (cmp == 0) {
                        Assert.fail("Field name " + this.names[i] + " occurs multiple times in record.", this.getSource());
                    }
                    this.names[j] = st;
                    this.values[j] = val2;
                }
                this.isNorm = true;
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].deepNormalize();
            }
            this.normalize();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            for (int i = 0; i < this.values.length; ++i) {
                defined = defined && this.values[i].isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final IValue deepCopy() {
        try {
            Value[] vals2 = new Value[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                vals2[i] = (Value)this.values[i].deepCopy();
            }
            return new RecordValue(Arrays.copyOf(this.names, this.names.length), vals2, this.isNorm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean assignable(Value val2) {
        try {
            boolean canAssign;
            boolean bl = canAssign = val2 instanceof RecordValue && this.names.length == ((RecordValue)val2).names.length;
            if (!canAssign) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                canAssign = canAssign && this.names[i].equals(((RecordValue)val2).names[i]) && this.values[i].assignable(((RecordValue)val2).values[i]);
            }
            return canAssign;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        int index2 = vos.put(this);
        if (index2 == -1) {
            vos.writeByte((byte)4);
            int len = this.names.length;
            vos.writeInt(this.isNormalized() ? len : -len);
            for (int i = 0; i < len; ++i) {
                int index1 = vos.put(this.names[i]);
                if (index1 == -1) {
                    vos.writeByte((byte)3);
                    this.names[i].write(vos.getOutputStream());
                } else {
                    vos.writeByte((byte)26);
                    vos.writeNat(index1);
                }
                this.values[i].write(vos);
            }
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index2);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.normalize();
            int rlen = this.names.length;
            fp = FP64.Extend(fp, (byte)9);
            fp = FP64.Extend(fp, rlen);
            for (int i = 0; i < rlen; ++i) {
                String str2 = this.names[i].toString();
                fp = FP64.Extend(fp, (byte)3);
                fp = FP64.Extend(fp, str2.length());
                fp = FP64.Extend(fp, str2);
                fp = this.values[i].fingerPrint(fp);
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.normalize();
            int rlen = this.names.length;
            Value[] vals2 = new Value[rlen];
            boolean changed = false;
            for (int i = 0; i < rlen; ++i) {
                vals2[i] = (Value)this.values[i].permute(perm);
                changed = changed || vals2[i] != this.values[i];
            }
            if (changed) {
                return new RecordValue(this.names, vals2, true);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            int len = this.names.length;
            sb.append("[");
            if (len > 0) {
                sb.append(this.names[0] + " |-> ");
                sb = this.values[0].toString(sb, offset, swallow);
            }
            for (int i = 1; i < len; ++i) {
                sb.append(", ");
                sb.append(this.names[i] + " |-> ");
                sb = this.values[i].toString(sb, offset, swallow);
            }
            return sb.append("]");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public static IValue createFrom(IValueInputStream vos) throws EOFException, IOException {
        int index2 = vos.getIndex();
        boolean isNorm = true;
        int len = vos.readInt();
        if (len < 0) {
            len = -len;
            isNorm = false;
        }
        UniqueString[] names = new UniqueString[len];
        Value[] vals2 = new Value[len];
        for (int i = 0; i < len; ++i) {
            int index1;
            byte kind1 = vos.readByte();
            if (kind1 == 26) {
                index1 = vos.readNat();
                names[i] = vos.getValue(index1);
            } else {
                index1 = vos.getIndex();
                names[i] = UniqueString.read(vos.getInputStream());
                vos.assign(names[i], index1);
            }
            vals2[i] = (Value)vos.read();
        }
        RecordValue res2 = new RecordValue(names, vals2, isNorm);
        vos.assign(res2, index2);
        return res2;
    }

    public static IValue createFrom(ValueInputStream vos, Map<String, UniqueString> tbl) throws EOFException, IOException {
        int index2 = vos.getIndex();
        boolean isNorm = true;
        int len = vos.readInt();
        if (len < 0) {
            len = -len;
            isNorm = false;
        }
        UniqueString[] names = new UniqueString[len];
        Value[] vals2 = new Value[len];
        for (int i = 0; i < len; ++i) {
            int index1;
            byte kind1 = vos.readByte();
            if (kind1 == 26) {
                index1 = vos.readNat();
                names[i] = vos.getValue(index1);
            } else {
                index1 = vos.getIndex();
                names[i] = UniqueString.read(vos.getInputStream(), tbl);
                vos.assign(names[i], index1);
            }
            vals2[i] = (Value)vos.read(tbl);
        }
        RecordValue res2 = new RecordValue(names, vals2, isNorm);
        vos.assign(res2, index2);
        return res2;
    }

    @Override
    public TLCState toState() {
        TLCState state = TLCState.Empty.createEmpty();
        OpDeclNode[] vars = state.getVars();
        for (int i = 0; i < vars.length; ++i) {
            UniqueString name2 = vars[i].getName();
            int rlen = this.names.length;
            for (int j = 0; j < rlen; ++j) {
                if (!name2.equals(this.names[j])) continue;
                state.bind(name2, (IValue)this.values[j]);
            }
        }
        return new PrintTLCState(this, state);
    }

    @Override
    public List<TLCVariable> getTLCVariables(TLCVariable prototype, Random rnd) {
        ArrayList<TLCVariable> nestedVars = new ArrayList<TLCVariable>(this.values.length);
        for (int i = 0; i < this.names.length; ++i) {
            UniqueString uniqueString = this.names[i];
            Value v = this.values[i];
            TLCVariable nested = prototype.newInstance(uniqueString.toString(), v, rnd);
            nested.setValue(v.toString());
            nested.setType(v.getTypeString());
            nestedVars.add(nested);
        }
        return nestedVars;
    }

    private static final class PrintTLCState
    extends TLCState {
        private final RecordValue rcd;
        private final TLCState state;

        public PrintTLCState(RecordValue recordValue, TLCState state) {
            this.rcd = recordValue;
            this.state = state;
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            int vlen = this.rcd.names.length;
            if (vlen == 1) {
                result.append(this.rcd.names[0].toString());
                result.append(" = ");
                result.append(Values.ppr(this.rcd.values[0]));
                result.append("\n");
            } else {
                for (int i = 0; i < vlen; ++i) {
                    UniqueString key2 = this.rcd.names[i];
                    result.append("/\\ ");
                    result.append(key2.toString());
                    result.append(" = ");
                    result.append(Values.ppr(this.rcd.values[i]));
                    result.append("\n");
                }
            }
            return result.toString();
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        public boolean equals(Object obj) {
            return this.state.equals(obj);
        }

        @Override
        public long fingerPrint() {
            return this.state.fingerPrint();
        }

        @Override
        public boolean allAssigned() {
            return this.state.allAssigned();
        }

        @Override
        public String toString(TLCState lastState) {
            return this.state.toString(lastState);
        }

        @Override
        public TLCState bind(UniqueString name2, IValue value) {
            return this.state.bind(name2, value);
        }

        @Override
        public TLCState bind(SymbolNode id, IValue value) {
            return this.state.bind(id, value);
        }

        @Override
        public TLCState unbind(UniqueString name2) {
            return this.state.unbind(name2);
        }

        @Override
        public IValue lookup(UniqueString var) {
            return this.state.lookup(var);
        }

        @Override
        public boolean containsKey(UniqueString var) {
            return this.state.containsKey(var);
        }

        @Override
        public TLCState copy() {
            return this.state.copy();
        }

        @Override
        public TLCState deepCopy() {
            return this.state.deepCopy();
        }

        @Override
        public StateVec addToVec(StateVec states) {
            return this.state.addToVec(states);
        }

        @Override
        public void deepNormalize() {
            this.state.deepNormalize();
        }

        @Override
        public Set<OpDeclNode> getUnassigned() {
            return this.state.getUnassigned();
        }

        @Override
        public TLCState createEmpty() {
            return this.state.createEmpty();
        }
    }
}

