/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.impl.UndefValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.ToolIO;

public class LazyValue
extends Value {
    private static final boolean LAZYEVAL_OFF = Boolean.getBoolean(LazyValue.class.getName() + ".off");
    public SemanticNode expr;
    public Context con;
    private Value val;

    public LazyValue(SemanticNode expr, Context con, CostModel cm) {
        this(expr, con, true, coverage ? cm.get(expr) : cm);
    }

    public LazyValue(SemanticNode expr, Context con, boolean cachable, CostModel cm) {
        this.expr = expr;
        this.con = con;
        this.cm = coverage ? cm.get(expr) : cm;
        this.val = null;
        if (LAZYEVAL_OFF || !cachable) {
            this.val = UndefValue.ValUndef;
        }
    }

    public final boolean isUncachable() {
        return this.val == UndefValue.ValUndef;
    }

    public final void setValue(Value aValue) {
        assert (!this.isUncachable());
        this.val = aValue;
    }

    public final Value getValue() {
        return this.val;
    }

    @Override
    public final byte getKind() {
        return 25;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to compare lazy values.", this.getSource());
            }
            return this.val.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to check equality of lazy values.", this.getSource());
            }
            return this.val.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to check set membership of lazy values.", this.getSource());
            }
            return this.val.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to check if a lazy value is a finite set.", this.getSource());
            }
            return this.val.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.", this.getSource());
            }
            return this.val.takeExcept(ex);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.", this.getSource());
            }
            return this.val.takeExcept(exs);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final int size() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to compute size of lazy value.", this.getSource());
            }
            return this.val.size();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.val = (Value)ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.val == null || this.val == UndefValue.ValUndef) {
            Assert.fail("Error(TLC): Attempted to serialize lazy value.", this.getSource());
        }
        oos.writeObject(this.val);
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to normalize lazy value.", this.getSource());
            }
            return this.val.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to normalize lazy value.", this.getSource());
            }
            this.val.normalize();
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                return this;
            }
            return this.val.deepCopy();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean assignable(Value val2) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to call assignable on lazy value.", this.getSource());
            }
            return this.val.assignable(val2);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to fingerprint a lazy value.", this.getSource());
            }
            return this.val.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply permutation to lazy value.", this.getSource());
            }
            return this.val.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            if (this.val == null || this.val == UndefValue.ValUndef) {
                return sb.append("<LAZY " + this.expr + ">");
            }
            return this.val.toString(sb, offset, swallow);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public IValue eval(Tool tool) {
        return this.eval(tool, TLCState.Empty);
    }

    public IValue eval(Tool tool, TLCState s0) {
        return this.eval(tool, s0, null);
    }

    public IValue eval(Tool tool, TLCState s0, TLCState s1) {
        Value eval2 = tool.eval(this.expr, this.con, s0, s1, 0, this.cm);
        if (!eval2.hasSource()) {
            eval2.setSource(this.expr);
        }
        return eval2;
    }

    static {
        if (LAZYEVAL_OFF) {
            ToolIO.out.println("LazyValue is disabled.");
        }
    }
}

