/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import java.util.NavigableMap;
import java.util.TreeMap;
import tlc2.util.statistics.AbstractBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class FixedSizedBucketStatistics
extends AbstractBucketStatistics
implements IBucketStatistics {
    private long observations;
    private final long[] buckets;

    public FixedSizedBucketStatistics(String aTitle, int aMaxmimum) {
        super(aTitle);
        this.buckets = new long[aMaxmimum];
    }

    @Override
    public void addSample(int amount) {
        int idx;
        if (amount < 0) {
            throw new IllegalArgumentException("Negative amount invalid");
        }
        int n = idx = Math.min(this.buckets.length - 1, amount);
        this.buckets[n] = this.buckets[n] + 1L;
        ++this.observations;
    }

    @Override
    public long getObservations() {
        return this.observations;
    }

    @Override
    public NavigableMap<Integer, Long> getSamples() {
        TreeMap<Integer, Long> res2 = new TreeMap<Integer, Long>();
        for (int i = 0; i < this.buckets.length; ++i) {
            long value = this.buckets[i];
            if (value <= 0L) continue;
            res2.put(i, value);
        }
        return res2;
    }
}

