/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tlc2.output.MP;
import tlc2.tool.TLCState;
import tlc2.util.StatePoolReader;
import tlc2.value.ValueOutputStream;
import util.Assert;

public class StatePoolWriter
extends Thread {
    private TLCState[] buf;
    private File poolFile;
    private StatePoolReader reader;

    public StatePoolWriter(int bufSize) {
        this(bufSize, null);
    }

    public StatePoolWriter(int bufSize, StatePoolReader reader2) {
        super("TLCStatePoolWriter");
        this.buf = new TLCState[bufSize];
        this.poolFile = null;
        this.reader = reader2;
    }

    public final synchronized TLCState[] doWork(TLCState[] enqBuf, File file2) throws IOException {
        if (this.poolFile != null) {
            ValueOutputStream vos = new ValueOutputStream(this.poolFile);
            for (int i = 0; i < this.buf.length; ++i) {
                this.buf[i].write(vos);
            }
            vos.close();
        }
        TLCState[] res2 = this.buf;
        this.buf = enqBuf;
        this.poolFile = file2;
        this.notify();
        return res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureWritten() throws InterruptedException {
        StatePoolWriter statePoolWriter = this;
        synchronized (statePoolWriter) {
            while (this.poolFile != null) {
                this.wait();
            }
        }
    }

    public final synchronized void beginChkpt(ObjectOutputStream oos) throws IOException {
        boolean hasFile = this.poolFile != null;
        oos.writeBoolean(hasFile);
        if (hasFile) {
            oos.writeObject(this.poolFile);
            for (int i = 0; i < this.buf.length; ++i) {
                oos.writeObject(this.buf[i]);
            }
        }
    }

    public final void recover(ObjectInputStream ois) throws IOException {
        boolean hasFile = ois.readBoolean();
        if (hasFile) {
            try {
                this.poolFile = (File)ois.readObject();
                for (int i = 0; i < this.buf.length; ++i) {
                    this.buf[i] = (TLCState)ois.readObject();
                }
            }
            catch (ClassNotFoundException e2) {
                Assert.fail(2126, e2);
            }
        } else {
            this.poolFile = null;
        }
    }

    @Override
    public void run() {
        try {
            StatePoolWriter statePoolWriter = this;
            synchronized (statePoolWriter) {
                while (true) {
                    if (this.poolFile == null) {
                        this.wait();
                        if (this.poolFile != null) continue;
                        return;
                    }
                    ValueOutputStream vos = new ValueOutputStream(this.poolFile);
                    for (int i = 0; i < this.buf.length; ++i) {
                        this.buf[i].write(vos);
                    }
                    vos.close();
                    this.poolFile = null;
                    this.notify();
                    if (this.reader == null) continue;
                    this.reader.wakeup();
                }
            }
        }
        catch (Exception e2) {
            MP.printError(2127, e2.getMessage(), (Throwable)e2);
            System.exit(1);
            return;
        }
    }
}

