/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import tlc2.tool.distributed.TLCServerRMI;
import util.FilenameToStream;

public class RMIFilenameToStreamResolver
implements FilenameToStream {
    private static final String javaTempDir = System.getProperty("java.io.tmpdir") + File.separator;
    private TLCServerRMI server;
    private final Map<String, File> fileCache = new HashMap<String, File>();
    private final String rndPrefix = this.getRandomStoragePrefix();

    public RMIFilenameToStreamResolver() {
    }

    public RMIFilenameToStreamResolver(String[] libraryPaths) {
    }

    public void setTLCServer(TLCServerRMI aServer) {
        this.server = aServer;
    }

    @Override
    public File resolve(String filename, boolean isModule) {
        String name2 = new FilenameToStream.TLAFile(filename, this).getName();
        File file2 = this.fileCache.get(name2);
        if (file2 == null || !file2.exists()) {
            byte[] bs = new byte[]{};
            try {
                bs = this.server.getFile(name2);
            }
            catch (RemoteException e2) {
                e2.printStackTrace();
            }
            file2 = this.writeToNewTempFile(name2, bs);
            this.fileCache.put(name2, file2);
        }
        return file2;
    }

    @Override
    public boolean isStandardModule(String moduleName) {
        return false;
    }

    private String getRandomStoragePrefix() {
        File file2 = new File(javaTempDir + System.currentTimeMillis());
        file2.deleteOnExit();
        file2.mkdir();
        return file2.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeToNewTempFile(String name2, byte[] bs) {
        FilenameToStream.TLAFile f = new FilenameToStream.TLAFile(this.rndPrefix + File.separator + name2, this);
        f.deleteOnExit();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(f);
            outputStream.write(bs);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        return f;
    }

    @Override
    public String getFullPath() {
        StringBuffer buf = new StringBuffer();
        String[] strings = this.fileCache.keySet().toArray(new String[this.fileCache.size()]);
        for (int i = 0; i < strings.length; ++i) {
            String string2 = strings[i];
            buf.append(string2);
            if (i >= string2.length() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

