/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.Action;
import tlc2.tool.StateVec;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import util.Assert;
import util.UniqueString;

public abstract class TLCState
implements Cloneable,
Serializable {
    public short workerId = Short.MAX_VALUE;
    public static final int INIT_UID = -1;
    public long uid = -1L;
    public static final int INIT_LEVEL = 1;
    private int level = 1;
    public static final TLCState Null = null;
    public static TLCState Empty = null;
    protected static OpDeclNode[] vars = null;

    public static boolean isEmpty(TLCState state) {
        return Empty == state;
    }

    public void read(IValueInputStream vis) throws IOException {
        this.workerId = vis.readShortNat();
        this.uid = vis.readLongNat();
        this.level = vis.readShortNat();
        assert (this.level >= 0);
    }

    public void write(IValueOutputStream vos) throws IOException {
        if (this.level > Short.MAX_VALUE) {
            Assert.fail(2282, this.toString());
        }
        vos.writeShortNat(this.workerId);
        vos.writeLongNat(this.uid);
        vos.writeShortNat((short)this.level);
    }

    public abstract TLCState bind(UniqueString var1, IValue var2);

    public abstract TLCState bind(SymbolNode var1, IValue var2);

    public abstract TLCState unbind(UniqueString var1);

    public IValue lookup(String var) {
        return this.lookup(UniqueString.uniqueStringOf(var));
    }

    public abstract IValue lookup(UniqueString var1);

    public abstract boolean containsKey(UniqueString var1);

    public abstract TLCState copy();

    public abstract TLCState deepCopy();

    public abstract StateVec addToVec(StateVec var1);

    public abstract void deepNormalize();

    public abstract long fingerPrint();

    public abstract boolean allAssigned();

    public abstract Set<OpDeclNode> getUnassigned();

    public abstract TLCState createEmpty();

    protected TLCState deepCopy(TLCState copy2) {
        copy2.level = this.level;
        copy2.workerId = this.workerId;
        copy2.uid = this.uid;
        return copy2;
    }

    public boolean noneAssigned() {
        return this.getUnassigned().size() >= vars.length;
    }

    public final Map<UniqueString, IValue> getVals() {
        HashMap<UniqueString, IValue> valMap = new HashMap<UniqueString, IValue>();
        for (int i = 0; i < vars.length; ++i) {
            UniqueString key2 = vars[i].getName();
            IValue val2 = this.lookup(key2);
            valMap.put(key2, val2);
        }
        return valMap;
    }

    public final OpDeclNode[] getVars() {
        return vars;
    }

    public final String[] getVarsAsStrings() {
        String[] res2 = new String[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            res2[i] = vars[i].getName().toString();
        }
        return res2;
    }

    public TLCState setPredecessor(TLCState predecessor) {
        if (predecessor.getLevel() == Integer.MAX_VALUE) {
            Assert.fail(2282, this.toString());
        }
        this.level = predecessor.getLevel() + 1;
        return this;
    }

    public TLCState unsetPredecessor() {
        return this;
    }

    public TLCState getPredecessor() {
        return null;
    }

    public final int getLevel() {
        return this.level;
    }

    public final boolean isInitial() {
        return this.level == 1;
    }

    public abstract String toString();

    public abstract String toString(TLCState var1);

    public Object execCallable() throws Exception {
        return null;
    }

    public void setCallable(Callable<?> cl) {
    }

    public Action getAction() {
        return null;
    }

    public TLCState setAction(Action action) {
        return this;
    }

    public boolean hasAction() {
        return this.getAction() != null;
    }
}

