/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.impl.Value;
import util.SimpleFilenameToStream;

public class TLAPlusExecutor {
    private final ReentrantLock lock = new ReentrantLock();
    private final FastTool tool;
    private TLCState state;

    public TLAPlusExecutor(String spec2, String config) {
        this.tool = new FastTool(spec2, config, new SimpleFilenameToStream(), Tool.Mode.Executor);
        this.state = this.tool.getInitStates().first();
    }

    public Mapping map(String actionName, String processNode, IValue v, String ... params) {
        Action[] actions;
        for (Action action : actions = this.tool.getActions()) {
            Object lookup;
            if (!action.getName().equals(actionName) || (lookup = action.con.lookup(s -> s.getName().equals(processNode))) == null || !lookup.equals(v)) continue;
            return new Mapping(action, params);
        }
        throw new RuntimeException("failed to create mapping");
    }

    public Object step(Mapping m) throws Exception {
        Context ctx = m.getContext();
        this.lock.lock();
        try {
            while (true) {
                StateVec nextStates = this.tool.getNextStates(m.action, ctx, this.state);
                assert (!nextStates.isEmpty());
                this.state = nextStates.first();
                for (int k = 0; k < this.tool.getInvariants().length; ++k) {
                    if (this.tool.isValid(this.tool.getInvariants()[k], this.state)) continue;
                    throw new INextStateFunctor.InvariantViolatedException();
                }
                Object result = this.state.execCallable();
                if (result == null) continue;
                Object object = result;
                return object;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public Value getConstant(String string2) {
        return (Value)this.tool.getSpecProcessor().getDefns().get(string2);
    }

    public class Mapping {
        private final Action action;
        private final Map<SymbolNode, IValue> params;
        private final Map<String, SymbolNode> symbol2node;

        public Mapping(Action a, String ... params) {
            this.action = a;
            this.params = new HashMap<SymbolNode, IValue>();
            this.symbol2node = new HashMap<String, SymbolNode>();
            for (String param : params) {
                SymbolNode node2 = this.action.con.lookupName(s -> s.getName().equals(param));
                this.symbol2node.put(param, node2);
            }
        }

        public Mapping set(String param, IValue value) {
            SymbolNode node2 = this.symbol2node.get(param);
            this.params.put(node2, value);
            return this;
        }

        public Context getContext() {
            Context ctx = this.action.con;
            for (Map.Entry<SymbolNode, IValue> entry : this.params.entrySet()) {
                ctx = ctx.cons(entry.getKey(), entry.getValue());
            }
            return ctx;
        }
    }
}

