/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import tla2sany.semantic.ExprNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.SimulationWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.coverage.CostModelCreator;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.Tool;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.liveness.LiveCheck1;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.NoOpLiveCheck;
import tlc2.util.DotActionWriter;
import tlc2.util.RandomGenerator;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.value.IValue;
import util.Assert;
import util.FileUtil;
import util.FilenameToStream;

public class Simulator {
    public static boolean EXPERIMENTAL_LIVENESS_SIMULATION = Boolean.getBoolean(Simulator.class.getName() + ".experimentalLiveness");
    private final String traceActions;
    private final ILiveCheck liveCheck;
    private final ITool tool;
    private final Action[] invariants;
    private final boolean checkDeadlock;
    private final boolean checkLiveness;
    private final LongAdder numOfGenStates = new LongAdder();
    private final LongAdder numOfGenTraces = new LongAdder();
    private final AtomicLong welfordM2AndMean = new AtomicLong();
    private final String traceFile;
    private final int traceDepth;
    private final long traceNum;
    private int numWorkers = 1;
    private final RandomGenerator rng;
    private final long seed;
    private long aril;
    protected final BlockingQueue<SimulationWorker.SimulationWorkerResult> workerResultQueue = new LinkedBlockingQueue<SimulationWorker.SimulationWorkerResult>();
    private final long startTime = System.currentTimeMillis();
    protected final List<SimulationWorker> workers;

    public Simulator(String specFile, String configFile, String traceFile, boolean deadlock, int traceDepth, long traceNum, RandomGenerator rng, long seed, FilenameToStream resolver, int numWorkers) throws IOException {
        this(new FastTool(Simulator.extracted(specFile), configFile, resolver, Tool.Mode.Simulation), "", traceFile, deadlock, traceDepth, traceNum, null, rng, seed, resolver, numWorkers);
    }

    private static String extracted(String specFile) {
        int lastSep = specFile.lastIndexOf(FileUtil.separatorChar);
        return specFile.substring(lastSep + 1);
    }

    public Simulator(ITool tool, String metadir, String traceFile, boolean deadlock, int traceDepth, long traceNum, String traceActions, RandomGenerator rng, long seed, FilenameToStream resolver, int numWorkers) throws IOException {
        this.tool = tool;
        this.checkDeadlock = deadlock && tool.getModelConfig().getCheckDeadlock();
        this.checkLiveness = !this.tool.livenessIsTrue();
        this.invariants = this.tool.getInvariants();
        this.traceDepth = traceDepth != -1 ? traceDepth : Integer.MAX_VALUE;
        this.traceFile = traceFile;
        this.traceNum = traceNum;
        this.traceActions = traceActions;
        this.rng = rng;
        this.seed = seed;
        this.aril = 0L;
        if (this.checkLiveness) {
            if (EXPERIMENTAL_LIVENESS_SIMULATION) {
                String tmpDir = System.getProperty("java.io.tmpdir");
                this.liveCheck = new LiveCheck(this.tool.getLiveness(), tmpDir, new DummyBucketStatistics());
            } else {
                this.liveCheck = new LiveCheck1(this.tool.getLiveness());
            }
        } else {
            this.liveCheck = new NoOpLiveCheck(tool, metadir);
        }
        this.numWorkers = numWorkers;
        this.workers = new ArrayList<SimulationWorker>(numWorkers);
        for (int i = 0; i < this.numWorkers; ++i) {
            this.workers.add(new SimulationWorker(i, this.tool, this.workerResultQueue, this.rng.nextLong(), this.traceDepth, this.traceNum, this.traceActions, this.checkDeadlock, this.traceFile, this.liveCheck, this.numOfGenStates, this.numOfGenTraces, this.welfordM2AndMean));
        }
        if (TLCGlobals.isCoverageEnabled()) {
            CostModelCreator.create(this.tool);
        }
        AbstractChecker.scheduleTermination(new TimerTask(){

            @Override
            public void run() {
                Simulator.this.stop();
            }
        });
    }

    protected boolean isNonContinuableError(int ec) {
        return ec == 2111 || ec == 2113 || ec == 2109;
    }

    private void shutdownAndJoinWorkers(List<SimulationWorker> workers) throws InterruptedException {
        for (SimulationWorker worker : workers) {
            worker.interrupt();
            worker.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int simulate() throws Exception {
        StateVec initStates;
        int res2 = this.tool.checkAssumptions();
        if (res2 != 0) {
            return res2;
        }
        TLCState curState = null;
        try {
            StateVec inits = this.tool.getInitStates();
            initStates = new StateVec(inits.size());
            assert (this.numOfGenStates.longValue() == 0L);
            this.numOfGenStates.add(inits.size());
            MP.printMessage(2269, this.numOfGenStates.toString());
            for (int i = 0; i < inits.size(); ++i) {
                curState = inits.elementAt(i);
                if (this.tool.isGoodState(curState)) {
                    for (int j = 0; j < this.invariants.length; ++j) {
                        if (this.tool.isValid(this.invariants[j], curState)) continue;
                        return MP.printError(2107, new String[]{this.tool.getInvNames()[j], curState.toString()});
                    }
                } else {
                    return MP.printError(2106, curState.toString());
                }
                if (!this.tool.isInModel(curState)) continue;
                initStates.addElement(curState);
            }
        }
        catch (Exception e2) {
            int errorCode = curState != null ? MP.printError(2102, new String[]{e2.getMessage() == null ? e2.toString() : e2.getMessage(), curState.toString()}) : MP.printError(1000, e2);
            this.printSummary();
            return errorCode;
        }
        if (this.numOfGenStates.longValue() == 0L) {
            return MP.printError(2118);
        }
        initStates.deepNormalize();
        ProgressReport report = new ProgressReport();
        report.start();
        this.aril = this.rng.getAril();
        int errorCode = this.simulate(initStates);
        if (errorCode == 0) {
            ExprNode sn = (ExprNode)this.tool.getPostConditionSpec();
            try {
                if (sn != null && !this.tool.isValid(sn)) {
                    MP.printError(2104, sn.toString());
                }
            }
            catch (Exception e3) {
                MP.printError(2105, new String[]{sn.toString(), e3.getMessage()});
            }
        }
        report.isRunning = false;
        ProgressReport progressReport = report;
        synchronized (progressReport) {
            report.notify();
        }
        report.join();
        return errorCode;
    }

    protected int simulate(StateVec initStates) throws InterruptedException {
        HashSet<Integer> runningWorkers = new HashSet<Integer>();
        for (int i = 0; i < this.workers.size(); ++i) {
            SimulationWorker worker = this.workers.get(i);
            worker.start(initStates);
            runningWorkers.add(i);
        }
        int errorCode = 0;
        while (true) {
            SimulationWorker.SimulationWorkerResult result;
            if ((result = this.workerResultQueue.take()).isError()) {
                SimulationWorker.SimulationWorkerError error = result.error();
                if (error.exception != null) {
                    if (error.exception instanceof LiveException) {
                        this.printSummary();
                        errorCode = ((LiveException)error.exception).errorCode;
                    } else if (error.exception instanceof Assert.TLCRuntimeException) {
                        Assert.TLCRuntimeException exception = (Assert.TLCRuntimeException)error.exception;
                        this.printBehavior(exception, error.state, error.stateTrace);
                        errorCode = exception.errorCode;
                    } else {
                        this.printBehavior(1000, new String[]{MP.ECGeneralMsg("", error.exception)}, error.state, error.stateTrace);
                        errorCode = 1000;
                    }
                    break;
                }
                this.printBehavior(error);
                if (this.isNonContinuableError(error.errorCode)) {
                    errorCode = error.errorCode;
                    break;
                }
                if (!TLCGlobals.continuation) {
                    errorCode = error.errorCode;
                    break;
                }
                if (errorCode != 0) continue;
                errorCode = 1000;
                continue;
            }
            runningWorkers.remove(result.workerId());
            if (runningWorkers.isEmpty()) break;
        }
        this.shutdownAndJoinWorkers(this.workers);
        return errorCode;
    }

    protected final void printBehavior(Assert.TLCRuntimeException exception, TLCState state, StateVec stateTrace) {
        MP.printTLCRuntimeException(exception);
        this.printBehavior(state, stateTrace);
    }

    protected final void printBehavior(SimulationWorker.SimulationWorkerError error) {
        this.printBehavior(error.errorCode, error.parameters, error.state, error.stateTrace);
    }

    protected final void printBehavior(int errorCode, String[] parameters, TLCState state, StateVec stateTrace) {
        MP.printError(errorCode, parameters);
        this.printBehavior(state, stateTrace);
        this.printSummary();
    }

    private final void printBehavior(TLCState state, StateVec stateTrace) {
        if ((long)this.traceDepth == Long.MAX_VALUE) {
            MP.printMessage(2120);
            StatePrinter.printStandaloneErrorState(state);
        } else {
            if (!stateTrace.isLastElement(state)) {
                stateTrace.addElement(state);
            }
            MP.printError(2121);
            TLCState lastState = null;
            int omitted = 0;
            for (int i = 0; i < stateTrace.size(); ++i) {
                TLCStateInfo sinfo;
                TLCState curState = stateTrace.elementAt(i);
                TLCState sucState = stateTrace.elementAt(Math.min(i + 1, stateTrace.size() - 1));
                if (lastState == null) {
                    sinfo = new TLCStateInfo(curState);
                    StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(sinfo, sucState), lastState, curState.getLevel());
                    lastState = curState;
                    continue;
                }
                sinfo = new TLCStateInfo(curState);
                if (TLCGlobals.printDiffsOnly && curState.fingerPrint() == lastState.fingerPrint()) {
                    ++omitted;
                } else {
                    StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(sinfo, sucState), lastState, curState.getLevel());
                }
                lastState = curState;
            }
            if (omitted > 0) {
                assert (TLCGlobals.printDiffsOnly);
                MP.printMessage(1000, String.format("difftrace requested: Shortened behavior by omitting finite stuttering (%s states), which is an artifact of simulation mode.\n", omitted));
            }
        }
    }

    public IValue getLocalValue(int idx) {
        Iterator<SimulationWorker> iterator = this.workers.iterator();
        if (iterator.hasNext()) {
            SimulationWorker w = iterator.next();
            return w.getLocalValue(idx);
        }
        return null;
    }

    public void setAllValues(int idx, IValue val2) {
        for (SimulationWorker w : this.workers) {
            w.setLocalValue(idx, val2);
        }
    }

    public List<IValue> getAllValues(int idx) {
        return this.workers.stream().map(w -> w.getLocalValue(idx)).collect(Collectors.toList());
    }

    protected final void printSummary() {
        this.reportCoverage();
        try {
            this.writeActionFlowGraph();
        }
        catch (Exception e2) {
            MP.printTLCBug(2124, null);
        }
        if (TLCGlobals.tool) {
            MP.printMessage(2209, String.valueOf(this.numOfGenStates.longValue()));
        }
        MP.printMessage(2210, String.valueOf(this.numOfGenStates.longValue()), String.valueOf(this.seed), String.valueOf(this.aril));
    }

    public final void reportCoverage() {
        if (TLCGlobals.isCoverageEnabled()) {
            CostModelCreator.report(this.tool, this.startTime);
        }
    }

    public final ITool getTool() {
        return this.tool;
    }

    private void writeActionFlowGraph() throws IOException {
        if (this.traceActions == "BASIC") {
            this.writeActionFlowGraphBasic();
        } else if (this.traceActions == "FULL") {
            this.writeActionFlowGraphFull();
        }
    }

    private void writeActionFlowGraphFull() throws IOException {
        Action[] actions = this.tool.getActions();
        int len = actions.length;
        HashMap clusters = new HashMap();
        for (int i = 0; i < len; ++i) {
            String con = actions[i].con.toString();
            if (!clusters.containsKey(con)) {
                clusters.put(con, new HashSet());
            }
            ((Set)clusters.get(con)).add(i);
        }
        DotActionWriter dotActionWriter = new DotActionWriter(this.tool.getRootName() + "_actions.dot", "");
        for (Map.Entry entry : clusters.entrySet()) {
            String key2 = Integer.toString(Math.abs(((String)entry.getKey()).hashCode()));
            dotActionWriter.writeSubGraphStart(key2, ((String)entry.getKey()).toString());
            Set ids = (Set)entry.getValue();
            for (Integer id : ids) {
                dotActionWriter.write(actions[id], (int)id);
            }
            dotActionWriter.writeSubGraphEnd();
        }
        long[][] aggregateActionStats = new long[len][len];
        List<SimulationWorker> list = this.workers;
        for (SimulationWorker sw : list) {
            long[][] s = sw.actionStats;
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < len; ++j) {
                    long[] lArray = aggregateActionStats[i];
                    int n = j;
                    lArray[n] = lArray[n] + s[i][j];
                }
            }
        }
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                long l = aggregateActionStats[i][j];
                if (l > 0L) {
                    double loglogWeight = Math.log10(Math.log10(l + 1L));
                    dotActionWriter.write(i, j, BigDecimal.valueOf(loglogWeight).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    continue;
                }
                dotActionWriter.write(i, j);
            }
        }
        dotActionWriter.close();
    }

    private void writeActionFlowGraphBasic() throws IOException {
        int i;
        Action[] actions = this.tool.getActions();
        int len = actions.length;
        HashMap<Integer, String> idToActionName = new HashMap<Integer, String>();
        for (int i2 = 0; i2 < len; ++i2) {
            String actionName = actions[i2].isNamed() ? actions[i2].getName().toString() : actions[i2].toString();
            idToActionName.put(i2, actionName);
        }
        DotActionWriter dotActionWriter = new DotActionWriter(this.tool.getRootName() + "_actions.dot", "");
        List distinctActionNames = idToActionName.values().stream().distinct().sorted().collect(Collectors.toList());
        for (int i3 = 0; i3 < distinctActionNames.size(); ++i3) {
            String actionName = (String)distinctActionNames.get(i3);
            dotActionWriter.write(actionName, i3);
        }
        long[][] aggregateActionStats = new long[len][len];
        List<SimulationWorker> workers = this.workers;
        for (SimulationWorker sw : workers) {
            long[][] s = sw.actionStats;
            for (int i4 = 0; i4 < len; ++i4) {
                for (int j = 0; j < len; ++j) {
                    long[] lArray = aggregateActionStats[i4];
                    int n = j;
                    lArray[n] = lArray[n] + s[i4][j];
                }
            }
        }
        long[][] reducedAggregateActionStats = new long[distinctActionNames.size()][distinctActionNames.size()];
        for (i = 0; i < len; ++i) {
            int originActionId = distinctActionNames.indexOf(idToActionName.get(i));
            for (int j = 0; j < len; ++j) {
                int nextActionId = distinctActionNames.indexOf(idToActionName.get(j));
                long[] lArray = reducedAggregateActionStats[originActionId];
                int n = nextActionId;
                lArray[n] = lArray[n] + aggregateActionStats[i][j];
            }
        }
        for (i = 0; i < distinctActionNames.size(); ++i) {
            for (int j = 0; j < distinctActionNames.size(); ++j) {
                long l = reducedAggregateActionStats[i][j];
                if (l > 0L) {
                    double loglogWeight = Math.log10(Math.log10(l + 1L));
                    dotActionWriter.write(i, j, BigDecimal.valueOf(loglogWeight).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    continue;
                }
                dotActionWriter.write(i, j);
            }
        }
        dotActionWriter.close();
    }

    public final StateVec getTrace(TLCState s) {
        if (Thread.currentThread() instanceof SimulationWorker) {
            SimulationWorker w = (SimulationWorker)Thread.currentThread();
            return w.getTrace(s);
        }
        assert (this.numWorkers == 1 && this.workers.size() == this.numWorkers);
        return this.workers.get(0).getTrace(s);
    }

    public final StateVec getTrace() {
        if (Thread.currentThread() instanceof SimulationWorker) {
            SimulationWorker w = (SimulationWorker)Thread.currentThread();
            return w.getTrace();
        }
        assert (this.numWorkers == 1 && this.workers.size() == this.numWorkers);
        return this.workers.get(0).getTrace();
    }

    public TLCStateInfo[] getTraceInfo(int level) {
        if (Thread.currentThread() instanceof SimulationWorker) {
            SimulationWorker w = (SimulationWorker)Thread.currentThread();
            return w.getTraceInfo(level);
        }
        assert (this.numWorkers == 1 && this.workers.size() == this.numWorkers);
        return this.workers.get(0).getTraceInfo(level);
    }

    public void stop() {
        for (SimulationWorker worker : this.workers) {
            worker.interrupt();
        }
    }

    public RandomGenerator getRNG() {
        if (Thread.currentThread() instanceof SimulationWorker) {
            SimulationWorker w = (SimulationWorker)Thread.currentThread();
            return w.getRNG();
        }
        return this.rng;
    }

    public int getTraceDepth() {
        return this.traceDepth;
    }

    final class ProgressReport
    extends Thread {
        volatile boolean isRunning = true;

        ProgressReport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int count2 = TLCGlobals.coverageInterval / 60000;
            try {
                while (this.isRunning) {
                    ProgressReport progressReport = this;
                    synchronized (progressReport) {
                        this.wait(60000L);
                    }
                    long genTrace = Simulator.this.numOfGenTraces.longValue();
                    long m2AndMean = Simulator.this.welfordM2AndMean.get();
                    long mean = m2AndMean & 0xFFFFFFFFL;
                    long m2 = m2AndMean >>> 32;
                    MP.printMessage(2209, String.valueOf(Simulator.this.numOfGenStates.longValue()), String.valueOf(genTrace), String.valueOf(mean), String.valueOf(Math.round((double)m2 / ((double)genTrace + 1.0))), String.valueOf(Math.round(Math.sqrt((double)m2 / ((double)genTrace + 1.0)))));
                    if (count2 > 1) {
                        --count2;
                    } else {
                        Simulator.this.reportCoverage();
                        count2 = TLCGlobals.coverageInterval / 60000;
                    }
                    Simulator.this.writeActionFlowGraph();
                }
            }
            catch (Exception e2) {
                MP.printTLCBug(2124, null);
            }
        }
    }
}

