/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import tlc2.overrides.TLAPlusOperator;
import tlc2.value.IValue;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.SubsetValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class Json {
    public static final long serialVersionUID = 20210223L;

    @TLAPlusOperator(identifier="ToJson", module="Json", warn=false)
    public static StringValue toJson(IValue value) throws IOException {
        return new StringValue(Json.getNode(value).toString());
    }

    @TLAPlusOperator(identifier="ToJsonArray", module="Json", warn=false)
    public static StringValue toJsonArray(IValue value) throws IOException {
        return new StringValue(Json.getArrayNode(value).toString());
    }

    @TLAPlusOperator(identifier="ToJsonObject", module="Json", warn=false)
    public static StringValue toJsonObject(IValue value) throws IOException {
        return new StringValue(Json.getObjectNode(value).toString());
    }

    @TLAPlusOperator(identifier="ndJsonDeserialize", module="Json", warn=false)
    public static IValue ndDeserialize(StringValue path2) throws IOException {
        ArrayList<Value> values = new ArrayList<Value>();
        try (BufferedReader reader2 = new BufferedReader(new FileReader(new File(path2.val.toString())));){
            String line = reader2.readLine();
            while (line != null) {
                JsonElement node2 = JsonParser.parseString(line);
                values.add(Json.getValue(node2));
                line = reader2.readLine();
            }
        }
        return new TupleValue(values.toArray(new Value[0]));
    }

    @TLAPlusOperator(identifier="JsonDeserialize", module="Json", warn=false)
    public static IValue deserialize(StringValue path2) throws IOException {
        JsonElement node2 = JsonParser.parseReader(new FileReader(new File(path2.val.toString())));
        return Json.getValue(node2);
    }

    @TLAPlusOperator(identifier="ndJsonSerialize", module="Json", warn=false)
    public static BoolValue ndSerialize(StringValue path2, TupleValue value) throws IOException {
        File file2 = new File(path2.val.toString());
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        try (BufferedWriter writer2 = new BufferedWriter(new FileWriter(new File(path2.val.toString())));){
            for (int i = 0; i < value.elems.length; ++i) {
                writer2.write(Json.getNode(value.elems[i]).toString() + "\n");
            }
        }
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="JsonSerialize", module="Json", warn=false)
    public static BoolValue serialize(StringValue path2, TupleValue value) throws IOException {
        File file2 = new File(path2.val.toString());
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        try (BufferedWriter writer2 = new BufferedWriter(new FileWriter(new File(path2.val.toString())));){
            writer2.write("[\n");
            for (int i = 0; i < value.elems.length; ++i) {
                writer2.write(Json.getNode(value.elems[i]).toString());
                if (i >= value.elems.length - 1) continue;
                writer2.write(",\n");
            }
            writer2.write("\n]\n");
        }
        return BoolValue.ValTrue;
    }

    private static JsonElement getNode(IValue value) throws IOException {
        if (value instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)value);
        }
        if (value instanceof StringValue) {
            return new JsonPrimitive(((StringValue)value).val.toString());
        }
        if (value instanceof ModelValue) {
            return new JsonPrimitive(((ModelValue)value).val.toString());
        }
        if (value instanceof IntValue) {
            return new JsonPrimitive(((IntValue)value).val);
        }
        if (value instanceof BoolValue) {
            return new JsonPrimitive(((BoolValue)value).val);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        if (value instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)value);
        }
        if (value instanceof SetOfRcdsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfRcdsValue)value).toSetEnum());
        }
        if (value instanceof SetOfTuplesValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfTuplesValue)value).toSetEnum());
        }
        if (value instanceof SetOfFcnsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfFcnsValue)value).toSetEnum());
        }
        if (value instanceof SubsetValue) {
            return Json.getArrayNode((SetEnumValue)((SubsetValue)value).toSetEnum());
        }
        if (value instanceof IntervalValue) {
            return Json.getArrayNode((SetEnumValue)((IntervalValue)value).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static boolean isValidSequence(FcnRcdValue value) {
        if (value.intv != null) {
            return value.intv.low == 1 && value.intv.high == value.domain.length;
        }
        for (Value domain : value.domain) {
            if (domain instanceof IntValue) continue;
            return false;
        }
        value.normalize();
        for (int i = 0; i < value.domain.length; ++i) {
            if (((IntValue)value.domain[i]).val == i + 1) continue;
            return false;
        }
        return true;
    }

    private static JsonElement getObjectNode(IValue value) throws IOException {
        if (value instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return Json.getObjectNode((TupleValue)value);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static JsonElement getObjectNode(FcnRcdValue value) throws IOException {
        if (Json.isValidSequence(value)) {
            return Json.getArrayNode(value);
        }
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.domain.length; ++i) {
            Value domainValue = value.domain[i];
            if (domainValue instanceof StringValue) {
                jsonObject.add(((StringValue)domainValue).val.toString(), Json.getNode(value.values[i]));
                continue;
            }
            jsonObject.add(domainValue.toString(), Json.getNode(value.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(RecordValue value) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.names.length; ++i) {
            jsonObject.add(value.names[i].toString(), Json.getNode(value.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(TupleValue value) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.elems.length; ++i) {
            jsonObject.add(String.valueOf(i), Json.getNode(value.elems[i]));
        }
        return jsonObject;
    }

    private static JsonElement getArrayNode(IValue value) throws IOException {
        if (value instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)value);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getArrayNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getArrayNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        if (value instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)value);
        }
        if (value instanceof SetOfRcdsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfRcdsValue)value).toSetEnum());
        }
        if (value instanceof SetOfTuplesValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfTuplesValue)value).toSetEnum());
        }
        if (value instanceof SetOfFcnsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfFcnsValue)value).toSetEnum());
        }
        if (value instanceof SubsetValue) {
            return Json.getArrayNode((SetEnumValue)((SubsetValue)value).toSetEnum());
        }
        if (value instanceof IntervalValue) {
            return Json.getArrayNode((SetEnumValue)((IntervalValue)value).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static JsonElement getArrayNode(TupleValue value) throws IOException {
        JsonArray jsonArray = new JsonArray(value.elems.length);
        for (int i = 0; i < value.elems.length; ++i) {
            jsonArray.add(Json.getNode(value.elems[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(FcnRcdValue value) throws IOException {
        if (!Json.isValidSequence(value)) {
            return Json.getObjectNode(value);
        }
        value.normalize();
        JsonArray jsonArray = new JsonArray(value.values.length);
        for (int i = 0; i < value.values.length; ++i) {
            jsonArray.add(Json.getNode(value.values[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(SetEnumValue value) throws IOException {
        value.normalize();
        Value[] values = value.elems.toArray();
        JsonArray jsonArray = new JsonArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            jsonArray.add(Json.getNode(values[i]));
        }
        return jsonArray;
    }

    private static Value getValue(JsonElement node2) throws IOException {
        if (node2.isJsonArray()) {
            return Json.getTupleValue(node2);
        }
        if (node2.isJsonObject()) {
            return Json.getRecordValue(node2);
        }
        if (node2.isJsonPrimitive()) {
            JsonPrimitive primitive = node2.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return IntValue.gen(primitive.getAsInt());
            }
            if (primitive.isBoolean()) {
                return new BoolValue(primitive.getAsBoolean());
            }
            if (primitive.isString()) {
                return new StringValue(primitive.getAsString());
            }
        } else if (node2.isJsonNull()) {
            return null;
        }
        throw new IOException("Cannot convert value: unsupported JSON value " + node2.toString());
    }

    private static TupleValue getTupleValue(JsonElement node2) throws IOException {
        ArrayList<Value> values = new ArrayList<Value>();
        JsonArray jsonArray = node2.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            values.add(Json.getValue(jsonArray.get(i)));
        }
        return new TupleValue(values.toArray(new Value[0]));
    }

    private static RecordValue getRecordValue(JsonElement node2) throws IOException {
        ArrayList<UniqueString> keys2 = new ArrayList<UniqueString>();
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry<String, JsonElement> entry : node2.getAsJsonObject().entrySet()) {
            keys2.add(UniqueString.uniqueStringOf(entry.getKey()));
            values.add(Json.getValue(entry.getValue()));
        }
        return new RecordValue(keys2.toArray(new UniqueString[0]), values.toArray(new Value[0]), false);
    }
}

