/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.BuiltInSymbols;
import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.Position;
import tla2tex.Token;
import tla2tex.TokenizeSpec;

public class FindAlignments {
    public static void FindAlignments(Token[][] spec2) {
        int item;
        FindAlignments.setSubscriptField(spec2);
        int line = 0;
        boolean inProlog = true;
        while (inProlog && line < spec2.length) {
            if (spec2[line].length > 0 && spec2[line][0].type != 8) {
                inProlog = false;
                continue;
            }
            ++line;
        }
        while (line < spec2.length) {
            boolean prevInfixInner = false;
            for (item = 0; item < spec2[line].length; ++item) {
                Position pos = new Position(line, item);
                Token token = spec2[line][item];
                if (!token.subscript) {
                    if (FindAlignments.isRightComment(spec2, pos)) {
                        Position bpos = FindAlignments.blockingPosition(spec2, pos);
                        Token btoken = null;
                        if (bpos.line != -1) {
                            btoken = bpos.toToken(spec2);
                        }
                        CommentToken ctok = (CommentToken)token;
                        if (ctok.subtype == 8 || ctok.subtype == 9) {
                            Debug.Assert(btoken != null && btoken.type == 5, "Bad blocking token for a MULTI or NULL token");
                            token.aboveAlign = ((CommentToken)btoken).subtype == 7 ? bpos : btoken.aboveAlign;
                            btoken.belowAlign = pos;
                        } else if (bpos.line != -1 && FindAlignments.isRightComment(spec2, bpos) && btoken.column == token.column && (btoken.aboveAlign.line == -1 && bpos.item > 0 || btoken.aboveAlign.line != -1 && btoken.aboveAlign.toToken((Token[][])spec2).belowAlign.line != -1)) {
                            btoken.belowAlign = pos;
                            token.aboveAlign = btoken.aboveAlign.line == -1 ? bpos : btoken.aboveAlign;
                        } else if (item == 0 || item == 1 && spec2[line][0].type == 5) {
                            pos.toToken((Token[][])spec2).aboveAlign = FindAlignments.coveringPosition(spec2, pos, true);
                        }
                        prevInfixInner = false;
                    }
                    if (prevInfixInner) {
                        Debug.Assert(pos.item > 0, "prevInfixInner true for first item on line");
                        Position lPos = new Position(pos.line, pos.item - 1);
                        Debug.Assert(lPos.toToken((Token[][])spec2).aboveAlign.line != -1, "prevInfixInner true, but token to left not aligned");
                        Position alPos = lPos.toToken((Token[][])spec2).aboveAlign;
                        Token alToken = alPos.toToken(spec2);
                        if (alPos.item + 1 < spec2[alPos.line].length) {
                            Position aPos = new Position(alPos.line, alPos.item + 1);
                            Token atoken = aPos.toToken(spec2);
                            Position cPos = FindAlignments.coveringPosition(spec2, pos, true);
                            if (cPos.line == aPos.line && cPos.item == aPos.item && token.column == atoken.column && atoken.type != 5) {
                                token.aboveAlign = aPos;
                            }
                        }
                        prevInfixInner = false;
                        continue;
                    }
                    if (item == 0 && token.type != 5 || item == 1 && spec2[line][0].type == 5) {
                        token.aboveAlign = FindAlignments.coveringPosition(spec2, pos, true);
                        continue;
                    }
                    if (FindAlignments.isLeftComment(spec2, pos)) {
                        token.aboveAlign = FindAlignments.coveringPosition(spec2, pos, false);
                        continue;
                    }
                    Position cpos = FindAlignments.coveringPosition(spec2, pos, true);
                    Token ctoken = null;
                    if (cpos.line != -1) {
                        ctoken = cpos.toToken(spec2);
                    }
                    int alignClass = 0;
                    int calignClass = 0;
                    if (token.type == 1) {
                        alignClass = BuiltInSymbols.GetBuiltInSymbol((String)token.string, (boolean)true).alignmentType;
                    }
                    if (ctoken != null && ctoken.type == 1) {
                        calignClass = BuiltInSymbols.GetBuiltInSymbol((String)ctoken.string, (boolean)true).alignmentType;
                    }
                    if (ctoken != null && token.column == ctoken.column && alignClass != 0 && alignClass == calignClass) {
                        ctoken.belowAlign = pos;
                        token.aboveAlign = ctoken.aboveAlign.line == -1 ? cpos : ctoken.aboveAlign;
                        prevInfixInner = true;
                        continue;
                    }
                    if (item != 1 && (item != 2 || spec2[line][0].type != 5) || spec2[line][item - 1].type != 1 || BuiltInSymbols.GetBuiltInSymbol((String)spec2[line][item - 1].string, (boolean)true).symbolType != 1 || ctoken == null || token.column != ctoken.column || spec2[line][item - 1].aboveAlign.line == -1) continue;
                    Token lTok = spec2[line][item - 1];
                    Position alPos = lTok.aboveAlign;
                    Token alTok = alPos.toToken(spec2);
                    if (alPos.line == cpos.line && alPos.item == cpos.item - 1) {
                        token.aboveAlign = cpos;
                        continue;
                    }
                    if (cpos.item != 0 && (cpos.item != 1 || spec2[cpos.line][0].type != 5)) continue;
                    token.aboveAlign = cpos;
                    ctoken.belowAlign = pos;
                    continue;
                }
                prevInfixInner = false;
            }
            if (++line >= spec2.length || spec2[line].length <= 0 || spec2[line][0].type != 9) continue;
            line = spec2.length;
        }
        FindAlignments.FindLabelAlignments(spec2);
        for (line = 0; line < spec2.length; ++line) {
            for (item = 0; item < spec2[line].length; ++item) {
                Token token = spec2[line][item];
                if (token.aboveAlign.line != -1) {
                    if (item > 0) {
                        token.isAlignmentPoint = true;
                    }
                    if (token.aboveAlign.item != 0) {
                        token.aboveAlign.toToken((Token[][])spec2).isAlignmentPoint = true;
                    }
                }
                if (token.belowAlign.line == -1) continue;
                if (item > 0) {
                    token.isAlignmentPoint = true;
                }
                if (token.belowAlign.line == 0) continue;
                token.belowAlign.toToken((Token[][])spec2).isAlignmentPoint = true;
            }
        }
    }

    public static void FindLabelAlignments(Token[][] spec2) {
        if (!TokenizeSpec.hasPcal) {
            return;
        }
        int pcalStartLine = TokenizeSpec.pcalStart.line + 1;
        int pcalEndLine = TokenizeSpec.pcalEnd.line;
        for (int curLabelLine = pcalStartLine; curLabelLine <= pcalEndLine && curLabelLine < spec2.length; ++curLabelLine) {
            if (spec2[curLabelLine].length <= 1 || spec2[curLabelLine][0].type != 13) continue;
            Token tok = spec2[curLabelLine][1];
            int alignCol = tok.column;
            int curLine = curLabelLine + 1;
            int alignLine = curLabelLine;
            int alignItem = 1;
            boolean notDone = true;
            while (notDone && curLine < spec2.length) {
                int curItem = 0;
                boolean shouldSkip = false;
                if (spec2[curLine].length != 0) {
                    if (spec2[curLine][0].type == 13) {
                        if (spec2[curLine].length > 1) {
                            curItem = 1;
                        } else {
                            notDone = spec2[curLine][0].column >= alignCol;
                            shouldSkip = true;
                        }
                    }
                    if (!shouldSkip) {
                        if (spec2[curLine][curItem].column < alignCol) {
                            notDone = false;
                        } else if (spec2[curLine][curItem].column == alignCol) {
                            spec2[alignLine][alignItem].belowAlign = new Position(curLine, curItem);
                            spec2[curLine][curItem].aboveAlign = new Position(alignLine, alignItem);
                            alignLine = curLine;
                            alignItem = curItem;
                        }
                    }
                }
                if (++curLine <= pcalEndLine && curLine < spec2.length) continue;
                notDone = false;
            }
            if (tok.aboveAlign.line != -1 && tok.aboveAlign.toToken((Token[][])spec2).belowAlign.equals(new Position(curLabelLine, 1))) continue;
            curLine = curLabelLine - 1;
            alignLine = curLabelLine;
            alignItem = 1;
            notDone = true;
            while (notDone) {
                if (spec2[curLine].length > 0 && spec2[curLine][0].column <= alignCol && (spec2[curLine][0].type != 13 || spec2[curLine].length > 1 && spec2[curLine][1].column <= alignCol)) {
                    if (spec2[curLine][0].column == alignCol) {
                        spec2[alignLine][alignItem].aboveAlign = new Position(curLine, 0);
                        spec2[curLine][0].belowAlign = new Position(alignLine, alignItem);
                        alignLine = curLine;
                        alignItem = 0;
                    } else if (spec2[alignLine][alignItem].aboveAlign.line == -1) {
                        int item;
                        for (item = 0; item < spec2[curLine].length && spec2[curLine][item].column <= alignCol; ++item) {
                        }
                        Token altok = null;
                        if (--item > 0) {
                            altok = spec2[curLine][item - 1];
                        }
                        if (altok != null && (altok.type == 13 || altok.type == 1 && BuiltInSymbols.IsBuiltInSymbol(altok.string, true) && !BuiltInSymbols.IsBuiltInSymbol(altok.string, false))) {
                            spec2[alignLine][alignItem].aboveAlign = new Position(curLine, item);
                            if (spec2[curLine][item].column == alignCol) {
                                spec2[curLine][item].belowAlign = new Position(alignLine, alignItem);
                            }
                        }
                        notDone = false;
                    } else {
                        notDone = false;
                    }
                }
                if (--curLine >= pcalStartLine) continue;
                notDone = false;
            }
        }
    }

    private static boolean isLeftComment(Token[][] spec2, Position p) {
        return p.item == 0 && spec2[p.line][p.item].type == 5 && spec2[p.line].length > 1;
    }

    private static boolean isRightComment(Token[][] spec2, Position p) {
        return p.item == spec2[p.line].length - 1 && spec2[p.line][p.item].type == 5;
    }

    private static Position coveringPosition(Token[][] spec2, Position p, boolean ignore) {
        int item;
        int line = p.line - 1;
        Token tok = p.toToken(spec2);
        boolean notDone = true;
        while (line >= 0 && notDone) {
            if (spec2[line].length > 0) {
                if (spec2[line][0].type == 8) {
                    line = -1;
                    notDone = false;
                } else {
                    item = 0;
                    if (ignore && FindAlignments.isLeftComment(spec2, new Position(line, 0))) {
                        item = 1;
                    }
                    if (spec2[line][item].column <= tok.column) {
                        notDone = false;
                    }
                }
            }
            if (!notDone) continue;
            --line;
        }
        if (line == -1) {
            return new Position(-1, 0);
        }
        item = 0;
        int nsItem = 0;
        boolean dashFound = false;
        if (spec2[line][0].type == 6) {
            dashFound = true;
        }
        while (!dashFound && item + 1 < spec2[line].length && spec2[line][item + 1].column <= tok.column) {
            if (spec2[line][item + 1].type == 6) {
                dashFound = true;
            }
            if (spec2[line][++item].subscript) continue;
            nsItem = item;
        }
        if (dashFound) {
            return new Position(-1, 0);
        }
        return new Position(line, nsItem);
    }

    private static Position blockingPosition(Token[][] spec2, Position p) {
        int line = p.line - 1;
        int item = 0;
        Token tok = p.toToken(spec2);
        boolean notDone = true;
        while (line >= 0 && notDone) {
            if (spec2[line].length > 0) {
                if (spec2[line][0].type == 8) {
                    line = -1;
                    notDone = false;
                } else {
                    item = 0;
                    if (FindAlignments.isLeftComment(spec2, new Position(line, 0))) {
                        item = 1;
                    }
                    while (notDone && item < spec2[line].length) {
                        if (spec2[line][item].column >= tok.column && !spec2[line][item].subscript) {
                            notDone = false;
                            continue;
                        }
                        ++item;
                    }
                }
            }
            if (!notDone) continue;
            --line;
        }
        if (line == -1) {
            return new Position(-1, 0);
        }
        return new Position(line, item);
    }

    private static void setSubscriptField(Token[][] spec2) {
        for (int line = 0; line < spec2.length; ++line) {
            int startSub = -1;
            int nestingDepth = 0;
            for (int item = 0; item < spec2[line].length; ++item) {
                Token tok = spec2[line][item];
                if (startSub == -1) {
                    if (tok.type != 1 || BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType != 6 && !tok.string.equals("^")) continue;
                    startSub = item + 1;
                    continue;
                }
                int symType = 10;
                if (tok.type == 1) {
                    symType = BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType;
                }
                if (nestingDepth == 0 && symType != 4 || nestingDepth == 1 && symType == 5) {
                    nestingDepth = 0;
                    while (startSub <= item) {
                        spec2[line][startSub].subscript = true;
                        ++startSub;
                    }
                    startSub = -1;
                    continue;
                }
                if (symType == 4) {
                    ++nestingDepth;
                    continue;
                }
                if (symType != 5) continue;
                --nestingDepth;
            }
        }
    }
}

