/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import tla2tex.CharReader;
import tla2tex.Debug;

public class FileCharReader
extends CharReader {
    private BufferedReader bufferedReader;

    public FileCharReader(String fileName) {
        try {
            this.bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e2) {
            Debug.ReportError("Input file " + fileName + " not found.");
        }
    }

    @Override
    public String innerGetNextLine() {
        try {
            return this.bufferedReader.readLine();
        }
        catch (IOException e2) {
            Debug.ReportError("Error reading file: " + e2.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.bufferedReader.close();
        }
        catch (IOException e2) {
            Debug.ReportError("Error trying to close file: " + e2.getMessage());
        }
    }
}

