/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.AnyDefNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefOrLabelNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.TheoremNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import util.UniqueString;
import util.WrongInvocationException;

public class ThmOrAssumpDefNode
extends SymbolNode
implements OpDefOrLabelNode,
AnyDefNode {
    protected LevelNode thmOrAssump = null;
    private LevelNode body = null;
    private ModuleNode originallyDefinedInModule = null;
    private boolean theorem = true;
    private boolean suffices = false;
    private Hashtable<UniqueString, LabelNode> labels = null;
    public int arity = 0;
    private FormalParamNode[] params = new FormalParamNode[0];
    ProofNode proof;
    private ModuleNode instantiatedFrom = null;
    private ThmOrAssumpDefNode source = null;
    private boolean local = false;
    int[] maxLevels;
    int[] weights;
    int[][] minMaxLevel;
    boolean[] isLeibnizArg;
    boolean isLeibniz;
    private boolean[][][] opLevelCond;

    public Hashtable<UniqueString, LabelNode> getLabelsHT() {
        return this.labels;
    }

    @Override
    public ThmOrAssumpDefNode getSource() {
        if (this.source == null) {
            return this;
        }
        return this.source;
    }

    public ThmOrAssumpDefNode(UniqueString name2, boolean thm, LevelNode exp, ModuleNode oModNode, SymbolTable st, TreeNode stn, FormalParamNode[] parms, ModuleNode iFrom, ThmOrAssumpDefNode src) {
        super(23, stn, name2);
        this.theorem = thm;
        this.body = exp;
        this.originallyDefinedInModule = oModNode;
        this.instantiatedFrom = iFrom;
        this.source = src;
        if (st != null) {
            st.addSymbol(name2, this);
        }
        if (parms != null) {
            this.params = parms;
            this.arity = parms.length;
        }
    }

    public ThmOrAssumpDefNode(UniqueString name2, TreeNode stn) {
        super(23, stn, name2);
    }

    public void construct(boolean thm, LevelNode exp, ModuleNode oModNode, SymbolTable st, FormalParamNode[] parms) {
        this.theorem = thm;
        this.body = exp;
        this.originallyDefinedInModule = oModNode;
        if (st != null) {
            st.addSymbol(this.name, this);
        }
        if (parms != null) {
            this.params = parms;
            this.arity = parms.length;
        }
    }

    public LevelNode getBody() {
        return this.body;
    }

    public ModuleNode getOriginallyDefinedInModuleNode() {
        return this.originallyDefinedInModule;
    }

    public ModuleNode getInstantiatedFrom() {
        return this.instantiatedFrom;
    }

    public boolean isTheorem() {
        return this.theorem;
    }

    public boolean isSuffices() {
        return this.suffices;
    }

    void setSuffices() {
        this.suffices = true;
    }

    public final ProofNode getProof() {
        return this.proof;
    }

    @Override
    public final FormalParamNode[] getParams() {
        return this.params;
    }

    public final boolean isExpr() {
        return this.body instanceof ExprNode;
    }

    @Override
    public final int getArity() {
        return this.arity;
    }

    @Override
    public final boolean isLocal() {
        return this.local;
    }

    public final void setLocal(boolean localness) {
        this.local = localness;
    }

    @Override
    public final boolean match(OpApplNode test2, ModuleNode mn) {
        SymbolNode odn = test2.getOperator();
        return odn.getArity() == 0;
    }

    @Override
    public void setLabels(Hashtable<UniqueString, LabelNode> ht) {
        this.labels = ht;
    }

    @Override
    public LabelNode getLabel(UniqueString us) {
        if (this.labels == null) {
            return null;
        }
        return this.labels.get(us);
    }

    @Override
    public boolean addLabel(LabelNode odn) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (this.labels.containsKey(odn.getName())) {
            return false;
        }
        this.labels.put(odn.getName(), odn);
        return true;
    }

    @Override
    public LabelNode[] getLabels() {
        if (this.labels == null) {
            return new LabelNode[0];
        }
        Vector<LabelNode> v = new Vector<LabelNode>();
        Enumeration<LabelNode> e2 = this.labels.elements();
        while (e2.hasMoreElements()) {
            v.addElement(e2.nextElement());
        }
        LabelNode[] retVal = new LabelNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retVal[i] = (LabelNode)v.elementAt(i);
        }
        return retVal;
    }

    @Override
    public boolean[] getIsLeibnizArg() {
        return this.isLeibnizArg;
    }

    @Override
    public boolean getIsLeibniz() {
        return this.isLeibniz;
    }

    @Override
    public final boolean levelCheck(int itr) {
        int i;
        int j;
        int i2;
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.maxLevels = new int[this.params.length];
        this.weights = new int[this.params.length];
        for (int i3 = 0; i3 < this.params.length; ++i3) {
            this.maxLevels[i3] = 3;
            this.weights[i3] = 0;
            this.isLeibniz = true;
            this.isLeibnizArg = new boolean[this.params.length];
            this.isLeibnizArg[i3] = true;
        }
        this.levelCorrect = this.body.levelCheck(itr);
        this.level = this.body.getLevel();
        SetOfLevelConstraints lcSet = this.body.getLevelConstraints();
        for (i2 = 0; i2 < this.params.length; ++i2) {
            Object plevel = lcSet.get(this.params[i2]);
            if (plevel == null) continue;
            this.maxLevels[i2] = (Integer)plevel;
        }
        for (i2 = 0; i2 < this.params.length; ++i2) {
            if (!this.body.getLevelParams().contains(this.params[i2])) continue;
            this.weights[i2] = this.weights[i2];
        }
        this.minMaxLevel = new int[this.params.length][];
        SetOfArgLevelConstraints alcSet = this.body.getArgLevelConstraints();
        for (int i4 = 0; i4 < this.params.length; ++i4) {
            int alen = this.params[i4].getArity();
            this.minMaxLevel[i4] = new int[alen];
            for (j = 0; j < alen; ++j) {
                Object alevel = alcSet.get(new ParamAndPosition(this.params[i4], j));
                this.minMaxLevel[i4][j] = alevel == null ? 0 : (Integer)alevel;
            }
        }
        this.opLevelCond = new boolean[this.params.length][this.params.length][];
        HashSet<ArgLevelParam> alpSet = this.body.getArgLevelParams();
        for (i = 0; i < this.params.length; ++i) {
            for (j = 0; j < this.params.length; ++j) {
                this.opLevelCond[i][j] = new boolean[this.params[i].getArity()];
                for (int k = 0; k < this.params[i].getArity(); ++k) {
                    ArgLevelParam alp = new ArgLevelParam(this.params[i], k, this.params[j]);
                    this.opLevelCond[i][j][k] = alpSet.contains(alp);
                }
            }
        }
        this.levelParams.addAll(this.body.getLevelParams());
        this.allParams.addAll(this.body.getAllParams());
        this.nonLeibnizParams.addAll(this.body.getNonLeibnizParams());
        for (i = 0; i < this.params.length; ++i) {
            this.levelParams.remove(this.params[i]);
            this.allParams.remove(this.params[i]);
            if (!this.nonLeibnizParams.contains(this.params[i])) continue;
            this.nonLeibnizParams.remove(this.params[i]);
            this.isLeibnizArg[i] = false;
            this.isLeibniz = false;
        }
        this.levelConstraints = (SetOfLevelConstraints)lcSet.clone();
        for (i = 0; i < this.params.length; ++i) {
            this.levelConstraints.remove(this.params[i]);
        }
        this.argLevelConstraints = (SetOfArgLevelConstraints)alcSet.clone();
        for (i = 0; i < this.params.length; ++i) {
            int alen = this.params[i].getArity();
            for (int j2 = 0; j2 < alen; ++j2) {
                this.argLevelConstraints.remove(new ParamAndPosition(this.params[i], j2));
            }
        }
        for (ArgLevelParam alp : alpSet) {
            if (alp.op.occur(this.params) && alp.param.occur(this.params)) continue;
            this.argLevelParams.add(alp);
        }
        return this.levelCorrect;
    }

    @Override
    public final int getMaxLevel(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMaxLevel called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.maxLevels[idx];
    }

    @Override
    public final int getWeight(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getWeight called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.weights[idx];
    }

    @Override
    public final int getMinMaxLevel(int i, int j) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMinMaxLevel called before levelCheck");
        }
        if (this.minMaxLevel == null) {
            return 0;
        }
        return this.minMaxLevel[i][j];
    }

    @Override
    public final boolean getOpLevelCond(int i, int j, int k) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getOpLevelCond called before levelCheck");
        }
        if (this.opLevelCond == null) {
            return false;
        }
        return this.opLevelCond[i][j][k];
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.body};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.body != null) {
            this.body.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*ThmOrAssumpDefNode: " + this.getName().toString() + "  " + super.toString(depth) + " arity: " + this.arity + " module: " + (this.originallyDefinedInModule != null ? this.originallyDefinedInModule.getName().toString() : "<null>");
        if (this.instantiatedFrom != null) {
            ret = ret + " instantiatedFrom: " + this.instantiatedFrom.getName();
        }
        if (this.params != null) {
            String tempString = "\nFormal params: " + this.params.length;
            for (int i = 0; i < this.params.length; ++i) {
                tempString = tempString + Strings.indent(2, this.params[i] != null ? this.params[i].toString(depth - 1) : "\nnull");
            }
            ret = ret + Strings.indent(2, tempString);
        }
        if (this.body != null) {
            ret = ret + Strings.indent(2, "\nisTheorem(): " + this.theorem + "\nBody:" + Strings.indent(2, this.body.toString(depth - 1)) + "\nsuffices: " + this.isSuffices());
        }
        if (this.labels != null) {
            ret = ret + "\n  Labels: ";
            Enumeration<UniqueString> list = this.labels.keys();
            while (list.hasMoreElements()) {
                ret = ret + list.nextElement().toString() + "  ";
            }
        } else {
            ret = ret + "\n  Labels: null";
        }
        return ret;
    }

    @Override
    protected String getNodeRef() {
        if (this.theorem) {
            assert (this.thmOrAssump instanceof TheoremNode);
            return "TheoremDefRef";
        }
        assert (this.thmOrAssump instanceof AssumeNode);
        return "AssumeDefRef";
    }

    @Override
    protected Element getSymbolElement(Document doc2, SymbolContext context) {
        assert (this.body != null);
        Element e2 = null;
        e2 = this.theorem ? doc2.createElement("TheoremDefNode") : doc2.createElement("AssumeDef");
        e2.appendChild(this.appendText(doc2, "uniquename", this.getName().toString()));
        e2.appendChild(this.body.export(doc2, context));
        return e2;
    }

    @Override
    public Element export(Document doc2, SymbolContext context) {
        context.put(this, doc2);
        Element e2 = doc2.createElement(this.getNodeRef());
        e2.appendChild(this.appendText(doc2, "UID", Integer.toString(this.myUID)));
        return e2;
    }
}

