/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ExprNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class StringNode
extends ExprNode
implements ExploreNode {
    private UniqueString value;

    public StringNode(TreeNode stn, boolean strip) {
        super(18, stn);
        this.value = stn.getUS();
        if (strip) {
            String str2 = this.value.toString();
            str2 = str2.substring(1, str2.length() - 1);
            this.value = UniqueString.uniqueStringOf(str2);
        }
    }

    public final UniqueString getRep() {
        return this.value;
    }

    @Override
    public final boolean levelCheck(int iter) {
        this.levelChecked = iter;
        return true;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    final String PrintVersion(String str2) {
        StringBuffer buf = new StringBuffer(str2.length());
        block8: for (int i = 0; i < str2.length(); ++i) {
            switch (str2.charAt(i)) {
                case '\"': {
                    buf.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block8;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block8;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block8;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block8;
                }
                default: {
                    buf.append(str2.charAt(i));
                }
            }
        }
        return buf.toString();
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        return "\n*StringNode: " + super.toString(depth) + "Value: '" + this.PrintVersion(this.value.toString()) + "' Length: " + this.value.length();
    }

    @Override
    protected Element getLevelElement(Document doc2, SymbolContext context) {
        Element e2 = doc2.createElement("StringValue");
        Text n = doc2.createTextNode(this.value.toString());
        e2.appendChild(n);
        return this.appendElement(doc2, "StringNode", e2);
    }
}

