/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.modanalyzer;

import java.io.PrintWriter;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.st.Location;
import tla2sany.st.ParseTree;
import tla2sany.st.TreeNode;

public class SyntaxTreePrinter {
    public static final void print(ParseTree pt, PrintWriter output) {
        output.println("%% Output of parse tree for module " + pt.moduleName());
        String[] dependencies = pt.dependencies();
        if (dependencies.length == 0) {
            output.println("%% no dependencies");
        } else {
            output.print("%% dependends on:");
            for (int lvi = 0; lvi < dependencies.length; ++lvi) {
                output.print(" " + dependencies[lvi]);
            }
            output.println(".");
        }
        SyntaxTreePrinter.printSubTree(output, "", pt.rootNode());
    }

    private static void printSubTree(PrintWriter o, String offset, TreeNode node2) {
        StringBuffer outS = new StringBuffer(offset);
        Location l = node2.getLocation();
        String image = node2.getImage();
        if (image != null) {
            outS.append(image);
        } else {
            outS.append("-- no name --");
        }
        outS.append(" [").append(l.beginLine()).append(" ").append(l.beginColumn()).append("] ");
        TreeNode[] h = node2.heirs();
        outS.append(" (kind: " + ((SyntaxTreeNode)node2).getKind() + ") ");
        if (h != null) {
            if (h.length == 0) {
                int length = node2.getPreComments().length;
                outS.append(length);
                outS.append(" pre-comments ");
            }
            outS.append(" {");
            o.println(outS);
            for (int i = 0; i < h.length; ++i) {
                SyntaxTreePrinter.printSubTree(o, offset + ".", h[i]);
            }
            o.print(offset);
            o.println("}");
        } else {
            outS.append(" ***WARNING***  null array reference ");
            o.println(outS);
        }
    }
}

