/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.modanalyzer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import tla2sany.modanalyzer.ModuleContext;
import tla2sany.modanalyzer.ModulePointer;
import tla2sany.modanalyzer.ModuleRelatives;
import tla2sany.modanalyzer.ParseUnitRelatives;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.modanalyzer.SyntaxTreePrinter;
import tla2sany.parser.TLAplusParser;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.st.Location;
import tla2sany.st.ParseTree;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Vector;
import util.FileUtil;
import util.FilenameToStream;
import util.MonolithSpecExtractor;
import util.NamedInputStream;
import util.TLAFlightRecorder;
import util.ToolIO;

public class ParseUnit {
    private SpecObj spec;
    private NamedInputStream nis = null;
    private ParseTree parseTree = null;
    private long parseStamp = 0L;
    private ModulePointer rootModule = null;
    private String rootModuleName;
    private ParseUnitRelatives parseUnitRelatives = new ParseUnitRelatives();

    public NamedInputStream getNis() {
        return this.nis;
    }

    public ParseUnit(SpecObj spec2, NamedInputStream source2) {
        this.spec = spec2;
        this.nis = source2;
        this.rootModuleName = source2 != null ? this.nis.getModuleName() : null;
    }

    public final String toString() {
        return "[ ParseUnit: " + this.rootModuleName + " ]";
    }

    public final boolean isLoaded() {
        return this.nis != null && this.nis.sourceFile().exists() && this.parseStamp > this.nis.sourceFile().lastModified();
    }

    public boolean isLibraryModule() {
        if (this.nis == null || !(this.nis.sourceFile() instanceof FilenameToStream.TLAFile)) {
            return false;
        }
        return ((FilenameToStream.TLAFile)this.nis.sourceFile()).isLibraryModule();
    }

    public final String getName() {
        return this.rootModuleName;
    }

    public final SpecObj getSpec() {
        return this.spec;
    }

    public final String getFileName() {
        return this.nis != null ? this.nis.getFileName() : null;
    }

    public final TreeNode getParseTree() {
        return this.parseTree != null ? this.parseTree.rootNode() : null;
    }

    public final ModulePointer getRootModule() {
        return this.rootModule;
    }

    final Vector getExtendees() {
        return this.parseUnitRelatives.extendees;
    }

    final Vector getExtendedBy() {
        return this.parseUnitRelatives.extendedBy;
    }

    final Vector getInstancees() {
        return this.parseUnitRelatives.instancees;
    }

    final Vector getInstancedBy() {
        return this.parseUnitRelatives.instancedBy;
    }

    final void addExtendee(ParseUnit pu) {
        this.parseUnitRelatives.extendees.addElement(pu);
    }

    final void addExtendedBy(ParseUnit pu) {
        this.parseUnitRelatives.extendedBy.addElement(pu);
    }

    final void addInstancee(ParseUnit pu) {
        this.parseUnitRelatives.instancees.addElement(pu);
    }

    final void addInstancedBy(ParseUnit pu) {
        this.parseUnitRelatives.instancedBy.addElement(pu);
    }

    final ModuleRelatives getRelatives(ModulePointer module) {
        return module.getRelatives();
    }

    final ParseUnitRelatives getRelatives() {
        return this.parseUnitRelatives;
    }

    final ModuleContext getContext(ModuleRelatives relatives) {
        return relatives.context;
    }

    final ModuleContext getContext(ModulePointer module) {
        return module.getRelatives().context;
    }

    final ModulePointer getParent(ModulePointer module) {
        return module.getRelatives().outerModule;
    }

    final Vector getPeers(ModulePointer module) {
        if (module.getRelatives().outerModule != null) {
            return module.getRelatives().outerModule.getRelatives().directInnerModules;
        }
        return null;
    }

    private final void writeParseTreeToFile(boolean file2, Errors errors) throws AbortException {
        if (file2) {
            String sinkName = this.nis.getModuleName() + ".jcg";
            File compiled = this.spec.getResolver().resolve(sinkName, false);
            if (compiled.exists()) {
                compiled.delete();
            }
            PrintWriter pw = new PrintWriter(FileUtil.newFOS(compiled));
            SyntaxTreePrinter.print(this.parseTree, pw);
            pw.flush();
            pw.close();
        } else {
            PrintWriter pw = new PrintWriter(ToolIO.out);
            SyntaxTreePrinter.print(this.parseTree, pw);
            pw.flush();
        }
    }

    private final void verifyEquivalenceOfFileAndModuleNames(Errors errors) throws AbortException {
        String fName = this.getFileName();
        fName = fName.substring(fName.lastIndexOf(System.getProperty("file.separator")) + 1);
        fName = fName.substring(0, fName.lastIndexOf("."));
        String mName = this.getParseTree().heirs()[0].heirs()[1].getImage();
        if (!mName.equals(fName)) {
            errors.addAbort("File name '" + fName + "' does not match the name '" + mName + "' of the top level module it contains.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseFile(Errors errors, boolean firstCall, String name2, ParseUnit rootParseUnit) throws AbortException {
        boolean parseSuccess;
        Path absoluteResolvedPath;
        if (this.parseStamp > this.nis.sourceFile().lastModified()) {
            return;
        }
        if (!this.nis.sourceFile().exists()) {
            errors.addAbort("Error: source file '" + this.nis.getName() + "' has apparently been deleted.");
        }
        try {
            absoluteResolvedPath = this.nis.getAbsoluteResolvedPath();
        }
        catch (IOException e1) {
            absoluteResolvedPath = this.nis.sourceFile().toPath();
        }
        if (ToolIO.getMode() == 0) {
            File rootSourceFile;
            String originalFilePath = "";
            if (this.nis.sourceFile() instanceof FilenameToStream.TLAFile && ((FilenameToStream.TLAFile)this.nis.sourceFile()).hasLibraryPath()) {
                URI libraryPath = ((FilenameToStream.TLAFile)this.nis.sourceFile()).getLibraryPath();
                if (!absoluteResolvedPath.toUri().getPath().equals(libraryPath.getPath())) {
                    originalFilePath = " (" + libraryPath + ")";
                }
            } else if (rootParseUnit != null && rootParseUnit.getNis() != null && (rootSourceFile = rootParseUnit.getNis().sourceFile()) != null) {
                try {
                    MonolithSpecExtractor.module(rootSourceFile, name2);
                    originalFilePath = " (" + rootSourceFile.getAbsolutePath() + ")";
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            ToolIO.out.println(TLAFlightRecorder.message(String.format("%s %s%s", "Parsing file", absoluteResolvedPath, originalFilePath)));
        } else {
            ToolIO.out.println(TLAFlightRecorder.message(String.format("Parsing module %s in file %s", this.nis.getModuleName(), absoluteResolvedPath)));
        }
        try {
            this.parseTree = new TLAplusParser(this.nis);
            parseSuccess = this.parseTree.parse();
            this.parseStamp = System.currentTimeMillis();
        }
        finally {
            try {
                this.nis.close();
            }
            catch (IOException iOException) {}
        }
        if (!parseSuccess) {
            errors.addAbort(Location.moduleLocation(this.nis.getModuleName()), "Could not parse module " + this.nis.getModuleName() + " from file " + this.nis.getName(), true);
        }
        if (firstCall) {
            this.spec.setName(this.getParseTree().heirs()[0].heirs()[1].getImage());
        }
        this.rootModule = new ModulePointer(this.spec, this, this.getParseTree());
        this.determineModuleRelationships(this.rootModule, null);
        this.verifyEquivalenceOfFileAndModuleNames(errors);
        if (System.getProperty("TLA-Print", "off").equals("file")) {
            this.writeParseTreeToFile(true, errors);
        } else if (System.getProperty("TLA-Print", "off").equals("on")) {
            this.writeParseTreeToFile(false, errors);
        }
    }

    private void handleExtensions(ModulePointer currentModule, ModulePointer otherModule) {
        if (otherModule == null) {
            return;
        }
        ModuleContext currentContext = this.getContext(currentModule);
        Vector extendeeNames = otherModule.getNamesOfModulesExtended();
        for (int i = 0; i < extendeeNames.size(); ++i) {
            String extendeeName = (String)extendeeNames.elementAt(i);
            ModulePointer extendeeResolvant = currentContext.resolve(extendeeName);
            if (extendeeResolvant == null) continue;
            Vector directInnerModules = extendeeResolvant.getDirectInnerModules();
            for (int j = 0; j < directInnerModules.size(); ++j) {
                ModulePointer upperInnerMod = (ModulePointer)directInnerModules.elementAt(j);
                currentContext.bindIfNotBound(upperInnerMod.getName(), upperInnerMod);
                this.handleExtensions(currentModule, extendeeResolvant);
            }
        }
    }

    private void calculateContextWithinParseUnit(ModulePointer currentModule) {
        ModuleContext currentContext = this.getContext(currentModule);
        if (this.getParent(currentModule) != null) {
            currentContext.union(this.getParent(currentModule).getContext());
        }
        ModulePointer ancestorModule = currentModule;
        while (this.getParent(ancestorModule) != null) {
            currentContext.union(this.getParent(ancestorModule).getContext());
            Vector peers = this.getPeers(ancestorModule);
            for (int i = 0; i < peers.size() - 1; ++i) {
                ModulePointer nextPeer = (ModulePointer)peers.elementAt(i);
                currentContext.bindIfNotBound(nextPeer.getName(), nextPeer);
            }
            ancestorModule = this.getParent(ancestorModule);
        }
        this.handleExtensions(currentModule, currentModule);
    }

    void determineModuleRelationships(ModulePointer currentModule, ModulePointer parent) {
        ModuleRelatives currentRelatives = new ModuleRelatives(this, currentModule);
        currentModule.putRelatives(currentRelatives);
        currentRelatives.outerModule = parent;
        TreeNode extendNode = currentModule.getExtendsDecl();
        for (int i = 1; i < extendNode.heirs().length; i += 2) {
            String extendedModuleName = extendNode.heirs()[i].getImage();
            currentRelatives.directlyExtendedModuleNames.addElement(extendedModuleName);
        }
        this.calculateContextWithinParseUnit(currentModule);
        TreeNode body = currentModule.getBody();
        for (int i = 0; i < body.heirs().length; ++i) {
            TreeNode def2 = body.heirs()[i];
            if (def2.getImage().equals("N_Module")) {
                ModulePointer innerModule = new ModulePointer(this.spec, this, def2);
                currentRelatives.directInnerModules.addElement(innerModule);
                this.determineModuleRelationships(innerModule, currentModule);
                continue;
            }
            this.getInstances(def2, currentRelatives);
        }
    }

    private void getInstanceInLet(TreeNode treeNode, ModuleRelatives currentRelatives) {
        TreeNode[] children2 = treeNode.heirs();
        if (treeNode.getImage().equals("N_LetIn")) {
            TreeNode[] syntaxTreeNode = children2[1].heirs();
            for (int i = 0; i < syntaxTreeNode.length; ++i) {
                TreeNode def2 = syntaxTreeNode[i];
                if (def2.getImage().equals("N_ModuleDefinition")) {
                    TreeNode[] instanceHeirs = def2.heirs();
                    int nonLocalInstanceNodeIX = 2;
                    String instanceModuleName = instanceHeirs[nonLocalInstanceNodeIX].heirs()[1].getImage();
                    currentRelatives.directlyInstantiatedModuleNames.addElement(instanceModuleName);
                    continue;
                }
                TreeNode[] defChildren = def2.heirs();
                for (int j = 0; j < defChildren.length; ++j) {
                    this.getInstanceInLet(defChildren[j], currentRelatives);
                }
            }
        } else {
            for (int i = 0; i < children2.length; ++i) {
                this.getInstanceInLet(children2[i], currentRelatives);
            }
        }
    }

    private void getInstances(TreeNode treeNode, ModuleRelatives currentRelatives) {
        TreeNode[] children2 = treeNode.heirs();
        int i = 0;
        if (treeNode.getImage().equals("N_NonLocalInstance")) {
            currentRelatives.directlyInstantiatedModuleNames.addElement(children2[1].getImage());
            i = 2;
        }
        for (int j = i; j < children2.length; ++j) {
            this.getInstances(children2[j], currentRelatives);
        }
    }
}

