/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.terminal.impl.ExecPty;
import org.jline.terminal.impl.ExternalTerminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.spi.JansiSupport;
import org.jline.terminal.spi.JnaSupport;
import org.jline.terminal.spi.Pty;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;

public final class TerminalBuilder {
    public static final String PROP_ENCODING = "org.jline.terminal.encoding";
    public static final String PROP_CODEPAGE = "org.jline.terminal.codepage";
    public static final String PROP_TYPE = "org.jline.terminal.type";
    public static final String PROP_JNA = "org.jline.terminal.jna";
    public static final String PROP_JANSI = "org.jline.terminal.jansi";
    public static final String PROP_EXEC = "org.jline.terminal.exec";
    public static final String PROP_DUMB = "org.jline.terminal.dumb";
    public static final String PROP_DUMB_COLOR = "org.jline.terminal.dumb.color";
    public static final String PROP_NON_BLOCKING_READS = "org.jline.terminal.pty.nonBlockingReads";
    public static final String PROP_COLOR_DISTANCE = "org.jline.utils.colorDistance";
    public static final String PROP_DISABLE_ALTERNATE_CHARSET = "org.jline.utils.disableAlternateCharset";
    private static final AtomicReference<Terminal> SYSTEM_TERMINAL = new AtomicReference();
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private Charset encoding;
    private int codepage;
    private Boolean system;
    private Boolean jna;
    private Boolean jansi;
    private Boolean exec;
    private Boolean dumb;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;
    private boolean paused = false;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public TerminalBuilder name(String name2) {
        this.name = name2;
        return this;
    }

    public TerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    public TerminalBuilder system(boolean system) {
        this.system = system;
        return this;
    }

    public TerminalBuilder jna(boolean jna) {
        this.jna = jna;
        return this;
    }

    public TerminalBuilder jansi(boolean jansi) {
        this.jansi = jansi;
        return this;
    }

    public TerminalBuilder exec(boolean exec) {
        this.exec = exec;
        return this;
    }

    public TerminalBuilder dumb(boolean dumb) {
        this.dumb = dumb;
        return this;
    }

    public TerminalBuilder type(String type2) {
        this.type = type2;
        return this;
    }

    public TerminalBuilder encoding(String encoding2) throws UnsupportedCharsetException {
        return this.encoding(encoding2 != null ? Charset.forName(encoding2) : null);
    }

    public TerminalBuilder encoding(Charset encoding2) {
        this.encoding = encoding2;
        return this;
    }

    @Deprecated
    public TerminalBuilder codepage(int codepage) {
        this.codepage = codepage;
        return this;
    }

    public TerminalBuilder attributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public TerminalBuilder size(Size size) {
        this.size = size;
        return this;
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        this.nativeSignals = nativeSignals;
        return this;
    }

    public TerminalBuilder signalHandler(Terminal.SignalHandler signalHandler) {
        this.signalHandler = signalHandler;
        return this;
    }

    public TerminalBuilder paused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public Terminal build() throws IOException {
        Terminal terminal = this.doBuild();
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        Boolean dumb;
        Boolean exec;
        Boolean jansi;
        Boolean jna;
        String type2;
        String str2;
        int codepage;
        String charsetName;
        Charset encoding2;
        String name2 = this.name;
        if (name2 == null) {
            name2 = "JLine terminal";
        }
        if ((encoding2 = this.encoding) == null && (charsetName = System.getProperty(PROP_ENCODING)) != null && Charset.isSupported(charsetName)) {
            encoding2 = Charset.forName(charsetName);
        }
        if ((codepage = this.codepage) <= 0 && (str2 = System.getProperty(PROP_CODEPAGE)) != null) {
            codepage = Integer.parseInt(str2);
        }
        if ((type2 = this.type) == null) {
            type2 = System.getProperty(PROP_TYPE);
        }
        if (type2 == null) {
            type2 = System.getenv("TERM");
        }
        if ((jna = this.jna) == null) {
            jna = TerminalBuilder.getBoolean(PROP_JNA, true);
        }
        if ((jansi = this.jansi) == null) {
            jansi = TerminalBuilder.getBoolean(PROP_JANSI, true);
        }
        if ((exec = this.exec) == null) {
            exec = TerminalBuilder.getBoolean(PROP_EXEC, true);
        }
        if ((dumb = this.dumb) == null) {
            dumb = TerminalBuilder.getBoolean(PROP_DUMB, null);
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            if (this.attributes != null || this.size != null) {
                Log.warn("Attributes and size fields are ignored when creating a system terminal");
            }
            IllegalStateException exception = new IllegalStateException("Unable to create a system terminal");
            Terminal terminal = null;
            if (OSUtils.IS_WINDOWS) {
                boolean cygwinTerm = "cygwin".equals(System.getenv("TERM"));
                boolean ansiPassThrough = OSUtils.IS_CONEMU;
                if ((OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) && exec.booleanValue() && !cygwinTerm) {
                    try {
                        Pty pty = ExecPty.current();
                        if ("xterm".equals(type2) && this.type == null && System.getProperty(PROP_TYPE) == null) {
                            type2 = "xterm-256color";
                        }
                        terminal = new PosixSysTerminal(name2, type2, pty, encoding2, this.nativeSignals, this.signalHandler);
                    }
                    catch (IOException e2) {
                        Log.debug("Error creating EXEC based terminal: ", e2.getMessage(), e2);
                        exception.addSuppressed(e2);
                    }
                }
                if (terminal == null && jna.booleanValue()) {
                    try {
                        terminal = this.load(JnaSupport.class).winSysTerminal(name2, type2, ansiPassThrough, encoding2, codepage, this.nativeSignals, this.signalHandler, this.paused);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (terminal == null && jansi.booleanValue()) {
                    try {
                        terminal = this.load(JansiSupport.class).winSysTerminal(name2, type2, ansiPassThrough, encoding2, codepage, this.nativeSignals, this.signalHandler, this.paused);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (!(terminal != null || jna.booleanValue() || jansi.booleanValue() || dumb != null && dumb.booleanValue())) {
                    throw new IllegalStateException("Unable to create a system terminal. On windows, either JNA or JANSI library is required.  Make sure to add one of those in the classpath.");
                }
            } else {
                Pty pty;
                if (terminal == null && jna.booleanValue()) {
                    try {
                        pty = this.load(JnaSupport.class).current();
                        terminal = new PosixSysTerminal(name2, type2, pty, encoding2, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (terminal == null && jansi.booleanValue()) {
                    try {
                        pty = this.load(JansiSupport.class).current();
                        terminal = new PosixSysTerminal(name2, type2, pty, encoding2, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (terminal == null && exec.booleanValue()) {
                    try {
                        pty = ExecPty.current();
                        terminal = new PosixSysTerminal(name2, type2, pty, encoding2, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating EXEC based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
            }
            if (terminal instanceof AbstractTerminal) {
                final AbstractTerminal t = terminal;
                if (SYSTEM_TERMINAL.compareAndSet(null, t)) {
                    t.setOnClose(new Runnable(){

                        @Override
                        public void run() {
                            SYSTEM_TERMINAL.compareAndSet(t, null);
                        }
                    });
                } else {
                    exception.addSuppressed(new IllegalStateException("A system terminal is already running. Make sure to use the created system Terminal on the LineReaderBuilder if you're using one or that previously created system Terminals have been correctly closed."));
                    terminal.close();
                    terminal = null;
                }
            }
            if (terminal == null && (dumb == null || dumb.booleanValue())) {
                boolean color = TerminalBuilder.getBoolean(PROP_DUMB_COLOR, false);
                if (!color) {
                    boolean bl = color = System.getenv("INSIDE_EMACS") != null;
                }
                if (!color) {
                    String command = TerminalBuilder.getParentProcessCommand();
                    boolean bl = color = command != null && command.contains("idea");
                }
                if (!color && dumb == null) {
                    if (Log.isDebugEnabled()) {
                        Log.warn("Creating a dumb terminal", exception);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                }
                terminal = new DumbTerminal(name2, color ? "dumb-color" : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), encoding2, this.signalHandler);
            }
            if (terminal == null) {
                throw exception;
            }
            return terminal;
        }
        if (jna.booleanValue()) {
            try {
                Pty pty = this.load(JnaSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name2, type2, pty, this.in, this.out, encoding2, this.signalHandler, this.paused);
            }
            catch (Throwable t) {
                Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
            }
        }
        if (jansi.booleanValue()) {
            try {
                Pty pty = this.load(JansiSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name2, type2, pty, this.in, this.out, encoding2, this.signalHandler, this.paused);
            }
            catch (Throwable t) {
                Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
            }
        }
        return new ExternalTerminal(name2, type2, this.in, this.out, encoding2, this.signalHandler, this.paused, this.attributes, this.size);
    }

    private static String getParentProcessCommand() {
        try {
            Class<?> phClass = Class.forName("java.lang.ProcessHandle");
            Object current = phClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object parent = ((Optional)phClass.getMethod("parent", new Class[0]).invoke(current, new Object[0])).orElse(null);
            Method infoMethod = phClass.getMethod("info", new Class[0]);
            Object info = infoMethod.invoke(parent, new Object[0]);
            Object command = ((Optional)infoMethod.getReturnType().getMethod("command", new Class[0]).invoke(info, new Object[0])).orElse(null);
            return command;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Boolean getBoolean(String name2, Boolean def2) {
        try {
            String str2 = System.getProperty(name2);
            if (str2 != null) {
                return Boolean.parseBoolean(str2);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return def2;
    }

    private <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }
}

