/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.messages;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class Either<L, R> {
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> forLeft(@NonNull L left2) {
        return new Either<L, Object>(left2, null);
    }

    public static <L, R> Either<L, R> forRight(@NonNull R right2) {
        return new Either<Object, R>(null, right2);
    }

    protected Either(L left2, R right2) {
        this.left = left2;
        this.right = right2;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public Object get() {
        if (this.left != null) {
            return this.left;
        }
        if (this.right != null) {
            return this.right;
        }
        return null;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Either) {
            Either other = (Either)obj;
            return this.left == other.left && this.right == other.right || this.left != null && other.left != null && this.left.equals(other.left) || this.right != null && other.right != null && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        if (this.left != null) {
            return this.left.hashCode();
        }
        if (this.right != null) {
            return this.right.hashCode();
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Either [").append(System.lineSeparator());
        builder.append("  left = ").append(this.left).append(System.lineSeparator());
        builder.append("  right = ").append(this.right).append(System.lineSeparator());
        return builder.append("]").toString();
    }

    @Deprecated
    public static Type getLeftDisjointType(Type type2) {
        if (Either.isEither(type2)) {
            if (type2 instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type2;
                return parameterizedType.getActualTypeArguments()[0];
            }
            if (type2 instanceof Class) {
                Class cls = (Class)type2;
                return cls.getTypeParameters()[0];
            }
        }
        return null;
    }

    @Deprecated
    public static Type getRightDisjointType(Type type2) {
        if (Either.isEither(type2)) {
            if (type2 instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type2;
                return parameterizedType.getActualTypeArguments()[1];
            }
            if (type2 instanceof Class) {
                Class cls = (Class)type2;
                return cls.getTypeParameters()[1];
            }
        }
        return null;
    }

    @Deprecated
    public static Collection<Type> getAllDisjoinTypes(Type type2) {
        return Either.collectDisjoinTypes(type2, new ArrayList<Type>());
    }

    @Deprecated
    protected static Collection<Type> collectDisjoinTypes(Type type2, Collection<Type> types) {
        if (Either.isEither(type2)) {
            if (type2 instanceof ParameterizedType) {
                return Either.collectDisjoinTypes((ParameterizedType)type2, types);
            }
            if (type2 instanceof Class) {
                return Either.collectDisjoinTypes((Class)type2, types);
            }
        }
        types.add(type2);
        return types;
    }

    @Deprecated
    protected static Collection<Type> collectDisjoinTypes(ParameterizedType type2, Collection<Type> types) {
        for (Type typeArgument : type2.getActualTypeArguments()) {
            Either.collectDisjoinTypes(typeArgument, types);
        }
        return types;
    }

    @Deprecated
    protected static Collection<Type> collectDisjoinTypes(Class<?> type2, Collection<Type> types) {
        for (TypeVariable<Class<?>> typeParameter : type2.getTypeParameters()) {
            Either.collectDisjoinTypes(typeParameter, types);
        }
        return types;
    }

    @Deprecated
    public static boolean isEither(Type type2) {
        if (type2 instanceof ParameterizedType) {
            return Either.isEither((ParameterizedType)type2);
        }
        if (type2 instanceof Class) {
            return Either.isEither((Class)type2);
        }
        return false;
    }

    @Deprecated
    public static boolean isEither(ParameterizedType type2) {
        return Either.isEither(type2.getRawType());
    }

    @Deprecated
    public static boolean isEither(Class<?> cls) {
        return Either.class.isAssignableFrom(cls);
    }
}

