/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.MessageTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.ThrowableTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.TupleTypeAdapters;
import org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.MessageIssue;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class MessageJsonHandler {
    public static final JsonRpcMethod CANCEL_METHOD = JsonRpcMethod.notification("$/cancelRequest", new Type[]{CancelParams.class});
    private final Gson gson;
    private final Map<String, JsonRpcMethod> supportedMethods;
    private MethodProvider methodProvider;
    private static MessageJsonHandler toStringInstance;

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods) {
        this.supportedMethods = supportedMethods;
        this.gson = this.getDefaultGsonBuilder().create();
    }

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods, Consumer<GsonBuilder> configureGson) {
        this.supportedMethods = supportedMethods;
        GsonBuilder gsonBuilder = this.getDefaultGsonBuilder();
        configureGson.accept(gsonBuilder);
        this.gson = gsonBuilder.create();
    }

    public GsonBuilder getDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory(new ThrowableTypeAdapter.Factory()).registerTypeAdapterFactory(new EitherTypeAdapter.Factory()).registerTypeAdapterFactory(new TupleTypeAdapters.TwoTypeAdapterFactory()).registerTypeAdapterFactory(new EnumTypeAdapter.Factory()).registerTypeAdapterFactory(new MessageTypeAdapter.Factory(this));
    }

    public Gson getGson() {
        return this.gson;
    }

    public JsonRpcMethod getJsonRpcMethod(String name2) {
        JsonRpcMethod result = this.supportedMethods.get(name2);
        if (result != null) {
            return result;
        }
        if (CANCEL_METHOD.getMethodName().equals(name2)) {
            return CANCEL_METHOD;
        }
        return null;
    }

    public MethodProvider getMethodProvider() {
        return this.methodProvider;
    }

    public void setMethodProvider(MethodProvider methodProvider) {
        this.methodProvider = methodProvider;
    }

    public Message parseMessage(CharSequence input) throws JsonParseException {
        StringReader reader2 = new StringReader(input.toString());
        return this.parseMessage(reader2);
    }

    public Message parseMessage(Reader input) throws JsonParseException {
        JsonReader jsonReader = new JsonReader(input);
        Message message = (Message)this.gson.fromJson(jsonReader, (Type)((Object)Message.class));
        if (message != null) {
            try {
                if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                    MessageIssue issue = new MessageIssue("JSON document was not fully consumed.", ResponseErrorCode.ParseError.getValue());
                    throw new MessageIssueException(message, issue);
                }
            }
            catch (MalformedJsonException e2) {
                MessageIssue issue = new MessageIssue("Message could not be parsed.", ResponseErrorCode.ParseError.getValue(), e2);
                throw new MessageIssueException(message, issue);
            }
            catch (IOException e3) {
                throw new JsonIOException(e3);
            }
        }
        return message;
    }

    public String serialize(Message message) {
        StringWriter writer2 = new StringWriter();
        this.serialize(message, writer2);
        return writer2.toString();
    }

    public void serialize(Message message, Writer output) throws JsonIOException {
        this.gson.toJson((Object)message, (Type)((Object)Message.class), output);
    }

    public static String toString(Object object) {
        if (toStringInstance == null) {
            toStringInstance = new MessageJsonHandler(Collections.emptyMap(), gsonBuilder -> gsonBuilder.setPrettyPrinting());
        }
        return MessageJsonHandler.toStringInstance.gson.toJson(object);
    }
}

