/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import com.google.gson.TypeAdapterFactory;
import java.lang.reflect.Type;

public class JsonRpcMethod {
    private final String methodName;
    private final Type[] parameterTypes;
    private final Type returnType;
    private final TypeAdapterFactory returnTypeAdapterFactory;
    private final boolean isNotification;

    private JsonRpcMethod(String methodName, Type[] parameterTypes, Type returnType, TypeAdapterFactory returnTypeAdapterFactory, boolean isNotification) {
        if (methodName == null) {
            throw new NullPointerException("methodName");
        }
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.returnTypeAdapterFactory = returnTypeAdapterFactory;
        this.isNotification = isNotification;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public TypeAdapterFactory getReturnTypeAdapterFactory() {
        return this.returnTypeAdapterFactory;
    }

    public boolean isNotification() {
        return this.isNotification;
    }

    public static JsonRpcMethod notification(String name2, Type ... parameterTypes) {
        return new JsonRpcMethod(name2, parameterTypes, (Type)((Object)Void.class), null, true);
    }

    public static JsonRpcMethod request(String name2, Type returnType, Type ... parameterTypes) {
        return new JsonRpcMethod(name2, parameterTypes, returnType, null, false);
    }

    public static JsonRpcMethod request(String name2, Type returnType, TypeAdapterFactory returnTypeAdapterFactory, Type ... parameterTypes) {
        return new JsonRpcMethod(name2, parameterTypes, returnType, returnTypeAdapterFactory, false);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isNotification) {
            builder.append("JsonRpcMethod (notification) {\n");
        } else {
            builder.append("JsonRpcMethod (request) {\n");
        }
        builder.append("\tmethodName: ").append(this.methodName).append('\n');
        if (this.parameterTypes != null) {
            builder.append("\tparameterTypes: ").append(this.parameterTypes).append('\n');
        }
        if (this.returnType != null) {
            builder.append("\treturnType: ").append(this.returnType).append('\n');
        }
        builder.append("}");
        return builder.toString();
    }
}

