/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.io.PrintWriter;
import java.time.Clock;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class TracingMessageConsumer
implements MessageConsumer {
    private static final Logger LOG = Logger.getLogger(TracingMessageConsumer.class.getName());
    private final MessageConsumer messageConsumer;
    private final Map<String, RequestMetadata> sentRequests;
    private final Map<String, RequestMetadata> receivedRequests;
    private final PrintWriter printWriter;
    private final Clock clock;
    private final DateTimeFormatter dateTimeFormatter;

    public TracingMessageConsumer(MessageConsumer messageConsumer, Map<String, RequestMetadata> sentRequests, Map<String, RequestMetadata> receivedRequests, PrintWriter printWriter, Clock clock) {
        this(messageConsumer, sentRequests, receivedRequests, printWriter, clock, null);
    }

    public TracingMessageConsumer(MessageConsumer messageConsumer, Map<String, RequestMetadata> sentRequests, Map<String, RequestMetadata> receivedRequests, PrintWriter printWriter, Clock clock, Locale locale) {
        this.messageConsumer = Objects.requireNonNull(messageConsumer);
        this.sentRequests = Objects.requireNonNull(sentRequests);
        this.receivedRequests = Objects.requireNonNull(receivedRequests);
        this.printWriter = Objects.requireNonNull(printWriter);
        this.clock = Objects.requireNonNull(clock);
        this.dateTimeFormatter = locale == null ? DateTimeFormatter.ofPattern("KK:mm:ss a").withZone(clock.getZone()) : DateTimeFormatter.ofPattern("KK:mm:ss a", locale).withZone(clock.getZone());
    }

    @Override
    public void consume(Message message) throws MessageIssueException, JsonRpcException {
        String logString;
        Instant now = this.clock.instant();
        String date = this.dateTimeFormatter.format(now);
        if (this.messageConsumer instanceof StreamMessageConsumer) {
            logString = this.consumeMessageSending(message, now, date);
        } else if (this.messageConsumer instanceof RemoteEndpoint) {
            logString = this.consumeMessageReceiving(message, now, date);
        } else {
            LOG.log(Level.WARNING, String.format("Unknown MessageConsumer type: %s", this.messageConsumer));
            logString = null;
        }
        if (logString != null) {
            this.printWriter.print(logString);
            this.printWriter.flush();
        }
        this.messageConsumer.consume(message);
    }

    private String consumeMessageSending(Message message, Instant now, String date) {
        if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            String id = requestMessage.getId();
            String method = requestMessage.getMethod();
            RequestMetadata requestMetadata = new RequestMetadata(method, now);
            this.sentRequests.put(id, requestMetadata);
            Object params = requestMessage.getParams();
            String paramsJson = MessageJsonHandler.toString(params);
            String format2 = "[Trace - %s] Sending request '%s - (%s)'\nParams: %s\n\n\n";
            return String.format(format2, date, method, id, paramsJson);
        }
        if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            String id = responseMessage.getId();
            RequestMetadata requestMetadata = this.receivedRequests.remove(id);
            if (requestMetadata == null) {
                LOG.log(Level.WARNING, String.format("Unmatched response message: %s", message));
                return null;
            }
            String method = requestMetadata.method;
            long latencyMillis = now.toEpochMilli() - requestMetadata.start.toEpochMilli();
            Object result = responseMessage.getResult();
            String resultJson = MessageJsonHandler.toString(result);
            String format3 = "[Trace - %s] Sending response '%s - (%s)'. Processing request took %sms\nResult: %s\n\n\n";
            return String.format(format3, date, method, id, latencyMillis, resultJson);
        }
        if (message instanceof NotificationMessage) {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            String method = notificationMessage.getMethod();
            Object params = notificationMessage.getParams();
            String paramsJson = MessageJsonHandler.toString(params);
            String format4 = "[Trace - %s] Sending notification '%s'\nParams: %s\n\n\n";
            return String.format(format4, date, method, paramsJson);
        }
        LOG.log(Level.WARNING, String.format("Unknown message type: %s", message));
        return null;
    }

    private String consumeMessageReceiving(Message message, Instant now, String date) {
        if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            String method = requestMessage.getMethod();
            String id = requestMessage.getId();
            RequestMetadata requestMetadata = new RequestMetadata(method, now);
            this.receivedRequests.put(id, requestMetadata);
            Object params = requestMessage.getParams();
            String paramsJson = MessageJsonHandler.toString(params);
            String format2 = "[Trace - %s] Received request '%s - (%s)'\nParams: %s\n\n\n";
            return String.format(format2, date, method, id, paramsJson);
        }
        if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            String id = responseMessage.getId();
            RequestMetadata requestMetadata = this.sentRequests.remove(id);
            if (requestMetadata == null) {
                LOG.log(Level.WARNING, String.format("Unmatched response message: %s", message));
                return null;
            }
            String method = requestMetadata.method;
            long latencyMillis = now.toEpochMilli() - requestMetadata.start.toEpochMilli();
            Object result = responseMessage.getResult();
            String resultJson = MessageJsonHandler.toString(result);
            ResponseError error = responseMessage.getError();
            String errorJson = MessageJsonHandler.toString(error);
            String format3 = "[Trace - %s] Received response '%s - (%s)' in %sms\nResult: %s\nError: %s\n\n\n";
            return String.format(format3, date, method, id, latencyMillis, resultJson, errorJson);
        }
        if (message instanceof NotificationMessage) {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            String method = notificationMessage.getMethod();
            Object params = notificationMessage.getParams();
            String paramsJson = MessageJsonHandler.toString(params);
            String format4 = "[Trace - %s] Received notification '%s'\nParams: %s\n\n\n";
            return String.format(format4, date, method, paramsJson);
        }
        LOG.log(Level.WARNING, String.format("Unknown message type: %s", message));
        return null;
    }

    public static class RequestMetadata {
        final String method;
        final Instant start;

        public RequestMetadata(String method, Instant start2) {
            this.method = method;
            this.start = start2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestMetadata that = (RequestMetadata)o;
            return Objects.equals(this.method, that.method) && Objects.equals(this.start, that.start);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.start);
        }
    }
}

