/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import util.FilenameToStream;
import util.SimpleFilenameToStream;

public class InJarFilenameToStream
extends SimpleFilenameToStream
implements FilenameToStream {
    private static final String TMPDIR = System.getProperty("java.io.tmpdir");
    private final String prefix;

    public InJarFilenameToStream(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public File resolve(String name2, boolean isModule) {
        InputStream is2 = InJarFilenameToStream.class.getResourceAsStream(this.prefix + name2);
        if (is2 != null) {
            try {
                int len;
                FilenameToStream.TLAFile sourceFile = new FilenameToStream.TLAFile(TMPDIR + File.separator + name2, InJarFilenameToStream.class.getResource(this.prefix + name2), false, this);
                sourceFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(sourceFile);
                byte[] buf = new byte[1024];
                while ((len = is2.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                is2.close();
                return sourceFile;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return super.resolve(name2, isModule);
    }

    @Override
    public File resolve(String name2) {
        return super.resolve(name2);
    }
}

