/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.BEncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.PropUtil;
import com.sun.mail.util.QDecoderStream;
import com.sun.mail.util.QEncoderStream;
import com.sun.mail.util.QPDecoderStream;
import com.sun.mail.util.QPEncoderStream;
import com.sun.mail.util.UUDecoderStream;
import com.sun.mail.util.UUEncoderStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.EncodingAware;
import javax.mail.MessagingException;
import javax.mail.internet.AsciiOutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

public class MimeUtility {
    public static final int ALL = -1;
    private static final Map<String, Boolean> nonAsciiCharsetMap;
    private static final boolean decodeStrict;
    private static final boolean encodeEolStrict;
    private static final boolean ignoreUnknownEncoding;
    private static final boolean allowUtf8;
    private static final boolean foldEncodedWords;
    private static final boolean foldText;
    private static String defaultJavaCharset;
    private static String defaultMIMECharset;
    private static Map<String, String> mime2java;
    private static Map<String, String> java2mime;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;

    private MimeUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEncoding(DataSource ds) {
        ContentType cType = null;
        InputStream is2 = null;
        String encoding2 = null;
        if (ds instanceof EncodingAware && (encoding2 = ((EncodingAware)((Object)ds)).getEncoding()) != null) {
            return encoding2;
        }
        try {
            cType = new ContentType(ds.getContentType());
            is2 = ds.getInputStream();
            boolean isText = cType.match("text/*");
            int i = MimeUtility.checkAscii(is2, -1, !isText);
            switch (i) {
                case 1: {
                    encoding2 = "7bit";
                    return encoding2;
                }
                case 2: {
                    if (isText && MimeUtility.nonAsciiCharset(cType)) {
                        encoding2 = "base64";
                        return encoding2;
                    } else {
                        encoding2 = "quoted-printable";
                        return encoding2;
                    }
                }
                default: {
                    encoding2 = "base64";
                    return encoding2;
                }
            }
        }
        catch (Exception ex) {
            String string2 = "base64";
            return string2;
        }
        finally {
            try {
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean nonAsciiCharset(ContentType ct) {
        Boolean bool;
        String charset = ct.getParameter("charset");
        if (charset == null) {
            return false;
        }
        charset = charset.toLowerCase(Locale.ENGLISH);
        Map<String, Boolean> map2 = nonAsciiCharsetMap;
        synchronized (map2) {
            bool = nonAsciiCharsetMap.get(charset);
        }
        if (bool == null) {
            try {
                byte[] b = "\r\n".getBytes(charset);
                bool = b.length != 2 || b[0] != 13 || b[1] != 10;
            }
            catch (UnsupportedEncodingException uex) {
                bool = Boolean.FALSE;
            }
            catch (RuntimeException ex) {
                bool = Boolean.TRUE;
            }
            map2 = nonAsciiCharsetMap;
            synchronized (map2) {
                nonAsciiCharsetMap.put(charset, bool);
            }
        }
        return bool;
    }

    public static String getEncoding(DataHandler dh) {
        ContentType cType = null;
        String encoding2 = null;
        if (dh.getName() != null) {
            return MimeUtility.getEncoding(dh.getDataSource());
        }
        try {
            cType = new ContentType(dh.getContentType());
        }
        catch (Exception ex) {
            return "base64";
        }
        if (cType.match("text/*")) {
            AsciiOutputStream aos = new AsciiOutputStream(false, false);
            try {
                dh.writeTo(aos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            switch (aos.getAscii()) {
                case 1: {
                    encoding2 = "7bit";
                    break;
                }
                case 2: {
                    encoding2 = "quoted-printable";
                    break;
                }
                default: {
                    encoding2 = "base64";
                    break;
                }
            }
        } else {
            AsciiOutputStream aos = new AsciiOutputStream(true, encodeEolStrict);
            try {
                dh.writeTo(aos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            encoding2 = aos.getAscii() == 1 ? "7bit" : "base64";
        }
        return encoding2;
    }

    public static InputStream decode(InputStream is2, String encoding2) throws MessagingException {
        if (encoding2.equalsIgnoreCase("base64")) {
            return new BASE64DecoderStream(is2);
        }
        if (encoding2.equalsIgnoreCase("quoted-printable")) {
            return new QPDecoderStream(is2);
        }
        if (encoding2.equalsIgnoreCase("uuencode") || encoding2.equalsIgnoreCase("x-uuencode") || encoding2.equalsIgnoreCase("x-uue")) {
            return new UUDecoderStream(is2);
        }
        if (encoding2.equalsIgnoreCase("binary") || encoding2.equalsIgnoreCase("7bit") || encoding2.equalsIgnoreCase("8bit")) {
            return is2;
        }
        if (!ignoreUnknownEncoding) {
            throw new MessagingException("Unknown encoding: " + encoding2);
        }
        return is2;
    }

    public static OutputStream encode(OutputStream os, String encoding2) throws MessagingException {
        if (encoding2 == null) {
            return os;
        }
        if (encoding2.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("uuencode") || encoding2.equalsIgnoreCase("x-uuencode") || encoding2.equalsIgnoreCase("x-uue")) {
            return new UUEncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("binary") || encoding2.equalsIgnoreCase("7bit") || encoding2.equalsIgnoreCase("8bit")) {
            return os;
        }
        throw new MessagingException("Unknown encoding: " + encoding2);
    }

    public static OutputStream encode(OutputStream os, String encoding2, String filename) throws MessagingException {
        if (encoding2 == null) {
            return os;
        }
        if (encoding2.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(os);
        }
        if (encoding2.equalsIgnoreCase("uuencode") || encoding2.equalsIgnoreCase("x-uuencode") || encoding2.equalsIgnoreCase("x-uue")) {
            return new UUEncoderStream(os, filename);
        }
        if (encoding2.equalsIgnoreCase("binary") || encoding2.equalsIgnoreCase("7bit") || encoding2.equalsIgnoreCase("8bit")) {
            return os;
        }
        throw new MessagingException("Unknown encoding: " + encoding2);
    }

    public static String encodeText(String text) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(text, null, null);
    }

    public static String encodeText(String text, String charset, String encoding2) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(text, charset, encoding2, false);
    }

    public static String decodeText(String etext) throws UnsupportedEncodingException {
        String lwsp = " \t\n\r";
        if (etext.indexOf("=?") == -1) {
            return etext;
        }
        StringTokenizer st = new StringTokenizer(etext, lwsp, true);
        StringBuilder sb = new StringBuilder();
        StringBuilder wsb = new StringBuilder();
        boolean prevWasEncoded = false;
        while (st.hasMoreTokens()) {
            String word;
            String s = st.nextToken();
            char c = s.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                wsb.append(c);
                continue;
            }
            try {
                word = MimeUtility.decodeWord(s);
                if (!prevWasEncoded && wsb.length() > 0) {
                    sb.append((CharSequence)wsb);
                }
                prevWasEncoded = true;
            }
            catch (ParseException pex) {
                word = s;
                if (!decodeStrict) {
                    String dword = MimeUtility.decodeInnerWords(word);
                    if (dword != word) {
                        if (!(prevWasEncoded && word.startsWith("=?") || wsb.length() <= 0)) {
                            sb.append((CharSequence)wsb);
                        }
                        prevWasEncoded = word.endsWith("?=");
                        word = dword;
                    } else {
                        if (wsb.length() > 0) {
                            sb.append((CharSequence)wsb);
                        }
                        prevWasEncoded = false;
                    }
                }
                if (wsb.length() > 0) {
                    sb.append((CharSequence)wsb);
                }
                prevWasEncoded = false;
            }
            sb.append(word);
            wsb.setLength(0);
        }
        sb.append((CharSequence)wsb);
        return sb.toString();
    }

    public static String encodeWord(String word) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, null, null);
    }

    public static String encodeWord(String word, String charset, String encoding2) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, charset, encoding2, true);
    }

    private static String encodeWord(String string2, String charset, String encoding2, boolean encodingWord) throws UnsupportedEncodingException {
        boolean b64;
        String jcharset;
        int ascii = MimeUtility.checkAscii(string2);
        if (ascii == 1) {
            return string2;
        }
        if (charset == null) {
            jcharset = MimeUtility.getDefaultJavaCharset();
            charset = MimeUtility.getDefaultMIMECharset();
        } else {
            jcharset = MimeUtility.javaCharset(charset);
        }
        if (encoding2 == null) {
            encoding2 = ascii != 3 ? "Q" : "B";
        }
        if (encoding2.equalsIgnoreCase("B")) {
            b64 = true;
        } else if (encoding2.equalsIgnoreCase("Q")) {
            b64 = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + encoding2);
        }
        StringBuilder outb = new StringBuilder();
        MimeUtility.doEncode(string2, b64, jcharset, 68 - charset.length(), "=?" + charset + "?" + encoding2 + "?", true, encodingWord, outb);
        return outb.toString();
    }

    private static void doEncode(String string2, boolean b64, String jcharset, int avail, String prefix, boolean first, boolean encodingWord, StringBuilder buf) throws UnsupportedEncodingException {
        int size;
        byte[] bytes2 = string2.getBytes(jcharset);
        int len = b64 ? BEncoderStream.encodedLength(bytes2) : QEncoderStream.encodedLength(bytes2, encodingWord);
        if (len > avail && (size = string2.length()) > 1) {
            int split2 = size / 2;
            if (Character.isHighSurrogate(string2.charAt(split2 - 1))) {
                --split2;
            }
            if (split2 > 0) {
                MimeUtility.doEncode(string2.substring(0, split2), b64, jcharset, avail, prefix, first, encodingWord, buf);
            }
            MimeUtility.doEncode(string2.substring(split2, size), b64, jcharset, avail, prefix, false, encodingWord, buf);
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FilterOutputStream eos = b64 ? new BEncoderStream(os) : new QEncoderStream((OutputStream)os, encodingWord);
            try {
                ((OutputStream)eos).write(bytes2);
                ((OutputStream)eos).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] encodedBytes = os.toByteArray();
            if (!first) {
                if (foldEncodedWords) {
                    buf.append("\r\n ");
                } else {
                    buf.append(" ");
                }
            }
            buf.append(prefix);
            for (int i = 0; i < encodedBytes.length; ++i) {
                buf.append((char)encodedBytes[i]);
            }
            buf.append("?=");
        }
    }

    public static String decodeWord(String eword) throws ParseException, UnsupportedEncodingException {
        if (!eword.startsWith("=?")) {
            throw new ParseException("encoded word does not start with \"=?\": " + eword);
        }
        int start2 = 2;
        int pos = eword.indexOf(63, start2);
        if (pos == -1) {
            throw new ParseException("encoded word does not include charset: " + eword);
        }
        String charset = eword.substring(start2, pos);
        int lpos = charset.indexOf(42);
        if (lpos >= 0) {
            charset = charset.substring(0, lpos);
        }
        charset = MimeUtility.javaCharset(charset);
        start2 = pos + 1;
        if ((pos = eword.indexOf(63, start2)) == -1) {
            throw new ParseException("encoded word does not include encoding: " + eword);
        }
        String encoding2 = eword.substring(start2, pos);
        start2 = pos + 1;
        if ((pos = eword.indexOf("?=", start2)) == -1) {
            throw new ParseException("encoded word does not end with \"?=\": " + eword);
        }
        String word = eword.substring(start2, pos);
        try {
            String decodedWord;
            if (word.length() > 0) {
                FilterInputStream is2;
                ByteArrayInputStream bis = new ByteArrayInputStream(ASCIIUtility.getBytes(word));
                if (encoding2.equalsIgnoreCase("B")) {
                    is2 = new BASE64DecoderStream(bis);
                } else if (encoding2.equalsIgnoreCase("Q")) {
                    is2 = new QDecoderStream(bis);
                } else {
                    throw new UnsupportedEncodingException("unknown encoding: " + encoding2);
                }
                int count2 = bis.available();
                byte[] bytes2 = new byte[count2];
                count2 = ((InputStream)is2).read(bytes2, 0, count2);
                decodedWord = count2 <= 0 ? "" : new String(bytes2, 0, count2, charset);
            } else {
                decodedWord = "";
            }
            if (pos + 2 < eword.length()) {
                String rest = eword.substring(pos + 2);
                if (!decodeStrict) {
                    rest = MimeUtility.decodeInnerWords(rest);
                }
                decodedWord = decodedWord + rest;
            }
            return decodedWord;
        }
        catch (UnsupportedEncodingException uex) {
            throw uex;
        }
        catch (IOException ioex) {
            throw new ParseException(ioex.toString());
        }
        catch (IllegalArgumentException iex) {
            throw new UnsupportedEncodingException(charset);
        }
    }

    private static String decodeInnerWords(String word) throws UnsupportedEncodingException {
        int i;
        int start2 = 0;
        StringBuilder buf = new StringBuilder();
        while ((i = word.indexOf("=?", start2)) >= 0) {
            buf.append(word.substring(start2, i));
            int end = word.indexOf(63, i + 2);
            if (end < 0 || (end = word.indexOf(63, end + 1)) < 0 || (end = word.indexOf("?=", end + 1)) < 0) break;
            String s = word.substring(i, end + 2);
            try {
                s = MimeUtility.decodeWord(s);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            buf.append(s);
            start2 = end + 2;
        }
        if (start2 == 0) {
            return word;
        }
        if (start2 < word.length()) {
            buf.append(word.substring(start2));
        }
        return buf.toString();
    }

    public static String quote(String word, String specials) {
        int len;
        int n = len = word == null ? 0 : word.length();
        if (len == 0) {
            return "\"\"";
        }
        boolean needQuoting = false;
        for (int i = 0; i < len; ++i) {
            char c = word.charAt(i);
            if (c == '\"' || c == '\\' || c == '\r' || c == '\n') {
                StringBuilder sb = new StringBuilder(len + 3);
                sb.append('\"');
                sb.append(word.substring(0, i));
                int lastc = 0;
                for (int j = i; j < len; ++j) {
                    char cc = word.charAt(j);
                    if (!(cc != '\"' && cc != '\\' && cc != '\r' && cc != '\n' || cc == '\n' && lastc == 13)) {
                        sb.append('\\');
                    }
                    sb.append(cc);
                    lastc = cc;
                }
                sb.append('\"');
                return sb.toString();
            }
            if (c >= ' ' && (c < '\u007f' || allowUtf8) && specials.indexOf(c) < 0) continue;
            needQuoting = true;
        }
        if (needQuoting) {
            StringBuilder sb = new StringBuilder(len + 2);
            sb.append('\"').append(word).append('\"');
            return sb.toString();
        }
        return word;
    }

    public static String fold(int used, String s) {
        char c;
        int end;
        if (!foldText) {
            return s;
        }
        for (end = s.length() - 1; end >= 0 && ((c = s.charAt(end)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --end) {
        }
        if (end != s.length() - 1) {
            s = s.substring(0, end + 1);
        }
        if (used + s.length() <= 76) {
            return MimeUtility.makesafe(s);
        }
        StringBuilder sb = new StringBuilder(s.length() + 4);
        char lastc = '\u0000';
        while (used + s.length() > 76) {
            int lastspace = -1;
            for (int i = 0; i < s.length() && (lastspace == -1 || used + i <= 76); ++i) {
                c = s.charAt(i);
                if ((c == ' ' || c == '\t') && lastc != ' ' && lastc != '\t') {
                    lastspace = i;
                }
                lastc = c;
            }
            if (lastspace == -1) {
                sb.append(s);
                s = "";
                used = 0;
                break;
            }
            sb.append(s.substring(0, lastspace));
            sb.append("\r\n");
            lastc = s.charAt(lastspace);
            sb.append(lastc);
            s = s.substring(lastspace + 1);
            used = 1;
        }
        sb.append(s);
        return MimeUtility.makesafe(sb);
    }

    private static String makesafe(CharSequence s) {
        char c;
        int i;
        for (i = 0; i < s.length() && (c = s.charAt(i)) != '\r' && c != '\n'; ++i) {
        }
        if (i == s.length()) {
            return s.toString();
        }
        StringBuilder sb = new StringBuilder(s.length() + 1);
        BufferedReader r = new BufferedReader(new StringReader(s.toString()));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (sb.length() > 0) {
                    sb.append("\r\n");
                    assert (line.length() > 0);
                    char c2 = line.charAt(0);
                    if (c2 != ' ' && c2 != '\t') {
                        sb.append(' ');
                    }
                }
                sb.append(line);
            }
        }
        catch (IOException ex) {
            return s.toString();
        }
        return sb.toString();
    }

    public static String unfold(String s) {
        int i;
        if (!foldText) {
            return s;
        }
        StringBuilder sb = null;
        while ((i = MimeUtility.indexOfAny(s, "\r\n")) >= 0) {
            char c;
            int start2 = i++;
            int slen = s.length();
            if (i < slen && s.charAt(i - 1) == '\r' && s.charAt(i) == '\n') {
                ++i;
            }
            if (start2 > 0 && s.charAt(start2 - 1) == '\\') {
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                }
                sb.append(s.substring(0, start2 - 1));
                sb.append(s.substring(start2, i));
                s = s.substring(i);
                continue;
            }
            if (i >= slen || (c = s.charAt(i)) == ' ' || c == '\t') {
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                }
                sb.append(s.substring(0, start2));
                s = s.substring(i);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(s.length());
            }
            sb.append(s.substring(0, i));
            s = s.substring(i);
        }
        if (sb != null) {
            sb.append(s);
            return sb.toString();
        }
        return s;
    }

    private static int indexOfAny(String s, String any) {
        return MimeUtility.indexOfAny(s, any, 0);
    }

    private static int indexOfAny(String s, String any, int start2) {
        try {
            int len = s.length();
            for (int i = start2; i < len; ++i) {
                if (any.indexOf(s.charAt(i)) < 0) continue;
                return i;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e2) {
            return -1;
        }
    }

    public static String javaCharset(String charset) {
        if (mime2java == null || charset == null) {
            return charset;
        }
        String alias2 = mime2java.get(charset.toLowerCase(Locale.ENGLISH));
        if (alias2 != null) {
            try {
                Charset.forName(alias2);
            }
            catch (Exception ex) {
                alias2 = null;
            }
        }
        return alias2 == null ? charset : alias2;
    }

    public static String mimeCharset(String charset) {
        if (java2mime == null || charset == null) {
            return charset;
        }
        String alias2 = java2mime.get(charset.toLowerCase(Locale.ENGLISH));
        return alias2 == null ? charset : alias2;
    }

    public static String getDefaultJavaCharset() {
        block6: {
            if (defaultJavaCharset == null) {
                String mimecs = null;
                try {
                    mimecs = System.getProperty("mail.mime.charset");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (mimecs != null && mimecs.length() > 0) {
                    defaultJavaCharset = MimeUtility.javaCharset(mimecs);
                    return defaultJavaCharset;
                }
                try {
                    defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
                }
                catch (SecurityException sex) {
                    class NullInputStream
                    extends InputStream {
                        NullInputStream() {
                        }

                        @Override
                        public int read() {
                            return 0;
                        }
                    }
                    InputStreamReader reader2 = new InputStreamReader(new NullInputStream());
                    defaultJavaCharset = reader2.getEncoding();
                    if (defaultJavaCharset != null) break block6;
                    defaultJavaCharset = "8859_1";
                }
            }
        }
        return defaultJavaCharset;
    }

    static String getDefaultMIMECharset() {
        if (defaultMIMECharset == null) {
            try {
                defaultMIMECharset = System.getProperty("mail.mime.charset");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (defaultMIMECharset == null) {
            defaultMIMECharset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        return defaultMIMECharset;
    }

    private static void loadMappings(LineInputStream is2, Map<String, String> table) {
        while (true) {
            String currLine;
            try {
                currLine = is2.readLine();
            }
            catch (IOException ioex) {
                break;
            }
            if (currLine == null || currLine.startsWith("--") && currLine.endsWith("--")) break;
            if (currLine.trim().length() == 0 || currLine.startsWith("#")) continue;
            StringTokenizer tk = new StringTokenizer(currLine, " \t");
            try {
                String key2 = tk.nextToken();
                String value = tk.nextToken();
                table.put(key2.toLowerCase(Locale.ENGLISH), value);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    static int checkAscii(String s) {
        int ascii = 0;
        int non_ascii = 0;
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (MimeUtility.nonascii(s.charAt(i))) {
                ++non_ascii;
                continue;
            }
            ++ascii;
        }
        if (non_ascii == 0) {
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(byte[] b) {
        int ascii = 0;
        int non_ascii = 0;
        for (int i = 0; i < b.length; ++i) {
            if (MimeUtility.nonascii(b[i] & 0xFF)) {
                ++non_ascii;
                continue;
            }
            ++ascii;
        }
        if (non_ascii == 0) {
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(InputStream is2, int max2, boolean breakOnNonAscii) {
        int ascii = 0;
        int non_ascii = 0;
        int block = 4096;
        int linelen = 0;
        boolean longLine = false;
        boolean badEOL = false;
        boolean checkEOL = encodeEolStrict && breakOnNonAscii;
        byte[] buf = null;
        if (max2 != 0) {
            block = max2 == -1 ? 4096 : Math.min(max2, 4096);
            buf = new byte[block];
        }
        while (max2 != 0) {
            int len;
            try {
                len = is2.read(buf, 0, block);
                if (len == -1) break;
                int lastb = 0;
                for (int i = 0; i < len; ++i) {
                    int b = buf[i] & 0xFF;
                    if (checkEOL && (lastb == 13 && b != 10 || lastb != 13 && b == 10)) {
                        badEOL = true;
                    }
                    if (b == 13 || b == 10) {
                        linelen = 0;
                    } else if (++linelen > 998) {
                        longLine = true;
                    }
                    if (MimeUtility.nonascii(b)) {
                        if (breakOnNonAscii) {
                            return 3;
                        }
                        ++non_ascii;
                    } else {
                        ++ascii;
                    }
                    lastb = b;
                }
            }
            catch (IOException ioex) {
                break;
            }
            if (max2 == -1) continue;
            max2 -= len;
        }
        if (max2 == 0 && breakOnNonAscii) {
            return 3;
        }
        if (non_ascii == 0) {
            if (badEOL) {
                return 3;
            }
            if (longLine) {
                return 2;
            }
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static final boolean nonascii(int b) {
        return b >= 127 || b < 32 && b != 13 && b != 10 && b != 9;
    }

    static {
        block11: {
            nonAsciiCharsetMap = new HashMap<String, Boolean>();
            decodeStrict = PropUtil.getBooleanSystemProperty("mail.mime.decodetext.strict", true);
            encodeEolStrict = PropUtil.getBooleanSystemProperty("mail.mime.encodeeol.strict", false);
            ignoreUnknownEncoding = PropUtil.getBooleanSystemProperty("mail.mime.ignoreunknownencoding", false);
            allowUtf8 = PropUtil.getBooleanSystemProperty("mail.mime.allowutf8", false);
            foldEncodedWords = PropUtil.getBooleanSystemProperty("mail.mime.foldencodedwords", false);
            foldText = PropUtil.getBooleanSystemProperty("mail.mime.foldtext", true);
            java2mime = new HashMap<String, String>(40);
            mime2java = new HashMap<String, String>(14);
            try {
                InputStream is2 = MimeUtility.class.getResourceAsStream("/META-INF/javamail.charset.map");
                if (is2 == null) break block11;
                try {
                    is2 = new LineInputStream(is2);
                    MimeUtility.loadMappings((LineInputStream)is2, java2mime);
                    MimeUtility.loadMappings((LineInputStream)is2, mime2java);
                }
                finally {
                    try {
                        is2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (java2mime.isEmpty()) {
            java2mime.put("8859_1", "ISO-8859-1");
            java2mime.put("iso8859_1", "ISO-8859-1");
            java2mime.put("iso8859-1", "ISO-8859-1");
            java2mime.put("8859_2", "ISO-8859-2");
            java2mime.put("iso8859_2", "ISO-8859-2");
            java2mime.put("iso8859-2", "ISO-8859-2");
            java2mime.put("8859_3", "ISO-8859-3");
            java2mime.put("iso8859_3", "ISO-8859-3");
            java2mime.put("iso8859-3", "ISO-8859-3");
            java2mime.put("8859_4", "ISO-8859-4");
            java2mime.put("iso8859_4", "ISO-8859-4");
            java2mime.put("iso8859-4", "ISO-8859-4");
            java2mime.put("8859_5", "ISO-8859-5");
            java2mime.put("iso8859_5", "ISO-8859-5");
            java2mime.put("iso8859-5", "ISO-8859-5");
            java2mime.put("8859_6", "ISO-8859-6");
            java2mime.put("iso8859_6", "ISO-8859-6");
            java2mime.put("iso8859-6", "ISO-8859-6");
            java2mime.put("8859_7", "ISO-8859-7");
            java2mime.put("iso8859_7", "ISO-8859-7");
            java2mime.put("iso8859-7", "ISO-8859-7");
            java2mime.put("8859_8", "ISO-8859-8");
            java2mime.put("iso8859_8", "ISO-8859-8");
            java2mime.put("iso8859-8", "ISO-8859-8");
            java2mime.put("8859_9", "ISO-8859-9");
            java2mime.put("iso8859_9", "ISO-8859-9");
            java2mime.put("iso8859-9", "ISO-8859-9");
            java2mime.put("sjis", "Shift_JIS");
            java2mime.put("jis", "ISO-2022-JP");
            java2mime.put("iso2022jp", "ISO-2022-JP");
            java2mime.put("euc_jp", "euc-jp");
            java2mime.put("koi8_r", "koi8-r");
            java2mime.put("euc_cn", "euc-cn");
            java2mime.put("euc_tw", "euc-tw");
            java2mime.put("euc_kr", "euc-kr");
        }
        if (mime2java.isEmpty()) {
            mime2java.put("iso-2022-cn", "ISO2022CN");
            mime2java.put("iso-2022-kr", "ISO2022KR");
            mime2java.put("utf-8", "UTF8");
            mime2java.put("utf8", "UTF8");
            mime2java.put("ja_jp.iso2022-7", "ISO2022JP");
            mime2java.put("ja_jp.eucjp", "EUCJIS");
            mime2java.put("euc-kr", "KSC5601");
            mime2java.put("euckr", "KSC5601");
            mime2java.put("us-ascii", "ISO-8859-1");
            mime2java.put("x-us-ascii", "ISO-8859-1");
            mime2java.put("gb2312", "GB18030");
            mime2java.put("cp936", "GB18030");
            mime2java.put("ms936", "GB18030");
            mime2java.put("gbk", "GB18030");
        }
    }
}

