/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.Action;
import tlc2.tool.CallStack;
import tlc2.tool.EvalException;
import tlc2.tool.IActionItemList;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.ActionItemList;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.OpLambdaValue;
import tlc2.value.impl.SetPredValue;
import tlc2.value.impl.Value;
import util.Assert;

public final class CallStackTool
extends Tool {
    private final CallStack callStack = new CallStack();

    public CallStackTool(ITool other) {
        super((Tool)other);
    }

    public final String toString() {
        return this.callStack.toString();
    }

    @Override
    protected final void getInitStates(SemanticNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        this.callStack.push(init);
        try {
            super.getInitStates(init, acts, c, ps, states, cm);
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected void getInitStatesAppl(OpApplNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        this.callStack.push((SemanticNode)init);
        try {
            super.getInitStatesAppl(init, acts, c, ps, states, cm);
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected final TLCState getNextStates(Action action, SemanticNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        this.callStack.push(pred);
        try {
            TLCState tLCState = this.getNextStatesImpl(action, pred, acts, c, s0, s1, nss, cm);
            return tLCState;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected final TLCState getNextStatesAppl(Action action, OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        this.callStack.push((SemanticNode)pred);
        try {
            TLCState tLCState = this.getNextStatesApplImpl(action, pred, acts, c, s0, s1, nss, cm);
            return tLCState;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    public final Value eval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        this.callStack.push(expr);
        try {
            Value value = this.evalImpl(expr, c, s0, s1, control, cm);
            if (value instanceof SetPredValue) {
                SetPredValue setPredValue = new SetPredValue((SetPredValue)value, this);
                return setPredValue;
            }
            if (value instanceof FcnLambdaValue) {
                FcnLambdaValue fcnLambdaValue = new FcnLambdaValue((FcnLambdaValue)value, this);
                return fcnLambdaValue;
            }
            if (value instanceof OpLambdaValue) {
                OpLambdaValue opLambdaValue = new OpLambdaValue((OpLambdaValue)value, this);
                return opLambdaValue;
            }
            Value value2 = value;
            return value2;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected final Value evalAppl(OpApplNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        this.callStack.push((SemanticNode)expr);
        try {
            Value value = this.evalApplImpl(expr, c, s0, s1, control, cm);
            if (value instanceof SetPredValue) {
                SetPredValue setPredValue = new SetPredValue((SetPredValue)value, this);
                return setPredValue;
            }
            if (value instanceof FcnLambdaValue) {
                FcnLambdaValue fcnLambdaValue = new FcnLambdaValue((FcnLambdaValue)value, this);
                return fcnLambdaValue;
            }
            if (value instanceof OpLambdaValue) {
                OpLambdaValue opLambdaValue = new OpLambdaValue((OpLambdaValue)value, this);
                return opLambdaValue;
            }
            Value value2 = value;
            return value2;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    public final TLCState enabled(SemanticNode pred, IActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        this.callStack.push(pred);
        try {
            TLCState tLCState = this.enabledImpl(pred, (ActionItemList)acts, c, s0, s1, cm);
            return tLCState;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected final TLCState enabledAppl(OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        this.callStack.push((SemanticNode)pred);
        try {
            TLCState tLCState = this.enabledApplImpl(pred, acts, c, s0, s1, cm);
            return tLCState;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected final TLCState processUnchanged(Action action, SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        this.callStack.push(expr);
        try {
            TLCState tLCState = this.processUnchangedImpl(action, expr, acts, c, s0, s1, nss, cm);
            return tLCState;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected final TLCState enabledUnchanged(SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        this.callStack.push(expr);
        try {
            TLCState tLCState = this.enabledUnchangedImpl(expr, acts, c, s0, s1, cm);
            return tLCState;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.callStack.freeze();
            throw e;
        }
        finally {
            this.callStack.pop();
        }
    }

    @Override
    protected final Value setSource(SemanticNode expr, Value value) {
        value.setSource(expr);
        return value;
    }

    public boolean hasCallStack() {
        return this.callStack.size() > 0;
    }
}

