/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import tlc2.output.MP;
import tlc2.tool.TLCTrace;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.util.SetOfLong;
import util.Assert;
import util.FileUtil;

public final class MemFPSet1
extends FPSet {
    private String metadir;
    private String filename;
    private SetOfLong set = new SetOfLong(10001, 0.75f);

    public MemFPSet1(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
    }

    @Override
    public final FPSet init(int numThreads, String metadir, String filename) {
        this.metadir = metadir;
        this.filename = filename;
        return this;
    }

    @Override
    public final long size() {
        return this.set.size();
    }

    public final long sizeof() {
        return 8L + this.set.sizeof();
    }

    @Override
    public final synchronized boolean put(long fp) {
        return this.set.put(fp);
    }

    @Override
    public final synchronized boolean contains(long fp) {
        return this.set.contains(fp);
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        super.exit(cleanup);
        if (cleanup) {
            File file = new File(this.metadir);
            FileUtil.deleteDir((File)file, (boolean)true);
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        MP.printMessage(2211, hostname);
        System.exit(0);
    }

    @Override
    public final long checkFPs() {
        return this.set.checkFPs();
    }

    @Override
    public final void beginChkpt(String fname) throws IOException {
        DataOutputStream dos = FileUtil.newDFOS((String)this.chkptName(fname, "tmp"));
        this.set.beginChkpt(dos);
        dos.close();
    }

    @Override
    public final void commitChkpt(String fname) throws IOException {
        File oldChkpt = new File(this.chkptName(fname, "chkpt"));
        File newChkpt = new File(this.chkptName(fname, "tmp"));
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemFPSet1.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    @Override
    public final void recover(String fname) throws IOException {
        DataInputStream dis = FileUtil.newDFIS((String)this.chkptName(fname, "chkpt"));
        this.set.recover(dis);
        dis.close();
    }

    @Override
    public final void beginChkpt() throws IOException {
        this.beginChkpt(this.filename);
    }

    @Override
    public final void commitChkpt() throws IOException {
        this.commitChkpt(this.filename);
    }

    @Override
    public final void recover(TLCTrace trace) throws IOException {
        this.recover(this.filename);
    }

    @Override
    public final void recoverFP(long fp) throws IOException {
        Assert.check((!this.set.put(fp) ? 1 : 0) != 0, (int)2133);
    }

    private final String chkptName(String fname, String ext) {
        return this.metadir + FileUtil.separator + fname + ".fp." + ext;
    }
}

