/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.selector;

import tlc2.tool.TLCState;
import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.TLCWorkerRMI;
import tlc2.tool.distributed.selector.IBlockSelector;
import tlc2.tool.queue.IStateQueue;
import util.Assert;

public class BlockSelector
implements IBlockSelector {
    protected volatile long averageBlockCnt = 0L;
    protected final TLCServer tlcServer;

    BlockSelector(TLCServer aTLCServer) {
        Assert.check((aTLCServer != null ? 1 : 0) != 0, (String)"TLC found a null TLCServer");
        this.tlcServer = aTLCServer;
    }

    @Override
    public TLCState[] getBlocks(IStateQueue stateQueue, TLCWorkerRMI worker) {
        long amountOfStates = stateQueue.size();
        long blockSize = this.getBlockSize(amountOfStates, worker);
        blockSize = Math.min(blockSize, amountOfStates);
        blockSize = Math.max(blockSize, 1L);
        TLCState[] sDequeue = stateQueue.sDequeue((int)(blockSize = Math.min(Integer.MAX_VALUE, blockSize)));
        this.setAverageBlockCnt(sDequeue != null ? (long)sDequeue.length : 0L);
        return sDequeue;
    }

    protected long getBlockSize(long size, TLCWorkerRMI aWorker) {
        int workerCount = this.tlcServer.getWorkerCount();
        return (long)Math.ceil((double)size * (1.0 / (double)workerCount));
    }

    @Override
    public void setMaxTXSize(int aMaximum) {
    }

    protected void setAverageBlockCnt(long blockCnt) {
        this.averageBlockCnt = this.averageBlockCnt > 0L ? (blockCnt + this.averageBlockCnt) / 2L : blockCnt;
    }

    @Override
    public long getAverageBlockCnt() {
        return this.averageBlockCnt;
    }
}

