(ns bling.fonts.isometric-1)



;;                   ___           ___           ___           ___           ___           ___                       ___
;;       ___        /\  \         /\  \         /\__\         /\  \         /\  \         /\  \          ___        /\  \
;;      /\  \      /::\  \       /::\  \       /::|  |       /::\  \        \:\  \       /::\  \        /\  \      /::\  \
;;      \:\  \    /:/\ \  \     /:/\:\  \     /:|:|  |      /:/\:\  \        \:\  \     /:/\:\  \       \:\  \    /:/\:\  \
;;      /::\__\  _\:\~\ \  \   /:/  \:\  \   /:/|:|__|__   /::\~\:\  \       /::\  \   /::\~\:\  \      /::\__\  /:/  \:\  \
;;   __/:/\/__/ /\ \:\ \ \__\ /:/__/ \:\__\ /:/ |::::\__\ /:/\:\ \:\__\     /:/\:\__\ /:/\:\ \:\__\  __/:/\/__/ /:/__/ \:\__\
;;  /\/:/  /    \:\ \:\ \/__/ \:\  \ /:/  / \/__/~~/:/  / \:\~\:\ \/__/    /:/  \/__/ \/_|::\/:/  / /\/:/  /    \:\  \  \/__/
;;  \::/__/      \:\ \:\__\    \:\  /:/  /        /:/  /   \:\ \:\__\     /:/  /         |:|::/  /  \::/__/      \:\  \
;;   \:\__\       \:\/:/  /     \:\/:/  /        /:/  /     \:\ \/__/     \/__/          |:|\/__/    \:\__\       \:\  \
;;    \/__/        \::/  /       \::/  /        /:/  /       \:\__\                      |:|  |       \/__/        \:\__\
;;                  \/__/         \/__/         \/__/         \/__/                       \|__|                     \/__/

(def isometric-1
'{:font-name "Isometric 1",
 :example
 ["                 ___           ___           ___           ___           ___           ___                       ___"
  "     ___        /\\  \\         /\\  \\         /\\__\\         /\\  \\         /\\  \\         /\\  \\          ___        /\\  \\"
  "    /\\  \\      /::\\  \\       /::\\  \\       /::|  |       /::\\  \\        \\:\\  \\       /::\\  \\        /\\  \\      /::\\  \\"
  "    \\:\\  \\    /:/\\ \\  \\     /:/\\:\\  \\     /:|:|  |      /:/\\:\\  \\        \\:\\  \\     /:/\\:\\  \\       \\:\\  \\    /:/\\:\\  \\"
  "    /::\\__\\  _\\:\\~\\ \\  \\   /:/  \\:\\  \\   /:/|:|__|__   /::\\~\\:\\  \\       /::\\  \\   /::\\~\\:\\  \\      /::\\__\\  /:/  \\:\\  \\"
  " __/:/\\/__/ /\\ \\:\\ \\ \\__\\ /:/__/ \\:\\__\\ /:/ |::::\\__\\ /:/\\:\\ \\:\\__\\     /:/\\:\\__\\ /:/\\:\\ \\:\\__\\  __/:/\\/__/ /:/__/ \\:\\__\\"
  "/\\/:/  /    \\:\\ \\:\\ \\/__/ \\:\\  \\ /:/  / \\/__/~~/:/  / \\:\\~\\:\\ \\/__/    /:/  \\/__/ \\/_|::\\/:/  / /\\/:/  /    \\:\\  \\  \\/__/"
  "\\::/__/      \\:\\ \\:\\__\\    \\:\\  /:/  /        /:/  /   \\:\\ \\:\\__\\     /:/  /         |:|::/  /  \\::/__/      \\:\\  \\"
  " \\:\\__\\       \\:\\/:/  /     \\:\\/:/  /        /:/  /     \\:\\ \\/__/     \\/__/          |:|\\/__/    \\:\\__\\       \\:\\  \\"
  "  \\/__/        \\::/  /       \\::/  /        /:/  /       \\:\\__\\                      |:|  |       \\/__/        \\:\\__\\"
  "                \\/__/         \\/__/         \\/__/         \\/__/                       \\|__|                     \\/__/"],
 :desc
 "Figlet conversion by Kent Nassen (kentn@cyberspace.org), 8-10-94, based\non the fonts posted by Lennert Stock:\n\nFrom: stock@fwi.uva.nl (Lennert Stock)\nDate: 15 Jul 1994 00:04:25 GMT\n\nHere are some fonts. Non-figlet I'm afraid, if you wanna convert them, be\nmy guest. I posted the isometric fonts before.\n\n------------------------------------------------------------------------------\n\n     .x%%%%%%x.                                             .x%%%%%%x.\n    ,%%%%%%%%%%.                                           .%%%%%%%%%%.\n   ,%%%'  )'  \\)                                           :(  `(  `%%%.\n  ,%x%)________) --------- L e n n e r t   S t o c k       ( _   __ (%x%.\n  (%%%~^88P~88P|                                           |~=> .=-~ %%%)\n  (%%::. .:,\\ .'                                           `. /,:. .::%%)\n  `;%:`\\. `-' |                                             | `-' ./':%:'\n   ``x`. -===.'                   stock@fwi.uva.nl -------- `.===- .'x''\n    / `:`.__.;                                               :.__.':' \\\n .d8b.     ..`.                                             .'..     .d8b.",
 :example-text "ABCDE",
 :font-sym isometric-1,
 :widest-char "A",
 :char-height 11,
 :max-char-width 14,
 :missing-chars
 ["!"
  "\""
  "#"
  "$"
  "%"
  "&"
  "'"
  "("
  ")"
  "*"
  "+"
  ","
  "-"
  "."
  "/"
  "0"
  "1"
  "2"
  "3"
  "4"
  "5"
  "6"
  "7"
  "8"
  "9"
  ":"
  ";"
  "<"
  "="
  ">"
  "?"
  "@"
  "\\"
  "]"
  "^"
  "_"
  "`"
  "{"
  "|"
  "}"
  "~"
  "Ä"
  "Ö"
  "Ü"
  "ä"
  "ö"
  "ü"
  "ß"],
 :chars-array-map
 {" "
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 0,
   :character " ",
   :width 7,
   :height 11},
  "!"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   !   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 1,
   :character "!",
   :width 0,
   :height 11,
   :missing? true},
  "\""
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   \"   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 2,
   :character "\"",
   :width 0,
   :height 11,
   :missing? true},
  "#"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   #   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 3,
   :character "#",
   :width 0,
   :height 11,
   :missing? true},
  "$"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   $   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 4,
   :character "$",
   :width 0,
   :height 11,
   :missing? true},
  "%"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   %   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 5,
   :character "%",
   :width 0,
   :height 11,
   :missing? true},
  "&"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   &   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 6,
   :character "&",
   :width 0,
   :height 11,
   :missing? true},
  "'"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   '   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 7,
   :character "'",
   :width 0,
   :height 11,
   :missing? true},
  "("
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   (   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 8,
   :character "(",
   :width 0,
   :height 11,
   :missing? true},
  ")"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   )   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 9,
   :character ")",
   :width 0,
   :height 11,
   :missing? true},
  "*"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   *   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 10,
   :character "*",
   :width 0,
   :height 11,
   :missing? true},
  "+"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   +   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 11,
   :character "+",
   :width 0,
   :height 11,
   :missing? true},
  ","
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ,   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 12,
   :character ",",
   :width 0,
   :height 11,
   :missing? true},
  "-"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   -   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 13,
   :character "-",
   :width 0,
   :height 11,
   :missing? true},
  "."
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   .   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 14,
   :character ".",
   :width 0,
   :height 11,
   :missing? true},
  "/"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   /   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 15,
   :character "/",
   :width 0,
   :height 11,
   :missing? true},
  "0"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   0   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 16,
   :character "0",
   :width 0,
   :height 11,
   :missing? true},
  "1"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   1   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 17,
   :character "1",
   :width 0,
   :height 11,
   :missing? true},
  "2"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   2   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 18,
   :character "2",
   :width 0,
   :height 11,
   :missing? true},
  "3"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   3   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 19,
   :character "3",
   :width 0,
   :height 11,
   :missing? true},
  "4"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   4   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 20,
   :character "4",
   :width 0,
   :height 11,
   :missing? true},
  "5"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   5   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 21,
   :character "5",
   :width 0,
   :height 11,
   :missing? true},
  "6"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   6   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 22,
   :character "6",
   :width 0,
   :height 11,
   :missing? true},
  "7"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   7   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 23,
   :character "7",
   :width 0,
   :height 11,
   :missing? true},
  "8"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   8   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 24,
   :character "8",
   :width 0,
   :height 11,
   :missing? true},
  "9"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   9   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 25,
   :character "9",
   :width 0,
   :height 11,
   :missing? true},
  ":"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   :   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 26,
   :character ":",
   :width 0,
   :height 11,
   :missing? true},
  ";"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ;   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 27,
   :character ";",
   :width 0,
   :height 11,
   :missing? true},
  "<"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   <   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 28,
   :character "<",
   :width 0,
   :height 11,
   :missing? true},
  "="
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   =   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 29,
   :character "=",
   :width 0,
   :height 11,
   :missing? true},
  ">"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   >   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 30,
   :character ">",
   :width 0,
   :height 11,
   :missing? true},
  "?"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ?   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 31,
   :character "?",
   :width 0,
   :height 11,
   :missing? true},
  "@"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   @   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 32,
   :character "@",
   :width 0,
   :height 11,
   :missing? true},
  "A"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/__\\:\\/:/  /"
    "      \\::/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 33,
   :character "A",
   :width 14,
   :height 11},
  "B"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\__\\ "
    " /:/\\:\\ \\:|__|"
    " \\:\\~\\:\\/:/  /"
    "  \\:\\ \\::/  / "
    "   \\:\\/:/  /  "
    "    \\::/__/   "
    "     ‾‾       "],
   :i 34,
   :character "B",
   :width 14,
   :height 11},
  "C"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\  \\ "
    " /:/__/ \\:\\__\\"
    " \\:\\  \\  \\/__/"
    "  \\:\\  \\      "
    "   \\:\\  \\     "
    "    \\:\\__\\    "
    "     \\/__/    "],
   :i 35,
   :character "C",
   :width 14,
   :height 11},
  "D"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\__\\ "
    " /:/__/ \\:|__|"
    " \\:\\  \\ /:/  /"
    "  \\:\\  /:/  / "
    "   \\:\\/:/  /  "
    "    \\::/__/   "
    "     ‾‾       "],
   :i 36,
   :character "D",
   :width 14,
   :height 11},
  "E"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\:\\~\\:\\ \\/__/"
    "  \\:\\ \\:\\__\\  "
    "   \\:\\ \\/__/  "
    "    \\:\\__\\    "
    "     \\/__/    "],
   :i 37,
   :character "E",
   :width 14,
   :height 11},
  "F"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/__\\:\\ \\/__/"
    "      \\:\\__\\  "
    "       \\/__/  "
    "              "
    "              "],
   :i 38,
   :character "F",
   :width 14,
   :height 11},
  "G"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\  \\ "
    " /:/__/_\\:\\__\\"
    " \\:\\  /\\ \\/__/"
    "  \\:\\ \\:\\__\\  "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 39,
   :character "G",
   :width 14,
   :height 11},
  "H"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/__/     "
    "  /::\\  \\ ___ "
    " /:/\\:\\  /\\__\\"
    " \\/__\\:\\/:/  /"
    "      \\::/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 40,
   :character "H",
   :width 14,
   :height 11},
  "I"
  {:bands
   ["            "
    "      ___   "
    "     /\\  \\  "
    "     \\:\\  \\ "
    "     /::\\__\\"
    "  __/:/\\/__/"
    " /\\/:/  /   "
    " \\::/__/    "
    "  \\:\\__\\    "
    "   \\/__/    "
    "            "],
   :i 41,
   :character "I",
   :width 12,
   :height 11},
  "J"
  {:bands
   ["       ___   "
    "      /\\  \\  "
    "      \\:\\  \\ "
    "  ___ /::\\__\\"
    " /\\  /:/\\/__/"
    " \\:\\/:/  /   "
    "  \\::/  /    "
    "   \\/__/     "
    "             "
    "             "
    "             "],
   :i 42,
   :character "J",
   :width 13,
   :height 11},
  "K"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/__/     "
    "  /::\\__\\____ "
    " /:/\\:::::\\__\\"
    " \\/_|:|~~|~   "
    "    |:|  |    "
    "    |:|  |    "
    "    |:|  |    "
    "     \\|__|    "],
   :i 43,
   :character "K",
   :width 14,
   :height 11},
  "L"
  {:bands
   ["      ___ "
    "     /\\__\\"
    "    /:/  /"
    "   /:/  / "
    "  /:/  /  "
    " /:/__/   "
    " \\:\\  \\   "
    "  \\:\\  \\  "
    "   \\:\\  \\ "
    "    \\:\\__\\"
    "     \\/__/"],
   :i 44,
   :character "L",
   :width 10,
   :height 11},
  "M"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /::|  |   "
    "   /:|:|  |   "
    "  /:/|:|__|__ "
    " /:/ |::::\\__\\"
    " \\/__/~~/:/  /"
    "       /:/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 45,
   :character "M",
   :width 14,
   :height 11},
  "N"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /::|  |   "
    "   /:|:|  |   "
    "  /:/|:|  |__ "
    " /:/ |:| /\\__\\"
    " \\/__|:|/:/  /"
    "     |:/:/  / "
    "     |::/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 46,
   :character "N",
   :width 14,
   :height 11},
  "O"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\  \\ "
    " /:/__/ \\:\\__\\"
    " \\:\\  \\ /:/  /"
    "  \\:\\  /:/  / "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 47,
   :character "O",
   :width 14,
   :height 11},
  "P"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/__\\:\\/:/  /"
    "      \\::/  / "
    "       \\/__/  "
    "              "
    "              "],
   :i 48,
   :character "P",
   :width 14,
   :height 11},
  "Q"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "   \\:\\~\\:\\  \\ "
    "    \\:\\ \\:\\__\\"
    "     \\:\\/:/  /"
    "      \\::/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 49,
   :character "Q",
   :width 14,
   :height 11},
  "R"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/_|::\\/:/  /"
    "    |:|::/  / "
    "    |:|\\/__/  "
    "    |:|  |    "
    "     \\|__|    "],
   :i 50,
   :character "R",
   :width 14,
   :height 11},
  "S"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\ \\  \\  "
    "  _\\:\\~\\ \\  \\ "
    " /\\ \\:\\ \\ \\__\\"
    " \\:\\ \\:\\ \\/__/"
    "  \\:\\ \\:\\__\\  "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 51,
   :character "S",
   :width 14,
   :height 11},
  "T"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "     \\:\\  \\   "
    "      \\:\\  \\  "
    "      /::\\  \\ "
    "     /:/\\:\\__\\"
    "    /:/  \\/__/"
    "   /:/  /     "
    "   \\/__/      "
    "              "
    "              "],
   :i 52,
   :character "T",
   :width 14,
   :height 11},
  "U"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/  /     "
    "  /:/  /  ___ "
    " /:/__/  /\\__\\"
    " \\:\\  \\ /:/  /"
    "  \\:\\  /:/  / "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 53,
   :character "U",
   :width 14,
   :height 11},
  "V"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/  /     "
    "  /:/__/  ___ "
    "  |:|  | /\\__\\"
    "  |:|  |/:/  /"
    "  |:|__/:/  / "
    "   \\::::/__/  "
    "    ~~~~      "
    "              "],
   :i 54,
   :character "V",
   :width 14,
   :height 11},
  "W"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/ _/_   "
    "   /:/ /\\__\\  "
    "  /:/ /:/ _/_ "
    " /:/_/:/ /\\__\\"
    " \\:\\/:/ /:/  /"
    "  \\::/_/:/  / "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 55,
   :character "W",
   :width 14,
   :height 11},
  "X"
  {:bands
   ["      ___     "
    "     |\\__\\    "
    "     |:|  |   "
    "     |:|  |   "
    "     |:|__|__ "
    " ____/::::\\__\\"
    " \\::::/~~/~   "
    "  ~~|:|~~|    "
    "    |:|  |    "
    "    |:|  |    "
    "     \\|__|    "],
   :i 56,
   :character "X",
   :width 14,
   :height 11},
  "Y"
  {:bands
   ["      ___     "
    "     |\\__\\    "
    "     |:|  |   "
    "     |:|  |   "
    "     |:|__|__ "
    "     /::::\\__\\"
    "    /:/~~/~   "
    "   /:/  /     "
    "   \\/__/      "
    "              "
    "              "],
   :i 57,
   :character "Y",
   :width 14,
   :height 11},
  "Z"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "     \\:\\  \\   "
    "      \\:\\  \\  "
    "       \\:\\  \\ "
    " _______\\:\\__\\"
    " \\::::::::/__/"
    "  \\:\\~~\\~~    "
    "   \\:\\  \\     "
    "    \\:\\__\\    "
    "     \\/__/    "],
   :i 58,
   :character "Z",
   :width 14,
   :height 11},
  "["
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /::::\\  \\  "
    "  /::::::\\  \\ "
    " /:::LS:::\\__\\"
    " \\::1994::/  /"
    "  \\::::::/  / "
    "   \\::::/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 59,
   :character "[",
   :width 14,
   :height 11},
  "\\"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   \\   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 60,
   :character "\\",
   :width 0,
   :height 11,
   :missing? true},
  "]"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ]   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 61,
   :character "]",
   :width 0,
   :height 11,
   :missing? true},
  "^"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ^   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 62,
   :character "^",
   :width 0,
   :height 11,
   :missing? true},
  "_"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   _   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 63,
   :character "_",
   :width 0,
   :height 11,
   :missing? true},
  "`"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   `   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 64,
   :character "`",
   :width 0,
   :height 11,
   :missing? true},
  "a"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/__\\:\\/:/  /"
    "      \\::/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 65,
   :character "a",
   :width 14,
   :height 11},
  "b"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\__\\ "
    " /:/\\:\\ \\:|__|"
    " \\:\\~\\:\\/:/  /"
    "  \\:\\ \\::/  / "
    "   \\:\\/:/  /  "
    "    \\::/__/   "
    "     ‾‾       "],
   :i 66,
   :character "b",
   :width 14,
   :height 11},
  "c"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\  \\ "
    " /:/__/ \\:\\__\\"
    " \\:\\  \\  \\/__/"
    "  \\:\\  \\      "
    "   \\:\\  \\     "
    "    \\:\\__\\    "
    "     \\/__/    "],
   :i 67,
   :character "c",
   :width 14,
   :height 11},
  "d"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\__\\ "
    " /:/__/ \\:|__|"
    " \\:\\  \\ /:/  /"
    "  \\:\\  /:/  / "
    "   \\:\\/:/  /  "
    "    \\::/__/   "
    "     ‾‾       "],
   :i 68,
   :character "d",
   :width 14,
   :height 11},
  "e"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\:\\~\\:\\ \\/__/"
    "  \\:\\ \\:\\__\\  "
    "   \\:\\ \\/__/  "
    "    \\:\\__\\    "
    "     \\/__/    "],
   :i 69,
   :character "e",
   :width 14,
   :height 11},
  "f"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/__\\:\\ \\/__/"
    "      \\:\\__\\  "
    "       \\/__/  "
    "              "
    "              "],
   :i 70,
   :character "f",
   :width 14,
   :height 11},
  "g"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\  \\ "
    " /:/__/_\\:\\__\\"
    " \\:\\  /\\ \\/__/"
    "  \\:\\ \\:\\__\\  "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 71,
   :character "g",
   :width 14,
   :height 11},
  "h"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/__/     "
    "  /::\\  \\ ___ "
    " /:/\\:\\  /\\__\\"
    " \\/__\\:\\/:/  /"
    "      \\::/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 72,
   :character "h",
   :width 14,
   :height 11},
  "i"
  {:bands
   ["            "
    "      ___   "
    "     /\\  \\  "
    "     \\:\\  \\ "
    "     /::\\__\\"
    "  __/:/\\/__/"
    " /\\/:/  /   "
    " \\::/__/    "
    "  \\:\\__\\    "
    "   \\/__/    "
    "            "],
   :i 73,
   :character "i",
   :width 12,
   :height 11},
  "j"
  {:bands
   ["       ___   "
    "      /\\  \\  "
    "      \\:\\  \\ "
    "  ___ /::\\__\\"
    " /\\  /:/\\/__/"
    " \\:\\/:/  /   "
    "  \\::/  /    "
    "   \\/__/     "
    "             "
    "             "
    "             "],
   :i 74,
   :character "j",
   :width 13,
   :height 11},
  "k"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/__/     "
    "  /::\\__\\____ "
    " /:/\\:::::\\__\\"
    " \\/_|:|~~|~   "
    "    |:|  |    "
    "    |:|  |    "
    "    |:|  |    "
    "     \\|__|    "],
   :i 75,
   :character "k",
   :width 14,
   :height 11},
  "l"
  {:bands
   ["      ___ "
    "     /\\__\\"
    "    /:/  /"
    "   /:/  / "
    "  /:/  /  "
    " /:/__/   "
    " \\:\\  \\   "
    "  \\:\\  \\  "
    "   \\:\\  \\ "
    "    \\:\\__\\"
    "     \\/__/"],
   :i 76,
   :character "l",
   :width 10,
   :height 11},
  "m"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /::|  |   "
    "   /:|:|  |   "
    "  /:/|:|__|__ "
    " /:/ |::::\\__\\"
    " \\/__/~~/:/  /"
    "       /:/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 77,
   :character "m",
   :width 14,
   :height 11},
  "n"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /::|  |   "
    "   /:|:|  |   "
    "  /:/|:|  |__ "
    " /:/ |:| /\\__\\"
    " \\/__|:|/:/  /"
    "     |:/:/  / "
    "     |::/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 78,
   :character "n",
   :width 14,
   :height 11},
  "o"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /:/  \\:\\  \\ "
    " /:/__/ \\:\\__\\"
    " \\:\\  \\ /:/  /"
    "  \\:\\  /:/  / "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 79,
   :character "o",
   :width 14,
   :height 11},
  "p"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/__\\:\\/:/  /"
    "      \\::/  / "
    "       \\/__/  "
    "              "
    "              "],
   :i 80,
   :character "p",
   :width 14,
   :height 11},
  "q"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "   \\:\\~\\:\\  \\ "
    "    \\:\\ \\:\\__\\"
    "     \\:\\/:/  /"
    "      \\::/  / "
    "      /:/  /  "
    "     /:/  /   "
    "     \\/__/    "],
   :i 81,
   :character "q",
   :width 14,
   :height 11},
  "r"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\:\\  \\  "
    "  /::\\~\\:\\  \\ "
    " /:/\\:\\ \\:\\__\\"
    " \\/_|::\\/:/  /"
    "    |:|::/  / "
    "    |:|\\/__/  "
    "    |:|  |    "
    "     \\|__|    "],
   :i 82,
   :character "r",
   :width 14,
   :height 11},
  "s"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "    /::\\  \\   "
    "   /:/\\ \\  \\  "
    "  _\\:\\~\\ \\  \\ "
    " /\\ \\:\\ \\ \\__\\"
    " \\:\\ \\:\\ \\/__/"
    "  \\:\\ \\:\\__\\  "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 83,
   :character "s",
   :width 14,
   :height 11},
  "t"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "     \\:\\  \\   "
    "      \\:\\  \\  "
    "      /::\\  \\ "
    "     /:/\\:\\__\\"
    "    /:/  \\/__/"
    "   /:/  /     "
    "   \\/__/      "
    "              "
    "              "],
   :i 84,
   :character "t",
   :width 14,
   :height 11},
  "u"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/  /     "
    "  /:/  /  ___ "
    " /:/__/  /\\__\\"
    " \\:\\  \\ /:/  /"
    "  \\:\\  /:/  / "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 85,
   :character "u",
   :width 14,
   :height 11},
  "v"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/  /    "
    "   /:/  /     "
    "  /:/__/  ___ "
    "  |:|  | /\\__\\"
    "  |:|  |/:/  /"
    "  |:|__/:/  / "
    "   \\::::/__/  "
    "    ‾‾‾‾      "
    "              "],
   :i 86,
   :character "v",
   :width 14,
   :height 11},
  "w"
  {:bands
   ["      ___     "
    "     /\\__\\    "
    "    /:/ _/_   "
    "   /:/ /\\__\\  "
    "  /:/ /:/ _/_ "
    " /:/_/:/ /\\__\\"
    " \\:\\/:/ /:/  /"
    "  \\::/_/:/  / "
    "   \\:\\/:/  /  "
    "    \\::/  /   "
    "     \\/__/    "],
   :i 87,
   :character "w",
   :width 14,
   :height 11},
  "x"
  {:bands
   ["      ___     "
    "     |\\__\\    "
    "     |:|  |   "
    "     |:|  |   "
    "     |:|__|__ "
    " ____/::::\\__\\"
    " \\::::/~~/~   "
    "  ~~|:|~~|    "
    "    |:|  |    "
    "    |:|  |    "
    "     \\|__|    "],
   :i 88,
   :character "x",
   :width 14,
   :height 11},
  "y"
  {:bands
   ["      ___     "
    "     |\\__\\    "
    "     |:|  |   "
    "     |:|  |   "
    "     |:|__|__ "
    "     /::::\\__\\"
    "    /:/~~/~   "
    "   /:/  /     "
    "   \\/__/      "
    "              "
    "              "],
   :i 89,
   :character "y",
   :width 14,
   :height 11},
  "z"
  {:bands
   ["      ___     "
    "     /\\  \\    "
    "     \\:\\  \\   "
    "      \\:\\  \\  "
    "       \\:\\  \\ "
    " _______\\:\\__\\"
    " \\::::::::/__/"
    "  \\:\\~~\\~~    "
    "   \\:\\  \\     "
    "    \\:\\__\\    "
    "     \\/__/    "],
   :i 90,
   :character "z",
   :width 14,
   :height 11},
  "{"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   {   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 91,
   :character "{",
   :width 0,
   :height 11,
   :missing? true},
  "|"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   |   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 92,
   :character "|",
   :width 0,
   :height 11,
   :missing? true},
  "}"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   }   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 93,
   :character "}",
   :width 0,
   :height 11,
   :missing? true},
  "~"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ~   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 94,
   :character "~",
   :width 0,
   :height 11,
   :missing? true},
  "Ä"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   Ä   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 95,
   :character "Ä",
   :width 0,
   :height 11,
   :missing? true},
  "Ö"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   Ö   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 96,
   :character "Ö",
   :width 0,
   :height 11,
   :missing? true},
  "Ü"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   Ü   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 97,
   :character "Ü",
   :width 0,
   :height 11,
   :missing? true},
  "ä"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ä   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 98,
   :character "ä",
   :width 0,
   :height 11,
   :missing? true},
  "ö"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ö   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 99,
   :character "ö",
   :width 0,
   :height 11,
   :missing? true},
  "ü"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ü   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 100,
   :character "ü",
   :width 0,
   :height 11,
   :missing? true},
  "ß"
  {:bands
   ["       "
    "       "
    "       "
    "       "
    "   ß   "
    "       "
    "       "
    "       "
    "       "
    "       "
    "       "],
   :i 101,
   :character "ß",
   :width 0,
   :height 11,
   :missing? true}}})